package peering

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"encoding/json"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/to"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// The package's fully qualified name.
const fqdn = "github.com/Azure/azure-sdk-for-go/services/preview/peering/mgmt/2019-08-01-preview/peering"

// BandwidthOffer the properties that define a peering bandwidth offer.
type BandwidthOffer struct {
	// OfferName - The name of the bandwidth offer.
	OfferName *string `json:"offerName,omitempty"`
	// ValueInMbps - The value of the bandwidth offer in Mbps.
	ValueInMbps *int32 `json:"valueInMbps,omitempty"`
}

// BgpSession the properties that define a BGP session.
type BgpSession struct {
	// SessionPrefixV4 - The IPv4 prefix that contains both ends' IPv4 addresses.
	SessionPrefixV4 *string `json:"sessionPrefixV4,omitempty"`
	// SessionPrefixV6 - The IPv6 prefix that contains both ends' IPv6 addresses.
	SessionPrefixV6 *string `json:"sessionPrefixV6,omitempty"`
	// MicrosoftSessionIPv4Address - READ-ONLY; The IPv4 session address on Microsoft's end.
	MicrosoftSessionIPv4Address *string `json:"microsoftSessionIPv4Address,omitempty"`
	// MicrosoftSessionIPv6Address - READ-ONLY; The IPv6 session address on Microsoft's end.
	MicrosoftSessionIPv6Address *string `json:"microsoftSessionIPv6Address,omitempty"`
	// PeerSessionIPv4Address - The IPv4 session address on peer's end.
	PeerSessionIPv4Address *string `json:"peerSessionIPv4Address,omitempty"`
	// PeerSessionIPv6Address - The IPv6 session address on peer's end.
	PeerSessionIPv6Address *string `json:"peerSessionIPv6Address,omitempty"`
	// SessionStateV4 - READ-ONLY; The state of the IPv4 session. Possible values include: 'SessionStateV4None', 'SessionStateV4Idle', 'SessionStateV4Connect', 'SessionStateV4Active', 'SessionStateV4OpenSent', 'SessionStateV4OpenConfirm', 'SessionStateV4OpenReceived', 'SessionStateV4Established', 'SessionStateV4PendingAdd', 'SessionStateV4PendingUpdate', 'SessionStateV4PendingRemove'
	SessionStateV4 SessionStateV4 `json:"sessionStateV4,omitempty"`
	// SessionStateV6 - READ-ONLY; The state of the IPv6 session. Possible values include: 'SessionStateV6None', 'SessionStateV6Idle', 'SessionStateV6Connect', 'SessionStateV6Active', 'SessionStateV6OpenSent', 'SessionStateV6OpenConfirm', 'SessionStateV6OpenReceived', 'SessionStateV6Established', 'SessionStateV6PendingAdd', 'SessionStateV6PendingUpdate', 'SessionStateV6PendingRemove'
	SessionStateV6 SessionStateV6 `json:"sessionStateV6,omitempty"`
	// MaxPrefixesAdvertisedV4 - The maximum number of prefixes advertised over the IPv4 session.
	MaxPrefixesAdvertisedV4 *int32 `json:"maxPrefixesAdvertisedV4,omitempty"`
	// MaxPrefixesAdvertisedV6 - The maximum number of prefixes advertised over the IPv6 session.
	MaxPrefixesAdvertisedV6 *int32 `json:"maxPrefixesAdvertisedV6,omitempty"`
	// Md5AuthenticationKey - The MD5 authentication key of the session.
	Md5AuthenticationKey *string `json:"md5AuthenticationKey,omitempty"`
}

// MarshalJSON is the custom marshaler for BgpSession.
func (bs BgpSession) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if bs.SessionPrefixV4 != nil {
		objectMap["sessionPrefixV4"] = bs.SessionPrefixV4
	}
	if bs.SessionPrefixV6 != nil {
		objectMap["sessionPrefixV6"] = bs.SessionPrefixV6
	}
	if bs.PeerSessionIPv4Address != nil {
		objectMap["peerSessionIPv4Address"] = bs.PeerSessionIPv4Address
	}
	if bs.PeerSessionIPv6Address != nil {
		objectMap["peerSessionIPv6Address"] = bs.PeerSessionIPv6Address
	}
	if bs.MaxPrefixesAdvertisedV4 != nil {
		objectMap["maxPrefixesAdvertisedV4"] = bs.MaxPrefixesAdvertisedV4
	}
	if bs.MaxPrefixesAdvertisedV6 != nil {
		objectMap["maxPrefixesAdvertisedV6"] = bs.MaxPrefixesAdvertisedV6
	}
	if bs.Md5AuthenticationKey != nil {
		objectMap["md5AuthenticationKey"] = bs.Md5AuthenticationKey
	}
	return json.Marshal(objectMap)
}

// CheckServiceProviderAvailabilityInput class for CheckServiceProviderAvailabilityInput
type CheckServiceProviderAvailabilityInput struct {
	// PeeringServiceLocation - Gets or sets the PeeringServiceLocation
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`
	// PeeringServiceProvider - Gets or sets the PeeringServiceProvider
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`
}

// ContactInfo the contact information of the peer.
type ContactInfo struct {
	// Emails - The list of email addresses.
	Emails *[]string `json:"emails,omitempty"`
	// Phone - The list of contact numbers.
	Phone *[]string `json:"phone,omitempty"`
}

// DirectConnection the properties that define a direct connection.
type DirectConnection struct {
	// BandwidthInMbps - The bandwidth of the connection.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// ProvisionedBandwidthInMbps - The bandwidth that is actually provisioned.
	ProvisionedBandwidthInMbps *int32 `json:"provisionedBandwidthInMbps,omitempty"`
	// SessionAddressProvider - The field indicating if Microsoft provides session ip addresses. Possible values include: 'Microsoft', 'Peer'
	SessionAddressProvider SessionAddressProvider `json:"sessionAddressProvider,omitempty"`
	// UseForPeeringService - The flag that indicates whether or not the connection is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// ConnectionState - READ-ONLY; The state of the connection. Possible values include: 'None', 'PendingApproval', 'Approved', 'ProvisioningStarted', 'ProvisioningFailed', 'ProvisioningCompleted', 'Validating', 'Active'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// BgpSession - The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`
	// ConnectionIdentifier - The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for DirectConnection.
func (dc DirectConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if dc.BandwidthInMbps != nil {
		objectMap["bandwidthInMbps"] = dc.BandwidthInMbps
	}
	if dc.ProvisionedBandwidthInMbps != nil {
		objectMap["provisionedBandwidthInMbps"] = dc.ProvisionedBandwidthInMbps
	}
	if dc.SessionAddressProvider != "" {
		objectMap["sessionAddressProvider"] = dc.SessionAddressProvider
	}
	if dc.UseForPeeringService != nil {
		objectMap["useForPeeringService"] = dc.UseForPeeringService
	}
	if dc.PeeringDBFacilityID != nil {
		objectMap["peeringDBFacilityId"] = dc.PeeringDBFacilityID
	}
	if dc.BgpSession != nil {
		objectMap["bgpSession"] = dc.BgpSession
	}
	if dc.ConnectionIdentifier != nil {
		objectMap["connectionIdentifier"] = dc.ConnectionIdentifier
	}
	return json.Marshal(objectMap)
}

// DirectPeeringFacility the properties that define a direct peering facility.
type DirectPeeringFacility struct {
	// Address - The address of the direct peering facility.
	Address *string `json:"address,omitempty"`
	// DirectPeeringType - The type of the direct peering. Possible values include: 'Edge', 'Transit', 'Cdn', 'Internal'
	DirectPeeringType DirectPeeringType `json:"directPeeringType,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// PeeringDBFacilityLink - The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// ErrorResponse the error response that indicates why an operation has failed.
type ErrorResponse struct {
	// Code - READ-ONLY; The error code.
	Code *string `json:"code,omitempty"`
	// Message - READ-ONLY; The error message.
	Message *string `json:"message,omitempty"`
}

// ExchangeConnection the properties that define an exchange connection.
type ExchangeConnection struct {
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility at which the connection has to be set up.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// ConnectionState - READ-ONLY; The state of the connection. Possible values include: 'None', 'PendingApproval', 'Approved', 'ProvisioningStarted', 'ProvisioningFailed', 'ProvisioningCompleted', 'Validating', 'Active'
	ConnectionState ConnectionState `json:"connectionState,omitempty"`
	// BgpSession - The BGP session associated with the connection.
	BgpSession *BgpSession `json:"bgpSession,omitempty"`
	// ConnectionIdentifier - The unique identifier (GUID) for the connection.
	ConnectionIdentifier *string `json:"connectionIdentifier,omitempty"`
}

// MarshalJSON is the custom marshaler for ExchangeConnection.
func (ec ExchangeConnection) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if ec.PeeringDBFacilityID != nil {
		objectMap["peeringDBFacilityId"] = ec.PeeringDBFacilityID
	}
	if ec.BgpSession != nil {
		objectMap["bgpSession"] = ec.BgpSession
	}
	if ec.ConnectionIdentifier != nil {
		objectMap["connectionIdentifier"] = ec.ConnectionIdentifier
	}
	return json.Marshal(objectMap)
}

// ExchangePeeringFacility the properties that define an exchange peering facility.
type ExchangePeeringFacility struct {
	// ExchangeName - The name of the exchange peering facility.
	ExchangeName *string `json:"exchangeName,omitempty"`
	// BandwidthInMbps - The bandwidth of the connection between Microsoft and the exchange peering facility.
	BandwidthInMbps *int32 `json:"bandwidthInMbps,omitempty"`
	// MicrosoftIPv4Address - The IPv4 address of Microsoft at the exchange peering facility.
	MicrosoftIPv4Address *string `json:"microsoftIPv4Address,omitempty"`
	// MicrosoftIPv6Address - The IPv6 address of Microsoft at the exchange peering facility.
	MicrosoftIPv6Address *string `json:"microsoftIPv6Address,omitempty"`
	// FacilityIPv4Prefix - The IPv4 prefixes associated with the exchange peering facility.
	FacilityIPv4Prefix *string `json:"facilityIPv4Prefix,omitempty"`
	// FacilityIPv6Prefix - The IPv6 prefixes associated with the exchange peering facility.
	FacilityIPv6Prefix *string `json:"facilityIPv6Prefix,omitempty"`
	// PeeringDBFacilityID - The PeeringDB.com ID of the facility.
	PeeringDBFacilityID *int32 `json:"peeringDBFacilityId,omitempty"`
	// PeeringDBFacilityLink - The PeeringDB.com URL of the facility.
	PeeringDBFacilityLink *string `json:"peeringDBFacilityLink,omitempty"`
}

// ListResult the paginated list of peerings.
type ListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peerings.
	Value *[]Model `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peerings.
	NextLink *string `json:"nextLink,omitempty"`
}

// ListResultIterator provides access to a complete listing of Model values.
type ListResultIterator struct {
	i    int
	page ListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ListResultIterator) Response() ListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ListResultIterator) Value() Model {
	if !iter.page.NotDone() {
		return Model{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ListResultIterator type.
func NewListResultIterator(page ListResultPage) ListResultIterator {
	return ListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (lr ListResult) IsEmpty() bool {
	return lr.Value == nil || len(*lr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (lr ListResult) hasNextLink() bool {
	return lr.NextLink != nil && len(*lr.NextLink) != 0
}

// listResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (lr ListResult) listResultPreparer(ctx context.Context) (*http.Request, error) {
	if !lr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(lr.NextLink)))
}

// ListResultPage contains a page of Model values.
type ListResultPage struct {
	fn func(context.Context, ListResult) (ListResult, error)
	lr ListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.lr)
		if err != nil {
			return err
		}
		page.lr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ListResultPage) NotDone() bool {
	return !page.lr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ListResultPage) Response() ListResult {
	return page.lr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ListResultPage) Values() []Model {
	if page.lr.IsEmpty() {
		return nil
	}
	return *page.lr.Value
}

// Creates a new instance of the ListResultPage type.
func NewListResultPage(cur ListResult, getNextPage func(context.Context, ListResult) (ListResult, error)) ListResultPage {
	return ListResultPage{
		fn: getNextPage,
		lr: cur,
	}
}

// Location peering location is where connectivity could be established to the Microsoft Cloud Edge.
type Location struct {
	// Kind - The kind of peering that the peering location supports. Possible values include: 'KindDirect', 'KindExchange'
	Kind Kind `json:"kind,omitempty"`
	// LocationProperties - The properties that define a peering location.
	*LocationProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Location.
func (l Location) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if l.Kind != "" {
		objectMap["kind"] = l.Kind
	}
	if l.LocationProperties != nil {
		objectMap["properties"] = l.LocationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Location struct.
func (l *Location) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				l.Kind = kind
			}
		case "properties":
			if v != nil {
				var locationProperties LocationProperties
				err = json.Unmarshal(*v, &locationProperties)
				if err != nil {
					return err
				}
				l.LocationProperties = &locationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				l.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				l.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				l.Type = &typeVar
			}
		}
	}

	return nil
}

// LocationListResult the paginated list of peering locations.
type LocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering locations.
	Value *[]Location `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// LocationListResultIterator provides access to a complete listing of Location values.
type LocationListResultIterator struct {
	i    int
	page LocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *LocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *LocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter LocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter LocationListResultIterator) Response() LocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter LocationListResultIterator) Value() Location {
	if !iter.page.NotDone() {
		return Location{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the LocationListResultIterator type.
func NewLocationListResultIterator(page LocationListResultPage) LocationListResultIterator {
	return LocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (llr LocationListResult) IsEmpty() bool {
	return llr.Value == nil || len(*llr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (llr LocationListResult) hasNextLink() bool {
	return llr.NextLink != nil && len(*llr.NextLink) != 0
}

// locationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (llr LocationListResult) locationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !llr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(llr.NextLink)))
}

// LocationListResultPage contains a page of Location values.
type LocationListResultPage struct {
	fn  func(context.Context, LocationListResult) (LocationListResult, error)
	llr LocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *LocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/LocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.llr)
		if err != nil {
			return err
		}
		page.llr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *LocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page LocationListResultPage) NotDone() bool {
	return !page.llr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page LocationListResultPage) Response() LocationListResult {
	return page.llr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page LocationListResultPage) Values() []Location {
	if page.llr.IsEmpty() {
		return nil
	}
	return *page.llr.Value
}

// Creates a new instance of the LocationListResultPage type.
func NewLocationListResultPage(cur LocationListResult, getNextPage func(context.Context, LocationListResult) (LocationListResult, error)) LocationListResultPage {
	return LocationListResultPage{
		fn:  getNextPage,
		llr: cur,
	}
}

// LocationProperties the properties that define a peering location.
type LocationProperties struct {
	// Direct - The properties that define a direct peering location.
	Direct *LocationPropertiesDirect `json:"direct,omitempty"`
	// Exchange - The properties that define an exchange peering location.
	Exchange *LocationPropertiesExchange `json:"exchange,omitempty"`
	// PeeringLocation - The name of the peering location.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// Country - The country in which the peering location exists.
	Country *string `json:"country,omitempty"`
	// AzureRegion - The Azure region associated with the peering location.
	AzureRegion *string `json:"azureRegion,omitempty"`
}

// LocationPropertiesDirect the properties that define a direct peering location.
type LocationPropertiesDirect struct {
	// PeeringFacilities - The list of direct peering facilities at the peering location.
	PeeringFacilities *[]DirectPeeringFacility `json:"peeringFacilities,omitempty"`
	// BandwidthOffers - The list of bandwidth offers available at the peering location.
	BandwidthOffers *[]BandwidthOffer `json:"bandwidthOffers,omitempty"`
}

// LocationPropertiesExchange the properties that define an exchange peering location.
type LocationPropertiesExchange struct {
	// PeeringFacilities - The list of exchange peering facilities at the peering location.
	PeeringFacilities *[]ExchangePeeringFacility `json:"peeringFacilities,omitempty"`
}

// Model peering is a logical representation of a set of connections to the Microsoft Cloud Edge at a
// location.
type Model struct {
	autorest.Response `json:"-"`
	// Sku - The SKU that defines the tier and kind of the peering.
	Sku *Sku `json:"sku,omitempty"`
	// Kind - The kind of the peering. Possible values include: 'KindDirect', 'KindExchange'
	Kind Kind `json:"kind,omitempty"`
	// Properties - The properties that define a peering.
	*Properties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Model.
func (mVar Model) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if mVar.Sku != nil {
		objectMap["sku"] = mVar.Sku
	}
	if mVar.Kind != "" {
		objectMap["kind"] = mVar.Kind
	}
	if mVar.Properties != nil {
		objectMap["properties"] = mVar.Properties
	}
	if mVar.Location != nil {
		objectMap["location"] = mVar.Location
	}
	if mVar.Tags != nil {
		objectMap["tags"] = mVar.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Model struct.
func (mVar *Model) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "sku":
			if v != nil {
				var sku Sku
				err = json.Unmarshal(*v, &sku)
				if err != nil {
					return err
				}
				mVar.Sku = &sku
			}
		case "kind":
			if v != nil {
				var kind Kind
				err = json.Unmarshal(*v, &kind)
				if err != nil {
					return err
				}
				mVar.Kind = kind
			}
		case "properties":
			if v != nil {
				var properties Properties
				err = json.Unmarshal(*v, &properties)
				if err != nil {
					return err
				}
				mVar.Properties = &properties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				mVar.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				mVar.Tags = tags
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				mVar.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				mVar.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				mVar.Type = &typeVar
			}
		}
	}

	return nil
}

// Operation the peering API operation.
type Operation struct {
	// Name - READ-ONLY; The name of the operation.
	Name *string `json:"name,omitempty"`
	// Display - READ-ONLY; The information related to the operation.
	Display *OperationDisplayInfo `json:"display,omitempty"`
	// IsDataAction - READ-ONLY; The flag that indicates whether the operation applies to data plane.
	IsDataAction *bool `json:"isDataAction,omitempty"`
}

// OperationDisplayInfo the information related to the operation.
type OperationDisplayInfo struct {
	// Provider - READ-ONLY; The name of the resource provider.
	Provider *string `json:"provider,omitempty"`
	// Resource - READ-ONLY; The type of the resource.
	Resource *string `json:"resource,omitempty"`
	// Operation - READ-ONLY; The name of the operation.
	Operation *string `json:"operation,omitempty"`
	// Description - READ-ONLY; The description of the operation.
	Description *string `json:"description,omitempty"`
}

// OperationListResult the paginated list of peering API operations.
type OperationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering API operations.
	Value *[]Operation `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering API operations.
	NextLink *string `json:"nextLink,omitempty"`
}

// OperationListResultIterator provides access to a complete listing of Operation values.
type OperationListResultIterator struct {
	i    int
	page OperationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *OperationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *OperationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter OperationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter OperationListResultIterator) Response() OperationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter OperationListResultIterator) Value() Operation {
	if !iter.page.NotDone() {
		return Operation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the OperationListResultIterator type.
func NewOperationListResultIterator(page OperationListResultPage) OperationListResultIterator {
	return OperationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (olr OperationListResult) IsEmpty() bool {
	return olr.Value == nil || len(*olr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (olr OperationListResult) hasNextLink() bool {
	return olr.NextLink != nil && len(*olr.NextLink) != 0
}

// operationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (olr OperationListResult) operationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !olr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(olr.NextLink)))
}

// OperationListResultPage contains a page of Operation values.
type OperationListResultPage struct {
	fn  func(context.Context, OperationListResult) (OperationListResult, error)
	olr OperationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *OperationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/OperationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.olr)
		if err != nil {
			return err
		}
		page.olr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *OperationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page OperationListResultPage) NotDone() bool {
	return !page.olr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page OperationListResultPage) Response() OperationListResult {
	return page.olr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page OperationListResultPage) Values() []Operation {
	if page.olr.IsEmpty() {
		return nil
	}
	return *page.olr.Value
}

// Creates a new instance of the OperationListResultPage type.
func NewOperationListResultPage(cur OperationListResult, getNextPage func(context.Context, OperationListResult) (OperationListResult, error)) OperationListResultPage {
	return OperationListResultPage{
		fn:  getNextPage,
		olr: cur,
	}
}

// PeerAsn the essential information related to the peer's ASN.
type PeerAsn struct {
	autorest.Response `json:"-"`
	// PeerAsnProperties - The properties that define a peer's ASN.
	*PeerAsnProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for PeerAsn.
func (pa PeerAsn) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if pa.PeerAsnProperties != nil {
		objectMap["properties"] = pa.PeerAsnProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for PeerAsn struct.
func (pa *PeerAsn) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var peerAsnProperties PeerAsnProperties
				err = json.Unmarshal(*v, &peerAsnProperties)
				if err != nil {
					return err
				}
				pa.PeerAsnProperties = &peerAsnProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				pa.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				pa.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				pa.Type = &typeVar
			}
		}
	}

	return nil
}

// PeerAsnListResult the paginated list of peer ASNs.
type PeerAsnListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peer ASNs.
	Value *[]PeerAsn `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peer ASNs.
	NextLink *string `json:"nextLink,omitempty"`
}

// PeerAsnListResultIterator provides access to a complete listing of PeerAsn values.
type PeerAsnListResultIterator struct {
	i    int
	page PeerAsnListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *PeerAsnListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerAsnListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *PeerAsnListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter PeerAsnListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter PeerAsnListResultIterator) Response() PeerAsnListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter PeerAsnListResultIterator) Value() PeerAsn {
	if !iter.page.NotDone() {
		return PeerAsn{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the PeerAsnListResultIterator type.
func NewPeerAsnListResultIterator(page PeerAsnListResultPage) PeerAsnListResultIterator {
	return PeerAsnListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (palr PeerAsnListResult) IsEmpty() bool {
	return palr.Value == nil || len(*palr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (palr PeerAsnListResult) hasNextLink() bool {
	return palr.NextLink != nil && len(*palr.NextLink) != 0
}

// peerAsnListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (palr PeerAsnListResult) peerAsnListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !palr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(palr.NextLink)))
}

// PeerAsnListResultPage contains a page of PeerAsn values.
type PeerAsnListResultPage struct {
	fn   func(context.Context, PeerAsnListResult) (PeerAsnListResult, error)
	palr PeerAsnListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *PeerAsnListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/PeerAsnListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.palr)
		if err != nil {
			return err
		}
		page.palr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *PeerAsnListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page PeerAsnListResultPage) NotDone() bool {
	return !page.palr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page PeerAsnListResultPage) Response() PeerAsnListResult {
	return page.palr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page PeerAsnListResultPage) Values() []PeerAsn {
	if page.palr.IsEmpty() {
		return nil
	}
	return *page.palr.Value
}

// Creates a new instance of the PeerAsnListResultPage type.
func NewPeerAsnListResultPage(cur PeerAsnListResult, getNextPage func(context.Context, PeerAsnListResult) (PeerAsnListResult, error)) PeerAsnListResultPage {
	return PeerAsnListResultPage{
		fn:   getNextPage,
		palr: cur,
	}
}

// PeerAsnProperties the properties that define a peer's ASN.
type PeerAsnProperties struct {
	// PeerAsn - The Autonomous System Number (ASN) of the peer.
	PeerAsn *int32 `json:"peerAsn,omitempty"`
	// PeerContactInfo - The contact information of the peer.
	PeerContactInfo *ContactInfo `json:"peerContactInfo,omitempty"`
	// PeerName - The name of the peer.
	PeerName *string `json:"peerName,omitempty"`
	// ValidationState - The validation state of the ASN associated with the peer. Possible values include: 'ValidationStateNone', 'ValidationStatePending', 'ValidationStateApproved', 'ValidationStateFailed'
	ValidationState ValidationState `json:"validationState,omitempty"`
}

// Properties the properties that define connectivity to the Microsoft Cloud Edge.
type Properties struct {
	// Direct - The properties that define a direct peering.
	Direct *PropertiesDirect `json:"direct,omitempty"`
	// Exchange - The properties that define an exchange peering.
	Exchange *PropertiesExchange `json:"exchange,omitempty"`
	// PeeringLocation - The location of the peering.
	PeeringLocation *string `json:"peeringLocation,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for Properties.
func (p Properties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if p.Direct != nil {
		objectMap["direct"] = p.Direct
	}
	if p.Exchange != nil {
		objectMap["exchange"] = p.Exchange
	}
	if p.PeeringLocation != nil {
		objectMap["peeringLocation"] = p.PeeringLocation
	}
	return json.Marshal(objectMap)
}

// PropertiesDirect the properties that define a direct peering.
type PropertiesDirect struct {
	// Connections - The set of connections that constitute a direct peering.
	Connections *[]DirectConnection `json:"connections,omitempty"`
	// UseForPeeringService - The flag that indicates whether or not the peering is used for peering service.
	UseForPeeringService *bool `json:"useForPeeringService,omitempty"`
	// PeerAsn - The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`
	// DirectPeeringType - The type of direct peering. Possible values include: 'Edge', 'Transit', 'Cdn', 'Internal'
	DirectPeeringType DirectPeeringType `json:"directPeeringType,omitempty"`
}

// PropertiesExchange the properties that define an exchange peering.
type PropertiesExchange struct {
	// Connections - The set of connections that constitute an exchange peering.
	Connections *[]ExchangeConnection `json:"connections,omitempty"`
	// PeerAsn - The reference of the peer ASN.
	PeerAsn *SubResource `json:"peerAsn,omitempty"`
}

// Resource the ARM resource class.
type Resource struct {
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// ResourceTags the resource tags.
type ResourceTags struct {
	// Tags - Gets or sets the tags, a dictionary of descriptors arm object
	Tags map[string]*string `json:"tags"`
}

// MarshalJSON is the custom marshaler for ResourceTags.
func (rt ResourceTags) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if rt.Tags != nil {
		objectMap["tags"] = rt.Tags
	}
	return json.Marshal(objectMap)
}

// Service peering Service
type Service struct {
	autorest.Response `json:"-"`
	// ServiceProperties - The properties that define a peering service.
	*ServiceProperties `json:"properties,omitempty"`
	// Location - The location of the resource.
	Location *string `json:"location,omitempty"`
	// Tags - The resource tags.
	Tags map[string]*string `json:"tags"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for Service.
func (s Service) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if s.ServiceProperties != nil {
		objectMap["properties"] = s.ServiceProperties
	}
	if s.Location != nil {
		objectMap["location"] = s.Location
	}
	if s.Tags != nil {
		objectMap["tags"] = s.Tags
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for Service struct.
func (s *Service) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProperties ServiceProperties
				err = json.Unmarshal(*v, &serviceProperties)
				if err != nil {
					return err
				}
				s.ServiceProperties = &serviceProperties
			}
		case "location":
			if v != nil {
				var location string
				err = json.Unmarshal(*v, &location)
				if err != nil {
					return err
				}
				s.Location = &location
			}
		case "tags":
			if v != nil {
				var tags map[string]*string
				err = json.Unmarshal(*v, &tags)
				if err != nil {
					return err
				}
				s.Tags = tags
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				s.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				s.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				s.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceListResult the paginated list of peering services.
type ServiceListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering services.
	Value *[]Service `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering services.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceListResultIterator provides access to a complete listing of Service values.
type ServiceListResultIterator struct {
	i    int
	page ServiceListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceListResultIterator) Response() ServiceListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceListResultIterator) Value() Service {
	if !iter.page.NotDone() {
		return Service{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceListResultIterator type.
func NewServiceListResultIterator(page ServiceListResultPage) ServiceListResultIterator {
	return ServiceListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (slr ServiceListResult) IsEmpty() bool {
	return slr.Value == nil || len(*slr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (slr ServiceListResult) hasNextLink() bool {
	return slr.NextLink != nil && len(*slr.NextLink) != 0
}

// serviceListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (slr ServiceListResult) serviceListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !slr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(slr.NextLink)))
}

// ServiceListResultPage contains a page of Service values.
type ServiceListResultPage struct {
	fn  func(context.Context, ServiceListResult) (ServiceListResult, error)
	slr ServiceListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.slr)
		if err != nil {
			return err
		}
		page.slr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceListResultPage) NotDone() bool {
	return !page.slr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceListResultPage) Response() ServiceListResult {
	return page.slr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceListResultPage) Values() []Service {
	if page.slr.IsEmpty() {
		return nil
	}
	return *page.slr.Value
}

// Creates a new instance of the ServiceListResultPage type.
func NewServiceListResultPage(cur ServiceListResult, getNextPage func(context.Context, ServiceListResult) (ServiceListResult, error)) ServiceListResultPage {
	return ServiceListResultPage{
		fn:  getNextPage,
		slr: cur,
	}
}

// ServiceLocation peeringService location
type ServiceLocation struct {
	// ServiceLocationProperties - The properties that define a peering service location.
	*ServiceLocationProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceLocation.
func (sl ServiceLocation) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sl.ServiceLocationProperties != nil {
		objectMap["properties"] = sl.ServiceLocationProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceLocation struct.
func (sl *ServiceLocation) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceLocationProperties ServiceLocationProperties
				err = json.Unmarshal(*v, &serviceLocationProperties)
				if err != nil {
					return err
				}
				sl.ServiceLocationProperties = &serviceLocationProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sl.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sl.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sl.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceLocationListResult the paginated list of peering service locations.
type ServiceLocationListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service locations.
	Value *[]ServiceLocation `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service locations.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceLocationListResultIterator provides access to a complete listing of ServiceLocation values.
type ServiceLocationListResultIterator struct {
	i    int
	page ServiceLocationListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceLocationListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceLocationListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceLocationListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceLocationListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceLocationListResultIterator) Response() ServiceLocationListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceLocationListResultIterator) Value() ServiceLocation {
	if !iter.page.NotDone() {
		return ServiceLocation{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceLocationListResultIterator type.
func NewServiceLocationListResultIterator(page ServiceLocationListResultPage) ServiceLocationListResultIterator {
	return ServiceLocationListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (sllr ServiceLocationListResult) IsEmpty() bool {
	return sllr.Value == nil || len(*sllr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (sllr ServiceLocationListResult) hasNextLink() bool {
	return sllr.NextLink != nil && len(*sllr.NextLink) != 0
}

// serviceLocationListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (sllr ServiceLocationListResult) serviceLocationListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !sllr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(sllr.NextLink)))
}

// ServiceLocationListResultPage contains a page of ServiceLocation values.
type ServiceLocationListResultPage struct {
	fn   func(context.Context, ServiceLocationListResult) (ServiceLocationListResult, error)
	sllr ServiceLocationListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceLocationListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceLocationListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.sllr)
		if err != nil {
			return err
		}
		page.sllr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceLocationListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceLocationListResultPage) NotDone() bool {
	return !page.sllr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceLocationListResultPage) Response() ServiceLocationListResult {
	return page.sllr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceLocationListResultPage) Values() []ServiceLocation {
	if page.sllr.IsEmpty() {
		return nil
	}
	return *page.sllr.Value
}

// Creates a new instance of the ServiceLocationListResultPage type.
func NewServiceLocationListResultPage(cur ServiceLocationListResult, getNextPage func(context.Context, ServiceLocationListResult) (ServiceLocationListResult, error)) ServiceLocationListResultPage {
	return ServiceLocationListResultPage{
		fn:   getNextPage,
		sllr: cur,
	}
}

// ServiceLocationProperties the properties that define connectivity to the Peering Service Location.
type ServiceLocationProperties struct {
	// Country - Country of the customer
	Country *string `json:"country,omitempty"`
	// State - State of the customer
	State *string `json:"state,omitempty"`
	// AzureRegion - Azure region for the location
	AzureRegion *string `json:"azureRegion,omitempty"`
}

// ServicePrefix the peering service prefix class.
type ServicePrefix struct {
	autorest.Response `json:"-"`
	// ServicePrefixProperties - Gets or sets the peering prefix properties.
	*ServicePrefixProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrefix.
func (sp ServicePrefix) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ServicePrefixProperties != nil {
		objectMap["properties"] = sp.ServicePrefixProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServicePrefix struct.
func (sp *ServicePrefix) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var servicePrefixProperties ServicePrefixProperties
				err = json.Unmarshal(*v, &servicePrefixProperties)
				if err != nil {
					return err
				}
				sp.ServicePrefixProperties = &servicePrefixProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServicePrefixListResult the paginated list of [T].
type ServicePrefixListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of [T].
	Value *[]ServicePrefix `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of [T].
	NextLink *string `json:"nextLink,omitempty"`
}

// ServicePrefixListResultIterator provides access to a complete listing of ServicePrefix values.
type ServicePrefixListResultIterator struct {
	i    int
	page ServicePrefixListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServicePrefixListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrefixListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServicePrefixListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServicePrefixListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServicePrefixListResultIterator) Response() ServicePrefixListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServicePrefixListResultIterator) Value() ServicePrefix {
	if !iter.page.NotDone() {
		return ServicePrefix{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServicePrefixListResultIterator type.
func NewServicePrefixListResultIterator(page ServicePrefixListResultPage) ServicePrefixListResultIterator {
	return ServicePrefixListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServicePrefixListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (splr ServicePrefixListResult) hasNextLink() bool {
	return splr.NextLink != nil && len(*splr.NextLink) != 0
}

// servicePrefixListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splr ServicePrefixListResult) servicePrefixListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !splr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splr.NextLink)))
}

// ServicePrefixListResultPage contains a page of ServicePrefix values.
type ServicePrefixListResultPage struct {
	fn   func(context.Context, ServicePrefixListResult) (ServicePrefixListResult, error)
	splr ServicePrefixListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServicePrefixListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServicePrefixListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.splr)
		if err != nil {
			return err
		}
		page.splr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServicePrefixListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServicePrefixListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServicePrefixListResultPage) Response() ServicePrefixListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServicePrefixListResultPage) Values() []ServicePrefix {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the ServicePrefixListResultPage type.
func NewServicePrefixListResultPage(cur ServicePrefixListResult, getNextPage func(context.Context, ServicePrefixListResult) (ServicePrefixListResult, error)) ServicePrefixListResultPage {
	return ServicePrefixListResultPage{
		fn:   getNextPage,
		splr: cur,
	}
}

// ServicePrefixProperties the peering service prefix properties class.
type ServicePrefixProperties struct {
	// Prefix - Valid route prefix
	Prefix *string `json:"prefix,omitempty"`
	// PrefixValidationState - The prefix validation state. Possible values include: 'PrefixValidationStateNone', 'PrefixValidationStateInvalid', 'PrefixValidationStateVerified', 'PrefixValidationStateFailed', 'PrefixValidationStatePending', 'PrefixValidationStateUnknown'
	PrefixValidationState PrefixValidationState `json:"prefixValidationState,omitempty"`
	// LearnedType - The prefix learned type. Possible values include: 'LearnedTypeNone', 'LearnedTypeViaPartner', 'LearnedTypeViaSession'
	LearnedType LearnedType `json:"learnedType,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServicePrefixProperties.
func (spp ServicePrefixProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if spp.Prefix != nil {
		objectMap["prefix"] = spp.Prefix
	}
	if spp.PrefixValidationState != "" {
		objectMap["prefixValidationState"] = spp.PrefixValidationState
	}
	if spp.LearnedType != "" {
		objectMap["learnedType"] = spp.LearnedType
	}
	return json.Marshal(objectMap)
}

// ServiceProperties the properties that define connectivity to the Peering Service.
type ServiceProperties struct {
	// PeeringServiceLocation - The PeeringServiceLocation of the Customer.
	PeeringServiceLocation *string `json:"peeringServiceLocation,omitempty"`
	// PeeringServiceProvider - The MAPS Provider Name.
	PeeringServiceProvider *string `json:"peeringServiceProvider,omitempty"`
	// ProvisioningState - READ-ONLY; The provisioning state of the resource. Possible values include: 'Succeeded', 'Updating', 'Deleting', 'Failed'
	ProvisioningState ProvisioningState `json:"provisioningState,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProperties.
func (sp ServiceProperties) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.PeeringServiceLocation != nil {
		objectMap["peeringServiceLocation"] = sp.PeeringServiceLocation
	}
	if sp.PeeringServiceProvider != nil {
		objectMap["peeringServiceProvider"] = sp.PeeringServiceProvider
	}
	return json.Marshal(objectMap)
}

// ServiceProvider peeringService provider
type ServiceProvider struct {
	// ServiceProviderProperties - The properties that define a peering service provider.
	*ServiceProviderProperties `json:"properties,omitempty"`
	// Name - READ-ONLY; The name of the resource.
	Name *string `json:"name,omitempty"`
	// ID - READ-ONLY; The ID of the resource.
	ID *string `json:"id,omitempty"`
	// Type - READ-ONLY; The type of the resource.
	Type *string `json:"type,omitempty"`
}

// MarshalJSON is the custom marshaler for ServiceProvider.
func (sp ServiceProvider) MarshalJSON() ([]byte, error) {
	objectMap := make(map[string]interface{})
	if sp.ServiceProviderProperties != nil {
		objectMap["properties"] = sp.ServiceProviderProperties
	}
	return json.Marshal(objectMap)
}

// UnmarshalJSON is the custom unmarshaler for ServiceProvider struct.
func (sp *ServiceProvider) UnmarshalJSON(body []byte) error {
	var m map[string]*json.RawMessage
	err := json.Unmarshal(body, &m)
	if err != nil {
		return err
	}
	for k, v := range m {
		switch k {
		case "properties":
			if v != nil {
				var serviceProviderProperties ServiceProviderProperties
				err = json.Unmarshal(*v, &serviceProviderProperties)
				if err != nil {
					return err
				}
				sp.ServiceProviderProperties = &serviceProviderProperties
			}
		case "name":
			if v != nil {
				var name string
				err = json.Unmarshal(*v, &name)
				if err != nil {
					return err
				}
				sp.Name = &name
			}
		case "id":
			if v != nil {
				var ID string
				err = json.Unmarshal(*v, &ID)
				if err != nil {
					return err
				}
				sp.ID = &ID
			}
		case "type":
			if v != nil {
				var typeVar string
				err = json.Unmarshal(*v, &typeVar)
				if err != nil {
					return err
				}
				sp.Type = &typeVar
			}
		}
	}

	return nil
}

// ServiceProviderListResult the paginated list of peering service providers.
type ServiceProviderListResult struct {
	autorest.Response `json:"-"`
	// Value - The list of peering service providers.
	Value *[]ServiceProvider `json:"value,omitempty"`
	// NextLink - The link to fetch the next page of peering service providers.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServiceProviderListResultIterator provides access to a complete listing of ServiceProvider values.
type ServiceProviderListResultIterator struct {
	i    int
	page ServiceProviderListResultPage
}

// NextWithContext advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
func (iter *ServiceProviderListResultIterator) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceProviderListResultIterator.NextWithContext")
		defer func() {
			sc := -1
			if iter.Response().Response.Response != nil {
				sc = iter.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	iter.i++
	if iter.i < len(iter.page.Values()) {
		return nil
	}
	err = iter.page.NextWithContext(ctx)
	if err != nil {
		iter.i--
		return err
	}
	iter.i = 0
	return nil
}

// Next advances to the next value.  If there was an error making
// the request the iterator does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (iter *ServiceProviderListResultIterator) Next() error {
	return iter.NextWithContext(context.Background())
}

// NotDone returns true if the enumeration should be started or is not yet complete.
func (iter ServiceProviderListResultIterator) NotDone() bool {
	return iter.page.NotDone() && iter.i < len(iter.page.Values())
}

// Response returns the raw server response from the last page request.
func (iter ServiceProviderListResultIterator) Response() ServiceProviderListResult {
	return iter.page.Response()
}

// Value returns the current value or a zero-initialized value if the
// iterator has advanced beyond the end of the collection.
func (iter ServiceProviderListResultIterator) Value() ServiceProvider {
	if !iter.page.NotDone() {
		return ServiceProvider{}
	}
	return iter.page.Values()[iter.i]
}

// Creates a new instance of the ServiceProviderListResultIterator type.
func NewServiceProviderListResultIterator(page ServiceProviderListResultPage) ServiceProviderListResultIterator {
	return ServiceProviderListResultIterator{page: page}
}

// IsEmpty returns true if the ListResult contains no values.
func (splr ServiceProviderListResult) IsEmpty() bool {
	return splr.Value == nil || len(*splr.Value) == 0
}

// hasNextLink returns true if the NextLink is not empty.
func (splr ServiceProviderListResult) hasNextLink() bool {
	return splr.NextLink != nil && len(*splr.NextLink) != 0
}

// serviceProviderListResultPreparer prepares a request to retrieve the next set of results.
// It returns nil if no more results exist.
func (splr ServiceProviderListResult) serviceProviderListResultPreparer(ctx context.Context) (*http.Request, error) {
	if !splr.hasNextLink() {
		return nil, nil
	}
	return autorest.Prepare((&http.Request{}).WithContext(ctx),
		autorest.AsJSON(),
		autorest.AsGet(),
		autorest.WithBaseURL(to.String(splr.NextLink)))
}

// ServiceProviderListResultPage contains a page of ServiceProvider values.
type ServiceProviderListResultPage struct {
	fn   func(context.Context, ServiceProviderListResult) (ServiceProviderListResult, error)
	splr ServiceProviderListResult
}

// NextWithContext advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
func (page *ServiceProviderListResultPage) NextWithContext(ctx context.Context) (err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ServiceProviderListResultPage.NextWithContext")
		defer func() {
			sc := -1
			if page.Response().Response.Response != nil {
				sc = page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	for {
		next, err := page.fn(ctx, page.splr)
		if err != nil {
			return err
		}
		page.splr = next
		if !next.hasNextLink() || !next.IsEmpty() {
			break
		}
	}
	return nil
}

// Next advances to the next page of values.  If there was an error making
// the request the page does not advance and the error is returned.
// Deprecated: Use NextWithContext() instead.
func (page *ServiceProviderListResultPage) Next() error {
	return page.NextWithContext(context.Background())
}

// NotDone returns true if the page enumeration should be started or is not yet complete.
func (page ServiceProviderListResultPage) NotDone() bool {
	return !page.splr.IsEmpty()
}

// Response returns the raw server response from the last page request.
func (page ServiceProviderListResultPage) Response() ServiceProviderListResult {
	return page.splr
}

// Values returns the slice of values for the current page or nil if there are no values.
func (page ServiceProviderListResultPage) Values() []ServiceProvider {
	if page.splr.IsEmpty() {
		return nil
	}
	return *page.splr.Value
}

// Creates a new instance of the ServiceProviderListResultPage type.
func NewServiceProviderListResultPage(cur ServiceProviderListResult, getNextPage func(context.Context, ServiceProviderListResult) (ServiceProviderListResult, error)) ServiceProviderListResultPage {
	return ServiceProviderListResultPage{
		fn:   getNextPage,
		splr: cur,
	}
}

// ServiceProviderProperties the properties that define connectivity to the Peering Service Provider.
type ServiceProviderProperties struct {
	// ServiceProviderName - The name of the service provider.
	ServiceProviderName *string `json:"serviceProviderName,omitempty"`
}

// Sku the SKU that defines the tier and kind of the peering.
type Sku struct {
	// Name - The name of the peering SKU. Possible values include: 'BasicExchangeFree', 'BasicDirectFree', 'PremiumDirectFree', 'PremiumExchangeMetered', 'PremiumDirectMetered', 'PremiumDirectUnlimited'
	Name Name `json:"name,omitempty"`
	// Tier - The tier of the peering SKU. Possible values include: 'Basic', 'Premium'
	Tier Tier `json:"tier,omitempty"`
	// Family - The family of the peering SKU. Possible values include: 'Direct', 'Exchange'
	Family Family `json:"family,omitempty"`
	// Size - The size of the peering SKU. Possible values include: 'Free', 'Metered', 'Unlimited'
	Size Size `json:"size,omitempty"`
}

// String ...
type String struct {
	autorest.Response `json:"-"`
	// Value - Possible values include: 'Available', 'UnAvailable'
	Value *string `json:"value,omitempty"`
}

// SubResource the sub resource.
type SubResource struct {
	// ID - The identifier of the referenced resource.
	ID *string `json:"id,omitempty"`
}
