package storsimple

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AlertEmailNotificationStatus enumerates the values for alert email notification status.
type AlertEmailNotificationStatus string

const (
	// Disabled ...
	Disabled AlertEmailNotificationStatus = "Disabled"
	// Enabled ...
	Enabled AlertEmailNotificationStatus = "Enabled"
)

// PossibleAlertEmailNotificationStatusValues returns an array of possible values for the AlertEmailNotificationStatus const type.
func PossibleAlertEmailNotificationStatusValues() []AlertEmailNotificationStatus {
	return []AlertEmailNotificationStatus{Disabled, Enabled}
}

// AlertScope enumerates the values for alert scope.
type AlertScope string

const (
	// AlertScopeDevice ...
	AlertScopeDevice AlertScope = "Device"
	// AlertScopeResource ...
	AlertScopeResource AlertScope = "Resource"
)

// PossibleAlertScopeValues returns an array of possible values for the AlertScope const type.
func PossibleAlertScopeValues() []AlertScope {
	return []AlertScope{AlertScopeDevice, AlertScopeResource}
}

// AlertSeverity enumerates the values for alert severity.
type AlertSeverity string

const (
	// Critical ...
	Critical AlertSeverity = "Critical"
	// Informational ...
	Informational AlertSeverity = "Informational"
	// Warning ...
	Warning AlertSeverity = "Warning"
)

// PossibleAlertSeverityValues returns an array of possible values for the AlertSeverity const type.
func PossibleAlertSeverityValues() []AlertSeverity {
	return []AlertSeverity{Critical, Informational, Warning}
}

// AlertSourceType enumerates the values for alert source type.
type AlertSourceType string

const (
	// AlertSourceTypeDevice ...
	AlertSourceTypeDevice AlertSourceType = "Device"
	// AlertSourceTypeResource ...
	AlertSourceTypeResource AlertSourceType = "Resource"
)

// PossibleAlertSourceTypeValues returns an array of possible values for the AlertSourceType const type.
func PossibleAlertSourceTypeValues() []AlertSourceType {
	return []AlertSourceType{AlertSourceTypeDevice, AlertSourceTypeResource}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// Active ...
	Active AlertStatus = "Active"
	// Cleared ...
	Cleared AlertStatus = "Cleared"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{Active, Cleared}
}

// AuthenticationType enumerates the values for authentication type.
type AuthenticationType string

const (
	// Basic ...
	Basic AuthenticationType = "Basic"
	// Invalid ...
	Invalid AuthenticationType = "Invalid"
	// None ...
	None AuthenticationType = "None"
	// NTLM ...
	NTLM AuthenticationType = "NTLM"
)

// PossibleAuthenticationTypeValues returns an array of possible values for the AuthenticationType const type.
func PossibleAuthenticationTypeValues() []AuthenticationType {
	return []AuthenticationType{Basic, Invalid, None, NTLM}
}

// AuthorizationEligibility enumerates the values for authorization eligibility.
type AuthorizationEligibility string

const (
	// Eligible ...
	Eligible AuthorizationEligibility = "Eligible"
	// InEligible ...
	InEligible AuthorizationEligibility = "InEligible"
)

// PossibleAuthorizationEligibilityValues returns an array of possible values for the AuthorizationEligibility const type.
func PossibleAuthorizationEligibilityValues() []AuthorizationEligibility {
	return []AuthorizationEligibility{Eligible, InEligible}
}

// AuthorizationStatus enumerates the values for authorization status.
type AuthorizationStatus string

const (
	// AuthorizationStatusDisabled ...
	AuthorizationStatusDisabled AuthorizationStatus = "Disabled"
	// AuthorizationStatusEnabled ...
	AuthorizationStatusEnabled AuthorizationStatus = "Enabled"
)

// PossibleAuthorizationStatusValues returns an array of possible values for the AuthorizationStatus const type.
func PossibleAuthorizationStatusValues() []AuthorizationStatus {
	return []AuthorizationStatus{AuthorizationStatusDisabled, AuthorizationStatusEnabled}
}

// BackupJobCreationType enumerates the values for backup job creation type.
type BackupJobCreationType string

const (
	// Adhoc ...
	Adhoc BackupJobCreationType = "Adhoc"
	// BySchedule ...
	BySchedule BackupJobCreationType = "BySchedule"
	// BySSM ...
	BySSM BackupJobCreationType = "BySSM"
)

// PossibleBackupJobCreationTypeValues returns an array of possible values for the BackupJobCreationType const type.
func PossibleBackupJobCreationTypeValues() []BackupJobCreationType {
	return []BackupJobCreationType{Adhoc, BySchedule, BySSM}
}

// BackupPolicyCreationType enumerates the values for backup policy creation type.
type BackupPolicyCreationType string

const (
	// BackupPolicyCreationTypeBySaaS ...
	BackupPolicyCreationTypeBySaaS BackupPolicyCreationType = "BySaaS"
	// BackupPolicyCreationTypeBySSM ...
	BackupPolicyCreationTypeBySSM BackupPolicyCreationType = "BySSM"
)

// PossibleBackupPolicyCreationTypeValues returns an array of possible values for the BackupPolicyCreationType const type.
func PossibleBackupPolicyCreationTypeValues() []BackupPolicyCreationType {
	return []BackupPolicyCreationType{BackupPolicyCreationTypeBySaaS, BackupPolicyCreationTypeBySSM}
}

// BackupStatus enumerates the values for backup status.
type BackupStatus string

const (
	// BackupStatusDisabled ...
	BackupStatusDisabled BackupStatus = "Disabled"
	// BackupStatusEnabled ...
	BackupStatusEnabled BackupStatus = "Enabled"
)

// PossibleBackupStatusValues returns an array of possible values for the BackupStatus const type.
func PossibleBackupStatusValues() []BackupStatus {
	return []BackupStatus{BackupStatusDisabled, BackupStatusEnabled}
}

// BackupType enumerates the values for backup type.
type BackupType string

const (
	// CloudSnapshot ...
	CloudSnapshot BackupType = "CloudSnapshot"
	// LocalSnapshot ...
	LocalSnapshot BackupType = "LocalSnapshot"
)

// PossibleBackupTypeValues returns an array of possible values for the BackupType const type.
func PossibleBackupTypeValues() []BackupType {
	return []BackupType{CloudSnapshot, LocalSnapshot}
}

// ControllerID enumerates the values for controller id.
type ControllerID string

const (
	// ControllerIDController0 ...
	ControllerIDController0 ControllerID = "Controller0"
	// ControllerIDController1 ...
	ControllerIDController1 ControllerID = "Controller1"
	// ControllerIDNone ...
	ControllerIDNone ControllerID = "None"
	// ControllerIDUnknown ...
	ControllerIDUnknown ControllerID = "Unknown"
)

// PossibleControllerIDValues returns an array of possible values for the ControllerID const type.
func PossibleControllerIDValues() []ControllerID {
	return []ControllerID{ControllerIDController0, ControllerIDController1, ControllerIDNone, ControllerIDUnknown}
}

// ControllerPowerStateAction enumerates the values for controller power state action.
type ControllerPowerStateAction string

const (
	// Restart ...
	Restart ControllerPowerStateAction = "Restart"
	// Shutdown ...
	Shutdown ControllerPowerStateAction = "Shutdown"
	// Start ...
	Start ControllerPowerStateAction = "Start"
)

// PossibleControllerPowerStateActionValues returns an array of possible values for the ControllerPowerStateAction const type.
func PossibleControllerPowerStateActionValues() []ControllerPowerStateAction {
	return []ControllerPowerStateAction{Restart, Shutdown, Start}
}

// ControllerStatus enumerates the values for controller status.
type ControllerStatus string

const (
	// ControllerStatusFailure ...
	ControllerStatusFailure ControllerStatus = "Failure"
	// ControllerStatusNotPresent ...
	ControllerStatusNotPresent ControllerStatus = "NotPresent"
	// ControllerStatusOk ...
	ControllerStatusOk ControllerStatus = "Ok"
	// ControllerStatusPoweredOff ...
	ControllerStatusPoweredOff ControllerStatus = "PoweredOff"
	// ControllerStatusRecovering ...
	ControllerStatusRecovering ControllerStatus = "Recovering"
	// ControllerStatusWarning ...
	ControllerStatusWarning ControllerStatus = "Warning"
)

// PossibleControllerStatusValues returns an array of possible values for the ControllerStatus const type.
func PossibleControllerStatusValues() []ControllerStatus {
	return []ControllerStatus{ControllerStatusFailure, ControllerStatusNotPresent, ControllerStatusOk, ControllerStatusPoweredOff, ControllerStatusRecovering, ControllerStatusWarning}
}

// DayOfWeek enumerates the values for day of week.
type DayOfWeek string

const (
	// Friday ...
	Friday DayOfWeek = "Friday"
	// Monday ...
	Monday DayOfWeek = "Monday"
	// Saturday ...
	Saturday DayOfWeek = "Saturday"
	// Sunday ...
	Sunday DayOfWeek = "Sunday"
	// Thursday ...
	Thursday DayOfWeek = "Thursday"
	// Tuesday ...
	Tuesday DayOfWeek = "Tuesday"
	// Wednesday ...
	Wednesday DayOfWeek = "Wednesday"
)

// PossibleDayOfWeekValues returns an array of possible values for the DayOfWeek const type.
func PossibleDayOfWeekValues() []DayOfWeek {
	return []DayOfWeek{Friday, Monday, Saturday, Sunday, Thursday, Tuesday, Wednesday}
}

// DeviceConfigurationStatus enumerates the values for device configuration status.
type DeviceConfigurationStatus string

const (
	// Complete ...
	Complete DeviceConfigurationStatus = "Complete"
	// Pending ...
	Pending DeviceConfigurationStatus = "Pending"
)

// PossibleDeviceConfigurationStatusValues returns an array of possible values for the DeviceConfigurationStatus const type.
func PossibleDeviceConfigurationStatusValues() []DeviceConfigurationStatus {
	return []DeviceConfigurationStatus{Complete, Pending}
}

// DeviceStatus enumerates the values for device status.
type DeviceStatus string

const (
	// Creating ...
	Creating DeviceStatus = "Creating"
	// Deactivated ...
	Deactivated DeviceStatus = "Deactivated"
	// Deactivating ...
	Deactivating DeviceStatus = "Deactivating"
	// Deleted ...
	Deleted DeviceStatus = "Deleted"
	// MaintenanceMode ...
	MaintenanceMode DeviceStatus = "MaintenanceMode"
	// Offline ...
	Offline DeviceStatus = "Offline"
	// Online ...
	Online DeviceStatus = "Online"
	// Provisioning ...
	Provisioning DeviceStatus = "Provisioning"
	// ReadyToSetup ...
	ReadyToSetup DeviceStatus = "ReadyToSetup"
	// RequiresAttention ...
	RequiresAttention DeviceStatus = "RequiresAttention"
	// Unknown ...
	Unknown DeviceStatus = "Unknown"
)

// PossibleDeviceStatusValues returns an array of possible values for the DeviceStatus const type.
func PossibleDeviceStatusValues() []DeviceStatus {
	return []DeviceStatus{Creating, Deactivated, Deactivating, Deleted, MaintenanceMode, Offline, Online, Provisioning, ReadyToSetup, RequiresAttention, Unknown}
}

// DeviceType enumerates the values for device type.
type DeviceType string

const (
	// DeviceTypeInvalid ...
	DeviceTypeInvalid DeviceType = "Invalid"
	// DeviceTypeSeries8000PhysicalAppliance ...
	DeviceTypeSeries8000PhysicalAppliance DeviceType = "Series8000PhysicalAppliance"
	// DeviceTypeSeries8000VirtualAppliance ...
	DeviceTypeSeries8000VirtualAppliance DeviceType = "Series8000VirtualAppliance"
)

// PossibleDeviceTypeValues returns an array of possible values for the DeviceType const type.
func PossibleDeviceTypeValues() []DeviceType {
	return []DeviceType{DeviceTypeInvalid, DeviceTypeSeries8000PhysicalAppliance, DeviceTypeSeries8000VirtualAppliance}
}

// EncryptionAlgorithm enumerates the values for encryption algorithm.
type EncryptionAlgorithm string

const (
	// EncryptionAlgorithmAES256 ...
	EncryptionAlgorithmAES256 EncryptionAlgorithm = "AES256"
	// EncryptionAlgorithmNone ...
	EncryptionAlgorithmNone EncryptionAlgorithm = "None"
	// EncryptionAlgorithmRSAESPKCS1V15 ...
	EncryptionAlgorithmRSAESPKCS1V15 EncryptionAlgorithm = "RSAES_PKCS1_v_1_5"
)

// PossibleEncryptionAlgorithmValues returns an array of possible values for the EncryptionAlgorithm const type.
func PossibleEncryptionAlgorithmValues() []EncryptionAlgorithm {
	return []EncryptionAlgorithm{EncryptionAlgorithmAES256, EncryptionAlgorithmNone, EncryptionAlgorithmRSAESPKCS1V15}
}

// EncryptionStatus enumerates the values for encryption status.
type EncryptionStatus string

const (
	// EncryptionStatusDisabled ...
	EncryptionStatusDisabled EncryptionStatus = "Disabled"
	// EncryptionStatusEnabled ...
	EncryptionStatusEnabled EncryptionStatus = "Enabled"
)

// PossibleEncryptionStatusValues returns an array of possible values for the EncryptionStatus const type.
func PossibleEncryptionStatusValues() []EncryptionStatus {
	return []EncryptionStatus{EncryptionStatusDisabled, EncryptionStatusEnabled}
}

// FeatureSupportStatus enumerates the values for feature support status.
type FeatureSupportStatus string

const (
	// NotAvailable ...
	NotAvailable FeatureSupportStatus = "NotAvailable"
	// Supported ...
	Supported FeatureSupportStatus = "Supported"
	// UnsupportedDeviceVersion ...
	UnsupportedDeviceVersion FeatureSupportStatus = "UnsupportedDeviceVersion"
)

// PossibleFeatureSupportStatusValues returns an array of possible values for the FeatureSupportStatus const type.
func PossibleFeatureSupportStatusValues() []FeatureSupportStatus {
	return []FeatureSupportStatus{NotAvailable, Supported, UnsupportedDeviceVersion}
}

// HardwareComponentStatus enumerates the values for hardware component status.
type HardwareComponentStatus string

const (
	// HardwareComponentStatusFailure ...
	HardwareComponentStatusFailure HardwareComponentStatus = "Failure"
	// HardwareComponentStatusNotPresent ...
	HardwareComponentStatusNotPresent HardwareComponentStatus = "NotPresent"
	// HardwareComponentStatusOk ...
	HardwareComponentStatusOk HardwareComponentStatus = "Ok"
	// HardwareComponentStatusPoweredOff ...
	HardwareComponentStatusPoweredOff HardwareComponentStatus = "PoweredOff"
	// HardwareComponentStatusRecovering ...
	HardwareComponentStatusRecovering HardwareComponentStatus = "Recovering"
	// HardwareComponentStatusUnknown ...
	HardwareComponentStatusUnknown HardwareComponentStatus = "Unknown"
	// HardwareComponentStatusWarning ...
	HardwareComponentStatusWarning HardwareComponentStatus = "Warning"
)

// PossibleHardwareComponentStatusValues returns an array of possible values for the HardwareComponentStatus const type.
func PossibleHardwareComponentStatusValues() []HardwareComponentStatus {
	return []HardwareComponentStatus{HardwareComponentStatusFailure, HardwareComponentStatusNotPresent, HardwareComponentStatusOk, HardwareComponentStatusPoweredOff, HardwareComponentStatusRecovering, HardwareComponentStatusUnknown, HardwareComponentStatusWarning}
}

// InEligibilityCategory enumerates the values for in eligibility category.
type InEligibilityCategory string

const (
	// DeviceNotOnline ...
	DeviceNotOnline InEligibilityCategory = "DeviceNotOnline"
	// NotSupportedAppliance ...
	NotSupportedAppliance InEligibilityCategory = "NotSupportedAppliance"
	// RolloverPending ...
	RolloverPending InEligibilityCategory = "RolloverPending"
)

// PossibleInEligibilityCategoryValues returns an array of possible values for the InEligibilityCategory const type.
func PossibleInEligibilityCategoryValues() []InEligibilityCategory {
	return []InEligibilityCategory{DeviceNotOnline, NotSupportedAppliance, RolloverPending}
}

// ISCSIAndCloudStatus enumerates the values for iscsi and cloud status.
type ISCSIAndCloudStatus string

const (
	// ISCSIAndCloudStatusCloudEnabled ...
	ISCSIAndCloudStatusCloudEnabled ISCSIAndCloudStatus = "CloudEnabled"
	// ISCSIAndCloudStatusDisabled ...
	ISCSIAndCloudStatusDisabled ISCSIAndCloudStatus = "Disabled"
	// ISCSIAndCloudStatusIscsiAndCloudEnabled ...
	ISCSIAndCloudStatusIscsiAndCloudEnabled ISCSIAndCloudStatus = "IscsiAndCloudEnabled"
	// ISCSIAndCloudStatusIscsiEnabled ...
	ISCSIAndCloudStatusIscsiEnabled ISCSIAndCloudStatus = "IscsiEnabled"
)

// PossibleISCSIAndCloudStatusValues returns an array of possible values for the ISCSIAndCloudStatus const type.
func PossibleISCSIAndCloudStatusValues() []ISCSIAndCloudStatus {
	return []ISCSIAndCloudStatus{ISCSIAndCloudStatusCloudEnabled, ISCSIAndCloudStatusDisabled, ISCSIAndCloudStatusIscsiAndCloudEnabled, ISCSIAndCloudStatusIscsiEnabled}
}

// JobStatus enumerates the values for job status.
type JobStatus string

const (
	// Canceled ...
	Canceled JobStatus = "Canceled"
	// Failed ...
	Failed JobStatus = "Failed"
	// Running ...
	Running JobStatus = "Running"
	// Succeeded ...
	Succeeded JobStatus = "Succeeded"
)

// PossibleJobStatusValues returns an array of possible values for the JobStatus const type.
func PossibleJobStatusValues() []JobStatus {
	return []JobStatus{Canceled, Failed, Running, Succeeded}
}

// JobType enumerates the values for job type.
type JobType string

const (
	// CloneVolume ...
	CloneVolume JobType = "CloneVolume"
	// CreateCloudAppliance ...
	CreateCloudAppliance JobType = "CreateCloudAppliance"
	// CreateLocallyPinnedVolume ...
	CreateLocallyPinnedVolume JobType = "CreateLocallyPinnedVolume"
	// FailoverVolumeContainers ...
	FailoverVolumeContainers JobType = "FailoverVolumeContainers"
	// InstallUpdates ...
	InstallUpdates JobType = "InstallUpdates"
	// ManualBackup ...
	ManualBackup JobType = "ManualBackup"
	// ModifyVolume ...
	ModifyVolume JobType = "ModifyVolume"
	// RestoreBackup ...
	RestoreBackup JobType = "RestoreBackup"
	// ScheduledBackup ...
	ScheduledBackup JobType = "ScheduledBackup"
	// SupportPackageLogs ...
	SupportPackageLogs JobType = "SupportPackageLogs"
)

// PossibleJobTypeValues returns an array of possible values for the JobType const type.
func PossibleJobTypeValues() []JobType {
	return []JobType{CloneVolume, CreateCloudAppliance, CreateLocallyPinnedVolume, FailoverVolumeContainers, InstallUpdates, ManualBackup, ModifyVolume, RestoreBackup, ScheduledBackup, SupportPackageLogs}
}

// KeyRolloverStatus enumerates the values for key rollover status.
type KeyRolloverStatus string

const (
	// NotRequired ...
	NotRequired KeyRolloverStatus = "NotRequired"
	// Required ...
	Required KeyRolloverStatus = "Required"
)

// PossibleKeyRolloverStatusValues returns an array of possible values for the KeyRolloverStatus const type.
func PossibleKeyRolloverStatusValues() []KeyRolloverStatus {
	return []KeyRolloverStatus{NotRequired, Required}
}

// Kind enumerates the values for kind.
type Kind string

const (
	// Series8000 ...
	Series8000 Kind = "Series8000"
)

// PossibleKindValues returns an array of possible values for the Kind const type.
func PossibleKindValues() []Kind {
	return []Kind{Series8000}
}

// ManagerType enumerates the values for manager type.
type ManagerType string

const (
	// GardaV1 ...
	GardaV1 ManagerType = "GardaV1"
	// HelsinkiV1 ...
	HelsinkiV1 ManagerType = "HelsinkiV1"
)

// PossibleManagerTypeValues returns an array of possible values for the ManagerType const type.
func PossibleManagerTypeValues() []ManagerType {
	return []ManagerType{GardaV1, HelsinkiV1}
}

// MetricAggregationType enumerates the values for metric aggregation type.
type MetricAggregationType string

const (
	// MetricAggregationTypeAverage ...
	MetricAggregationTypeAverage MetricAggregationType = "Average"
	// MetricAggregationTypeLast ...
	MetricAggregationTypeLast MetricAggregationType = "Last"
	// MetricAggregationTypeMaximum ...
	MetricAggregationTypeMaximum MetricAggregationType = "Maximum"
	// MetricAggregationTypeMinimum ...
	MetricAggregationTypeMinimum MetricAggregationType = "Minimum"
	// MetricAggregationTypeNone ...
	MetricAggregationTypeNone MetricAggregationType = "None"
	// MetricAggregationTypeTotal ...
	MetricAggregationTypeTotal MetricAggregationType = "Total"
)

// PossibleMetricAggregationTypeValues returns an array of possible values for the MetricAggregationType const type.
func PossibleMetricAggregationTypeValues() []MetricAggregationType {
	return []MetricAggregationType{MetricAggregationTypeAverage, MetricAggregationTypeLast, MetricAggregationTypeMaximum, MetricAggregationTypeMinimum, MetricAggregationTypeNone, MetricAggregationTypeTotal}
}

// MetricUnit enumerates the values for metric unit.
type MetricUnit string

const (
	// Bytes ...
	Bytes MetricUnit = "Bytes"
	// BytesPerSecond ...
	BytesPerSecond MetricUnit = "BytesPerSecond"
	// Count ...
	Count MetricUnit = "Count"
	// CountPerSecond ...
	CountPerSecond MetricUnit = "CountPerSecond"
	// Percent ...
	Percent MetricUnit = "Percent"
	// Seconds ...
	Seconds MetricUnit = "Seconds"
)

// PossibleMetricUnitValues returns an array of possible values for the MetricUnit const type.
func PossibleMetricUnitValues() []MetricUnit {
	return []MetricUnit{Bytes, BytesPerSecond, Count, CountPerSecond, Percent, Seconds}
}

// MonitoringStatus enumerates the values for monitoring status.
type MonitoringStatus string

const (
	// MonitoringStatusDisabled ...
	MonitoringStatusDisabled MonitoringStatus = "Disabled"
	// MonitoringStatusEnabled ...
	MonitoringStatusEnabled MonitoringStatus = "Enabled"
)

// PossibleMonitoringStatusValues returns an array of possible values for the MonitoringStatus const type.
func PossibleMonitoringStatusValues() []MonitoringStatus {
	return []MonitoringStatus{MonitoringStatusDisabled, MonitoringStatusEnabled}
}

// NetInterfaceID enumerates the values for net interface id.
type NetInterfaceID string

const (
	// NetInterfaceIDData0 ...
	NetInterfaceIDData0 NetInterfaceID = "Data0"
	// NetInterfaceIDData1 ...
	NetInterfaceIDData1 NetInterfaceID = "Data1"
	// NetInterfaceIDData2 ...
	NetInterfaceIDData2 NetInterfaceID = "Data2"
	// NetInterfaceIDData3 ...
	NetInterfaceIDData3 NetInterfaceID = "Data3"
	// NetInterfaceIDData4 ...
	NetInterfaceIDData4 NetInterfaceID = "Data4"
	// NetInterfaceIDData5 ...
	NetInterfaceIDData5 NetInterfaceID = "Data5"
	// NetInterfaceIDInvalid ...
	NetInterfaceIDInvalid NetInterfaceID = "Invalid"
)

// PossibleNetInterfaceIDValues returns an array of possible values for the NetInterfaceID const type.
func PossibleNetInterfaceIDValues() []NetInterfaceID {
	return []NetInterfaceID{NetInterfaceIDData0, NetInterfaceIDData1, NetInterfaceIDData2, NetInterfaceIDData3, NetInterfaceIDData4, NetInterfaceIDData5, NetInterfaceIDInvalid}
}

// NetInterfaceStatus enumerates the values for net interface status.
type NetInterfaceStatus string

const (
	// NetInterfaceStatusDisabled ...
	NetInterfaceStatusDisabled NetInterfaceStatus = "Disabled"
	// NetInterfaceStatusEnabled ...
	NetInterfaceStatusEnabled NetInterfaceStatus = "Enabled"
)

// PossibleNetInterfaceStatusValues returns an array of possible values for the NetInterfaceStatus const type.
func PossibleNetInterfaceStatusValues() []NetInterfaceStatus {
	return []NetInterfaceStatus{NetInterfaceStatusDisabled, NetInterfaceStatusEnabled}
}

// NetworkMode enumerates the values for network mode.
type NetworkMode string

const (
	// NetworkModeBOTH ...
	NetworkModeBOTH NetworkMode = "BOTH"
	// NetworkModeInvalid ...
	NetworkModeInvalid NetworkMode = "Invalid"
	// NetworkModeIPV4 ...
	NetworkModeIPV4 NetworkMode = "IPV4"
	// NetworkModeIPV6 ...
	NetworkModeIPV6 NetworkMode = "IPV6"
)

// PossibleNetworkModeValues returns an array of possible values for the NetworkMode const type.
func PossibleNetworkModeValues() []NetworkMode {
	return []NetworkMode{NetworkModeBOTH, NetworkModeInvalid, NetworkModeIPV4, NetworkModeIPV6}
}

// OperationStatus enumerates the values for operation status.
type OperationStatus string

const (
	// OperationStatusDeleting ...
	OperationStatusDeleting OperationStatus = "Deleting"
	// OperationStatusNone ...
	OperationStatusNone OperationStatus = "None"
	// OperationStatusRestoring ...
	OperationStatusRestoring OperationStatus = "Restoring"
	// OperationStatusUpdating ...
	OperationStatusUpdating OperationStatus = "Updating"
)

// PossibleOperationStatusValues returns an array of possible values for the OperationStatus const type.
func PossibleOperationStatusValues() []OperationStatus {
	return []OperationStatus{OperationStatusDeleting, OperationStatusNone, OperationStatusRestoring, OperationStatusUpdating}
}

// OwnerShipStatus enumerates the values for owner ship status.
type OwnerShipStatus string

const (
	// NotOwned ...
	NotOwned OwnerShipStatus = "NotOwned"
	// Owned ...
	Owned OwnerShipStatus = "Owned"
)

// PossibleOwnerShipStatusValues returns an array of possible values for the OwnerShipStatus const type.
func PossibleOwnerShipStatusValues() []OwnerShipStatus {
	return []OwnerShipStatus{NotOwned, Owned}
}

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// Daily ...
	Daily RecurrenceType = "Daily"
	// Hourly ...
	Hourly RecurrenceType = "Hourly"
	// Minutes ...
	Minutes RecurrenceType = "Minutes"
	// Weekly ...
	Weekly RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns an array of possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{Daily, Hourly, Minutes, Weekly}
}

// RemoteManagementModeConfiguration enumerates the values for remote management mode configuration.
type RemoteManagementModeConfiguration string

const (
	// RemoteManagementModeConfigurationDisabled ...
	RemoteManagementModeConfigurationDisabled RemoteManagementModeConfiguration = "Disabled"
	// RemoteManagementModeConfigurationHTTPSAndHTTPEnabled ...
	RemoteManagementModeConfigurationHTTPSAndHTTPEnabled RemoteManagementModeConfiguration = "HttpsAndHttpEnabled"
	// RemoteManagementModeConfigurationHTTPSEnabled ...
	RemoteManagementModeConfigurationHTTPSEnabled RemoteManagementModeConfiguration = "HttpsEnabled"
	// RemoteManagementModeConfigurationUnknown ...
	RemoteManagementModeConfigurationUnknown RemoteManagementModeConfiguration = "Unknown"
)

// PossibleRemoteManagementModeConfigurationValues returns an array of possible values for the RemoteManagementModeConfiguration const type.
func PossibleRemoteManagementModeConfigurationValues() []RemoteManagementModeConfiguration {
	return []RemoteManagementModeConfiguration{RemoteManagementModeConfigurationDisabled, RemoteManagementModeConfigurationHTTPSAndHTTPEnabled, RemoteManagementModeConfigurationHTTPSEnabled, RemoteManagementModeConfigurationUnknown}
}

// ScheduledBackupStatus enumerates the values for scheduled backup status.
type ScheduledBackupStatus string

const (
	// ScheduledBackupStatusDisabled ...
	ScheduledBackupStatusDisabled ScheduledBackupStatus = "Disabled"
	// ScheduledBackupStatusEnabled ...
	ScheduledBackupStatusEnabled ScheduledBackupStatus = "Enabled"
)

// PossibleScheduledBackupStatusValues returns an array of possible values for the ScheduledBackupStatus const type.
func PossibleScheduledBackupStatusValues() []ScheduledBackupStatus {
	return []ScheduledBackupStatus{ScheduledBackupStatusDisabled, ScheduledBackupStatusEnabled}
}

// ScheduleStatus enumerates the values for schedule status.
type ScheduleStatus string

const (
	// ScheduleStatusDisabled ...
	ScheduleStatusDisabled ScheduleStatus = "Disabled"
	// ScheduleStatusEnabled ...
	ScheduleStatusEnabled ScheduleStatus = "Enabled"
)

// PossibleScheduleStatusValues returns an array of possible values for the ScheduleStatus const type.
func PossibleScheduleStatusValues() []ScheduleStatus {
	return []ScheduleStatus{ScheduleStatusDisabled, ScheduleStatusEnabled}
}

// SslStatus enumerates the values for ssl status.
type SslStatus string

const (
	// SslStatusDisabled ...
	SslStatusDisabled SslStatus = "Disabled"
	// SslStatusEnabled ...
	SslStatusEnabled SslStatus = "Enabled"
)

// PossibleSslStatusValues returns an array of possible values for the SslStatus const type.
func PossibleSslStatusValues() []SslStatus {
	return []SslStatus{SslStatusDisabled, SslStatusEnabled}
}

// TargetEligibilityResultCode enumerates the values for target eligibility result code.
type TargetEligibilityResultCode string

const (
	// LocalToTieredVolumesConversionWarning ...
	LocalToTieredVolumesConversionWarning TargetEligibilityResultCode = "LocalToTieredVolumesConversionWarning"
	// TargetAndSourceCannotBeSameError ...
	TargetAndSourceCannotBeSameError TargetEligibilityResultCode = "TargetAndSourceCannotBeSameError"
	// TargetInsufficientCapacityError ...
	TargetInsufficientCapacityError TargetEligibilityResultCode = "TargetInsufficientCapacityError"
	// TargetInsufficientLocalVolumeMemoryError ...
	TargetInsufficientLocalVolumeMemoryError TargetEligibilityResultCode = "TargetInsufficientLocalVolumeMemoryError"
	// TargetInsufficientTieredVolumeMemoryError ...
	TargetInsufficientTieredVolumeMemoryError TargetEligibilityResultCode = "TargetInsufficientTieredVolumeMemoryError"
	// TargetIsNotOnlineError ...
	TargetIsNotOnlineError TargetEligibilityResultCode = "TargetIsNotOnlineError"
	// TargetSourceIncompatibleVersionError ...
	TargetSourceIncompatibleVersionError TargetEligibilityResultCode = "TargetSourceIncompatibleVersionError"
)

// PossibleTargetEligibilityResultCodeValues returns an array of possible values for the TargetEligibilityResultCode const type.
func PossibleTargetEligibilityResultCodeValues() []TargetEligibilityResultCode {
	return []TargetEligibilityResultCode{LocalToTieredVolumesConversionWarning, TargetAndSourceCannotBeSameError, TargetInsufficientCapacityError, TargetInsufficientLocalVolumeMemoryError, TargetInsufficientTieredVolumeMemoryError, TargetIsNotOnlineError, TargetSourceIncompatibleVersionError}
}

// TargetEligibilityStatus enumerates the values for target eligibility status.
type TargetEligibilityStatus string

const (
	// TargetEligibilityStatusEligible ...
	TargetEligibilityStatusEligible TargetEligibilityStatus = "Eligible"
	// TargetEligibilityStatusNotEligible ...
	TargetEligibilityStatusNotEligible TargetEligibilityStatus = "NotEligible"
)

// PossibleTargetEligibilityStatusValues returns an array of possible values for the TargetEligibilityStatus const type.
func PossibleTargetEligibilityStatusValues() []TargetEligibilityStatus {
	return []TargetEligibilityStatus{TargetEligibilityStatusEligible, TargetEligibilityStatusNotEligible}
}

// VirtualMachineAPIType enumerates the values for virtual machine api type.
type VirtualMachineAPIType string

const (
	// Arm ...
	Arm VirtualMachineAPIType = "Arm"
	// Classic ...
	Classic VirtualMachineAPIType = "Classic"
)

// PossibleVirtualMachineAPITypeValues returns an array of possible values for the VirtualMachineAPIType const type.
func PossibleVirtualMachineAPITypeValues() []VirtualMachineAPIType {
	return []VirtualMachineAPIType{Arm, Classic}
}

// VolumeStatus enumerates the values for volume status.
type VolumeStatus string

const (
	// VolumeStatusOffline ...
	VolumeStatusOffline VolumeStatus = "Offline"
	// VolumeStatusOnline ...
	VolumeStatusOnline VolumeStatus = "Online"
)

// PossibleVolumeStatusValues returns an array of possible values for the VolumeStatus const type.
func PossibleVolumeStatusValues() []VolumeStatus {
	return []VolumeStatus{VolumeStatusOffline, VolumeStatusOnline}
}

// VolumeType enumerates the values for volume type.
type VolumeType string

const (
	// Archival ...
	Archival VolumeType = "Archival"
	// LocallyPinned ...
	LocallyPinned VolumeType = "LocallyPinned"
	// Tiered ...
	Tiered VolumeType = "Tiered"
)

// PossibleVolumeTypeValues returns an array of possible values for the VolumeType const type.
func PossibleVolumeTypeValues() []VolumeType {
	return []VolumeType{Archival, LocallyPinned, Tiered}
}
