package costmanagement

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// AccumulatedType enumerates the values for accumulated type.
type AccumulatedType string

const (
	// False ...
	False AccumulatedType = "false"
	// True ...
	True AccumulatedType = "true"
)

// PossibleAccumulatedTypeValues returns an array of possible values for the AccumulatedType const type.
func PossibleAccumulatedTypeValues() []AccumulatedType {
	return []AccumulatedType{False, True}
}

// AlertCategory enumerates the values for alert category.
type AlertCategory string

const (
	// Billing ...
	Billing AlertCategory = "Billing"
	// Cost ...
	Cost AlertCategory = "Cost"
	// System ...
	System AlertCategory = "System"
	// Usage ...
	Usage AlertCategory = "Usage"
)

// PossibleAlertCategoryValues returns an array of possible values for the AlertCategory const type.
func PossibleAlertCategoryValues() []AlertCategory {
	return []AlertCategory{Billing, Cost, System, Usage}
}

// AlertCriteria enumerates the values for alert criteria.
type AlertCriteria string

const (
	// CostThresholdExceeded ...
	CostThresholdExceeded AlertCriteria = "CostThresholdExceeded"
	// CreditThresholdApproaching ...
	CreditThresholdApproaching AlertCriteria = "CreditThresholdApproaching"
	// CreditThresholdReached ...
	CreditThresholdReached AlertCriteria = "CreditThresholdReached"
	// CrossCloudCollectionError ...
	CrossCloudCollectionError AlertCriteria = "CrossCloudCollectionError"
	// CrossCloudNewDataAvailable ...
	CrossCloudNewDataAvailable AlertCriteria = "CrossCloudNewDataAvailable"
	// ForecastCostThresholdExceeded ...
	ForecastCostThresholdExceeded AlertCriteria = "ForecastCostThresholdExceeded"
	// ForecastUsageThresholdExceeded ...
	ForecastUsageThresholdExceeded AlertCriteria = "ForecastUsageThresholdExceeded"
	// GeneralThresholdError ...
	GeneralThresholdError AlertCriteria = "GeneralThresholdError"
	// InvoiceDueDateApproaching ...
	InvoiceDueDateApproaching AlertCriteria = "InvoiceDueDateApproaching"
	// InvoiceDueDateReached ...
	InvoiceDueDateReached AlertCriteria = "InvoiceDueDateReached"
	// MultiCurrency ...
	MultiCurrency AlertCriteria = "MultiCurrency"
	// QuotaThresholdApproaching ...
	QuotaThresholdApproaching AlertCriteria = "QuotaThresholdApproaching"
	// QuotaThresholdReached ...
	QuotaThresholdReached AlertCriteria = "QuotaThresholdReached"
	// UsageThresholdExceeded ...
	UsageThresholdExceeded AlertCriteria = "UsageThresholdExceeded"
)

// PossibleAlertCriteriaValues returns an array of possible values for the AlertCriteria const type.
func PossibleAlertCriteriaValues() []AlertCriteria {
	return []AlertCriteria{CostThresholdExceeded, CreditThresholdApproaching, CreditThresholdReached, CrossCloudCollectionError, CrossCloudNewDataAvailable, ForecastCostThresholdExceeded, ForecastUsageThresholdExceeded, GeneralThresholdError, InvoiceDueDateApproaching, InvoiceDueDateReached, MultiCurrency, QuotaThresholdApproaching, QuotaThresholdReached, UsageThresholdExceeded}
}

// AlertOperator enumerates the values for alert operator.
type AlertOperator string

const (
	// EqualTo ...
	EqualTo AlertOperator = "EqualTo"
	// GreaterThan ...
	GreaterThan AlertOperator = "GreaterThan"
	// GreaterThanOrEqualTo ...
	GreaterThanOrEqualTo AlertOperator = "GreaterThanOrEqualTo"
	// LessThan ...
	LessThan AlertOperator = "LessThan"
	// LessThanOrEqualTo ...
	LessThanOrEqualTo AlertOperator = "LessThanOrEqualTo"
	// None ...
	None AlertOperator = "None"
)

// PossibleAlertOperatorValues returns an array of possible values for the AlertOperator const type.
func PossibleAlertOperatorValues() []AlertOperator {
	return []AlertOperator{EqualTo, GreaterThan, GreaterThanOrEqualTo, LessThan, LessThanOrEqualTo, None}
}

// AlertSource enumerates the values for alert source.
type AlertSource string

const (
	// Preset ...
	Preset AlertSource = "Preset"
	// User ...
	User AlertSource = "User"
)

// PossibleAlertSourceValues returns an array of possible values for the AlertSource const type.
func PossibleAlertSourceValues() []AlertSource {
	return []AlertSource{Preset, User}
}

// AlertStatus enumerates the values for alert status.
type AlertStatus string

const (
	// AlertStatusActive ...
	AlertStatusActive AlertStatus = "Active"
	// AlertStatusDismissed ...
	AlertStatusDismissed AlertStatus = "Dismissed"
	// AlertStatusNone ...
	AlertStatusNone AlertStatus = "None"
	// AlertStatusOverridden ...
	AlertStatusOverridden AlertStatus = "Overridden"
	// AlertStatusResolved ...
	AlertStatusResolved AlertStatus = "Resolved"
)

// PossibleAlertStatusValues returns an array of possible values for the AlertStatus const type.
func PossibleAlertStatusValues() []AlertStatus {
	return []AlertStatus{AlertStatusActive, AlertStatusDismissed, AlertStatusNone, AlertStatusOverridden, AlertStatusResolved}
}

// AlertTimeGrainType enumerates the values for alert time grain type.
type AlertTimeGrainType string

const (
	// AlertTimeGrainTypeAnnually ...
	AlertTimeGrainTypeAnnually AlertTimeGrainType = "Annually"
	// AlertTimeGrainTypeBillingAnnual ...
	AlertTimeGrainTypeBillingAnnual AlertTimeGrainType = "BillingAnnual"
	// AlertTimeGrainTypeBillingMonth ...
	AlertTimeGrainTypeBillingMonth AlertTimeGrainType = "BillingMonth"
	// AlertTimeGrainTypeBillingQuarter ...
	AlertTimeGrainTypeBillingQuarter AlertTimeGrainType = "BillingQuarter"
	// AlertTimeGrainTypeMonthly ...
	AlertTimeGrainTypeMonthly AlertTimeGrainType = "Monthly"
	// AlertTimeGrainTypeNone ...
	AlertTimeGrainTypeNone AlertTimeGrainType = "None"
	// AlertTimeGrainTypeQuarterly ...
	AlertTimeGrainTypeQuarterly AlertTimeGrainType = "Quarterly"
)

// PossibleAlertTimeGrainTypeValues returns an array of possible values for the AlertTimeGrainType const type.
func PossibleAlertTimeGrainTypeValues() []AlertTimeGrainType {
	return []AlertTimeGrainType{AlertTimeGrainTypeAnnually, AlertTimeGrainTypeBillingAnnual, AlertTimeGrainTypeBillingMonth, AlertTimeGrainTypeBillingQuarter, AlertTimeGrainTypeMonthly, AlertTimeGrainTypeNone, AlertTimeGrainTypeQuarterly}
}

// AlertType enumerates the values for alert type.
type AlertType string

const (
	// Budget ...
	Budget AlertType = "Budget"
	// BudgetForecast ...
	BudgetForecast AlertType = "BudgetForecast"
	// Credit ...
	Credit AlertType = "Credit"
	// General ...
	General AlertType = "General"
	// Invoice ...
	Invoice AlertType = "Invoice"
	// Quota ...
	Quota AlertType = "Quota"
	// XCloud ...
	XCloud AlertType = "xCloud"
)

// PossibleAlertTypeValues returns an array of possible values for the AlertType const type.
func PossibleAlertTypeValues() []AlertType {
	return []AlertType{Budget, BudgetForecast, Credit, General, Invoice, Quota, XCloud}
}

// ChartType enumerates the values for chart type.
type ChartType string

const (
	// Area ...
	Area ChartType = "Area"
	// GroupedColumn ...
	GroupedColumn ChartType = "GroupedColumn"
	// Line ...
	Line ChartType = "Line"
	// StackedColumn ...
	StackedColumn ChartType = "StackedColumn"
	// Table ...
	Table ChartType = "Table"
)

// PossibleChartTypeValues returns an array of possible values for the ChartType const type.
func PossibleChartTypeValues() []ChartType {
	return []ChartType{Area, GroupedColumn, Line, StackedColumn, Table}
}

// Direction enumerates the values for direction.
type Direction string

const (
	// Ascending ...
	Ascending Direction = "Ascending"
	// Descending ...
	Descending Direction = "Descending"
)

// PossibleDirectionValues returns an array of possible values for the Direction const type.
func PossibleDirectionValues() []Direction {
	return []Direction{Ascending, Descending}
}

// ExecutionStatus enumerates the values for execution status.
type ExecutionStatus string

const (
	// Completed ...
	Completed ExecutionStatus = "Completed"
	// DataNotAvailable ...
	DataNotAvailable ExecutionStatus = "DataNotAvailable"
	// Failed ...
	Failed ExecutionStatus = "Failed"
	// InProgress ...
	InProgress ExecutionStatus = "InProgress"
	// NewDataNotAvailable ...
	NewDataNotAvailable ExecutionStatus = "NewDataNotAvailable"
	// Queued ...
	Queued ExecutionStatus = "Queued"
	// Timeout ...
	Timeout ExecutionStatus = "Timeout"
)

// PossibleExecutionStatusValues returns an array of possible values for the ExecutionStatus const type.
func PossibleExecutionStatusValues() []ExecutionStatus {
	return []ExecutionStatus{Completed, DataNotAvailable, Failed, InProgress, NewDataNotAvailable, Queued, Timeout}
}

// ExecutionType enumerates the values for execution type.
type ExecutionType string

const (
	// OnDemand ...
	OnDemand ExecutionType = "OnDemand"
	// Scheduled ...
	Scheduled ExecutionType = "Scheduled"
)

// PossibleExecutionTypeValues returns an array of possible values for the ExecutionType const type.
func PossibleExecutionTypeValues() []ExecutionType {
	return []ExecutionType{OnDemand, Scheduled}
}

// ExportType enumerates the values for export type.
type ExportType string

const (
	// ExportTypeActualCost ...
	ExportTypeActualCost ExportType = "ActualCost"
	// ExportTypeAmortizedCost ...
	ExportTypeAmortizedCost ExportType = "AmortizedCost"
	// ExportTypeUsage ...
	ExportTypeUsage ExportType = "Usage"
)

// PossibleExportTypeValues returns an array of possible values for the ExportType const type.
func PossibleExportTypeValues() []ExportType {
	return []ExportType{ExportTypeActualCost, ExportTypeAmortizedCost, ExportTypeUsage}
}

// ExternalCloudProviderType enumerates the values for external cloud provider type.
type ExternalCloudProviderType string

const (
	// ExternalBillingAccounts ...
	ExternalBillingAccounts ExternalCloudProviderType = "externalBillingAccounts"
	// ExternalSubscriptions ...
	ExternalSubscriptions ExternalCloudProviderType = "externalSubscriptions"
)

// PossibleExternalCloudProviderTypeValues returns an array of possible values for the ExternalCloudProviderType const type.
func PossibleExternalCloudProviderTypeValues() []ExternalCloudProviderType {
	return []ExternalCloudProviderType{ExternalBillingAccounts, ExternalSubscriptions}
}

// ForecastTimeframeType enumerates the values for forecast timeframe type.
type ForecastTimeframeType string

const (
	// BillingMonthToDate ...
	BillingMonthToDate ForecastTimeframeType = "BillingMonthToDate"
	// Custom ...
	Custom ForecastTimeframeType = "Custom"
	// MonthToDate ...
	MonthToDate ForecastTimeframeType = "MonthToDate"
	// TheLastBillingMonth ...
	TheLastBillingMonth ForecastTimeframeType = "TheLastBillingMonth"
	// TheLastMonth ...
	TheLastMonth ForecastTimeframeType = "TheLastMonth"
	// WeekToDate ...
	WeekToDate ForecastTimeframeType = "WeekToDate"
)

// PossibleForecastTimeframeTypeValues returns an array of possible values for the ForecastTimeframeType const type.
func PossibleForecastTimeframeTypeValues() []ForecastTimeframeType {
	return []ForecastTimeframeType{BillingMonthToDate, Custom, MonthToDate, TheLastBillingMonth, TheLastMonth, WeekToDate}
}

// ForecastType enumerates the values for forecast type.
type ForecastType string

const (
	// ForecastTypeActualCost ...
	ForecastTypeActualCost ForecastType = "ActualCost"
	// ForecastTypeAmortizedCost ...
	ForecastTypeAmortizedCost ForecastType = "AmortizedCost"
	// ForecastTypeUsage ...
	ForecastTypeUsage ForecastType = "Usage"
)

// PossibleForecastTypeValues returns an array of possible values for the ForecastType const type.
func PossibleForecastTypeValues() []ForecastType {
	return []ForecastType{ForecastTypeActualCost, ForecastTypeAmortizedCost, ForecastTypeUsage}
}

// FormatType enumerates the values for format type.
type FormatType string

const (
	// Csv ...
	Csv FormatType = "Csv"
)

// PossibleFormatTypeValues returns an array of possible values for the FormatType const type.
func PossibleFormatTypeValues() []FormatType {
	return []FormatType{Csv}
}

// GranularityType enumerates the values for granularity type.
type GranularityType string

const (
	// Daily ...
	Daily GranularityType = "Daily"
)

// PossibleGranularityTypeValues returns an array of possible values for the GranularityType const type.
func PossibleGranularityTypeValues() []GranularityType {
	return []GranularityType{Daily}
}

// KpiTypeType enumerates the values for kpi type type.
type KpiTypeType string

const (
	// KpiTypeTypeBudget ...
	KpiTypeTypeBudget KpiTypeType = "Budget"
	// KpiTypeTypeForecast ...
	KpiTypeTypeForecast KpiTypeType = "Forecast"
)

// PossibleKpiTypeTypeValues returns an array of possible values for the KpiTypeType const type.
func PossibleKpiTypeTypeValues() []KpiTypeType {
	return []KpiTypeType{KpiTypeTypeBudget, KpiTypeTypeForecast}
}

// MetricType enumerates the values for metric type.
type MetricType string

const (
	// ActualCost ...
	ActualCost MetricType = "ActualCost"
	// AHUB ...
	AHUB MetricType = "AHUB"
	// AmortizedCost ...
	AmortizedCost MetricType = "AmortizedCost"
)

// PossibleMetricTypeValues returns an array of possible values for the MetricType const type.
func PossibleMetricTypeValues() []MetricType {
	return []MetricType{ActualCost, AHUB, AmortizedCost}
}

// OperatorType enumerates the values for operator type.
type OperatorType string

const (
	// Contains ...
	Contains OperatorType = "Contains"
	// In ...
	In OperatorType = "In"
)

// PossibleOperatorTypeValues returns an array of possible values for the OperatorType const type.
func PossibleOperatorTypeValues() []OperatorType {
	return []OperatorType{Contains, In}
}

// PivotTypeType enumerates the values for pivot type type.
type PivotTypeType string

const (
	// PivotTypeTypeDimension ...
	PivotTypeTypeDimension PivotTypeType = "Dimension"
	// PivotTypeTypeTagKey ...
	PivotTypeTypeTagKey PivotTypeType = "TagKey"
)

// PossiblePivotTypeTypeValues returns an array of possible values for the PivotTypeType const type.
func PossiblePivotTypeTypeValues() []PivotTypeType {
	return []PivotTypeType{PivotTypeTypeDimension, PivotTypeTypeTagKey}
}

// QueryColumnType enumerates the values for query column type.
type QueryColumnType string

const (
	// QueryColumnTypeDimension ...
	QueryColumnTypeDimension QueryColumnType = "Dimension"
	// QueryColumnTypeTag ...
	QueryColumnTypeTag QueryColumnType = "Tag"
)

// PossibleQueryColumnTypeValues returns an array of possible values for the QueryColumnType const type.
func PossibleQueryColumnTypeValues() []QueryColumnType {
	return []QueryColumnType{QueryColumnTypeDimension, QueryColumnTypeTag}
}

// RecurrenceType enumerates the values for recurrence type.
type RecurrenceType string

const (
	// RecurrenceTypeAnnually ...
	RecurrenceTypeAnnually RecurrenceType = "Annually"
	// RecurrenceTypeDaily ...
	RecurrenceTypeDaily RecurrenceType = "Daily"
	// RecurrenceTypeMonthly ...
	RecurrenceTypeMonthly RecurrenceType = "Monthly"
	// RecurrenceTypeWeekly ...
	RecurrenceTypeWeekly RecurrenceType = "Weekly"
)

// PossibleRecurrenceTypeValues returns an array of possible values for the RecurrenceType const type.
func PossibleRecurrenceTypeValues() []RecurrenceType {
	return []RecurrenceType{RecurrenceTypeAnnually, RecurrenceTypeDaily, RecurrenceTypeMonthly, RecurrenceTypeWeekly}
}

// ReportConfigColumnType enumerates the values for report config column type.
type ReportConfigColumnType string

const (
	// ReportConfigColumnTypeDimension ...
	ReportConfigColumnTypeDimension ReportConfigColumnType = "Dimension"
	// ReportConfigColumnTypeTag ...
	ReportConfigColumnTypeTag ReportConfigColumnType = "Tag"
)

// PossibleReportConfigColumnTypeValues returns an array of possible values for the ReportConfigColumnType const type.
func PossibleReportConfigColumnTypeValues() []ReportConfigColumnType {
	return []ReportConfigColumnType{ReportConfigColumnTypeDimension, ReportConfigColumnTypeTag}
}

// ReportGranularityType enumerates the values for report granularity type.
type ReportGranularityType string

const (
	// ReportGranularityTypeDaily ...
	ReportGranularityTypeDaily ReportGranularityType = "Daily"
	// ReportGranularityTypeMonthly ...
	ReportGranularityTypeMonthly ReportGranularityType = "Monthly"
)

// PossibleReportGranularityTypeValues returns an array of possible values for the ReportGranularityType const type.
func PossibleReportGranularityTypeValues() []ReportGranularityType {
	return []ReportGranularityType{ReportGranularityTypeDaily, ReportGranularityTypeMonthly}
}

// ReportTimeframeType enumerates the values for report timeframe type.
type ReportTimeframeType string

const (
	// ReportTimeframeTypeCustom ...
	ReportTimeframeTypeCustom ReportTimeframeType = "Custom"
	// ReportTimeframeTypeMonthToDate ...
	ReportTimeframeTypeMonthToDate ReportTimeframeType = "MonthToDate"
	// ReportTimeframeTypeWeekToDate ...
	ReportTimeframeTypeWeekToDate ReportTimeframeType = "WeekToDate"
	// ReportTimeframeTypeYearToDate ...
	ReportTimeframeTypeYearToDate ReportTimeframeType = "YearToDate"
)

// PossibleReportTimeframeTypeValues returns an array of possible values for the ReportTimeframeType const type.
func PossibleReportTimeframeTypeValues() []ReportTimeframeType {
	return []ReportTimeframeType{ReportTimeframeTypeCustom, ReportTimeframeTypeMonthToDate, ReportTimeframeTypeWeekToDate, ReportTimeframeTypeYearToDate}
}

// StatusType enumerates the values for status type.
type StatusType string

const (
	// Active ...
	Active StatusType = "Active"
	// Inactive ...
	Inactive StatusType = "Inactive"
)

// PossibleStatusTypeValues returns an array of possible values for the StatusType const type.
func PossibleStatusTypeValues() []StatusType {
	return []StatusType{Active, Inactive}
}

// TimeframeType enumerates the values for timeframe type.
type TimeframeType string

const (
	// TimeframeTypeBillingMonthToDate ...
	TimeframeTypeBillingMonthToDate TimeframeType = "BillingMonthToDate"
	// TimeframeTypeCustom ...
	TimeframeTypeCustom TimeframeType = "Custom"
	// TimeframeTypeMonthToDate ...
	TimeframeTypeMonthToDate TimeframeType = "MonthToDate"
	// TimeframeTypeTheLastBillingMonth ...
	TimeframeTypeTheLastBillingMonth TimeframeType = "TheLastBillingMonth"
	// TimeframeTypeTheLastMonth ...
	TimeframeTypeTheLastMonth TimeframeType = "TheLastMonth"
	// TimeframeTypeWeekToDate ...
	TimeframeTypeWeekToDate TimeframeType = "WeekToDate"
)

// PossibleTimeframeTypeValues returns an array of possible values for the TimeframeType const type.
func PossibleTimeframeTypeValues() []TimeframeType {
	return []TimeframeType{TimeframeTypeBillingMonthToDate, TimeframeTypeCustom, TimeframeTypeMonthToDate, TimeframeTypeTheLastBillingMonth, TimeframeTypeTheLastMonth, TimeframeTypeWeekToDate}
}
