package siterecovery

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

// A2ARpRecoveryPointType enumerates the values for a2a rp recovery point type.
type A2ARpRecoveryPointType string

const (
	// Latest ...
	Latest A2ARpRecoveryPointType = "Latest"
	// LatestApplicationConsistent ...
	LatestApplicationConsistent A2ARpRecoveryPointType = "LatestApplicationConsistent"
	// LatestCrashConsistent ...
	LatestCrashConsistent A2ARpRecoveryPointType = "LatestCrashConsistent"
	// LatestProcessed ...
	LatestProcessed A2ARpRecoveryPointType = "LatestProcessed"
)

// PossibleA2ARpRecoveryPointTypeValues returns an array of possible values for the A2ARpRecoveryPointType const type.
func PossibleA2ARpRecoveryPointTypeValues() []A2ARpRecoveryPointType {
	return []A2ARpRecoveryPointType{Latest, LatestApplicationConsistent, LatestCrashConsistent, LatestProcessed}
}

// AlternateLocationRecoveryOption enumerates the values for alternate location recovery option.
type AlternateLocationRecoveryOption string

const (
	// CreateVMIfNotFound ...
	CreateVMIfNotFound AlternateLocationRecoveryOption = "CreateVmIfNotFound"
	// NoAction ...
	NoAction AlternateLocationRecoveryOption = "NoAction"
)

// PossibleAlternateLocationRecoveryOptionValues returns an array of possible values for the AlternateLocationRecoveryOption const type.
func PossibleAlternateLocationRecoveryOptionValues() []AlternateLocationRecoveryOption {
	return []AlternateLocationRecoveryOption{CreateVMIfNotFound, NoAction}
}

// DataSyncStatus enumerates the values for data sync status.
type DataSyncStatus string

const (
	// ForDownTime ...
	ForDownTime DataSyncStatus = "ForDownTime"
	// ForSynchronization ...
	ForSynchronization DataSyncStatus = "ForSynchronization"
)

// PossibleDataSyncStatusValues returns an array of possible values for the DataSyncStatus const type.
func PossibleDataSyncStatusValues() []DataSyncStatus {
	return []DataSyncStatus{ForDownTime, ForSynchronization}
}

// DisableProtectionReason enumerates the values for disable protection reason.
type DisableProtectionReason string

const (
	// MigrationComplete ...
	MigrationComplete DisableProtectionReason = "MigrationComplete"
	// NotSpecified ...
	NotSpecified DisableProtectionReason = "NotSpecified"
)

// PossibleDisableProtectionReasonValues returns an array of possible values for the DisableProtectionReason const type.
func PossibleDisableProtectionReasonValues() []DisableProtectionReason {
	return []DisableProtectionReason{MigrationComplete, NotSpecified}
}

// FailoverDeploymentModel enumerates the values for failover deployment model.
type FailoverDeploymentModel string

const (
	// Classic ...
	Classic FailoverDeploymentModel = "Classic"
	// NotApplicable ...
	NotApplicable FailoverDeploymentModel = "NotApplicable"
	// ResourceManager ...
	ResourceManager FailoverDeploymentModel = "ResourceManager"
)

// PossibleFailoverDeploymentModelValues returns an array of possible values for the FailoverDeploymentModel const type.
func PossibleFailoverDeploymentModelValues() []FailoverDeploymentModel {
	return []FailoverDeploymentModel{Classic, NotApplicable, ResourceManager}
}

// HealthErrorCategory enumerates the values for health error category.
type HealthErrorCategory string

const (
	// Configuration ...
	Configuration HealthErrorCategory = "Configuration"
	// Replication ...
	Replication HealthErrorCategory = "Replication"
	// TestFailover ...
	TestFailover HealthErrorCategory = "TestFailover"
)

// PossibleHealthErrorCategoryValues returns an array of possible values for the HealthErrorCategory const type.
func PossibleHealthErrorCategoryValues() []HealthErrorCategory {
	return []HealthErrorCategory{Configuration, Replication, TestFailover}
}

// HyperVReplicaAzureRpRecoveryPointType enumerates the values for hyper v replica azure rp recovery point
// type.
type HyperVReplicaAzureRpRecoveryPointType string

const (
	// HyperVReplicaAzureRpRecoveryPointTypeLatest ...
	HyperVReplicaAzureRpRecoveryPointTypeLatest HyperVReplicaAzureRpRecoveryPointType = "Latest"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent ...
	HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent HyperVReplicaAzureRpRecoveryPointType = "LatestApplicationConsistent"
	// HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed ...
	HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed HyperVReplicaAzureRpRecoveryPointType = "LatestProcessed"
)

// PossibleHyperVReplicaAzureRpRecoveryPointTypeValues returns an array of possible values for the HyperVReplicaAzureRpRecoveryPointType const type.
func PossibleHyperVReplicaAzureRpRecoveryPointTypeValues() []HyperVReplicaAzureRpRecoveryPointType {
	return []HyperVReplicaAzureRpRecoveryPointType{HyperVReplicaAzureRpRecoveryPointTypeLatest, HyperVReplicaAzureRpRecoveryPointTypeLatestApplicationConsistent, HyperVReplicaAzureRpRecoveryPointTypeLatestProcessed}
}

// IdentityProviderType enumerates the values for identity provider type.
type IdentityProviderType string

const (
	// CustomerActiveDirectory ...
	CustomerActiveDirectory IdentityProviderType = "CustomerActiveDirectory"
	// RecoveryServicesActiveDirectory ...
	RecoveryServicesActiveDirectory IdentityProviderType = "RecoveryServicesActiveDirectory"
)

// PossibleIdentityProviderTypeValues returns an array of possible values for the IdentityProviderType const type.
func PossibleIdentityProviderTypeValues() []IdentityProviderType {
	return []IdentityProviderType{CustomerActiveDirectory, RecoveryServicesActiveDirectory}
}

// InMageV2RpRecoveryPointType enumerates the values for in mage v2 rp recovery point type.
type InMageV2RpRecoveryPointType string

const (
	// InMageV2RpRecoveryPointTypeLatest ...
	InMageV2RpRecoveryPointTypeLatest InMageV2RpRecoveryPointType = "Latest"
	// InMageV2RpRecoveryPointTypeLatestApplicationConsistent ...
	InMageV2RpRecoveryPointTypeLatestApplicationConsistent InMageV2RpRecoveryPointType = "LatestApplicationConsistent"
	// InMageV2RpRecoveryPointTypeLatestCrashConsistent ...
	InMageV2RpRecoveryPointTypeLatestCrashConsistent InMageV2RpRecoveryPointType = "LatestCrashConsistent"
	// InMageV2RpRecoveryPointTypeLatestProcessed ...
	InMageV2RpRecoveryPointTypeLatestProcessed InMageV2RpRecoveryPointType = "LatestProcessed"
)

// PossibleInMageV2RpRecoveryPointTypeValues returns an array of possible values for the InMageV2RpRecoveryPointType const type.
func PossibleInMageV2RpRecoveryPointTypeValues() []InMageV2RpRecoveryPointType {
	return []InMageV2RpRecoveryPointType{InMageV2RpRecoveryPointTypeLatest, InMageV2RpRecoveryPointTypeLatestApplicationConsistent, InMageV2RpRecoveryPointTypeLatestCrashConsistent, InMageV2RpRecoveryPointTypeLatestProcessed}
}

// InstanceType enumerates the values for instance type.
type InstanceType string

const (
	// InstanceTypeA2A ...
	InstanceTypeA2A InstanceType = "A2A"
	// InstanceTypeEventProviderSpecificDetails ...
	InstanceTypeEventProviderSpecificDetails InstanceType = "EventProviderSpecificDetails"
	// InstanceTypeHyperVReplica2012 ...
	InstanceTypeHyperVReplica2012 InstanceType = "HyperVReplica2012"
	// InstanceTypeHyperVReplica2012R2 ...
	InstanceTypeHyperVReplica2012R2 InstanceType = "HyperVReplica2012R2"
	// InstanceTypeHyperVReplicaAzure ...
	InstanceTypeHyperVReplicaAzure InstanceType = "HyperVReplicaAzure"
	// InstanceTypeHyperVReplicaBaseEventDetails ...
	InstanceTypeHyperVReplicaBaseEventDetails InstanceType = "HyperVReplicaBaseEventDetails"
	// InstanceTypeInMageAzureV2 ...
	InstanceTypeInMageAzureV2 InstanceType = "InMageAzureV2"
)

// PossibleInstanceTypeValues returns an array of possible values for the InstanceType const type.
func PossibleInstanceTypeValues() []InstanceType {
	return []InstanceType{InstanceTypeA2A, InstanceTypeEventProviderSpecificDetails, InstanceTypeHyperVReplica2012, InstanceTypeHyperVReplica2012R2, InstanceTypeHyperVReplicaAzure, InstanceTypeHyperVReplicaBaseEventDetails, InstanceTypeInMageAzureV2}
}

// InstanceTypeBasicApplyRecoveryPointProviderSpecificInput enumerates the values for instance type basic apply
// recovery point provider specific input.
type InstanceTypeBasicApplyRecoveryPointProviderSpecificInput string

const (
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "A2A"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "ApplyRecoveryPointProviderSpecificInput"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicApplyRecoveryPointProviderSpecificInput = "InMageAzureV2"
)

// PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicApplyRecoveryPointProviderSpecificInput const type.
func PossibleInstanceTypeBasicApplyRecoveryPointProviderSpecificInputValues() []InstanceTypeBasicApplyRecoveryPointProviderSpecificInput {
	return []InstanceTypeBasicApplyRecoveryPointProviderSpecificInput{InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeApplyRecoveryPointProviderSpecificInput, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicApplyRecoveryPointProviderSpecificInputInstanceTypeInMageAzureV2}
}

// InstanceTypeBasicConfigurationSettings enumerates the values for instance type basic configuration settings.
type InstanceTypeBasicConfigurationSettings string

const (
	// InstanceTypeConfigurationSettings ...
	InstanceTypeConfigurationSettings InstanceTypeBasicConfigurationSettings = "ConfigurationSettings"
	// InstanceTypeHyperVVirtualMachine ...
	InstanceTypeHyperVVirtualMachine InstanceTypeBasicConfigurationSettings = "HyperVVirtualMachine"
	// InstanceTypeReplicationGroupDetails ...
	InstanceTypeReplicationGroupDetails InstanceTypeBasicConfigurationSettings = "ReplicationGroupDetails"
	// InstanceTypeVMwareVirtualMachine ...
	InstanceTypeVMwareVirtualMachine InstanceTypeBasicConfigurationSettings = "VMwareVirtualMachine"
)

// PossibleInstanceTypeBasicConfigurationSettingsValues returns an array of possible values for the InstanceTypeBasicConfigurationSettings const type.
func PossibleInstanceTypeBasicConfigurationSettingsValues() []InstanceTypeBasicConfigurationSettings {
	return []InstanceTypeBasicConfigurationSettings{InstanceTypeConfigurationSettings, InstanceTypeHyperVVirtualMachine, InstanceTypeReplicationGroupDetails, InstanceTypeVMwareVirtualMachine}
}

// InstanceTypeBasicDisableProtectionProviderSpecificInput enumerates the values for instance type basic
// disable protection provider specific input.
type InstanceTypeBasicDisableProtectionProviderSpecificInput string

const (
	// InstanceTypeDisableProtectionProviderSpecificInput ...
	InstanceTypeDisableProtectionProviderSpecificInput InstanceTypeBasicDisableProtectionProviderSpecificInput = "DisableProtectionProviderSpecificInput"
	// InstanceTypeInMage ...
	InstanceTypeInMage InstanceTypeBasicDisableProtectionProviderSpecificInput = "InMage"
)

// PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicDisableProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicDisableProtectionProviderSpecificInputValues() []InstanceTypeBasicDisableProtectionProviderSpecificInput {
	return []InstanceTypeBasicDisableProtectionProviderSpecificInput{InstanceTypeDisableProtectionProviderSpecificInput, InstanceTypeInMage}
}

// InstanceTypeBasicEnableProtectionProviderSpecificInput enumerates the values for instance type basic enable
// protection provider specific input.
type InstanceTypeBasicEnableProtectionProviderSpecificInput string

const (
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A InstanceTypeBasicEnableProtectionProviderSpecificInput = "A2A"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput InstanceTypeBasicEnableProtectionProviderSpecificInput = "EnableProtectionProviderSpecificInput"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicEnableProtectionProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage InstanceTypeBasicEnableProtectionProviderSpecificInput = "InMage"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicEnableProtectionProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan ...
	InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan InstanceTypeBasicEnableProtectionProviderSpecificInput = "San"
)

// PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicEnableProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicEnableProtectionProviderSpecificInputValues() []InstanceTypeBasicEnableProtectionProviderSpecificInput {
	return []InstanceTypeBasicEnableProtectionProviderSpecificInput{InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeEnableProtectionProviderSpecificInput, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicEnableProtectionProviderSpecificInputInstanceTypeSan}
}

// InstanceTypeBasicEventSpecificDetails enumerates the values for instance type basic event specific details.
type InstanceTypeBasicEventSpecificDetails string

const (
	// InstanceTypeEventSpecificDetails ...
	InstanceTypeEventSpecificDetails InstanceTypeBasicEventSpecificDetails = "EventSpecificDetails"
	// InstanceTypeJobStatus ...
	InstanceTypeJobStatus InstanceTypeBasicEventSpecificDetails = "JobStatus"
)

// PossibleInstanceTypeBasicEventSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicEventSpecificDetails const type.
func PossibleInstanceTypeBasicEventSpecificDetailsValues() []InstanceTypeBasicEventSpecificDetails {
	return []InstanceTypeBasicEventSpecificDetails{InstanceTypeEventSpecificDetails, InstanceTypeJobStatus}
}

// InstanceTypeBasicFabricSpecificCreateNetworkMappingInput enumerates the values for instance type basic
// fabric specific create network mapping input.
type InstanceTypeBasicFabricSpecificCreateNetworkMappingInput string

const (
	// InstanceTypeAzureToAzure ...
	InstanceTypeAzureToAzure InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeFabricSpecificCreateNetworkMappingInput ...
	InstanceTypeFabricSpecificCreateNetworkMappingInput InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "FabricSpecificCreateNetworkMappingInput"
	// InstanceTypeVmmToAzure ...
	InstanceTypeVmmToAzure InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeVmmToVmm ...
	InstanceTypeVmmToVmm InstanceTypeBasicFabricSpecificCreateNetworkMappingInput = "VmmToVmm"
)

// PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificCreateNetworkMappingInput const type.
func PossibleInstanceTypeBasicFabricSpecificCreateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput {
	return []InstanceTypeBasicFabricSpecificCreateNetworkMappingInput{InstanceTypeAzureToAzure, InstanceTypeFabricSpecificCreateNetworkMappingInput, InstanceTypeVmmToAzure, InstanceTypeVmmToVmm}
}

// InstanceTypeBasicFabricSpecificCreationInput enumerates the values for instance type basic fabric specific
// creation input.
type InstanceTypeBasicFabricSpecificCreationInput string

const (
	// InstanceTypeAzure ...
	InstanceTypeAzure InstanceTypeBasicFabricSpecificCreationInput = "Azure"
	// InstanceTypeFabricSpecificCreationInput ...
	InstanceTypeFabricSpecificCreationInput InstanceTypeBasicFabricSpecificCreationInput = "FabricSpecificCreationInput"
	// InstanceTypeVMwareV2 ...
	InstanceTypeVMwareV2 InstanceTypeBasicFabricSpecificCreationInput = "VMwareV2"
)

// PossibleInstanceTypeBasicFabricSpecificCreationInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificCreationInput const type.
func PossibleInstanceTypeBasicFabricSpecificCreationInputValues() []InstanceTypeBasicFabricSpecificCreationInput {
	return []InstanceTypeBasicFabricSpecificCreationInput{InstanceTypeAzure, InstanceTypeFabricSpecificCreationInput, InstanceTypeVMwareV2}
}

// InstanceTypeBasicFabricSpecificDetails enumerates the values for instance type basic fabric specific
// details.
type InstanceTypeBasicFabricSpecificDetails string

const (
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure InstanceTypeBasicFabricSpecificDetails = "Azure"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails InstanceTypeBasicFabricSpecificDetails = "FabricSpecificDetails"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite InstanceTypeBasicFabricSpecificDetails = "HyperVSite"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM InstanceTypeBasicFabricSpecificDetails = "VMM"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware InstanceTypeBasicFabricSpecificDetails = "VMware"
	// InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2 ...
	InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2 InstanceTypeBasicFabricSpecificDetails = "VMwareV2"
)

// PossibleInstanceTypeBasicFabricSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicFabricSpecificDetails const type.
func PossibleInstanceTypeBasicFabricSpecificDetailsValues() []InstanceTypeBasicFabricSpecificDetails {
	return []InstanceTypeBasicFabricSpecificDetails{InstanceTypeBasicFabricSpecificDetailsInstanceTypeAzure, InstanceTypeBasicFabricSpecificDetailsInstanceTypeFabricSpecificDetails, InstanceTypeBasicFabricSpecificDetailsInstanceTypeHyperVSite, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMM, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMware, InstanceTypeBasicFabricSpecificDetailsInstanceTypeVMwareV2}
}

// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput enumerates the values for instance type basic
// fabric specific update network mapping input.
type InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput string

const (
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "AzureToAzure"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "FabricSpecificUpdateNetworkMappingInput"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "VmmToAzure"
	// InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm ...
	InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput = "VmmToVmm"
)

// PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues returns an array of possible values for the InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput const type.
func PossibleInstanceTypeBasicFabricSpecificUpdateNetworkMappingInputValues() []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput {
	return []InstanceTypeBasicFabricSpecificUpdateNetworkMappingInput{InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeAzureToAzure, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeFabricSpecificUpdateNetworkMappingInput, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToAzure, InstanceTypeBasicFabricSpecificUpdateNetworkMappingInputInstanceTypeVmmToVmm}
}

// InstanceTypeBasicGroupTaskDetails enumerates the values for instance type basic group task details.
type InstanceTypeBasicGroupTaskDetails string

const (
	// InstanceTypeGroupTaskDetails ...
	InstanceTypeGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "GroupTaskDetails"
	// InstanceTypeInlineWorkflowTaskDetails ...
	InstanceTypeInlineWorkflowTaskDetails InstanceTypeBasicGroupTaskDetails = "InlineWorkflowTaskDetails"
	// InstanceTypeRecoveryPlanGroupTaskDetails ...
	InstanceTypeRecoveryPlanGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "RecoveryPlanGroupTaskDetails"
	// InstanceTypeRecoveryPlanShutdownGroupTaskDetails ...
	InstanceTypeRecoveryPlanShutdownGroupTaskDetails InstanceTypeBasicGroupTaskDetails = "RecoveryPlanShutdownGroupTaskDetails"
)

// PossibleInstanceTypeBasicGroupTaskDetailsValues returns an array of possible values for the InstanceTypeBasicGroupTaskDetails const type.
func PossibleInstanceTypeBasicGroupTaskDetailsValues() []InstanceTypeBasicGroupTaskDetails {
	return []InstanceTypeBasicGroupTaskDetails{InstanceTypeGroupTaskDetails, InstanceTypeInlineWorkflowTaskDetails, InstanceTypeRecoveryPlanGroupTaskDetails, InstanceTypeRecoveryPlanShutdownGroupTaskDetails}
}

// InstanceTypeBasicJobDetails enumerates the values for instance type basic job details.
type InstanceTypeBasicJobDetails string

const (
	// InstanceTypeAsrJobDetails ...
	InstanceTypeAsrJobDetails InstanceTypeBasicJobDetails = "AsrJobDetails"
	// InstanceTypeExportJobDetails ...
	InstanceTypeExportJobDetails InstanceTypeBasicJobDetails = "ExportJobDetails"
	// InstanceTypeFailoverJobDetails ...
	InstanceTypeFailoverJobDetails InstanceTypeBasicJobDetails = "FailoverJobDetails"
	// InstanceTypeJobDetails ...
	InstanceTypeJobDetails InstanceTypeBasicJobDetails = "JobDetails"
	// InstanceTypeSwitchProtectionJobDetails ...
	InstanceTypeSwitchProtectionJobDetails InstanceTypeBasicJobDetails = "SwitchProtectionJobDetails"
	// InstanceTypeTestFailoverJobDetails ...
	InstanceTypeTestFailoverJobDetails InstanceTypeBasicJobDetails = "TestFailoverJobDetails"
)

// PossibleInstanceTypeBasicJobDetailsValues returns an array of possible values for the InstanceTypeBasicJobDetails const type.
func PossibleInstanceTypeBasicJobDetailsValues() []InstanceTypeBasicJobDetails {
	return []InstanceTypeBasicJobDetails{InstanceTypeAsrJobDetails, InstanceTypeExportJobDetails, InstanceTypeFailoverJobDetails, InstanceTypeJobDetails, InstanceTypeSwitchProtectionJobDetails, InstanceTypeTestFailoverJobDetails}
}

// InstanceTypeBasicNetworkMappingFabricSpecificSettings enumerates the values for instance type basic network
// mapping fabric specific settings.
type InstanceTypeBasicNetworkMappingFabricSpecificSettings string

const (
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure InstanceTypeBasicNetworkMappingFabricSpecificSettings = "AzureToAzure"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings InstanceTypeBasicNetworkMappingFabricSpecificSettings = "NetworkMappingFabricSpecificSettings"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure InstanceTypeBasicNetworkMappingFabricSpecificSettings = "VmmToAzure"
	// InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm ...
	InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm InstanceTypeBasicNetworkMappingFabricSpecificSettings = "VmmToVmm"
)

// PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues returns an array of possible values for the InstanceTypeBasicNetworkMappingFabricSpecificSettings const type.
func PossibleInstanceTypeBasicNetworkMappingFabricSpecificSettingsValues() []InstanceTypeBasicNetworkMappingFabricSpecificSettings {
	return []InstanceTypeBasicNetworkMappingFabricSpecificSettings{InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeAzureToAzure, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeNetworkMappingFabricSpecificSettings, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToAzure, InstanceTypeBasicNetworkMappingFabricSpecificSettingsInstanceTypeVmmToVmm}
}

// InstanceTypeBasicPolicyProviderSpecificDetails enumerates the values for instance type basic policy provider
// specific details.
type InstanceTypeBasicPolicyProviderSpecificDetails string

const (
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A InstanceTypeBasicPolicyProviderSpecificDetails = "A2A"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012 InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplica2012"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2 InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplica2012R2"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplicaAzure"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = "HyperVReplicaBasePolicyDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage InstanceTypeBasicPolicyProviderSpecificDetails = "InMage"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2 InstanceTypeBasicPolicyProviderSpecificDetails = "InMageAzureV2"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails InstanceTypeBasicPolicyProviderSpecificDetails = "InMageBasePolicyDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails InstanceTypeBasicPolicyProviderSpecificDetails = "PolicyProviderSpecificDetails"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration InstanceTypeBasicPolicyProviderSpecificDetails = "RcmAzureMigration"
	// InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt ...
	InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt InstanceTypeBasicPolicyProviderSpecificDetails = "VMwareCbt"
)

// PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues returns an array of possible values for the InstanceTypeBasicPolicyProviderSpecificDetails const type.
func PossibleInstanceTypeBasicPolicyProviderSpecificDetailsValues() []InstanceTypeBasicPolicyProviderSpecificDetails {
	return []InstanceTypeBasicPolicyProviderSpecificDetails{InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeA2A, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplica2012R2, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaAzure, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeHyperVReplicaBasePolicyDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMage, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageAzureV2, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeInMageBasePolicyDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypePolicyProviderSpecificDetails, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeRcmAzureMigration, InstanceTypeBasicPolicyProviderSpecificDetailsInstanceTypeVMwareCbt}
}

// InstanceTypeBasicPolicyProviderSpecificInput enumerates the values for instance type basic policy provider
// specific input.
type InstanceTypeBasicPolicyProviderSpecificInput string

const (
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A InstanceTypeBasicPolicyProviderSpecificInput = "A2A"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012 InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplica2012"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2 InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplica2012R2"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicPolicyProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage InstanceTypeBasicPolicyProviderSpecificInput = "InMage"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicPolicyProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput InstanceTypeBasicPolicyProviderSpecificInput = "PolicyProviderSpecificInput"
	// InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt ...
	InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt InstanceTypeBasicPolicyProviderSpecificInput = "VMwareCbt"
)

// PossibleInstanceTypeBasicPolicyProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicPolicyProviderSpecificInput const type.
func PossibleInstanceTypeBasicPolicyProviderSpecificInputValues() []InstanceTypeBasicPolicyProviderSpecificInput {
	return []InstanceTypeBasicPolicyProviderSpecificInput{InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplica2012R2, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypePolicyProviderSpecificInput, InstanceTypeBasicPolicyProviderSpecificInputInstanceTypeVMwareCbt}
}

// InstanceTypeBasicProviderSpecificFailoverInput enumerates the values for instance type basic provider
// specific failover input.
type InstanceTypeBasicProviderSpecificFailoverInput string

const (
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeBasicProviderSpecificFailoverInput = "A2A"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeBasicProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeBasicProviderSpecificFailoverInput = "InMage"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeBasicProviderSpecificFailoverInput = "InMageAzureV2"
	// InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput ...
	InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput InstanceTypeBasicProviderSpecificFailoverInput = "ProviderSpecificFailoverInput"
)

// PossibleInstanceTypeBasicProviderSpecificFailoverInputValues returns an array of possible values for the InstanceTypeBasicProviderSpecificFailoverInput const type.
func PossibleInstanceTypeBasicProviderSpecificFailoverInputValues() []InstanceTypeBasicProviderSpecificFailoverInput {
	return []InstanceTypeBasicProviderSpecificFailoverInput{InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeA2A, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMage, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeInMageAzureV2, InstanceTypeBasicProviderSpecificFailoverInputInstanceTypeProviderSpecificFailoverInput}
}

// InstanceTypeBasicRecoveryPlanActionDetails enumerates the values for instance type basic recovery plan
// action details.
type InstanceTypeBasicRecoveryPlanActionDetails string

const (
	// InstanceTypeAutomationRunbookActionDetails ...
	InstanceTypeAutomationRunbookActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "AutomationRunbookActionDetails"
	// InstanceTypeManualActionDetails ...
	InstanceTypeManualActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "ManualActionDetails"
	// InstanceTypeRecoveryPlanActionDetails ...
	InstanceTypeRecoveryPlanActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "RecoveryPlanActionDetails"
	// InstanceTypeScriptActionDetails ...
	InstanceTypeScriptActionDetails InstanceTypeBasicRecoveryPlanActionDetails = "ScriptActionDetails"
)

// PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues returns an array of possible values for the InstanceTypeBasicRecoveryPlanActionDetails const type.
func PossibleInstanceTypeBasicRecoveryPlanActionDetailsValues() []InstanceTypeBasicRecoveryPlanActionDetails {
	return []InstanceTypeBasicRecoveryPlanActionDetails{InstanceTypeAutomationRunbookActionDetails, InstanceTypeManualActionDetails, InstanceTypeRecoveryPlanActionDetails, InstanceTypeScriptActionDetails}
}

// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput enumerates the values for instance type basic
// recovery plan provider specific failover input.
type InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput string

const (
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "A2A"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzure"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "HyperVReplicaAzureFailback"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "InMage"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2 InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "InMageAzureV2"
	// InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput ...
	InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput = "RecoveryPlanProviderSpecificFailoverInput"
)

// PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues returns an array of possible values for the InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput const type.
func PossibleInstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputValues() []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput {
	return []InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInput{InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeA2A, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeHyperVReplicaAzureFailback, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMage, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeInMageAzureV2, InstanceTypeBasicRecoveryPlanProviderSpecificFailoverInputInstanceTypeRecoveryPlanProviderSpecificFailoverInput}
}

// InstanceTypeBasicReplicationProviderSpecificContainerCreationInput enumerates the values for instance type
// basic replication provider specific container creation input.
type InstanceTypeBasicReplicationProviderSpecificContainerCreationInput string

const (
	// InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A ...
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = "A2A"
	// InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput ...
	InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput InstanceTypeBasicReplicationProviderSpecificContainerCreationInput = "ReplicationProviderSpecificContainerCreationInput"
)

// PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues returns an array of possible values for the InstanceTypeBasicReplicationProviderSpecificContainerCreationInput const type.
func PossibleInstanceTypeBasicReplicationProviderSpecificContainerCreationInputValues() []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput {
	return []InstanceTypeBasicReplicationProviderSpecificContainerCreationInput{InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeA2A, InstanceTypeBasicReplicationProviderSpecificContainerCreationInputInstanceTypeReplicationProviderSpecificContainerCreationInput}
}

// InstanceTypeBasicReplicationProviderSpecificSettings enumerates the values for instance type basic
// replication provider specific settings.
type InstanceTypeBasicReplicationProviderSpecificSettings string

const (
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A InstanceTypeBasicReplicationProviderSpecificSettings = "A2A"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012 InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplica2012"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2 InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplica2012R2"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplicaAzure"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails InstanceTypeBasicReplicationProviderSpecificSettings = "HyperVReplicaBaseReplicationDetails"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage InstanceTypeBasicReplicationProviderSpecificSettings = "InMage"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2 InstanceTypeBasicReplicationProviderSpecificSettings = "InMageAzureV2"
	// InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings ...
	InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings InstanceTypeBasicReplicationProviderSpecificSettings = "ReplicationProviderSpecificSettings"
)

// PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues returns an array of possible values for the InstanceTypeBasicReplicationProviderSpecificSettings const type.
func PossibleInstanceTypeBasicReplicationProviderSpecificSettingsValues() []InstanceTypeBasicReplicationProviderSpecificSettings {
	return []InstanceTypeBasicReplicationProviderSpecificSettings{InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeA2A, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplica2012R2, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaAzure, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeHyperVReplicaBaseReplicationDetails, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMage, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeInMageAzureV2, InstanceTypeBasicReplicationProviderSpecificSettingsInstanceTypeReplicationProviderSpecificSettings}
}

// InstanceTypeBasicReverseReplicationProviderSpecificInput enumerates the values for instance type basic
// reverse replication provider specific input.
type InstanceTypeBasicReverseReplicationProviderSpecificInput string

const (
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A InstanceTypeBasicReverseReplicationProviderSpecificInput = "A2A"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicReverseReplicationProviderSpecificInput = "HyperVReplicaAzure"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage InstanceTypeBasicReverseReplicationProviderSpecificInput = "InMage"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2 InstanceTypeBasicReverseReplicationProviderSpecificInput = "InMageAzureV2"
	// InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput ...
	InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput InstanceTypeBasicReverseReplicationProviderSpecificInput = "ReverseReplicationProviderSpecificInput"
)

// PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicReverseReplicationProviderSpecificInput const type.
func PossibleInstanceTypeBasicReverseReplicationProviderSpecificInputValues() []InstanceTypeBasicReverseReplicationProviderSpecificInput {
	return []InstanceTypeBasicReverseReplicationProviderSpecificInput{InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMage, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeInMageAzureV2, InstanceTypeBasicReverseReplicationProviderSpecificInputInstanceTypeReverseReplicationProviderSpecificInput}
}

// InstanceTypeBasicSwitchProtectionProviderSpecificInput enumerates the values for instance type basic switch
// protection provider specific input.
type InstanceTypeBasicSwitchProtectionProviderSpecificInput string

const (
	// InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A ...
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A InstanceTypeBasicSwitchProtectionProviderSpecificInput = "A2A"
	// InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput ...
	InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput InstanceTypeBasicSwitchProtectionProviderSpecificInput = "SwitchProtectionProviderSpecificInput"
)

// PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues returns an array of possible values for the InstanceTypeBasicSwitchProtectionProviderSpecificInput const type.
func PossibleInstanceTypeBasicSwitchProtectionProviderSpecificInputValues() []InstanceTypeBasicSwitchProtectionProviderSpecificInput {
	return []InstanceTypeBasicSwitchProtectionProviderSpecificInput{InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeA2A, InstanceTypeBasicSwitchProtectionProviderSpecificInputInstanceTypeSwitchProtectionProviderSpecificInput}
}

// InstanceTypeBasicTaskTypeDetails enumerates the values for instance type basic task type details.
type InstanceTypeBasicTaskTypeDetails string

const (
	// InstanceTypeAutomationRunbookTaskDetails ...
	InstanceTypeAutomationRunbookTaskDetails InstanceTypeBasicTaskTypeDetails = "AutomationRunbookTaskDetails"
	// InstanceTypeConsistencyCheckTaskDetails ...
	InstanceTypeConsistencyCheckTaskDetails InstanceTypeBasicTaskTypeDetails = "ConsistencyCheckTaskDetails"
	// InstanceTypeFabricReplicationGroupTaskDetails ...
	InstanceTypeFabricReplicationGroupTaskDetails InstanceTypeBasicTaskTypeDetails = "FabricReplicationGroupTaskDetails"
	// InstanceTypeJobTaskDetails ...
	InstanceTypeJobTaskDetails InstanceTypeBasicTaskTypeDetails = "JobTaskDetails"
	// InstanceTypeManualActionTaskDetails ...
	InstanceTypeManualActionTaskDetails InstanceTypeBasicTaskTypeDetails = "ManualActionTaskDetails"
	// InstanceTypeScriptActionTaskDetails ...
	InstanceTypeScriptActionTaskDetails InstanceTypeBasicTaskTypeDetails = "ScriptActionTaskDetails"
	// InstanceTypeTaskTypeDetails ...
	InstanceTypeTaskTypeDetails InstanceTypeBasicTaskTypeDetails = "TaskTypeDetails"
	// InstanceTypeVirtualMachineTaskDetails ...
	InstanceTypeVirtualMachineTaskDetails InstanceTypeBasicTaskTypeDetails = "VirtualMachineTaskDetails"
	// InstanceTypeVMNicUpdatesTaskDetails ...
	InstanceTypeVMNicUpdatesTaskDetails InstanceTypeBasicTaskTypeDetails = "VmNicUpdatesTaskDetails"
)

// PossibleInstanceTypeBasicTaskTypeDetailsValues returns an array of possible values for the InstanceTypeBasicTaskTypeDetails const type.
func PossibleInstanceTypeBasicTaskTypeDetailsValues() []InstanceTypeBasicTaskTypeDetails {
	return []InstanceTypeBasicTaskTypeDetails{InstanceTypeAutomationRunbookTaskDetails, InstanceTypeConsistencyCheckTaskDetails, InstanceTypeFabricReplicationGroupTaskDetails, InstanceTypeJobTaskDetails, InstanceTypeManualActionTaskDetails, InstanceTypeScriptActionTaskDetails, InstanceTypeTaskTypeDetails, InstanceTypeVirtualMachineTaskDetails, InstanceTypeVMNicUpdatesTaskDetails}
}

// InstanceTypeBasicUpdateReplicationProtectedItemProviderInput enumerates the values for instance type basic
// update replication protected item provider input.
type InstanceTypeBasicUpdateReplicationProtectedItemProviderInput string

const (
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "A2A"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "HyperVReplicaAzure"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2 ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2 InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "InMageAzureV2"
	// InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput ...
	InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput InstanceTypeBasicUpdateReplicationProtectedItemProviderInput = "UpdateReplicationProtectedItemProviderInput"
)

// PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues returns an array of possible values for the InstanceTypeBasicUpdateReplicationProtectedItemProviderInput const type.
func PossibleInstanceTypeBasicUpdateReplicationProtectedItemProviderInputValues() []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput {
	return []InstanceTypeBasicUpdateReplicationProtectedItemProviderInput{InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeA2A, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeHyperVReplicaAzure, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeInMageAzureV2, InstanceTypeBasicUpdateReplicationProtectedItemProviderInputInstanceTypeUpdateReplicationProtectedItemProviderInput}
}

// LicenseType enumerates the values for license type.
type LicenseType string

const (
	// LicenseTypeNoLicenseType ...
	LicenseTypeNoLicenseType LicenseType = "NoLicenseType"
	// LicenseTypeNotSpecified ...
	LicenseTypeNotSpecified LicenseType = "NotSpecified"
	// LicenseTypeWindowsServer ...
	LicenseTypeWindowsServer LicenseType = "WindowsServer"
)

// PossibleLicenseTypeValues returns an array of possible values for the LicenseType const type.
func PossibleLicenseTypeValues() []LicenseType {
	return []LicenseType{LicenseTypeNoLicenseType, LicenseTypeNotSpecified, LicenseTypeWindowsServer}
}

// MultiVMSyncStatus enumerates the values for multi vm sync status.
type MultiVMSyncStatus string

const (
	// Disabled ...
	Disabled MultiVMSyncStatus = "Disabled"
	// Enabled ...
	Enabled MultiVMSyncStatus = "Enabled"
)

// PossibleMultiVMSyncStatusValues returns an array of possible values for the MultiVMSyncStatus const type.
func PossibleMultiVMSyncStatusValues() []MultiVMSyncStatus {
	return []MultiVMSyncStatus{Disabled, Enabled}
}

// PossibleOperationsDirections enumerates the values for possible operations directions.
type PossibleOperationsDirections string

const (
	// PrimaryToRecovery ...
	PrimaryToRecovery PossibleOperationsDirections = "PrimaryToRecovery"
	// RecoveryToPrimary ...
	RecoveryToPrimary PossibleOperationsDirections = "RecoveryToPrimary"
)

// PossiblePossibleOperationsDirectionsValues returns an array of possible values for the PossibleOperationsDirections const type.
func PossiblePossibleOperationsDirectionsValues() []PossibleOperationsDirections {
	return []PossibleOperationsDirections{PrimaryToRecovery, RecoveryToPrimary}
}

// RecoveryPlanActionLocation enumerates the values for recovery plan action location.
type RecoveryPlanActionLocation string

const (
	// Primary ...
	Primary RecoveryPlanActionLocation = "Primary"
	// Recovery ...
	Recovery RecoveryPlanActionLocation = "Recovery"
)

// PossibleRecoveryPlanActionLocationValues returns an array of possible values for the RecoveryPlanActionLocation const type.
func PossibleRecoveryPlanActionLocationValues() []RecoveryPlanActionLocation {
	return []RecoveryPlanActionLocation{Primary, Recovery}
}

// RecoveryPlanGroupType enumerates the values for recovery plan group type.
type RecoveryPlanGroupType string

const (
	// Boot ...
	Boot RecoveryPlanGroupType = "Boot"
	// Failover ...
	Failover RecoveryPlanGroupType = "Failover"
	// Shutdown ...
	Shutdown RecoveryPlanGroupType = "Shutdown"
)

// PossibleRecoveryPlanGroupTypeValues returns an array of possible values for the RecoveryPlanGroupType const type.
func PossibleRecoveryPlanGroupTypeValues() []RecoveryPlanGroupType {
	return []RecoveryPlanGroupType{Boot, Failover, Shutdown}
}

// RecoveryPointType enumerates the values for recovery point type.
type RecoveryPointType string

const (
	// Custom ...
	Custom RecoveryPointType = "Custom"
	// LatestTag ...
	LatestTag RecoveryPointType = "LatestTag"
	// LatestTime ...
	LatestTime RecoveryPointType = "LatestTime"
)

// PossibleRecoveryPointTypeValues returns an array of possible values for the RecoveryPointType const type.
func PossibleRecoveryPointTypeValues() []RecoveryPointType {
	return []RecoveryPointType{Custom, LatestTag, LatestTime}
}

// ReplicationProtectedItemOperation enumerates the values for replication protected item operation.
type ReplicationProtectedItemOperation string

const (
	// ReplicationProtectedItemOperationChangePit ...
	ReplicationProtectedItemOperationChangePit ReplicationProtectedItemOperation = "ChangePit"
	// ReplicationProtectedItemOperationCommit ...
	ReplicationProtectedItemOperationCommit ReplicationProtectedItemOperation = "Commit"
	// ReplicationProtectedItemOperationCompleteMigration ...
	ReplicationProtectedItemOperationCompleteMigration ReplicationProtectedItemOperation = "CompleteMigration"
	// ReplicationProtectedItemOperationDisableProtection ...
	ReplicationProtectedItemOperationDisableProtection ReplicationProtectedItemOperation = "DisableProtection"
	// ReplicationProtectedItemOperationFailback ...
	ReplicationProtectedItemOperationFailback ReplicationProtectedItemOperation = "Failback"
	// ReplicationProtectedItemOperationFinalizeFailback ...
	ReplicationProtectedItemOperationFinalizeFailback ReplicationProtectedItemOperation = "FinalizeFailback"
	// ReplicationProtectedItemOperationPlannedFailover ...
	ReplicationProtectedItemOperationPlannedFailover ReplicationProtectedItemOperation = "PlannedFailover"
	// ReplicationProtectedItemOperationRepairReplication ...
	ReplicationProtectedItemOperationRepairReplication ReplicationProtectedItemOperation = "RepairReplication"
	// ReplicationProtectedItemOperationReverseReplicate ...
	ReplicationProtectedItemOperationReverseReplicate ReplicationProtectedItemOperation = "ReverseReplicate"
	// ReplicationProtectedItemOperationSwitchProtection ...
	ReplicationProtectedItemOperationSwitchProtection ReplicationProtectedItemOperation = "SwitchProtection"
	// ReplicationProtectedItemOperationTestFailover ...
	ReplicationProtectedItemOperationTestFailover ReplicationProtectedItemOperation = "TestFailover"
	// ReplicationProtectedItemOperationTestFailoverCleanup ...
	ReplicationProtectedItemOperationTestFailoverCleanup ReplicationProtectedItemOperation = "TestFailoverCleanup"
	// ReplicationProtectedItemOperationUnplannedFailover ...
	ReplicationProtectedItemOperationUnplannedFailover ReplicationProtectedItemOperation = "UnplannedFailover"
)

// PossibleReplicationProtectedItemOperationValues returns an array of possible values for the ReplicationProtectedItemOperation const type.
func PossibleReplicationProtectedItemOperationValues() []ReplicationProtectedItemOperation {
	return []ReplicationProtectedItemOperation{ReplicationProtectedItemOperationChangePit, ReplicationProtectedItemOperationCommit, ReplicationProtectedItemOperationCompleteMigration, ReplicationProtectedItemOperationDisableProtection, ReplicationProtectedItemOperationFailback, ReplicationProtectedItemOperationFinalizeFailback, ReplicationProtectedItemOperationPlannedFailover, ReplicationProtectedItemOperationRepairReplication, ReplicationProtectedItemOperationReverseReplicate, ReplicationProtectedItemOperationSwitchProtection, ReplicationProtectedItemOperationTestFailover, ReplicationProtectedItemOperationTestFailoverCleanup, ReplicationProtectedItemOperationUnplannedFailover}
}

// RpInMageRecoveryPointType enumerates the values for rp in mage recovery point type.
type RpInMageRecoveryPointType string

const (
	// RpInMageRecoveryPointTypeCustom ...
	RpInMageRecoveryPointTypeCustom RpInMageRecoveryPointType = "Custom"
	// RpInMageRecoveryPointTypeLatestTag ...
	RpInMageRecoveryPointTypeLatestTag RpInMageRecoveryPointType = "LatestTag"
	// RpInMageRecoveryPointTypeLatestTime ...
	RpInMageRecoveryPointTypeLatestTime RpInMageRecoveryPointType = "LatestTime"
)

// PossibleRpInMageRecoveryPointTypeValues returns an array of possible values for the RpInMageRecoveryPointType const type.
func PossibleRpInMageRecoveryPointTypeValues() []RpInMageRecoveryPointType {
	return []RpInMageRecoveryPointType{RpInMageRecoveryPointTypeCustom, RpInMageRecoveryPointTypeLatestTag, RpInMageRecoveryPointTypeLatestTime}
}

// SetMultiVMSyncStatus enumerates the values for set multi vm sync status.
type SetMultiVMSyncStatus string

const (
	// Disable ...
	Disable SetMultiVMSyncStatus = "Disable"
	// Enable ...
	Enable SetMultiVMSyncStatus = "Enable"
)

// PossibleSetMultiVMSyncStatusValues returns an array of possible values for the SetMultiVMSyncStatus const type.
func PossibleSetMultiVMSyncStatusValues() []SetMultiVMSyncStatus {
	return []SetMultiVMSyncStatus{Disable, Enable}
}

// Severity enumerates the values for severity.
type Severity string

const (
	// Error ...
	Error Severity = "Error"
	// Info ...
	Info Severity = "Info"
	// NONE ...
	NONE Severity = "NONE"
	// Warning ...
	Warning Severity = "Warning"
)

// PossibleSeverityValues returns an array of possible values for the Severity const type.
func PossibleSeverityValues() []Severity {
	return []Severity{Error, Info, NONE, Warning}
}

// SourceSiteOperations enumerates the values for source site operations.
type SourceSiteOperations string

const (
	// NotRequired ...
	NotRequired SourceSiteOperations = "NotRequired"
	// Required ...
	Required SourceSiteOperations = "Required"
)

// PossibleSourceSiteOperationsValues returns an array of possible values for the SourceSiteOperations const type.
func PossibleSourceSiteOperationsValues() []SourceSiteOperations {
	return []SourceSiteOperations{NotRequired, Required}
}
