<!--
#
# Licensed to the Apache Software Foundation (ASF) under one or more
# contributor license agreements.  See the NOTICE file distributed with
# this work for additional information regarding copyright ownership.
# The ASF licenses this file to You under the Apache License, Version 2.0
# (the "License"); you may not use this file except in compliance with
# the License.  You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
-->

## CycloneDX schemas

For convenience, schemas are copied locally from:
- https://github.com/CycloneDX/specification/tree/master/schema

### Supported releases

| release tag (variant) | branch | schema file (git format) |
| :-- | :-- | :-- |
| [1.4](https://github.com/CycloneDX/specification/releases/tag/1.4) | https://github.com/CycloneDX/specification (master) | https://github.com/CycloneDX/specification/blob/master/schema/bom-1.4.schema.json |
| [1.3](https://github.com/CycloneDX/specification/releases/tag/1.3) | https://github.com/CycloneDX/specification (master) | https://github.com/CycloneDX/specification/blob/master/schema/bom-1.3.schema.json |
| [1.3 (strict)](https://github.com/CycloneDX/specification/releases/tag/1.3) | https://github.com/CycloneDX/specification (master) | https://github.com/CycloneDX/specification/blob/master/schema/bom-1.3-strict.schema.json |
| [1.2](https://github.com/CycloneDX/specification/releases/tag/1.2) | https://github.com/CycloneDX/specification (master) | https://github.com/CycloneDX/specification/blob/master/schema/bom-1.2.schema.json |

### Version comparisons

- [Document comparing schema 1.3 to 1.4](cdx-schema-delta-by-version.md)
