// Code generated by smithy-go-codegen DO NOT EDIT.

package cloudfront

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/cloudfront/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists distributions by trust store.
func (c *Client) ListDistributionsByTrustStore(ctx context.Context, params *ListDistributionsByTrustStoreInput, optFns ...func(*Options)) (*ListDistributionsByTrustStoreOutput, error) {
	if params == nil {
		params = &ListDistributionsByTrustStoreInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListDistributionsByTrustStore", params, optFns, c.addOperationListDistributionsByTrustStoreMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListDistributionsByTrustStoreOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListDistributionsByTrustStoreInput struct {

	// The distributions by trust store identifier.
	//
	// This member is required.
	TrustStoreIdentifier *string

	// Use this field when paginating results to indicate where to begin in your list.
	// The response includes items in the list that occur after the marker. To get the
	// next page of the list, set this field's value to the value of NextMarker from
	// the current page's response.
	Marker *string

	// The maximum number of distributions that you want returned in the response.
	MaxItems *int32

	noSmithyDocumentSerde
}

type ListDistributionsByTrustStoreOutput struct {

	// A distribution list.
	DistributionList *types.DistributionList

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListDistributionsByTrustStoreMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestxml_serializeOpListDistributionsByTrustStore{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestxml_deserializeOpListDistributionsByTrustStore{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListDistributionsByTrustStore"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListDistributionsByTrustStoreValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListDistributionsByTrustStore(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListDistributionsByTrustStorePaginatorOptions is the paginator options for
// ListDistributionsByTrustStore
type ListDistributionsByTrustStorePaginatorOptions struct {
	// The maximum number of distributions that you want returned in the response.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListDistributionsByTrustStorePaginator is a paginator for
// ListDistributionsByTrustStore
type ListDistributionsByTrustStorePaginator struct {
	options   ListDistributionsByTrustStorePaginatorOptions
	client    ListDistributionsByTrustStoreAPIClient
	params    *ListDistributionsByTrustStoreInput
	nextToken *string
	firstPage bool
}

// NewListDistributionsByTrustStorePaginator returns a new
// ListDistributionsByTrustStorePaginator
func NewListDistributionsByTrustStorePaginator(client ListDistributionsByTrustStoreAPIClient, params *ListDistributionsByTrustStoreInput, optFns ...func(*ListDistributionsByTrustStorePaginatorOptions)) *ListDistributionsByTrustStorePaginator {
	if params == nil {
		params = &ListDistributionsByTrustStoreInput{}
	}

	options := ListDistributionsByTrustStorePaginatorOptions{}
	if params.MaxItems != nil {
		options.Limit = *params.MaxItems
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListDistributionsByTrustStorePaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.Marker,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListDistributionsByTrustStorePaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListDistributionsByTrustStore page.
func (p *ListDistributionsByTrustStorePaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListDistributionsByTrustStoreOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.Marker = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxItems = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListDistributionsByTrustStore(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = nil
	if result.DistributionList != nil {
		p.nextToken = result.DistributionList.NextMarker
	}

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListDistributionsByTrustStoreAPIClient is a client that implements the
// ListDistributionsByTrustStore operation.
type ListDistributionsByTrustStoreAPIClient interface {
	ListDistributionsByTrustStore(context.Context, *ListDistributionsByTrustStoreInput, ...func(*Options)) (*ListDistributionsByTrustStoreOutput, error)
}

var _ ListDistributionsByTrustStoreAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListDistributionsByTrustStore(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListDistributionsByTrustStore",
	}
}
