// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Describe traffic mirror filters that determine the traffic that is mirrored.
func (c *Client) DescribeTrafficMirrorFilterRules(ctx context.Context, params *DescribeTrafficMirrorFilterRulesInput, optFns ...func(*Options)) (*DescribeTrafficMirrorFilterRulesOutput, error) {
	if params == nil {
		params = &DescribeTrafficMirrorFilterRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "DescribeTrafficMirrorFilterRules", params, optFns, c.addOperationDescribeTrafficMirrorFilterRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*DescribeTrafficMirrorFilterRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type DescribeTrafficMirrorFilterRulesInput struct {

	// Checks whether you have the required permissions for the action, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// Traffic mirror filters.
	//
	//   - traffic-mirror-filter-rule-id : The ID of the Traffic Mirror rule.
	//
	//   - traffic-mirror-filter-id : The ID of the filter that this rule is associated
	//   with.
	//
	//   - rule-number : The number of the Traffic Mirror rule.
	//
	//   - rule-action : The action taken on the filtered traffic. Possible actions are
	//   accept and reject .
	//
	//   - traffic-direction : The traffic direction. Possible directions are ingress
	//   and egress .
	//
	//   - protocol : The protocol, for example UDP, assigned to the Traffic Mirror
	//   rule.
	//
	//   - source-cidr-block : The source CIDR block assigned to the Traffic Mirror
	//   rule.
	//
	//   - destination-cidr-block : The destination CIDR block assigned to the Traffic
	//   Mirror rule.
	//
	//   - description : The description of the Traffic Mirror rule.
	Filters []types.Filter

	// The maximum number of results to return with a single call. To retrieve the
	// remaining results, make another call with the returned nextToken value.
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	// Traffic filter ID.
	TrafficMirrorFilterId *string

	// Traffic filter rule IDs.
	TrafficMirrorFilterRuleIds []string

	noSmithyDocumentSerde
}

type DescribeTrafficMirrorFilterRulesOutput struct {

	// The token to use to retrieve the next page of results. The value is null when
	// there are no more results to return.
	NextToken *string

	// Traffic mirror rules.
	TrafficMirrorFilterRules []types.TrafficMirrorFilterRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationDescribeTrafficMirrorFilterRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpDescribeTrafficMirrorFilterRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpDescribeTrafficMirrorFilterRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "DescribeTrafficMirrorFilterRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opDescribeTrafficMirrorFilterRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opDescribeTrafficMirrorFilterRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "DescribeTrafficMirrorFilterRules",
	}
}
