// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves the CIDR selection rules for an IPAM prefix list resolver. Use this
// operation to view the business logic that determines which CIDRs are selected
// for synchronization with prefix lists.
func (c *Client) GetIpamPrefixListResolverRules(ctx context.Context, params *GetIpamPrefixListResolverRulesInput, optFns ...func(*Options)) (*GetIpamPrefixListResolverRulesOutput, error) {
	if params == nil {
		params = &GetIpamPrefixListResolverRulesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetIpamPrefixListResolverRules", params, optFns, c.addOperationGetIpamPrefixListResolverRulesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetIpamPrefixListResolverRulesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetIpamPrefixListResolverRulesInput struct {

	// The ID of the IPAM prefix list resolver whose rules you want to retrieve.
	//
	// This member is required.
	IpamPrefixListResolverId *string

	// A check for whether you have the required permissions for the action without
	// actually making the request and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// One or more filters to limit the results.
	Filters []types.Filter

	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	MaxResults *int32

	// The token for the next page of results.
	NextToken *string

	noSmithyDocumentSerde
}

type GetIpamPrefixListResolverRulesOutput struct {

	// The token to use to retrieve the next page of results. This value is null when
	// there are no more results to return.
	NextToken *string

	// The CIDR selection rules for the IPAM prefix list resolver.
	Rules []types.IpamPrefixListResolverRule

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetIpamPrefixListResolverRulesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpGetIpamPrefixListResolverRules{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpGetIpamPrefixListResolverRules{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "GetIpamPrefixListResolverRules"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpGetIpamPrefixListResolverRulesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetIpamPrefixListResolverRules(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// GetIpamPrefixListResolverRulesPaginatorOptions is the paginator options for
// GetIpamPrefixListResolverRules
type GetIpamPrefixListResolverRulesPaginatorOptions struct {
	// The maximum number of items to return for this request. To get the next page of
	// items, make another request with the token returned in the output. For more
	// information, see [Pagination].
	//
	// [Pagination]: https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html#api-pagination
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetIpamPrefixListResolverRulesPaginator is a paginator for
// GetIpamPrefixListResolverRules
type GetIpamPrefixListResolverRulesPaginator struct {
	options   GetIpamPrefixListResolverRulesPaginatorOptions
	client    GetIpamPrefixListResolverRulesAPIClient
	params    *GetIpamPrefixListResolverRulesInput
	nextToken *string
	firstPage bool
}

// NewGetIpamPrefixListResolverRulesPaginator returns a new
// GetIpamPrefixListResolverRulesPaginator
func NewGetIpamPrefixListResolverRulesPaginator(client GetIpamPrefixListResolverRulesAPIClient, params *GetIpamPrefixListResolverRulesInput, optFns ...func(*GetIpamPrefixListResolverRulesPaginatorOptions)) *GetIpamPrefixListResolverRulesPaginator {
	if params == nil {
		params = &GetIpamPrefixListResolverRulesInput{}
	}

	options := GetIpamPrefixListResolverRulesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetIpamPrefixListResolverRulesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetIpamPrefixListResolverRulesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetIpamPrefixListResolverRules page.
func (p *GetIpamPrefixListResolverRulesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetIpamPrefixListResolverRulesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.GetIpamPrefixListResolverRules(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// GetIpamPrefixListResolverRulesAPIClient is a client that implements the
// GetIpamPrefixListResolverRules operation.
type GetIpamPrefixListResolverRulesAPIClient interface {
	GetIpamPrefixListResolverRules(context.Context, *GetIpamPrefixListResolverRulesInput, ...func(*Options)) (*GetIpamPrefixListResolverRulesOutput, error)
}

var _ GetIpamPrefixListResolverRulesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opGetIpamPrefixListResolverRules(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "GetIpamPrefixListResolverRules",
	}
}
