// Code generated by smithy-go-codegen DO NOT EDIT.

package ec2

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/ec2/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Modifies the specified EC2 Instance Connect Endpoint.
//
// For more information, see [Modify an EC2 Instance Connect Endpoint] in the Amazon EC2 User Guide.
//
// [Modify an EC2 Instance Connect Endpoint]: https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/modify-ec2-instance-connect-endpoint.html
func (c *Client) ModifyInstanceConnectEndpoint(ctx context.Context, params *ModifyInstanceConnectEndpointInput, optFns ...func(*Options)) (*ModifyInstanceConnectEndpointOutput, error) {
	if params == nil {
		params = &ModifyInstanceConnectEndpointInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ModifyInstanceConnectEndpoint", params, optFns, c.addOperationModifyInstanceConnectEndpointMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ModifyInstanceConnectEndpointOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ModifyInstanceConnectEndpointInput struct {

	// The ID of the EC2 Instance Connect Endpoint to modify.
	//
	// This member is required.
	InstanceConnectEndpointId *string

	// Checks whether you have the required permissions for the operation, without
	// actually making the request, and provides an error response. If you have the
	// required permissions, the error response is DryRunOperation . Otherwise, it is
	// UnauthorizedOperation .
	DryRun *bool

	// The new IP address type for the EC2 Instance Connect Endpoint.
	//
	// PreserveClientIp is only supported on IPv4 EC2 Instance Connect Endpoints. To
	// use PreserveClientIp , the value for IpAddressType must be ipv4 .
	IpAddressType types.IpAddressType

	// Indicates whether the client IP address is preserved as the source when you
	// connect to a resource. The following are the possible values.
	//
	//   - true - Use the IP address of the client. Your instance must have an IPv4
	//   address.
	//
	//   - false - Use the IP address of the network interface.
	PreserveClientIp *bool

	// Changes the security groups for the EC2 Instance Connect Endpoint. The new set
	// of groups you specify replaces the current set. You must specify at least one
	// group, even if it's just the default security group in the VPC. You must specify
	// the ID of the security group, not the name.
	SecurityGroupIds []string

	noSmithyDocumentSerde
}

type ModifyInstanceConnectEndpointOutput struct {

	// Is true if the request succeeds and an error otherwise.
	Return *bool

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationModifyInstanceConnectEndpointMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsEc2query_serializeOpModifyInstanceConnectEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsEc2query_deserializeOpModifyInstanceConnectEndpoint{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ModifyInstanceConnectEndpoint"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpModifyInstanceConnectEndpointValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opModifyInstanceConnectEndpoint(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opModifyInstanceConnectEndpoint(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ModifyInstanceConnectEndpoint",
	}
}
