// Code generated by smithy-go-codegen DO NOT EDIT.

package eventbridge

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/eventbridge/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Lists your replays. You can either list all the replays or you can provide a
// prefix to match to the replay names. Filter parameters are exclusive.
func (c *Client) ListReplays(ctx context.Context, params *ListReplaysInput, optFns ...func(*Options)) (*ListReplaysOutput, error) {
	if params == nil {
		params = &ListReplaysInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListReplays", params, optFns, c.addOperationListReplaysMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListReplaysOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListReplaysInput struct {

	// The ARN of the archive from which the events are replayed.
	EventSourceArn *string

	// The maximum number of replays to retrieve.
	Limit *int32

	// A name prefix to filter the replays returned. Only replays with name that match
	// the prefix are returned.
	NamePrefix *string

	// The token returned by a previous call, which you can use to retrieve the next
	// set of results.
	//
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page of results, make the call again using the returned token. Keep all
	// other arguments unchanged.
	//
	// Using an expired pagination token results in an HTTP 400 InvalidToken error.
	NextToken *string

	// The state of the replay.
	State types.ReplayState

	noSmithyDocumentSerde
}

type ListReplaysOutput struct {

	// A token indicating there are more results available. If there are no more
	// results, no token is included in the response.
	//
	// The value of nextToken is a unique pagination token for each page. To retrieve
	// the next page of results, make the call again using the returned token. Keep all
	// other arguments unchanged.
	//
	// Using an expired pagination token results in an HTTP 400 InvalidToken error.
	NextToken *string

	// An array of Replay objects that contain information about the replay.
	Replays []types.Replay

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListReplaysMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpListReplays{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpListReplays{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListReplays"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListReplays(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addSpanInitializeStart(stack); err != nil {
		return err
	}
	if err = addSpanInitializeEnd(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestStart(stack); err != nil {
		return err
	}
	if err = addSpanBuildRequestEnd(stack); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListReplays(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListReplays",
	}
}
