// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appregistry

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateAttributeGroup = "AssociateAttributeGroup"

// AssociateAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the AssociateAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateAttributeGroup for more information on using the AssociateAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateAttributeGroupRequest method.
//    req, resp := client.AssociateAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup
func (c *AppRegistry) AssociateAttributeGroupRequest(input *AssociateAttributeGroupInput) (req *request.Request, output *AssociateAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opAssociateAttributeGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{application}/attribute-groups/{attributeGroup}",
	}

	if input == nil {
		input = &AssociateAttributeGroupInput{}
	}

	output = &AssociateAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Associates an attribute group with an application to augment the application's
// metadata with the group's attributes. This feature enables applications to
// be described with user-defined details that are machine-readable, such as
// third-party integrations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation AssociateAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
//   * ServiceQuotaExceededException
//   The maximum number of resources per account has been reached.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateAttributeGroup
func (c *AppRegistry) AssociateAttributeGroup(input *AssociateAttributeGroupInput) (*AssociateAttributeGroupOutput, error) {
	req, out := c.AssociateAttributeGroupRequest(input)
	return out, req.Send()
}

// AssociateAttributeGroupWithContext is the same as AssociateAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) AssociateAttributeGroupWithContext(ctx aws.Context, input *AssociateAttributeGroupInput, opts ...request.Option) (*AssociateAttributeGroupOutput, error) {
	req, out := c.AssociateAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResource = "AssociateResource"

// AssociateResourceRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResource for more information on using the AssociateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateResourceRequest method.
//    req, resp := client.AssociateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource
func (c *AppRegistry) AssociateResourceRequest(input *AssociateResourceInput) (req *request.Request, output *AssociateResourceOutput) {
	op := &request.Operation{
		Name:       opAssociateResource,
		HTTPMethod: "PUT",
		HTTPPath:   "/applications/{application}/resources/{resourceType}/{resource}",
	}

	if input == nil {
		input = &AssociateResourceInput{}
	}

	output = &AssociateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResource API operation for AWS Service Catalog App Registry.
//
// Associates a resource with an application. Both the resource and the application
// can be specified either by ID or name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation AssociateResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
//   * ServiceQuotaExceededException
//   The maximum number of resources per account has been reached.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/AssociateResource
func (c *AppRegistry) AssociateResource(input *AssociateResourceInput) (*AssociateResourceOutput, error) {
	req, out := c.AssociateResourceRequest(input)
	return out, req.Send()
}

// AssociateResourceWithContext is the same as AssociateResource with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) AssociateResourceWithContext(ctx aws.Context, input *AssociateResourceInput, opts ...request.Option) (*AssociateResourceOutput, error) {
	req, out := c.AssociateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateApplication = "CreateApplication"

// CreateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the CreateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateApplication for more information on using the CreateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateApplicationRequest method.
//    req, resp := client.CreateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication
func (c *AppRegistry) CreateApplicationRequest(input *CreateApplicationInput) (req *request.Request, output *CreateApplicationOutput) {
	op := &request.Operation{
		Name:       opCreateApplication,
		HTTPMethod: "POST",
		HTTPPath:   "/applications",
	}

	if input == nil {
		input = &CreateApplicationInput{}
	}

	output = &CreateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateApplication API operation for AWS Service Catalog App Registry.
//
// Creates a new application that is the top-level node in a hierarchy of related
// cloud resource abstractions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation CreateApplication for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The maximum number of resources per account has been reached.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateApplication
func (c *AppRegistry) CreateApplication(input *CreateApplicationInput) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	return out, req.Send()
}

// CreateApplicationWithContext is the same as CreateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See CreateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) CreateApplicationWithContext(ctx aws.Context, input *CreateApplicationInput, opts ...request.Option) (*CreateApplicationOutput, error) {
	req, out := c.CreateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAttributeGroup = "CreateAttributeGroup"

// CreateAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAttributeGroup for more information on using the CreateAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateAttributeGroupRequest method.
//    req, resp := client.CreateAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup
func (c *AppRegistry) CreateAttributeGroupRequest(input *CreateAttributeGroupInput) (req *request.Request, output *CreateAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opCreateAttributeGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/attribute-groups",
	}

	if input == nil {
		input = &CreateAttributeGroupInput{}
	}

	output = &CreateAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Creates a new attribute group as a container for user-defined attributes.
// This feature enables users to have full control over their cloud application's
// metadata in a rich machine-readable format to facilitate integration with
// automated workflows and third-party tools.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation CreateAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ServiceQuotaExceededException
//   The maximum number of resources per account has been reached.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/CreateAttributeGroup
func (c *AppRegistry) CreateAttributeGroup(input *CreateAttributeGroupInput) (*CreateAttributeGroupOutput, error) {
	req, out := c.CreateAttributeGroupRequest(input)
	return out, req.Send()
}

// CreateAttributeGroupWithContext is the same as CreateAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) CreateAttributeGroupWithContext(ctx aws.Context, input *CreateAttributeGroupInput, opts ...request.Option) (*CreateAttributeGroupOutput, error) {
	req, out := c.CreateAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteApplication = "DeleteApplication"

// DeleteApplicationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteApplication for more information on using the DeleteApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteApplicationRequest method.
//    req, resp := client.DeleteApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication
func (c *AppRegistry) DeleteApplicationRequest(input *DeleteApplicationInput) (req *request.Request, output *DeleteApplicationOutput) {
	op := &request.Operation{
		Name:       opDeleteApplication,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{application}",
	}

	if input == nil {
		input = &DeleteApplicationInput{}
	}

	output = &DeleteApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteApplication API operation for AWS Service Catalog App Registry.
//
// Deletes an application that is specified either by its application ID or
// name. All associated attribute groups and resources must be disassociated
// from it before deleting an application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation DeleteApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteApplication
func (c *AppRegistry) DeleteApplication(input *DeleteApplicationInput) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	return out, req.Send()
}

// DeleteApplicationWithContext is the same as DeleteApplication with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) DeleteApplicationWithContext(ctx aws.Context, input *DeleteApplicationInput, opts ...request.Option) (*DeleteApplicationOutput, error) {
	req, out := c.DeleteApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteAttributeGroup = "DeleteAttributeGroup"

// DeleteAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteAttributeGroup for more information on using the DeleteAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteAttributeGroupRequest method.
//    req, resp := client.DeleteAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup
func (c *AppRegistry) DeleteAttributeGroupRequest(input *DeleteAttributeGroupInput) (req *request.Request, output *DeleteAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteAttributeGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/attribute-groups/{attributeGroup}",
	}

	if input == nil {
		input = &DeleteAttributeGroupInput{}
	}

	output = &DeleteAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Deletes an attribute group, specified either by its attribute group ID or
// name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation DeleteAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DeleteAttributeGroup
func (c *AppRegistry) DeleteAttributeGroup(input *DeleteAttributeGroupInput) (*DeleteAttributeGroupOutput, error) {
	req, out := c.DeleteAttributeGroupRequest(input)
	return out, req.Send()
}

// DeleteAttributeGroupWithContext is the same as DeleteAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) DeleteAttributeGroupWithContext(ctx aws.Context, input *DeleteAttributeGroupInput, opts ...request.Option) (*DeleteAttributeGroupOutput, error) {
	req, out := c.DeleteAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateAttributeGroup = "DisassociateAttributeGroup"

// DisassociateAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateAttributeGroup for more information on using the DisassociateAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateAttributeGroupRequest method.
//    req, resp := client.DisassociateAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup
func (c *AppRegistry) DisassociateAttributeGroupRequest(input *DisassociateAttributeGroupInput) (req *request.Request, output *DisassociateAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opDisassociateAttributeGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{application}/attribute-groups/{attributeGroup}",
	}

	if input == nil {
		input = &DisassociateAttributeGroupInput{}
	}

	output = &DisassociateAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Disassociates an attribute group from an application to remove the extra
// attributes contained in the attribute group from the application's metadata.
// This operation reverts AssociateAttributeGroup.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation DisassociateAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateAttributeGroup
func (c *AppRegistry) DisassociateAttributeGroup(input *DisassociateAttributeGroupInput) (*DisassociateAttributeGroupOutput, error) {
	req, out := c.DisassociateAttributeGroupRequest(input)
	return out, req.Send()
}

// DisassociateAttributeGroupWithContext is the same as DisassociateAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) DisassociateAttributeGroupWithContext(ctx aws.Context, input *DisassociateAttributeGroupInput, opts ...request.Option) (*DisassociateAttributeGroupOutput, error) {
	req, out := c.DisassociateAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResource = "DisassociateResource"

// DisassociateResourceRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResource for more information on using the DisassociateResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateResourceRequest method.
//    req, resp := client.DisassociateResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource
func (c *AppRegistry) DisassociateResourceRequest(input *DisassociateResourceInput) (req *request.Request, output *DisassociateResourceOutput) {
	op := &request.Operation{
		Name:       opDisassociateResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/applications/{application}/resources/{resourceType}/{resource}",
	}

	if input == nil {
		input = &DisassociateResourceInput{}
	}

	output = &DisassociateResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResource API operation for AWS Service Catalog App Registry.
//
// Disassociates a resource from application. Both the resource and the application
// can be specified either by ID or name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation DisassociateResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/DisassociateResource
func (c *AppRegistry) DisassociateResource(input *DisassociateResourceInput) (*DisassociateResourceOutput, error) {
	req, out := c.DisassociateResourceRequest(input)
	return out, req.Send()
}

// DisassociateResourceWithContext is the same as DisassociateResource with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) DisassociateResourceWithContext(ctx aws.Context, input *DisassociateResourceInput, opts ...request.Option) (*DisassociateResourceOutput, error) {
	req, out := c.DisassociateResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetApplication = "GetApplication"

// GetApplicationRequest generates a "aws/request.Request" representing the
// client's request for the GetApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetApplication for more information on using the GetApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetApplicationRequest method.
//    req, resp := client.GetApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication
func (c *AppRegistry) GetApplicationRequest(input *GetApplicationInput) (req *request.Request, output *GetApplicationOutput) {
	op := &request.Operation{
		Name:       opGetApplication,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{application}",
	}

	if input == nil {
		input = &GetApplicationInput{}
	}

	output = &GetApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetApplication API operation for AWS Service Catalog App Registry.
//
// Retrieves metadata information about one of your applications. The application
// can be specified either by its unique ID or by its name (which is unique
// within one account in one region at a given point in time). Specify by ID
// in automated workflows if you want to make sure that the exact same application
// is returned or a ResourceNotFoundException is thrown, avoiding the ABA addressing
// problem.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation GetApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetApplication
func (c *AppRegistry) GetApplication(input *GetApplicationInput) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	return out, req.Send()
}

// GetApplicationWithContext is the same as GetApplication with the addition of
// the ability to pass a context and additional request options.
//
// See GetApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) GetApplicationWithContext(ctx aws.Context, input *GetApplicationInput, opts ...request.Option) (*GetApplicationOutput, error) {
	req, out := c.GetApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAssociatedResource = "GetAssociatedResource"

// GetAssociatedResourceRequest generates a "aws/request.Request" representing the
// client's request for the GetAssociatedResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAssociatedResource for more information on using the GetAssociatedResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAssociatedResourceRequest method.
//    req, resp := client.GetAssociatedResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource
func (c *AppRegistry) GetAssociatedResourceRequest(input *GetAssociatedResourceInput) (req *request.Request, output *GetAssociatedResourceOutput) {
	op := &request.Operation{
		Name:       opGetAssociatedResource,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{application}/resources/{resourceType}/{resource}",
	}

	if input == nil {
		input = &GetAssociatedResourceInput{}
	}

	output = &GetAssociatedResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAssociatedResource API operation for AWS Service Catalog App Registry.
//
// Gets the resource associated with the application.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation GetAssociatedResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAssociatedResource
func (c *AppRegistry) GetAssociatedResource(input *GetAssociatedResourceInput) (*GetAssociatedResourceOutput, error) {
	req, out := c.GetAssociatedResourceRequest(input)
	return out, req.Send()
}

// GetAssociatedResourceWithContext is the same as GetAssociatedResource with the addition of
// the ability to pass a context and additional request options.
//
// See GetAssociatedResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) GetAssociatedResourceWithContext(ctx aws.Context, input *GetAssociatedResourceInput, opts ...request.Option) (*GetAssociatedResourceOutput, error) {
	req, out := c.GetAssociatedResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetAttributeGroup = "GetAttributeGroup"

// GetAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the GetAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetAttributeGroup for more information on using the GetAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetAttributeGroupRequest method.
//    req, resp := client.GetAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup
func (c *AppRegistry) GetAttributeGroupRequest(input *GetAttributeGroupInput) (req *request.Request, output *GetAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opGetAttributeGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/attribute-groups/{attributeGroup}",
	}

	if input == nil {
		input = &GetAttributeGroupInput{}
	}

	output = &GetAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Retrieves an attribute group, either by its name or its ID. The attribute
// group can be specified either by its unique ID or by its name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation GetAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/GetAttributeGroup
func (c *AppRegistry) GetAttributeGroup(input *GetAttributeGroupInput) (*GetAttributeGroupOutput, error) {
	req, out := c.GetAttributeGroupRequest(input)
	return out, req.Send()
}

// GetAttributeGroupWithContext is the same as GetAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See GetAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) GetAttributeGroupWithContext(ctx aws.Context, input *GetAttributeGroupInput, opts ...request.Option) (*GetAttributeGroupOutput, error) {
	req, out := c.GetAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplications = "ListApplications"

// ListApplicationsRequest generates a "aws/request.Request" representing the
// client's request for the ListApplications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApplications for more information on using the ListApplications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListApplicationsRequest method.
//    req, resp := client.ListApplicationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications
func (c *AppRegistry) ListApplicationsRequest(input *ListApplicationsInput) (req *request.Request, output *ListApplicationsOutput) {
	op := &request.Operation{
		Name:       opListApplications,
		HTTPMethod: "GET",
		HTTPPath:   "/applications",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApplicationsInput{}
	}

	output = &ListApplicationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApplications API operation for AWS Service Catalog App Registry.
//
// Retrieves a list of all of your applications. Results are paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation ListApplications for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListApplications
func (c *AppRegistry) ListApplications(input *ListApplicationsInput) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	return out, req.Send()
}

// ListApplicationsWithContext is the same as ListApplications with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListApplicationsWithContext(ctx aws.Context, input *ListApplicationsInput, opts ...request.Option) (*ListApplicationsOutput, error) {
	req, out := c.ListApplicationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApplicationsPages iterates over the pages of a ListApplications operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApplications method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListApplications operation.
//    pageNum := 0
//    err := client.ListApplicationsPages(params,
//        func(page *appregistry.ListApplicationsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRegistry) ListApplicationsPages(input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool) error {
	return c.ListApplicationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApplicationsPagesWithContext same as ListApplicationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListApplicationsPagesWithContext(ctx aws.Context, input *ListApplicationsInput, fn func(*ListApplicationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApplicationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApplicationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApplicationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociatedAttributeGroups = "ListAssociatedAttributeGroups"

// ListAssociatedAttributeGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedAttributeGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedAttributeGroups for more information on using the ListAssociatedAttributeGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedAttributeGroupsRequest method.
//    req, resp := client.ListAssociatedAttributeGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups
func (c *AppRegistry) ListAssociatedAttributeGroupsRequest(input *ListAssociatedAttributeGroupsInput) (req *request.Request, output *ListAssociatedAttributeGroupsOutput) {
	op := &request.Operation{
		Name:       opListAssociatedAttributeGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{application}/attribute-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedAttributeGroupsInput{}
	}

	output = &ListAssociatedAttributeGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedAttributeGroups API operation for AWS Service Catalog App Registry.
//
// Lists all attribute groups that are associated with specified application.
// Results are paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation ListAssociatedAttributeGroups for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedAttributeGroups
func (c *AppRegistry) ListAssociatedAttributeGroups(input *ListAssociatedAttributeGroupsInput) (*ListAssociatedAttributeGroupsOutput, error) {
	req, out := c.ListAssociatedAttributeGroupsRequest(input)
	return out, req.Send()
}

// ListAssociatedAttributeGroupsWithContext is the same as ListAssociatedAttributeGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedAttributeGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAssociatedAttributeGroupsWithContext(ctx aws.Context, input *ListAssociatedAttributeGroupsInput, opts ...request.Option) (*ListAssociatedAttributeGroupsOutput, error) {
	req, out := c.ListAssociatedAttributeGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedAttributeGroupsPages iterates over the pages of a ListAssociatedAttributeGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedAttributeGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociatedAttributeGroups operation.
//    pageNum := 0
//    err := client.ListAssociatedAttributeGroupsPages(params,
//        func(page *appregistry.ListAssociatedAttributeGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRegistry) ListAssociatedAttributeGroupsPages(input *ListAssociatedAttributeGroupsInput, fn func(*ListAssociatedAttributeGroupsOutput, bool) bool) error {
	return c.ListAssociatedAttributeGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedAttributeGroupsPagesWithContext same as ListAssociatedAttributeGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAssociatedAttributeGroupsPagesWithContext(ctx aws.Context, input *ListAssociatedAttributeGroupsInput, fn func(*ListAssociatedAttributeGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedAttributeGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedAttributeGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedAttributeGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAssociatedResources = "ListAssociatedResources"

// ListAssociatedResourcesRequest generates a "aws/request.Request" representing the
// client's request for the ListAssociatedResources operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAssociatedResources for more information on using the ListAssociatedResources
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAssociatedResourcesRequest method.
//    req, resp := client.ListAssociatedResourcesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources
func (c *AppRegistry) ListAssociatedResourcesRequest(input *ListAssociatedResourcesInput) (req *request.Request, output *ListAssociatedResourcesOutput) {
	op := &request.Operation{
		Name:       opListAssociatedResources,
		HTTPMethod: "GET",
		HTTPPath:   "/applications/{application}/resources",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAssociatedResourcesInput{}
	}

	output = &ListAssociatedResourcesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAssociatedResources API operation for AWS Service Catalog App Registry.
//
// Lists all resources that are associated with specified application. Results
// are paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation ListAssociatedResources for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAssociatedResources
func (c *AppRegistry) ListAssociatedResources(input *ListAssociatedResourcesInput) (*ListAssociatedResourcesOutput, error) {
	req, out := c.ListAssociatedResourcesRequest(input)
	return out, req.Send()
}

// ListAssociatedResourcesWithContext is the same as ListAssociatedResources with the addition of
// the ability to pass a context and additional request options.
//
// See ListAssociatedResources for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAssociatedResourcesWithContext(ctx aws.Context, input *ListAssociatedResourcesInput, opts ...request.Option) (*ListAssociatedResourcesOutput, error) {
	req, out := c.ListAssociatedResourcesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAssociatedResourcesPages iterates over the pages of a ListAssociatedResources operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAssociatedResources method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAssociatedResources operation.
//    pageNum := 0
//    err := client.ListAssociatedResourcesPages(params,
//        func(page *appregistry.ListAssociatedResourcesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRegistry) ListAssociatedResourcesPages(input *ListAssociatedResourcesInput, fn func(*ListAssociatedResourcesOutput, bool) bool) error {
	return c.ListAssociatedResourcesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAssociatedResourcesPagesWithContext same as ListAssociatedResourcesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAssociatedResourcesPagesWithContext(ctx aws.Context, input *ListAssociatedResourcesInput, fn func(*ListAssociatedResourcesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAssociatedResourcesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAssociatedResourcesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAssociatedResourcesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListAttributeGroups = "ListAttributeGroups"

// ListAttributeGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListAttributeGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAttributeGroups for more information on using the ListAttributeGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAttributeGroupsRequest method.
//    req, resp := client.ListAttributeGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups
func (c *AppRegistry) ListAttributeGroupsRequest(input *ListAttributeGroupsInput) (req *request.Request, output *ListAttributeGroupsOutput) {
	op := &request.Operation{
		Name:       opListAttributeGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/attribute-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"nextToken"},
			OutputTokens:    []string{"nextToken"},
			LimitToken:      "maxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAttributeGroupsInput{}
	}

	output = &ListAttributeGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAttributeGroups API operation for AWS Service Catalog App Registry.
//
// Lists all attribute groups which you have access to. Results are paginated.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation ListAttributeGroups for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListAttributeGroups
func (c *AppRegistry) ListAttributeGroups(input *ListAttributeGroupsInput) (*ListAttributeGroupsOutput, error) {
	req, out := c.ListAttributeGroupsRequest(input)
	return out, req.Send()
}

// ListAttributeGroupsWithContext is the same as ListAttributeGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListAttributeGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAttributeGroupsWithContext(ctx aws.Context, input *ListAttributeGroupsInput, opts ...request.Option) (*ListAttributeGroupsOutput, error) {
	req, out := c.ListAttributeGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAttributeGroupsPages iterates over the pages of a ListAttributeGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAttributeGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a ListAttributeGroups operation.
//    pageNum := 0
//    err := client.ListAttributeGroupsPages(params,
//        func(page *appregistry.ListAttributeGroupsOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *AppRegistry) ListAttributeGroupsPages(input *ListAttributeGroupsInput, fn func(*ListAttributeGroupsOutput, bool) bool) error {
	return c.ListAttributeGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAttributeGroupsPagesWithContext same as ListAttributeGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListAttributeGroupsPagesWithContext(ctx aws.Context, input *ListAttributeGroupsInput, fn func(*ListAttributeGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAttributeGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAttributeGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAttributeGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource
func (c *AppRegistry) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for AWS Service Catalog App Registry.
//
// Lists all of the tags on the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/ListTagsForResource
func (c *AppRegistry) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSyncResource = "SyncResource"

// SyncResourceRequest generates a "aws/request.Request" representing the
// client's request for the SyncResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SyncResource for more information on using the SyncResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the SyncResourceRequest method.
//    req, resp := client.SyncResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource
func (c *AppRegistry) SyncResourceRequest(input *SyncResourceInput) (req *request.Request, output *SyncResourceOutput) {
	op := &request.Operation{
		Name:       opSyncResource,
		HTTPMethod: "POST",
		HTTPPath:   "/sync/{resourceType}/{resource}",
	}

	if input == nil {
		input = &SyncResourceInput{}
	}

	output = &SyncResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SyncResource API operation for AWS Service Catalog App Registry.
//
// Syncs the resource with current AppRegistry records.
//
// Specifically, the resource’s AppRegistry system tags sync with its associated
// application. We remove the resource's AppRegistry system tags if it does
// not associate with the application. The caller must have permissions to read
// and update the resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation SyncResource for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/SyncResource
func (c *AppRegistry) SyncResource(input *SyncResourceInput) (*SyncResourceOutput, error) {
	req, out := c.SyncResourceRequest(input)
	return out, req.Send()
}

// SyncResourceWithContext is the same as SyncResource with the addition of
// the ability to pass a context and additional request options.
//
// See SyncResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) SyncResourceWithContext(ctx aws.Context, input *SyncResourceInput, opts ...request.Option) (*SyncResourceOutput, error) {
	req, out := c.SyncResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource
func (c *AppRegistry) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for AWS Service Catalog App Registry.
//
// Assigns one or more tags (key-value pairs) to the specified resource.
//
// Each tag consists of a key and an optional value. If a tag with the same
// key is already associated with the resource, this action updates its value.
//
// This operation returns an empty response if the call was successful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/TagResource
func (c *AppRegistry) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource
func (c *AppRegistry) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for AWS Service Catalog App Registry.
//
// Removes tags from a resource.
//
// This operation returns an empty response if the call was successful.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UntagResource
func (c *AppRegistry) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplication = "UpdateApplication"

// UpdateApplicationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateApplication operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateApplication for more information on using the UpdateApplication
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateApplicationRequest method.
//    req, resp := client.UpdateApplicationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication
func (c *AppRegistry) UpdateApplicationRequest(input *UpdateApplicationInput) (req *request.Request, output *UpdateApplicationOutput) {
	op := &request.Operation{
		Name:       opUpdateApplication,
		HTTPMethod: "PATCH",
		HTTPPath:   "/applications/{application}",
	}

	if input == nil {
		input = &UpdateApplicationInput{}
	}

	output = &UpdateApplicationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateApplication API operation for AWS Service Catalog App Registry.
//
// Updates an existing application with new attributes.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation UpdateApplication for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateApplication
func (c *AppRegistry) UpdateApplication(input *UpdateApplicationInput) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	return out, req.Send()
}

// UpdateApplicationWithContext is the same as UpdateApplication with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplication for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) UpdateApplicationWithContext(ctx aws.Context, input *UpdateApplicationInput, opts ...request.Option) (*UpdateApplicationOutput, error) {
	req, out := c.UpdateApplicationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAttributeGroup = "UpdateAttributeGroup"

// UpdateAttributeGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAttributeGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAttributeGroup for more information on using the UpdateAttributeGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateAttributeGroupRequest method.
//    req, resp := client.UpdateAttributeGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup
func (c *AppRegistry) UpdateAttributeGroupRequest(input *UpdateAttributeGroupInput) (req *request.Request, output *UpdateAttributeGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateAttributeGroup,
		HTTPMethod: "PATCH",
		HTTPPath:   "/attribute-groups/{attributeGroup}",
	}

	if input == nil {
		input = &UpdateAttributeGroupInput{}
	}

	output = &UpdateAttributeGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateAttributeGroup API operation for AWS Service Catalog App Registry.
//
// Updates an existing attribute group with new details.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for AWS Service Catalog App Registry's
// API operation UpdateAttributeGroup for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The specified resource does not exist.
//
//   * ValidationException
//   The request has invalid or missing parameters.
//
//   * ConflictException
//   There was a conflict when processing the request (for example, a resource
//   with the given name already exists within the account).
//
//   * InternalServerException
//   The service is experiencing internal problems.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/AWS242AppRegistry-2020-06-24/UpdateAttributeGroup
func (c *AppRegistry) UpdateAttributeGroup(input *UpdateAttributeGroupInput) (*UpdateAttributeGroupOutput, error) {
	req, out := c.UpdateAttributeGroupRequest(input)
	return out, req.Send()
}

// UpdateAttributeGroupWithContext is the same as UpdateAttributeGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAttributeGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppRegistry) UpdateAttributeGroupWithContext(ctx aws.Context, input *UpdateAttributeGroupInput, opts ...request.Option) (*UpdateAttributeGroupOutput, error) {
	req, out := c.UpdateAttributeGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// Represents a Amazon Web Services Service Catalog AppRegistry application
// that is the top-level node in a hierarchy of related cloud resource abstractions.
type Application struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string `locationName:"arn" type:"string"`

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the application.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the application. The name must be unique in the region in which
	// you are creating the application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Key-value pairs you can use to associate with the application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Application) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Application) SetArn(v string) *Application {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Application) SetCreationTime(v time.Time) *Application {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Application) SetDescription(v string) *Application {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *Application) SetId(v string) *Application {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *Application) SetLastUpdateTime(v time.Time) *Application {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Application) SetName(v string) *Application {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *Application) SetTags(v map[string]*string) *Application {
	s.Tags = v
	return s
}

// Summary of a Amazon Web Services Service Catalog AppRegistry application.
type ApplicationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string `locationName:"arn" type:"string"`

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the application.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the application. The name must be unique in the region in which
	// you are creating the application.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ApplicationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ApplicationSummary) SetArn(v string) *ApplicationSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *ApplicationSummary) SetCreationTime(v time.Time) *ApplicationSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ApplicationSummary) SetDescription(v string) *ApplicationSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ApplicationSummary) SetId(v string) *ApplicationSummary {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *ApplicationSummary) SetLastUpdateTime(v time.Time) *ApplicationSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ApplicationSummary) SetName(v string) *ApplicationSummary {
	s.Name = &v
	return s
}

type AssociateAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The name or ID of the attribute group that holds the attributes to describe
	// the application.
	//
	// AttributeGroup is a required field
	AttributeGroup *string `location:"uri" locationName:"attributeGroup" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateAttributeGroupInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.AttributeGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeGroup"))
	}
	if s.AttributeGroup != nil && len(*s.AttributeGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *AssociateAttributeGroupInput) SetApplication(v string) *AssociateAttributeGroupInput {
	s.Application = &v
	return s
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *AssociateAttributeGroupInput) SetAttributeGroup(v string) *AssociateAttributeGroupInput {
	s.AttributeGroup = &v
	return s
}

type AssociateAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the application that was augmented with
	// attributes.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The Amazon resource name (ARN) of the attribute group that contains the application's
	// new attributes.
	AttributeGroupArn *string `locationName:"attributeGroupArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *AssociateAttributeGroupOutput) SetApplicationArn(v string) *AssociateAttributeGroupOutput {
	s.ApplicationArn = &v
	return s
}

// SetAttributeGroupArn sets the AttributeGroupArn field's value.
func (s *AssociateAttributeGroupOutput) SetAttributeGroupArn(v string) *AssociateAttributeGroupOutput {
	s.AttributeGroupArn = &v
	return s
}

type AssociateResourceInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The name or ID of the resource of which the application will be associated.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"resource" min:"1" type:"string" required:"true"`

	// The type of resource of which the application will be associated.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *AssociateResourceInput) SetApplication(v string) *AssociateResourceInput {
	s.Application = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *AssociateResourceInput) SetResource(v string) *AssociateResourceInput {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociateResourceInput) SetResourceType(v string) *AssociateResourceInput {
	s.ResourceType = &v
	return s
}

type AssociateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the application that was augmented with
	// attributes.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The Amazon resource name (ARN) that specifies the resource.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *AssociateResourceOutput) SetApplicationArn(v string) *AssociateResourceOutput {
	s.ApplicationArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AssociateResourceOutput) SetResourceArn(v string) *AssociateResourceOutput {
	s.ResourceArn = &v
	return s
}

// Represents a Amazon Web Services Service Catalog AppRegistry attribute group
// that is rich metadata which describes an application and its components.
type AttributeGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string `locationName:"arn" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the attribute group that the user provides.
	Description *string `locationName:"description" type:"string"`

	// The globally unique attribute group identifier of the attribute group.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the attribute group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Key-value pairs you can use to associate with the attribute group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AttributeGroup) SetArn(v string) *AttributeGroup {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AttributeGroup) SetCreationTime(v time.Time) *AttributeGroup {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AttributeGroup) SetDescription(v string) *AttributeGroup {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AttributeGroup) SetId(v string) *AttributeGroup {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AttributeGroup) SetLastUpdateTime(v time.Time) *AttributeGroup {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttributeGroup) SetName(v string) *AttributeGroup {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AttributeGroup) SetTags(v map[string]*string) *AttributeGroup {
	s.Tags = v
	return s
}

// Summary of a Amazon Web Services Service Catalog AppRegistry attribute group.
type AttributeGroupSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string `locationName:"arn" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the attribute group that the user provides.
	Description *string `locationName:"description" type:"string"`

	// The globally unique attribute group identifier of the attribute group.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the attribute group.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeGroupSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttributeGroupSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AttributeGroupSummary) SetArn(v string) *AttributeGroupSummary {
	s.Arn = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *AttributeGroupSummary) SetCreationTime(v time.Time) *AttributeGroupSummary {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AttributeGroupSummary) SetDescription(v string) *AttributeGroupSummary {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *AttributeGroupSummary) SetId(v string) *AttributeGroupSummary {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *AttributeGroupSummary) SetLastUpdateTime(v time.Time) *AttributeGroupSummary {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *AttributeGroupSummary) SetName(v string) *AttributeGroupSummary {
	s.Name = &v
	return s
}

// There was a conflict when processing the request (for example, a resource
// with the given name already exists within the account).
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateApplicationInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier that you provide to ensure idempotency. If you retry
	// a request that completed successfully using the same client token and the
	// same parameters, the retry succeeds without performing any further actions.
	// If you retry a successful request using the same client token, but one or
	// more of the parameters are different, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The name of the application. The name must be unique in the region in which
	// you are creating the application.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Key-value pairs you can use to associate with the application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateApplicationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateApplicationInput) SetClientToken(v string) *CreateApplicationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateApplicationInput) SetDescription(v string) *CreateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateApplicationInput) SetName(v string) *CreateApplicationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateApplicationInput) SetTags(v map[string]*string) *CreateApplicationInput {
	s.Tags = v
	return s
}

type CreateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the application.
	Application *Application `locationName:"application" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *CreateApplicationOutput) SetApplication(v *Application) *CreateApplicationOutput {
	s.Application = v
	return s
}

type CreateAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// A JSON string in the form of nested key-value pairs that represent the attributes
	// in the group and describes an application and its components.
	//
	// Attributes is a required field
	Attributes *string `locationName:"attributes" min:"1" type:"string" required:"true"`

	// A unique identifier that you provide to ensure idempotency. If you retry
	// a request that completed successfully using the same client token and the
	// same parameters, the retry succeeds without performing any further actions.
	// If you retry a successful request using the same client token, but one or
	// more of the parameters are different, the retry fails.
	ClientToken *string `locationName:"clientToken" min:"1" type:"string" idempotencyToken:"true"`

	// The description of the attribute group that the user provides.
	Description *string `locationName:"description" type:"string"`

	// The name of the attribute group.
	//
	// Name is a required field
	Name *string `locationName:"name" min:"1" type:"string" required:"true"`

	// Key-value pairs you can use to associate with the attribute group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAttributeGroupInput"}
	if s.Attributes == nil {
		invalidParams.Add(request.NewErrParamRequired("Attributes"))
	}
	if s.Attributes != nil && len(*s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributes sets the Attributes field's value.
func (s *CreateAttributeGroupInput) SetAttributes(v string) *CreateAttributeGroupInput {
	s.Attributes = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateAttributeGroupInput) SetClientToken(v string) *CreateAttributeGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateAttributeGroupInput) SetDescription(v string) *CreateAttributeGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAttributeGroupInput) SetName(v string) *CreateAttributeGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAttributeGroupInput) SetTags(v map[string]*string) *CreateAttributeGroupInput {
	s.Tags = v
	return s
}

type CreateAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the attribute group.
	AttributeGroup *AttributeGroup `locationName:"attributeGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *CreateAttributeGroupOutput) SetAttributeGroup(v *AttributeGroup) *CreateAttributeGroupOutput {
	s.AttributeGroup = v
	return s
}

type DeleteApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DeleteApplicationInput) SetApplication(v string) *DeleteApplicationInput {
	s.Application = &v
	return s
}

type DeleteApplicationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted application.
	Application *ApplicationSummary `locationName:"application" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *DeleteApplicationOutput) SetApplication(v *ApplicationSummary) *DeleteApplicationOutput {
	s.Application = v
	return s
}

type DeleteAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the attribute group that holds the attributes to describe
	// the application.
	//
	// AttributeGroup is a required field
	AttributeGroup *string `location:"uri" locationName:"attributeGroup" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteAttributeGroupInput"}
	if s.AttributeGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeGroup"))
	}
	if s.AttributeGroup != nil && len(*s.AttributeGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *DeleteAttributeGroupInput) SetAttributeGroup(v string) *DeleteAttributeGroupInput {
	s.AttributeGroup = &v
	return s
}

type DeleteAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// Information about the deleted attribute group.
	AttributeGroup *AttributeGroupSummary `locationName:"attributeGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *DeleteAttributeGroupOutput) SetAttributeGroup(v *AttributeGroupSummary) *DeleteAttributeGroupOutput {
	s.AttributeGroup = v
	return s
}

type DisassociateAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The name or ID of the attribute group that holds the attributes to describe
	// the application.
	//
	// AttributeGroup is a required field
	AttributeGroup *string `location:"uri" locationName:"attributeGroup" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateAttributeGroupInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.AttributeGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeGroup"))
	}
	if s.AttributeGroup != nil && len(*s.AttributeGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DisassociateAttributeGroupInput) SetApplication(v string) *DisassociateAttributeGroupInput {
	s.Application = &v
	return s
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *DisassociateAttributeGroupInput) SetAttributeGroup(v string) *DisassociateAttributeGroupInput {
	s.AttributeGroup = &v
	return s
}

type DisassociateAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The Amazon resource name (ARN) that specifies the attribute group.
	AttributeGroupArn *string `locationName:"attributeGroupArn" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DisassociateAttributeGroupOutput) SetApplicationArn(v string) *DisassociateAttributeGroupOutput {
	s.ApplicationArn = &v
	return s
}

// SetAttributeGroupArn sets the AttributeGroupArn field's value.
func (s *DisassociateAttributeGroupOutput) SetAttributeGroupArn(v string) *DisassociateAttributeGroupOutput {
	s.AttributeGroupArn = &v
	return s
}

type DisassociateResourceInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The name or ID of the resource.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"resource" min:"1" type:"string" required:"true"`

	// The type of the resource that is being disassociated.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *DisassociateResourceInput) SetApplication(v string) *DisassociateResourceInput {
	s.Application = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *DisassociateResourceInput) SetResource(v string) *DisassociateResourceInput {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DisassociateResourceInput) SetResourceType(v string) *DisassociateResourceInput {
	s.ResourceType = &v
	return s
}

type DisassociateResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The Amazon resource name (ARN) that specifies the resource.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceOutput) GoString() string {
	return s.String()
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *DisassociateResourceOutput) SetApplicationArn(v string) *DisassociateResourceOutput {
	s.ApplicationArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DisassociateResourceOutput) SetResourceArn(v string) *DisassociateResourceOutput {
	s.ResourceArn = &v
	return s
}

type GetApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *GetApplicationInput) SetApplication(v string) *GetApplicationInput {
	s.Application = &v
	return s
}

type GetApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the application across services.
	Arn *string `locationName:"arn" type:"string"`

	// The number of top-level resources that were registered as part of this application.
	AssociatedResourceCount *int64 `locationName:"associatedResourceCount" type:"integer"`

	// The ISO-8601 formatted timestamp of the moment when the application was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the application.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the application.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The information about the integration of the application with other services,
	// such as Resource Groups.
	Integrations *Integrations `locationName:"integrations" type:"structure"`

	// The ISO-8601 formatted timestamp of the moment when the application was last
	// updated.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the application. The name must be unique in the region in which
	// you are creating the application.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Key-value pairs associated with the application.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetApplicationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetApplicationOutput) SetArn(v string) *GetApplicationOutput {
	s.Arn = &v
	return s
}

// SetAssociatedResourceCount sets the AssociatedResourceCount field's value.
func (s *GetApplicationOutput) SetAssociatedResourceCount(v int64) *GetApplicationOutput {
	s.AssociatedResourceCount = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetApplicationOutput) SetCreationTime(v time.Time) *GetApplicationOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetApplicationOutput) SetDescription(v string) *GetApplicationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetApplicationOutput) SetId(v string) *GetApplicationOutput {
	s.Id = &v
	return s
}

// SetIntegrations sets the Integrations field's value.
func (s *GetApplicationOutput) SetIntegrations(v *Integrations) *GetApplicationOutput {
	s.Integrations = v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *GetApplicationOutput) SetLastUpdateTime(v time.Time) *GetApplicationOutput {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetApplicationOutput) SetName(v string) *GetApplicationOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetApplicationOutput) SetTags(v map[string]*string) *GetApplicationOutput {
	s.Tags = v
	return s
}

type GetAssociatedResourceInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The name or ID of the resource associated with the application.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"resource" min:"1" type:"string" required:"true"`

	// The type of resource associated with the application.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssociatedResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssociatedResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAssociatedResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAssociatedResourceInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *GetAssociatedResourceInput) SetApplication(v string) *GetAssociatedResourceInput {
	s.Application = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *GetAssociatedResourceInput) SetResource(v string) *GetAssociatedResourceInput {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *GetAssociatedResourceInput) SetResourceType(v string) *GetAssociatedResourceInput {
	s.ResourceType = &v
	return s
}

type GetAssociatedResourceOutput struct {
	_ struct{} `type:"structure"`

	// The resource associated with the application.
	Resource *Resource `locationName:"resource" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssociatedResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAssociatedResourceOutput) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *GetAssociatedResourceOutput) SetResource(v *Resource) *GetAssociatedResourceOutput {
	s.Resource = v
	return s
}

type GetAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the attribute group that holds the attributes to describe
	// the application.
	//
	// AttributeGroup is a required field
	AttributeGroup *string `location:"uri" locationName:"attributeGroup" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetAttributeGroupInput"}
	if s.AttributeGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeGroup"))
	}
	if s.AttributeGroup != nil && len(*s.AttributeGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeGroup", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *GetAttributeGroupInput) SetAttributeGroup(v string) *GetAttributeGroupInput {
	s.AttributeGroup = &v
	return s
}

type GetAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the attribute group across
	// services.
	Arn *string `locationName:"arn" type:"string"`

	// A JSON string in the form of nested key-value pairs that represent the attributes
	// in the group and describes an application and its components.
	Attributes *string `locationName:"attributes" min:"1" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was created.
	CreationTime *time.Time `locationName:"creationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The description of the attribute group that the user provides.
	Description *string `locationName:"description" type:"string"`

	// The identifier of the attribute group.
	Id *string `locationName:"id" min:"26" type:"string"`

	// The ISO-8601 formatted timestamp of the moment the attribute group was last
	// updated. This time is the same as the creationTime for a newly created attribute
	// group.
	LastUpdateTime *time.Time `locationName:"lastUpdateTime" type:"timestamp" timestampFormat:"iso8601"`

	// The name of the attribute group.
	Name *string `locationName:"name" min:"1" type:"string"`

	// Key-value pairs associated with the attribute group.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetAttributeGroupOutput) SetArn(v string) *GetAttributeGroupOutput {
	s.Arn = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *GetAttributeGroupOutput) SetAttributes(v string) *GetAttributeGroupOutput {
	s.Attributes = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *GetAttributeGroupOutput) SetCreationTime(v time.Time) *GetAttributeGroupOutput {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetAttributeGroupOutput) SetDescription(v string) *GetAttributeGroupOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetAttributeGroupOutput) SetId(v string) *GetAttributeGroupOutput {
	s.Id = &v
	return s
}

// SetLastUpdateTime sets the LastUpdateTime field's value.
func (s *GetAttributeGroupOutput) SetLastUpdateTime(v time.Time) *GetAttributeGroupOutput {
	s.LastUpdateTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetAttributeGroupOutput) SetName(v string) *GetAttributeGroupOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetAttributeGroupOutput) SetTags(v map[string]*string) *GetAttributeGroupOutput {
	s.Tags = v
	return s
}

// The information about the service integration.
type Integrations struct {
	_ struct{} `type:"structure"`

	// The information about the resource group integration.
	ResourceGroup *ResourceGroup `locationName:"resourceGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integrations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Integrations) GoString() string {
	return s.String()
}

// SetResourceGroup sets the ResourceGroup field's value.
func (s *Integrations) SetResourceGroup(v *ResourceGroup) *Integrations {
	s.ResourceGroup = v
	return s
}

// The service is experiencing internal problems.
type InternalServerException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerException) GoString() string {
	return s.String()
}

func newErrorInternalServerException(v protocol.ResponseMetadata) error {
	return &InternalServerException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerException) Code() string {
	return "InternalServerException"
}

// Message returns the exception's message.
func (s *InternalServerException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerException) OrigErr() error {
	return nil
}

func (s *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListApplicationsInput struct {
	_ struct{} `type:"structure"`

	// The upper bound of the number of results to return (cannot exceed 25). If
	// this parameter is omitted, it defaults to 25. This value is optional.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationsInput) SetMaxResults(v int64) *ListApplicationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsInput) SetNextToken(v string) *ListApplicationsInput {
	s.NextToken = &v
	return s
}

type ListApplicationsOutput struct {
	_ struct{} `type:"structure"`

	// This list of applications.
	Applications []*ApplicationSummary `locationName:"applications" type:"list"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListApplicationsOutput) GoString() string {
	return s.String()
}

// SetApplications sets the Applications field's value.
func (s *ListApplicationsOutput) SetApplications(v []*ApplicationSummary) *ListApplicationsOutput {
	s.Applications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationsOutput) SetNextToken(v string) *ListApplicationsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedAttributeGroupsInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The upper bound of the number of results to return (cannot exceed 25). If
	// this parameter is omitted, it defaults to 25. This value is optional.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAttributeGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAttributeGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedAttributeGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedAttributeGroupsInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *ListAssociatedAttributeGroupsInput) SetApplication(v string) *ListAssociatedAttributeGroupsInput {
	s.Application = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedAttributeGroupsInput) SetMaxResults(v int64) *ListAssociatedAttributeGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAttributeGroupsInput) SetNextToken(v string) *ListAssociatedAttributeGroupsInput {
	s.NextToken = &v
	return s
}

type ListAssociatedAttributeGroupsOutput struct {
	_ struct{} `type:"structure"`

	// A list of attribute group IDs.
	AttributeGroups []*string `locationName:"attributeGroups" type:"list"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAttributeGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedAttributeGroupsOutput) GoString() string {
	return s.String()
}

// SetAttributeGroups sets the AttributeGroups field's value.
func (s *ListAssociatedAttributeGroupsOutput) SetAttributeGroups(v []*string) *ListAssociatedAttributeGroupsOutput {
	s.AttributeGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedAttributeGroupsOutput) SetNextToken(v string) *ListAssociatedAttributeGroupsOutput {
	s.NextToken = &v
	return s
}

type ListAssociatedResourcesInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The upper bound of the number of results to return (cannot exceed 25). If
	// this parameter is omitted, it defaults to 25. This value is optional.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedResourcesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedResourcesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAssociatedResourcesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAssociatedResourcesInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *ListAssociatedResourcesInput) SetApplication(v string) *ListAssociatedResourcesInput {
	s.Application = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAssociatedResourcesInput) SetMaxResults(v int64) *ListAssociatedResourcesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedResourcesInput) SetNextToken(v string) *ListAssociatedResourcesInput {
	s.NextToken = &v
	return s
}

type ListAssociatedResourcesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`

	// Information about the resources.
	Resources []*ResourceInfo `locationName:"resources" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedResourcesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAssociatedResourcesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListAssociatedResourcesOutput) SetNextToken(v string) *ListAssociatedResourcesOutput {
	s.NextToken = &v
	return s
}

// SetResources sets the Resources field's value.
func (s *ListAssociatedResourcesOutput) SetResources(v []*ResourceInfo) *ListAssociatedResourcesOutput {
	s.Resources = v
	return s
}

type ListAttributeGroupsInput struct {
	_ struct{} `type:"structure"`

	// The upper bound of the number of results to return (cannot exceed 25). If
	// this parameter is omitted, it defaults to 25. This value is optional.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributeGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributeGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAttributeGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAttributeGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAttributeGroupsInput) SetMaxResults(v int64) *ListAttributeGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttributeGroupsInput) SetNextToken(v string) *ListAttributeGroupsInput {
	s.NextToken = &v
	return s
}

type ListAttributeGroupsOutput struct {
	_ struct{} `type:"structure"`

	// This list of attribute groups.
	AttributeGroups []*AttributeGroupSummary `locationName:"attributeGroups" type:"list"`

	// The token to use to get the next page of results after a previous API call.
	NextToken *string `locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributeGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAttributeGroupsOutput) GoString() string {
	return s.String()
}

// SetAttributeGroups sets the AttributeGroups field's value.
func (s *ListAttributeGroupsOutput) SetAttributeGroups(v []*AttributeGroupSummary) *ListAttributeGroupsOutput {
	s.AttributeGroups = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAttributeGroupsOutput) SetNextToken(v string) *ListAttributeGroupsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags on the resource.
	Tags map[string]*string `locationName:"tags" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The information about the resource.
type Resource struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the resource.
	Arn *string `locationName:"arn" type:"string"`

	// The time the resource was associated with the application.
	AssociationTime *time.Time `locationName:"associationTime" type:"timestamp" timestampFormat:"iso8601"`

	// The service integration information about the resource.
	Integrations *ResourceIntegrations `locationName:"integrations" type:"structure"`

	// The name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Resource) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Resource) SetArn(v string) *Resource {
	s.Arn = &v
	return s
}

// SetAssociationTime sets the AssociationTime field's value.
func (s *Resource) SetAssociationTime(v time.Time) *Resource {
	s.AssociationTime = &v
	return s
}

// SetIntegrations sets the Integrations field's value.
func (s *Resource) SetIntegrations(v *ResourceIntegrations) *Resource {
	s.Integrations = v
	return s
}

// SetName sets the Name field's value.
func (s *Resource) SetName(v string) *Resource {
	s.Name = &v
	return s
}

// The information about the resource group integration.
type ResourceGroup struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) of the resource group.
	Arn *string `locationName:"arn" min:"1" type:"string"`

	// The error message that generates when the propagation process for the resource
	// group fails.
	ErrorMessage *string `locationName:"errorMessage" type:"string"`

	// The state of the propagation process for the resource group. The states includes:
	//
	// CREATING if the resource group is in the process of being created.
	//
	// CREATE_COMPLETE if the resource group was created successfully.
	//
	// CREATE_FAILED if the resource group failed to be created.
	//
	// UPDATING if the resource group is in the process of being updated.
	//
	// UPDATE_COMPLETE if the resource group updated successfully.
	//
	// UPDATE_FAILED if the resource group could not update successfully.
	State *string `locationName:"state" type:"string" enum:"ResourceGroupState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceGroup) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceGroup) SetArn(v string) *ResourceGroup {
	s.Arn = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *ResourceGroup) SetErrorMessage(v string) *ResourceGroup {
	s.ErrorMessage = &v
	return s
}

// SetState sets the State field's value.
func (s *ResourceGroup) SetState(v string) *ResourceGroup {
	s.State = &v
	return s
}

// The information about the resource.
type ResourceInfo struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the resource across services.
	Arn *string `locationName:"arn" type:"string"`

	// The name of the resource.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceInfo) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ResourceInfo) SetArn(v string) *ResourceInfo {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *ResourceInfo) SetName(v string) *ResourceInfo {
	s.Name = &v
	return s
}

// The service integration information about the resource.
type ResourceIntegrations struct {
	_ struct{} `type:"structure"`

	// The information about the integration of Resource Groups.
	ResourceGroup *ResourceGroup `locationName:"resourceGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIntegrations) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceIntegrations) GoString() string {
	return s.String()
}

// SetResourceGroup sets the ResourceGroup field's value.
func (s *ResourceIntegrations) SetResourceGroup(v *ResourceGroup) *ResourceIntegrations {
	s.ResourceGroup = v
	return s
}

// The specified resource does not exist.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The maximum number of resources per account has been reached.
type ServiceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ServiceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorServiceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ServiceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ServiceQuotaExceededException) Code() string {
	return "ServiceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ServiceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ServiceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ServiceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ServiceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ServiceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type SyncResourceInput struct {
	_ struct{} `type:"structure"`

	// An entity you can work with and specify with a name or ID. Examples include
	// an Amazon EC2 instance, an Amazon Web Services CloudFormation stack, or an
	// Amazon S3 bucket.
	//
	// Resource is a required field
	Resource *string `location:"uri" locationName:"resource" min:"1" type:"string" required:"true"`

	// The type of resource of which the application will be associated.
	//
	// ResourceType is a required field
	ResourceType *string `location:"uri" locationName:"resourceType" type:"string" required:"true" enum:"ResourceType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SyncResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SyncResourceInput"}
	if s.Resource == nil {
		invalidParams.Add(request.NewErrParamRequired("Resource"))
	}
	if s.Resource != nil && len(*s.Resource) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Resource", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.ResourceType != nil && len(*s.ResourceType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResource sets the Resource field's value.
func (s *SyncResourceInput) SetResource(v string) *SyncResourceInput {
	s.Resource = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *SyncResourceInput) SetResourceType(v string) *SyncResourceInput {
	s.ResourceType = &v
	return s
}

type SyncResourceOutput struct {
	_ struct{} `type:"structure"`

	// The results of the output if an application is associated with an ARN value,
	// which could be syncStarted or None.
	ActionTaken *string `locationName:"actionTaken" type:"string" enum:"SyncAction"`

	// The Amazon resource name (ARN) that specifies the application.
	ApplicationArn *string `locationName:"applicationArn" type:"string"`

	// The Amazon resource name (ARN) that specifies the resource.
	ResourceArn *string `locationName:"resourceArn" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SyncResourceOutput) GoString() string {
	return s.String()
}

// SetActionTaken sets the ActionTaken field's value.
func (s *SyncResourceOutput) SetActionTaken(v string) *SyncResourceOutput {
	s.ActionTaken = &v
	return s
}

// SetApplicationArn sets the ApplicationArn field's value.
func (s *SyncResourceOutput) SetApplicationArn(v string) *SyncResourceOutput {
	s.ApplicationArn = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *SyncResourceOutput) SetResourceArn(v string) *SyncResourceOutput {
	s.ResourceArn = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The new or modified tags for the resource.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

type UntagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon resource name (ARN) that specifies the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// A list of the tag keys to remove from the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateApplicationInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the application that will be updated.
	//
	// Application is a required field
	Application *string `location:"uri" locationName:"application" min:"1" type:"string" required:"true"`

	// The new description of the application.
	Description *string `locationName:"description" type:"string"`

	// The new name of the application. The name must be unique in the region in
	// which you are updating the application.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationInput"}
	if s.Application == nil {
		invalidParams.Add(request.NewErrParamRequired("Application"))
	}
	if s.Application != nil && len(*s.Application) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Application", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplication sets the Application field's value.
func (s *UpdateApplicationInput) SetApplication(v string) *UpdateApplicationInput {
	s.Application = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateApplicationInput) SetDescription(v string) *UpdateApplicationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateApplicationInput) SetName(v string) *UpdateApplicationInput {
	s.Name = &v
	return s
}

type UpdateApplicationOutput struct {
	_ struct{} `type:"structure"`

	// The updated information of the application.
	Application *Application `locationName:"application" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateApplicationOutput) GoString() string {
	return s.String()
}

// SetApplication sets the Application field's value.
func (s *UpdateApplicationOutput) SetApplication(v *Application) *UpdateApplicationOutput {
	s.Application = v
	return s
}

type UpdateAttributeGroupInput struct {
	_ struct{} `type:"structure"`

	// The name or ID of the attribute group that holds the attributes to describe
	// the application.
	//
	// AttributeGroup is a required field
	AttributeGroup *string `location:"uri" locationName:"attributeGroup" min:"1" type:"string" required:"true"`

	// A JSON string in the form of nested key-value pairs that represent the attributes
	// in the group and describes an application and its components.
	Attributes *string `locationName:"attributes" min:"1" type:"string"`

	// The description of the attribute group that the user provides.
	Description *string `locationName:"description" type:"string"`

	// The new name of the attribute group. The name must be unique in the region
	// in which you are updating the attribute group.
	Name *string `locationName:"name" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttributeGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttributeGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateAttributeGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateAttributeGroupInput"}
	if s.AttributeGroup == nil {
		invalidParams.Add(request.NewErrParamRequired("AttributeGroup"))
	}
	if s.AttributeGroup != nil && len(*s.AttributeGroup) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AttributeGroup", 1))
	}
	if s.Attributes != nil && len(*s.Attributes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Attributes", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *UpdateAttributeGroupInput) SetAttributeGroup(v string) *UpdateAttributeGroupInput {
	s.AttributeGroup = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *UpdateAttributeGroupInput) SetAttributes(v string) *UpdateAttributeGroupInput {
	s.Attributes = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateAttributeGroupInput) SetDescription(v string) *UpdateAttributeGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateAttributeGroupInput) SetName(v string) *UpdateAttributeGroupInput {
	s.Name = &v
	return s
}

type UpdateAttributeGroupOutput struct {
	_ struct{} `type:"structure"`

	// The updated information of the attribute group.
	AttributeGroup *AttributeGroup `locationName:"attributeGroup" type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttributeGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateAttributeGroupOutput) GoString() string {
	return s.String()
}

// SetAttributeGroup sets the AttributeGroup field's value.
func (s *UpdateAttributeGroupOutput) SetAttributeGroup(v *AttributeGroup) *UpdateAttributeGroupOutput {
	s.AttributeGroup = v
	return s
}

// The request has invalid or missing parameters.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ResourceGroupStateCreating is a ResourceGroupState enum value
	ResourceGroupStateCreating = "CREATING"

	// ResourceGroupStateCreateComplete is a ResourceGroupState enum value
	ResourceGroupStateCreateComplete = "CREATE_COMPLETE"

	// ResourceGroupStateCreateFailed is a ResourceGroupState enum value
	ResourceGroupStateCreateFailed = "CREATE_FAILED"

	// ResourceGroupStateUpdating is a ResourceGroupState enum value
	ResourceGroupStateUpdating = "UPDATING"

	// ResourceGroupStateUpdateComplete is a ResourceGroupState enum value
	ResourceGroupStateUpdateComplete = "UPDATE_COMPLETE"

	// ResourceGroupStateUpdateFailed is a ResourceGroupState enum value
	ResourceGroupStateUpdateFailed = "UPDATE_FAILED"
)

// ResourceGroupState_Values returns all elements of the ResourceGroupState enum
func ResourceGroupState_Values() []string {
	return []string{
		ResourceGroupStateCreating,
		ResourceGroupStateCreateComplete,
		ResourceGroupStateCreateFailed,
		ResourceGroupStateUpdating,
		ResourceGroupStateUpdateComplete,
		ResourceGroupStateUpdateFailed,
	}
}

const (
	// ResourceTypeCfnStack is a ResourceType enum value
	ResourceTypeCfnStack = "CFN_STACK"
)

// ResourceType_Values returns all elements of the ResourceType enum
func ResourceType_Values() []string {
	return []string{
		ResourceTypeCfnStack,
	}
}

const (
	// SyncActionStartSync is a SyncAction enum value
	SyncActionStartSync = "START_SYNC"

	// SyncActionNoAction is a SyncAction enum value
	SyncActionNoAction = "NO_ACTION"
)

// SyncAction_Values returns all elements of the SyncAction enum
func SyncAction_Values() []string {
	return []string{
		SyncActionStartSync,
		SyncActionNoAction,
	}
}
