// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workspaces

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/jsonrpc"
)

const opAssociateConnectionAlias = "AssociateConnectionAlias"

// AssociateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the AssociateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateConnectionAlias for more information on using the AssociateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateConnectionAliasRequest method.
//    req, resp := client.AssociateConnectionAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias
func (c *WorkSpaces) AssociateConnectionAliasRequest(input *AssociateConnectionAliasInput) (req *request.Request, output *AssociateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opAssociateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateConnectionAliasInput{}
	}

	output = &AssociateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateConnectionAlias API operation for Amazon WorkSpaces.
//
// Associates the specified connection alias with the specified directory to
// enable cross-Region redirection. For more information, see Cross-Region Redirection
// for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
// to make sure that the current state of the connection alias is CREATED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateConnectionAlias for usage and error information.
//
// Returned Error Types:
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateConnectionAlias
func (c *WorkSpaces) AssociateConnectionAlias(input *AssociateConnectionAliasInput) (*AssociateConnectionAliasOutput, error) {
	req, out := c.AssociateConnectionAliasRequest(input)
	return out, req.Send()
}

// AssociateConnectionAliasWithContext is the same as AssociateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateConnectionAliasWithContext(ctx aws.Context, input *AssociateConnectionAliasInput, opts ...request.Option) (*AssociateConnectionAliasOutput, error) {
	req, out := c.AssociateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateIpGroups = "AssociateIpGroups"

// AssociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateIpGroups for more information on using the AssociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AssociateIpGroupsRequest method.
//    req, resp := client.AssociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroupsRequest(input *AssociateIpGroupsInput) (req *request.Request, output *AssociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opAssociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AssociateIpGroupsInput{}
	}

	output = &AssociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateIpGroups API operation for Amazon WorkSpaces.
//
// Associates the specified IP access control group with the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AssociateIpGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AssociateIpGroups
func (c *WorkSpaces) AssociateIpGroups(input *AssociateIpGroupsInput) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	return out, req.Send()
}

// AssociateIpGroupsWithContext is the same as AssociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AssociateIpGroupsWithContext(ctx aws.Context, input *AssociateIpGroupsInput, opts ...request.Option) (*AssociateIpGroupsOutput, error) {
	req, out := c.AssociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAuthorizeIpRules = "AuthorizeIpRules"

// AuthorizeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the AuthorizeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AuthorizeIpRules for more information on using the AuthorizeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the AuthorizeIpRulesRequest method.
//    req, resp := client.AuthorizeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRulesRequest(input *AuthorizeIpRulesInput) (req *request.Request, output *AuthorizeIpRulesOutput) {
	op := &request.Operation{
		Name:       opAuthorizeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AuthorizeIpRulesInput{}
	}

	output = &AuthorizeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AuthorizeIpRules API operation for Amazon WorkSpaces.
//
// Adds one or more rules to the specified IP access control group.
//
// This action gives users permission to access their WorkSpaces from the CIDR
// address ranges specified in the rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation AuthorizeIpRules for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/AuthorizeIpRules
func (c *WorkSpaces) AuthorizeIpRules(input *AuthorizeIpRulesInput) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	return out, req.Send()
}

// AuthorizeIpRulesWithContext is the same as AuthorizeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See AuthorizeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) AuthorizeIpRulesWithContext(ctx aws.Context, input *AuthorizeIpRulesInput, opts ...request.Option) (*AuthorizeIpRulesOutput, error) {
	req, out := c.AuthorizeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCopyWorkspaceImage = "CopyWorkspaceImage"

// CopyWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CopyWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CopyWorkspaceImage for more information on using the CopyWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CopyWorkspaceImageRequest method.
//    req, resp := client.CopyWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImageRequest(input *CopyWorkspaceImageInput) (req *request.Request, output *CopyWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCopyWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CopyWorkspaceImageInput{}
	}

	output = &CopyWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CopyWorkspaceImage API operation for Amazon WorkSpaces.
//
// Copies the specified image from the specified Region to the current Region.
// For more information about copying images, see Copy a Custom WorkSpaces Image
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
//
// In the China (Ningxia) Region, you can copy images only within the same Region.
//
// In Amazon Web Services GovCloud (US), to copy images to and from other Regions,
// contact Amazon Web Services Support.
//
// Before copying a shared image, be sure to verify that it has been shared
// from the correct Amazon Web Services account. To determine if an image has
// been shared and to see the ID of the Amazon Web Services account that owns
// an image, use the DescribeWorkSpaceImages (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html)
// and DescribeWorkspaceImagePermissions (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImagePermissions.html)
// API operations.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CopyWorkspaceImage for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CopyWorkspaceImage
func (c *WorkSpaces) CopyWorkspaceImage(input *CopyWorkspaceImageInput) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	return out, req.Send()
}

// CopyWorkspaceImageWithContext is the same as CopyWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CopyWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CopyWorkspaceImageWithContext(ctx aws.Context, input *CopyWorkspaceImageInput, opts ...request.Option) (*CopyWorkspaceImageOutput, error) {
	req, out := c.CopyWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectClientAddIn = "CreateConnectClientAddIn"

// CreateConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectClientAddIn for more information on using the CreateConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectClientAddInRequest method.
//    req, resp := client.CreateConnectClientAddInRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn
func (c *WorkSpaces) CreateConnectClientAddInRequest(input *CreateConnectClientAddInInput) (req *request.Request, output *CreateConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opCreateConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectClientAddInInput{}
	}

	output = &CreateConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Creates a client-add-in for Amazon Connect within a directory. You can create
// only one Amazon Connect client add-in within a directory.
//
// This client add-in allows WorkSpaces users to seamlessly connect to Amazon
// Connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceCreationFailedException
//   The resource could not be created.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectClientAddIn
func (c *WorkSpaces) CreateConnectClientAddIn(input *CreateConnectClientAddInInput) (*CreateConnectClientAddInOutput, error) {
	req, out := c.CreateConnectClientAddInRequest(input)
	return out, req.Send()
}

// CreateConnectClientAddInWithContext is the same as CreateConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateConnectClientAddInWithContext(ctx aws.Context, input *CreateConnectClientAddInInput, opts ...request.Option) (*CreateConnectClientAddInOutput, error) {
	req, out := c.CreateConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateConnectionAlias = "CreateConnectionAlias"

// CreateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the CreateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateConnectionAlias for more information on using the CreateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateConnectionAliasRequest method.
//    req, resp := client.CreateConnectionAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias
func (c *WorkSpaces) CreateConnectionAliasRequest(input *CreateConnectionAliasInput) (req *request.Request, output *CreateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opCreateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateConnectionAliasInput{}
	}

	output = &CreateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateConnectionAlias API operation for Amazon WorkSpaces.
//
// Creates the specified connection alias for use with cross-Region redirection.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateConnectionAlias for usage and error information.
//
// Returned Error Types:
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateConnectionAlias
func (c *WorkSpaces) CreateConnectionAlias(input *CreateConnectionAliasInput) (*CreateConnectionAliasOutput, error) {
	req, out := c.CreateConnectionAliasRequest(input)
	return out, req.Send()
}

// CreateConnectionAliasWithContext is the same as CreateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See CreateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateConnectionAliasWithContext(ctx aws.Context, input *CreateConnectionAliasInput, opts ...request.Option) (*CreateConnectionAliasOutput, error) {
	req, out := c.CreateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIpGroup = "CreateIpGroup"

// CreateIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIpGroup for more information on using the CreateIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateIpGroupRequest method.
//    req, resp := client.CreateIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroupRequest(input *CreateIpGroupInput) (req *request.Request, output *CreateIpGroupOutput) {
	op := &request.Operation{
		Name:       opCreateIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateIpGroupInput{}
	}

	output = &CreateIpGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIpGroup API operation for Amazon WorkSpaces.
//
// Creates an IP access control group.
//
// An IP access control group provides you with the ability to control the IP
// addresses from which users are allowed to access their WorkSpaces. To specify
// the CIDR address ranges, add rules to your IP access control group and then
// associate the group with your directory. You can add rules when you create
// the group or at any time using AuthorizeIpRules.
//
// There is a default IP access control group associated with your directory.
// If you don't associate an IP access control group with your directory, the
// default group is used. The default group includes a default rule that allows
// users to access their WorkSpaces from anywhere. You cannot modify the default
// IP access control group for your directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateIpGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceCreationFailedException
//   The resource could not be created.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateIpGroup
func (c *WorkSpaces) CreateIpGroup(input *CreateIpGroupInput) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	return out, req.Send()
}

// CreateIpGroupWithContext is the same as CreateIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateIpGroupWithContext(ctx aws.Context, input *CreateIpGroupInput, opts ...request.Option) (*CreateIpGroupOutput, error) {
	req, out := c.CreateIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTags = "CreateTags"

// CreateTagsRequest generates a "aws/request.Request" representing the
// client's request for the CreateTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTags for more information on using the CreateTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateTagsRequest method.
//    req, resp := client.CreateTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTagsRequest(input *CreateTagsInput) (req *request.Request, output *CreateTagsOutput) {
	op := &request.Operation{
		Name:       opCreateTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTagsInput{}
	}

	output = &CreateTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// CreateTags API operation for Amazon WorkSpaces.
//
// Creates the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateTags
func (c *WorkSpaces) CreateTags(input *CreateTagsInput) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	return out, req.Send()
}

// CreateTagsWithContext is the same as CreateTags with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateTagsWithContext(ctx aws.Context, input *CreateTagsInput, opts ...request.Option) (*CreateTagsOutput, error) {
	req, out := c.CreateTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUpdatedWorkspaceImage = "CreateUpdatedWorkspaceImage"

// CreateUpdatedWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the CreateUpdatedWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUpdatedWorkspaceImage for more information on using the CreateUpdatedWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateUpdatedWorkspaceImageRequest method.
//    req, resp := client.CreateUpdatedWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage
func (c *WorkSpaces) CreateUpdatedWorkspaceImageRequest(input *CreateUpdatedWorkspaceImageInput) (req *request.Request, output *CreateUpdatedWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opCreateUpdatedWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUpdatedWorkspaceImageInput{}
	}

	output = &CreateUpdatedWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUpdatedWorkspaceImage API operation for Amazon WorkSpaces.
//
// Creates a new updated WorkSpace image based on the specified source image.
// The new updated WorkSpace image has the latest drivers and other updates
// required by the Amazon WorkSpaces components.
//
// To determine which WorkSpace images need to be updated with the latest Amazon
// WorkSpaces requirements, use DescribeWorkspaceImages (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceImages.html).
//
//    * Only Windows 10, Windows Sever 2016, and Windows Server 2019 WorkSpace
//    images can be programmatically updated at this time.
//
//    * Microsoft Windows updates and other application updates are not included
//    in the update process.
//
//    * The source WorkSpace image is not deleted. You can delete the source
//    image after you've verified your new updated image and created a new bundle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateUpdatedWorkspaceImage for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateUpdatedWorkspaceImage
func (c *WorkSpaces) CreateUpdatedWorkspaceImage(input *CreateUpdatedWorkspaceImageInput) (*CreateUpdatedWorkspaceImageOutput, error) {
	req, out := c.CreateUpdatedWorkspaceImageRequest(input)
	return out, req.Send()
}

// CreateUpdatedWorkspaceImageWithContext is the same as CreateUpdatedWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUpdatedWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateUpdatedWorkspaceImageWithContext(ctx aws.Context, input *CreateUpdatedWorkspaceImageInput, opts ...request.Option) (*CreateUpdatedWorkspaceImageOutput, error) {
	req, out := c.CreateUpdatedWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaceBundle = "CreateWorkspaceBundle"

// CreateWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaceBundle for more information on using the CreateWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkspaceBundleRequest method.
//    req, resp := client.CreateWorkspaceBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle
func (c *WorkSpaces) CreateWorkspaceBundleRequest(input *CreateWorkspaceBundleInput) (req *request.Request, output *CreateWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspaceBundleInput{}
	}

	output = &CreateWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Creates the specified WorkSpace bundle. For more information about creating
// WorkSpace bundles, see Create a Custom WorkSpaces Image and Bundle (https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//   * ResourceUnavailableException
//   The specified resource is not available.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaceBundle
func (c *WorkSpaces) CreateWorkspaceBundle(input *CreateWorkspaceBundleInput) (*CreateWorkspaceBundleOutput, error) {
	req, out := c.CreateWorkspaceBundleRequest(input)
	return out, req.Send()
}

// CreateWorkspaceBundleWithContext is the same as CreateWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspaceBundleWithContext(ctx aws.Context, input *CreateWorkspaceBundleInput, opts ...request.Option) (*CreateWorkspaceBundleOutput, error) {
	req, out := c.CreateWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWorkspaces = "CreateWorkspaces"

// CreateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the CreateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateWorkspaces for more information on using the CreateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateWorkspacesRequest method.
//    req, resp := client.CreateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspacesRequest(input *CreateWorkspacesInput) (req *request.Request, output *CreateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opCreateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWorkspacesInput{}
	}

	output = &CreateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateWorkspaces API operation for Amazon WorkSpaces.
//
// Creates one or more WorkSpaces.
//
// This operation is asynchronous and returns before the WorkSpaces are created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation CreateWorkspaces for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/CreateWorkspaces
func (c *WorkSpaces) CreateWorkspaces(input *CreateWorkspacesInput) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	return out, req.Send()
}

// CreateWorkspacesWithContext is the same as CreateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) CreateWorkspacesWithContext(ctx aws.Context, input *CreateWorkspacesInput, opts ...request.Option) (*CreateWorkspacesOutput, error) {
	req, out := c.CreateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectClientAddIn = "DeleteConnectClientAddIn"

// DeleteConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectClientAddIn for more information on using the DeleteConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectClientAddInRequest method.
//    req, resp := client.DeleteConnectClientAddInRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn
func (c *WorkSpaces) DeleteConnectClientAddInRequest(input *DeleteConnectClientAddInInput) (req *request.Request, output *DeleteConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectClientAddInInput{}
	}

	output = &DeleteConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Deletes a client-add-in for Amazon Connect that is configured within a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectClientAddIn
func (c *WorkSpaces) DeleteConnectClientAddIn(input *DeleteConnectClientAddInInput) (*DeleteConnectClientAddInOutput, error) {
	req, out := c.DeleteConnectClientAddInRequest(input)
	return out, req.Send()
}

// DeleteConnectClientAddInWithContext is the same as DeleteConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteConnectClientAddInWithContext(ctx aws.Context, input *DeleteConnectClientAddInInput, opts ...request.Option) (*DeleteConnectClientAddInOutput, error) {
	req, out := c.DeleteConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteConnectionAlias = "DeleteConnectionAlias"

// DeleteConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the DeleteConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteConnectionAlias for more information on using the DeleteConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteConnectionAliasRequest method.
//    req, resp := client.DeleteConnectionAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias
func (c *WorkSpaces) DeleteConnectionAliasRequest(input *DeleteConnectionAliasInput) (req *request.Request, output *DeleteConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opDeleteConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteConnectionAliasInput{}
	}

	output = &DeleteConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteConnectionAlias API operation for Amazon WorkSpaces.
//
// Deletes the specified connection alias. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// If you will no longer be using a fully qualified domain name (FQDN) as the
// registration code for your WorkSpaces users, you must take certain precautions
// to prevent potential security issues. For more information, see Security
// Considerations if You Stop Using Cross-Region Redirection (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html#cross-region-redirection-security-considerations).
//
// To delete a connection alias that has been shared, the shared account must
// first disassociate the connection alias from any directories it has been
// associated with. Then you must unshare the connection alias from the account
// it has been shared with. You can delete a connection alias only after it
// is no longer shared with any accounts or associated with any directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteConnectionAlias for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteConnectionAlias
func (c *WorkSpaces) DeleteConnectionAlias(input *DeleteConnectionAliasInput) (*DeleteConnectionAliasOutput, error) {
	req, out := c.DeleteConnectionAliasRequest(input)
	return out, req.Send()
}

// DeleteConnectionAliasWithContext is the same as DeleteConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteConnectionAliasWithContext(ctx aws.Context, input *DeleteConnectionAliasInput, opts ...request.Option) (*DeleteConnectionAliasOutput, error) {
	req, out := c.DeleteConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIpGroup = "DeleteIpGroup"

// DeleteIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIpGroup for more information on using the DeleteIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteIpGroupRequest method.
//    req, resp := client.DeleteIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroupRequest(input *DeleteIpGroupInput) (req *request.Request, output *DeleteIpGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteIpGroupInput{}
	}

	output = &DeleteIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIpGroup API operation for Amazon WorkSpaces.
//
// Deletes the specified IP access control group.
//
// You cannot delete an IP access control group that is associated with a directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteIpGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteIpGroup
func (c *WorkSpaces) DeleteIpGroup(input *DeleteIpGroupInput) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	return out, req.Send()
}

// DeleteIpGroupWithContext is the same as DeleteIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteIpGroupWithContext(ctx aws.Context, input *DeleteIpGroupInput, opts ...request.Option) (*DeleteIpGroupOutput, error) {
	req, out := c.DeleteIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTags = "DeleteTags"

// DeleteTagsRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTags for more information on using the DeleteTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteTagsRequest method.
//    req, resp := client.DeleteTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTagsRequest(input *DeleteTagsInput) (req *request.Request, output *DeleteTagsOutput) {
	op := &request.Operation{
		Name:       opDeleteTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteTagsInput{}
	}

	output = &DeleteTagsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTags API operation for Amazon WorkSpaces.
//
// Deletes the specified tags from the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteTags
func (c *WorkSpaces) DeleteTags(input *DeleteTagsInput) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	return out, req.Send()
}

// DeleteTagsWithContext is the same as DeleteTags with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteTagsWithContext(ctx aws.Context, input *DeleteTagsInput, opts ...request.Option) (*DeleteTagsOutput, error) {
	req, out := c.DeleteTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceBundle = "DeleteWorkspaceBundle"

// DeleteWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceBundle for more information on using the DeleteWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkspaceBundleRequest method.
//    req, resp := client.DeleteWorkspaceBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle
func (c *WorkSpaces) DeleteWorkspaceBundleRequest(input *DeleteWorkspaceBundleInput) (req *request.Request, output *DeleteWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceBundleInput{}
	}

	output = &DeleteWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Deletes the specified WorkSpace bundle. For more information about deleting
// WorkSpace bundles, see Delete a Custom WorkSpaces Bundle or Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceBundle
func (c *WorkSpaces) DeleteWorkspaceBundle(input *DeleteWorkspaceBundleInput) (*DeleteWorkspaceBundleOutput, error) {
	req, out := c.DeleteWorkspaceBundleRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceBundleWithContext is the same as DeleteWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteWorkspaceBundleWithContext(ctx aws.Context, input *DeleteWorkspaceBundleInput, opts ...request.Option) (*DeleteWorkspaceBundleOutput, error) {
	req, out := c.DeleteWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteWorkspaceImage = "DeleteWorkspaceImage"

// DeleteWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the DeleteWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteWorkspaceImage for more information on using the DeleteWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteWorkspaceImageRequest method.
//    req, resp := client.DeleteWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImageRequest(input *DeleteWorkspaceImageInput) (req *request.Request, output *DeleteWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opDeleteWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeleteWorkspaceImageInput{}
	}

	output = &DeleteWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteWorkspaceImage API operation for Amazon WorkSpaces.
//
// Deletes the specified image from your account. To delete an image, you must
// first delete any bundles that are associated with the image and unshare the
// image if it is shared with other accounts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeleteWorkspaceImage for usage and error information.
//
// Returned Error Types:
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeleteWorkspaceImage
func (c *WorkSpaces) DeleteWorkspaceImage(input *DeleteWorkspaceImageInput) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	return out, req.Send()
}

// DeleteWorkspaceImageWithContext is the same as DeleteWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeleteWorkspaceImageWithContext(ctx aws.Context, input *DeleteWorkspaceImageInput, opts ...request.Option) (*DeleteWorkspaceImageOutput, error) {
	req, out := c.DeleteWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeregisterWorkspaceDirectory = "DeregisterWorkspaceDirectory"

// DeregisterWorkspaceDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the DeregisterWorkspaceDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeregisterWorkspaceDirectory for more information on using the DeregisterWorkspaceDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeregisterWorkspaceDirectoryRequest method.
//    req, resp := client.DeregisterWorkspaceDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory
func (c *WorkSpaces) DeregisterWorkspaceDirectoryRequest(input *DeregisterWorkspaceDirectoryInput) (req *request.Request, output *DeregisterWorkspaceDirectoryOutput) {
	op := &request.Operation{
		Name:       opDeregisterWorkspaceDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DeregisterWorkspaceDirectoryInput{}
	}

	output = &DeregisterWorkspaceDirectoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeregisterWorkspaceDirectory API operation for Amazon WorkSpaces.
//
// Deregisters the specified directory. This operation is asynchronous and returns
// before the WorkSpace directory is deregistered. If any WorkSpaces are registered
// to this directory, you must remove them before you can deregister the directory.
//
// Simple AD and AD Connector are made available to you free of charge to use
// with WorkSpaces. If there are no WorkSpaces being used with your Simple AD
// or AD Connector directory for 30 consecutive days, this directory will be
// automatically deregistered for use with Amazon WorkSpaces, and you will be
// charged for this directory as per the Directory Service pricing terms (http://aws.amazon.com/directoryservice/pricing/).
//
// To delete empty directories, see Delete the Directory for Your WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
// If you delete your Simple AD or AD Connector directory, you can always create
// a new one when you want to start using WorkSpaces again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DeregisterWorkspaceDirectory for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DeregisterWorkspaceDirectory
func (c *WorkSpaces) DeregisterWorkspaceDirectory(input *DeregisterWorkspaceDirectoryInput) (*DeregisterWorkspaceDirectoryOutput, error) {
	req, out := c.DeregisterWorkspaceDirectoryRequest(input)
	return out, req.Send()
}

// DeregisterWorkspaceDirectoryWithContext is the same as DeregisterWorkspaceDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See DeregisterWorkspaceDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DeregisterWorkspaceDirectoryWithContext(ctx aws.Context, input *DeregisterWorkspaceDirectoryInput, opts ...request.Option) (*DeregisterWorkspaceDirectoryOutput, error) {
	req, out := c.DeregisterWorkspaceDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccount = "DescribeAccount"

// DescribeAccountRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccount for more information on using the DescribeAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountRequest method.
//    req, resp := client.DescribeAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccountRequest(input *DescribeAccountInput) (req *request.Request, output *DescribeAccountOutput) {
	op := &request.Operation{
		Name:       opDescribeAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountInput{}
	}

	output = &DescribeAccountOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccount API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the configuration of Bring Your Own License
// (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccount for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccount
func (c *WorkSpaces) DescribeAccount(input *DescribeAccountInput) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	return out, req.Send()
}

// DescribeAccountWithContext is the same as DescribeAccount with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountWithContext(ctx aws.Context, input *DescribeAccountInput, opts ...request.Option) (*DescribeAccountOutput, error) {
	req, out := c.DescribeAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAccountModifications = "DescribeAccountModifications"

// DescribeAccountModificationsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAccountModifications operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAccountModifications for more information on using the DescribeAccountModifications
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeAccountModificationsRequest method.
//    req, resp := client.DescribeAccountModificationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModificationsRequest(input *DescribeAccountModificationsInput) (req *request.Request, output *DescribeAccountModificationsOutput) {
	op := &request.Operation{
		Name:       opDescribeAccountModifications,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAccountModificationsInput{}
	}

	output = &DescribeAccountModificationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAccountModifications API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes modifications to the configuration of Bring
// Your Own License (BYOL) for the specified account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeAccountModifications for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeAccountModifications
func (c *WorkSpaces) DescribeAccountModifications(input *DescribeAccountModificationsInput) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	return out, req.Send()
}

// DescribeAccountModificationsWithContext is the same as DescribeAccountModifications with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAccountModifications for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeAccountModificationsWithContext(ctx aws.Context, input *DescribeAccountModificationsInput, opts ...request.Option) (*DescribeAccountModificationsOutput, error) {
	req, out := c.DescribeAccountModificationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeClientProperties = "DescribeClientProperties"

// DescribeClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeClientProperties for more information on using the DescribeClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeClientPropertiesRequest method.
//    req, resp := client.DescribeClientPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientPropertiesRequest(input *DescribeClientPropertiesInput) (req *request.Request, output *DescribeClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opDescribeClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeClientPropertiesInput{}
	}

	output = &DescribeClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeClientProperties API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeClientProperties for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeClientProperties
func (c *WorkSpaces) DescribeClientProperties(input *DescribeClientPropertiesInput) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	return out, req.Send()
}

// DescribeClientPropertiesWithContext is the same as DescribeClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeClientPropertiesWithContext(ctx aws.Context, input *DescribeClientPropertiesInput, opts ...request.Option) (*DescribeClientPropertiesOutput, error) {
	req, out := c.DescribeClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectClientAddIns = "DescribeConnectClientAddIns"

// DescribeConnectClientAddInsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectClientAddIns operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectClientAddIns for more information on using the DescribeConnectClientAddIns
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectClientAddInsRequest method.
//    req, resp := client.DescribeConnectClientAddInsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns
func (c *WorkSpaces) DescribeConnectClientAddInsRequest(input *DescribeConnectClientAddInsInput) (req *request.Request, output *DescribeConnectClientAddInsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectClientAddIns,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectClientAddInsInput{}
	}

	output = &DescribeConnectClientAddInsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectClientAddIns API operation for Amazon WorkSpaces.
//
// Retrieves a list of Amazon Connect client add-ins that have been created.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectClientAddIns for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectClientAddIns
func (c *WorkSpaces) DescribeConnectClientAddIns(input *DescribeConnectClientAddInsInput) (*DescribeConnectClientAddInsOutput, error) {
	req, out := c.DescribeConnectClientAddInsRequest(input)
	return out, req.Send()
}

// DescribeConnectClientAddInsWithContext is the same as DescribeConnectClientAddIns with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectClientAddIns for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectClientAddInsWithContext(ctx aws.Context, input *DescribeConnectClientAddInsInput, opts ...request.Option) (*DescribeConnectClientAddInsOutput, error) {
	req, out := c.DescribeConnectClientAddInsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionAliasPermissions = "DescribeConnectionAliasPermissions"

// DescribeConnectionAliasPermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionAliasPermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionAliasPermissions for more information on using the DescribeConnectionAliasPermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionAliasPermissionsRequest method.
//    req, resp := client.DescribeConnectionAliasPermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions
func (c *WorkSpaces) DescribeConnectionAliasPermissionsRequest(input *DescribeConnectionAliasPermissionsInput) (req *request.Request, output *DescribeConnectionAliasPermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectionAliasPermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionAliasPermissionsInput{}
	}

	output = &DescribeConnectionAliasPermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionAliasPermissions API operation for Amazon WorkSpaces.
//
// Describes the permissions that the owner of a connection alias has granted
// to another Amazon Web Services account for the specified connection alias.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectionAliasPermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliasPermissions
func (c *WorkSpaces) DescribeConnectionAliasPermissions(input *DescribeConnectionAliasPermissionsInput) (*DescribeConnectionAliasPermissionsOutput, error) {
	req, out := c.DescribeConnectionAliasPermissionsRequest(input)
	return out, req.Send()
}

// DescribeConnectionAliasPermissionsWithContext is the same as DescribeConnectionAliasPermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionAliasPermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectionAliasPermissionsWithContext(ctx aws.Context, input *DescribeConnectionAliasPermissionsInput, opts ...request.Option) (*DescribeConnectionAliasPermissionsOutput, error) {
	req, out := c.DescribeConnectionAliasPermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeConnectionAliases = "DescribeConnectionAliases"

// DescribeConnectionAliasesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeConnectionAliases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeConnectionAliases for more information on using the DescribeConnectionAliases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeConnectionAliasesRequest method.
//    req, resp := client.DescribeConnectionAliasesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases
func (c *WorkSpaces) DescribeConnectionAliasesRequest(input *DescribeConnectionAliasesInput) (req *request.Request, output *DescribeConnectionAliasesOutput) {
	op := &request.Operation{
		Name:       opDescribeConnectionAliases,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeConnectionAliasesInput{}
	}

	output = &DescribeConnectionAliasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeConnectionAliases API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the connection aliases used for cross-Region
// redirection. For more information, see Cross-Region Redirection for Amazon
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeConnectionAliases for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeConnectionAliases
func (c *WorkSpaces) DescribeConnectionAliases(input *DescribeConnectionAliasesInput) (*DescribeConnectionAliasesOutput, error) {
	req, out := c.DescribeConnectionAliasesRequest(input)
	return out, req.Send()
}

// DescribeConnectionAliasesWithContext is the same as DescribeConnectionAliases with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeConnectionAliases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeConnectionAliasesWithContext(ctx aws.Context, input *DescribeConnectionAliasesInput, opts ...request.Option) (*DescribeConnectionAliasesOutput, error) {
	req, out := c.DescribeConnectionAliasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeIpGroups = "DescribeIpGroups"

// DescribeIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeIpGroups for more information on using the DescribeIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeIpGroupsRequest method.
//    req, resp := client.DescribeIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroupsRequest(input *DescribeIpGroupsInput) (req *request.Request, output *DescribeIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeIpGroupsInput{}
	}

	output = &DescribeIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeIpGroups API operation for Amazon WorkSpaces.
//
// Describes one or more of your IP access control groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeIpGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeIpGroups
func (c *WorkSpaces) DescribeIpGroups(input *DescribeIpGroupsInput) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	return out, req.Send()
}

// DescribeIpGroupsWithContext is the same as DescribeIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeIpGroupsWithContext(ctx aws.Context, input *DescribeIpGroupsInput, opts ...request.Option) (*DescribeIpGroupsOutput, error) {
	req, out := c.DescribeIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTags = "DescribeTags"

// DescribeTagsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTags operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTags for more information on using the DescribeTags
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeTagsRequest method.
//    req, resp := client.DescribeTagsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTagsRequest(input *DescribeTagsInput) (req *request.Request, output *DescribeTagsOutput) {
	op := &request.Operation{
		Name:       opDescribeTags,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagsInput{}
	}

	output = &DescribeTagsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTags API operation for Amazon WorkSpaces.
//
// Describes the specified tags for the specified WorkSpaces resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeTags for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeTags
func (c *WorkSpaces) DescribeTags(input *DescribeTagsInput) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	return out, req.Send()
}

// DescribeTagsWithContext is the same as DescribeTags with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTags for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeTagsWithContext(ctx aws.Context, input *DescribeTagsInput, opts ...request.Option) (*DescribeTagsOutput, error) {
	req, out := c.DescribeTagsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceBundles = "DescribeWorkspaceBundles"

// DescribeWorkspaceBundlesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceBundles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceBundles for more information on using the DescribeWorkspaceBundles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceBundlesRequest method.
//    req, resp := client.DescribeWorkspaceBundlesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundlesRequest(input *DescribeWorkspaceBundlesInput) (req *request.Request, output *DescribeWorkspaceBundlesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceBundles,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceBundlesInput{}
	}

	output = &DescribeWorkspaceBundlesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceBundles API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes the available WorkSpace bundles.
//
// You can filter the results using either bundle ID or owner, but not both.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceBundles for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceBundles
func (c *WorkSpaces) DescribeWorkspaceBundles(input *DescribeWorkspaceBundlesInput) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceBundlesWithContext is the same as DescribeWorkspaceBundles with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceBundles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, opts ...request.Option) (*DescribeWorkspaceBundlesOutput, error) {
	req, out := c.DescribeWorkspaceBundlesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceBundlesPages iterates over the pages of a DescribeWorkspaceBundles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceBundles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceBundles operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceBundlesPages(params,
//        func(page *workspaces.DescribeWorkspaceBundlesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceBundlesPages(input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool) error {
	return c.DescribeWorkspaceBundlesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceBundlesPagesWithContext same as DescribeWorkspaceBundlesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceBundlesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceBundlesInput, fn func(*DescribeWorkspaceBundlesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceBundlesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceBundlesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspaceBundlesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspaceDirectories = "DescribeWorkspaceDirectories"

// DescribeWorkspaceDirectoriesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceDirectories operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceDirectories for more information on using the DescribeWorkspaceDirectories
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceDirectoriesRequest method.
//    req, resp := client.DescribeWorkspaceDirectoriesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectoriesRequest(input *DescribeWorkspaceDirectoriesInput) (req *request.Request, output *DescribeWorkspaceDirectoriesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceDirectories,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspaceDirectoriesInput{}
	}

	output = &DescribeWorkspaceDirectoriesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceDirectories API operation for Amazon WorkSpaces.
//
// Describes the available directories that are registered with Amazon WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceDirectories for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceDirectories
func (c *WorkSpaces) DescribeWorkspaceDirectories(input *DescribeWorkspaceDirectoriesInput) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesWithContext is the same as DescribeWorkspaceDirectories with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceDirectories for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, opts ...request.Option) (*DescribeWorkspaceDirectoriesOutput, error) {
	req, out := c.DescribeWorkspaceDirectoriesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspaceDirectoriesPages iterates over the pages of a DescribeWorkspaceDirectories operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaceDirectories method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaceDirectories operation.
//    pageNum := 0
//    err := client.DescribeWorkspaceDirectoriesPages(params,
//        func(page *workspaces.DescribeWorkspaceDirectoriesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPages(input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool) error {
	return c.DescribeWorkspaceDirectoriesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspaceDirectoriesPagesWithContext same as DescribeWorkspaceDirectoriesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceDirectoriesPagesWithContext(ctx aws.Context, input *DescribeWorkspaceDirectoriesInput, fn func(*DescribeWorkspaceDirectoriesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspaceDirectoriesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspaceDirectoriesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspaceDirectoriesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspaceImagePermissions = "DescribeWorkspaceImagePermissions"

// DescribeWorkspaceImagePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceImagePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceImagePermissions for more information on using the DescribeWorkspaceImagePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceImagePermissionsRequest method.
//    req, resp := client.DescribeWorkspaceImagePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions
func (c *WorkSpaces) DescribeWorkspaceImagePermissionsRequest(input *DescribeWorkspaceImagePermissionsInput) (req *request.Request, output *DescribeWorkspaceImagePermissionsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceImagePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagePermissionsInput{}
	}

	output = &DescribeWorkspaceImagePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceImagePermissions API operation for Amazon WorkSpaces.
//
// Describes the permissions that the owner of an image has granted to other
// Amazon Web Services accounts for an image.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceImagePermissions for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImagePermissions
func (c *WorkSpaces) DescribeWorkspaceImagePermissions(input *DescribeWorkspaceImagePermissionsInput) (*DescribeWorkspaceImagePermissionsOutput, error) {
	req, out := c.DescribeWorkspaceImagePermissionsRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceImagePermissionsWithContext is the same as DescribeWorkspaceImagePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceImagePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceImagePermissionsWithContext(ctx aws.Context, input *DescribeWorkspaceImagePermissionsInput, opts ...request.Option) (*DescribeWorkspaceImagePermissionsOutput, error) {
	req, out := c.DescribeWorkspaceImagePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceImages = "DescribeWorkspaceImages"

// DescribeWorkspaceImagesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceImages operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceImages for more information on using the DescribeWorkspaceImages
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceImagesRequest method.
//    req, resp := client.DescribeWorkspaceImagesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImagesRequest(input *DescribeWorkspaceImagesInput) (req *request.Request, output *DescribeWorkspaceImagesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceImages,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceImagesInput{}
	}

	output = &DescribeWorkspaceImagesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceImages API operation for Amazon WorkSpaces.
//
// Retrieves a list that describes one or more specified images, if the image
// identifiers are provided. Otherwise, all images in the account are described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceImages for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceImages
func (c *WorkSpaces) DescribeWorkspaceImages(input *DescribeWorkspaceImagesInput) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceImagesWithContext is the same as DescribeWorkspaceImages with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceImages for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceImagesWithContext(ctx aws.Context, input *DescribeWorkspaceImagesInput, opts ...request.Option) (*DescribeWorkspaceImagesOutput, error) {
	req, out := c.DescribeWorkspaceImagesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaceSnapshots = "DescribeWorkspaceSnapshots"

// DescribeWorkspaceSnapshotsRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaceSnapshots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaceSnapshots for more information on using the DescribeWorkspaceSnapshots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspaceSnapshotsRequest method.
//    req, resp := client.DescribeWorkspaceSnapshotsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots
func (c *WorkSpaces) DescribeWorkspaceSnapshotsRequest(input *DescribeWorkspaceSnapshotsInput) (req *request.Request, output *DescribeWorkspaceSnapshotsOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaceSnapshots,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspaceSnapshotsInput{}
	}

	output = &DescribeWorkspaceSnapshotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaceSnapshots API operation for Amazon WorkSpaces.
//
// Describes the snapshots for the specified WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaceSnapshots for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaceSnapshots
func (c *WorkSpaces) DescribeWorkspaceSnapshots(input *DescribeWorkspaceSnapshotsInput) (*DescribeWorkspaceSnapshotsOutput, error) {
	req, out := c.DescribeWorkspaceSnapshotsRequest(input)
	return out, req.Send()
}

// DescribeWorkspaceSnapshotsWithContext is the same as DescribeWorkspaceSnapshots with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaceSnapshots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspaceSnapshotsWithContext(ctx aws.Context, input *DescribeWorkspaceSnapshotsInput, opts ...request.Option) (*DescribeWorkspaceSnapshotsOutput, error) {
	req, out := c.DescribeWorkspaceSnapshotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeWorkspaces = "DescribeWorkspaces"

// DescribeWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspaces for more information on using the DescribeWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesRequest method.
//    req, resp := client.DescribeWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspacesRequest(input *DescribeWorkspacesInput) (req *request.Request, output *DescribeWorkspacesOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "Limit",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &DescribeWorkspacesInput{}
	}

	output = &DescribeWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspaces API operation for Amazon WorkSpaces.
//
// Describes the specified WorkSpaces.
//
// You can filter the results by using the bundle identifier, directory identifier,
// or owner, but you can specify only one filter at a time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspaces for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspaces
func (c *WorkSpaces) DescribeWorkspaces(input *DescribeWorkspacesInput) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesWithContext is the same as DescribeWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, opts ...request.Option) (*DescribeWorkspacesOutput, error) {
	req, out := c.DescribeWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// DescribeWorkspacesPages iterates over the pages of a DescribeWorkspaces operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See DescribeWorkspaces method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//    // Example iterating over at most 3 pages of a DescribeWorkspaces operation.
//    pageNum := 0
//    err := client.DescribeWorkspacesPages(params,
//        func(page *workspaces.DescribeWorkspacesOutput, lastPage bool) bool {
//            pageNum++
//            fmt.Println(page)
//            return pageNum <= 3
//        })
//
func (c *WorkSpaces) DescribeWorkspacesPages(input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool) error {
	return c.DescribeWorkspacesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// DescribeWorkspacesPagesWithContext same as DescribeWorkspacesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesPagesWithContext(ctx aws.Context, input *DescribeWorkspacesInput, fn func(*DescribeWorkspacesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *DescribeWorkspacesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.DescribeWorkspacesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*DescribeWorkspacesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opDescribeWorkspacesConnectionStatus = "DescribeWorkspacesConnectionStatus"

// DescribeWorkspacesConnectionStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeWorkspacesConnectionStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeWorkspacesConnectionStatus for more information on using the DescribeWorkspacesConnectionStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DescribeWorkspacesConnectionStatusRequest method.
//    req, resp := client.DescribeWorkspacesConnectionStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusRequest(input *DescribeWorkspacesConnectionStatusInput) (req *request.Request, output *DescribeWorkspacesConnectionStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeWorkspacesConnectionStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeWorkspacesConnectionStatusInput{}
	}

	output = &DescribeWorkspacesConnectionStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeWorkspacesConnectionStatus API operation for Amazon WorkSpaces.
//
// Describes the connection status of the specified WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DescribeWorkspacesConnectionStatus for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DescribeWorkspacesConnectionStatus
func (c *WorkSpaces) DescribeWorkspacesConnectionStatus(input *DescribeWorkspacesConnectionStatusInput) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	return out, req.Send()
}

// DescribeWorkspacesConnectionStatusWithContext is the same as DescribeWorkspacesConnectionStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeWorkspacesConnectionStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DescribeWorkspacesConnectionStatusWithContext(ctx aws.Context, input *DescribeWorkspacesConnectionStatusInput, opts ...request.Option) (*DescribeWorkspacesConnectionStatusOutput, error) {
	req, out := c.DescribeWorkspacesConnectionStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateConnectionAlias = "DisassociateConnectionAlias"

// DisassociateConnectionAliasRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateConnectionAlias operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateConnectionAlias for more information on using the DisassociateConnectionAlias
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateConnectionAliasRequest method.
//    req, resp := client.DisassociateConnectionAliasRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias
func (c *WorkSpaces) DisassociateConnectionAliasRequest(input *DisassociateConnectionAliasInput) (req *request.Request, output *DisassociateConnectionAliasOutput) {
	op := &request.Operation{
		Name:       opDisassociateConnectionAlias,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateConnectionAliasInput{}
	}

	output = &DisassociateConnectionAliasOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateConnectionAlias API operation for Amazon WorkSpaces.
//
// Disassociates a connection alias from a directory. Disassociating a connection
// alias disables cross-Region redirection between two directories in different
// Regions. For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
// Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
// to make sure that the current state of the connection alias is CREATED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateConnectionAlias for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateConnectionAlias
func (c *WorkSpaces) DisassociateConnectionAlias(input *DisassociateConnectionAliasInput) (*DisassociateConnectionAliasOutput, error) {
	req, out := c.DisassociateConnectionAliasRequest(input)
	return out, req.Send()
}

// DisassociateConnectionAliasWithContext is the same as DisassociateConnectionAlias with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateConnectionAlias for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateConnectionAliasWithContext(ctx aws.Context, input *DisassociateConnectionAliasInput, opts ...request.Option) (*DisassociateConnectionAliasOutput, error) {
	req, out := c.DisassociateConnectionAliasRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateIpGroups = "DisassociateIpGroups"

// DisassociateIpGroupsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateIpGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateIpGroups for more information on using the DisassociateIpGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DisassociateIpGroupsRequest method.
//    req, resp := client.DisassociateIpGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroupsRequest(input *DisassociateIpGroupsInput) (req *request.Request, output *DisassociateIpGroupsOutput) {
	op := &request.Operation{
		Name:       opDisassociateIpGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisassociateIpGroupsInput{}
	}

	output = &DisassociateIpGroupsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateIpGroups API operation for Amazon WorkSpaces.
//
// Disassociates the specified IP access control group from the specified directory.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation DisassociateIpGroups for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/DisassociateIpGroups
func (c *WorkSpaces) DisassociateIpGroups(input *DisassociateIpGroupsInput) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	return out, req.Send()
}

// DisassociateIpGroupsWithContext is the same as DisassociateIpGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateIpGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) DisassociateIpGroupsWithContext(ctx aws.Context, input *DisassociateIpGroupsInput, opts ...request.Option) (*DisassociateIpGroupsOutput, error) {
	req, out := c.DisassociateIpGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opImportWorkspaceImage = "ImportWorkspaceImage"

// ImportWorkspaceImageRequest generates a "aws/request.Request" representing the
// client's request for the ImportWorkspaceImage operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ImportWorkspaceImage for more information on using the ImportWorkspaceImage
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ImportWorkspaceImageRequest method.
//    req, resp := client.ImportWorkspaceImageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImageRequest(input *ImportWorkspaceImageInput) (req *request.Request, output *ImportWorkspaceImageOutput) {
	op := &request.Operation{
		Name:       opImportWorkspaceImage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ImportWorkspaceImageInput{}
	}

	output = &ImportWorkspaceImageOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ImportWorkspaceImage API operation for Amazon WorkSpaces.
//
// Imports the specified Windows 10 Bring Your Own License (BYOL) image into
// Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image
// that is in your Amazon Web Services account, and you must own the image.
// For more information about creating BYOL images, see Bring Your Own Windows
// Desktop Licenses (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ImportWorkspaceImage for usage and error information.
//
// Returned Error Types:
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * ResourceAlreadyExistsException
//   The specified resource already exists.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ImportWorkspaceImage
func (c *WorkSpaces) ImportWorkspaceImage(input *ImportWorkspaceImageInput) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	return out, req.Send()
}

// ImportWorkspaceImageWithContext is the same as ImportWorkspaceImage with the addition of
// the ability to pass a context and additional request options.
//
// See ImportWorkspaceImage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ImportWorkspaceImageWithContext(ctx aws.Context, input *ImportWorkspaceImageInput, opts ...request.Option) (*ImportWorkspaceImageOutput, error) {
	req, out := c.ImportWorkspaceImageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAvailableManagementCidrRanges = "ListAvailableManagementCidrRanges"

// ListAvailableManagementCidrRangesRequest generates a "aws/request.Request" representing the
// client's request for the ListAvailableManagementCidrRanges operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAvailableManagementCidrRanges for more information on using the ListAvailableManagementCidrRanges
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListAvailableManagementCidrRangesRequest method.
//    req, resp := client.ListAvailableManagementCidrRangesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRangesRequest(input *ListAvailableManagementCidrRangesInput) (req *request.Request, output *ListAvailableManagementCidrRangesOutput) {
	op := &request.Operation{
		Name:       opListAvailableManagementCidrRanges,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListAvailableManagementCidrRangesInput{}
	}

	output = &ListAvailableManagementCidrRangesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAvailableManagementCidrRanges API operation for Amazon WorkSpaces.
//
// Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that
// you can use for the network management interface when you enable Bring Your
// Own License (BYOL).
//
// This operation can be run only by Amazon Web Services accounts that are enabled
// for BYOL. If your account isn't enabled for BYOL, you'll receive an AccessDeniedException
// error.
//
// The management network interface is connected to a secure Amazon WorkSpaces
// management network. It is used for interactive streaming of the WorkSpace
// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
// the WorkSpace.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ListAvailableManagementCidrRanges for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ListAvailableManagementCidrRanges
func (c *WorkSpaces) ListAvailableManagementCidrRanges(input *ListAvailableManagementCidrRangesInput) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	return out, req.Send()
}

// ListAvailableManagementCidrRangesWithContext is the same as ListAvailableManagementCidrRanges with the addition of
// the ability to pass a context and additional request options.
//
// See ListAvailableManagementCidrRanges for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ListAvailableManagementCidrRangesWithContext(ctx aws.Context, input *ListAvailableManagementCidrRangesInput, opts ...request.Option) (*ListAvailableManagementCidrRangesOutput, error) {
	req, out := c.ListAvailableManagementCidrRangesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opMigrateWorkspace = "MigrateWorkspace"

// MigrateWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the MigrateWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MigrateWorkspace for more information on using the MigrateWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the MigrateWorkspaceRequest method.
//    req, resp := client.MigrateWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace
func (c *WorkSpaces) MigrateWorkspaceRequest(input *MigrateWorkspaceInput) (req *request.Request, output *MigrateWorkspaceOutput) {
	op := &request.Operation{
		Name:       opMigrateWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &MigrateWorkspaceInput{}
	}

	output = &MigrateWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MigrateWorkspace API operation for Amazon WorkSpaces.
//
// Migrates a WorkSpace from one operating system or bundle type to another,
// while retaining the data on the user volume.
//
// The migration process recreates the WorkSpace by using a new root volume
// from the target bundle image and the user volume from the last available
// snapshot of the original WorkSpace. During migration, the original D:\Users\%USERNAME%
// user profile folder is renamed to D:\Users\%USERNAME%MMddyyTHHmmss%.NotMigrated.
// A new D:\Users\%USERNAME%\ folder is generated by the new OS. Certain files
// in the old user profile are moved to the new user profile.
//
// For available migration scenarios, details about what happens during migration,
// and best practices, see Migrate a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/migrate-workspaces.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation MigrateWorkspace for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
//   * OperationInProgressException
//   The properties of this WorkSpace are currently being modified. Try again
//   in a moment.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/MigrateWorkspace
func (c *WorkSpaces) MigrateWorkspace(input *MigrateWorkspaceInput) (*MigrateWorkspaceOutput, error) {
	req, out := c.MigrateWorkspaceRequest(input)
	return out, req.Send()
}

// MigrateWorkspaceWithContext is the same as MigrateWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See MigrateWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) MigrateWorkspaceWithContext(ctx aws.Context, input *MigrateWorkspaceInput, opts ...request.Option) (*MigrateWorkspaceOutput, error) {
	req, out := c.MigrateWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyAccount = "ModifyAccount"

// ModifyAccountRequest generates a "aws/request.Request" representing the
// client's request for the ModifyAccount operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyAccount for more information on using the ModifyAccount
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyAccountRequest method.
//    req, resp := client.ModifyAccountRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccountRequest(input *ModifyAccountInput) (req *request.Request, output *ModifyAccountOutput) {
	op := &request.Operation{
		Name:       opModifyAccount,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyAccountInput{}
	}

	output = &ModifyAccountOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyAccount API operation for Amazon WorkSpaces.
//
// Modifies the configuration of Bring Your Own License (BYOL) for the specified
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyAccount for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyAccount
func (c *WorkSpaces) ModifyAccount(input *ModifyAccountInput) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	return out, req.Send()
}

// ModifyAccountWithContext is the same as ModifyAccount with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyAccount for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyAccountWithContext(ctx aws.Context, input *ModifyAccountInput, opts ...request.Option) (*ModifyAccountOutput, error) {
	req, out := c.ModifyAccountRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyClientProperties = "ModifyClientProperties"

// ModifyClientPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyClientProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyClientProperties for more information on using the ModifyClientProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyClientPropertiesRequest method.
//    req, resp := client.ModifyClientPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientPropertiesRequest(input *ModifyClientPropertiesInput) (req *request.Request, output *ModifyClientPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyClientProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyClientPropertiesInput{}
	}

	output = &ModifyClientPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyClientProperties API operation for Amazon WorkSpaces.
//
// Modifies the properties of the specified Amazon WorkSpaces clients.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyClientProperties for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyClientProperties
func (c *WorkSpaces) ModifyClientProperties(input *ModifyClientPropertiesInput) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	return out, req.Send()
}

// ModifyClientPropertiesWithContext is the same as ModifyClientProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyClientProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyClientPropertiesWithContext(ctx aws.Context, input *ModifyClientPropertiesInput, opts ...request.Option) (*ModifyClientPropertiesOutput, error) {
	req, out := c.ModifyClientPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifySelfservicePermissions = "ModifySelfservicePermissions"

// ModifySelfservicePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ModifySelfservicePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifySelfservicePermissions for more information on using the ModifySelfservicePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifySelfservicePermissionsRequest method.
//    req, resp := client.ModifySelfservicePermissionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions
func (c *WorkSpaces) ModifySelfservicePermissionsRequest(input *ModifySelfservicePermissionsInput) (req *request.Request, output *ModifySelfservicePermissionsOutput) {
	op := &request.Operation{
		Name:       opModifySelfservicePermissions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifySelfservicePermissionsInput{}
	}

	output = &ModifySelfservicePermissionsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifySelfservicePermissions API operation for Amazon WorkSpaces.
//
// Modifies the self-service WorkSpace management capabilities for your users.
// For more information, see Enable Self-Service WorkSpace Management Capabilities
// for Your Users (https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifySelfservicePermissions for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifySelfservicePermissions
func (c *WorkSpaces) ModifySelfservicePermissions(input *ModifySelfservicePermissionsInput) (*ModifySelfservicePermissionsOutput, error) {
	req, out := c.ModifySelfservicePermissionsRequest(input)
	return out, req.Send()
}

// ModifySelfservicePermissionsWithContext is the same as ModifySelfservicePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ModifySelfservicePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifySelfservicePermissionsWithContext(ctx aws.Context, input *ModifySelfservicePermissionsInput, opts ...request.Option) (*ModifySelfservicePermissionsOutput, error) {
	req, out := c.ModifySelfservicePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceAccessProperties = "ModifyWorkspaceAccessProperties"

// ModifyWorkspaceAccessPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceAccessProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceAccessProperties for more information on using the ModifyWorkspaceAccessProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspaceAccessPropertiesRequest method.
//    req, resp := client.ModifyWorkspaceAccessPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties
func (c *WorkSpaces) ModifyWorkspaceAccessPropertiesRequest(input *ModifyWorkspaceAccessPropertiesInput) (req *request.Request, output *ModifyWorkspaceAccessPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceAccessProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceAccessPropertiesInput{}
	}

	output = &ModifyWorkspaceAccessPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceAccessProperties API operation for Amazon WorkSpaces.
//
// Specifies which devices and operating systems users can use to access their
// WorkSpaces. For more information, see Control Device Access (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceAccessProperties for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceAccessProperties
func (c *WorkSpaces) ModifyWorkspaceAccessProperties(input *ModifyWorkspaceAccessPropertiesInput) (*ModifyWorkspaceAccessPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceAccessPropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceAccessPropertiesWithContext is the same as ModifyWorkspaceAccessProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceAccessProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceAccessPropertiesWithContext(ctx aws.Context, input *ModifyWorkspaceAccessPropertiesInput, opts ...request.Option) (*ModifyWorkspaceAccessPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceAccessPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceCreationProperties = "ModifyWorkspaceCreationProperties"

// ModifyWorkspaceCreationPropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceCreationProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceCreationProperties for more information on using the ModifyWorkspaceCreationProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspaceCreationPropertiesRequest method.
//    req, resp := client.ModifyWorkspaceCreationPropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties
func (c *WorkSpaces) ModifyWorkspaceCreationPropertiesRequest(input *ModifyWorkspaceCreationPropertiesInput) (req *request.Request, output *ModifyWorkspaceCreationPropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceCreationProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceCreationPropertiesInput{}
	}

	output = &ModifyWorkspaceCreationPropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceCreationProperties API operation for Amazon WorkSpaces.
//
// Modify the default properties used to create WorkSpaces.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceCreationProperties for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceCreationProperties
func (c *WorkSpaces) ModifyWorkspaceCreationProperties(input *ModifyWorkspaceCreationPropertiesInput) (*ModifyWorkspaceCreationPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceCreationPropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceCreationPropertiesWithContext is the same as ModifyWorkspaceCreationProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceCreationProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceCreationPropertiesWithContext(ctx aws.Context, input *ModifyWorkspaceCreationPropertiesInput, opts ...request.Option) (*ModifyWorkspaceCreationPropertiesOutput, error) {
	req, out := c.ModifyWorkspaceCreationPropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceProperties = "ModifyWorkspaceProperties"

// ModifyWorkspacePropertiesRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceProperties operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceProperties for more information on using the ModifyWorkspaceProperties
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspacePropertiesRequest method.
//    req, resp := client.ModifyWorkspacePropertiesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspacePropertiesRequest(input *ModifyWorkspacePropertiesInput) (req *request.Request, output *ModifyWorkspacePropertiesOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceProperties,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspacePropertiesInput{}
	}

	output = &ModifyWorkspacePropertiesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceProperties API operation for Amazon WorkSpaces.
//
// Modifies the specified WorkSpace properties. For important information about
// how to modify the size of the root and user volumes, see Modify a WorkSpace
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceProperties for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationInProgressException
//   The properties of this WorkSpace are currently being modified. Try again
//   in a moment.
//
//   * UnsupportedWorkspaceConfigurationException
//   The configuration of this WorkSpace is not supported for this operation.
//   For more information, see Required Configuration and Service Components for
//   WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html).
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceProperties
func (c *WorkSpaces) ModifyWorkspaceProperties(input *ModifyWorkspacePropertiesInput) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	return out, req.Send()
}

// ModifyWorkspacePropertiesWithContext is the same as ModifyWorkspaceProperties with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceProperties for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspacePropertiesWithContext(ctx aws.Context, input *ModifyWorkspacePropertiesInput, opts ...request.Option) (*ModifyWorkspacePropertiesOutput, error) {
	req, out := c.ModifyWorkspacePropertiesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opModifyWorkspaceState = "ModifyWorkspaceState"

// ModifyWorkspaceStateRequest generates a "aws/request.Request" representing the
// client's request for the ModifyWorkspaceState operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ModifyWorkspaceState for more information on using the ModifyWorkspaceState
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ModifyWorkspaceStateRequest method.
//    req, resp := client.ModifyWorkspaceStateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceStateRequest(input *ModifyWorkspaceStateInput) (req *request.Request, output *ModifyWorkspaceStateOutput) {
	op := &request.Operation{
		Name:       opModifyWorkspaceState,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ModifyWorkspaceStateInput{}
	}

	output = &ModifyWorkspaceStateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ModifyWorkspaceState API operation for Amazon WorkSpaces.
//
// Sets the state of the specified WorkSpace.
//
// To maintain a WorkSpace without being interrupted, set the WorkSpace state
// to ADMIN_MAINTENANCE. WorkSpaces in this state do not respond to requests
// to reboot, stop, start, rebuild, or restore. An AutoStop WorkSpace in this
// state is not stopped. Users cannot log into a WorkSpace in the ADMIN_MAINTENANCE
// state.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation ModifyWorkspaceState for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/ModifyWorkspaceState
func (c *WorkSpaces) ModifyWorkspaceState(input *ModifyWorkspaceStateInput) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	return out, req.Send()
}

// ModifyWorkspaceStateWithContext is the same as ModifyWorkspaceState with the addition of
// the ability to pass a context and additional request options.
//
// See ModifyWorkspaceState for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) ModifyWorkspaceStateWithContext(ctx aws.Context, input *ModifyWorkspaceStateInput, opts ...request.Option) (*ModifyWorkspaceStateOutput, error) {
	req, out := c.ModifyWorkspaceStateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebootWorkspaces = "RebootWorkspaces"

// RebootWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebootWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebootWorkspaces for more information on using the RebootWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebootWorkspacesRequest method.
//    req, resp := client.RebootWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspacesRequest(input *RebootWorkspacesInput) (req *request.Request, output *RebootWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebootWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebootWorkspacesInput{}
	}

	output = &RebootWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebootWorkspaces API operation for Amazon WorkSpaces.
//
// Reboots the specified WorkSpaces.
//
// You cannot reboot a WorkSpace unless its state is AVAILABLE or UNHEALTHY.
//
// This operation is asynchronous and returns before the WorkSpaces have rebooted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebootWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebootWorkspaces
func (c *WorkSpaces) RebootWorkspaces(input *RebootWorkspacesInput) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	return out, req.Send()
}

// RebootWorkspacesWithContext is the same as RebootWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebootWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebootWorkspacesWithContext(ctx aws.Context, input *RebootWorkspacesInput, opts ...request.Option) (*RebootWorkspacesOutput, error) {
	req, out := c.RebootWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRebuildWorkspaces = "RebuildWorkspaces"

// RebuildWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the RebuildWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RebuildWorkspaces for more information on using the RebuildWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RebuildWorkspacesRequest method.
//    req, resp := client.RebuildWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspacesRequest(input *RebuildWorkspacesInput) (req *request.Request, output *RebuildWorkspacesOutput) {
	op := &request.Operation{
		Name:       opRebuildWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RebuildWorkspacesInput{}
	}

	output = &RebuildWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// RebuildWorkspaces API operation for Amazon WorkSpaces.
//
// Rebuilds the specified WorkSpace.
//
// You cannot rebuild a WorkSpace unless its state is AVAILABLE, ERROR, UNHEALTHY,
// STOPPED, or REBOOTING.
//
// Rebuilding a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Rebuild a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/reset-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely rebuilt.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RebuildWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RebuildWorkspaces
func (c *WorkSpaces) RebuildWorkspaces(input *RebuildWorkspacesInput) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	return out, req.Send()
}

// RebuildWorkspacesWithContext is the same as RebuildWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See RebuildWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RebuildWorkspacesWithContext(ctx aws.Context, input *RebuildWorkspacesInput, opts ...request.Option) (*RebuildWorkspacesOutput, error) {
	req, out := c.RebuildWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRegisterWorkspaceDirectory = "RegisterWorkspaceDirectory"

// RegisterWorkspaceDirectoryRequest generates a "aws/request.Request" representing the
// client's request for the RegisterWorkspaceDirectory operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RegisterWorkspaceDirectory for more information on using the RegisterWorkspaceDirectory
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RegisterWorkspaceDirectoryRequest method.
//    req, resp := client.RegisterWorkspaceDirectoryRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory
func (c *WorkSpaces) RegisterWorkspaceDirectoryRequest(input *RegisterWorkspaceDirectoryInput) (req *request.Request, output *RegisterWorkspaceDirectoryOutput) {
	op := &request.Operation{
		Name:       opRegisterWorkspaceDirectory,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RegisterWorkspaceDirectoryInput{}
	}

	output = &RegisterWorkspaceDirectoryOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RegisterWorkspaceDirectory API operation for Amazon WorkSpaces.
//
// Registers the specified directory. This operation is asynchronous and returns
// before the WorkSpace directory is registered. If this is the first time you
// are registering a directory, you will need to create the workspaces_DefaultRole
// role before you can register a directory. For more information, see Creating
// the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RegisterWorkspaceDirectory for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * WorkspacesDefaultRoleNotFoundException
//   The workspaces_DefaultRole role could not be found. If this is the first
//   time you are registering a directory, you will need to create the workspaces_DefaultRole
//   role before you can register a directory. For more information, see Creating
//   the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * UnsupportedNetworkConfigurationException
//   The configuration of this network is not supported for this operation, or
//   your network configuration conflicts with the Amazon WorkSpaces management
//   network IP range. For more information, see Configure a VPC for Amazon WorkSpaces
//   (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RegisterWorkspaceDirectory
func (c *WorkSpaces) RegisterWorkspaceDirectory(input *RegisterWorkspaceDirectoryInput) (*RegisterWorkspaceDirectoryOutput, error) {
	req, out := c.RegisterWorkspaceDirectoryRequest(input)
	return out, req.Send()
}

// RegisterWorkspaceDirectoryWithContext is the same as RegisterWorkspaceDirectory with the addition of
// the ability to pass a context and additional request options.
//
// See RegisterWorkspaceDirectory for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RegisterWorkspaceDirectoryWithContext(ctx aws.Context, input *RegisterWorkspaceDirectoryInput, opts ...request.Option) (*RegisterWorkspaceDirectoryOutput, error) {
	req, out := c.RegisterWorkspaceDirectoryRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRestoreWorkspace = "RestoreWorkspace"

// RestoreWorkspaceRequest generates a "aws/request.Request" representing the
// client's request for the RestoreWorkspace operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RestoreWorkspace for more information on using the RestoreWorkspace
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RestoreWorkspaceRequest method.
//    req, resp := client.RestoreWorkspaceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace
func (c *WorkSpaces) RestoreWorkspaceRequest(input *RestoreWorkspaceInput) (req *request.Request, output *RestoreWorkspaceOutput) {
	op := &request.Operation{
		Name:       opRestoreWorkspace,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RestoreWorkspaceInput{}
	}

	output = &RestoreWorkspaceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RestoreWorkspace API operation for Amazon WorkSpaces.
//
// Restores the specified WorkSpace to its last known healthy state.
//
// You cannot restore a WorkSpace unless its state is AVAILABLE, ERROR, UNHEALTHY,
// or STOPPED.
//
// Restoring a WorkSpace is a potentially destructive action that can result
// in the loss of data. For more information, see Restore a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/restore-workspace.html).
//
// This operation is asynchronous and returns before the WorkSpace is completely
// restored.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RestoreWorkspace for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RestoreWorkspace
func (c *WorkSpaces) RestoreWorkspace(input *RestoreWorkspaceInput) (*RestoreWorkspaceOutput, error) {
	req, out := c.RestoreWorkspaceRequest(input)
	return out, req.Send()
}

// RestoreWorkspaceWithContext is the same as RestoreWorkspace with the addition of
// the ability to pass a context and additional request options.
//
// See RestoreWorkspace for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RestoreWorkspaceWithContext(ctx aws.Context, input *RestoreWorkspaceInput, opts ...request.Option) (*RestoreWorkspaceOutput, error) {
	req, out := c.RestoreWorkspaceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opRevokeIpRules = "RevokeIpRules"

// RevokeIpRulesRequest generates a "aws/request.Request" representing the
// client's request for the RevokeIpRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See RevokeIpRules for more information on using the RevokeIpRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the RevokeIpRulesRequest method.
//    req, resp := client.RevokeIpRulesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRulesRequest(input *RevokeIpRulesInput) (req *request.Request, output *RevokeIpRulesOutput) {
	op := &request.Operation{
		Name:       opRevokeIpRules,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &RevokeIpRulesInput{}
	}

	output = &RevokeIpRulesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// RevokeIpRules API operation for Amazon WorkSpaces.
//
// Removes one or more rules from the specified IP access control group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation RevokeIpRules for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/RevokeIpRules
func (c *WorkSpaces) RevokeIpRules(input *RevokeIpRulesInput) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	return out, req.Send()
}

// RevokeIpRulesWithContext is the same as RevokeIpRules with the addition of
// the ability to pass a context and additional request options.
//
// See RevokeIpRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) RevokeIpRulesWithContext(ctx aws.Context, input *RevokeIpRulesInput, opts ...request.Option) (*RevokeIpRulesOutput, error) {
	req, out := c.RevokeIpRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartWorkspaces = "StartWorkspaces"

// StartWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StartWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartWorkspaces for more information on using the StartWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StartWorkspacesRequest method.
//    req, resp := client.StartWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspacesRequest(input *StartWorkspacesInput) (req *request.Request, output *StartWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStartWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartWorkspacesInput{}
	}

	output = &StartWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartWorkspaces API operation for Amazon WorkSpaces.
//
// Starts the specified WorkSpaces.
//
// You cannot start a WorkSpace unless it has a running mode of AutoStop and
// a state of STOPPED.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StartWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StartWorkspaces
func (c *WorkSpaces) StartWorkspaces(input *StartWorkspacesInput) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	return out, req.Send()
}

// StartWorkspacesWithContext is the same as StartWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StartWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StartWorkspacesWithContext(ctx aws.Context, input *StartWorkspacesInput, opts ...request.Option) (*StartWorkspacesOutput, error) {
	req, out := c.StartWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopWorkspaces = "StopWorkspaces"

// StopWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the StopWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopWorkspaces for more information on using the StopWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the StopWorkspacesRequest method.
//    req, resp := client.StopWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspacesRequest(input *StopWorkspacesInput) (req *request.Request, output *StopWorkspacesOutput) {
	op := &request.Operation{
		Name:       opStopWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StopWorkspacesInput{}
	}

	output = &StopWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StopWorkspaces API operation for Amazon WorkSpaces.
//
// Stops the specified WorkSpaces.
//
// You cannot stop a WorkSpace unless it has a running mode of AutoStop and
// a state of AVAILABLE, IMPAIRED, UNHEALTHY, or ERROR.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation StopWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/StopWorkspaces
func (c *WorkSpaces) StopWorkspaces(input *StopWorkspacesInput) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	return out, req.Send()
}

// StopWorkspacesWithContext is the same as StopWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See StopWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) StopWorkspacesWithContext(ctx aws.Context, input *StopWorkspacesInput, opts ...request.Option) (*StopWorkspacesOutput, error) {
	req, out := c.StopWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTerminateWorkspaces = "TerminateWorkspaces"

// TerminateWorkspacesRequest generates a "aws/request.Request" representing the
// client's request for the TerminateWorkspaces operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TerminateWorkspaces for more information on using the TerminateWorkspaces
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TerminateWorkspacesRequest method.
//    req, resp := client.TerminateWorkspacesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspacesRequest(input *TerminateWorkspacesInput) (req *request.Request, output *TerminateWorkspacesOutput) {
	op := &request.Operation{
		Name:       opTerminateWorkspaces,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &TerminateWorkspacesInput{}
	}

	output = &TerminateWorkspacesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TerminateWorkspaces API operation for Amazon WorkSpaces.
//
// Terminates the specified WorkSpaces.
//
// Terminating a WorkSpace is a permanent action and cannot be undone. The user's
// data is destroyed. If you need to archive any user data, contact Amazon Web
// Services Support before terminating the WorkSpace.
//
// You can terminate a WorkSpace that is in any state except SUSPENDED.
//
// This operation is asynchronous and returns before the WorkSpaces have been
// completely terminated. After a WorkSpace is terminated, the TERMINATED state
// is returned only briefly before the WorkSpace directory metadata is cleaned
// up, so this state is rarely returned. To confirm that a WorkSpace is terminated,
// check for the WorkSpace ID by using DescribeWorkSpaces (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html).
// If the WorkSpace ID isn't returned, then the WorkSpace has been successfully
// terminated.
//
// Simple AD and AD Connector are made available to you free of charge to use
// with WorkSpaces. If there are no WorkSpaces being used with your Simple AD
// or AD Connector directory for 30 consecutive days, this directory will be
// automatically deregistered for use with Amazon WorkSpaces, and you will be
// charged for this directory as per the Directory Service pricing terms (http://aws.amazon.com/directoryservice/pricing/).
//
// To delete empty directories, see Delete the Directory for Your WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/delete-workspaces-directory.html).
// If you delete your Simple AD or AD Connector directory, you can always create
// a new one when you want to start using WorkSpaces again.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation TerminateWorkspaces for usage and error information.
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/TerminateWorkspaces
func (c *WorkSpaces) TerminateWorkspaces(input *TerminateWorkspacesInput) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	return out, req.Send()
}

// TerminateWorkspacesWithContext is the same as TerminateWorkspaces with the addition of
// the ability to pass a context and additional request options.
//
// See TerminateWorkspaces for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) TerminateWorkspacesWithContext(ctx aws.Context, input *TerminateWorkspacesInput, opts ...request.Option) (*TerminateWorkspacesOutput, error) {
	req, out := c.TerminateWorkspacesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectClientAddIn = "UpdateConnectClientAddIn"

// UpdateConnectClientAddInRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectClientAddIn operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectClientAddIn for more information on using the UpdateConnectClientAddIn
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectClientAddInRequest method.
//    req, resp := client.UpdateConnectClientAddInRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn
func (c *WorkSpaces) UpdateConnectClientAddInRequest(input *UpdateConnectClientAddInInput) (req *request.Request, output *UpdateConnectClientAddInOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectClientAddIn,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectClientAddInInput{}
	}

	output = &UpdateConnectClientAddInOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnectClientAddIn API operation for Amazon WorkSpaces.
//
// Updates a Amazon Connect client add-in. Use this action to update the name
// and endpoint URL of a Amazon Connect client add-in.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateConnectClientAddIn for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectClientAddIn
func (c *WorkSpaces) UpdateConnectClientAddIn(input *UpdateConnectClientAddInInput) (*UpdateConnectClientAddInOutput, error) {
	req, out := c.UpdateConnectClientAddInRequest(input)
	return out, req.Send()
}

// UpdateConnectClientAddInWithContext is the same as UpdateConnectClientAddIn with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectClientAddIn for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateConnectClientAddInWithContext(ctx aws.Context, input *UpdateConnectClientAddInInput, opts ...request.Option) (*UpdateConnectClientAddInOutput, error) {
	req, out := c.UpdateConnectClientAddInRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateConnectionAliasPermission = "UpdateConnectionAliasPermission"

// UpdateConnectionAliasPermissionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateConnectionAliasPermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateConnectionAliasPermission for more information on using the UpdateConnectionAliasPermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateConnectionAliasPermissionRequest method.
//    req, resp := client.UpdateConnectionAliasPermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission
func (c *WorkSpaces) UpdateConnectionAliasPermissionRequest(input *UpdateConnectionAliasPermissionInput) (req *request.Request, output *UpdateConnectionAliasPermissionOutput) {
	op := &request.Operation{
		Name:       opUpdateConnectionAliasPermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateConnectionAliasPermissionInput{}
	}

	output = &UpdateConnectionAliasPermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateConnectionAliasPermission API operation for Amazon WorkSpaces.
//
// Shares or unshares a connection alias with one account by specifying whether
// that account has permission to associate the connection alias with a directory.
// If the association permission is granted, the connection alias is shared
// with that account. If the association permission is revoked, the connection
// alias is unshared with the account. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
//
//    * Before performing this operation, call DescribeConnectionAliases (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeConnectionAliases.html)
//    to make sure that the current state of the connection alias is CREATED.
//
//    * To delete a connection alias that has been shared, the shared account
//    must first disassociate the connection alias from any directories it has
//    been associated with. Then you must unshare the connection alias from
//    the account it has been shared with. You can delete a connection alias
//    only after it is no longer shared with any accounts or associated with
//    any directories.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateConnectionAliasPermission for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceAssociatedException
//   The resource is associated with a directory.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateConnectionAliasPermission
func (c *WorkSpaces) UpdateConnectionAliasPermission(input *UpdateConnectionAliasPermissionInput) (*UpdateConnectionAliasPermissionOutput, error) {
	req, out := c.UpdateConnectionAliasPermissionRequest(input)
	return out, req.Send()
}

// UpdateConnectionAliasPermissionWithContext is the same as UpdateConnectionAliasPermission with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateConnectionAliasPermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateConnectionAliasPermissionWithContext(ctx aws.Context, input *UpdateConnectionAliasPermissionInput, opts ...request.Option) (*UpdateConnectionAliasPermissionOutput, error) {
	req, out := c.UpdateConnectionAliasPermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRulesOfIpGroup = "UpdateRulesOfIpGroup"

// UpdateRulesOfIpGroupRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRulesOfIpGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRulesOfIpGroup for more information on using the UpdateRulesOfIpGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateRulesOfIpGroupRequest method.
//    req, resp := client.UpdateRulesOfIpGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroupRequest(input *UpdateRulesOfIpGroupInput) (req *request.Request, output *UpdateRulesOfIpGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateRulesOfIpGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateRulesOfIpGroupInput{}
	}

	output = &UpdateRulesOfIpGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRulesOfIpGroup API operation for Amazon WorkSpaces.
//
// Replaces the current rules of the specified IP access control group with
// the specified rules.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateRulesOfIpGroup for usage and error information.
//
// Returned Error Types:
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceLimitExceededException
//   Your resource limits have been exceeded.
//
//   * InvalidResourceStateException
//   The state of the resource is not valid for this operation.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateRulesOfIpGroup
func (c *WorkSpaces) UpdateRulesOfIpGroup(input *UpdateRulesOfIpGroupInput) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	return out, req.Send()
}

// UpdateRulesOfIpGroupWithContext is the same as UpdateRulesOfIpGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRulesOfIpGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateRulesOfIpGroupWithContext(ctx aws.Context, input *UpdateRulesOfIpGroupInput, opts ...request.Option) (*UpdateRulesOfIpGroupOutput, error) {
	req, out := c.UpdateRulesOfIpGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceBundle = "UpdateWorkspaceBundle"

// UpdateWorkspaceBundleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceBundle operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceBundle for more information on using the UpdateWorkspaceBundle
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkspaceBundleRequest method.
//    req, resp := client.UpdateWorkspaceBundleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle
func (c *WorkSpaces) UpdateWorkspaceBundleRequest(input *UpdateWorkspaceBundleInput) (req *request.Request, output *UpdateWorkspaceBundleOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceBundle,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkspaceBundleInput{}
	}

	output = &UpdateWorkspaceBundleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceBundle API operation for Amazon WorkSpaces.
//
// Updates a WorkSpace bundle with a new image. For more information about updating
// WorkSpace bundles, see Update a Custom WorkSpaces Bundle (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
//
// Existing WorkSpaces aren't automatically updated when you update the bundle
// that they're based on. To update existing WorkSpaces that are based on a
// bundle that you've updated, you must either rebuild the WorkSpaces or delete
// and recreate them.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateWorkspaceBundle for usage and error information.
//
// Returned Error Types:
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceBundle
func (c *WorkSpaces) UpdateWorkspaceBundle(input *UpdateWorkspaceBundleInput) (*UpdateWorkspaceBundleOutput, error) {
	req, out := c.UpdateWorkspaceBundleRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceBundleWithContext is the same as UpdateWorkspaceBundle with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceBundle for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateWorkspaceBundleWithContext(ctx aws.Context, input *UpdateWorkspaceBundleInput, opts ...request.Option) (*UpdateWorkspaceBundleOutput, error) {
	req, out := c.UpdateWorkspaceBundleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateWorkspaceImagePermission = "UpdateWorkspaceImagePermission"

// UpdateWorkspaceImagePermissionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateWorkspaceImagePermission operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateWorkspaceImagePermission for more information on using the UpdateWorkspaceImagePermission
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateWorkspaceImagePermissionRequest method.
//    req, resp := client.UpdateWorkspaceImagePermissionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission
func (c *WorkSpaces) UpdateWorkspaceImagePermissionRequest(input *UpdateWorkspaceImagePermissionInput) (req *request.Request, output *UpdateWorkspaceImagePermissionOutput) {
	op := &request.Operation{
		Name:       opUpdateWorkspaceImagePermission,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWorkspaceImagePermissionInput{}
	}

	output = &UpdateWorkspaceImagePermissionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(jsonrpc.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateWorkspaceImagePermission API operation for Amazon WorkSpaces.
//
// Shares or unshares an image with one account in the same Amazon Web Services
// Region by specifying whether that account has permission to copy the image.
// If the copy image permission is granted, the image is shared with that account.
// If the copy image permission is revoked, the image is unshared with the account.
//
// After an image has been shared, the recipient account can copy the image
// to other Regions as needed.
//
// In the China (Ningxia) Region, you can copy images only within the same Region.
//
// In Amazon Web Services GovCloud (US), to copy images to and from other Regions,
// contact Amazon Web Services Support.
//
// For more information about sharing images, see Share or Unshare a Custom
// WorkSpaces Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
//
//    * To delete an image that has been shared, you must unshare the image
//    before you delete it.
//
//    * Sharing Bring Your Own License (BYOL) images across Amazon Web Services
//    accounts isn't supported at this time in Amazon Web Services GovCloud
//    (US). To share BYOL images across accounts in Amazon Web Services GovCloud
//    (US), contact Amazon Web Services Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon WorkSpaces's
// API operation UpdateWorkspaceImagePermission for usage and error information.
//
// Returned Error Types:
//   * ResourceNotFoundException
//   The resource could not be found.
//
//   * ResourceUnavailableException
//   The specified resource is not available.
//
//   * AccessDeniedException
//   The user is not authorized to access a resource.
//
//   * InvalidParameterValuesException
//   One or more parameter values are not valid.
//
//   * OperationNotSupportedException
//   This operation is not supported.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/workspaces-2015-04-08/UpdateWorkspaceImagePermission
func (c *WorkSpaces) UpdateWorkspaceImagePermission(input *UpdateWorkspaceImagePermissionInput) (*UpdateWorkspaceImagePermissionOutput, error) {
	req, out := c.UpdateWorkspaceImagePermissionRequest(input)
	return out, req.Send()
}

// UpdateWorkspaceImagePermissionWithContext is the same as UpdateWorkspaceImagePermission with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateWorkspaceImagePermission for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *WorkSpaces) UpdateWorkspaceImagePermissionWithContext(ctx aws.Context, input *UpdateWorkspaceImagePermissionInput, opts ...request.Option) (*UpdateWorkspaceImagePermissionOutput, error) {
	req, out := c.UpdateWorkspaceImagePermissionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The user is not authorized to access a resource.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes a modification to the configuration of Bring Your Own License (BYOL)
// for the specified account.
type AccountModification struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface used for the account.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is being enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`

	// The error code that is returned if the configuration of BYOL cannot be modified.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the configuration of BYOL
	// cannot be modified.
	ErrorMessage *string `type:"string"`

	// The state of the modification to the configuration of BYOL.
	ModificationState *string `type:"string" enum:"DedicatedTenancyModificationStateEnum"`

	// The timestamp when the modification of the BYOL configuration was started.
	StartTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountModification) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccountModification) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *AccountModification) SetDedicatedTenancyManagementCidrRange(v string) *AccountModification {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *AccountModification) SetDedicatedTenancySupport(v string) *AccountModification {
	s.DedicatedTenancySupport = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *AccountModification) SetErrorCode(v string) *AccountModification {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *AccountModification) SetErrorMessage(v string) *AccountModification {
	s.ErrorMessage = &v
	return s
}

// SetModificationState sets the ModificationState field's value.
func (s *AccountModification) SetModificationState(v string) *AccountModification {
	s.ModificationState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *AccountModification) SetStartTime(v time.Time) *AccountModification {
	s.StartTime = &v
	return s
}

type AssociateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// The identifier of the directory to associate the connection alias with.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *AssociateConnectionAliasInput) SetAliasId(v string) *AssociateConnectionAliasInput {
	s.AliasId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateConnectionAliasInput) SetResourceId(v string) *AssociateConnectionAliasInput {
	s.ResourceId = &v
	return s
}

type AssociateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias association. You use the connection
	// identifier in the DNS TXT record when you're configuring your DNS routing
	// policies.
	ConnectionIdentifier *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateConnectionAliasOutput) GoString() string {
	return s.String()
}

// SetConnectionIdentifier sets the ConnectionIdentifier field's value.
func (s *AssociateConnectionAliasOutput) SetConnectionIdentifier(v string) *AssociateConnectionAliasOutput {
	s.ConnectionIdentifier = &v
	return s
}

type AssociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *AssociateIpGroupsInput) SetDirectoryId(v string) *AssociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *AssociateIpGroupsInput) SetGroupIds(v []*string) *AssociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type AssociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateIpGroupsOutput) GoString() string {
	return s.String()
}

type AuthorizeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to add to the group.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AuthorizeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AuthorizeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *AuthorizeIpRulesInput) SetGroupId(v string) *AuthorizeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *AuthorizeIpRulesInput) SetUserRules(v []*IpRuleItem) *AuthorizeIpRulesInput {
	s.UserRules = v
	return s
}

type AuthorizeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AuthorizeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes an Amazon WorkSpaces client.
type ClientProperties struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can cache their credentials on the Amazon WorkSpaces
	// client. When enabled, users can choose to reconnect to their WorkSpaces without
	// re-entering their credentials.
	ReconnectEnabled *string `type:"string" enum:"ReconnectEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientProperties) GoString() string {
	return s.String()
}

// SetReconnectEnabled sets the ReconnectEnabled field's value.
func (s *ClientProperties) SetReconnectEnabled(v string) *ClientProperties {
	s.ReconnectEnabled = &v
	return s
}

// Information about the Amazon WorkSpaces client.
type ClientPropertiesResult struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	ClientProperties *ClientProperties `type:"structure"`

	// The resource identifier, in the form of a directory ID.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPropertiesResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClientPropertiesResult) GoString() string {
	return s.String()
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ClientPropertiesResult) SetClientProperties(v *ClientProperties) *ClientPropertiesResult {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ClientPropertiesResult) SetResourceId(v string) *ClientPropertiesResult {
	s.ResourceId = &v
	return s
}

// Describes the compute type of the bundle.
type ComputeType struct {
	_ struct{} `type:"structure"`

	// The compute type.
	Name *string `type:"string" enum:"Compute"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ComputeType) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ComputeType) SetName(v string) *ComputeType {
	s.Name = &v
	return s
}

// Describes an Amazon Connect client add-in.
type ConnectClientAddIn struct {
	_ struct{} `type:"structure"`

	// The client add-in identifier.
	AddInId *string `min:"36" type:"string"`

	// The name of the client add in.
	Name *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	ResourceId *string `min:"10" type:"string"`

	// The endpoint URL of the client add-in.
	URL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectClientAddIn) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectClientAddIn) GoString() string {
	return s.String()
}

// SetAddInId sets the AddInId field's value.
func (s *ConnectClientAddIn) SetAddInId(v string) *ConnectClientAddIn {
	s.AddInId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConnectClientAddIn) SetName(v string) *ConnectClientAddIn {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConnectClientAddIn) SetResourceId(v string) *ConnectClientAddIn {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *ConnectClientAddIn) SetURL(v string) *ConnectClientAddIn {
	s.URL = &v
	return s
}

// Describes a connection alias. Connection aliases are used for cross-Region
// redirection. For more information, see Cross-Region Redirection for Amazon
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAlias struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`

	// The association status of the connection alias.
	Associations []*ConnectionAliasAssociation `min:"1" type:"list"`

	// The connection string specified for the connection alias. The connection
	// string must be in the form of a fully qualified domain name (FQDN), such
	// as www.example.com.
	ConnectionString *string `min:"1" type:"string"`

	// The identifier of the Amazon Web Services account that owns the connection
	// alias.
	OwnerAccountId *string `type:"string"`

	// The current state of the connection alias.
	State *string `type:"string" enum:"ConnectionAliasState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAlias) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAlias) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *ConnectionAlias) SetAliasId(v string) *ConnectionAlias {
	s.AliasId = &v
	return s
}

// SetAssociations sets the Associations field's value.
func (s *ConnectionAlias) SetAssociations(v []*ConnectionAliasAssociation) *ConnectionAlias {
	s.Associations = v
	return s
}

// SetConnectionString sets the ConnectionString field's value.
func (s *ConnectionAlias) SetConnectionString(v string) *ConnectionAlias {
	s.ConnectionString = &v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *ConnectionAlias) SetOwnerAccountId(v string) *ConnectionAlias {
	s.OwnerAccountId = &v
	return s
}

// SetState sets the State field's value.
func (s *ConnectionAlias) SetState(v string) *ConnectionAlias {
	s.State = &v
	return s
}

// Describes a connection alias association that is used for cross-Region redirection.
// For more information, see Cross-Region Redirection for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAliasAssociation struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account that associated the connection
	// alias with a directory.
	AssociatedAccountId *string `type:"string"`

	// The association status of the connection alias.
	AssociationStatus *string `type:"string" enum:"AssociationStatus"`

	// The identifier of the connection alias association. You use the connection
	// identifier in the DNS TXT record when you're configuring your DNS routing
	// policies.
	ConnectionIdentifier *string `min:"1" type:"string"`

	// The identifier of the directory associated with a connection alias.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasAssociation) GoString() string {
	return s.String()
}

// SetAssociatedAccountId sets the AssociatedAccountId field's value.
func (s *ConnectionAliasAssociation) SetAssociatedAccountId(v string) *ConnectionAliasAssociation {
	s.AssociatedAccountId = &v
	return s
}

// SetAssociationStatus sets the AssociationStatus field's value.
func (s *ConnectionAliasAssociation) SetAssociationStatus(v string) *ConnectionAliasAssociation {
	s.AssociationStatus = &v
	return s
}

// SetConnectionIdentifier sets the ConnectionIdentifier field's value.
func (s *ConnectionAliasAssociation) SetConnectionIdentifier(v string) *ConnectionAliasAssociation {
	s.ConnectionIdentifier = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ConnectionAliasAssociation) SetResourceId(v string) *ConnectionAliasAssociation {
	s.ResourceId = &v
	return s
}

// Describes the permissions for a connection alias. Connection aliases are
// used for cross-Region redirection. For more information, see Cross-Region
// Redirection for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
type ConnectionAliasPermission struct {
	_ struct{} `type:"structure"`

	// Indicates whether the specified Amazon Web Services account is allowed to
	// associate the connection alias with a directory.
	//
	// AllowAssociation is a required field
	AllowAssociation *bool `type:"boolean" required:"true"`

	// The identifier of the Amazon Web Services account that the connection alias
	// is shared with.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasPermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConnectionAliasPermission) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConnectionAliasPermission) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConnectionAliasPermission"}
	if s.AllowAssociation == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowAssociation"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowAssociation sets the AllowAssociation field's value.
func (s *ConnectionAliasPermission) SetAllowAssociation(v bool) *ConnectionAliasPermission {
	s.AllowAssociation = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *ConnectionAliasPermission) SetSharedAccountId(v string) *ConnectionAliasPermission {
	s.SharedAccountId = &v
	return s
}

type CopyWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// A description of the image.
	Description *string `min:"1" type:"string"`

	// The name of the image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the source image.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The identifier of the source Region.
	//
	// SourceRegion is a required field
	SourceRegion *string `min:"1" type:"string" required:"true"`

	// The tags for the image.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CopyWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CopyWorkspaceImageInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.SourceRegion == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceRegion"))
	}
	if s.SourceRegion != nil && len(*s.SourceRegion) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceRegion", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CopyWorkspaceImageInput) SetDescription(v string) *CopyWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CopyWorkspaceImageInput) SetName(v string) *CopyWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CopyWorkspaceImageInput) SetSourceImageId(v string) *CopyWorkspaceImageInput {
	s.SourceImageId = &v
	return s
}

// SetSourceRegion sets the SourceRegion field's value.
func (s *CopyWorkspaceImageInput) SetSourceRegion(v string) *CopyWorkspaceImageInput {
	s.SourceRegion = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CopyWorkspaceImageInput) SetTags(v []*Tag) *CopyWorkspaceImageInput {
	s.Tags = v
	return s
}

type CopyWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CopyWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CopyWorkspaceImageOutput) SetImageId(v string) *CopyWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

type CreateConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The name of the client add-in.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The directory identifier for which to configure the client add-in.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The endpoint URL of the Amazon Connect client add-in.
	//
	// URL is a required field
	URL *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectClientAddInInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.URL == nil {
		invalidParams.Add(request.NewErrParamRequired("URL"))
	}
	if s.URL != nil && len(*s.URL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateConnectClientAddInInput) SetName(v string) *CreateConnectClientAddInInput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateConnectClientAddInInput) SetResourceId(v string) *CreateConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *CreateConnectClientAddInInput) SetURL(v string) *CreateConnectClientAddInInput {
	s.URL = &v
	return s
}

type CreateConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`

	// The client add-in identifier.
	AddInId *string `min:"36" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectClientAddInOutput) GoString() string {
	return s.String()
}

// SetAddInId sets the AddInId field's value.
func (s *CreateConnectClientAddInOutput) SetAddInId(v string) *CreateConnectClientAddInOutput {
	s.AddInId = &v
	return s
}

type CreateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// A connection string in the form of a fully qualified domain name (FQDN),
	// such as www.example.com.
	//
	// After you create a connection string, it is always associated to your Amazon
	// Web Services account. You cannot recreate the same connection string with
	// a different account, even if you delete all instances of it from the original
	// account. The connection string is globally reserved for your account.
	//
	// ConnectionString is a required field
	ConnectionString *string `min:"1" type:"string" required:"true"`

	// The tags to associate with the connection alias.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateConnectionAliasInput"}
	if s.ConnectionString == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionString"))
	}
	if s.ConnectionString != nil && len(*s.ConnectionString) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ConnectionString", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConnectionString sets the ConnectionString field's value.
func (s *CreateConnectionAliasInput) SetConnectionString(v string) *CreateConnectionAliasInput {
	s.ConnectionString = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateConnectionAliasInput) SetTags(v []*Tag) *CreateConnectionAliasInput {
	s.Tags = v
	return s
}

type CreateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateConnectionAliasOutput) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *CreateConnectionAliasOutput) SetAliasId(v string) *CreateConnectionAliasOutput {
	s.AliasId = &v
	return s
}

type CreateIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `type:"string"`

	// The name of the group.
	//
	// GroupName is a required field
	GroupName *string `type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`

	// The rules to add to the group.
	UserRules []*IpRuleItem `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIpGroupInput"}
	if s.GroupName == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupName"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *CreateIpGroupInput) SetGroupDesc(v string) *CreateIpGroupInput {
	s.GroupDesc = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *CreateIpGroupInput) SetGroupName(v string) *CreateIpGroupInput {
	s.GroupName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIpGroupInput) SetTags(v []*Tag) *CreateIpGroupInput {
	s.Tags = v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *CreateIpGroupInput) SetUserRules(v []*IpRuleItem) *CreateIpGroupInput {
	s.UserRules = v
	return s
}

type CreateIpGroupOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	GroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIpGroupOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *CreateIpGroupOutput) SetGroupId(v string) *CreateIpGroupOutput {
	s.GroupId = &v
	return s
}

type CreateTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	//
	// Tags is a required field
	Tags []*Tag `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *CreateTagsInput) SetResourceId(v string) *CreateTagsInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTagsInput) SetTags(v []*Tag) *CreateTagsInput {
	s.Tags = v
	return s
}

type CreateTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTagsOutput) GoString() string {
	return s.String()
}

type CreateUpdatedWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// A description of whether updates for the WorkSpace image are available.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The name of the new updated WorkSpace image.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The identifier of the source WorkSpace image.
	//
	// SourceImageId is a required field
	SourceImageId *string `type:"string" required:"true"`

	// The tags that you want to add to the new updated WorkSpace image.
	//
	// To add tags at the same time when you're creating the updated image, you
	// must create an IAM policy that grants your IAM user permissions to use workspaces:CreateTags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUpdatedWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUpdatedWorkspaceImageInput"}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceImageId"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetDescription(v string) *CreateUpdatedWorkspaceImageInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetName(v string) *CreateUpdatedWorkspaceImageInput {
	s.Name = &v
	return s
}

// SetSourceImageId sets the SourceImageId field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetSourceImageId(v string) *CreateUpdatedWorkspaceImageInput {
	s.SourceImageId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUpdatedWorkspaceImageInput) SetTags(v []*Tag) *CreateUpdatedWorkspaceImageInput {
	s.Tags = v
	return s
}

type CreateUpdatedWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the new updated WorkSpace image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUpdatedWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *CreateUpdatedWorkspaceImageOutput) SetImageId(v string) *CreateUpdatedWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

type CreateWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The description of the bundle.
	//
	// BundleDescription is a required field
	BundleDescription *string `min:"1" type:"string" required:"true"`

	// The name of the bundle.
	//
	// BundleName is a required field
	BundleName *string `min:"1" type:"string" required:"true"`

	// Describes the compute type of the bundle.
	//
	// ComputeType is a required field
	ComputeType *ComputeType `type:"structure" required:"true"`

	// The identifier of the image that is used to create the bundle.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// Describes the root volume for a WorkSpace bundle.
	RootStorage *RootStorage `type:"structure"`

	// The tags associated with the bundle.
	//
	// To add tags at the same time when you're creating the bundle, you must create
	// an IAM policy that grants your IAM user permissions to use workspaces:CreateTags.
	Tags []*Tag `type:"list"`

	// Describes the user volume for a WorkSpace bundle.
	//
	// UserStorage is a required field
	UserStorage *UserStorage `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspaceBundleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspaceBundleInput"}
	if s.BundleDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleDescription"))
	}
	if s.BundleDescription != nil && len(*s.BundleDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleDescription", 1))
	}
	if s.BundleName == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleName"))
	}
	if s.BundleName != nil && len(*s.BundleName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleName", 1))
	}
	if s.ComputeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ComputeType"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.UserStorage == nil {
		invalidParams.Add(request.NewErrParamRequired("UserStorage"))
	}
	if s.RootStorage != nil {
		if err := s.RootStorage.Validate(); err != nil {
			invalidParams.AddNested("RootStorage", err.(request.ErrInvalidParams))
		}
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.UserStorage != nil {
		if err := s.UserStorage.Validate(); err != nil {
			invalidParams.AddNested("UserStorage", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleDescription sets the BundleDescription field's value.
func (s *CreateWorkspaceBundleInput) SetBundleDescription(v string) *CreateWorkspaceBundleInput {
	s.BundleDescription = &v
	return s
}

// SetBundleName sets the BundleName field's value.
func (s *CreateWorkspaceBundleInput) SetBundleName(v string) *CreateWorkspaceBundleInput {
	s.BundleName = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *CreateWorkspaceBundleInput) SetComputeType(v *ComputeType) *CreateWorkspaceBundleInput {
	s.ComputeType = v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *CreateWorkspaceBundleInput) SetImageId(v string) *CreateWorkspaceBundleInput {
	s.ImageId = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *CreateWorkspaceBundleInput) SetRootStorage(v *RootStorage) *CreateWorkspaceBundleInput {
	s.RootStorage = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateWorkspaceBundleInput) SetTags(v []*Tag) *CreateWorkspaceBundleInput {
	s.Tags = v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *CreateWorkspaceBundleInput) SetUserStorage(v *UserStorage) *CreateWorkspaceBundleInput {
	s.UserStorage = v
	return s
}

type CreateWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`

	// Describes a WorkSpace bundle.
	WorkspaceBundle *WorkspaceBundle `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspaceBundleOutput) GoString() string {
	return s.String()
}

// SetWorkspaceBundle sets the WorkspaceBundle field's value.
func (s *CreateWorkspaceBundleOutput) SetWorkspaceBundle(v *WorkspaceBundle) *CreateWorkspaceBundleOutput {
	s.WorkspaceBundle = v
	return s
}

type CreateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to create. You can specify up to 25 WorkSpaces.
	//
	// Workspaces is a required field
	Workspaces []*WorkspaceRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWorkspacesInput"}
	if s.Workspaces == nil {
		invalidParams.Add(request.NewErrParamRequired("Workspaces"))
	}
	if s.Workspaces != nil && len(s.Workspaces) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Workspaces", 1))
	}
	if s.Workspaces != nil {
		for i, v := range s.Workspaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Workspaces", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaces sets the Workspaces field's value.
func (s *CreateWorkspacesInput) SetWorkspaces(v []*WorkspaceRequest) *CreateWorkspacesInput {
	s.Workspaces = v
	return s
}

type CreateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be created.
	FailedRequests []*FailedCreateWorkspaceRequest `type:"list"`

	// Information about the WorkSpaces that were created.
	//
	// Because this operation is asynchronous, the identifier returned is not immediately
	// available for use with other operations. For example, if you call DescribeWorkspaces
	// before the WorkSpace is created, the information returned can be incomplete.
	PendingRequests []*Workspace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *CreateWorkspacesOutput) SetFailedRequests(v []*FailedCreateWorkspaceRequest) *CreateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// SetPendingRequests sets the PendingRequests field's value.
func (s *CreateWorkspacesOutput) SetPendingRequests(v []*Workspace) *CreateWorkspacesOutput {
	s.PendingRequests = v
	return s
}

// Describes the default values that are used to create WorkSpaces. For more
// information, see Update Directory Details for Your WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
type DefaultWorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of the default security group to apply to WorkSpaces when
	// they are created. For more information, see Security Groups for Your WorkSpaces
	// (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-security-groups.html).
	CustomSecurityGroupId *string `min:"11" type:"string"`

	// The organizational unit (OU) in the directory for the WorkSpace machine accounts.
	DefaultOu *string `type:"string"`

	// Specifies whether to automatically assign an Elastic public IP address to
	// WorkSpaces in this directory by default. If enabled, the Elastic public IP
	// address allows outbound internet access from your WorkSpaces when you’re
	// using an internet gateway in the Amazon VPC in which your WorkSpaces are
	// located. If you're using a Network Address Translation (NAT) gateway for
	// outbound internet access from your VPC, or if your WorkSpaces are in public
	// subnets and you manually assign them Elastic IP addresses, you should disable
	// this setting. This setting applies to new WorkSpaces that you launch or to
	// existing WorkSpaces that you rebuild. For more information, see Configure
	// a VPC for Amazon WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
	EnableInternetAccess *bool `type:"boolean"`

	// Specifies whether maintenance mode is enabled for WorkSpaces. For more information,
	// see WorkSpace Maintenance (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
	EnableMaintenanceMode *bool `type:"boolean"`

	// Specifies whether the directory is enabled for Amazon WorkDocs.
	EnableWorkDocs *bool `type:"boolean"`

	// Specifies whether WorkSpace users are local administrators on their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultWorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DefaultWorkspaceCreationProperties) GoString() string {
	return s.String()
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *DefaultWorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *DefaultWorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *DefaultWorkspaceCreationProperties) SetDefaultOu(v string) *DefaultWorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableInternetAccess(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableMaintenanceMode sets the EnableMaintenanceMode field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableMaintenanceMode(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableMaintenanceMode = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *DefaultWorkspaceCreationProperties) SetEnableWorkDocs(v bool) *DefaultWorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *DefaultWorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *DefaultWorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

type DeleteConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the client add-in to delete.
	//
	// AddInId is a required field
	AddInId *string `min:"36" type:"string" required:"true"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectClientAddInInput"}
	if s.AddInId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddInId"))
	}
	if s.AddInId != nil && len(*s.AddInId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AddInId", 36))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddInId sets the AddInId field's value.
func (s *DeleteConnectClientAddInInput) SetAddInId(v string) *DeleteConnectClientAddInInput {
	s.AddInId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteConnectClientAddInInput) SetResourceId(v string) *DeleteConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

type DeleteConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectClientAddInOutput) GoString() string {
	return s.String()
}

type DeleteConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias to delete.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DeleteConnectionAliasInput) SetAliasId(v string) *DeleteConnectionAliasInput {
	s.AliasId = &v
	return s
}

type DeleteConnectionAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteConnectionAliasOutput) GoString() string {
	return s.String()
}

type DeleteIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the IP access control group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *DeleteIpGroupInput) SetGroupId(v string) *DeleteIpGroupInput {
	s.GroupId = &v
	return s
}

type DeleteIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteIpGroupOutput) GoString() string {
	return s.String()
}

type DeleteTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DeleteTagsInput) SetResourceId(v string) *DeleteTagsInput {
	s.ResourceId = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *DeleteTagsInput) SetTagKeys(v []*string) *DeleteTagsInput {
	s.TagKeys = v
	return s
}

type DeleteTagsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteTagsOutput) GoString() string {
	return s.String()
}

type DeleteWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleInput) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *DeleteWorkspaceBundleInput) SetBundleId(v string) *DeleteWorkspaceBundleInput {
	s.BundleId = &v
	return s
}

type DeleteWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceBundleOutput) GoString() string {
	return s.String()
}

type DeleteWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteWorkspaceImageInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageId sets the ImageId field's value.
func (s *DeleteWorkspaceImageInput) SetImageId(v string) *DeleteWorkspaceImageInput {
	s.ImageId = &v
	return s
}

type DeleteWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteWorkspaceImageOutput) GoString() string {
	return s.String()
}

type DeregisterWorkspaceDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory. If any WorkSpaces are registered to this
	// directory, you must remove them before you deregister the directory, or you
	// will receive an OperationNotSupportedException error.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeregisterWorkspaceDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeregisterWorkspaceDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DeregisterWorkspaceDirectoryInput) SetDirectoryId(v string) *DeregisterWorkspaceDirectoryInput {
	s.DirectoryId = &v
	return s
}

type DeregisterWorkspaceDirectoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeregisterWorkspaceDirectoryOutput) GoString() string {
	return s.String()
}

type DescribeAccountInput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountInput) GoString() string {
	return s.String()
}

type DescribeAccountModificationsInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAccountModificationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAccountModificationsInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsInput) SetNextToken(v string) *DescribeAccountModificationsInput {
	s.NextToken = &v
	return s
}

type DescribeAccountModificationsOutput struct {
	_ struct{} `type:"structure"`

	// The list of modifications to the configuration of BYOL.
	AccountModifications []*AccountModification `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountModificationsOutput) GoString() string {
	return s.String()
}

// SetAccountModifications sets the AccountModifications field's value.
func (s *DescribeAccountModificationsOutput) SetAccountModifications(v []*AccountModification) *DescribeAccountModificationsOutput {
	s.AccountModifications = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeAccountModificationsOutput) SetNextToken(v string) *DescribeAccountModificationsOutput {
	s.NextToken = &v
	return s
}

type DescribeAccountOutput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, used for the management
	// network interface.
	//
	// The management network interface is connected to a secure Amazon WorkSpaces
	// management network. It is used for interactive streaming of the WorkSpace
	// desktop to Amazon WorkSpaces clients, and to allow Amazon WorkSpaces to manage
	// the WorkSpace.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL (whether BYOL is enabled or disabled).
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportResultEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeAccountOutput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancyManagementCidrRange(v string) *DescribeAccountOutput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *DescribeAccountOutput) SetDedicatedTenancySupport(v string) *DescribeAccountOutput {
	s.DedicatedTenancySupport = &v
	return s
}

type DescribeClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The resource identifier, in the form of directory IDs.
	//
	// ResourceIds is a required field
	ResourceIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeClientPropertiesInput"}
	if s.ResourceIds == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceIds"))
	}
	if s.ResourceIds != nil && len(s.ResourceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceIds sets the ResourceIds field's value.
func (s *DescribeClientPropertiesInput) SetResourceIds(v []*string) *DescribeClientPropertiesInput {
	s.ResourceIds = v
	return s
}

type DescribeClientPropertiesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified Amazon WorkSpaces clients.
	ClientPropertiesList []*ClientPropertiesResult `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeClientPropertiesOutput) GoString() string {
	return s.String()
}

// SetClientPropertiesList sets the ClientPropertiesList field's value.
func (s *DescribeClientPropertiesOutput) SetClientPropertiesList(v []*ClientPropertiesResult) *DescribeClientPropertiesOutput {
	s.ClientPropertiesList = v
	return s
}

type DescribeConnectClientAddInsInput struct {
	_ struct{} `type:"structure"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectClientAddInsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectClientAddInsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConnectClientAddInsInput) SetMaxResults(v int64) *DescribeConnectClientAddInsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectClientAddInsInput) SetNextToken(v string) *DescribeConnectClientAddInsInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeConnectClientAddInsInput) SetResourceId(v string) *DescribeConnectClientAddInsInput {
	s.ResourceId = &v
	return s
}

type DescribeConnectClientAddInsOutput struct {
	_ struct{} `type:"structure"`

	// Information about client add-ins.
	AddIns []*ConnectClientAddIn `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectClientAddInsOutput) GoString() string {
	return s.String()
}

// SetAddIns sets the AddIns field's value.
func (s *DescribeConnectClientAddInsOutput) SetAddIns(v []*ConnectClientAddIn) *DescribeConnectClientAddInsOutput {
	s.AddIns = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectClientAddInsOutput) SetNextToken(v string) *DescribeConnectClientAddInsOutput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasPermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// The maximum number of results to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionAliasPermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionAliasPermissionsInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetAliasId(v string) *DescribeConnectionAliasPermissionsInput {
	s.AliasId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetMaxResults(v int64) *DescribeConnectionAliasPermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasPermissionsInput) SetNextToken(v string) *DescribeConnectionAliasPermissionsInput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasPermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias.
	AliasId *string `min:"13" type:"string"`

	// The permissions associated with a connection alias.
	ConnectionAliasPermissions []*ConnectionAliasPermission `min:"1" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasPermissionsOutput) GoString() string {
	return s.String()
}

// SetAliasId sets the AliasId field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetAliasId(v string) *DescribeConnectionAliasPermissionsOutput {
	s.AliasId = &v
	return s
}

// SetConnectionAliasPermissions sets the ConnectionAliasPermissions field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetConnectionAliasPermissions(v []*ConnectionAliasPermission) *DescribeConnectionAliasPermissionsOutput {
	s.ConnectionAliasPermissions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasPermissionsOutput) SetNextToken(v string) *DescribeConnectionAliasPermissionsOutput {
	s.NextToken = &v
	return s
}

type DescribeConnectionAliasesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the connection aliases to describe.
	AliasIds []*string `min:"1" type:"list"`

	// The maximum number of connection aliases to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifier of the directory associated with the connection alias.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeConnectionAliasesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeConnectionAliasesInput"}
	if s.AliasIds != nil && len(s.AliasIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("AliasIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasIds sets the AliasIds field's value.
func (s *DescribeConnectionAliasesInput) SetAliasIds(v []*string) *DescribeConnectionAliasesInput {
	s.AliasIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeConnectionAliasesInput) SetLimit(v int64) *DescribeConnectionAliasesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasesInput) SetNextToken(v string) *DescribeConnectionAliasesInput {
	s.NextToken = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeConnectionAliasesInput) SetResourceId(v string) *DescribeConnectionAliasesInput {
	s.ResourceId = &v
	return s
}

type DescribeConnectionAliasesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the specified connection aliases.
	ConnectionAliases []*ConnectionAlias `min:"1" type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeConnectionAliasesOutput) GoString() string {
	return s.String()
}

// SetConnectionAliases sets the ConnectionAliases field's value.
func (s *DescribeConnectionAliasesOutput) SetConnectionAliases(v []*ConnectionAlias) *DescribeConnectionAliasesOutput {
	s.ConnectionAliases = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeConnectionAliasesOutput) SetNextToken(v string) *DescribeConnectionAliasesOutput {
	s.NextToken = &v
	return s
}

type DescribeIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of one or more IP access control groups.
	GroupIds []*string `type:"list"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeIpGroupsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *DescribeIpGroupsInput) SetGroupIds(v []*string) *DescribeIpGroupsInput {
	s.GroupIds = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeIpGroupsInput) SetMaxResults(v int64) *DescribeIpGroupsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsInput) SetNextToken(v string) *DescribeIpGroupsInput {
	s.NextToken = &v
	return s
}

type DescribeIpGroupsOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the IP access control groups.
	Result []*IpGroup `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeIpGroupsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeIpGroupsOutput) SetNextToken(v string) *DescribeIpGroupsOutput {
	s.NextToken = &v
	return s
}

// SetResult sets the Result field's value.
func (s *DescribeIpGroupsOutput) SetResult(v []*IpGroup) *DescribeIpGroupsOutput {
	s.Result = v
	return s
}

type DescribeTagsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpaces resource. The supported resource types are
	// WorkSpaces, registered directories, images, custom bundles, IP access control
	// groups, and connection aliases.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTagsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *DescribeTagsInput) SetResourceId(v string) *DescribeTagsInput {
	s.ResourceId = &v
	return s
}

type DescribeTagsOutput struct {
	_ struct{} `type:"structure"`

	// The tags.
	TagList []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeTagsOutput) GoString() string {
	return s.String()
}

// SetTagList sets the TagList field's value.
func (s *DescribeTagsOutput) SetTagList(v []*Tag) *DescribeTagsOutput {
	s.TagList = v
	return s
}

type DescribeWorkspaceBundlesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the bundles. You cannot combine this parameter with any
	// other filter.
	BundleIds []*string `min:"1" type:"list"`

	// The token for the next set of results. (You received this token from a previous
	// call.)
	NextToken *string `min:"1" type:"string"`

	// The owner of the bundles. You cannot combine this parameter with any other
	// filter.
	//
	// To describe the bundles provided by Amazon Web Services, specify AMAZON.
	// To describe the bundles that belong to your account, don't specify a value.
	Owner *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceBundlesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceBundlesInput"}
	if s.BundleIds != nil && len(s.BundleIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BundleIds", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleIds sets the BundleIds field's value.
func (s *DescribeWorkspaceBundlesInput) SetBundleIds(v []*string) *DescribeWorkspaceBundlesInput {
	s.BundleIds = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesInput) SetNextToken(v string) *DescribeWorkspaceBundlesInput {
	s.NextToken = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *DescribeWorkspaceBundlesInput) SetOwner(v string) *DescribeWorkspaceBundlesInput {
	s.Owner = &v
	return s
}

type DescribeWorkspaceBundlesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the bundles.
	Bundles []*WorkspaceBundle `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return. This token is valid for one day
	// and must be used within that time frame.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceBundlesOutput) GoString() string {
	return s.String()
}

// SetBundles sets the Bundles field's value.
func (s *DescribeWorkspaceBundlesOutput) SetBundles(v []*WorkspaceBundle) *DescribeWorkspaceBundlesOutput {
	s.Bundles = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceBundlesOutput) SetNextToken(v string) *DescribeWorkspaceBundlesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesInput struct {
	_ struct{} `type:"structure"`

	// The identifiers of the directories. If the value is null, all directories
	// are retrieved.
	DirectoryIds []*string `min:"1" type:"list"`

	// The maximum number of directories to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceDirectoriesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceDirectoriesInput"}
	if s.DirectoryIds != nil && len(s.DirectoryIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryIds", 1))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryIds sets the DirectoryIds field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetDirectoryIds(v []*string) *DescribeWorkspaceDirectoriesInput {
	s.DirectoryIds = v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetLimit(v int64) *DescribeWorkspaceDirectoriesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesInput) SetNextToken(v string) *DescribeWorkspaceDirectoriesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceDirectoriesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the directories.
	Directories []*WorkspaceDirectory `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceDirectoriesOutput) GoString() string {
	return s.String()
}

// SetDirectories sets the Directories field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetDirectories(v []*WorkspaceDirectory) *DescribeWorkspaceDirectoriesOutput {
	s.Directories = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceDirectoriesOutput) SetNextToken(v string) *DescribeWorkspaceDirectoriesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceImagePermissionsInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageId sets the ImageId field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetImageId(v string) *DescribeWorkspaceImagePermissionsInput {
	s.ImageId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetMaxResults(v int64) *DescribeWorkspaceImagePermissionsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagePermissionsInput) SetNextToken(v string) *DescribeWorkspaceImagePermissionsInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagePermissionsOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The identifiers of the Amazon Web Services accounts that the image has been
	// shared with.
	ImagePermissions []*ImagePermission `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagePermissionsOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetImageId(v string) *DescribeWorkspaceImagePermissionsOutput {
	s.ImageId = &v
	return s
}

// SetImagePermissions sets the ImagePermissions field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetImagePermissions(v []*ImagePermission) *DescribeWorkspaceImagePermissionsOutput {
	s.ImagePermissions = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagePermissionsOutput) SetNextToken(v string) *DescribeWorkspaceImagePermissionsOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the image.
	ImageIds []*string `min:"1" type:"list"`

	// The type (owned or shared) of the image.
	ImageType *string `type:"string" enum:"ImageType"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceImagesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceImagesInput"}
	if s.ImageIds != nil && len(s.ImageIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageIds", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetImageIds sets the ImageIds field's value.
func (s *DescribeWorkspaceImagesInput) SetImageIds(v []*string) *DescribeWorkspaceImagesInput {
	s.ImageIds = v
	return s
}

// SetImageType sets the ImageType field's value.
func (s *DescribeWorkspaceImagesInput) SetImageType(v string) *DescribeWorkspaceImagesInput {
	s.ImageType = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *DescribeWorkspaceImagesInput) SetMaxResults(v int64) *DescribeWorkspaceImagesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesInput) SetNextToken(v string) *DescribeWorkspaceImagesInput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceImagesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the images.
	Images []*WorkspaceImage `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceImagesOutput) GoString() string {
	return s.String()
}

// SetImages sets the Images field's value.
func (s *DescribeWorkspaceImagesOutput) SetImages(v []*WorkspaceImage) *DescribeWorkspaceImagesOutput {
	s.Images = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspaceImagesOutput) SetNextToken(v string) *DescribeWorkspaceImagesOutput {
	s.NextToken = &v
	return s
}

type DescribeWorkspaceSnapshotsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspaceSnapshotsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspaceSnapshotsInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *DescribeWorkspaceSnapshotsInput) SetWorkspaceId(v string) *DescribeWorkspaceSnapshotsInput {
	s.WorkspaceId = &v
	return s
}

type DescribeWorkspaceSnapshotsOutput struct {
	_ struct{} `type:"structure"`

	// Information about the snapshots that can be used to rebuild a WorkSpace.
	// These snapshots include the user volume.
	RebuildSnapshots []*Snapshot `type:"list"`

	// Information about the snapshots that can be used to restore a WorkSpace.
	// These snapshots include both the root volume and the user volume.
	RestoreSnapshots []*Snapshot `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspaceSnapshotsOutput) GoString() string {
	return s.String()
}

// SetRebuildSnapshots sets the RebuildSnapshots field's value.
func (s *DescribeWorkspaceSnapshotsOutput) SetRebuildSnapshots(v []*Snapshot) *DescribeWorkspaceSnapshotsOutput {
	s.RebuildSnapshots = v
	return s
}

// SetRestoreSnapshots sets the RestoreSnapshots field's value.
func (s *DescribeWorkspaceSnapshotsOutput) SetRestoreSnapshots(v []*Snapshot) *DescribeWorkspaceSnapshotsOutput {
	s.RestoreSnapshots = v
	return s
}

type DescribeWorkspacesConnectionStatusInput struct {
	_ struct{} `type:"structure"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesConnectionStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesConnectionStatusInput"}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusInput {
	s.NextToken = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesConnectionStatusInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesConnectionStatusInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesConnectionStatusOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the connection status of the WorkSpace.
	WorkspacesConnectionStatus []*WorkspaceConnectionStatus `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesConnectionStatusOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetNextToken(v string) *DescribeWorkspacesConnectionStatusOutput {
	s.NextToken = &v
	return s
}

// SetWorkspacesConnectionStatus sets the WorkspacesConnectionStatus field's value.
func (s *DescribeWorkspacesConnectionStatusOutput) SetWorkspacesConnectionStatus(v []*WorkspaceConnectionStatus) *DescribeWorkspacesConnectionStatusOutput {
	s.WorkspacesConnectionStatus = v
	return s
}

type DescribeWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle. All WorkSpaces that are created from this bundle
	// are retrieved. You cannot combine this parameter with any other filter.
	BundleId *string `type:"string"`

	// The identifier of the directory. In addition, you can optionally specify
	// a specific directory user (see UserName). You cannot combine this parameter
	// with any other filter.
	DirectoryId *string `min:"10" type:"string"`

	// The maximum number of items to return.
	Limit *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`

	// The name of the directory user. You must specify this parameter with DirectoryId.
	UserName *string `min:"1" type:"string"`

	// The identifiers of the WorkSpaces. You cannot combine this parameter with
	// any other filter.
	//
	// Because the CreateWorkspaces operation is asynchronous, the identifier it
	// returns is not immediately available. If you immediately call DescribeWorkspaces
	// with this identifier, no information is returned.
	WorkspaceIds []*string `min:"1" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeWorkspacesInput"}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.Limit != nil && *s.Limit < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Limit", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.WorkspaceIds != nil && len(s.WorkspaceIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("WorkspaceIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *DescribeWorkspacesInput) SetBundleId(v string) *DescribeWorkspacesInput {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DescribeWorkspacesInput) SetDirectoryId(v string) *DescribeWorkspacesInput {
	s.DirectoryId = &v
	return s
}

// SetLimit sets the Limit field's value.
func (s *DescribeWorkspacesInput) SetLimit(v int64) *DescribeWorkspacesInput {
	s.Limit = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesInput) SetNextToken(v string) *DescribeWorkspacesInput {
	s.NextToken = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DescribeWorkspacesInput) SetUserName(v string) *DescribeWorkspacesInput {
	s.UserName = &v
	return s
}

// SetWorkspaceIds sets the WorkspaceIds field's value.
func (s *DescribeWorkspacesInput) SetWorkspaceIds(v []*string) *DescribeWorkspacesInput {
	s.WorkspaceIds = v
	return s
}

type DescribeWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`

	// Information about the WorkSpaces.
	//
	// Because CreateWorkspaces is an asynchronous operation, some of the returned
	// information could be incomplete.
	Workspaces []*Workspace `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DescribeWorkspacesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *DescribeWorkspacesOutput) SetNextToken(v string) *DescribeWorkspacesOutput {
	s.NextToken = &v
	return s
}

// SetWorkspaces sets the Workspaces field's value.
func (s *DescribeWorkspacesOutput) SetWorkspaces(v []*Workspace) *DescribeWorkspacesOutput {
	s.Workspaces = v
	return s
}

type DisassociateConnectionAliasInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias to disassociate.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateConnectionAliasInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateConnectionAliasInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *DisassociateConnectionAliasInput) SetAliasId(v string) *DisassociateConnectionAliasInput {
	s.AliasId = &v
	return s
}

type DisassociateConnectionAliasOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateConnectionAliasOutput) GoString() string {
	return s.String()
}

type DisassociateIpGroupsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// The identifiers of one or more IP access control groups.
	//
	// GroupIds is a required field
	GroupIds []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateIpGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateIpGroupsInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.GroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupIds"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *DisassociateIpGroupsInput) SetDirectoryId(v string) *DisassociateIpGroupsInput {
	s.DirectoryId = &v
	return s
}

// SetGroupIds sets the GroupIds field's value.
func (s *DisassociateIpGroupsInput) SetGroupIds(v []*string) *DisassociateIpGroupsInput {
	s.GroupIds = v
	return s
}

type DisassociateIpGroupsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateIpGroupsOutput) GoString() string {
	return s.String()
}

// Describes a WorkSpace that cannot be created.
type FailedCreateWorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// Information about the WorkSpace.
	WorkspaceRequest *WorkspaceRequest `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateWorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedCreateWorkspaceRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorCode(v string) *FailedCreateWorkspaceRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedCreateWorkspaceRequest) SetErrorMessage(v string) *FailedCreateWorkspaceRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceRequest sets the WorkspaceRequest field's value.
func (s *FailedCreateWorkspaceRequest) SetWorkspaceRequest(v *WorkspaceRequest) *FailedCreateWorkspaceRequest {
	s.WorkspaceRequest = v
	return s
}

// Describes a WorkSpace that could not be rebooted. (RebootWorkspaces), rebuilt
// (RebuildWorkspaces), restored (RestoreWorkspace), terminated (TerminateWorkspaces),
// started (StartWorkspaces), or stopped (StopWorkspaces).
type FailedWorkspaceChangeRequest struct {
	_ struct{} `type:"structure"`

	// The error code that is returned if the WorkSpace cannot be rebooted.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// rebooted.
	ErrorMessage *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedWorkspaceChangeRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s FailedWorkspaceChangeRequest) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorCode(v string) *FailedWorkspaceChangeRequest {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *FailedWorkspaceChangeRequest) SetErrorMessage(v string) *FailedWorkspaceChangeRequest {
	s.ErrorMessage = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *FailedWorkspaceChangeRequest) SetWorkspaceId(v string) *FailedWorkspaceChangeRequest {
	s.WorkspaceId = &v
	return s
}

// Describes the Amazon Web Services accounts that have been granted permission
// to use a shared image. For more information about sharing images, see Share
// or Unshare a Custom WorkSpaces Image (https://docs.aws.amazon.com/workspaces/latest/adminguide/share-custom-image.html).
type ImagePermission struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Web Services account that an image has been
	// shared with.
	SharedAccountId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePermission) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImagePermission) GoString() string {
	return s.String()
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *ImagePermission) SetSharedAccountId(v string) *ImagePermission {
	s.SharedAccountId = &v
	return s
}

type ImportWorkspaceImageInput struct {
	_ struct{} `type:"structure"`

	// If specified, the version of Microsoft Office to subscribe to. Valid only
	// for Windows 10 BYOL images. For more information about subscribing to Office
	// for BYOL images, see Bring Your Own Windows Desktop Licenses (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	//
	// Although this parameter is an array, only one item is allowed at this time.
	Applications []*string `min:"1" type:"list" enum:"Application"`

	// The identifier of the EC2 image.
	//
	// Ec2ImageId is a required field
	Ec2ImageId *string `type:"string" required:"true"`

	// The description of the WorkSpace image.
	//
	// ImageDescription is a required field
	ImageDescription *string `min:"1" type:"string" required:"true"`

	// The name of the WorkSpace image.
	//
	// ImageName is a required field
	ImageName *string `min:"1" type:"string" required:"true"`

	// The ingestion process to be used when importing the image, depending on which
	// protocol you want to use for your BYOL Workspace image, either PCoIP or WorkSpaces
	// Streaming Protocol (WSP). To use WSP, specify a value that ends in _WSP.
	// To use PCoIP, specify a value that does not end in _WSP.
	//
	// For non-GPU-enabled bundles (bundles other than Graphics or GraphicsPro),
	// specify BYOL_REGULAR or BYOL_REGULAR_WSP, depending on the protocol.
	//
	// IngestionProcess is a required field
	IngestionProcess *string `type:"string" required:"true" enum:"WorkspaceImageIngestionProcess"`

	// The tags. Each WorkSpaces resource can have a maximum of 50 tags.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ImportWorkspaceImageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ImportWorkspaceImageInput"}
	if s.Applications != nil && len(s.Applications) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Applications", 1))
	}
	if s.Ec2ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("Ec2ImageId"))
	}
	if s.ImageDescription == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageDescription"))
	}
	if s.ImageDescription != nil && len(*s.ImageDescription) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageDescription", 1))
	}
	if s.ImageName == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageName"))
	}
	if s.ImageName != nil && len(*s.ImageName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ImageName", 1))
	}
	if s.IngestionProcess == nil {
		invalidParams.Add(request.NewErrParamRequired("IngestionProcess"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplications sets the Applications field's value.
func (s *ImportWorkspaceImageInput) SetApplications(v []*string) *ImportWorkspaceImageInput {
	s.Applications = v
	return s
}

// SetEc2ImageId sets the Ec2ImageId field's value.
func (s *ImportWorkspaceImageInput) SetEc2ImageId(v string) *ImportWorkspaceImageInput {
	s.Ec2ImageId = &v
	return s
}

// SetImageDescription sets the ImageDescription field's value.
func (s *ImportWorkspaceImageInput) SetImageDescription(v string) *ImportWorkspaceImageInput {
	s.ImageDescription = &v
	return s
}

// SetImageName sets the ImageName field's value.
func (s *ImportWorkspaceImageInput) SetImageName(v string) *ImportWorkspaceImageInput {
	s.ImageName = &v
	return s
}

// SetIngestionProcess sets the IngestionProcess field's value.
func (s *ImportWorkspaceImageInput) SetIngestionProcess(v string) *ImportWorkspaceImageInput {
	s.IngestionProcess = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ImportWorkspaceImageInput) SetTags(v []*Tag) *ImportWorkspaceImageInput {
	s.Tags = v
	return s
}

type ImportWorkspaceImageOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ImportWorkspaceImageOutput) GoString() string {
	return s.String()
}

// SetImageId sets the ImageId field's value.
func (s *ImportWorkspaceImageOutput) SetImageId(v string) *ImportWorkspaceImageOutput {
	s.ImageId = &v
	return s
}

// One or more parameter values are not valid.
type InvalidParameterValuesException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValuesException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterValuesException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterValuesException(v protocol.ResponseMetadata) error {
	return &InvalidParameterValuesException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterValuesException) Code() string {
	return "InvalidParameterValuesException"
}

// Message returns the exception's message.
func (s *InvalidParameterValuesException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterValuesException) OrigErr() error {
	return nil
}

func (s *InvalidParameterValuesException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterValuesException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterValuesException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The state of the resource is not valid for this operation.
type InvalidResourceStateException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidResourceStateException) GoString() string {
	return s.String()
}

func newErrorInvalidResourceStateException(v protocol.ResponseMetadata) error {
	return &InvalidResourceStateException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidResourceStateException) Code() string {
	return "InvalidResourceStateException"
}

// Message returns the exception's message.
func (s *InvalidResourceStateException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidResourceStateException) OrigErr() error {
	return nil
}

func (s *InvalidResourceStateException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidResourceStateException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidResourceStateException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes an IP access control group.
type IpGroup struct {
	_ struct{} `type:"structure"`

	// The description of the group.
	GroupDesc *string `locationName:"groupDesc" type:"string"`

	// The identifier of the group.
	GroupId *string `locationName:"groupId" type:"string"`

	// The name of the group.
	GroupName *string `locationName:"groupName" type:"string"`

	// The rules.
	UserRules []*IpRuleItem `locationName:"userRules" type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpGroup) GoString() string {
	return s.String()
}

// SetGroupDesc sets the GroupDesc field's value.
func (s *IpGroup) SetGroupDesc(v string) *IpGroup {
	s.GroupDesc = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *IpGroup) SetGroupId(v string) *IpGroup {
	s.GroupId = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *IpGroup) SetGroupName(v string) *IpGroup {
	s.GroupName = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *IpGroup) SetUserRules(v []*IpRuleItem) *IpGroup {
	s.UserRules = v
	return s
}

// Describes a rule for an IP access control group.
type IpRuleItem struct {
	_ struct{} `type:"structure"`

	// The IP address range, in CIDR notation.
	IpRule *string `locationName:"ipRule" type:"string"`

	// The description.
	RuleDesc *string `locationName:"ruleDesc" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRuleItem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IpRuleItem) GoString() string {
	return s.String()
}

// SetIpRule sets the IpRule field's value.
func (s *IpRuleItem) SetIpRule(v string) *IpRuleItem {
	s.IpRule = &v
	return s
}

// SetRuleDesc sets the RuleDesc field's value.
func (s *IpRuleItem) SetRuleDesc(v string) *IpRuleItem {
	s.RuleDesc = &v
	return s
}

type ListAvailableManagementCidrRangesInput struct {
	_ struct{} `type:"structure"`

	// The IP address range to search. Specify an IP address range that is compatible
	// with your network and in CIDR notation (that is, specify the range as an
	// IPv4 CIDR block).
	//
	// ManagementCidrRangeConstraint is a required field
	ManagementCidrRangeConstraint *string `type:"string" required:"true"`

	// The maximum number of items to return.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you received a NextToken from a previous call that was paginated, provide
	// this token to receive the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListAvailableManagementCidrRangesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListAvailableManagementCidrRangesInput"}
	if s.ManagementCidrRangeConstraint == nil {
		invalidParams.Add(request.NewErrParamRequired("ManagementCidrRangeConstraint"))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetManagementCidrRangeConstraint sets the ManagementCidrRangeConstraint field's value.
func (s *ListAvailableManagementCidrRangesInput) SetManagementCidrRangeConstraint(v string) *ListAvailableManagementCidrRangesInput {
	s.ManagementCidrRangeConstraint = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListAvailableManagementCidrRangesInput) SetMaxResults(v int64) *ListAvailableManagementCidrRangesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesInput) SetNextToken(v string) *ListAvailableManagementCidrRangesInput {
	s.NextToken = &v
	return s
}

type ListAvailableManagementCidrRangesOutput struct {
	_ struct{} `type:"structure"`

	// The list of available IP address ranges, specified as IPv4 CIDR blocks.
	ManagementCidrRanges []*string `type:"list"`

	// The token to use to retrieve the next page of results. This value is null
	// when there are no more results to return.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListAvailableManagementCidrRangesOutput) GoString() string {
	return s.String()
}

// SetManagementCidrRanges sets the ManagementCidrRanges field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetManagementCidrRanges(v []*string) *ListAvailableManagementCidrRangesOutput {
	s.ManagementCidrRanges = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListAvailableManagementCidrRangesOutput) SetNextToken(v string) *ListAvailableManagementCidrRangesOutput {
	s.NextToken = &v
	return s
}

type MigrateWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the target bundle type to migrate the WorkSpace to.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the WorkSpace to migrate from.
	//
	// SourceWorkspaceId is a required field
	SourceWorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *MigrateWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "MigrateWorkspaceInput"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.SourceWorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("SourceWorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *MigrateWorkspaceInput) SetBundleId(v string) *MigrateWorkspaceInput {
	s.BundleId = &v
	return s
}

// SetSourceWorkspaceId sets the SourceWorkspaceId field's value.
func (s *MigrateWorkspaceInput) SetSourceWorkspaceId(v string) *MigrateWorkspaceInput {
	s.SourceWorkspaceId = &v
	return s
}

type MigrateWorkspaceOutput struct {
	_ struct{} `type:"structure"`

	// The original identifier of the WorkSpace that is being migrated.
	SourceWorkspaceId *string `type:"string"`

	// The new identifier of the WorkSpace that is being migrated. If the migration
	// does not succeed, the target WorkSpace ID will not be used, and the WorkSpace
	// will still have the original WorkSpace ID.
	TargetWorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s MigrateWorkspaceOutput) GoString() string {
	return s.String()
}

// SetSourceWorkspaceId sets the SourceWorkspaceId field's value.
func (s *MigrateWorkspaceOutput) SetSourceWorkspaceId(v string) *MigrateWorkspaceOutput {
	s.SourceWorkspaceId = &v
	return s
}

// SetTargetWorkspaceId sets the TargetWorkspaceId field's value.
func (s *MigrateWorkspaceOutput) SetTargetWorkspaceId(v string) *MigrateWorkspaceOutput {
	s.TargetWorkspaceId = &v
	return s
}

// Describes a WorkSpace modification.
type ModificationState struct {
	_ struct{} `type:"structure"`

	// The resource.
	Resource *string `type:"string" enum:"ModificationResourceEnum"`

	// The modification state.
	State *string `type:"string" enum:"ModificationStateEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModificationState) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModificationState) GoString() string {
	return s.String()
}

// SetResource sets the Resource field's value.
func (s *ModificationState) SetResource(v string) *ModificationState {
	s.Resource = &v
	return s
}

// SetState sets the State field's value.
func (s *ModificationState) SetState(v string) *ModificationState {
	s.State = &v
	return s
}

type ModifyAccountInput struct {
	_ struct{} `type:"structure"`

	// The IP address range, specified as an IPv4 CIDR block, for the management
	// network interface. Specify an IP address range that is compatible with your
	// network and in CIDR notation (that is, specify the range as an IPv4 CIDR
	// block). The CIDR block size must be /16 (for example, 203.0.113.25/16). It
	// must also be specified as available by the ListAvailableManagementCidrRanges
	// operation.
	DedicatedTenancyManagementCidrRange *string `type:"string"`

	// The status of BYOL.
	DedicatedTenancySupport *string `type:"string" enum:"DedicatedTenancySupportEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountInput) GoString() string {
	return s.String()
}

// SetDedicatedTenancyManagementCidrRange sets the DedicatedTenancyManagementCidrRange field's value.
func (s *ModifyAccountInput) SetDedicatedTenancyManagementCidrRange(v string) *ModifyAccountInput {
	s.DedicatedTenancyManagementCidrRange = &v
	return s
}

// SetDedicatedTenancySupport sets the DedicatedTenancySupport field's value.
func (s *ModifyAccountInput) SetDedicatedTenancySupport(v string) *ModifyAccountInput {
	s.DedicatedTenancySupport = &v
	return s
}

type ModifyAccountOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyAccountOutput) GoString() string {
	return s.String()
}

type ModifyClientPropertiesInput struct {
	_ struct{} `type:"structure"`

	// Information about the Amazon WorkSpaces client.
	//
	// ClientProperties is a required field
	ClientProperties *ClientProperties `type:"structure" required:"true"`

	// The resource identifiers, in the form of directory IDs.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyClientPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyClientPropertiesInput"}
	if s.ClientProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("ClientProperties"))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientProperties sets the ClientProperties field's value.
func (s *ModifyClientPropertiesInput) SetClientProperties(v *ClientProperties) *ModifyClientPropertiesInput {
	s.ClientProperties = v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyClientPropertiesInput) SetResourceId(v string) *ModifyClientPropertiesInput {
	s.ResourceId = &v
	return s
}

type ModifyClientPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyClientPropertiesOutput) GoString() string {
	return s.String()
}

type ModifySelfservicePermissionsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The permissions to enable or disable self-service capabilities.
	//
	// SelfservicePermissions is a required field
	SelfservicePermissions *SelfservicePermissions `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifySelfservicePermissionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifySelfservicePermissionsInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.SelfservicePermissions == nil {
		invalidParams.Add(request.NewErrParamRequired("SelfservicePermissions"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifySelfservicePermissionsInput) SetResourceId(v string) *ModifySelfservicePermissionsInput {
	s.ResourceId = &v
	return s
}

// SetSelfservicePermissions sets the SelfservicePermissions field's value.
func (s *ModifySelfservicePermissionsInput) SetSelfservicePermissions(v *SelfservicePermissions) *ModifySelfservicePermissionsInput {
	s.SelfservicePermissions = v
	return s
}

type ModifySelfservicePermissionsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifySelfservicePermissionsOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceAccessPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The device types and operating systems to enable or disable for access.
	//
	// WorkspaceAccessProperties is a required field
	WorkspaceAccessProperties *WorkspaceAccessProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceAccessPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceAccessPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.WorkspaceAccessProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceAccessProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyWorkspaceAccessPropertiesInput) SetResourceId(v string) *ModifyWorkspaceAccessPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetWorkspaceAccessProperties sets the WorkspaceAccessProperties field's value.
func (s *ModifyWorkspaceAccessPropertiesInput) SetWorkspaceAccessProperties(v *WorkspaceAccessProperties) *ModifyWorkspaceAccessPropertiesInput {
	s.WorkspaceAccessProperties = v
	return s
}

type ModifyWorkspaceAccessPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceAccessPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceCreationPropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The default properties for creating WorkSpaces.
	//
	// WorkspaceCreationProperties is a required field
	WorkspaceCreationProperties *WorkspaceCreationProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceCreationPropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceCreationPropertiesInput"}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.WorkspaceCreationProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceCreationProperties"))
	}
	if s.WorkspaceCreationProperties != nil {
		if err := s.WorkspaceCreationProperties.Validate(); err != nil {
			invalidParams.AddNested("WorkspaceCreationProperties", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceId sets the ResourceId field's value.
func (s *ModifyWorkspaceCreationPropertiesInput) SetResourceId(v string) *ModifyWorkspaceCreationPropertiesInput {
	s.ResourceId = &v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *ModifyWorkspaceCreationPropertiesInput) SetWorkspaceCreationProperties(v *WorkspaceCreationProperties) *ModifyWorkspaceCreationPropertiesInput {
	s.WorkspaceCreationProperties = v
	return s
}

type ModifyWorkspaceCreationPropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceCreationPropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspacePropertiesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The properties of the WorkSpace.
	//
	// WorkspaceProperties is a required field
	WorkspaceProperties *WorkspaceProperties `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspacePropertiesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspacePropertiesInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceProperties == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceProperties"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceId(v string) *ModifyWorkspacePropertiesInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *ModifyWorkspacePropertiesInput) SetWorkspaceProperties(v *WorkspaceProperties) *ModifyWorkspacePropertiesInput {
	s.WorkspaceProperties = v
	return s
}

type ModifyWorkspacePropertiesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspacePropertiesOutput) GoString() string {
	return s.String()
}

type ModifyWorkspaceStateInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`

	// The WorkSpace state.
	//
	// WorkspaceState is a required field
	WorkspaceState *string `type:"string" required:"true" enum:"TargetWorkspaceState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ModifyWorkspaceStateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ModifyWorkspaceStateInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}
	if s.WorkspaceState == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceState"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceId(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceState sets the WorkspaceState field's value.
func (s *ModifyWorkspaceStateInput) SetWorkspaceState(v string) *ModifyWorkspaceStateInput {
	s.WorkspaceState = &v
	return s
}

type ModifyWorkspaceStateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ModifyWorkspaceStateOutput) GoString() string {
	return s.String()
}

// The operating system that the image is running.
type OperatingSystem struct {
	_ struct{} `type:"structure"`

	// The operating system.
	Type *string `type:"string" enum:"OperatingSystemType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystem) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperatingSystem) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *OperatingSystem) SetType(v string) *OperatingSystem {
	s.Type = &v
	return s
}

// The properties of this WorkSpace are currently being modified. Try again
// in a moment.
type OperationInProgressException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationInProgressException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationInProgressException) GoString() string {
	return s.String()
}

func newErrorOperationInProgressException(v protocol.ResponseMetadata) error {
	return &OperationInProgressException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationInProgressException) Code() string {
	return "OperationInProgressException"
}

// Message returns the exception's message.
func (s *OperationInProgressException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationInProgressException) OrigErr() error {
	return nil
}

func (s *OperationInProgressException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationInProgressException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationInProgressException) RequestID() string {
	return s.RespMetadata.RequestID
}

// This operation is not supported.
type OperationNotSupportedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotSupportedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OperationNotSupportedException) GoString() string {
	return s.String()
}

func newErrorOperationNotSupportedException(v protocol.ResponseMetadata) error {
	return &OperationNotSupportedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *OperationNotSupportedException) Code() string {
	return "OperationNotSupportedException"
}

// Message returns the exception's message.
func (s *OperationNotSupportedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *OperationNotSupportedException) OrigErr() error {
	return nil
}

func (s *OperationNotSupportedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *OperationNotSupportedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *OperationNotSupportedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Describes the information used to reboot a WorkSpace.
type RebootRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebootRequest) SetWorkspaceId(v string) *RebootRequest {
	s.WorkspaceId = &v
	return s
}

type RebootWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
	//
	// RebootWorkspaceRequests is a required field
	RebootWorkspaceRequests []*RebootRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebootWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebootWorkspacesInput"}
	if s.RebootWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebootWorkspaceRequests"))
	}
	if s.RebootWorkspaceRequests != nil && len(s.RebootWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebootWorkspaceRequests", 1))
	}
	if s.RebootWorkspaceRequests != nil {
		for i, v := range s.RebootWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebootWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebootWorkspaceRequests sets the RebootWorkspaceRequests field's value.
func (s *RebootWorkspacesInput) SetRebootWorkspaceRequests(v []*RebootRequest) *RebootWorkspacesInput {
	s.RebootWorkspaceRequests = v
	return s
}

type RebootWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be rebooted.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebootWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebootWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebootWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the information used to rebuild a WorkSpace.
type RebuildRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RebuildRequest) SetWorkspaceId(v string) *RebuildRequest {
	s.WorkspaceId = &v
	return s
}

type RebuildWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpace to rebuild. You can specify a single WorkSpace.
	//
	// RebuildWorkspaceRequests is a required field
	RebuildWorkspaceRequests []*RebuildRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RebuildWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RebuildWorkspacesInput"}
	if s.RebuildWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("RebuildWorkspaceRequests"))
	}
	if s.RebuildWorkspaceRequests != nil && len(s.RebuildWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RebuildWorkspaceRequests", 1))
	}
	if s.RebuildWorkspaceRequests != nil {
		for i, v := range s.RebuildWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "RebuildWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRebuildWorkspaceRequests sets the RebuildWorkspaceRequests field's value.
func (s *RebuildWorkspacesInput) SetRebuildWorkspaceRequests(v []*RebuildRequest) *RebuildWorkspacesInput {
	s.RebuildWorkspaceRequests = v
	return s
}

type RebuildWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpace that could not be rebuilt.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RebuildWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *RebuildWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *RebuildWorkspacesOutput {
	s.FailedRequests = v
	return s
}

type RegisterWorkspaceDirectoryInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the directory. You cannot register a directory if it does
	// not have a status of Active. If the directory does not have a status of Active,
	// you will receive an InvalidResourceStateException error. If you have already
	// registered the maximum number of directories that you can register with Amazon
	// WorkSpaces, you will receive a ResourceLimitExceededException error. Deregister
	// directories that you are not using for WorkSpaces, and try again.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// Indicates whether self-service capabilities are enabled or disabled.
	EnableSelfService *bool `type:"boolean"`

	// Indicates whether Amazon WorkDocs is enabled or disabled. If you have enabled
	// this parameter and WorkDocs is not available in the Region, you will receive
	// an OperationNotSupportedException error. Set EnableWorkDocs to disabled,
	// and try again.
	//
	// EnableWorkDocs is a required field
	EnableWorkDocs *bool `type:"boolean" required:"true"`

	// The identifiers of the subnets for your virtual private cloud (VPC). Make
	// sure that the subnets are in supported Availability Zones. The subnets must
	// also be in separate Availability Zones. If these conditions are not met,
	// you will receive an OperationNotSupportedException error.
	SubnetIds []*string `type:"list"`

	// The tags associated with the directory.
	Tags []*Tag `type:"list"`

	// Indicates whether your WorkSpace directory is dedicated or shared. To use
	// Bring Your Own License (BYOL) images, this value must be set to DEDICATED
	// and your Amazon Web Services account must be enabled for BYOL. If your account
	// has not been enabled for BYOL, you will receive an InvalidParameterValuesException
	// error. For more information about BYOL images, see Bring Your Own Windows
	// Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	Tenancy *string `type:"string" enum:"Tenancy"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RegisterWorkspaceDirectoryInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RegisterWorkspaceDirectoryInput"}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.EnableWorkDocs == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableWorkDocs"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *RegisterWorkspaceDirectoryInput) SetDirectoryId(v string) *RegisterWorkspaceDirectoryInput {
	s.DirectoryId = &v
	return s
}

// SetEnableSelfService sets the EnableSelfService field's value.
func (s *RegisterWorkspaceDirectoryInput) SetEnableSelfService(v bool) *RegisterWorkspaceDirectoryInput {
	s.EnableSelfService = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *RegisterWorkspaceDirectoryInput) SetEnableWorkDocs(v bool) *RegisterWorkspaceDirectoryInput {
	s.EnableWorkDocs = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *RegisterWorkspaceDirectoryInput) SetSubnetIds(v []*string) *RegisterWorkspaceDirectoryInput {
	s.SubnetIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *RegisterWorkspaceDirectoryInput) SetTags(v []*Tag) *RegisterWorkspaceDirectoryInput {
	s.Tags = v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *RegisterWorkspaceDirectoryInput) SetTenancy(v string) *RegisterWorkspaceDirectoryInput {
	s.Tenancy = &v
	return s
}

type RegisterWorkspaceDirectoryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RegisterWorkspaceDirectoryOutput) GoString() string {
	return s.String()
}

// The specified resource already exists.
type ResourceAlreadyExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAlreadyExistsException) GoString() string {
	return s.String()
}

func newErrorResourceAlreadyExistsException(v protocol.ResponseMetadata) error {
	return &ResourceAlreadyExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAlreadyExistsException) Code() string {
	return "ResourceAlreadyExistsException"
}

// Message returns the exception's message.
func (s *ResourceAlreadyExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAlreadyExistsException) OrigErr() error {
	return nil
}

func (s *ResourceAlreadyExistsException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAlreadyExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAlreadyExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource is associated with a directory.
type ResourceAssociatedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceAssociatedException) GoString() string {
	return s.String()
}

func newErrorResourceAssociatedException(v protocol.ResponseMetadata) error {
	return &ResourceAssociatedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceAssociatedException) Code() string {
	return "ResourceAssociatedException"
}

// Message returns the exception's message.
func (s *ResourceAssociatedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceAssociatedException) OrigErr() error {
	return nil
}

func (s *ResourceAssociatedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceAssociatedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceAssociatedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource could not be created.
type ResourceCreationFailedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCreationFailedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceCreationFailedException) GoString() string {
	return s.String()
}

func newErrorResourceCreationFailedException(v protocol.ResponseMetadata) error {
	return &ResourceCreationFailedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceCreationFailedException) Code() string {
	return "ResourceCreationFailedException"
}

// Message returns the exception's message.
func (s *ResourceCreationFailedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceCreationFailedException) OrigErr() error {
	return nil
}

func (s *ResourceCreationFailedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceCreationFailedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceCreationFailedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Your resource limits have been exceeded.
type ResourceLimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceLimitExceededException) GoString() string {
	return s.String()
}

func newErrorResourceLimitExceededException(v protocol.ResponseMetadata) error {
	return &ResourceLimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceLimitExceededException) Code() string {
	return "ResourceLimitExceededException"
}

// Message returns the exception's message.
func (s *ResourceLimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceLimitExceededException) OrigErr() error {
	return nil
}

func (s *ResourceLimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceLimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceLimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource could not be found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The resource could not be found.
	Message_ *string `locationName:"message" type:"string"`

	// The ID of the resource that could not be found.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The specified resource is not available.
type ResourceUnavailableException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The exception error message.
	Message_ *string `locationName:"message" type:"string"`

	// The identifier of the resource that is not available.
	ResourceId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceUnavailableException) GoString() string {
	return s.String()
}

func newErrorResourceUnavailableException(v protocol.ResponseMetadata) error {
	return &ResourceUnavailableException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceUnavailableException) Code() string {
	return "ResourceUnavailableException"
}

// Message returns the exception's message.
func (s *ResourceUnavailableException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceUnavailableException) OrigErr() error {
	return nil
}

func (s *ResourceUnavailableException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceUnavailableException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceUnavailableException) RequestID() string {
	return s.RespMetadata.RequestID
}

type RestoreWorkspaceInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RestoreWorkspaceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RestoreWorkspaceInput"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *RestoreWorkspaceInput) SetWorkspaceId(v string) *RestoreWorkspaceInput {
	s.WorkspaceId = &v
	return s
}

type RestoreWorkspaceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RestoreWorkspaceOutput) GoString() string {
	return s.String()
}

type RevokeIpRulesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// The rules to remove from the group.
	//
	// UserRules is a required field
	UserRules []*string `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RevokeIpRulesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RevokeIpRulesInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *RevokeIpRulesInput) SetGroupId(v string) *RevokeIpRulesInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *RevokeIpRulesInput) SetUserRules(v []*string) *RevokeIpRulesInput {
	s.UserRules = v
	return s
}

type RevokeIpRulesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RevokeIpRulesOutput) GoString() string {
	return s.String()
}

// Describes the root volume for a WorkSpace bundle.
type RootStorage struct {
	_ struct{} `type:"structure"`

	// The size of the root volume.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s RootStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *RootStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "RootStorage"}
	if s.Capacity != nil && len(*s.Capacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Capacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *RootStorage) SetCapacity(v string) *RootStorage {
	s.Capacity = &v
	return s
}

// Describes the self-service permissions for a directory. For more information,
// see Enable Self-Service WorkSpace Management Capabilities for Your Users
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
type SelfservicePermissions struct {
	_ struct{} `type:"structure"`

	// Specifies whether users can change the compute type (bundle) for their WorkSpace.
	ChangeComputeType *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can increase the volume size of the drives on their
	// WorkSpace.
	IncreaseVolumeSize *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can rebuild the operating system of a WorkSpace to
	// its original state.
	RebuildWorkspace *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can restart their WorkSpace.
	RestartWorkspace *string `type:"string" enum:"ReconnectEnum"`

	// Specifies whether users can switch the running mode of their WorkSpace.
	SwitchRunningMode *string `type:"string" enum:"ReconnectEnum"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfservicePermissions) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s SelfservicePermissions) GoString() string {
	return s.String()
}

// SetChangeComputeType sets the ChangeComputeType field's value.
func (s *SelfservicePermissions) SetChangeComputeType(v string) *SelfservicePermissions {
	s.ChangeComputeType = &v
	return s
}

// SetIncreaseVolumeSize sets the IncreaseVolumeSize field's value.
func (s *SelfservicePermissions) SetIncreaseVolumeSize(v string) *SelfservicePermissions {
	s.IncreaseVolumeSize = &v
	return s
}

// SetRebuildWorkspace sets the RebuildWorkspace field's value.
func (s *SelfservicePermissions) SetRebuildWorkspace(v string) *SelfservicePermissions {
	s.RebuildWorkspace = &v
	return s
}

// SetRestartWorkspace sets the RestartWorkspace field's value.
func (s *SelfservicePermissions) SetRestartWorkspace(v string) *SelfservicePermissions {
	s.RestartWorkspace = &v
	return s
}

// SetSwitchRunningMode sets the SwitchRunningMode field's value.
func (s *SelfservicePermissions) SetSwitchRunningMode(v string) *SelfservicePermissions {
	s.SwitchRunningMode = &v
	return s
}

// Describes a snapshot.
type Snapshot struct {
	_ struct{} `type:"structure"`

	// The time when the snapshot was created.
	SnapshotTime *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Snapshot) GoString() string {
	return s.String()
}

// SetSnapshotTime sets the SnapshotTime field's value.
func (s *Snapshot) SetSnapshotTime(v time.Time) *Snapshot {
	s.SnapshotTime = &v
	return s
}

// Information used to start a WorkSpace.
type StartRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StartRequest) SetWorkspaceId(v string) *StartRequest {
	s.WorkspaceId = &v
	return s
}

type StartWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to start. You can specify up to 25 WorkSpaces.
	//
	// StartWorkspaceRequests is a required field
	StartWorkspaceRequests []*StartRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartWorkspacesInput"}
	if s.StartWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StartWorkspaceRequests"))
	}
	if s.StartWorkspaceRequests != nil && len(s.StartWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StartWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStartWorkspaceRequests sets the StartWorkspaceRequests field's value.
func (s *StartWorkspacesInput) SetStartWorkspaceRequests(v []*StartRequest) *StartWorkspacesInput {
	s.StartWorkspaceRequests = v
	return s
}

type StartWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be started.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StartWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StartWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes the information used to stop a WorkSpace.
type StopRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopRequest) GoString() string {
	return s.String()
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *StopRequest) SetWorkspaceId(v string) *StopRequest {
	s.WorkspaceId = &v
	return s
}

type StopWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
	//
	// StopWorkspaceRequests is a required field
	StopWorkspaceRequests []*StopRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StopWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StopWorkspacesInput"}
	if s.StopWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("StopWorkspaceRequests"))
	}
	if s.StopWorkspaceRequests != nil && len(s.StopWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StopWorkspaceRequests", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStopWorkspaceRequests sets the StopWorkspaceRequests field's value.
func (s *StopWorkspacesInput) SetStopWorkspaceRequests(v []*StopRequest) *StopWorkspacesInput {
	s.StopWorkspaceRequests = v
	return s
}

type StopWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be stopped.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StopWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *StopWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *StopWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// Describes a tag.
type Tag struct {
	_ struct{} `type:"structure"`

	// The key of the tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// The value of the tag.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

// Describes the information used to terminate a WorkSpace.
type TerminateRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the WorkSpace.
	//
	// WorkspaceId is a required field
	WorkspaceId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateRequest"}
	if s.WorkspaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("WorkspaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *TerminateRequest) SetWorkspaceId(v string) *TerminateRequest {
	s.WorkspaceId = &v
	return s
}

type TerminateWorkspacesInput struct {
	_ struct{} `type:"structure"`

	// The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
	//
	// TerminateWorkspaceRequests is a required field
	TerminateWorkspaceRequests []*TerminateRequest `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TerminateWorkspacesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TerminateWorkspacesInput"}
	if s.TerminateWorkspaceRequests == nil {
		invalidParams.Add(request.NewErrParamRequired("TerminateWorkspaceRequests"))
	}
	if s.TerminateWorkspaceRequests != nil && len(s.TerminateWorkspaceRequests) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TerminateWorkspaceRequests", 1))
	}
	if s.TerminateWorkspaceRequests != nil {
		for i, v := range s.TerminateWorkspaceRequests {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TerminateWorkspaceRequests", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetTerminateWorkspaceRequests sets the TerminateWorkspaceRequests field's value.
func (s *TerminateWorkspacesInput) SetTerminateWorkspaceRequests(v []*TerminateRequest) *TerminateWorkspacesInput {
	s.TerminateWorkspaceRequests = v
	return s
}

type TerminateWorkspacesOutput struct {
	_ struct{} `type:"structure"`

	// Information about the WorkSpaces that could not be terminated.
	FailedRequests []*FailedWorkspaceChangeRequest `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TerminateWorkspacesOutput) GoString() string {
	return s.String()
}

// SetFailedRequests sets the FailedRequests field's value.
func (s *TerminateWorkspacesOutput) SetFailedRequests(v []*FailedWorkspaceChangeRequest) *TerminateWorkspacesOutput {
	s.FailedRequests = v
	return s
}

// The configuration of this network is not supported for this operation, or
// your network configuration conflicts with the Amazon WorkSpaces management
// network IP range. For more information, see Configure a VPC for Amazon WorkSpaces
// (https://docs.aws.amazon.com/workspaces/latest/adminguide/amazon-workspaces-vpc.html).
type UnsupportedNetworkConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedNetworkConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedNetworkConfigurationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedNetworkConfigurationException(v protocol.ResponseMetadata) error {
	return &UnsupportedNetworkConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedNetworkConfigurationException) Code() string {
	return "UnsupportedNetworkConfigurationException"
}

// Message returns the exception's message.
func (s *UnsupportedNetworkConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedNetworkConfigurationException) OrigErr() error {
	return nil
}

func (s *UnsupportedNetworkConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedNetworkConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedNetworkConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The configuration of this WorkSpace is not supported for this operation.
// For more information, see Required Configuration and Service Components for
// WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/required-service-components.html).
type UnsupportedWorkspaceConfigurationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedWorkspaceConfigurationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedWorkspaceConfigurationException) GoString() string {
	return s.String()
}

func newErrorUnsupportedWorkspaceConfigurationException(v protocol.ResponseMetadata) error {
	return &UnsupportedWorkspaceConfigurationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedWorkspaceConfigurationException) Code() string {
	return "UnsupportedWorkspaceConfigurationException"
}

// Message returns the exception's message.
func (s *UnsupportedWorkspaceConfigurationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedWorkspaceConfigurationException) OrigErr() error {
	return nil
}

func (s *UnsupportedWorkspaceConfigurationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedWorkspaceConfigurationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedWorkspaceConfigurationException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UpdateConnectClientAddInInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the client add-in to update.
	//
	// AddInId is a required field
	AddInId *string `min:"36" type:"string" required:"true"`

	// The name of the client add-in.
	Name *string `min:"1" type:"string"`

	// The directory identifier for which the client add-in is configured.
	//
	// ResourceId is a required field
	ResourceId *string `min:"10" type:"string" required:"true"`

	// The endpoint URL of the Amazon Connect client add-in.
	URL *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectClientAddInInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectClientAddInInput"}
	if s.AddInId == nil {
		invalidParams.Add(request.NewErrParamRequired("AddInId"))
	}
	if s.AddInId != nil && len(*s.AddInId) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("AddInId", 36))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 10))
	}
	if s.URL != nil && len(*s.URL) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("URL", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddInId sets the AddInId field's value.
func (s *UpdateConnectClientAddInInput) SetAddInId(v string) *UpdateConnectClientAddInInput {
	s.AddInId = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateConnectClientAddInInput) SetName(v string) *UpdateConnectClientAddInInput {
	s.Name = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *UpdateConnectClientAddInInput) SetResourceId(v string) *UpdateConnectClientAddInInput {
	s.ResourceId = &v
	return s
}

// SetURL sets the URL field's value.
func (s *UpdateConnectClientAddInInput) SetURL(v string) *UpdateConnectClientAddInInput {
	s.URL = &v
	return s
}

type UpdateConnectClientAddInOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectClientAddInOutput) GoString() string {
	return s.String()
}

type UpdateConnectionAliasPermissionInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the connection alias that you want to update permissions
	// for.
	//
	// AliasId is a required field
	AliasId *string `min:"13" type:"string" required:"true"`

	// Indicates whether to share or unshare the connection alias with the specified
	// Amazon Web Services account.
	//
	// ConnectionAliasPermission is a required field
	ConnectionAliasPermission *ConnectionAliasPermission `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateConnectionAliasPermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateConnectionAliasPermissionInput"}
	if s.AliasId == nil {
		invalidParams.Add(request.NewErrParamRequired("AliasId"))
	}
	if s.AliasId != nil && len(*s.AliasId) < 13 {
		invalidParams.Add(request.NewErrParamMinLen("AliasId", 13))
	}
	if s.ConnectionAliasPermission == nil {
		invalidParams.Add(request.NewErrParamRequired("ConnectionAliasPermission"))
	}
	if s.ConnectionAliasPermission != nil {
		if err := s.ConnectionAliasPermission.Validate(); err != nil {
			invalidParams.AddNested("ConnectionAliasPermission", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAliasId sets the AliasId field's value.
func (s *UpdateConnectionAliasPermissionInput) SetAliasId(v string) *UpdateConnectionAliasPermissionInput {
	s.AliasId = &v
	return s
}

// SetConnectionAliasPermission sets the ConnectionAliasPermission field's value.
func (s *UpdateConnectionAliasPermissionInput) SetConnectionAliasPermission(v *ConnectionAliasPermission) *UpdateConnectionAliasPermissionInput {
	s.ConnectionAliasPermission = v
	return s
}

type UpdateConnectionAliasPermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateConnectionAliasPermissionOutput) GoString() string {
	return s.String()
}

// Describes whether a WorkSpace image needs to be updated with the latest drivers
// and other components required by Amazon WorkSpaces.
//
// Only Windows 10 WorkSpace images can be programmatically updated at this
// time.
type UpdateResult struct {
	_ struct{} `type:"structure"`

	// A description of whether updates for the WorkSpace image are pending or available.
	Description *string `min:"1" type:"string"`

	// Indicates whether updated drivers or other components are available for the
	// specified WorkSpace image.
	UpdateAvailable *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResult) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateResult) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *UpdateResult) SetDescription(v string) *UpdateResult {
	s.Description = &v
	return s
}

// SetUpdateAvailable sets the UpdateAvailable field's value.
func (s *UpdateResult) SetUpdateAvailable(v bool) *UpdateResult {
	s.UpdateAvailable = &v
	return s
}

type UpdateRulesOfIpGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the group.
	//
	// GroupId is a required field
	GroupId *string `type:"string" required:"true"`

	// One or more rules.
	//
	// UserRules is a required field
	UserRules []*IpRuleItem `type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateRulesOfIpGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateRulesOfIpGroupInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.UserRules == nil {
		invalidParams.Add(request.NewErrParamRequired("UserRules"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateRulesOfIpGroupInput) SetGroupId(v string) *UpdateRulesOfIpGroupInput {
	s.GroupId = &v
	return s
}

// SetUserRules sets the UserRules field's value.
func (s *UpdateRulesOfIpGroupInput) SetUserRules(v []*IpRuleItem) *UpdateRulesOfIpGroupInput {
	s.UserRules = v
	return s
}

type UpdateRulesOfIpGroupOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateRulesOfIpGroupOutput) GoString() string {
	return s.String()
}

type UpdateWorkspaceBundleInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleInput) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *UpdateWorkspaceBundleInput) SetBundleId(v string) *UpdateWorkspaceBundleInput {
	s.BundleId = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *UpdateWorkspaceBundleInput) SetImageId(v string) *UpdateWorkspaceBundleInput {
	s.ImageId = &v
	return s
}

type UpdateWorkspaceBundleOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceBundleOutput) GoString() string {
	return s.String()
}

type UpdateWorkspaceImagePermissionInput struct {
	_ struct{} `type:"structure"`

	// The permission to copy the image. This permission can be revoked only after
	// an image has been shared.
	//
	// AllowCopyImage is a required field
	AllowCopyImage *bool `type:"boolean" required:"true"`

	// The identifier of the image.
	//
	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	// The identifier of the Amazon Web Services account to share or unshare the
	// image with.
	//
	// Before sharing the image, confirm that you are sharing to the correct Amazon
	// Web Services account ID.
	//
	// SharedAccountId is a required field
	SharedAccountId *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWorkspaceImagePermissionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateWorkspaceImagePermissionInput"}
	if s.AllowCopyImage == nil {
		invalidParams.Add(request.NewErrParamRequired("AllowCopyImage"))
	}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.SharedAccountId == nil {
		invalidParams.Add(request.NewErrParamRequired("SharedAccountId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowCopyImage sets the AllowCopyImage field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetAllowCopyImage(v bool) *UpdateWorkspaceImagePermissionInput {
	s.AllowCopyImage = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetImageId(v string) *UpdateWorkspaceImagePermissionInput {
	s.ImageId = &v
	return s
}

// SetSharedAccountId sets the SharedAccountId field's value.
func (s *UpdateWorkspaceImagePermissionInput) SetSharedAccountId(v string) *UpdateWorkspaceImagePermissionInput {
	s.SharedAccountId = &v
	return s
}

type UpdateWorkspaceImagePermissionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateWorkspaceImagePermissionOutput) GoString() string {
	return s.String()
}

// Describes the user volume for a WorkSpace bundle.
type UserStorage struct {
	_ struct{} `type:"structure"`

	// The size of the user volume.
	Capacity *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserStorage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UserStorage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UserStorage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UserStorage"}
	if s.Capacity != nil && len(*s.Capacity) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Capacity", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *UserStorage) SetCapacity(v string) *UserStorage {
	s.Capacity = &v
	return s
}

// Describes a WorkSpace.
type Workspace struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle used to create the WorkSpace.
	BundleId *string `type:"string"`

	// The name of the WorkSpace, as seen by the operating system. The format of
	// this name varies. For more information, see Launch a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/launch-workspaces-tutorials.html).
	ComputerName *string `type:"string"`

	// The identifier of the Directory Service directory for the WorkSpace.
	DirectoryId *string `min:"10" type:"string"`

	// The error code that is returned if the WorkSpace cannot be created.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned if the WorkSpace cannot be
	// created.
	ErrorMessage *string `type:"string"`

	// The IP address of the WorkSpace.
	IpAddress *string `type:"string"`

	// The modification states of the WorkSpace.
	ModificationStates []*ModificationState `type:"list"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The operational state of the WorkSpace.
	//
	// After a WorkSpace is terminated, the TERMINATED state is returned only briefly
	// before the WorkSpace directory metadata is cleaned up, so this state is rarely
	// returned. To confirm that a WorkSpace is terminated, check for the WorkSpace
	// ID by using DescribeWorkSpaces (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaces.html).
	// If the WorkSpace ID isn't returned, then the WorkSpace has been successfully
	// terminated.
	State *string `type:"string" enum:"WorkspaceState"`

	// The identifier of the subnet for the WorkSpace.
	SubnetId *string `min:"15" type:"string"`

	// The user for the WorkSpace.
	UserName *string `min:"1" type:"string"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon
	// WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string `type:"string"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`

	// The properties of the WorkSpace.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workspace) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Workspace) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *Workspace) SetBundleId(v string) *Workspace {
	s.BundleId = &v
	return s
}

// SetComputerName sets the ComputerName field's value.
func (s *Workspace) SetComputerName(v string) *Workspace {
	s.ComputerName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *Workspace) SetDirectoryId(v string) *Workspace {
	s.DirectoryId = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Workspace) SetErrorCode(v string) *Workspace {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *Workspace) SetErrorMessage(v string) *Workspace {
	s.ErrorMessage = &v
	return s
}

// SetIpAddress sets the IpAddress field's value.
func (s *Workspace) SetIpAddress(v string) *Workspace {
	s.IpAddress = &v
	return s
}

// SetModificationStates sets the ModificationStates field's value.
func (s *Workspace) SetModificationStates(v []*ModificationState) *Workspace {
	s.ModificationStates = v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *Workspace) SetRootVolumeEncryptionEnabled(v bool) *Workspace {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetState sets the State field's value.
func (s *Workspace) SetState(v string) *Workspace {
	s.State = &v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *Workspace) SetSubnetId(v string) *Workspace {
	s.SubnetId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *Workspace) SetUserName(v string) *Workspace {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *Workspace) SetUserVolumeEncryptionEnabled(v bool) *Workspace {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *Workspace) SetVolumeEncryptionKey(v string) *Workspace {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *Workspace) SetWorkspaceId(v string) *Workspace {
	s.WorkspaceId = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *Workspace) SetWorkspaceProperties(v *WorkspaceProperties) *Workspace {
	s.WorkspaceProperties = v
	return s
}

// The device types and operating systems that can be used to access a WorkSpace.
// For more information, see Amazon WorkSpaces Client Network Requirements (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-network-requirements.html).
type WorkspaceAccessProperties struct {
	_ struct{} `type:"structure"`

	// Indicates whether users can use Android and Android-compatible Chrome OS
	// devices to access their WorkSpaces.
	DeviceTypeAndroid *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Chromebooks to access their WorkSpaces.
	DeviceTypeChromeOs *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use iOS devices to access their WorkSpaces.
	DeviceTypeIos *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Linux clients to access their WorkSpaces.
	DeviceTypeLinux *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use macOS clients to access their WorkSpaces.
	DeviceTypeOsx *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can access their WorkSpaces through a web browser.
	DeviceTypeWeb *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use Windows clients to access their WorkSpaces.
	DeviceTypeWindows *string `type:"string" enum:"AccessPropertyValue"`

	// Indicates whether users can use zero client devices to access their WorkSpaces.
	DeviceTypeZeroClient *string `type:"string" enum:"AccessPropertyValue"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceAccessProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceAccessProperties) GoString() string {
	return s.String()
}

// SetDeviceTypeAndroid sets the DeviceTypeAndroid field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeAndroid(v string) *WorkspaceAccessProperties {
	s.DeviceTypeAndroid = &v
	return s
}

// SetDeviceTypeChromeOs sets the DeviceTypeChromeOs field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeChromeOs(v string) *WorkspaceAccessProperties {
	s.DeviceTypeChromeOs = &v
	return s
}

// SetDeviceTypeIos sets the DeviceTypeIos field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeIos(v string) *WorkspaceAccessProperties {
	s.DeviceTypeIos = &v
	return s
}

// SetDeviceTypeLinux sets the DeviceTypeLinux field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeLinux(v string) *WorkspaceAccessProperties {
	s.DeviceTypeLinux = &v
	return s
}

// SetDeviceTypeOsx sets the DeviceTypeOsx field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeOsx(v string) *WorkspaceAccessProperties {
	s.DeviceTypeOsx = &v
	return s
}

// SetDeviceTypeWeb sets the DeviceTypeWeb field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeWeb(v string) *WorkspaceAccessProperties {
	s.DeviceTypeWeb = &v
	return s
}

// SetDeviceTypeWindows sets the DeviceTypeWindows field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeWindows(v string) *WorkspaceAccessProperties {
	s.DeviceTypeWindows = &v
	return s
}

// SetDeviceTypeZeroClient sets the DeviceTypeZeroClient field's value.
func (s *WorkspaceAccessProperties) SetDeviceTypeZeroClient(v string) *WorkspaceAccessProperties {
	s.DeviceTypeZeroClient = &v
	return s
}

// Describes a WorkSpace bundle.
type WorkspaceBundle struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle.
	BundleId *string `type:"string"`

	// The compute type of the bundle. For more information, see Amazon WorkSpaces
	// Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeType *ComputeType `type:"structure"`

	// The time when the bundle was created.
	CreationTime *time.Time `type:"timestamp"`

	// The description of the bundle.
	Description *string `type:"string"`

	// The identifier of the image that was used to create the bundle.
	ImageId *string `type:"string"`

	// The last time that the bundle was updated.
	LastUpdatedTime *time.Time `type:"timestamp"`

	// The name of the bundle.
	Name *string `min:"1" type:"string"`

	// The owner of the bundle. This is the account identifier of the owner, or
	// AMAZON if the bundle is provided by Amazon Web Services.
	Owner *string `type:"string"`

	// The size of the root volume.
	RootStorage *RootStorage `type:"structure"`

	// The size of the user volume.
	UserStorage *UserStorage `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceBundle) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceBundle) GoString() string {
	return s.String()
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceBundle) SetBundleId(v string) *WorkspaceBundle {
	s.BundleId = &v
	return s
}

// SetComputeType sets the ComputeType field's value.
func (s *WorkspaceBundle) SetComputeType(v *ComputeType) *WorkspaceBundle {
	s.ComputeType = v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *WorkspaceBundle) SetCreationTime(v time.Time) *WorkspaceBundle {
	s.CreationTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceBundle) SetDescription(v string) *WorkspaceBundle {
	s.Description = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *WorkspaceBundle) SetImageId(v string) *WorkspaceBundle {
	s.ImageId = &v
	return s
}

// SetLastUpdatedTime sets the LastUpdatedTime field's value.
func (s *WorkspaceBundle) SetLastUpdatedTime(v time.Time) *WorkspaceBundle {
	s.LastUpdatedTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceBundle) SetName(v string) *WorkspaceBundle {
	s.Name = &v
	return s
}

// SetOwner sets the Owner field's value.
func (s *WorkspaceBundle) SetOwner(v string) *WorkspaceBundle {
	s.Owner = &v
	return s
}

// SetRootStorage sets the RootStorage field's value.
func (s *WorkspaceBundle) SetRootStorage(v *RootStorage) *WorkspaceBundle {
	s.RootStorage = v
	return s
}

// SetUserStorage sets the UserStorage field's value.
func (s *WorkspaceBundle) SetUserStorage(v *UserStorage) *WorkspaceBundle {
	s.UserStorage = v
	return s
}

// Describes the connection status of a WorkSpace.
type WorkspaceConnectionStatus struct {
	_ struct{} `type:"structure"`

	// The connection state of the WorkSpace. The connection state is unknown if
	// the WorkSpace is stopped.
	ConnectionState *string `type:"string" enum:"ConnectionState"`

	// The timestamp of the connection status check.
	ConnectionStateCheckTimestamp *time.Time `type:"timestamp"`

	// The timestamp of the last known user connection.
	LastKnownUserConnectionTimestamp *time.Time `type:"timestamp"`

	// The identifier of the WorkSpace.
	WorkspaceId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceConnectionStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceConnectionStatus) GoString() string {
	return s.String()
}

// SetConnectionState sets the ConnectionState field's value.
func (s *WorkspaceConnectionStatus) SetConnectionState(v string) *WorkspaceConnectionStatus {
	s.ConnectionState = &v
	return s
}

// SetConnectionStateCheckTimestamp sets the ConnectionStateCheckTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetConnectionStateCheckTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.ConnectionStateCheckTimestamp = &v
	return s
}

// SetLastKnownUserConnectionTimestamp sets the LastKnownUserConnectionTimestamp field's value.
func (s *WorkspaceConnectionStatus) SetLastKnownUserConnectionTimestamp(v time.Time) *WorkspaceConnectionStatus {
	s.LastKnownUserConnectionTimestamp = &v
	return s
}

// SetWorkspaceId sets the WorkspaceId field's value.
func (s *WorkspaceConnectionStatus) SetWorkspaceId(v string) *WorkspaceConnectionStatus {
	s.WorkspaceId = &v
	return s
}

// Describes the default properties that are used for creating WorkSpaces. For
// more information, see Update Directory Details for Your WorkSpaces (https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html).
type WorkspaceCreationProperties struct {
	_ struct{} `type:"structure"`

	// The identifier of your custom security group.
	CustomSecurityGroupId *string `min:"11" type:"string"`

	// The default organizational unit (OU) for your WorkSpaces directories. This
	// string must be the full Lightweight Directory Access Protocol (LDAP) distinguished
	// name for the target domain and OU. It must be in the form "OU=value,DC=value,DC=value",
	// where value is any string of characters, and the number of domain components
	// (DCs) is two or more. For example, OU=WorkSpaces_machines,DC=machines,DC=example,DC=com.
	//
	//    * To avoid errors, certain characters in the distinguished name must be
	//    escaped. For more information, see Distinguished Names (https://docs.microsoft.com/previous-versions/windows/desktop/ldap/distinguished-names)
	//    in the Microsoft documentation.
	//
	//    * The API doesn't validate whether the OU exists.
	DefaultOu *string `type:"string"`

	// Indicates whether internet access is enabled for your WorkSpaces.
	EnableInternetAccess *bool `type:"boolean"`

	// Indicates whether maintenance mode is enabled for your WorkSpaces. For more
	// information, see WorkSpace Maintenance (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspace-maintenance.html).
	EnableMaintenanceMode *bool `type:"boolean"`

	// Indicates whether Amazon WorkDocs is enabled for your WorkSpaces.
	//
	// If WorkDocs is already enabled for a WorkSpaces directory and you disable
	// it, new WorkSpaces launched in the directory will not have WorkDocs enabled.
	// However, WorkDocs remains enabled for any existing WorkSpaces, unless you
	// either disable users' access to WorkDocs or you delete the WorkDocs site.
	// To disable users' access to WorkDocs, see Disabling Users (https://docs.aws.amazon.com/workdocs/latest/adminguide/inactive-user.html)
	// in the Amazon WorkDocs Administration Guide. To delete a WorkDocs site, see
	// Deleting a Site (https://docs.aws.amazon.com/workdocs/latest/adminguide/manage-sites.html)
	// in the Amazon WorkDocs Administration Guide.
	//
	// If you enable WorkDocs on a directory that already has existing WorkSpaces,
	// the existing WorkSpaces and any new WorkSpaces that are launched in the directory
	// will have WorkDocs enabled.
	EnableWorkDocs *bool `type:"boolean"`

	// Indicates whether users are local administrators of their WorkSpaces.
	UserEnabledAsLocalAdministrator *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceCreationProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceCreationProperties) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceCreationProperties) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceCreationProperties"}
	if s.CustomSecurityGroupId != nil && len(*s.CustomSecurityGroupId) < 11 {
		invalidParams.Add(request.NewErrParamMinLen("CustomSecurityGroupId", 11))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomSecurityGroupId sets the CustomSecurityGroupId field's value.
func (s *WorkspaceCreationProperties) SetCustomSecurityGroupId(v string) *WorkspaceCreationProperties {
	s.CustomSecurityGroupId = &v
	return s
}

// SetDefaultOu sets the DefaultOu field's value.
func (s *WorkspaceCreationProperties) SetDefaultOu(v string) *WorkspaceCreationProperties {
	s.DefaultOu = &v
	return s
}

// SetEnableInternetAccess sets the EnableInternetAccess field's value.
func (s *WorkspaceCreationProperties) SetEnableInternetAccess(v bool) *WorkspaceCreationProperties {
	s.EnableInternetAccess = &v
	return s
}

// SetEnableMaintenanceMode sets the EnableMaintenanceMode field's value.
func (s *WorkspaceCreationProperties) SetEnableMaintenanceMode(v bool) *WorkspaceCreationProperties {
	s.EnableMaintenanceMode = &v
	return s
}

// SetEnableWorkDocs sets the EnableWorkDocs field's value.
func (s *WorkspaceCreationProperties) SetEnableWorkDocs(v bool) *WorkspaceCreationProperties {
	s.EnableWorkDocs = &v
	return s
}

// SetUserEnabledAsLocalAdministrator sets the UserEnabledAsLocalAdministrator field's value.
func (s *WorkspaceCreationProperties) SetUserEnabledAsLocalAdministrator(v bool) *WorkspaceCreationProperties {
	s.UserEnabledAsLocalAdministrator = &v
	return s
}

// Describes a directory that is used with Amazon WorkSpaces.
type WorkspaceDirectory struct {
	_ struct{} `type:"structure"`

	// The directory alias.
	Alias *string `type:"string"`

	// The user name for the service account.
	CustomerUserName *string `min:"1" type:"string"`

	// The directory identifier.
	DirectoryId *string `min:"10" type:"string"`

	// The name of the directory.
	DirectoryName *string `type:"string"`

	// The directory type.
	DirectoryType *string `type:"string" enum:"WorkspaceDirectoryType"`

	// The IP addresses of the DNS servers for the directory.
	DnsIpAddresses []*string `type:"list"`

	// The identifier of the IAM role. This is the role that allows Amazon WorkSpaces
	// to make calls to other services, such as Amazon EC2, on your behalf.
	IamRoleId *string `type:"string"`

	// The identifiers of the IP access control groups associated with the directory.
	IpGroupIds []*string `locationName:"ipGroupIds" type:"list"`

	// The registration code for the directory. This is the code that users enter
	// in their Amazon WorkSpaces client application to connect to the directory.
	RegistrationCode *string `min:"1" type:"string"`

	// The default self-service permissions for WorkSpaces in the directory.
	SelfservicePermissions *SelfservicePermissions `type:"structure"`

	// The state of the directory's registration with Amazon WorkSpaces. After a
	// directory is deregistered, the DEREGISTERED state is returned very briefly
	// before the directory metadata is cleaned up, so this state is rarely returned.
	// To confirm that a directory is deregistered, check for the directory ID by
	// using DescribeWorkspaceDirectories (https://docs.aws.amazon.com/workspaces/latest/api/API_DescribeWorkspaceDirectories.html).
	// If the directory ID isn't returned, then the directory has been successfully
	// deregistered.
	State *string `type:"string" enum:"WorkspaceDirectoryState"`

	// The identifiers of the subnets used with the directory.
	SubnetIds []*string `type:"list"`

	// Specifies whether the directory is dedicated or shared. To use Bring Your
	// Own License (BYOL), this value must be set to DEDICATED. For more information,
	// see Bring Your Own Windows Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	Tenancy *string `type:"string" enum:"Tenancy"`

	// The devices and operating systems that users can use to access WorkSpaces.
	WorkspaceAccessProperties *WorkspaceAccessProperties `type:"structure"`

	// The default creation properties for all WorkSpaces in the directory.
	WorkspaceCreationProperties *DefaultWorkspaceCreationProperties `type:"structure"`

	// The identifier of the security group that is assigned to new WorkSpaces.
	WorkspaceSecurityGroupId *string `min:"11" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDirectory) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceDirectory) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *WorkspaceDirectory) SetAlias(v string) *WorkspaceDirectory {
	s.Alias = &v
	return s
}

// SetCustomerUserName sets the CustomerUserName field's value.
func (s *WorkspaceDirectory) SetCustomerUserName(v string) *WorkspaceDirectory {
	s.CustomerUserName = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceDirectory) SetDirectoryId(v string) *WorkspaceDirectory {
	s.DirectoryId = &v
	return s
}

// SetDirectoryName sets the DirectoryName field's value.
func (s *WorkspaceDirectory) SetDirectoryName(v string) *WorkspaceDirectory {
	s.DirectoryName = &v
	return s
}

// SetDirectoryType sets the DirectoryType field's value.
func (s *WorkspaceDirectory) SetDirectoryType(v string) *WorkspaceDirectory {
	s.DirectoryType = &v
	return s
}

// SetDnsIpAddresses sets the DnsIpAddresses field's value.
func (s *WorkspaceDirectory) SetDnsIpAddresses(v []*string) *WorkspaceDirectory {
	s.DnsIpAddresses = v
	return s
}

// SetIamRoleId sets the IamRoleId field's value.
func (s *WorkspaceDirectory) SetIamRoleId(v string) *WorkspaceDirectory {
	s.IamRoleId = &v
	return s
}

// SetIpGroupIds sets the IpGroupIds field's value.
func (s *WorkspaceDirectory) SetIpGroupIds(v []*string) *WorkspaceDirectory {
	s.IpGroupIds = v
	return s
}

// SetRegistrationCode sets the RegistrationCode field's value.
func (s *WorkspaceDirectory) SetRegistrationCode(v string) *WorkspaceDirectory {
	s.RegistrationCode = &v
	return s
}

// SetSelfservicePermissions sets the SelfservicePermissions field's value.
func (s *WorkspaceDirectory) SetSelfservicePermissions(v *SelfservicePermissions) *WorkspaceDirectory {
	s.SelfservicePermissions = v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceDirectory) SetState(v string) *WorkspaceDirectory {
	s.State = &v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkspaceDirectory) SetSubnetIds(v []*string) *WorkspaceDirectory {
	s.SubnetIds = v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *WorkspaceDirectory) SetTenancy(v string) *WorkspaceDirectory {
	s.Tenancy = &v
	return s
}

// SetWorkspaceAccessProperties sets the WorkspaceAccessProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceAccessProperties(v *WorkspaceAccessProperties) *WorkspaceDirectory {
	s.WorkspaceAccessProperties = v
	return s
}

// SetWorkspaceCreationProperties sets the WorkspaceCreationProperties field's value.
func (s *WorkspaceDirectory) SetWorkspaceCreationProperties(v *DefaultWorkspaceCreationProperties) *WorkspaceDirectory {
	s.WorkspaceCreationProperties = v
	return s
}

// SetWorkspaceSecurityGroupId sets the WorkspaceSecurityGroupId field's value.
func (s *WorkspaceDirectory) SetWorkspaceSecurityGroupId(v string) *WorkspaceDirectory {
	s.WorkspaceSecurityGroupId = &v
	return s
}

// Describes a WorkSpace image.
type WorkspaceImage struct {
	_ struct{} `type:"structure"`

	// The date when the image was created. If the image has been shared, the Amazon
	// Web Services account that the image has been shared with sees the original
	// creation date of the image.
	Created *time.Time `type:"timestamp"`

	// The description of the image.
	Description *string `min:"1" type:"string"`

	// The error code that is returned for the image.
	ErrorCode *string `type:"string"`

	// The text of the error message that is returned for the image.
	ErrorMessage *string `type:"string"`

	// The identifier of the image.
	ImageId *string `type:"string"`

	// The name of the image.
	Name *string `min:"1" type:"string"`

	// The operating system that the image is running.
	OperatingSystem *OperatingSystem `type:"structure"`

	// The identifier of the Amazon Web Services account that owns the image.
	OwnerAccountId *string `type:"string"`

	// Specifies whether the image is running on dedicated hardware. When Bring
	// Your Own License (BYOL) is enabled, this value is set to DEDICATED. For more
	// information, see Bring Your Own Windows Desktop Images (https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
	RequiredTenancy *string `type:"string" enum:"WorkspaceImageRequiredTenancy"`

	// The status of the image.
	State *string `type:"string" enum:"WorkspaceImageState"`

	// The updates (if any) that are available for the specified image.
	Updates *UpdateResult `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceImage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceImage) GoString() string {
	return s.String()
}

// SetCreated sets the Created field's value.
func (s *WorkspaceImage) SetCreated(v time.Time) *WorkspaceImage {
	s.Created = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WorkspaceImage) SetDescription(v string) *WorkspaceImage {
	s.Description = &v
	return s
}

// SetErrorCode sets the ErrorCode field's value.
func (s *WorkspaceImage) SetErrorCode(v string) *WorkspaceImage {
	s.ErrorCode = &v
	return s
}

// SetErrorMessage sets the ErrorMessage field's value.
func (s *WorkspaceImage) SetErrorMessage(v string) *WorkspaceImage {
	s.ErrorMessage = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *WorkspaceImage) SetImageId(v string) *WorkspaceImage {
	s.ImageId = &v
	return s
}

// SetName sets the Name field's value.
func (s *WorkspaceImage) SetName(v string) *WorkspaceImage {
	s.Name = &v
	return s
}

// SetOperatingSystem sets the OperatingSystem field's value.
func (s *WorkspaceImage) SetOperatingSystem(v *OperatingSystem) *WorkspaceImage {
	s.OperatingSystem = v
	return s
}

// SetOwnerAccountId sets the OwnerAccountId field's value.
func (s *WorkspaceImage) SetOwnerAccountId(v string) *WorkspaceImage {
	s.OwnerAccountId = &v
	return s
}

// SetRequiredTenancy sets the RequiredTenancy field's value.
func (s *WorkspaceImage) SetRequiredTenancy(v string) *WorkspaceImage {
	s.RequiredTenancy = &v
	return s
}

// SetState sets the State field's value.
func (s *WorkspaceImage) SetState(v string) *WorkspaceImage {
	s.State = &v
	return s
}

// SetUpdates sets the Updates field's value.
func (s *WorkspaceImage) SetUpdates(v *UpdateResult) *WorkspaceImage {
	s.Updates = v
	return s
}

// Describes a WorkSpace.
type WorkspaceProperties struct {
	_ struct{} `type:"structure"`

	// The compute type. For more information, see Amazon WorkSpaces Bundles (http://aws.amazon.com/workspaces/details/#Amazon_WorkSpaces_Bundles).
	ComputeTypeName *string `type:"string" enum:"Compute"`

	// The size of the root volume. For important information about how to modify
	// the size of the root and user volumes, see Modify a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
	RootVolumeSizeGib *int64 `type:"integer"`

	// The running mode. For more information, see Manage the WorkSpace Running
	// Mode (https://docs.aws.amazon.com/workspaces/latest/adminguide/running-mode.html).
	RunningMode *string `type:"string" enum:"RunningMode"`

	// The time after a user logs off when WorkSpaces are automatically stopped.
	// Configured in 60-minute intervals.
	RunningModeAutoStopTimeoutInMinutes *int64 `type:"integer"`

	// The size of the user storage. For important information about how to modify
	// the size of the root and user volumes, see Modify a WorkSpace (https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
	UserVolumeSizeGib *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceProperties) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceProperties) GoString() string {
	return s.String()
}

// SetComputeTypeName sets the ComputeTypeName field's value.
func (s *WorkspaceProperties) SetComputeTypeName(v string) *WorkspaceProperties {
	s.ComputeTypeName = &v
	return s
}

// SetRootVolumeSizeGib sets the RootVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetRootVolumeSizeGib(v int64) *WorkspaceProperties {
	s.RootVolumeSizeGib = &v
	return s
}

// SetRunningMode sets the RunningMode field's value.
func (s *WorkspaceProperties) SetRunningMode(v string) *WorkspaceProperties {
	s.RunningMode = &v
	return s
}

// SetRunningModeAutoStopTimeoutInMinutes sets the RunningModeAutoStopTimeoutInMinutes field's value.
func (s *WorkspaceProperties) SetRunningModeAutoStopTimeoutInMinutes(v int64) *WorkspaceProperties {
	s.RunningModeAutoStopTimeoutInMinutes = &v
	return s
}

// SetUserVolumeSizeGib sets the UserVolumeSizeGib field's value.
func (s *WorkspaceProperties) SetUserVolumeSizeGib(v int64) *WorkspaceProperties {
	s.UserVolumeSizeGib = &v
	return s
}

// Describes the information used to create a WorkSpace.
type WorkspaceRequest struct {
	_ struct{} `type:"structure"`

	// The identifier of the bundle for the WorkSpace. You can use DescribeWorkspaceBundles
	// to list the available bundles.
	//
	// BundleId is a required field
	BundleId *string `type:"string" required:"true"`

	// The identifier of the Directory Service directory for the WorkSpace. You
	// can use DescribeWorkspaceDirectories to list the available directories.
	//
	// DirectoryId is a required field
	DirectoryId *string `min:"10" type:"string" required:"true"`

	// Indicates whether the data stored on the root volume is encrypted.
	RootVolumeEncryptionEnabled *bool `type:"boolean"`

	// The tags for the WorkSpace.
	Tags []*Tag `type:"list"`

	// The user name of the user for the WorkSpace. This user name must exist in
	// the Directory Service directory for the WorkSpace.
	//
	// UserName is a required field
	UserName *string `min:"1" type:"string" required:"true"`

	// Indicates whether the data stored on the user volume is encrypted.
	UserVolumeEncryptionEnabled *bool `type:"boolean"`

	// The symmetric KMS key used to encrypt data stored on your WorkSpace. Amazon
	// WorkSpaces does not support asymmetric KMS keys.
	VolumeEncryptionKey *string `type:"string"`

	// The WorkSpace properties.
	WorkspaceProperties *WorkspaceProperties `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceRequest) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspaceRequest) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *WorkspaceRequest) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "WorkspaceRequest"}
	if s.BundleId == nil {
		invalidParams.Add(request.NewErrParamRequired("BundleId"))
	}
	if s.DirectoryId == nil {
		invalidParams.Add(request.NewErrParamRequired("DirectoryId"))
	}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 10 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 10))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBundleId sets the BundleId field's value.
func (s *WorkspaceRequest) SetBundleId(v string) *WorkspaceRequest {
	s.BundleId = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *WorkspaceRequest) SetDirectoryId(v string) *WorkspaceRequest {
	s.DirectoryId = &v
	return s
}

// SetRootVolumeEncryptionEnabled sets the RootVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetRootVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.RootVolumeEncryptionEnabled = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *WorkspaceRequest) SetTags(v []*Tag) *WorkspaceRequest {
	s.Tags = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *WorkspaceRequest) SetUserName(v string) *WorkspaceRequest {
	s.UserName = &v
	return s
}

// SetUserVolumeEncryptionEnabled sets the UserVolumeEncryptionEnabled field's value.
func (s *WorkspaceRequest) SetUserVolumeEncryptionEnabled(v bool) *WorkspaceRequest {
	s.UserVolumeEncryptionEnabled = &v
	return s
}

// SetVolumeEncryptionKey sets the VolumeEncryptionKey field's value.
func (s *WorkspaceRequest) SetVolumeEncryptionKey(v string) *WorkspaceRequest {
	s.VolumeEncryptionKey = &v
	return s
}

// SetWorkspaceProperties sets the WorkspaceProperties field's value.
func (s *WorkspaceRequest) SetWorkspaceProperties(v *WorkspaceProperties) *WorkspaceRequest {
	s.WorkspaceProperties = v
	return s
}

// The workspaces_DefaultRole role could not be found. If this is the first
// time you are registering a directory, you will need to create the workspaces_DefaultRole
// role before you can register a directory. For more information, see Creating
// the workspaces_DefaultRole Role (https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
type WorkspacesDefaultRoleNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesDefaultRoleNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s WorkspacesDefaultRoleNotFoundException) GoString() string {
	return s.String()
}

func newErrorWorkspacesDefaultRoleNotFoundException(v protocol.ResponseMetadata) error {
	return &WorkspacesDefaultRoleNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *WorkspacesDefaultRoleNotFoundException) Code() string {
	return "WorkspacesDefaultRoleNotFoundException"
}

// Message returns the exception's message.
func (s *WorkspacesDefaultRoleNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *WorkspacesDefaultRoleNotFoundException) OrigErr() error {
	return nil
}

func (s *WorkspacesDefaultRoleNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *WorkspacesDefaultRoleNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *WorkspacesDefaultRoleNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// AccessPropertyValueAllow is a AccessPropertyValue enum value
	AccessPropertyValueAllow = "ALLOW"

	// AccessPropertyValueDeny is a AccessPropertyValue enum value
	AccessPropertyValueDeny = "DENY"
)

// AccessPropertyValue_Values returns all elements of the AccessPropertyValue enum
func AccessPropertyValue_Values() []string {
	return []string{
		AccessPropertyValueAllow,
		AccessPropertyValueDeny,
	}
}

const (
	// ApplicationMicrosoftOffice2016 is a Application enum value
	ApplicationMicrosoftOffice2016 = "Microsoft_Office_2016"

	// ApplicationMicrosoftOffice2019 is a Application enum value
	ApplicationMicrosoftOffice2019 = "Microsoft_Office_2019"
)

// Application_Values returns all elements of the Application enum
func Application_Values() []string {
	return []string{
		ApplicationMicrosoftOffice2016,
		ApplicationMicrosoftOffice2019,
	}
}

const (
	// AssociationStatusNotAssociated is a AssociationStatus enum value
	AssociationStatusNotAssociated = "NOT_ASSOCIATED"

	// AssociationStatusAssociatedWithOwnerAccount is a AssociationStatus enum value
	AssociationStatusAssociatedWithOwnerAccount = "ASSOCIATED_WITH_OWNER_ACCOUNT"

	// AssociationStatusAssociatedWithSharedAccount is a AssociationStatus enum value
	AssociationStatusAssociatedWithSharedAccount = "ASSOCIATED_WITH_SHARED_ACCOUNT"

	// AssociationStatusPendingAssociation is a AssociationStatus enum value
	AssociationStatusPendingAssociation = "PENDING_ASSOCIATION"

	// AssociationStatusPendingDisassociation is a AssociationStatus enum value
	AssociationStatusPendingDisassociation = "PENDING_DISASSOCIATION"
)

// AssociationStatus_Values returns all elements of the AssociationStatus enum
func AssociationStatus_Values() []string {
	return []string{
		AssociationStatusNotAssociated,
		AssociationStatusAssociatedWithOwnerAccount,
		AssociationStatusAssociatedWithSharedAccount,
		AssociationStatusPendingAssociation,
		AssociationStatusPendingDisassociation,
	}
}

const (
	// ComputeValue is a Compute enum value
	ComputeValue = "VALUE"

	// ComputeStandard is a Compute enum value
	ComputeStandard = "STANDARD"

	// ComputePerformance is a Compute enum value
	ComputePerformance = "PERFORMANCE"

	// ComputePower is a Compute enum value
	ComputePower = "POWER"

	// ComputeGraphics is a Compute enum value
	ComputeGraphics = "GRAPHICS"

	// ComputePowerpro is a Compute enum value
	ComputePowerpro = "POWERPRO"

	// ComputeGraphicspro is a Compute enum value
	ComputeGraphicspro = "GRAPHICSPRO"
)

// Compute_Values returns all elements of the Compute enum
func Compute_Values() []string {
	return []string{
		ComputeValue,
		ComputeStandard,
		ComputePerformance,
		ComputePower,
		ComputeGraphics,
		ComputePowerpro,
		ComputeGraphicspro,
	}
}

const (
	// ConnectionAliasStateCreating is a ConnectionAliasState enum value
	ConnectionAliasStateCreating = "CREATING"

	// ConnectionAliasStateCreated is a ConnectionAliasState enum value
	ConnectionAliasStateCreated = "CREATED"

	// ConnectionAliasStateDeleting is a ConnectionAliasState enum value
	ConnectionAliasStateDeleting = "DELETING"
)

// ConnectionAliasState_Values returns all elements of the ConnectionAliasState enum
func ConnectionAliasState_Values() []string {
	return []string{
		ConnectionAliasStateCreating,
		ConnectionAliasStateCreated,
		ConnectionAliasStateDeleting,
	}
}

const (
	// ConnectionStateConnected is a ConnectionState enum value
	ConnectionStateConnected = "CONNECTED"

	// ConnectionStateDisconnected is a ConnectionState enum value
	ConnectionStateDisconnected = "DISCONNECTED"

	// ConnectionStateUnknown is a ConnectionState enum value
	ConnectionStateUnknown = "UNKNOWN"
)

// ConnectionState_Values returns all elements of the ConnectionState enum
func ConnectionState_Values() []string {
	return []string{
		ConnectionStateConnected,
		ConnectionStateDisconnected,
		ConnectionStateUnknown,
	}
}

const (
	// DedicatedTenancyModificationStateEnumPending is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumPending = "PENDING"

	// DedicatedTenancyModificationStateEnumCompleted is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumCompleted = "COMPLETED"

	// DedicatedTenancyModificationStateEnumFailed is a DedicatedTenancyModificationStateEnum enum value
	DedicatedTenancyModificationStateEnumFailed = "FAILED"
)

// DedicatedTenancyModificationStateEnum_Values returns all elements of the DedicatedTenancyModificationStateEnum enum
func DedicatedTenancyModificationStateEnum_Values() []string {
	return []string{
		DedicatedTenancyModificationStateEnumPending,
		DedicatedTenancyModificationStateEnumCompleted,
		DedicatedTenancyModificationStateEnumFailed,
	}
}

const (
	// DedicatedTenancySupportEnumEnabled is a DedicatedTenancySupportEnum enum value
	DedicatedTenancySupportEnumEnabled = "ENABLED"
)

// DedicatedTenancySupportEnum_Values returns all elements of the DedicatedTenancySupportEnum enum
func DedicatedTenancySupportEnum_Values() []string {
	return []string{
		DedicatedTenancySupportEnumEnabled,
	}
}

const (
	// DedicatedTenancySupportResultEnumEnabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumEnabled = "ENABLED"

	// DedicatedTenancySupportResultEnumDisabled is a DedicatedTenancySupportResultEnum enum value
	DedicatedTenancySupportResultEnumDisabled = "DISABLED"
)

// DedicatedTenancySupportResultEnum_Values returns all elements of the DedicatedTenancySupportResultEnum enum
func DedicatedTenancySupportResultEnum_Values() []string {
	return []string{
		DedicatedTenancySupportResultEnumEnabled,
		DedicatedTenancySupportResultEnumDisabled,
	}
}

const (
	// ImageTypeOwned is a ImageType enum value
	ImageTypeOwned = "OWNED"

	// ImageTypeShared is a ImageType enum value
	ImageTypeShared = "SHARED"
)

// ImageType_Values returns all elements of the ImageType enum
func ImageType_Values() []string {
	return []string{
		ImageTypeOwned,
		ImageTypeShared,
	}
}

const (
	// ModificationResourceEnumRootVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumRootVolume = "ROOT_VOLUME"

	// ModificationResourceEnumUserVolume is a ModificationResourceEnum enum value
	ModificationResourceEnumUserVolume = "USER_VOLUME"

	// ModificationResourceEnumComputeType is a ModificationResourceEnum enum value
	ModificationResourceEnumComputeType = "COMPUTE_TYPE"
)

// ModificationResourceEnum_Values returns all elements of the ModificationResourceEnum enum
func ModificationResourceEnum_Values() []string {
	return []string{
		ModificationResourceEnumRootVolume,
		ModificationResourceEnumUserVolume,
		ModificationResourceEnumComputeType,
	}
}

const (
	// ModificationStateEnumUpdateInitiated is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInitiated = "UPDATE_INITIATED"

	// ModificationStateEnumUpdateInProgress is a ModificationStateEnum enum value
	ModificationStateEnumUpdateInProgress = "UPDATE_IN_PROGRESS"
)

// ModificationStateEnum_Values returns all elements of the ModificationStateEnum enum
func ModificationStateEnum_Values() []string {
	return []string{
		ModificationStateEnumUpdateInitiated,
		ModificationStateEnumUpdateInProgress,
	}
}

const (
	// OperatingSystemTypeWindows is a OperatingSystemType enum value
	OperatingSystemTypeWindows = "WINDOWS"

	// OperatingSystemTypeLinux is a OperatingSystemType enum value
	OperatingSystemTypeLinux = "LINUX"
)

// OperatingSystemType_Values returns all elements of the OperatingSystemType enum
func OperatingSystemType_Values() []string {
	return []string{
		OperatingSystemTypeWindows,
		OperatingSystemTypeLinux,
	}
}

const (
	// ReconnectEnumEnabled is a ReconnectEnum enum value
	ReconnectEnumEnabled = "ENABLED"

	// ReconnectEnumDisabled is a ReconnectEnum enum value
	ReconnectEnumDisabled = "DISABLED"
)

// ReconnectEnum_Values returns all elements of the ReconnectEnum enum
func ReconnectEnum_Values() []string {
	return []string{
		ReconnectEnumEnabled,
		ReconnectEnumDisabled,
	}
}

const (
	// RunningModeAutoStop is a RunningMode enum value
	RunningModeAutoStop = "AUTO_STOP"

	// RunningModeAlwaysOn is a RunningMode enum value
	RunningModeAlwaysOn = "ALWAYS_ON"
)

// RunningMode_Values returns all elements of the RunningMode enum
func RunningMode_Values() []string {
	return []string{
		RunningModeAutoStop,
		RunningModeAlwaysOn,
	}
}

const (
	// TargetWorkspaceStateAvailable is a TargetWorkspaceState enum value
	TargetWorkspaceStateAvailable = "AVAILABLE"

	// TargetWorkspaceStateAdminMaintenance is a TargetWorkspaceState enum value
	TargetWorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"
)

// TargetWorkspaceState_Values returns all elements of the TargetWorkspaceState enum
func TargetWorkspaceState_Values() []string {
	return []string{
		TargetWorkspaceStateAvailable,
		TargetWorkspaceStateAdminMaintenance,
	}
}

const (
	// TenancyDedicated is a Tenancy enum value
	TenancyDedicated = "DEDICATED"

	// TenancyShared is a Tenancy enum value
	TenancyShared = "SHARED"
)

// Tenancy_Values returns all elements of the Tenancy enum
func Tenancy_Values() []string {
	return []string{
		TenancyDedicated,
		TenancyShared,
	}
}

const (
	// WorkspaceDirectoryStateRegistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistering = "REGISTERING"

	// WorkspaceDirectoryStateRegistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateRegistered = "REGISTERED"

	// WorkspaceDirectoryStateDeregistering is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistering = "DEREGISTERING"

	// WorkspaceDirectoryStateDeregistered is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateDeregistered = "DEREGISTERED"

	// WorkspaceDirectoryStateError is a WorkspaceDirectoryState enum value
	WorkspaceDirectoryStateError = "ERROR"
)

// WorkspaceDirectoryState_Values returns all elements of the WorkspaceDirectoryState enum
func WorkspaceDirectoryState_Values() []string {
	return []string{
		WorkspaceDirectoryStateRegistering,
		WorkspaceDirectoryStateRegistered,
		WorkspaceDirectoryStateDeregistering,
		WorkspaceDirectoryStateDeregistered,
		WorkspaceDirectoryStateError,
	}
}

const (
	// WorkspaceDirectoryTypeSimpleAd is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeSimpleAd = "SIMPLE_AD"

	// WorkspaceDirectoryTypeAdConnector is a WorkspaceDirectoryType enum value
	WorkspaceDirectoryTypeAdConnector = "AD_CONNECTOR"
)

// WorkspaceDirectoryType_Values returns all elements of the WorkspaceDirectoryType enum
func WorkspaceDirectoryType_Values() []string {
	return []string{
		WorkspaceDirectoryTypeSimpleAd,
		WorkspaceDirectoryTypeAdConnector,
	}
}

const (
	// WorkspaceImageIngestionProcessByolRegular is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegular = "BYOL_REGULAR"

	// WorkspaceImageIngestionProcessByolGraphics is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphics = "BYOL_GRAPHICS"

	// WorkspaceImageIngestionProcessByolGraphicspro is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolGraphicspro = "BYOL_GRAPHICSPRO"

	// WorkspaceImageIngestionProcessByolRegularWsp is a WorkspaceImageIngestionProcess enum value
	WorkspaceImageIngestionProcessByolRegularWsp = "BYOL_REGULAR_WSP"
)

// WorkspaceImageIngestionProcess_Values returns all elements of the WorkspaceImageIngestionProcess enum
func WorkspaceImageIngestionProcess_Values() []string {
	return []string{
		WorkspaceImageIngestionProcessByolRegular,
		WorkspaceImageIngestionProcessByolGraphics,
		WorkspaceImageIngestionProcessByolGraphicspro,
		WorkspaceImageIngestionProcessByolRegularWsp,
	}
}

const (
	// WorkspaceImageRequiredTenancyDefault is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDefault = "DEFAULT"

	// WorkspaceImageRequiredTenancyDedicated is a WorkspaceImageRequiredTenancy enum value
	WorkspaceImageRequiredTenancyDedicated = "DEDICATED"
)

// WorkspaceImageRequiredTenancy_Values returns all elements of the WorkspaceImageRequiredTenancy enum
func WorkspaceImageRequiredTenancy_Values() []string {
	return []string{
		WorkspaceImageRequiredTenancyDefault,
		WorkspaceImageRequiredTenancyDedicated,
	}
}

const (
	// WorkspaceImageStateAvailable is a WorkspaceImageState enum value
	WorkspaceImageStateAvailable = "AVAILABLE"

	// WorkspaceImageStatePending is a WorkspaceImageState enum value
	WorkspaceImageStatePending = "PENDING"

	// WorkspaceImageStateError is a WorkspaceImageState enum value
	WorkspaceImageStateError = "ERROR"
)

// WorkspaceImageState_Values returns all elements of the WorkspaceImageState enum
func WorkspaceImageState_Values() []string {
	return []string{
		WorkspaceImageStateAvailable,
		WorkspaceImageStatePending,
		WorkspaceImageStateError,
	}
}

const (
	// WorkspaceStatePending is a WorkspaceState enum value
	WorkspaceStatePending = "PENDING"

	// WorkspaceStateAvailable is a WorkspaceState enum value
	WorkspaceStateAvailable = "AVAILABLE"

	// WorkspaceStateImpaired is a WorkspaceState enum value
	WorkspaceStateImpaired = "IMPAIRED"

	// WorkspaceStateUnhealthy is a WorkspaceState enum value
	WorkspaceStateUnhealthy = "UNHEALTHY"

	// WorkspaceStateRebooting is a WorkspaceState enum value
	WorkspaceStateRebooting = "REBOOTING"

	// WorkspaceStateStarting is a WorkspaceState enum value
	WorkspaceStateStarting = "STARTING"

	// WorkspaceStateRebuilding is a WorkspaceState enum value
	WorkspaceStateRebuilding = "REBUILDING"

	// WorkspaceStateRestoring is a WorkspaceState enum value
	WorkspaceStateRestoring = "RESTORING"

	// WorkspaceStateMaintenance is a WorkspaceState enum value
	WorkspaceStateMaintenance = "MAINTENANCE"

	// WorkspaceStateAdminMaintenance is a WorkspaceState enum value
	WorkspaceStateAdminMaintenance = "ADMIN_MAINTENANCE"

	// WorkspaceStateTerminating is a WorkspaceState enum value
	WorkspaceStateTerminating = "TERMINATING"

	// WorkspaceStateTerminated is a WorkspaceState enum value
	WorkspaceStateTerminated = "TERMINATED"

	// WorkspaceStateSuspended is a WorkspaceState enum value
	WorkspaceStateSuspended = "SUSPENDED"

	// WorkspaceStateUpdating is a WorkspaceState enum value
	WorkspaceStateUpdating = "UPDATING"

	// WorkspaceStateStopping is a WorkspaceState enum value
	WorkspaceStateStopping = "STOPPING"

	// WorkspaceStateStopped is a WorkspaceState enum value
	WorkspaceStateStopped = "STOPPED"

	// WorkspaceStateError is a WorkspaceState enum value
	WorkspaceStateError = "ERROR"
)

// WorkspaceState_Values returns all elements of the WorkspaceState enum
func WorkspaceState_Values() []string {
	return []string{
		WorkspaceStatePending,
		WorkspaceStateAvailable,
		WorkspaceStateImpaired,
		WorkspaceStateUnhealthy,
		WorkspaceStateRebooting,
		WorkspaceStateStarting,
		WorkspaceStateRebuilding,
		WorkspaceStateRestoring,
		WorkspaceStateMaintenance,
		WorkspaceStateAdminMaintenance,
		WorkspaceStateTerminating,
		WorkspaceStateTerminated,
		WorkspaceStateSuspended,
		WorkspaceStateUpdating,
		WorkspaceStateStopping,
		WorkspaceStateStopped,
		WorkspaceStateError,
	}
}
