// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package connect

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opActivateEvaluationForm = "ActivateEvaluationForm"

// ActivateEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the ActivateEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ActivateEvaluationForm for more information on using the ActivateEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ActivateEvaluationFormRequest method.
//	req, resp := client.ActivateEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm
func (c *Connect) ActivateEvaluationFormRequest(input *ActivateEvaluationFormInput) (req *request.Request, output *ActivateEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opActivateEvaluationForm,
		HTTPMethod: "POST",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}/activate",
	}

	if input == nil {
		input = &ActivateEvaluationFormInput{}
	}

	output = &ActivateEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ActivateEvaluationForm API operation for Amazon Connect Service.
//
// Activates an evaluation form in the specified Amazon Connect instance. After
// the evaluation form is activated, it is available to start new evaluations
// based on the form.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ActivateEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ActivateEvaluationForm
func (c *Connect) ActivateEvaluationForm(input *ActivateEvaluationFormInput) (*ActivateEvaluationFormOutput, error) {
	req, out := c.ActivateEvaluationFormRequest(input)
	return out, req.Send()
}

// ActivateEvaluationFormWithContext is the same as ActivateEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See ActivateEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ActivateEvaluationFormWithContext(ctx aws.Context, input *ActivateEvaluationFormInput, opts ...request.Option) (*ActivateEvaluationFormOutput, error) {
	req, out := c.ActivateEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateApprovedOrigin = "AssociateApprovedOrigin"

// AssociateApprovedOriginRequest generates a "aws/request.Request" representing the
// client's request for the AssociateApprovedOrigin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateApprovedOrigin for more information on using the AssociateApprovedOrigin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateApprovedOriginRequest method.
//	req, resp := client.AssociateApprovedOriginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin
func (c *Connect) AssociateApprovedOriginRequest(input *AssociateApprovedOriginInput) (req *request.Request, output *AssociateApprovedOriginOutput) {
	op := &request.Operation{
		Name:       opAssociateApprovedOrigin,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/approved-origin",
	}

	if input == nil {
		input = &AssociateApprovedOriginInput{}
	}

	output = &AssociateApprovedOriginOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateApprovedOrigin API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Associates an approved origin to an Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateApprovedOrigin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateApprovedOrigin
func (c *Connect) AssociateApprovedOrigin(input *AssociateApprovedOriginInput) (*AssociateApprovedOriginOutput, error) {
	req, out := c.AssociateApprovedOriginRequest(input)
	return out, req.Send()
}

// AssociateApprovedOriginWithContext is the same as AssociateApprovedOrigin with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateApprovedOrigin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateApprovedOriginWithContext(ctx aws.Context, input *AssociateApprovedOriginInput, opts ...request.Option) (*AssociateApprovedOriginOutput, error) {
	req, out := c.AssociateApprovedOriginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateBot = "AssociateBot"

// AssociateBotRequest generates a "aws/request.Request" representing the
// client's request for the AssociateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateBot for more information on using the AssociateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateBotRequest method.
//	req, resp := client.AssociateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot
func (c *Connect) AssociateBotRequest(input *AssociateBotInput) (req *request.Request, output *AssociateBotOutput) {
	op := &request.Operation{
		Name:       opAssociateBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/bot",
	}

	if input == nil {
		input = &AssociateBotInput{}
	}

	output = &AssociateBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateBot API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Allows the specified Amazon Connect instance to access the specified Amazon
// Lex or Amazon Lex V2 bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateBot for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateBot
func (c *Connect) AssociateBot(input *AssociateBotInput) (*AssociateBotOutput, error) {
	req, out := c.AssociateBotRequest(input)
	return out, req.Send()
}

// AssociateBotWithContext is the same as AssociateBot with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateBotWithContext(ctx aws.Context, input *AssociateBotInput, opts ...request.Option) (*AssociateBotOutput, error) {
	req, out := c.AssociateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateDefaultVocabulary = "AssociateDefaultVocabulary"

// AssociateDefaultVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the AssociateDefaultVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateDefaultVocabulary for more information on using the AssociateDefaultVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateDefaultVocabularyRequest method.
//	req, resp := client.AssociateDefaultVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary
func (c *Connect) AssociateDefaultVocabularyRequest(input *AssociateDefaultVocabularyInput) (req *request.Request, output *AssociateDefaultVocabularyOutput) {
	op := &request.Operation{
		Name:       opAssociateDefaultVocabulary,
		HTTPMethod: "PUT",
		HTTPPath:   "/default-vocabulary/{InstanceId}/{LanguageCode}",
	}

	if input == nil {
		input = &AssociateDefaultVocabularyInput{}
	}

	output = &AssociateDefaultVocabularyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateDefaultVocabulary API operation for Amazon Connect Service.
//
// Associates an existing vocabulary as the default. Contact Lens for Amazon
// Connect uses the vocabulary in post-call and real-time analysis sessions
// for the given language.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateDefaultVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateDefaultVocabulary
func (c *Connect) AssociateDefaultVocabulary(input *AssociateDefaultVocabularyInput) (*AssociateDefaultVocabularyOutput, error) {
	req, out := c.AssociateDefaultVocabularyRequest(input)
	return out, req.Send()
}

// AssociateDefaultVocabularyWithContext is the same as AssociateDefaultVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateDefaultVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateDefaultVocabularyWithContext(ctx aws.Context, input *AssociateDefaultVocabularyInput, opts ...request.Option) (*AssociateDefaultVocabularyOutput, error) {
	req, out := c.AssociateDefaultVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateInstanceStorageConfig = "AssociateInstanceStorageConfig"

// AssociateInstanceStorageConfigRequest generates a "aws/request.Request" representing the
// client's request for the AssociateInstanceStorageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateInstanceStorageConfig for more information on using the AssociateInstanceStorageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateInstanceStorageConfigRequest method.
//	req, resp := client.AssociateInstanceStorageConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig
func (c *Connect) AssociateInstanceStorageConfigRequest(input *AssociateInstanceStorageConfigInput) (req *request.Request, output *AssociateInstanceStorageConfigOutput) {
	op := &request.Operation{
		Name:       opAssociateInstanceStorageConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/storage-config",
	}

	if input == nil {
		input = &AssociateInstanceStorageConfigInput{}
	}

	output = &AssociateInstanceStorageConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateInstanceStorageConfig API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Associates a storage resource type for the first time. You can only associate
// one type of storage configuration in a single call. This means, for example,
// that you can't define an instance with multiple S3 buckets for storing chat
// transcripts.
//
// This API does not create a resource that doesn't exist. It only associates
// it to the instance. Ensure that the resource being specified in the storage
// configuration, like an S3 bucket, exists when being used for association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateInstanceStorageConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateInstanceStorageConfig
func (c *Connect) AssociateInstanceStorageConfig(input *AssociateInstanceStorageConfigInput) (*AssociateInstanceStorageConfigOutput, error) {
	req, out := c.AssociateInstanceStorageConfigRequest(input)
	return out, req.Send()
}

// AssociateInstanceStorageConfigWithContext is the same as AssociateInstanceStorageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateInstanceStorageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateInstanceStorageConfigWithContext(ctx aws.Context, input *AssociateInstanceStorageConfigInput, opts ...request.Option) (*AssociateInstanceStorageConfigOutput, error) {
	req, out := c.AssociateInstanceStorageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateLambdaFunction = "AssociateLambdaFunction"

// AssociateLambdaFunctionRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLambdaFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLambdaFunction for more information on using the AssociateLambdaFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateLambdaFunctionRequest method.
//	req, resp := client.AssociateLambdaFunctionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction
func (c *Connect) AssociateLambdaFunctionRequest(input *AssociateLambdaFunctionInput) (req *request.Request, output *AssociateLambdaFunctionOutput) {
	op := &request.Operation{
		Name:       opAssociateLambdaFunction,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/lambda-function",
	}

	if input == nil {
		input = &AssociateLambdaFunctionInput{}
	}

	output = &AssociateLambdaFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateLambdaFunction API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Allows the specified Amazon Connect instance to access the specified Lambda
// function.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateLambdaFunction for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLambdaFunction
func (c *Connect) AssociateLambdaFunction(input *AssociateLambdaFunctionInput) (*AssociateLambdaFunctionOutput, error) {
	req, out := c.AssociateLambdaFunctionRequest(input)
	return out, req.Send()
}

// AssociateLambdaFunctionWithContext is the same as AssociateLambdaFunction with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLambdaFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateLambdaFunctionWithContext(ctx aws.Context, input *AssociateLambdaFunctionInput, opts ...request.Option) (*AssociateLambdaFunctionOutput, error) {
	req, out := c.AssociateLambdaFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateLexBot = "AssociateLexBot"

// AssociateLexBotRequest generates a "aws/request.Request" representing the
// client's request for the AssociateLexBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateLexBot for more information on using the AssociateLexBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateLexBotRequest method.
//	req, resp := client.AssociateLexBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot
func (c *Connect) AssociateLexBotRequest(input *AssociateLexBotInput) (req *request.Request, output *AssociateLexBotOutput) {
	op := &request.Operation{
		Name:       opAssociateLexBot,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/lex-bot",
	}

	if input == nil {
		input = &AssociateLexBotInput{}
	}

	output = &AssociateLexBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateLexBot API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Allows the specified Amazon Connect instance to access the specified Amazon
// Lex V1 bot. This API only supports the association of Amazon Lex V1 bots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateLexBot for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateLexBot
func (c *Connect) AssociateLexBot(input *AssociateLexBotInput) (*AssociateLexBotOutput, error) {
	req, out := c.AssociateLexBotRequest(input)
	return out, req.Send()
}

// AssociateLexBotWithContext is the same as AssociateLexBot with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateLexBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateLexBotWithContext(ctx aws.Context, input *AssociateLexBotInput, opts ...request.Option) (*AssociateLexBotOutput, error) {
	req, out := c.AssociateLexBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociatePhoneNumberContactFlow = "AssociatePhoneNumberContactFlow"

// AssociatePhoneNumberContactFlowRequest generates a "aws/request.Request" representing the
// client's request for the AssociatePhoneNumberContactFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociatePhoneNumberContactFlow for more information on using the AssociatePhoneNumberContactFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociatePhoneNumberContactFlowRequest method.
//	req, resp := client.AssociatePhoneNumberContactFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow
func (c *Connect) AssociatePhoneNumberContactFlowRequest(input *AssociatePhoneNumberContactFlowInput) (req *request.Request, output *AssociatePhoneNumberContactFlowOutput) {
	op := &request.Operation{
		Name:       opAssociatePhoneNumberContactFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/phone-number/{PhoneNumberId}/contact-flow",
	}

	if input == nil {
		input = &AssociatePhoneNumberContactFlowInput{}
	}

	output = &AssociatePhoneNumberContactFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociatePhoneNumberContactFlow API operation for Amazon Connect Service.
//
// Associates a flow with a phone number claimed to your Amazon Connect instance.
//
// If the number is claimed to a traffic distribution group, and you are calling
// this API using an instance in the Amazon Web Services Region where the traffic
// distribution group was created, you can use either a full phone number ARN
// or UUID value for the PhoneNumberId URI request parameter. However, if the
// number is claimed to a traffic distribution group and you are calling this
// API using an instance in the alternate Amazon Web Services Region associated
// with the traffic distribution group, you must provide a full phone number
// ARN. If a UUID is provided in this scenario, you will receive a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociatePhoneNumberContactFlow for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociatePhoneNumberContactFlow
func (c *Connect) AssociatePhoneNumberContactFlow(input *AssociatePhoneNumberContactFlowInput) (*AssociatePhoneNumberContactFlowOutput, error) {
	req, out := c.AssociatePhoneNumberContactFlowRequest(input)
	return out, req.Send()
}

// AssociatePhoneNumberContactFlowWithContext is the same as AssociatePhoneNumberContactFlow with the addition of
// the ability to pass a context and additional request options.
//
// See AssociatePhoneNumberContactFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociatePhoneNumberContactFlowWithContext(ctx aws.Context, input *AssociatePhoneNumberContactFlowInput, opts ...request.Option) (*AssociatePhoneNumberContactFlowOutput, error) {
	req, out := c.AssociatePhoneNumberContactFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateQueueQuickConnects = "AssociateQueueQuickConnects"

// AssociateQueueQuickConnectsRequest generates a "aws/request.Request" representing the
// client's request for the AssociateQueueQuickConnects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateQueueQuickConnects for more information on using the AssociateQueueQuickConnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateQueueQuickConnectsRequest method.
//	req, resp := client.AssociateQueueQuickConnectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects
func (c *Connect) AssociateQueueQuickConnectsRequest(input *AssociateQueueQuickConnectsInput) (req *request.Request, output *AssociateQueueQuickConnectsOutput) {
	op := &request.Operation{
		Name:       opAssociateQueueQuickConnects,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/associate-quick-connects",
	}

	if input == nil {
		input = &AssociateQueueQuickConnectsInput{}
	}

	output = &AssociateQueueQuickConnectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateQueueQuickConnects API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Associates a set of quick connects with a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateQueueQuickConnects for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateQueueQuickConnects
func (c *Connect) AssociateQueueQuickConnects(input *AssociateQueueQuickConnectsInput) (*AssociateQueueQuickConnectsOutput, error) {
	req, out := c.AssociateQueueQuickConnectsRequest(input)
	return out, req.Send()
}

// AssociateQueueQuickConnectsWithContext is the same as AssociateQueueQuickConnects with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateQueueQuickConnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateQueueQuickConnectsWithContext(ctx aws.Context, input *AssociateQueueQuickConnectsInput, opts ...request.Option) (*AssociateQueueQuickConnectsOutput, error) {
	req, out := c.AssociateQueueQuickConnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateRoutingProfileQueues = "AssociateRoutingProfileQueues"

// AssociateRoutingProfileQueuesRequest generates a "aws/request.Request" representing the
// client's request for the AssociateRoutingProfileQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateRoutingProfileQueues for more information on using the AssociateRoutingProfileQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateRoutingProfileQueuesRequest method.
//	req, resp := client.AssociateRoutingProfileQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues
func (c *Connect) AssociateRoutingProfileQueuesRequest(input *AssociateRoutingProfileQueuesInput) (req *request.Request, output *AssociateRoutingProfileQueuesOutput) {
	op := &request.Operation{
		Name:       opAssociateRoutingProfileQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/associate-queues",
	}

	if input == nil {
		input = &AssociateRoutingProfileQueuesInput{}
	}

	output = &AssociateRoutingProfileQueuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// AssociateRoutingProfileQueues API operation for Amazon Connect Service.
//
// Associates a set of queues with a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateRoutingProfileQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateRoutingProfileQueues
func (c *Connect) AssociateRoutingProfileQueues(input *AssociateRoutingProfileQueuesInput) (*AssociateRoutingProfileQueuesOutput, error) {
	req, out := c.AssociateRoutingProfileQueuesRequest(input)
	return out, req.Send()
}

// AssociateRoutingProfileQueuesWithContext is the same as AssociateRoutingProfileQueues with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateRoutingProfileQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateRoutingProfileQueuesWithContext(ctx aws.Context, input *AssociateRoutingProfileQueuesInput, opts ...request.Option) (*AssociateRoutingProfileQueuesOutput, error) {
	req, out := c.AssociateRoutingProfileQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateSecurityKey = "AssociateSecurityKey"

// AssociateSecurityKeyRequest generates a "aws/request.Request" representing the
// client's request for the AssociateSecurityKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateSecurityKey for more information on using the AssociateSecurityKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateSecurityKeyRequest method.
//	req, resp := client.AssociateSecurityKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey
func (c *Connect) AssociateSecurityKeyRequest(input *AssociateSecurityKeyInput) (req *request.Request, output *AssociateSecurityKeyOutput) {
	op := &request.Operation{
		Name:       opAssociateSecurityKey,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/security-key",
	}

	if input == nil {
		input = &AssociateSecurityKeyInput{}
	}

	output = &AssociateSecurityKeyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateSecurityKey API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Associates a security key to the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation AssociateSecurityKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/AssociateSecurityKey
func (c *Connect) AssociateSecurityKey(input *AssociateSecurityKeyInput) (*AssociateSecurityKeyOutput, error) {
	req, out := c.AssociateSecurityKeyRequest(input)
	return out, req.Send()
}

// AssociateSecurityKeyWithContext is the same as AssociateSecurityKey with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateSecurityKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) AssociateSecurityKeyWithContext(ctx aws.Context, input *AssociateSecurityKeyInput, opts ...request.Option) (*AssociateSecurityKeyOutput, error) {
	req, out := c.AssociateSecurityKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opClaimPhoneNumber = "ClaimPhoneNumber"

// ClaimPhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the ClaimPhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ClaimPhoneNumber for more information on using the ClaimPhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ClaimPhoneNumberRequest method.
//	req, resp := client.ClaimPhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber
func (c *Connect) ClaimPhoneNumberRequest(input *ClaimPhoneNumberInput) (req *request.Request, output *ClaimPhoneNumberOutput) {
	op := &request.Operation{
		Name:       opClaimPhoneNumber,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number/claim",
	}

	if input == nil {
		input = &ClaimPhoneNumberInput{}
	}

	output = &ClaimPhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ClaimPhoneNumber API operation for Amazon Connect Service.
//
// Claims an available phone number to your Amazon Connect instance or traffic
// distribution group. You can call this API only in the same Amazon Web Services
// Region where the Amazon Connect instance or traffic distribution group was
// created.
//
// For more information about how to use this operation, see Claim a phone number
// in your country (https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-number.html)
// and Claim phone numbers to traffic distribution groups (https://docs.aws.amazon.com/connect/latest/adminguide/claim-phone-numbers-traffic-distribution-groups.html)
// in the Amazon Connect Administrator Guide.
//
// You can call the SearchAvailablePhoneNumbers (https://docs.aws.amazon.com/connect/latest/APIReference/API_SearchAvailablePhoneNumbers.html)
// API for available phone numbers that you can claim. Call the DescribePhoneNumber
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html)
// API to verify the status of a previous ClaimPhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimPhoneNumber.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ClaimPhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ClaimPhoneNumber
func (c *Connect) ClaimPhoneNumber(input *ClaimPhoneNumberInput) (*ClaimPhoneNumberOutput, error) {
	req, out := c.ClaimPhoneNumberRequest(input)
	return out, req.Send()
}

// ClaimPhoneNumberWithContext is the same as ClaimPhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See ClaimPhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ClaimPhoneNumberWithContext(ctx aws.Context, input *ClaimPhoneNumberInput, opts ...request.Option) (*ClaimPhoneNumberOutput, error) {
	req, out := c.ClaimPhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAgentStatus = "CreateAgentStatus"

// CreateAgentStatusRequest generates a "aws/request.Request" representing the
// client's request for the CreateAgentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateAgentStatus for more information on using the CreateAgentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateAgentStatusRequest method.
//	req, resp := client.CreateAgentStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus
func (c *Connect) CreateAgentStatusRequest(input *CreateAgentStatusInput) (req *request.Request, output *CreateAgentStatusOutput) {
	op := &request.Operation{
		Name:       opCreateAgentStatus,
		HTTPMethod: "PUT",
		HTTPPath:   "/agent-status/{InstanceId}",
	}

	if input == nil {
		input = &CreateAgentStatusInput{}
	}

	output = &CreateAgentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateAgentStatus API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Creates an agent status for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateAgentStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateAgentStatus
func (c *Connect) CreateAgentStatus(input *CreateAgentStatusInput) (*CreateAgentStatusOutput, error) {
	req, out := c.CreateAgentStatusRequest(input)
	return out, req.Send()
}

// CreateAgentStatusWithContext is the same as CreateAgentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAgentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateAgentStatusWithContext(ctx aws.Context, input *CreateAgentStatusInput, opts ...request.Option) (*CreateAgentStatusOutput, error) {
	req, out := c.CreateAgentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContactFlow = "CreateContactFlow"

// CreateContactFlowRequest generates a "aws/request.Request" representing the
// client's request for the CreateContactFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContactFlow for more information on using the CreateContactFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactFlowRequest method.
//	req, resp := client.CreateContactFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow
func (c *Connect) CreateContactFlowRequest(input *CreateContactFlowInput) (req *request.Request, output *CreateContactFlowOutput) {
	op := &request.Operation{
		Name:       opCreateContactFlow,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact-flows/{InstanceId}",
	}

	if input == nil {
		input = &CreateContactFlowInput{}
	}

	output = &CreateContactFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContactFlow API operation for Amazon Connect Service.
//
// Creates a flow for the specified Amazon Connect instance.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateContactFlow for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidContactFlowException
//     The flow is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlow
func (c *Connect) CreateContactFlow(input *CreateContactFlowInput) (*CreateContactFlowOutput, error) {
	req, out := c.CreateContactFlowRequest(input)
	return out, req.Send()
}

// CreateContactFlowWithContext is the same as CreateContactFlow with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContactFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateContactFlowWithContext(ctx aws.Context, input *CreateContactFlowInput, opts ...request.Option) (*CreateContactFlowOutput, error) {
	req, out := c.CreateContactFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateContactFlowModule = "CreateContactFlowModule"

// CreateContactFlowModuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateContactFlowModule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateContactFlowModule for more information on using the CreateContactFlowModule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateContactFlowModuleRequest method.
//	req, resp := client.CreateContactFlowModuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule
func (c *Connect) CreateContactFlowModuleRequest(input *CreateContactFlowModuleInput) (req *request.Request, output *CreateContactFlowModuleOutput) {
	op := &request.Operation{
		Name:       opCreateContactFlowModule,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact-flow-modules/{InstanceId}",
	}

	if input == nil {
		input = &CreateContactFlowModuleInput{}
	}

	output = &CreateContactFlowModuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateContactFlowModule API operation for Amazon Connect Service.
//
// Creates a flow module for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateContactFlowModule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidContactFlowModuleException
//     The problems with the module. Please fix before trying again.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateContactFlowModule
func (c *Connect) CreateContactFlowModule(input *CreateContactFlowModuleInput) (*CreateContactFlowModuleOutput, error) {
	req, out := c.CreateContactFlowModuleRequest(input)
	return out, req.Send()
}

// CreateContactFlowModuleWithContext is the same as CreateContactFlowModule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateContactFlowModule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateContactFlowModuleWithContext(ctx aws.Context, input *CreateContactFlowModuleInput, opts ...request.Option) (*CreateContactFlowModuleOutput, error) {
	req, out := c.CreateContactFlowModuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEvaluationForm = "CreateEvaluationForm"

// CreateEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the CreateEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEvaluationForm for more information on using the CreateEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateEvaluationFormRequest method.
//	req, resp := client.CreateEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm
func (c *Connect) CreateEvaluationFormRequest(input *CreateEvaluationFormInput) (req *request.Request, output *CreateEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opCreateEvaluationForm,
		HTTPMethod: "PUT",
		HTTPPath:   "/evaluation-forms/{InstanceId}",
	}

	if input == nil {
		input = &CreateEvaluationFormInput{}
	}

	output = &CreateEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEvaluationForm API operation for Amazon Connect Service.
//
// Creates an evaluation form in the specified Amazon Connect instance. The
// form can be used to define questions related to agent performance, and create
// sections to organize such questions. An evaluation form must have a unique
// title within an instance. Question and section identifiers cannot be duplicated
// within the same evaluation form.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateEvaluationForm
func (c *Connect) CreateEvaluationForm(input *CreateEvaluationFormInput) (*CreateEvaluationFormOutput, error) {
	req, out := c.CreateEvaluationFormRequest(input)
	return out, req.Send()
}

// CreateEvaluationFormWithContext is the same as CreateEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateEvaluationFormWithContext(ctx aws.Context, input *CreateEvaluationFormInput, opts ...request.Option) (*CreateEvaluationFormOutput, error) {
	req, out := c.CreateEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateHoursOfOperation = "CreateHoursOfOperation"

// CreateHoursOfOperationRequest generates a "aws/request.Request" representing the
// client's request for the CreateHoursOfOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateHoursOfOperation for more information on using the CreateHoursOfOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateHoursOfOperationRequest method.
//	req, resp := client.CreateHoursOfOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation
func (c *Connect) CreateHoursOfOperationRequest(input *CreateHoursOfOperationInput) (req *request.Request, output *CreateHoursOfOperationOutput) {
	op := &request.Operation{
		Name:       opCreateHoursOfOperation,
		HTTPMethod: "PUT",
		HTTPPath:   "/hours-of-operations/{InstanceId}",
	}

	if input == nil {
		input = &CreateHoursOfOperationInput{}
	}

	output = &CreateHoursOfOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateHoursOfOperation API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Creates hours of operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateHoursOfOperation for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateHoursOfOperation
func (c *Connect) CreateHoursOfOperation(input *CreateHoursOfOperationInput) (*CreateHoursOfOperationOutput, error) {
	req, out := c.CreateHoursOfOperationRequest(input)
	return out, req.Send()
}

// CreateHoursOfOperationWithContext is the same as CreateHoursOfOperation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateHoursOfOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateHoursOfOperationWithContext(ctx aws.Context, input *CreateHoursOfOperationInput, opts ...request.Option) (*CreateHoursOfOperationOutput, error) {
	req, out := c.CreateHoursOfOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the CreateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateInstance for more information on using the CreateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateInstanceRequest method.
//	req, resp := client.CreateInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance
func (c *Connect) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	output = &CreateInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateInstance API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Initiates an Amazon Connect instance with all the supported channels enabled.
// It does not attach any storage, such as Amazon Simple Storage Service (Amazon
// S3) or Amazon Kinesis. It also does not allow for any configurations on features,
// such as Contact Lens for Amazon Connect.
//
// Amazon Connect enforces a limit on the total number of instances that you
// can create or delete in 30 days. If you exceed this limit, you will get an
// error message indicating there has been an excessive number of attempts at
// creating or deleting instances. You must wait 30 days before you can restart
// creating and deleting instances in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateInstance
func (c *Connect) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	return out, req.Send()
}

// CreateInstanceWithContext is the same as CreateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateInstanceWithContext(ctx aws.Context, input *CreateInstanceInput, opts ...request.Option) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateIntegrationAssociation = "CreateIntegrationAssociation"

// CreateIntegrationAssociationRequest generates a "aws/request.Request" representing the
// client's request for the CreateIntegrationAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateIntegrationAssociation for more information on using the CreateIntegrationAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateIntegrationAssociationRequest method.
//	req, resp := client.CreateIntegrationAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation
func (c *Connect) CreateIntegrationAssociationRequest(input *CreateIntegrationAssociationInput) (req *request.Request, output *CreateIntegrationAssociationOutput) {
	op := &request.Operation{
		Name:       opCreateIntegrationAssociation,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/integration-associations",
	}

	if input == nil {
		input = &CreateIntegrationAssociationInput{}
	}

	output = &CreateIntegrationAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateIntegrationAssociation API operation for Amazon Connect Service.
//
// Creates an Amazon Web Services resource association with an Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateIntegrationAssociation for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateIntegrationAssociation
func (c *Connect) CreateIntegrationAssociation(input *CreateIntegrationAssociationInput) (*CreateIntegrationAssociationOutput, error) {
	req, out := c.CreateIntegrationAssociationRequest(input)
	return out, req.Send()
}

// CreateIntegrationAssociationWithContext is the same as CreateIntegrationAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See CreateIntegrationAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateIntegrationAssociationWithContext(ctx aws.Context, input *CreateIntegrationAssociationInput, opts ...request.Option) (*CreateIntegrationAssociationOutput, error) {
	req, out := c.CreateIntegrationAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateParticipant = "CreateParticipant"

// CreateParticipantRequest generates a "aws/request.Request" representing the
// client's request for the CreateParticipant operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateParticipant for more information on using the CreateParticipant
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateParticipantRequest method.
//	req, resp := client.CreateParticipantRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant
func (c *Connect) CreateParticipantRequest(input *CreateParticipantInput) (req *request.Request, output *CreateParticipantOutput) {
	op := &request.Operation{
		Name:       opCreateParticipant,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/create-participant",
	}

	if input == nil {
		input = &CreateParticipantInput{}
	}

	output = &CreateParticipantOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateParticipant API operation for Amazon Connect Service.
//
// Adds a new participant into an on-going chat contact. For more information,
// see Customize chat flow experiences by integrating custom participants (https://docs.aws.amazon.com/connect/latest/adminguide/chat-customize-flow.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateParticipant for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateParticipant
func (c *Connect) CreateParticipant(input *CreateParticipantInput) (*CreateParticipantOutput, error) {
	req, out := c.CreateParticipantRequest(input)
	return out, req.Send()
}

// CreateParticipantWithContext is the same as CreateParticipant with the addition of
// the ability to pass a context and additional request options.
//
// See CreateParticipant for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateParticipantWithContext(ctx aws.Context, input *CreateParticipantInput, opts ...request.Option) (*CreateParticipantOutput, error) {
	req, out := c.CreateParticipantRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueue = "CreateQueue"

// CreateQueueRequest generates a "aws/request.Request" representing the
// client's request for the CreateQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQueue for more information on using the CreateQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQueueRequest method.
//	req, resp := client.CreateQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue
func (c *Connect) CreateQueueRequest(input *CreateQueueInput) (req *request.Request, output *CreateQueueOutput) {
	op := &request.Operation{
		Name:       opCreateQueue,
		HTTPMethod: "PUT",
		HTTPPath:   "/queues/{InstanceId}",
	}

	if input == nil {
		input = &CreateQueueInput{}
	}

	output = &CreateQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQueue API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Creates a new queue for the specified Amazon Connect instance.
//
// If the number being used in the input is claimed to a traffic distribution
// group, and you are calling this API using an instance in the Amazon Web Services
// Region where the traffic distribution group was created, you can use either
// a full phone number ARN or UUID value for the OutboundCallerIdNumberId value
// of the OutboundCallerConfig (https://docs.aws.amazon.com/connect/latest/APIReference/API_OutboundCallerConfig)
// request body parameter. However, if the number is claimed to a traffic distribution
// group and you are calling this API using an instance in the alternate Amazon
// Web Services Region associated with the traffic distribution group, you must
// provide a full phone number ARN. If a UUID is provided in this scenario,
// you will receive a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateQueue for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQueue
func (c *Connect) CreateQueue(input *CreateQueueInput) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	return out, req.Send()
}

// CreateQueueWithContext is the same as CreateQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateQueueWithContext(ctx aws.Context, input *CreateQueueInput, opts ...request.Option) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQuickConnect = "CreateQuickConnect"

// CreateQuickConnectRequest generates a "aws/request.Request" representing the
// client's request for the CreateQuickConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateQuickConnect for more information on using the CreateQuickConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateQuickConnectRequest method.
//	req, resp := client.CreateQuickConnectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect
func (c *Connect) CreateQuickConnectRequest(input *CreateQuickConnectInput) (req *request.Request, output *CreateQuickConnectOutput) {
	op := &request.Operation{
		Name:       opCreateQuickConnect,
		HTTPMethod: "PUT",
		HTTPPath:   "/quick-connects/{InstanceId}",
	}

	if input == nil {
		input = &CreateQuickConnectInput{}
	}

	output = &CreateQuickConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateQuickConnect API operation for Amazon Connect Service.
//
// Creates a quick connect for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateQuickConnect for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateQuickConnect
func (c *Connect) CreateQuickConnect(input *CreateQuickConnectInput) (*CreateQuickConnectOutput, error) {
	req, out := c.CreateQuickConnectRequest(input)
	return out, req.Send()
}

// CreateQuickConnectWithContext is the same as CreateQuickConnect with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQuickConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateQuickConnectWithContext(ctx aws.Context, input *CreateQuickConnectInput, opts ...request.Option) (*CreateQuickConnectOutput, error) {
	req, out := c.CreateQuickConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRoutingProfile = "CreateRoutingProfile"

// CreateRoutingProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateRoutingProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRoutingProfile for more information on using the CreateRoutingProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRoutingProfileRequest method.
//	req, resp := client.CreateRoutingProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile
func (c *Connect) CreateRoutingProfileRequest(input *CreateRoutingProfileInput) (req *request.Request, output *CreateRoutingProfileOutput) {
	op := &request.Operation{
		Name:       opCreateRoutingProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/routing-profiles/{InstanceId}",
	}

	if input == nil {
		input = &CreateRoutingProfileInput{}
	}

	output = &CreateRoutingProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRoutingProfile API operation for Amazon Connect Service.
//
// Creates a new routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateRoutingProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRoutingProfile
func (c *Connect) CreateRoutingProfile(input *CreateRoutingProfileInput) (*CreateRoutingProfileOutput, error) {
	req, out := c.CreateRoutingProfileRequest(input)
	return out, req.Send()
}

// CreateRoutingProfileWithContext is the same as CreateRoutingProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRoutingProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateRoutingProfileWithContext(ctx aws.Context, input *CreateRoutingProfileInput, opts ...request.Option) (*CreateRoutingProfileOutput, error) {
	req, out := c.CreateRoutingProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "aws/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateRuleRequest method.
//	req, resp := client.CreateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule
func (c *Connect) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/rules/{InstanceId}",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateRule API operation for Amazon Connect Service.
//
// Creates a rule for the specified Amazon Connect instance.
//
// Use the Rules Function language (https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html)
// to code conditions for the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateRule
func (c *Connect) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateRuleWithContext(ctx aws.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateSecurityProfile = "CreateSecurityProfile"

// CreateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateSecurityProfile for more information on using the CreateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateSecurityProfileRequest method.
//	req, resp := client.CreateSecurityProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile
func (c *Connect) CreateSecurityProfileRequest(input *CreateSecurityProfileInput) (req *request.Request, output *CreateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opCreateSecurityProfile,
		HTTPMethod: "PUT",
		HTTPPath:   "/security-profiles/{InstanceId}",
	}

	if input == nil {
		input = &CreateSecurityProfileInput{}
	}

	output = &CreateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateSecurityProfile API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Creates a security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateSecurityProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateSecurityProfile
func (c *Connect) CreateSecurityProfile(input *CreateSecurityProfileInput) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	return out, req.Send()
}

// CreateSecurityProfileWithContext is the same as CreateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateSecurityProfileWithContext(ctx aws.Context, input *CreateSecurityProfileInput, opts ...request.Option) (*CreateSecurityProfileOutput, error) {
	req, out := c.CreateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTaskTemplate = "CreateTaskTemplate"

// CreateTaskTemplateRequest generates a "aws/request.Request" representing the
// client's request for the CreateTaskTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTaskTemplate for more information on using the CreateTaskTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTaskTemplateRequest method.
//	req, resp := client.CreateTaskTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate
func (c *Connect) CreateTaskTemplateRequest(input *CreateTaskTemplateInput) (req *request.Request, output *CreateTaskTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateTaskTemplate,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/task/template",
	}

	if input == nil {
		input = &CreateTaskTemplateInput{}
	}

	output = &CreateTaskTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTaskTemplate API operation for Amazon Connect Service.
//
// Creates a new task template in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateTaskTemplate for usage and error information.
//
// Returned Error Types:
//
//   - PropertyValidationException
//     The property is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTaskTemplate
func (c *Connect) CreateTaskTemplate(input *CreateTaskTemplateInput) (*CreateTaskTemplateOutput, error) {
	req, out := c.CreateTaskTemplateRequest(input)
	return out, req.Send()
}

// CreateTaskTemplateWithContext is the same as CreateTaskTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTaskTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateTaskTemplateWithContext(ctx aws.Context, input *CreateTaskTemplateInput, opts ...request.Option) (*CreateTaskTemplateOutput, error) {
	req, out := c.CreateTaskTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTrafficDistributionGroup = "CreateTrafficDistributionGroup"

// CreateTrafficDistributionGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateTrafficDistributionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateTrafficDistributionGroup for more information on using the CreateTrafficDistributionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateTrafficDistributionGroupRequest method.
//	req, resp := client.CreateTrafficDistributionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup
func (c *Connect) CreateTrafficDistributionGroupRequest(input *CreateTrafficDistributionGroupInput) (req *request.Request, output *CreateTrafficDistributionGroupOutput) {
	op := &request.Operation{
		Name:       opCreateTrafficDistributionGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/traffic-distribution-group",
	}

	if input == nil {
		input = &CreateTrafficDistributionGroupInput{}
	}

	output = &CreateTrafficDistributionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateTrafficDistributionGroup API operation for Amazon Connect Service.
//
// Creates a traffic distribution group given an Amazon Connect instance that
// has been replicated.
//
// For more information about creating traffic distribution groups, see Set
// up traffic distribution groups (https://docs.aws.amazon.com/connect/latest/adminguide/setup-traffic-distribution-groups.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateTrafficDistributionGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - ResourceNotReadyException
//     The resource is not ready.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateTrafficDistributionGroup
func (c *Connect) CreateTrafficDistributionGroup(input *CreateTrafficDistributionGroupInput) (*CreateTrafficDistributionGroupOutput, error) {
	req, out := c.CreateTrafficDistributionGroupRequest(input)
	return out, req.Send()
}

// CreateTrafficDistributionGroupWithContext is the same as CreateTrafficDistributionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTrafficDistributionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateTrafficDistributionGroupWithContext(ctx aws.Context, input *CreateTrafficDistributionGroupInput, opts ...request.Option) (*CreateTrafficDistributionGroupOutput, error) {
	req, out := c.CreateTrafficDistributionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUseCase = "CreateUseCase"

// CreateUseCaseRequest generates a "aws/request.Request" representing the
// client's request for the CreateUseCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUseCase for more information on using the CreateUseCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUseCaseRequest method.
//	req, resp := client.CreateUseCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase
func (c *Connect) CreateUseCaseRequest(input *CreateUseCaseInput) (req *request.Request, output *CreateUseCaseOutput) {
	op := &request.Operation{
		Name:       opCreateUseCase,
		HTTPMethod: "PUT",
		HTTPPath:   "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases",
	}

	if input == nil {
		input = &CreateUseCaseInput{}
	}

	output = &CreateUseCaseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUseCase API operation for Amazon Connect Service.
//
// Creates a use case for an integration association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateUseCase for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUseCase
func (c *Connect) CreateUseCase(input *CreateUseCaseInput) (*CreateUseCaseOutput, error) {
	req, out := c.CreateUseCaseRequest(input)
	return out, req.Send()
}

// CreateUseCaseWithContext is the same as CreateUseCase with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUseCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateUseCaseWithContext(ctx aws.Context, input *CreateUseCaseInput, opts ...request.Option) (*CreateUseCaseOutput, error) {
	req, out := c.CreateUseCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "aws/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserRequest method.
//	req, resp := client.CreateUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "PUT",
		HTTPPath:   "/users/{InstanceId}",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUser API operation for Amazon Connect Service.
//
// Creates a user account for the specified Amazon Connect instance.
//
// For information about how to create user accounts using the Amazon Connect
// console, see Add Users (https://docs.aws.amazon.com/connect/latest/adminguide/user-management.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateUser for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUser
func (c *Connect) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateUserWithContext(ctx aws.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUserHierarchyGroup = "CreateUserHierarchyGroup"

// CreateUserHierarchyGroupRequest generates a "aws/request.Request" representing the
// client's request for the CreateUserHierarchyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateUserHierarchyGroup for more information on using the CreateUserHierarchyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateUserHierarchyGroupRequest method.
//	req, resp := client.CreateUserHierarchyGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup
func (c *Connect) CreateUserHierarchyGroupRequest(input *CreateUserHierarchyGroupInput) (req *request.Request, output *CreateUserHierarchyGroupOutput) {
	op := &request.Operation{
		Name:       opCreateUserHierarchyGroup,
		HTTPMethod: "PUT",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}",
	}

	if input == nil {
		input = &CreateUserHierarchyGroupInput{}
	}

	output = &CreateUserHierarchyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateUserHierarchyGroup API operation for Amazon Connect Service.
//
// Creates a new user hierarchy group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateUserHierarchyGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateUserHierarchyGroup
func (c *Connect) CreateUserHierarchyGroup(input *CreateUserHierarchyGroupInput) (*CreateUserHierarchyGroupOutput, error) {
	req, out := c.CreateUserHierarchyGroupRequest(input)
	return out, req.Send()
}

// CreateUserHierarchyGroupWithContext is the same as CreateUserHierarchyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserHierarchyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateUserHierarchyGroupWithContext(ctx aws.Context, input *CreateUserHierarchyGroupInput, opts ...request.Option) (*CreateUserHierarchyGroupOutput, error) {
	req, out := c.CreateUserHierarchyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateVocabulary = "CreateVocabulary"

// CreateVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the CreateVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateVocabulary for more information on using the CreateVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateVocabularyRequest method.
//	req, resp := client.CreateVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary
func (c *Connect) CreateVocabularyRequest(input *CreateVocabularyInput) (req *request.Request, output *CreateVocabularyOutput) {
	op := &request.Operation{
		Name:       opCreateVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/vocabulary/{InstanceId}",
	}

	if input == nil {
		input = &CreateVocabularyInput{}
	}

	output = &CreateVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateVocabulary API operation for Amazon Connect Service.
//
// Creates a custom vocabulary associated with your Amazon Connect instance.
// You can set a custom vocabulary to be your default vocabulary for a given
// language. Contact Lens for Amazon Connect uses the default vocabulary in
// post-call and real-time contact analysis sessions for that language.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation CreateVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/CreateVocabulary
func (c *Connect) CreateVocabulary(input *CreateVocabularyInput) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	return out, req.Send()
}

// CreateVocabularyWithContext is the same as CreateVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See CreateVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) CreateVocabularyWithContext(ctx aws.Context, input *CreateVocabularyInput, opts ...request.Option) (*CreateVocabularyOutput, error) {
	req, out := c.CreateVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeactivateEvaluationForm = "DeactivateEvaluationForm"

// DeactivateEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the DeactivateEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeactivateEvaluationForm for more information on using the DeactivateEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeactivateEvaluationFormRequest method.
//	req, resp := client.DeactivateEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm
func (c *Connect) DeactivateEvaluationFormRequest(input *DeactivateEvaluationFormInput) (req *request.Request, output *DeactivateEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opDeactivateEvaluationForm,
		HTTPMethod: "POST",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}/deactivate",
	}

	if input == nil {
		input = &DeactivateEvaluationFormInput{}
	}

	output = &DeactivateEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeactivateEvaluationForm API operation for Amazon Connect Service.
//
// Deactivates an evaluation form in the specified Amazon Connect instance.
// After a form is deactivated, it is no longer available for users to start
// new evaluations based on the form.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeactivateEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeactivateEvaluationForm
func (c *Connect) DeactivateEvaluationForm(input *DeactivateEvaluationFormInput) (*DeactivateEvaluationFormOutput, error) {
	req, out := c.DeactivateEvaluationFormRequest(input)
	return out, req.Send()
}

// DeactivateEvaluationFormWithContext is the same as DeactivateEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See DeactivateEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeactivateEvaluationFormWithContext(ctx aws.Context, input *DeactivateEvaluationFormInput, opts ...request.Option) (*DeactivateEvaluationFormOutput, error) {
	req, out := c.DeactivateEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactEvaluation = "DeleteContactEvaluation"

// DeleteContactEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactEvaluation for more information on using the DeleteContactEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactEvaluationRequest method.
//	req, resp := client.DeleteContactEvaluationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation
func (c *Connect) DeleteContactEvaluationRequest(input *DeleteContactEvaluationInput) (req *request.Request, output *DeleteContactEvaluationOutput) {
	op := &request.Operation{
		Name:       opDeleteContactEvaluation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/contact-evaluations/{InstanceId}/{EvaluationId}",
	}

	if input == nil {
		input = &DeleteContactEvaluationInput{}
	}

	output = &DeleteContactEvaluationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContactEvaluation API operation for Amazon Connect Service.
//
// Deletes a contact evaluation in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteContactEvaluation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactEvaluation
func (c *Connect) DeleteContactEvaluation(input *DeleteContactEvaluationInput) (*DeleteContactEvaluationOutput, error) {
	req, out := c.DeleteContactEvaluationRequest(input)
	return out, req.Send()
}

// DeleteContactEvaluationWithContext is the same as DeleteContactEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteContactEvaluationWithContext(ctx aws.Context, input *DeleteContactEvaluationInput, opts ...request.Option) (*DeleteContactEvaluationOutput, error) {
	req, out := c.DeleteContactEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactFlow = "DeleteContactFlow"

// DeleteContactFlowRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactFlow for more information on using the DeleteContactFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactFlowRequest method.
//	req, resp := client.DeleteContactFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow
func (c *Connect) DeleteContactFlowRequest(input *DeleteContactFlowInput) (req *request.Request, output *DeleteContactFlowOutput) {
	op := &request.Operation{
		Name:       opDeleteContactFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/contact-flows/{InstanceId}/{ContactFlowId}",
	}

	if input == nil {
		input = &DeleteContactFlowInput{}
	}

	output = &DeleteContactFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContactFlow API operation for Amazon Connect Service.
//
// Deletes a flow for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteContactFlow for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlow
func (c *Connect) DeleteContactFlow(input *DeleteContactFlowInput) (*DeleteContactFlowOutput, error) {
	req, out := c.DeleteContactFlowRequest(input)
	return out, req.Send()
}

// DeleteContactFlowWithContext is the same as DeleteContactFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteContactFlowWithContext(ctx aws.Context, input *DeleteContactFlowInput, opts ...request.Option) (*DeleteContactFlowOutput, error) {
	req, out := c.DeleteContactFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteContactFlowModule = "DeleteContactFlowModule"

// DeleteContactFlowModuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteContactFlowModule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteContactFlowModule for more information on using the DeleteContactFlowModule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteContactFlowModuleRequest method.
//	req, resp := client.DeleteContactFlowModuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule
func (c *Connect) DeleteContactFlowModuleRequest(input *DeleteContactFlowModuleInput) (req *request.Request, output *DeleteContactFlowModuleOutput) {
	op := &request.Operation{
		Name:       opDeleteContactFlowModule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
	}

	if input == nil {
		input = &DeleteContactFlowModuleInput{}
	}

	output = &DeleteContactFlowModuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteContactFlowModule API operation for Amazon Connect Service.
//
// Deletes the specified flow module.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteContactFlowModule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteContactFlowModule
func (c *Connect) DeleteContactFlowModule(input *DeleteContactFlowModuleInput) (*DeleteContactFlowModuleOutput, error) {
	req, out := c.DeleteContactFlowModuleRequest(input)
	return out, req.Send()
}

// DeleteContactFlowModuleWithContext is the same as DeleteContactFlowModule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteContactFlowModule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteContactFlowModuleWithContext(ctx aws.Context, input *DeleteContactFlowModuleInput, opts ...request.Option) (*DeleteContactFlowModuleOutput, error) {
	req, out := c.DeleteContactFlowModuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEvaluationForm = "DeleteEvaluationForm"

// DeleteEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEvaluationForm for more information on using the DeleteEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteEvaluationFormRequest method.
//	req, resp := client.DeleteEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm
func (c *Connect) DeleteEvaluationFormRequest(input *DeleteEvaluationFormInput) (req *request.Request, output *DeleteEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opDeleteEvaluationForm,
		HTTPMethod: "DELETE",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
	}

	if input == nil {
		input = &DeleteEvaluationFormInput{}
	}

	output = &DeleteEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEvaluationForm API operation for Amazon Connect Service.
//
// Deletes an evaluation form in the specified Amazon Connect instance.
//
//   - If the version property is provided, only the specified version of the
//     evaluation form is deleted.
//
//   - If no version is provided, then the full form (all versions) is deleted.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteEvaluationForm
func (c *Connect) DeleteEvaluationForm(input *DeleteEvaluationFormInput) (*DeleteEvaluationFormOutput, error) {
	req, out := c.DeleteEvaluationFormRequest(input)
	return out, req.Send()
}

// DeleteEvaluationFormWithContext is the same as DeleteEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteEvaluationFormWithContext(ctx aws.Context, input *DeleteEvaluationFormInput, opts ...request.Option) (*DeleteEvaluationFormOutput, error) {
	req, out := c.DeleteEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteHoursOfOperation = "DeleteHoursOfOperation"

// DeleteHoursOfOperationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteHoursOfOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteHoursOfOperation for more information on using the DeleteHoursOfOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteHoursOfOperationRequest method.
//	req, resp := client.DeleteHoursOfOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation
func (c *Connect) DeleteHoursOfOperationRequest(input *DeleteHoursOfOperationInput) (req *request.Request, output *DeleteHoursOfOperationOutput) {
	op := &request.Operation{
		Name:       opDeleteHoursOfOperation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
	}

	if input == nil {
		input = &DeleteHoursOfOperationInput{}
	}

	output = &DeleteHoursOfOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteHoursOfOperation API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Deletes an hours of operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteHoursOfOperation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteHoursOfOperation
func (c *Connect) DeleteHoursOfOperation(input *DeleteHoursOfOperationInput) (*DeleteHoursOfOperationOutput, error) {
	req, out := c.DeleteHoursOfOperationRequest(input)
	return out, req.Send()
}

// DeleteHoursOfOperationWithContext is the same as DeleteHoursOfOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteHoursOfOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteHoursOfOperationWithContext(ctx aws.Context, input *DeleteHoursOfOperationInput, opts ...request.Option) (*DeleteHoursOfOperationOutput, error) {
	req, out := c.DeleteHoursOfOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteInstance = "DeleteInstance"

// DeleteInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DeleteInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteInstance for more information on using the DeleteInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteInstanceRequest method.
//	req, resp := client.DeleteInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance
func (c *Connect) DeleteInstanceRequest(input *DeleteInstanceInput) (req *request.Request, output *DeleteInstanceOutput) {
	op := &request.Operation{
		Name:       opDeleteInstance,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}",
	}

	if input == nil {
		input = &DeleteInstanceInput{}
	}

	output = &DeleteInstanceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteInstance API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Deletes the Amazon Connect instance.
//
// Amazon Connect enforces a limit on the total number of instances that you
// can create or delete in 30 days. If you exceed this limit, you will get an
// error message indicating there has been an excessive number of attempts at
// creating or deleting instances. You must wait 30 days before you can restart
// creating and deleting instances in your account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteInstance for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteInstance
func (c *Connect) DeleteInstance(input *DeleteInstanceInput) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	return out, req.Send()
}

// DeleteInstanceWithContext is the same as DeleteInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteInstanceWithContext(ctx aws.Context, input *DeleteInstanceInput, opts ...request.Option) (*DeleteInstanceOutput, error) {
	req, out := c.DeleteInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteIntegrationAssociation = "DeleteIntegrationAssociation"

// DeleteIntegrationAssociationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteIntegrationAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteIntegrationAssociation for more information on using the DeleteIntegrationAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteIntegrationAssociationRequest method.
//	req, resp := client.DeleteIntegrationAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation
func (c *Connect) DeleteIntegrationAssociationRequest(input *DeleteIntegrationAssociationInput) (req *request.Request, output *DeleteIntegrationAssociationOutput) {
	op := &request.Operation{
		Name:       opDeleteIntegrationAssociation,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}",
	}

	if input == nil {
		input = &DeleteIntegrationAssociationInput{}
	}

	output = &DeleteIntegrationAssociationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteIntegrationAssociation API operation for Amazon Connect Service.
//
// Deletes an Amazon Web Services resource association from an Amazon Connect
// instance. The association must not have any use cases associated with it.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteIntegrationAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteIntegrationAssociation
func (c *Connect) DeleteIntegrationAssociation(input *DeleteIntegrationAssociationInput) (*DeleteIntegrationAssociationOutput, error) {
	req, out := c.DeleteIntegrationAssociationRequest(input)
	return out, req.Send()
}

// DeleteIntegrationAssociationWithContext is the same as DeleteIntegrationAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteIntegrationAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteIntegrationAssociationWithContext(ctx aws.Context, input *DeleteIntegrationAssociationInput, opts ...request.Option) (*DeleteIntegrationAssociationOutput, error) {
	req, out := c.DeleteIntegrationAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteQuickConnect = "DeleteQuickConnect"

// DeleteQuickConnectRequest generates a "aws/request.Request" representing the
// client's request for the DeleteQuickConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteQuickConnect for more information on using the DeleteQuickConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteQuickConnectRequest method.
//	req, resp := client.DeleteQuickConnectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect
func (c *Connect) DeleteQuickConnectRequest(input *DeleteQuickConnectInput) (req *request.Request, output *DeleteQuickConnectOutput) {
	op := &request.Operation{
		Name:       opDeleteQuickConnect,
		HTTPMethod: "DELETE",
		HTTPPath:   "/quick-connects/{InstanceId}/{QuickConnectId}",
	}

	if input == nil {
		input = &DeleteQuickConnectInput{}
	}

	output = &DeleteQuickConnectOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteQuickConnect API operation for Amazon Connect Service.
//
// Deletes a quick connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteQuickConnect for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteQuickConnect
func (c *Connect) DeleteQuickConnect(input *DeleteQuickConnectInput) (*DeleteQuickConnectOutput, error) {
	req, out := c.DeleteQuickConnectRequest(input)
	return out, req.Send()
}

// DeleteQuickConnectWithContext is the same as DeleteQuickConnect with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteQuickConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteQuickConnectWithContext(ctx aws.Context, input *DeleteQuickConnectInput, opts ...request.Option) (*DeleteQuickConnectOutput, error) {
	req, out := c.DeleteQuickConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteRule = "DeleteRule"

// DeleteRuleRequest generates a "aws/request.Request" representing the
// client's request for the DeleteRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteRule for more information on using the DeleteRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteRuleRequest method.
//	req, resp := client.DeleteRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule
func (c *Connect) DeleteRuleRequest(input *DeleteRuleInput) (req *request.Request, output *DeleteRuleOutput) {
	op := &request.Operation{
		Name:       opDeleteRule,
		HTTPMethod: "DELETE",
		HTTPPath:   "/rules/{InstanceId}/{RuleId}",
	}

	if input == nil {
		input = &DeleteRuleInput{}
	}

	output = &DeleteRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteRule API operation for Amazon Connect Service.
//
// Deletes a rule for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteRule
func (c *Connect) DeleteRule(input *DeleteRuleInput) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	return out, req.Send()
}

// DeleteRuleWithContext is the same as DeleteRule with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteRuleWithContext(ctx aws.Context, input *DeleteRuleInput, opts ...request.Option) (*DeleteRuleOutput, error) {
	req, out := c.DeleteRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteSecurityProfile = "DeleteSecurityProfile"

// DeleteSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteSecurityProfile for more information on using the DeleteSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteSecurityProfileRequest method.
//	req, resp := client.DeleteSecurityProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile
func (c *Connect) DeleteSecurityProfileRequest(input *DeleteSecurityProfileInput) (req *request.Request, output *DeleteSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteSecurityProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/security-profiles/{InstanceId}/{SecurityProfileId}",
	}

	if input == nil {
		input = &DeleteSecurityProfileInput{}
	}

	output = &DeleteSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteSecurityProfile API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Deletes a security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteSecurityProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteSecurityProfile
func (c *Connect) DeleteSecurityProfile(input *DeleteSecurityProfileInput) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	return out, req.Send()
}

// DeleteSecurityProfileWithContext is the same as DeleteSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteSecurityProfileWithContext(ctx aws.Context, input *DeleteSecurityProfileInput, opts ...request.Option) (*DeleteSecurityProfileOutput, error) {
	req, out := c.DeleteSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTaskTemplate = "DeleteTaskTemplate"

// DeleteTaskTemplateRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTaskTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTaskTemplate for more information on using the DeleteTaskTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTaskTemplateRequest method.
//	req, resp := client.DeleteTaskTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate
func (c *Connect) DeleteTaskTemplateRequest(input *DeleteTaskTemplateInput) (req *request.Request, output *DeleteTaskTemplateOutput) {
	op := &request.Operation{
		Name:       opDeleteTaskTemplate,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/task/template/{TaskTemplateId}",
	}

	if input == nil {
		input = &DeleteTaskTemplateInput{}
	}

	output = &DeleteTaskTemplateOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTaskTemplate API operation for Amazon Connect Service.
//
// Deletes the task template.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteTaskTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTaskTemplate
func (c *Connect) DeleteTaskTemplate(input *DeleteTaskTemplateInput) (*DeleteTaskTemplateOutput, error) {
	req, out := c.DeleteTaskTemplateRequest(input)
	return out, req.Send()
}

// DeleteTaskTemplateWithContext is the same as DeleteTaskTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTaskTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteTaskTemplateWithContext(ctx aws.Context, input *DeleteTaskTemplateInput, opts ...request.Option) (*DeleteTaskTemplateOutput, error) {
	req, out := c.DeleteTaskTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteTrafficDistributionGroup = "DeleteTrafficDistributionGroup"

// DeleteTrafficDistributionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteTrafficDistributionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteTrafficDistributionGroup for more information on using the DeleteTrafficDistributionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteTrafficDistributionGroupRequest method.
//	req, resp := client.DeleteTrafficDistributionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup
func (c *Connect) DeleteTrafficDistributionGroupRequest(input *DeleteTrafficDistributionGroupInput) (req *request.Request, output *DeleteTrafficDistributionGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteTrafficDistributionGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/traffic-distribution-group/{TrafficDistributionGroupId}",
	}

	if input == nil {
		input = &DeleteTrafficDistributionGroupInput{}
	}

	output = &DeleteTrafficDistributionGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteTrafficDistributionGroup API operation for Amazon Connect Service.
//
// Deletes a traffic distribution group. This API can be called only in the
// Region where the traffic distribution group is created.
//
// For more information about deleting traffic distribution groups, see Delete
// traffic distribution groups (https://docs.aws.amazon.com/connect/latest/adminguide/delete-traffic-distribution-groups.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteTrafficDistributionGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteTrafficDistributionGroup
func (c *Connect) DeleteTrafficDistributionGroup(input *DeleteTrafficDistributionGroupInput) (*DeleteTrafficDistributionGroupOutput, error) {
	req, out := c.DeleteTrafficDistributionGroupRequest(input)
	return out, req.Send()
}

// DeleteTrafficDistributionGroupWithContext is the same as DeleteTrafficDistributionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteTrafficDistributionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteTrafficDistributionGroupWithContext(ctx aws.Context, input *DeleteTrafficDistributionGroupInput, opts ...request.Option) (*DeleteTrafficDistributionGroupOutput, error) {
	req, out := c.DeleteTrafficDistributionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUseCase = "DeleteUseCase"

// DeleteUseCaseRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUseCase operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUseCase for more information on using the DeleteUseCase
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUseCaseRequest method.
//	req, resp := client.DeleteUseCaseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase
func (c *Connect) DeleteUseCaseRequest(input *DeleteUseCaseInput) (req *request.Request, output *DeleteUseCaseOutput) {
	op := &request.Operation{
		Name:       opDeleteUseCase,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases/{UseCaseId}",
	}

	if input == nil {
		input = &DeleteUseCaseInput{}
	}

	output = &DeleteUseCaseOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUseCase API operation for Amazon Connect Service.
//
// Deletes a use case from an integration association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteUseCase for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUseCase
func (c *Connect) DeleteUseCase(input *DeleteUseCaseInput) (*DeleteUseCaseOutput, error) {
	req, out := c.DeleteUseCaseRequest(input)
	return out, req.Send()
}

// DeleteUseCaseWithContext is the same as DeleteUseCase with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUseCase for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteUseCaseWithContext(ctx aws.Context, input *DeleteUseCaseInput, opts ...request.Option) (*DeleteUseCaseOutput, error) {
	req, out := c.DeleteUseCaseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUser = "DeleteUser"

// DeleteUserRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUser for more information on using the DeleteUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserRequest method.
//	req, resp := client.DeleteUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUserRequest(input *DeleteUserInput) (req *request.Request, output *DeleteUserOutput) {
	op := &request.Operation{
		Name:       opDeleteUser,
		HTTPMethod: "DELETE",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DeleteUserInput{}
	}

	output = &DeleteUserOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUser API operation for Amazon Connect Service.
//
// Deletes a user account from the specified Amazon Connect instance.
//
// For information about what happens to a user's data when their account is
// deleted, see Delete Users from Your Amazon Connect Instance (https://docs.aws.amazon.com/connect/latest/adminguide/delete-users.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteUser for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUser
func (c *Connect) DeleteUser(input *DeleteUserInput) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	return out, req.Send()
}

// DeleteUserWithContext is the same as DeleteUser with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteUserWithContext(ctx aws.Context, input *DeleteUserInput, opts ...request.Option) (*DeleteUserOutput, error) {
	req, out := c.DeleteUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteUserHierarchyGroup = "DeleteUserHierarchyGroup"

// DeleteUserHierarchyGroupRequest generates a "aws/request.Request" representing the
// client's request for the DeleteUserHierarchyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteUserHierarchyGroup for more information on using the DeleteUserHierarchyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteUserHierarchyGroupRequest method.
//	req, resp := client.DeleteUserHierarchyGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup
func (c *Connect) DeleteUserHierarchyGroupRequest(input *DeleteUserHierarchyGroupInput) (req *request.Request, output *DeleteUserHierarchyGroupOutput) {
	op := &request.Operation{
		Name:       opDeleteUserHierarchyGroup,
		HTTPMethod: "DELETE",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
	}

	if input == nil {
		input = &DeleteUserHierarchyGroupInput{}
	}

	output = &DeleteUserHierarchyGroupOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteUserHierarchyGroup API operation for Amazon Connect Service.
//
// Deletes an existing user hierarchy group. It must not be associated with
// any agents or have any active child groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteUserHierarchyGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteUserHierarchyGroup
func (c *Connect) DeleteUserHierarchyGroup(input *DeleteUserHierarchyGroupInput) (*DeleteUserHierarchyGroupOutput, error) {
	req, out := c.DeleteUserHierarchyGroupRequest(input)
	return out, req.Send()
}

// DeleteUserHierarchyGroupWithContext is the same as DeleteUserHierarchyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteUserHierarchyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteUserHierarchyGroupWithContext(ctx aws.Context, input *DeleteUserHierarchyGroupInput, opts ...request.Option) (*DeleteUserHierarchyGroupOutput, error) {
	req, out := c.DeleteUserHierarchyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteVocabulary = "DeleteVocabulary"

// DeleteVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DeleteVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteVocabulary for more information on using the DeleteVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteVocabularyRequest method.
//	req, resp := client.DeleteVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary
func (c *Connect) DeleteVocabularyRequest(input *DeleteVocabularyInput) (req *request.Request, output *DeleteVocabularyOutput) {
	op := &request.Operation{
		Name:       opDeleteVocabulary,
		HTTPMethod: "POST",
		HTTPPath:   "/vocabulary-remove/{InstanceId}/{VocabularyId}",
	}

	if input == nil {
		input = &DeleteVocabularyInput{}
	}

	output = &DeleteVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteVocabulary API operation for Amazon Connect Service.
//
// Deletes the vocabulary that has the given identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DeleteVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DeleteVocabulary
func (c *Connect) DeleteVocabulary(input *DeleteVocabularyInput) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	return out, req.Send()
}

// DeleteVocabularyWithContext is the same as DeleteVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DeleteVocabularyWithContext(ctx aws.Context, input *DeleteVocabularyInput, opts ...request.Option) (*DeleteVocabularyOutput, error) {
	req, out := c.DeleteVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAgentStatus = "DescribeAgentStatus"

// DescribeAgentStatusRequest generates a "aws/request.Request" representing the
// client's request for the DescribeAgentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeAgentStatus for more information on using the DescribeAgentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeAgentStatusRequest method.
//	req, resp := client.DescribeAgentStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus
func (c *Connect) DescribeAgentStatusRequest(input *DescribeAgentStatusInput) (req *request.Request, output *DescribeAgentStatusOutput) {
	op := &request.Operation{
		Name:       opDescribeAgentStatus,
		HTTPMethod: "GET",
		HTTPPath:   "/agent-status/{InstanceId}/{AgentStatusId}",
	}

	if input == nil {
		input = &DescribeAgentStatusInput{}
	}

	output = &DescribeAgentStatusOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeAgentStatus API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Describes an agent status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeAgentStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeAgentStatus
func (c *Connect) DescribeAgentStatus(input *DescribeAgentStatusInput) (*DescribeAgentStatusOutput, error) {
	req, out := c.DescribeAgentStatusRequest(input)
	return out, req.Send()
}

// DescribeAgentStatusWithContext is the same as DescribeAgentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAgentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeAgentStatusWithContext(ctx aws.Context, input *DescribeAgentStatusInput, opts ...request.Option) (*DescribeAgentStatusOutput, error) {
	req, out := c.DescribeAgentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContact = "DescribeContact"

// DescribeContactRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContact for more information on using the DescribeContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeContactRequest method.
//	req, resp := client.DescribeContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact
func (c *Connect) DescribeContactRequest(input *DescribeContactInput) (req *request.Request, output *DescribeContactOutput) {
	op := &request.Operation{
		Name:       opDescribeContact,
		HTTPMethod: "GET",
		HTTPPath:   "/contacts/{InstanceId}/{ContactId}",
	}

	if input == nil {
		input = &DescribeContactInput{}
	}

	output = &DescribeContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContact API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Describes the specified contact.
//
// Contact information remains available in Amazon Connect for 24 months, and
// then it is deleted.
//
// Only data from November 12, 2021, and later is returned by this API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContact
func (c *Connect) DescribeContact(input *DescribeContactInput) (*DescribeContactOutput, error) {
	req, out := c.DescribeContactRequest(input)
	return out, req.Send()
}

// DescribeContactWithContext is the same as DescribeContact with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeContactWithContext(ctx aws.Context, input *DescribeContactInput, opts ...request.Option) (*DescribeContactOutput, error) {
	req, out := c.DescribeContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContactEvaluation = "DescribeContactEvaluation"

// DescribeContactEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContactEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContactEvaluation for more information on using the DescribeContactEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeContactEvaluationRequest method.
//	req, resp := client.DescribeContactEvaluationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation
func (c *Connect) DescribeContactEvaluationRequest(input *DescribeContactEvaluationInput) (req *request.Request, output *DescribeContactEvaluationOutput) {
	op := &request.Operation{
		Name:       opDescribeContactEvaluation,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-evaluations/{InstanceId}/{EvaluationId}",
	}

	if input == nil {
		input = &DescribeContactEvaluationInput{}
	}

	output = &DescribeContactEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContactEvaluation API operation for Amazon Connect Service.
//
// Describes a contact evaluation in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeContactEvaluation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactEvaluation
func (c *Connect) DescribeContactEvaluation(input *DescribeContactEvaluationInput) (*DescribeContactEvaluationOutput, error) {
	req, out := c.DescribeContactEvaluationRequest(input)
	return out, req.Send()
}

// DescribeContactEvaluationWithContext is the same as DescribeContactEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContactEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeContactEvaluationWithContext(ctx aws.Context, input *DescribeContactEvaluationInput, opts ...request.Option) (*DescribeContactEvaluationOutput, error) {
	req, out := c.DescribeContactEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContactFlow = "DescribeContactFlow"

// DescribeContactFlowRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContactFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContactFlow for more information on using the DescribeContactFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeContactFlowRequest method.
//	req, resp := client.DescribeContactFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow
func (c *Connect) DescribeContactFlowRequest(input *DescribeContactFlowInput) (req *request.Request, output *DescribeContactFlowOutput) {
	op := &request.Operation{
		Name:       opDescribeContactFlow,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-flows/{InstanceId}/{ContactFlowId}",
	}

	if input == nil {
		input = &DescribeContactFlowInput{}
	}

	output = &DescribeContactFlowOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContactFlow API operation for Amazon Connect Service.
//
// Describes the specified flow.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeContactFlow for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ContactFlowNotPublishedException
//     The flow has not been published.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlow
func (c *Connect) DescribeContactFlow(input *DescribeContactFlowInput) (*DescribeContactFlowOutput, error) {
	req, out := c.DescribeContactFlowRequest(input)
	return out, req.Send()
}

// DescribeContactFlowWithContext is the same as DescribeContactFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContactFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeContactFlowWithContext(ctx aws.Context, input *DescribeContactFlowInput, opts ...request.Option) (*DescribeContactFlowOutput, error) {
	req, out := c.DescribeContactFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeContactFlowModule = "DescribeContactFlowModule"

// DescribeContactFlowModuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeContactFlowModule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeContactFlowModule for more information on using the DescribeContactFlowModule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeContactFlowModuleRequest method.
//	req, resp := client.DescribeContactFlowModuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule
func (c *Connect) DescribeContactFlowModuleRequest(input *DescribeContactFlowModuleInput) (req *request.Request, output *DescribeContactFlowModuleOutput) {
	op := &request.Operation{
		Name:       opDescribeContactFlowModule,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}",
	}

	if input == nil {
		input = &DescribeContactFlowModuleInput{}
	}

	output = &DescribeContactFlowModuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeContactFlowModule API operation for Amazon Connect Service.
//
// Describes the specified flow module.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeContactFlowModule for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeContactFlowModule
func (c *Connect) DescribeContactFlowModule(input *DescribeContactFlowModuleInput) (*DescribeContactFlowModuleOutput, error) {
	req, out := c.DescribeContactFlowModuleRequest(input)
	return out, req.Send()
}

// DescribeContactFlowModuleWithContext is the same as DescribeContactFlowModule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeContactFlowModule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeContactFlowModuleWithContext(ctx aws.Context, input *DescribeContactFlowModuleInput, opts ...request.Option) (*DescribeContactFlowModuleOutput, error) {
	req, out := c.DescribeContactFlowModuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeEvaluationForm = "DescribeEvaluationForm"

// DescribeEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the DescribeEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeEvaluationForm for more information on using the DescribeEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeEvaluationFormRequest method.
//	req, resp := client.DescribeEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm
func (c *Connect) DescribeEvaluationFormRequest(input *DescribeEvaluationFormInput) (req *request.Request, output *DescribeEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opDescribeEvaluationForm,
		HTTPMethod: "GET",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
	}

	if input == nil {
		input = &DescribeEvaluationFormInput{}
	}

	output = &DescribeEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeEvaluationForm API operation for Amazon Connect Service.
//
// Describes an evaluation form in the specified Amazon Connect instance. If
// the version property is not provided, the latest version of the evaluation
// form is described.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeEvaluationForm
func (c *Connect) DescribeEvaluationForm(input *DescribeEvaluationFormInput) (*DescribeEvaluationFormOutput, error) {
	req, out := c.DescribeEvaluationFormRequest(input)
	return out, req.Send()
}

// DescribeEvaluationFormWithContext is the same as DescribeEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeEvaluationFormWithContext(ctx aws.Context, input *DescribeEvaluationFormInput, opts ...request.Option) (*DescribeEvaluationFormOutput, error) {
	req, out := c.DescribeEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeHoursOfOperation = "DescribeHoursOfOperation"

// DescribeHoursOfOperationRequest generates a "aws/request.Request" representing the
// client's request for the DescribeHoursOfOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeHoursOfOperation for more information on using the DescribeHoursOfOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeHoursOfOperationRequest method.
//	req, resp := client.DescribeHoursOfOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation
func (c *Connect) DescribeHoursOfOperationRequest(input *DescribeHoursOfOperationInput) (req *request.Request, output *DescribeHoursOfOperationOutput) {
	op := &request.Operation{
		Name:       opDescribeHoursOfOperation,
		HTTPMethod: "GET",
		HTTPPath:   "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
	}

	if input == nil {
		input = &DescribeHoursOfOperationInput{}
	}

	output = &DescribeHoursOfOperationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeHoursOfOperation API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Describes the hours of operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeHoursOfOperation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeHoursOfOperation
func (c *Connect) DescribeHoursOfOperation(input *DescribeHoursOfOperationInput) (*DescribeHoursOfOperationOutput, error) {
	req, out := c.DescribeHoursOfOperationRequest(input)
	return out, req.Send()
}

// DescribeHoursOfOperationWithContext is the same as DescribeHoursOfOperation with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeHoursOfOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeHoursOfOperationWithContext(ctx aws.Context, input *DescribeHoursOfOperationInput, opts ...request.Option) (*DescribeHoursOfOperationOutput, error) {
	req, out := c.DescribeHoursOfOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstance = "DescribeInstance"

// DescribeInstanceRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstance for more information on using the DescribeInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceRequest method.
//	req, resp := client.DescribeInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance
func (c *Connect) DescribeInstanceRequest(input *DescribeInstanceInput) (req *request.Request, output *DescribeInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeInstance,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}",
	}

	if input == nil {
		input = &DescribeInstanceInput{}
	}

	output = &DescribeInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstance API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns the current state of the specified instance identifier. It tracks
// the instance while it is being created and returns an error status, if applicable.
//
// If an instance is not created successfully, the instance status reason field
// returns details relevant to the reason. The instance in a failed state is
// returned only for 24 hours after the CreateInstance API was invoked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstance
func (c *Connect) DescribeInstance(input *DescribeInstanceInput) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	return out, req.Send()
}

// DescribeInstanceWithContext is the same as DescribeInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeInstanceWithContext(ctx aws.Context, input *DescribeInstanceInput, opts ...request.Option) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceAttribute = "DescribeInstanceAttribute"

// DescribeInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceAttribute for more information on using the DescribeInstanceAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceAttributeRequest method.
//	req, resp := client.DescribeInstanceAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute
func (c *Connect) DescribeInstanceAttributeRequest(input *DescribeInstanceAttributeInput) (req *request.Request, output *DescribeInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceAttribute,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/attribute/{AttributeType}",
	}

	if input == nil {
		input = &DescribeInstanceAttributeInput{}
	}

	output = &DescribeInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceAttribute API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Describes the specified instance attribute.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeInstanceAttribute for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceAttribute
func (c *Connect) DescribeInstanceAttribute(input *DescribeInstanceAttributeInput) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	return out, req.Send()
}

// DescribeInstanceAttributeWithContext is the same as DescribeInstanceAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeInstanceAttributeWithContext(ctx aws.Context, input *DescribeInstanceAttributeInput, opts ...request.Option) (*DescribeInstanceAttributeOutput, error) {
	req, out := c.DescribeInstanceAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstanceStorageConfig = "DescribeInstanceStorageConfig"

// DescribeInstanceStorageConfigRequest generates a "aws/request.Request" representing the
// client's request for the DescribeInstanceStorageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeInstanceStorageConfig for more information on using the DescribeInstanceStorageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeInstanceStorageConfigRequest method.
//	req, resp := client.DescribeInstanceStorageConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig
func (c *Connect) DescribeInstanceStorageConfigRequest(input *DescribeInstanceStorageConfigInput) (req *request.Request, output *DescribeInstanceStorageConfigOutput) {
	op := &request.Operation{
		Name:       opDescribeInstanceStorageConfig,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/storage-config/{AssociationId}",
	}

	if input == nil {
		input = &DescribeInstanceStorageConfigInput{}
	}

	output = &DescribeInstanceStorageConfigOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeInstanceStorageConfig API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Retrieves the current storage configurations for the specified resource type,
// association ID, and instance ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeInstanceStorageConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeInstanceStorageConfig
func (c *Connect) DescribeInstanceStorageConfig(input *DescribeInstanceStorageConfigInput) (*DescribeInstanceStorageConfigOutput, error) {
	req, out := c.DescribeInstanceStorageConfigRequest(input)
	return out, req.Send()
}

// DescribeInstanceStorageConfigWithContext is the same as DescribeInstanceStorageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceStorageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeInstanceStorageConfigWithContext(ctx aws.Context, input *DescribeInstanceStorageConfigInput, opts ...request.Option) (*DescribeInstanceStorageConfigOutput, error) {
	req, out := c.DescribeInstanceStorageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribePhoneNumber = "DescribePhoneNumber"

// DescribePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the DescribePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribePhoneNumber for more information on using the DescribePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribePhoneNumberRequest method.
//	req, resp := client.DescribePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber
func (c *Connect) DescribePhoneNumberRequest(input *DescribePhoneNumberInput) (req *request.Request, output *DescribePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opDescribePhoneNumber,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-number/{PhoneNumberId}",
	}

	if input == nil {
		input = &DescribePhoneNumberInput{}
	}

	output = &DescribePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribePhoneNumber API operation for Amazon Connect Service.
//
// Gets details and status of a phone number that’s claimed to your Amazon
// Connect instance or traffic distribution group.
//
// If the number is claimed to a traffic distribution group, and you are calling
// in the Amazon Web Services Region where the traffic distribution group was
// created, you can use either a phone number ARN or UUID value for the PhoneNumberId
// URI request parameter. However, if the number is claimed to a traffic distribution
// group and you are calling this API in the alternate Amazon Web Services Region
// associated with the traffic distribution group, you must provide a full phone
// number ARN. If a UUID is provided in this scenario, you will receive a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribePhoneNumber
func (c *Connect) DescribePhoneNumber(input *DescribePhoneNumberInput) (*DescribePhoneNumberOutput, error) {
	req, out := c.DescribePhoneNumberRequest(input)
	return out, req.Send()
}

// DescribePhoneNumberWithContext is the same as DescribePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See DescribePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribePhoneNumberWithContext(ctx aws.Context, input *DescribePhoneNumberInput, opts ...request.Option) (*DescribePhoneNumberOutput, error) {
	req, out := c.DescribePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeQueue = "DescribeQueue"

// DescribeQueueRequest generates a "aws/request.Request" representing the
// client's request for the DescribeQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeQueue for more information on using the DescribeQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeQueueRequest method.
//	req, resp := client.DescribeQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue
func (c *Connect) DescribeQueueRequest(input *DescribeQueueInput) (req *request.Request, output *DescribeQueueOutput) {
	op := &request.Operation{
		Name:       opDescribeQueue,
		HTTPMethod: "GET",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}",
	}

	if input == nil {
		input = &DescribeQueueInput{}
	}

	output = &DescribeQueueOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeQueue API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Describes the specified queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeQueue for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQueue
func (c *Connect) DescribeQueue(input *DescribeQueueInput) (*DescribeQueueOutput, error) {
	req, out := c.DescribeQueueRequest(input)
	return out, req.Send()
}

// DescribeQueueWithContext is the same as DescribeQueue with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeQueueWithContext(ctx aws.Context, input *DescribeQueueInput, opts ...request.Option) (*DescribeQueueOutput, error) {
	req, out := c.DescribeQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeQuickConnect = "DescribeQuickConnect"

// DescribeQuickConnectRequest generates a "aws/request.Request" representing the
// client's request for the DescribeQuickConnect operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeQuickConnect for more information on using the DescribeQuickConnect
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeQuickConnectRequest method.
//	req, resp := client.DescribeQuickConnectRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect
func (c *Connect) DescribeQuickConnectRequest(input *DescribeQuickConnectInput) (req *request.Request, output *DescribeQuickConnectOutput) {
	op := &request.Operation{
		Name:       opDescribeQuickConnect,
		HTTPMethod: "GET",
		HTTPPath:   "/quick-connects/{InstanceId}/{QuickConnectId}",
	}

	if input == nil {
		input = &DescribeQuickConnectInput{}
	}

	output = &DescribeQuickConnectOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeQuickConnect API operation for Amazon Connect Service.
//
// Describes the quick connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeQuickConnect for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeQuickConnect
func (c *Connect) DescribeQuickConnect(input *DescribeQuickConnectInput) (*DescribeQuickConnectOutput, error) {
	req, out := c.DescribeQuickConnectRequest(input)
	return out, req.Send()
}

// DescribeQuickConnectWithContext is the same as DescribeQuickConnect with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeQuickConnect for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeQuickConnectWithContext(ctx aws.Context, input *DescribeQuickConnectInput, opts ...request.Option) (*DescribeQuickConnectOutput, error) {
	req, out := c.DescribeQuickConnectRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRoutingProfile = "DescribeRoutingProfile"

// DescribeRoutingProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRoutingProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRoutingProfile for more information on using the DescribeRoutingProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRoutingProfileRequest method.
//	req, resp := client.DescribeRoutingProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile
func (c *Connect) DescribeRoutingProfileRequest(input *DescribeRoutingProfileInput) (req *request.Request, output *DescribeRoutingProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeRoutingProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}",
	}

	if input == nil {
		input = &DescribeRoutingProfileInput{}
	}

	output = &DescribeRoutingProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRoutingProfile API operation for Amazon Connect Service.
//
// Describes the specified routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeRoutingProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRoutingProfile
func (c *Connect) DescribeRoutingProfile(input *DescribeRoutingProfileInput) (*DescribeRoutingProfileOutput, error) {
	req, out := c.DescribeRoutingProfileRequest(input)
	return out, req.Send()
}

// DescribeRoutingProfileWithContext is the same as DescribeRoutingProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRoutingProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeRoutingProfileWithContext(ctx aws.Context, input *DescribeRoutingProfileInput, opts ...request.Option) (*DescribeRoutingProfileOutput, error) {
	req, out := c.DescribeRoutingProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeRule = "DescribeRule"

// DescribeRuleRequest generates a "aws/request.Request" representing the
// client's request for the DescribeRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeRule for more information on using the DescribeRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeRuleRequest method.
//	req, resp := client.DescribeRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule
func (c *Connect) DescribeRuleRequest(input *DescribeRuleInput) (req *request.Request, output *DescribeRuleOutput) {
	op := &request.Operation{
		Name:       opDescribeRule,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{InstanceId}/{RuleId}",
	}

	if input == nil {
		input = &DescribeRuleInput{}
	}

	output = &DescribeRuleOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeRule API operation for Amazon Connect Service.
//
// Describes a rule for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeRule
func (c *Connect) DescribeRule(input *DescribeRuleInput) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	return out, req.Send()
}

// DescribeRuleWithContext is the same as DescribeRule with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeRuleWithContext(ctx aws.Context, input *DescribeRuleInput, opts ...request.Option) (*DescribeRuleOutput, error) {
	req, out := c.DescribeRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecurityProfile = "DescribeSecurityProfile"

// DescribeSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the DescribeSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeSecurityProfile for more information on using the DescribeSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeSecurityProfileRequest method.
//	req, resp := client.DescribeSecurityProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile
func (c *Connect) DescribeSecurityProfileRequest(input *DescribeSecurityProfileInput) (req *request.Request, output *DescribeSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opDescribeSecurityProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles/{InstanceId}/{SecurityProfileId}",
	}

	if input == nil {
		input = &DescribeSecurityProfileInput{}
	}

	output = &DescribeSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeSecurityProfile API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Gets basic information about the security profle.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeSecurityProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeSecurityProfile
func (c *Connect) DescribeSecurityProfile(input *DescribeSecurityProfileInput) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	return out, req.Send()
}

// DescribeSecurityProfileWithContext is the same as DescribeSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeSecurityProfileWithContext(ctx aws.Context, input *DescribeSecurityProfileInput, opts ...request.Option) (*DescribeSecurityProfileOutput, error) {
	req, out := c.DescribeSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTrafficDistributionGroup = "DescribeTrafficDistributionGroup"

// DescribeTrafficDistributionGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeTrafficDistributionGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeTrafficDistributionGroup for more information on using the DescribeTrafficDistributionGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeTrafficDistributionGroupRequest method.
//	req, resp := client.DescribeTrafficDistributionGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup
func (c *Connect) DescribeTrafficDistributionGroupRequest(input *DescribeTrafficDistributionGroupInput) (req *request.Request, output *DescribeTrafficDistributionGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeTrafficDistributionGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/traffic-distribution-group/{TrafficDistributionGroupId}",
	}

	if input == nil {
		input = &DescribeTrafficDistributionGroupInput{}
	}

	output = &DescribeTrafficDistributionGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeTrafficDistributionGroup API operation for Amazon Connect Service.
//
// Gets details and status of a traffic distribution group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeTrafficDistributionGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeTrafficDistributionGroup
func (c *Connect) DescribeTrafficDistributionGroup(input *DescribeTrafficDistributionGroupInput) (*DescribeTrafficDistributionGroupOutput, error) {
	req, out := c.DescribeTrafficDistributionGroupRequest(input)
	return out, req.Send()
}

// DescribeTrafficDistributionGroupWithContext is the same as DescribeTrafficDistributionGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTrafficDistributionGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeTrafficDistributionGroupWithContext(ctx aws.Context, input *DescribeTrafficDistributionGroupInput, opts ...request.Option) (*DescribeTrafficDistributionGroupOutput, error) {
	req, out := c.DescribeTrafficDistributionGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUser = "DescribeUser"

// DescribeUserRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUser operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUser for more information on using the DescribeUser
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserRequest method.
//	req, resp := client.DescribeUserRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUserRequest(input *DescribeUserInput) (req *request.Request, output *DescribeUserOutput) {
	op := &request.Operation{
		Name:       opDescribeUser,
		HTTPMethod: "GET",
		HTTPPath:   "/users/{InstanceId}/{UserId}",
	}

	if input == nil {
		input = &DescribeUserInput{}
	}

	output = &DescribeUserOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUser API operation for Amazon Connect Service.
//
// Describes the specified user account. You can find the instance ID in the
// Amazon Connect console (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
// (it’s the final part of the ARN). The console does not display the user
// IDs. Instead, list the users and note the IDs provided in the output.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUser for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUser
func (c *Connect) DescribeUser(input *DescribeUserInput) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	return out, req.Send()
}

// DescribeUserWithContext is the same as DescribeUser with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserWithContext(ctx aws.Context, input *DescribeUserInput, opts ...request.Option) (*DescribeUserOutput, error) {
	req, out := c.DescribeUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyGroup = "DescribeUserHierarchyGroup"

// DescribeUserHierarchyGroupRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyGroup operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyGroup for more information on using the DescribeUserHierarchyGroup
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserHierarchyGroupRequest method.
//	req, resp := client.DescribeUserHierarchyGroupRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroupRequest(input *DescribeUserHierarchyGroupInput) (req *request.Request, output *DescribeUserHierarchyGroupOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyGroup,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyGroupInput{}
	}

	output = &DescribeUserHierarchyGroupOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyGroup API operation for Amazon Connect Service.
//
// Describes the specified hierarchy group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyGroup for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyGroup
func (c *Connect) DescribeUserHierarchyGroup(input *DescribeUserHierarchyGroupInput) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyGroupWithContext is the same as DescribeUserHierarchyGroup with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyGroupWithContext(ctx aws.Context, input *DescribeUserHierarchyGroupInput, opts ...request.Option) (*DescribeUserHierarchyGroupOutput, error) {
	req, out := c.DescribeUserHierarchyGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeUserHierarchyStructure = "DescribeUserHierarchyStructure"

// DescribeUserHierarchyStructureRequest generates a "aws/request.Request" representing the
// client's request for the DescribeUserHierarchyStructure operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeUserHierarchyStructure for more information on using the DescribeUserHierarchyStructure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeUserHierarchyStructureRequest method.
//	req, resp := client.DescribeUserHierarchyStructureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructureRequest(input *DescribeUserHierarchyStructureInput) (req *request.Request, output *DescribeUserHierarchyStructureOutput) {
	op := &request.Operation{
		Name:       opDescribeUserHierarchyStructure,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-structure/{InstanceId}",
	}

	if input == nil {
		input = &DescribeUserHierarchyStructureInput{}
	}

	output = &DescribeUserHierarchyStructureOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeUserHierarchyStructure API operation for Amazon Connect Service.
//
// Describes the hierarchy structure of the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeUserHierarchyStructure for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeUserHierarchyStructure
func (c *Connect) DescribeUserHierarchyStructure(input *DescribeUserHierarchyStructureInput) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	return out, req.Send()
}

// DescribeUserHierarchyStructureWithContext is the same as DescribeUserHierarchyStructure with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeUserHierarchyStructure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeUserHierarchyStructureWithContext(ctx aws.Context, input *DescribeUserHierarchyStructureInput, opts ...request.Option) (*DescribeUserHierarchyStructureOutput, error) {
	req, out := c.DescribeUserHierarchyStructureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeVocabulary = "DescribeVocabulary"

// DescribeVocabularyRequest generates a "aws/request.Request" representing the
// client's request for the DescribeVocabulary operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DescribeVocabulary for more information on using the DescribeVocabulary
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DescribeVocabularyRequest method.
//	req, resp := client.DescribeVocabularyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary
func (c *Connect) DescribeVocabularyRequest(input *DescribeVocabularyInput) (req *request.Request, output *DescribeVocabularyOutput) {
	op := &request.Operation{
		Name:       opDescribeVocabulary,
		HTTPMethod: "GET",
		HTTPPath:   "/vocabulary/{InstanceId}/{VocabularyId}",
	}

	if input == nil {
		input = &DescribeVocabularyInput{}
	}

	output = &DescribeVocabularyOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DescribeVocabulary API operation for Amazon Connect Service.
//
// Describes the specified vocabulary.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DescribeVocabulary for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DescribeVocabulary
func (c *Connect) DescribeVocabulary(input *DescribeVocabularyInput) (*DescribeVocabularyOutput, error) {
	req, out := c.DescribeVocabularyRequest(input)
	return out, req.Send()
}

// DescribeVocabularyWithContext is the same as DescribeVocabulary with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeVocabulary for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DescribeVocabularyWithContext(ctx aws.Context, input *DescribeVocabularyInput, opts ...request.Option) (*DescribeVocabularyOutput, error) {
	req, out := c.DescribeVocabularyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateApprovedOrigin = "DisassociateApprovedOrigin"

// DisassociateApprovedOriginRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateApprovedOrigin operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateApprovedOrigin for more information on using the DisassociateApprovedOrigin
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateApprovedOriginRequest method.
//	req, resp := client.DisassociateApprovedOriginRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin
func (c *Connect) DisassociateApprovedOriginRequest(input *DisassociateApprovedOriginInput) (req *request.Request, output *DisassociateApprovedOriginOutput) {
	op := &request.Operation{
		Name:       opDisassociateApprovedOrigin,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/approved-origin",
	}

	if input == nil {
		input = &DisassociateApprovedOriginInput{}
	}

	output = &DisassociateApprovedOriginOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateApprovedOrigin API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Revokes access to integrated applications from Amazon Connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateApprovedOrigin for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateApprovedOrigin
func (c *Connect) DisassociateApprovedOrigin(input *DisassociateApprovedOriginInput) (*DisassociateApprovedOriginOutput, error) {
	req, out := c.DisassociateApprovedOriginRequest(input)
	return out, req.Send()
}

// DisassociateApprovedOriginWithContext is the same as DisassociateApprovedOrigin with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateApprovedOrigin for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateApprovedOriginWithContext(ctx aws.Context, input *DisassociateApprovedOriginInput, opts ...request.Option) (*DisassociateApprovedOriginOutput, error) {
	req, out := c.DisassociateApprovedOriginRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateBot = "DisassociateBot"

// DisassociateBotRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateBot for more information on using the DisassociateBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateBotRequest method.
//	req, resp := client.DisassociateBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot
func (c *Connect) DisassociateBotRequest(input *DisassociateBotInput) (req *request.Request, output *DisassociateBotOutput) {
	op := &request.Operation{
		Name:       opDisassociateBot,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/{InstanceId}/bot",
	}

	if input == nil {
		input = &DisassociateBotInput{}
	}

	output = &DisassociateBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateBot API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Revokes authorization from the specified instance to access the specified
// Amazon Lex or Amazon Lex V2 bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateBot for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateBot
func (c *Connect) DisassociateBot(input *DisassociateBotInput) (*DisassociateBotOutput, error) {
	req, out := c.DisassociateBotRequest(input)
	return out, req.Send()
}

// DisassociateBotWithContext is the same as DisassociateBot with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateBotWithContext(ctx aws.Context, input *DisassociateBotInput, opts ...request.Option) (*DisassociateBotOutput, error) {
	req, out := c.DisassociateBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateInstanceStorageConfig = "DisassociateInstanceStorageConfig"

// DisassociateInstanceStorageConfigRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateInstanceStorageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateInstanceStorageConfig for more information on using the DisassociateInstanceStorageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateInstanceStorageConfigRequest method.
//	req, resp := client.DisassociateInstanceStorageConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig
func (c *Connect) DisassociateInstanceStorageConfigRequest(input *DisassociateInstanceStorageConfigInput) (req *request.Request, output *DisassociateInstanceStorageConfigOutput) {
	op := &request.Operation{
		Name:       opDisassociateInstanceStorageConfig,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/storage-config/{AssociationId}",
	}

	if input == nil {
		input = &DisassociateInstanceStorageConfigInput{}
	}

	output = &DisassociateInstanceStorageConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateInstanceStorageConfig API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Removes the storage type configurations for the specified resource type and
// association ID.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateInstanceStorageConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateInstanceStorageConfig
func (c *Connect) DisassociateInstanceStorageConfig(input *DisassociateInstanceStorageConfigInput) (*DisassociateInstanceStorageConfigOutput, error) {
	req, out := c.DisassociateInstanceStorageConfigRequest(input)
	return out, req.Send()
}

// DisassociateInstanceStorageConfigWithContext is the same as DisassociateInstanceStorageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateInstanceStorageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateInstanceStorageConfigWithContext(ctx aws.Context, input *DisassociateInstanceStorageConfigInput, opts ...request.Option) (*DisassociateInstanceStorageConfigOutput, error) {
	req, out := c.DisassociateInstanceStorageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLambdaFunction = "DisassociateLambdaFunction"

// DisassociateLambdaFunctionRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLambdaFunction operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLambdaFunction for more information on using the DisassociateLambdaFunction
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateLambdaFunctionRequest method.
//	req, resp := client.DisassociateLambdaFunctionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction
func (c *Connect) DisassociateLambdaFunctionRequest(input *DisassociateLambdaFunctionInput) (req *request.Request, output *DisassociateLambdaFunctionOutput) {
	op := &request.Operation{
		Name:       opDisassociateLambdaFunction,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/lambda-function",
	}

	if input == nil {
		input = &DisassociateLambdaFunctionInput{}
	}

	output = &DisassociateLambdaFunctionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateLambdaFunction API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Remove the Lambda function from the dropdown options available in the relevant
// flow blocks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateLambdaFunction for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLambdaFunction
func (c *Connect) DisassociateLambdaFunction(input *DisassociateLambdaFunctionInput) (*DisassociateLambdaFunctionOutput, error) {
	req, out := c.DisassociateLambdaFunctionRequest(input)
	return out, req.Send()
}

// DisassociateLambdaFunctionWithContext is the same as DisassociateLambdaFunction with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLambdaFunction for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateLambdaFunctionWithContext(ctx aws.Context, input *DisassociateLambdaFunctionInput, opts ...request.Option) (*DisassociateLambdaFunctionOutput, error) {
	req, out := c.DisassociateLambdaFunctionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateLexBot = "DisassociateLexBot"

// DisassociateLexBotRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateLexBot operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateLexBot for more information on using the DisassociateLexBot
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateLexBotRequest method.
//	req, resp := client.DisassociateLexBotRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot
func (c *Connect) DisassociateLexBotRequest(input *DisassociateLexBotInput) (req *request.Request, output *DisassociateLexBotOutput) {
	op := &request.Operation{
		Name:       opDisassociateLexBot,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/lex-bot",
	}

	if input == nil {
		input = &DisassociateLexBotInput{}
	}

	output = &DisassociateLexBotOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateLexBot API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Revokes authorization from the specified instance to access the specified
// Amazon Lex bot.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateLexBot for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateLexBot
func (c *Connect) DisassociateLexBot(input *DisassociateLexBotInput) (*DisassociateLexBotOutput, error) {
	req, out := c.DisassociateLexBotRequest(input)
	return out, req.Send()
}

// DisassociateLexBotWithContext is the same as DisassociateLexBot with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateLexBot for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateLexBotWithContext(ctx aws.Context, input *DisassociateLexBotInput, opts ...request.Option) (*DisassociateLexBotOutput, error) {
	req, out := c.DisassociateLexBotRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociatePhoneNumberContactFlow = "DisassociatePhoneNumberContactFlow"

// DisassociatePhoneNumberContactFlowRequest generates a "aws/request.Request" representing the
// client's request for the DisassociatePhoneNumberContactFlow operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociatePhoneNumberContactFlow for more information on using the DisassociatePhoneNumberContactFlow
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociatePhoneNumberContactFlowRequest method.
//	req, resp := client.DisassociatePhoneNumberContactFlowRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow
func (c *Connect) DisassociatePhoneNumberContactFlowRequest(input *DisassociatePhoneNumberContactFlowInput) (req *request.Request, output *DisassociatePhoneNumberContactFlowOutput) {
	op := &request.Operation{
		Name:       opDisassociatePhoneNumberContactFlow,
		HTTPMethod: "DELETE",
		HTTPPath:   "/phone-number/{PhoneNumberId}/contact-flow",
	}

	if input == nil {
		input = &DisassociatePhoneNumberContactFlowInput{}
	}

	output = &DisassociatePhoneNumberContactFlowOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociatePhoneNumberContactFlow API operation for Amazon Connect Service.
//
// Removes the flow association from a phone number claimed to your Amazon Connect
// instance.
//
// If the number is claimed to a traffic distribution group, and you are calling
// this API using an instance in the Amazon Web Services Region where the traffic
// distribution group was created, you can use either a full phone number ARN
// or UUID value for the PhoneNumberId URI request parameter. However, if the
// number is claimed to a traffic distribution group and you are calling this
// API using an instance in the alternate Amazon Web Services Region associated
// with the traffic distribution group, you must provide a full phone number
// ARN. If a UUID is provided in this scenario, you will receive a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociatePhoneNumberContactFlow for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociatePhoneNumberContactFlow
func (c *Connect) DisassociatePhoneNumberContactFlow(input *DisassociatePhoneNumberContactFlowInput) (*DisassociatePhoneNumberContactFlowOutput, error) {
	req, out := c.DisassociatePhoneNumberContactFlowRequest(input)
	return out, req.Send()
}

// DisassociatePhoneNumberContactFlowWithContext is the same as DisassociatePhoneNumberContactFlow with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociatePhoneNumberContactFlow for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociatePhoneNumberContactFlowWithContext(ctx aws.Context, input *DisassociatePhoneNumberContactFlowInput, opts ...request.Option) (*DisassociatePhoneNumberContactFlowOutput, error) {
	req, out := c.DisassociatePhoneNumberContactFlowRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateQueueQuickConnects = "DisassociateQueueQuickConnects"

// DisassociateQueueQuickConnectsRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateQueueQuickConnects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateQueueQuickConnects for more information on using the DisassociateQueueQuickConnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateQueueQuickConnectsRequest method.
//	req, resp := client.DisassociateQueueQuickConnectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects
func (c *Connect) DisassociateQueueQuickConnectsRequest(input *DisassociateQueueQuickConnectsInput) (req *request.Request, output *DisassociateQueueQuickConnectsOutput) {
	op := &request.Operation{
		Name:       opDisassociateQueueQuickConnects,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/disassociate-quick-connects",
	}

	if input == nil {
		input = &DisassociateQueueQuickConnectsInput{}
	}

	output = &DisassociateQueueQuickConnectsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateQueueQuickConnects API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Disassociates a set of quick connects from a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateQueueQuickConnects for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateQueueQuickConnects
func (c *Connect) DisassociateQueueQuickConnects(input *DisassociateQueueQuickConnectsInput) (*DisassociateQueueQuickConnectsOutput, error) {
	req, out := c.DisassociateQueueQuickConnectsRequest(input)
	return out, req.Send()
}

// DisassociateQueueQuickConnectsWithContext is the same as DisassociateQueueQuickConnects with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateQueueQuickConnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateQueueQuickConnectsWithContext(ctx aws.Context, input *DisassociateQueueQuickConnectsInput, opts ...request.Option) (*DisassociateQueueQuickConnectsOutput, error) {
	req, out := c.DisassociateQueueQuickConnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateRoutingProfileQueues = "DisassociateRoutingProfileQueues"

// DisassociateRoutingProfileQueuesRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateRoutingProfileQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateRoutingProfileQueues for more information on using the DisassociateRoutingProfileQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateRoutingProfileQueuesRequest method.
//	req, resp := client.DisassociateRoutingProfileQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues
func (c *Connect) DisassociateRoutingProfileQueuesRequest(input *DisassociateRoutingProfileQueuesInput) (req *request.Request, output *DisassociateRoutingProfileQueuesOutput) {
	op := &request.Operation{
		Name:       opDisassociateRoutingProfileQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/disassociate-queues",
	}

	if input == nil {
		input = &DisassociateRoutingProfileQueuesInput{}
	}

	output = &DisassociateRoutingProfileQueuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateRoutingProfileQueues API operation for Amazon Connect Service.
//
// Disassociates a set of queues from a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateRoutingProfileQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateRoutingProfileQueues
func (c *Connect) DisassociateRoutingProfileQueues(input *DisassociateRoutingProfileQueuesInput) (*DisassociateRoutingProfileQueuesOutput, error) {
	req, out := c.DisassociateRoutingProfileQueuesRequest(input)
	return out, req.Send()
}

// DisassociateRoutingProfileQueuesWithContext is the same as DisassociateRoutingProfileQueues with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateRoutingProfileQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateRoutingProfileQueuesWithContext(ctx aws.Context, input *DisassociateRoutingProfileQueuesInput, opts ...request.Option) (*DisassociateRoutingProfileQueuesOutput, error) {
	req, out := c.DisassociateRoutingProfileQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateSecurityKey = "DisassociateSecurityKey"

// DisassociateSecurityKeyRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateSecurityKey operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateSecurityKey for more information on using the DisassociateSecurityKey
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateSecurityKeyRequest method.
//	req, resp := client.DisassociateSecurityKeyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey
func (c *Connect) DisassociateSecurityKeyRequest(input *DisassociateSecurityKeyInput) (req *request.Request, output *DisassociateSecurityKeyOutput) {
	op := &request.Operation{
		Name:       opDisassociateSecurityKey,
		HTTPMethod: "DELETE",
		HTTPPath:   "/instance/{InstanceId}/security-key/{AssociationId}",
	}

	if input == nil {
		input = &DisassociateSecurityKeyInput{}
	}

	output = &DisassociateSecurityKeyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DisassociateSecurityKey API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Deletes the specified security key.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DisassociateSecurityKey for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DisassociateSecurityKey
func (c *Connect) DisassociateSecurityKey(input *DisassociateSecurityKeyInput) (*DisassociateSecurityKeyOutput, error) {
	req, out := c.DisassociateSecurityKeyRequest(input)
	return out, req.Send()
}

// DisassociateSecurityKeyWithContext is the same as DisassociateSecurityKey with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateSecurityKey for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DisassociateSecurityKeyWithContext(ctx aws.Context, input *DisassociateSecurityKeyInput, opts ...request.Option) (*DisassociateSecurityKeyOutput, error) {
	req, out := c.DisassociateSecurityKeyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDismissUserContact = "DismissUserContact"

// DismissUserContactRequest generates a "aws/request.Request" representing the
// client's request for the DismissUserContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DismissUserContact for more information on using the DismissUserContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DismissUserContactRequest method.
//	req, resp := client.DismissUserContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact
func (c *Connect) DismissUserContactRequest(input *DismissUserContactInput) (req *request.Request, output *DismissUserContactOutput) {
	op := &request.Operation{
		Name:       opDismissUserContact,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/contact",
	}

	if input == nil {
		input = &DismissUserContactInput{}
	}

	output = &DismissUserContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DismissUserContact API operation for Amazon Connect Service.
//
// Dismisses contacts from an agent’s CCP and returns the agent to an available
// state, which allows the agent to receive a new routed contact. Contacts can
// only be dismissed if they are in a MISSED, ERROR, ENDED, or REJECTED state
// in the Agent Event Stream (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation DismissUserContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/DismissUserContact
func (c *Connect) DismissUserContact(input *DismissUserContactInput) (*DismissUserContactOutput, error) {
	req, out := c.DismissUserContactRequest(input)
	return out, req.Send()
}

// DismissUserContactWithContext is the same as DismissUserContact with the addition of
// the ability to pass a context and additional request options.
//
// See DismissUserContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) DismissUserContactWithContext(ctx aws.Context, input *DismissUserContactInput, opts ...request.Option) (*DismissUserContactOutput, error) {
	req, out := c.DismissUserContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetContactAttributes = "GetContactAttributes"

// GetContactAttributesRequest generates a "aws/request.Request" representing the
// client's request for the GetContactAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetContactAttributes for more information on using the GetContactAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetContactAttributesRequest method.
//	req, resp := client.GetContactAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes
func (c *Connect) GetContactAttributesRequest(input *GetContactAttributesInput) (req *request.Request, output *GetContactAttributesOutput) {
	op := &request.Operation{
		Name:       opGetContactAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/contact/attributes/{InstanceId}/{InitialContactId}",
	}

	if input == nil {
		input = &GetContactAttributesInput{}
	}

	output = &GetContactAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetContactAttributes API operation for Amazon Connect Service.
//
// Retrieves the contact attributes for the specified contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetContactAttributes for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetContactAttributes
func (c *Connect) GetContactAttributes(input *GetContactAttributesInput) (*GetContactAttributesOutput, error) {
	req, out := c.GetContactAttributesRequest(input)
	return out, req.Send()
}

// GetContactAttributesWithContext is the same as GetContactAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See GetContactAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetContactAttributesWithContext(ctx aws.Context, input *GetContactAttributesInput, opts ...request.Option) (*GetContactAttributesOutput, error) {
	req, out := c.GetContactAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetCurrentMetricData = "GetCurrentMetricData"

// GetCurrentMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetCurrentMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCurrentMetricData for more information on using the GetCurrentMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCurrentMetricDataRequest method.
//	req, resp := client.GetCurrentMetricDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricDataRequest(input *GetCurrentMetricDataInput) (req *request.Request, output *GetCurrentMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetCurrentMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/current/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCurrentMetricDataInput{}
	}

	output = &GetCurrentMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCurrentMetricData API operation for Amazon Connect Service.
//
// Gets the real-time metric data from the specified Amazon Connect instance.
//
// For a description of each metric, see Real-time Metrics Definitions (https://docs.aws.amazon.com/connect/latest/adminguide/real-time-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetCurrentMetricData for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentMetricData
func (c *Connect) GetCurrentMetricData(input *GetCurrentMetricDataInput) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	return out, req.Send()
}

// GetCurrentMetricDataWithContext is the same as GetCurrentMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetCurrentMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, opts ...request.Option) (*GetCurrentMetricDataOutput, error) {
	req, out := c.GetCurrentMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCurrentMetricDataPages iterates over the pages of a GetCurrentMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCurrentMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetCurrentMetricData operation.
//	pageNum := 0
//	err := client.GetCurrentMetricDataPages(params,
//	    func(page *connect.GetCurrentMetricDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) GetCurrentMetricDataPages(input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool) error {
	return c.GetCurrentMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCurrentMetricDataPagesWithContext same as GetCurrentMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentMetricDataPagesWithContext(ctx aws.Context, input *GetCurrentMetricDataInput, fn func(*GetCurrentMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCurrentMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCurrentMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCurrentMetricDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetCurrentUserData = "GetCurrentUserData"

// GetCurrentUserDataRequest generates a "aws/request.Request" representing the
// client's request for the GetCurrentUserData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetCurrentUserData for more information on using the GetCurrentUserData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetCurrentUserDataRequest method.
//	req, resp := client.GetCurrentUserDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData
func (c *Connect) GetCurrentUserDataRequest(input *GetCurrentUserDataInput) (req *request.Request, output *GetCurrentUserDataOutput) {
	op := &request.Operation{
		Name:       opGetCurrentUserData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/userdata/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetCurrentUserDataInput{}
	}

	output = &GetCurrentUserDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetCurrentUserData API operation for Amazon Connect Service.
//
// Gets the real-time active user data from the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetCurrentUserData for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetCurrentUserData
func (c *Connect) GetCurrentUserData(input *GetCurrentUserDataInput) (*GetCurrentUserDataOutput, error) {
	req, out := c.GetCurrentUserDataRequest(input)
	return out, req.Send()
}

// GetCurrentUserDataWithContext is the same as GetCurrentUserData with the addition of
// the ability to pass a context and additional request options.
//
// See GetCurrentUserData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentUserDataWithContext(ctx aws.Context, input *GetCurrentUserDataInput, opts ...request.Option) (*GetCurrentUserDataOutput, error) {
	req, out := c.GetCurrentUserDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetCurrentUserDataPages iterates over the pages of a GetCurrentUserData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetCurrentUserData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetCurrentUserData operation.
//	pageNum := 0
//	err := client.GetCurrentUserDataPages(params,
//	    func(page *connect.GetCurrentUserDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) GetCurrentUserDataPages(input *GetCurrentUserDataInput, fn func(*GetCurrentUserDataOutput, bool) bool) error {
	return c.GetCurrentUserDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetCurrentUserDataPagesWithContext same as GetCurrentUserDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetCurrentUserDataPagesWithContext(ctx aws.Context, input *GetCurrentUserDataInput, fn func(*GetCurrentUserDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetCurrentUserDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetCurrentUserDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetCurrentUserDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetFederationToken = "GetFederationToken"

// GetFederationTokenRequest generates a "aws/request.Request" representing the
// client's request for the GetFederationToken operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetFederationToken for more information on using the GetFederationToken
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetFederationTokenRequest method.
//	req, resp := client.GetFederationTokenRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationTokenRequest(input *GetFederationTokenInput) (req *request.Request, output *GetFederationTokenOutput) {
	op := &request.Operation{
		Name:       opGetFederationToken,
		HTTPMethod: "GET",
		HTTPPath:   "/user/federate/{InstanceId}",
	}

	if input == nil {
		input = &GetFederationTokenInput{}
	}

	output = &GetFederationTokenOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetFederationToken API operation for Amazon Connect Service.
//
// Retrieves a token for federation.
//
// This API doesn't support root users. If you try to invoke GetFederationToken
// with root credentials, an error message similar to the following one appears:
//
// Provided identity: Principal: .... User: .... cannot be used for federation
// with Amazon Connect
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetFederationToken for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - UserNotFoundException
//     No user with the specified credentials was found in the Amazon Connect instance.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetFederationToken
func (c *Connect) GetFederationToken(input *GetFederationTokenInput) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	return out, req.Send()
}

// GetFederationTokenWithContext is the same as GetFederationToken with the addition of
// the ability to pass a context and additional request options.
//
// See GetFederationToken for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetFederationTokenWithContext(ctx aws.Context, input *GetFederationTokenInput, opts ...request.Option) (*GetFederationTokenOutput, error) {
	req, out := c.GetFederationTokenRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetMetricData = "GetMetricData"

// GetMetricDataRequest generates a "aws/request.Request" representing the
// client's request for the GetMetricData operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricData for more information on using the GetMetricData
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricDataRequest method.
//	req, resp := client.GetMetricDataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricDataRequest(input *GetMetricDataInput) (req *request.Request, output *GetMetricDataOutput) {
	op := &request.Operation{
		Name:       opGetMetricData,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/historical/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataInput{}
	}

	output = &GetMetricDataOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricData API operation for Amazon Connect Service.
//
// Gets historical metric data from the specified Amazon Connect instance.
//
// For a description of each historical metric, see Historical Metrics Definitions
// (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetMetricData for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricData
func (c *Connect) GetMetricData(input *GetMetricDataInput) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	return out, req.Send()
}

// GetMetricDataWithContext is the same as GetMetricData with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricData for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataWithContext(ctx aws.Context, input *GetMetricDataInput, opts ...request.Option) (*GetMetricDataOutput, error) {
	req, out := c.GetMetricDataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMetricDataPages iterates over the pages of a GetMetricData operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMetricData method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetMetricData operation.
//	pageNum := 0
//	err := client.GetMetricDataPages(params,
//	    func(page *connect.GetMetricDataOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) GetMetricDataPages(input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool) error {
	return c.GetMetricDataPagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMetricDataPagesWithContext same as GetMetricDataPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataPagesWithContext(ctx aws.Context, input *GetMetricDataInput, fn func(*GetMetricDataOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMetricDataInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMetricDataRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMetricDataOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetMetricDataV2 = "GetMetricDataV2"

// GetMetricDataV2Request generates a "aws/request.Request" representing the
// client's request for the GetMetricDataV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetMetricDataV2 for more information on using the GetMetricDataV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetMetricDataV2Request method.
//	req, resp := client.GetMetricDataV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2
func (c *Connect) GetMetricDataV2Request(input *GetMetricDataV2Input) (req *request.Request, output *GetMetricDataV2Output) {
	op := &request.Operation{
		Name:       opGetMetricDataV2,
		HTTPMethod: "POST",
		HTTPPath:   "/metrics/data",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &GetMetricDataV2Input{}
	}

	output = &GetMetricDataV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// GetMetricDataV2 API operation for Amazon Connect Service.
//
// Gets metric data from the specified Amazon Connect instance.
//
// GetMetricDataV2 offers more features than GetMetricData (https://docs.aws.amazon.com/connect/latest/APIReference/API_GetMetricData.html),
// the previous version of this API. It has new metrics, offers filtering at
// a metric level, and offers the ability to filter and group data by channels,
// queues, routing profiles, agents, and agent hierarchy levels. It can retrieve
// historical data for the last 14 days, in 24-hour intervals.
//
// For a description of the historical metrics that are supported by GetMetricDataV2
// and GetMetricData, see Historical metrics definitions (https://docs.aws.amazon.com/connect/latest/adminguide/historical-metrics-definitions.html)
// in the Amazon Connect Administrator's Guide.
//
// This API is not available in the Amazon Web Services GovCloud (US) Regions.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetMetricDataV2 for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetMetricDataV2
func (c *Connect) GetMetricDataV2(input *GetMetricDataV2Input) (*GetMetricDataV2Output, error) {
	req, out := c.GetMetricDataV2Request(input)
	return out, req.Send()
}

// GetMetricDataV2WithContext is the same as GetMetricDataV2 with the addition of
// the ability to pass a context and additional request options.
//
// See GetMetricDataV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataV2WithContext(ctx aws.Context, input *GetMetricDataV2Input, opts ...request.Option) (*GetMetricDataV2Output, error) {
	req, out := c.GetMetricDataV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// GetMetricDataV2Pages iterates over the pages of a GetMetricDataV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See GetMetricDataV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a GetMetricDataV2 operation.
//	pageNum := 0
//	err := client.GetMetricDataV2Pages(params,
//	    func(page *connect.GetMetricDataV2Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) GetMetricDataV2Pages(input *GetMetricDataV2Input, fn func(*GetMetricDataV2Output, bool) bool) error {
	return c.GetMetricDataV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// GetMetricDataV2PagesWithContext same as GetMetricDataV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetMetricDataV2PagesWithContext(ctx aws.Context, input *GetMetricDataV2Input, fn func(*GetMetricDataV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *GetMetricDataV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.GetMetricDataV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*GetMetricDataV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opGetTaskTemplate = "GetTaskTemplate"

// GetTaskTemplateRequest generates a "aws/request.Request" representing the
// client's request for the GetTaskTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTaskTemplate for more information on using the GetTaskTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTaskTemplateRequest method.
//	req, resp := client.GetTaskTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate
func (c *Connect) GetTaskTemplateRequest(input *GetTaskTemplateInput) (req *request.Request, output *GetTaskTemplateOutput) {
	op := &request.Operation{
		Name:       opGetTaskTemplate,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/task/template/{TaskTemplateId}",
	}

	if input == nil {
		input = &GetTaskTemplateInput{}
	}

	output = &GetTaskTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTaskTemplate API operation for Amazon Connect Service.
//
// Gets details about a specific task template in the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetTaskTemplate for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTaskTemplate
func (c *Connect) GetTaskTemplate(input *GetTaskTemplateInput) (*GetTaskTemplateOutput, error) {
	req, out := c.GetTaskTemplateRequest(input)
	return out, req.Send()
}

// GetTaskTemplateWithContext is the same as GetTaskTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See GetTaskTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetTaskTemplateWithContext(ctx aws.Context, input *GetTaskTemplateInput, opts ...request.Option) (*GetTaskTemplateOutput, error) {
	req, out := c.GetTaskTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetTrafficDistribution = "GetTrafficDistribution"

// GetTrafficDistributionRequest generates a "aws/request.Request" representing the
// client's request for the GetTrafficDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetTrafficDistribution for more information on using the GetTrafficDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetTrafficDistributionRequest method.
//	req, resp := client.GetTrafficDistributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution
func (c *Connect) GetTrafficDistributionRequest(input *GetTrafficDistributionInput) (req *request.Request, output *GetTrafficDistributionOutput) {
	op := &request.Operation{
		Name:       opGetTrafficDistribution,
		HTTPMethod: "GET",
		HTTPPath:   "/traffic-distribution/{Id}",
	}

	if input == nil {
		input = &GetTrafficDistributionInput{}
	}

	output = &GetTrafficDistributionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetTrafficDistribution API operation for Amazon Connect Service.
//
// Retrieves the current traffic distribution for a given traffic distribution
// group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation GetTrafficDistribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/GetTrafficDistribution
func (c *Connect) GetTrafficDistribution(input *GetTrafficDistributionInput) (*GetTrafficDistributionOutput, error) {
	req, out := c.GetTrafficDistributionRequest(input)
	return out, req.Send()
}

// GetTrafficDistributionWithContext is the same as GetTrafficDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See GetTrafficDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) GetTrafficDistributionWithContext(ctx aws.Context, input *GetTrafficDistributionInput, opts ...request.Option) (*GetTrafficDistributionOutput, error) {
	req, out := c.GetTrafficDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListAgentStatuses = "ListAgentStatuses"

// ListAgentStatusesRequest generates a "aws/request.Request" representing the
// client's request for the ListAgentStatuses operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListAgentStatuses for more information on using the ListAgentStatuses
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListAgentStatusesRequest method.
//	req, resp := client.ListAgentStatusesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses
func (c *Connect) ListAgentStatusesRequest(input *ListAgentStatusesInput) (req *request.Request, output *ListAgentStatusesOutput) {
	op := &request.Operation{
		Name:       opListAgentStatuses,
		HTTPMethod: "GET",
		HTTPPath:   "/agent-status/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListAgentStatusesInput{}
	}

	output = &ListAgentStatusesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListAgentStatuses API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Lists agent statuses.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListAgentStatuses for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListAgentStatuses
func (c *Connect) ListAgentStatuses(input *ListAgentStatusesInput) (*ListAgentStatusesOutput, error) {
	req, out := c.ListAgentStatusesRequest(input)
	return out, req.Send()
}

// ListAgentStatusesWithContext is the same as ListAgentStatuses with the addition of
// the ability to pass a context and additional request options.
//
// See ListAgentStatuses for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListAgentStatusesWithContext(ctx aws.Context, input *ListAgentStatusesInput, opts ...request.Option) (*ListAgentStatusesOutput, error) {
	req, out := c.ListAgentStatusesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListAgentStatusesPages iterates over the pages of a ListAgentStatuses operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListAgentStatuses method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListAgentStatuses operation.
//	pageNum := 0
//	err := client.ListAgentStatusesPages(params,
//	    func(page *connect.ListAgentStatusesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListAgentStatusesPages(input *ListAgentStatusesInput, fn func(*ListAgentStatusesOutput, bool) bool) error {
	return c.ListAgentStatusesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListAgentStatusesPagesWithContext same as ListAgentStatusesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListAgentStatusesPagesWithContext(ctx aws.Context, input *ListAgentStatusesInput, fn func(*ListAgentStatusesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListAgentStatusesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListAgentStatusesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListAgentStatusesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListApprovedOrigins = "ListApprovedOrigins"

// ListApprovedOriginsRequest generates a "aws/request.Request" representing the
// client's request for the ListApprovedOrigins operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListApprovedOrigins for more information on using the ListApprovedOrigins
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListApprovedOriginsRequest method.
//	req, resp := client.ListApprovedOriginsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins
func (c *Connect) ListApprovedOriginsRequest(input *ListApprovedOriginsInput) (req *request.Request, output *ListApprovedOriginsOutput) {
	op := &request.Operation{
		Name:       opListApprovedOrigins,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/approved-origins",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListApprovedOriginsInput{}
	}

	output = &ListApprovedOriginsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListApprovedOrigins API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of all approved origins associated with the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListApprovedOrigins for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListApprovedOrigins
func (c *Connect) ListApprovedOrigins(input *ListApprovedOriginsInput) (*ListApprovedOriginsOutput, error) {
	req, out := c.ListApprovedOriginsRequest(input)
	return out, req.Send()
}

// ListApprovedOriginsWithContext is the same as ListApprovedOrigins with the addition of
// the ability to pass a context and additional request options.
//
// See ListApprovedOrigins for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListApprovedOriginsWithContext(ctx aws.Context, input *ListApprovedOriginsInput, opts ...request.Option) (*ListApprovedOriginsOutput, error) {
	req, out := c.ListApprovedOriginsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListApprovedOriginsPages iterates over the pages of a ListApprovedOrigins operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListApprovedOrigins method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListApprovedOrigins operation.
//	pageNum := 0
//	err := client.ListApprovedOriginsPages(params,
//	    func(page *connect.ListApprovedOriginsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListApprovedOriginsPages(input *ListApprovedOriginsInput, fn func(*ListApprovedOriginsOutput, bool) bool) error {
	return c.ListApprovedOriginsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListApprovedOriginsPagesWithContext same as ListApprovedOriginsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListApprovedOriginsPagesWithContext(ctx aws.Context, input *ListApprovedOriginsInput, fn func(*ListApprovedOriginsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListApprovedOriginsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListApprovedOriginsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListApprovedOriginsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListBots = "ListBots"

// ListBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListBots for more information on using the ListBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListBotsRequest method.
//	req, resp := client.ListBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots
func (c *Connect) ListBotsRequest(input *ListBotsInput) (req *request.Request, output *ListBotsOutput) {
	op := &request.Operation{
		Name:       opListBots,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/bots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListBotsInput{}
	}

	output = &ListBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListBots API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// For the specified version of Amazon Lex, returns a paginated list of all
// the Amazon Lex bots currently associated with the instance. Use this API
// to returns both Amazon Lex V1 and V2 bots.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListBots for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListBots
func (c *Connect) ListBots(input *ListBotsInput) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	return out, req.Send()
}

// ListBotsWithContext is the same as ListBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListBotsWithContext(ctx aws.Context, input *ListBotsInput, opts ...request.Option) (*ListBotsOutput, error) {
	req, out := c.ListBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListBotsPages iterates over the pages of a ListBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListBots operation.
//	pageNum := 0
//	err := client.ListBotsPages(params,
//	    func(page *connect.ListBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListBotsPages(input *ListBotsInput, fn func(*ListBotsOutput, bool) bool) error {
	return c.ListBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListBotsPagesWithContext same as ListBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListBotsPagesWithContext(ctx aws.Context, input *ListBotsInput, fn func(*ListBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContactEvaluations = "ListContactEvaluations"

// ListContactEvaluationsRequest generates a "aws/request.Request" representing the
// client's request for the ListContactEvaluations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactEvaluations for more information on using the ListContactEvaluations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactEvaluationsRequest method.
//	req, resp := client.ListContactEvaluationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations
func (c *Connect) ListContactEvaluationsRequest(input *ListContactEvaluationsInput) (req *request.Request, output *ListContactEvaluationsOutput) {
	op := &request.Operation{
		Name:       opListContactEvaluations,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-evaluations/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactEvaluationsInput{}
	}

	output = &ListContactEvaluationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactEvaluations API operation for Amazon Connect Service.
//
// Lists contact evaluations in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListContactEvaluations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactEvaluations
func (c *Connect) ListContactEvaluations(input *ListContactEvaluationsInput) (*ListContactEvaluationsOutput, error) {
	req, out := c.ListContactEvaluationsRequest(input)
	return out, req.Send()
}

// ListContactEvaluationsWithContext is the same as ListContactEvaluations with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactEvaluations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactEvaluationsWithContext(ctx aws.Context, input *ListContactEvaluationsInput, opts ...request.Option) (*ListContactEvaluationsOutput, error) {
	req, out := c.ListContactEvaluationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactEvaluationsPages iterates over the pages of a ListContactEvaluations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactEvaluations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactEvaluations operation.
//	pageNum := 0
//	err := client.ListContactEvaluationsPages(params,
//	    func(page *connect.ListContactEvaluationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListContactEvaluationsPages(input *ListContactEvaluationsInput, fn func(*ListContactEvaluationsOutput, bool) bool) error {
	return c.ListContactEvaluationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactEvaluationsPagesWithContext same as ListContactEvaluationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactEvaluationsPagesWithContext(ctx aws.Context, input *ListContactEvaluationsInput, fn func(*ListContactEvaluationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactEvaluationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactEvaluationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactEvaluationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContactFlowModules = "ListContactFlowModules"

// ListContactFlowModulesRequest generates a "aws/request.Request" representing the
// client's request for the ListContactFlowModules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactFlowModules for more information on using the ListContactFlowModules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactFlowModulesRequest method.
//	req, resp := client.ListContactFlowModulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules
func (c *Connect) ListContactFlowModulesRequest(input *ListContactFlowModulesInput) (req *request.Request, output *ListContactFlowModulesOutput) {
	op := &request.Operation{
		Name:       opListContactFlowModules,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-flow-modules-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactFlowModulesInput{}
	}

	output = &ListContactFlowModulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactFlowModules API operation for Amazon Connect Service.
//
// Provides information about the flow modules for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListContactFlowModules for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlowModules
func (c *Connect) ListContactFlowModules(input *ListContactFlowModulesInput) (*ListContactFlowModulesOutput, error) {
	req, out := c.ListContactFlowModulesRequest(input)
	return out, req.Send()
}

// ListContactFlowModulesWithContext is the same as ListContactFlowModules with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactFlowModules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowModulesWithContext(ctx aws.Context, input *ListContactFlowModulesInput, opts ...request.Option) (*ListContactFlowModulesOutput, error) {
	req, out := c.ListContactFlowModulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactFlowModulesPages iterates over the pages of a ListContactFlowModules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactFlowModules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactFlowModules operation.
//	pageNum := 0
//	err := client.ListContactFlowModulesPages(params,
//	    func(page *connect.ListContactFlowModulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListContactFlowModulesPages(input *ListContactFlowModulesInput, fn func(*ListContactFlowModulesOutput, bool) bool) error {
	return c.ListContactFlowModulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactFlowModulesPagesWithContext same as ListContactFlowModulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowModulesPagesWithContext(ctx aws.Context, input *ListContactFlowModulesInput, fn func(*ListContactFlowModulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactFlowModulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactFlowModulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactFlowModulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContactFlows = "ListContactFlows"

// ListContactFlowsRequest generates a "aws/request.Request" representing the
// client's request for the ListContactFlows operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactFlows for more information on using the ListContactFlows
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactFlowsRequest method.
//	req, resp := client.ListContactFlowsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows
func (c *Connect) ListContactFlowsRequest(input *ListContactFlowsInput) (req *request.Request, output *ListContactFlowsOutput) {
	op := &request.Operation{
		Name:       opListContactFlows,
		HTTPMethod: "GET",
		HTTPPath:   "/contact-flows-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactFlowsInput{}
	}

	output = &ListContactFlowsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactFlows API operation for Amazon Connect Service.
//
// Provides information about the flows for the specified Amazon Connect instance.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
//
// For more information about flows, see Flows (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-contact-flows.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListContactFlows for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactFlows
func (c *Connect) ListContactFlows(input *ListContactFlowsInput) (*ListContactFlowsOutput, error) {
	req, out := c.ListContactFlowsRequest(input)
	return out, req.Send()
}

// ListContactFlowsWithContext is the same as ListContactFlows with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactFlows for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowsWithContext(ctx aws.Context, input *ListContactFlowsInput, opts ...request.Option) (*ListContactFlowsOutput, error) {
	req, out := c.ListContactFlowsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactFlowsPages iterates over the pages of a ListContactFlows operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactFlows method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactFlows operation.
//	pageNum := 0
//	err := client.ListContactFlowsPages(params,
//	    func(page *connect.ListContactFlowsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListContactFlowsPages(input *ListContactFlowsInput, fn func(*ListContactFlowsOutput, bool) bool) error {
	return c.ListContactFlowsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactFlowsPagesWithContext same as ListContactFlowsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactFlowsPagesWithContext(ctx aws.Context, input *ListContactFlowsInput, fn func(*ListContactFlowsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactFlowsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactFlowsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactFlowsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListContactReferences = "ListContactReferences"

// ListContactReferencesRequest generates a "aws/request.Request" representing the
// client's request for the ListContactReferences operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListContactReferences for more information on using the ListContactReferences
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListContactReferencesRequest method.
//	req, resp := client.ListContactReferencesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences
func (c *Connect) ListContactReferencesRequest(input *ListContactReferencesInput) (req *request.Request, output *ListContactReferencesOutput) {
	op := &request.Operation{
		Name:       opListContactReferences,
		HTTPMethod: "GET",
		HTTPPath:   "/contact/references/{InstanceId}/{ContactId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListContactReferencesInput{}
	}

	output = &ListContactReferencesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListContactReferences API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// For the specified referenceTypes, returns a list of references associated
// with the contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListContactReferences for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListContactReferences
func (c *Connect) ListContactReferences(input *ListContactReferencesInput) (*ListContactReferencesOutput, error) {
	req, out := c.ListContactReferencesRequest(input)
	return out, req.Send()
}

// ListContactReferencesWithContext is the same as ListContactReferences with the addition of
// the ability to pass a context and additional request options.
//
// See ListContactReferences for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactReferencesWithContext(ctx aws.Context, input *ListContactReferencesInput, opts ...request.Option) (*ListContactReferencesOutput, error) {
	req, out := c.ListContactReferencesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListContactReferencesPages iterates over the pages of a ListContactReferences operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListContactReferences method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListContactReferences operation.
//	pageNum := 0
//	err := client.ListContactReferencesPages(params,
//	    func(page *connect.ListContactReferencesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListContactReferencesPages(input *ListContactReferencesInput, fn func(*ListContactReferencesOutput, bool) bool) error {
	return c.ListContactReferencesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListContactReferencesPagesWithContext same as ListContactReferencesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListContactReferencesPagesWithContext(ctx aws.Context, input *ListContactReferencesInput, fn func(*ListContactReferencesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListContactReferencesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListContactReferencesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListContactReferencesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListDefaultVocabularies = "ListDefaultVocabularies"

// ListDefaultVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the ListDefaultVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDefaultVocabularies for more information on using the ListDefaultVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListDefaultVocabulariesRequest method.
//	req, resp := client.ListDefaultVocabulariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies
func (c *Connect) ListDefaultVocabulariesRequest(input *ListDefaultVocabulariesInput) (req *request.Request, output *ListDefaultVocabulariesOutput) {
	op := &request.Operation{
		Name:       opListDefaultVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/default-vocabulary-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListDefaultVocabulariesInput{}
	}

	output = &ListDefaultVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDefaultVocabularies API operation for Amazon Connect Service.
//
// Lists the default vocabularies for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListDefaultVocabularies for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListDefaultVocabularies
func (c *Connect) ListDefaultVocabularies(input *ListDefaultVocabulariesInput) (*ListDefaultVocabulariesOutput, error) {
	req, out := c.ListDefaultVocabulariesRequest(input)
	return out, req.Send()
}

// ListDefaultVocabulariesWithContext is the same as ListDefaultVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See ListDefaultVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListDefaultVocabulariesWithContext(ctx aws.Context, input *ListDefaultVocabulariesInput, opts ...request.Option) (*ListDefaultVocabulariesOutput, error) {
	req, out := c.ListDefaultVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListDefaultVocabulariesPages iterates over the pages of a ListDefaultVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListDefaultVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListDefaultVocabularies operation.
//	pageNum := 0
//	err := client.ListDefaultVocabulariesPages(params,
//	    func(page *connect.ListDefaultVocabulariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListDefaultVocabulariesPages(input *ListDefaultVocabulariesInput, fn func(*ListDefaultVocabulariesOutput, bool) bool) error {
	return c.ListDefaultVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListDefaultVocabulariesPagesWithContext same as ListDefaultVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListDefaultVocabulariesPagesWithContext(ctx aws.Context, input *ListDefaultVocabulariesInput, fn func(*ListDefaultVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListDefaultVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListDefaultVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListDefaultVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvaluationFormVersions = "ListEvaluationFormVersions"

// ListEvaluationFormVersionsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvaluationFormVersions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvaluationFormVersions for more information on using the ListEvaluationFormVersions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEvaluationFormVersionsRequest method.
//	req, resp := client.ListEvaluationFormVersionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions
func (c *Connect) ListEvaluationFormVersionsRequest(input *ListEvaluationFormVersionsInput) (req *request.Request, output *ListEvaluationFormVersionsOutput) {
	op := &request.Operation{
		Name:       opListEvaluationFormVersions,
		HTTPMethod: "GET",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}/versions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEvaluationFormVersionsInput{}
	}

	output = &ListEvaluationFormVersionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvaluationFormVersions API operation for Amazon Connect Service.
//
// Lists versions of an evaluation form in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListEvaluationFormVersions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationFormVersions
func (c *Connect) ListEvaluationFormVersions(input *ListEvaluationFormVersionsInput) (*ListEvaluationFormVersionsOutput, error) {
	req, out := c.ListEvaluationFormVersionsRequest(input)
	return out, req.Send()
}

// ListEvaluationFormVersionsWithContext is the same as ListEvaluationFormVersions with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvaluationFormVersions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListEvaluationFormVersionsWithContext(ctx aws.Context, input *ListEvaluationFormVersionsInput, opts ...request.Option) (*ListEvaluationFormVersionsOutput, error) {
	req, out := c.ListEvaluationFormVersionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEvaluationFormVersionsPages iterates over the pages of a ListEvaluationFormVersions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvaluationFormVersions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEvaluationFormVersions operation.
//	pageNum := 0
//	err := client.ListEvaluationFormVersionsPages(params,
//	    func(page *connect.ListEvaluationFormVersionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListEvaluationFormVersionsPages(input *ListEvaluationFormVersionsInput, fn func(*ListEvaluationFormVersionsOutput, bool) bool) error {
	return c.ListEvaluationFormVersionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEvaluationFormVersionsPagesWithContext same as ListEvaluationFormVersionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListEvaluationFormVersionsPagesWithContext(ctx aws.Context, input *ListEvaluationFormVersionsInput, fn func(*ListEvaluationFormVersionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEvaluationFormVersionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEvaluationFormVersionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEvaluationFormVersionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListEvaluationForms = "ListEvaluationForms"

// ListEvaluationFormsRequest generates a "aws/request.Request" representing the
// client's request for the ListEvaluationForms operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEvaluationForms for more information on using the ListEvaluationForms
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListEvaluationFormsRequest method.
//	req, resp := client.ListEvaluationFormsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms
func (c *Connect) ListEvaluationFormsRequest(input *ListEvaluationFormsInput) (req *request.Request, output *ListEvaluationFormsOutput) {
	op := &request.Operation{
		Name:       opListEvaluationForms,
		HTTPMethod: "GET",
		HTTPPath:   "/evaluation-forms/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListEvaluationFormsInput{}
	}

	output = &ListEvaluationFormsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEvaluationForms API operation for Amazon Connect Service.
//
// Lists evaluation forms in the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListEvaluationForms for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListEvaluationForms
func (c *Connect) ListEvaluationForms(input *ListEvaluationFormsInput) (*ListEvaluationFormsOutput, error) {
	req, out := c.ListEvaluationFormsRequest(input)
	return out, req.Send()
}

// ListEvaluationFormsWithContext is the same as ListEvaluationForms with the addition of
// the ability to pass a context and additional request options.
//
// See ListEvaluationForms for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListEvaluationFormsWithContext(ctx aws.Context, input *ListEvaluationFormsInput, opts ...request.Option) (*ListEvaluationFormsOutput, error) {
	req, out := c.ListEvaluationFormsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListEvaluationFormsPages iterates over the pages of a ListEvaluationForms operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListEvaluationForms method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListEvaluationForms operation.
//	pageNum := 0
//	err := client.ListEvaluationFormsPages(params,
//	    func(page *connect.ListEvaluationFormsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListEvaluationFormsPages(input *ListEvaluationFormsInput, fn func(*ListEvaluationFormsOutput, bool) bool) error {
	return c.ListEvaluationFormsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListEvaluationFormsPagesWithContext same as ListEvaluationFormsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListEvaluationFormsPagesWithContext(ctx aws.Context, input *ListEvaluationFormsInput, fn func(*ListEvaluationFormsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListEvaluationFormsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListEvaluationFormsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListEvaluationFormsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListHoursOfOperations = "ListHoursOfOperations"

// ListHoursOfOperationsRequest generates a "aws/request.Request" representing the
// client's request for the ListHoursOfOperations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListHoursOfOperations for more information on using the ListHoursOfOperations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListHoursOfOperationsRequest method.
//	req, resp := client.ListHoursOfOperationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations
func (c *Connect) ListHoursOfOperationsRequest(input *ListHoursOfOperationsInput) (req *request.Request, output *ListHoursOfOperationsOutput) {
	op := &request.Operation{
		Name:       opListHoursOfOperations,
		HTTPMethod: "GET",
		HTTPPath:   "/hours-of-operations-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListHoursOfOperationsInput{}
	}

	output = &ListHoursOfOperationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListHoursOfOperations API operation for Amazon Connect Service.
//
// Provides information about the hours of operation for the specified Amazon
// Connect instance.
//
// For more information about hours of operation, see Set the Hours of Operation
// for a Queue (https://docs.aws.amazon.com/connect/latest/adminguide/set-hours-operation.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListHoursOfOperations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListHoursOfOperations
func (c *Connect) ListHoursOfOperations(input *ListHoursOfOperationsInput) (*ListHoursOfOperationsOutput, error) {
	req, out := c.ListHoursOfOperationsRequest(input)
	return out, req.Send()
}

// ListHoursOfOperationsWithContext is the same as ListHoursOfOperations with the addition of
// the ability to pass a context and additional request options.
//
// See ListHoursOfOperations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListHoursOfOperationsWithContext(ctx aws.Context, input *ListHoursOfOperationsInput, opts ...request.Option) (*ListHoursOfOperationsOutput, error) {
	req, out := c.ListHoursOfOperationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListHoursOfOperationsPages iterates over the pages of a ListHoursOfOperations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListHoursOfOperations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListHoursOfOperations operation.
//	pageNum := 0
//	err := client.ListHoursOfOperationsPages(params,
//	    func(page *connect.ListHoursOfOperationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListHoursOfOperationsPages(input *ListHoursOfOperationsInput, fn func(*ListHoursOfOperationsOutput, bool) bool) error {
	return c.ListHoursOfOperationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListHoursOfOperationsPagesWithContext same as ListHoursOfOperationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListHoursOfOperationsPagesWithContext(ctx aws.Context, input *ListHoursOfOperationsInput, fn func(*ListHoursOfOperationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListHoursOfOperationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListHoursOfOperationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListHoursOfOperationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceAttributes = "ListInstanceAttributes"

// ListInstanceAttributesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceAttributes for more information on using the ListInstanceAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstanceAttributesRequest method.
//	req, resp := client.ListInstanceAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes
func (c *Connect) ListInstanceAttributesRequest(input *ListInstanceAttributesInput) (req *request.Request, output *ListInstanceAttributesOutput) {
	op := &request.Operation{
		Name:       opListInstanceAttributes,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/attributes",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceAttributesInput{}
	}

	output = &ListInstanceAttributesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceAttributes API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of all attribute types for the given instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListInstanceAttributes for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceAttributes
func (c *Connect) ListInstanceAttributes(input *ListInstanceAttributesInput) (*ListInstanceAttributesOutput, error) {
	req, out := c.ListInstanceAttributesRequest(input)
	return out, req.Send()
}

// ListInstanceAttributesWithContext is the same as ListInstanceAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstanceAttributesWithContext(ctx aws.Context, input *ListInstanceAttributesInput, opts ...request.Option) (*ListInstanceAttributesOutput, error) {
	req, out := c.ListInstanceAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceAttributesPages iterates over the pages of a ListInstanceAttributes operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceAttributes method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstanceAttributes operation.
//	pageNum := 0
//	err := client.ListInstanceAttributesPages(params,
//	    func(page *connect.ListInstanceAttributesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListInstanceAttributesPages(input *ListInstanceAttributesInput, fn func(*ListInstanceAttributesOutput, bool) bool) error {
	return c.ListInstanceAttributesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceAttributesPagesWithContext same as ListInstanceAttributesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstanceAttributesPagesWithContext(ctx aws.Context, input *ListInstanceAttributesInput, fn func(*ListInstanceAttributesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceAttributesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceAttributesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceAttributesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstanceStorageConfigs = "ListInstanceStorageConfigs"

// ListInstanceStorageConfigsRequest generates a "aws/request.Request" representing the
// client's request for the ListInstanceStorageConfigs operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstanceStorageConfigs for more information on using the ListInstanceStorageConfigs
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstanceStorageConfigsRequest method.
//	req, resp := client.ListInstanceStorageConfigsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs
func (c *Connect) ListInstanceStorageConfigsRequest(input *ListInstanceStorageConfigsInput) (req *request.Request, output *ListInstanceStorageConfigsOutput) {
	op := &request.Operation{
		Name:       opListInstanceStorageConfigs,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/storage-configs",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstanceStorageConfigsInput{}
	}

	output = &ListInstanceStorageConfigsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstanceStorageConfigs API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of storage configs for the identified instance and
// resource type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListInstanceStorageConfigs for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstanceStorageConfigs
func (c *Connect) ListInstanceStorageConfigs(input *ListInstanceStorageConfigsInput) (*ListInstanceStorageConfigsOutput, error) {
	req, out := c.ListInstanceStorageConfigsRequest(input)
	return out, req.Send()
}

// ListInstanceStorageConfigsWithContext is the same as ListInstanceStorageConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstanceStorageConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstanceStorageConfigsWithContext(ctx aws.Context, input *ListInstanceStorageConfigsInput, opts ...request.Option) (*ListInstanceStorageConfigsOutput, error) {
	req, out := c.ListInstanceStorageConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstanceStorageConfigsPages iterates over the pages of a ListInstanceStorageConfigs operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstanceStorageConfigs method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstanceStorageConfigs operation.
//	pageNum := 0
//	err := client.ListInstanceStorageConfigsPages(params,
//	    func(page *connect.ListInstanceStorageConfigsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListInstanceStorageConfigsPages(input *ListInstanceStorageConfigsInput, fn func(*ListInstanceStorageConfigsOutput, bool) bool) error {
	return c.ListInstanceStorageConfigsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstanceStorageConfigsPagesWithContext same as ListInstanceStorageConfigsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstanceStorageConfigsPagesWithContext(ctx aws.Context, input *ListInstanceStorageConfigsInput, fn func(*ListInstanceStorageConfigsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstanceStorageConfigsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstanceStorageConfigsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstanceStorageConfigsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListInstances = "ListInstances"

// ListInstancesRequest generates a "aws/request.Request" representing the
// client's request for the ListInstances operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListInstances for more information on using the ListInstances
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListInstancesRequest method.
//	req, resp := client.ListInstancesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances
func (c *Connect) ListInstancesRequest(input *ListInstancesInput) (req *request.Request, output *ListInstancesOutput) {
	op := &request.Operation{
		Name:       opListInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/instance",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListInstancesInput{}
	}

	output = &ListInstancesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListInstances API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Return a list of instances which are in active state, creation-in-progress
// state, and failed state. Instances that aren't successfully created (they
// are in a failed state) are returned only for 24 hours after the CreateInstance
// API was invoked.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListInstances for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListInstances
func (c *Connect) ListInstances(input *ListInstancesInput) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	return out, req.Send()
}

// ListInstancesWithContext is the same as ListInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstancesWithContext(ctx aws.Context, input *ListInstancesInput, opts ...request.Option) (*ListInstancesOutput, error) {
	req, out := c.ListInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListInstancesPages iterates over the pages of a ListInstances operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListInstances method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListInstances operation.
//	pageNum := 0
//	err := client.ListInstancesPages(params,
//	    func(page *connect.ListInstancesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListInstancesPages(input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool) error {
	return c.ListInstancesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListInstancesPagesWithContext same as ListInstancesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListInstancesPagesWithContext(ctx aws.Context, input *ListInstancesInput, fn func(*ListInstancesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListInstancesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListInstancesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListInstancesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListIntegrationAssociations = "ListIntegrationAssociations"

// ListIntegrationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListIntegrationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListIntegrationAssociations for more information on using the ListIntegrationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListIntegrationAssociationsRequest method.
//	req, resp := client.ListIntegrationAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations
func (c *Connect) ListIntegrationAssociationsRequest(input *ListIntegrationAssociationsInput) (req *request.Request, output *ListIntegrationAssociationsOutput) {
	op := &request.Operation{
		Name:       opListIntegrationAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/integration-associations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListIntegrationAssociationsInput{}
	}

	output = &ListIntegrationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListIntegrationAssociations API operation for Amazon Connect Service.
//
// Provides summary information about the Amazon Web Services resource associations
// for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListIntegrationAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListIntegrationAssociations
func (c *Connect) ListIntegrationAssociations(input *ListIntegrationAssociationsInput) (*ListIntegrationAssociationsOutput, error) {
	req, out := c.ListIntegrationAssociationsRequest(input)
	return out, req.Send()
}

// ListIntegrationAssociationsWithContext is the same as ListIntegrationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListIntegrationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListIntegrationAssociationsWithContext(ctx aws.Context, input *ListIntegrationAssociationsInput, opts ...request.Option) (*ListIntegrationAssociationsOutput, error) {
	req, out := c.ListIntegrationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListIntegrationAssociationsPages iterates over the pages of a ListIntegrationAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListIntegrationAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListIntegrationAssociations operation.
//	pageNum := 0
//	err := client.ListIntegrationAssociationsPages(params,
//	    func(page *connect.ListIntegrationAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListIntegrationAssociationsPages(input *ListIntegrationAssociationsInput, fn func(*ListIntegrationAssociationsOutput, bool) bool) error {
	return c.ListIntegrationAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListIntegrationAssociationsPagesWithContext same as ListIntegrationAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListIntegrationAssociationsPagesWithContext(ctx aws.Context, input *ListIntegrationAssociationsInput, fn func(*ListIntegrationAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListIntegrationAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListIntegrationAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListIntegrationAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLambdaFunctions = "ListLambdaFunctions"

// ListLambdaFunctionsRequest generates a "aws/request.Request" representing the
// client's request for the ListLambdaFunctions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLambdaFunctions for more information on using the ListLambdaFunctions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLambdaFunctionsRequest method.
//	req, resp := client.ListLambdaFunctionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions
func (c *Connect) ListLambdaFunctionsRequest(input *ListLambdaFunctionsInput) (req *request.Request, output *ListLambdaFunctionsOutput) {
	op := &request.Operation{
		Name:       opListLambdaFunctions,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/lambda-functions",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLambdaFunctionsInput{}
	}

	output = &ListLambdaFunctionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLambdaFunctions API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of all Lambda functions that display in the dropdown
// options in the relevant flow blocks.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListLambdaFunctions for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLambdaFunctions
func (c *Connect) ListLambdaFunctions(input *ListLambdaFunctionsInput) (*ListLambdaFunctionsOutput, error) {
	req, out := c.ListLambdaFunctionsRequest(input)
	return out, req.Send()
}

// ListLambdaFunctionsWithContext is the same as ListLambdaFunctions with the addition of
// the ability to pass a context and additional request options.
//
// See ListLambdaFunctions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListLambdaFunctionsWithContext(ctx aws.Context, input *ListLambdaFunctionsInput, opts ...request.Option) (*ListLambdaFunctionsOutput, error) {
	req, out := c.ListLambdaFunctionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLambdaFunctionsPages iterates over the pages of a ListLambdaFunctions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLambdaFunctions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLambdaFunctions operation.
//	pageNum := 0
//	err := client.ListLambdaFunctionsPages(params,
//	    func(page *connect.ListLambdaFunctionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListLambdaFunctionsPages(input *ListLambdaFunctionsInput, fn func(*ListLambdaFunctionsOutput, bool) bool) error {
	return c.ListLambdaFunctionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLambdaFunctionsPagesWithContext same as ListLambdaFunctionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListLambdaFunctionsPagesWithContext(ctx aws.Context, input *ListLambdaFunctionsInput, fn func(*ListLambdaFunctionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLambdaFunctionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLambdaFunctionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLambdaFunctionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListLexBots = "ListLexBots"

// ListLexBotsRequest generates a "aws/request.Request" representing the
// client's request for the ListLexBots operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListLexBots for more information on using the ListLexBots
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListLexBotsRequest method.
//	req, resp := client.ListLexBotsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots
func (c *Connect) ListLexBotsRequest(input *ListLexBotsInput) (req *request.Request, output *ListLexBotsOutput) {
	op := &request.Operation{
		Name:       opListLexBots,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/lex-bots",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListLexBotsInput{}
	}

	output = &ListLexBotsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListLexBots API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of all the Amazon Lex V1 bots currently associated
// with the instance. To return both Amazon Lex V1 and V2 bots, use the ListBots
// (https://docs.aws.amazon.com/connect/latest/APIReference/API_ListBots.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListLexBots for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListLexBots
func (c *Connect) ListLexBots(input *ListLexBotsInput) (*ListLexBotsOutput, error) {
	req, out := c.ListLexBotsRequest(input)
	return out, req.Send()
}

// ListLexBotsWithContext is the same as ListLexBots with the addition of
// the ability to pass a context and additional request options.
//
// See ListLexBots for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListLexBotsWithContext(ctx aws.Context, input *ListLexBotsInput, opts ...request.Option) (*ListLexBotsOutput, error) {
	req, out := c.ListLexBotsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListLexBotsPages iterates over the pages of a ListLexBots operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListLexBots method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListLexBots operation.
//	pageNum := 0
//	err := client.ListLexBotsPages(params,
//	    func(page *connect.ListLexBotsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListLexBotsPages(input *ListLexBotsInput, fn func(*ListLexBotsOutput, bool) bool) error {
	return c.ListLexBotsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListLexBotsPagesWithContext same as ListLexBotsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListLexBotsPagesWithContext(ctx aws.Context, input *ListLexBotsInput, fn func(*ListLexBotsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListLexBotsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListLexBotsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListLexBotsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbers = "ListPhoneNumbers"

// ListPhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbers for more information on using the ListPhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumbersRequest method.
//	req, resp := client.ListPhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers
func (c *Connect) ListPhoneNumbersRequest(input *ListPhoneNumbersInput) (req *request.Request, output *ListPhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opListPhoneNumbers,
		HTTPMethod: "GET",
		HTTPPath:   "/phone-numbers-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersInput{}
	}

	output = &ListPhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbers API operation for Amazon Connect Service.
//
// Provides information about the phone numbers for the specified Amazon Connect
// instance.
//
// For more information about phone numbers, see Set Up Phone Numbers for Your
// Contact Center (https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html)
// in the Amazon Connect Administrator Guide.
//
// The phone number Arn value that is returned from each of the items in the
// PhoneNumberSummaryList (https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbers.html#connect-ListPhoneNumbers-response-PhoneNumberSummaryList)
// cannot be used to tag phone number resources. It will fail with a ResourceNotFoundException.
// Instead, use the ListPhoneNumbersV2 (https://docs.aws.amazon.com/connect/latest/APIReference/API_ListPhoneNumbersV2.html)
// API. It returns the new phone number ARN that can be used to tag phone number
// resources.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListPhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbers
func (c *Connect) ListPhoneNumbers(input *ListPhoneNumbersInput) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	return out, req.Send()
}

// ListPhoneNumbersWithContext is the same as ListPhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersWithContext(ctx aws.Context, input *ListPhoneNumbersInput, opts ...request.Option) (*ListPhoneNumbersOutput, error) {
	req, out := c.ListPhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersPages iterates over the pages of a ListPhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumbers operation.
//	pageNum := 0
//	err := client.ListPhoneNumbersPages(params,
//	    func(page *connect.ListPhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListPhoneNumbersPages(input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool) error {
	return c.ListPhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersPagesWithContext same as ListPhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersPagesWithContext(ctx aws.Context, input *ListPhoneNumbersInput, fn func(*ListPhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPhoneNumbersV2 = "ListPhoneNumbersV2"

// ListPhoneNumbersV2Request generates a "aws/request.Request" representing the
// client's request for the ListPhoneNumbersV2 operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPhoneNumbersV2 for more information on using the ListPhoneNumbersV2
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPhoneNumbersV2Request method.
//	req, resp := client.ListPhoneNumbersV2Request(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2
func (c *Connect) ListPhoneNumbersV2Request(input *ListPhoneNumbersV2Input) (req *request.Request, output *ListPhoneNumbersV2Output) {
	op := &request.Operation{
		Name:       opListPhoneNumbersV2,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number/list",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPhoneNumbersV2Input{}
	}

	output = &ListPhoneNumbersV2Output{}
	req = c.newRequest(op, input, output)
	return
}

// ListPhoneNumbersV2 API operation for Amazon Connect Service.
//
// Lists phone numbers claimed to your Amazon Connect instance or traffic distribution
// group. If the provided TargetArn is a traffic distribution group, you can
// call this API in both Amazon Web Services Regions associated with traffic
// distribution group.
//
// For more information about phone numbers, see Set Up Phone Numbers for Your
// Contact Center (https://docs.aws.amazon.com/connect/latest/adminguide/contact-center-phone-number.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListPhoneNumbersV2 for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPhoneNumbersV2
func (c *Connect) ListPhoneNumbersV2(input *ListPhoneNumbersV2Input) (*ListPhoneNumbersV2Output, error) {
	req, out := c.ListPhoneNumbersV2Request(input)
	return out, req.Send()
}

// ListPhoneNumbersV2WithContext is the same as ListPhoneNumbersV2 with the addition of
// the ability to pass a context and additional request options.
//
// See ListPhoneNumbersV2 for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersV2WithContext(ctx aws.Context, input *ListPhoneNumbersV2Input, opts ...request.Option) (*ListPhoneNumbersV2Output, error) {
	req, out := c.ListPhoneNumbersV2Request(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPhoneNumbersV2Pages iterates over the pages of a ListPhoneNumbersV2 operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPhoneNumbersV2 method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPhoneNumbersV2 operation.
//	pageNum := 0
//	err := client.ListPhoneNumbersV2Pages(params,
//	    func(page *connect.ListPhoneNumbersV2Output, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListPhoneNumbersV2Pages(input *ListPhoneNumbersV2Input, fn func(*ListPhoneNumbersV2Output, bool) bool) error {
	return c.ListPhoneNumbersV2PagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPhoneNumbersV2PagesWithContext same as ListPhoneNumbersV2Pages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPhoneNumbersV2PagesWithContext(ctx aws.Context, input *ListPhoneNumbersV2Input, fn func(*ListPhoneNumbersV2Output, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPhoneNumbersV2Input
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPhoneNumbersV2Request(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPhoneNumbersV2Output), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListPrompts = "ListPrompts"

// ListPromptsRequest generates a "aws/request.Request" representing the
// client's request for the ListPrompts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListPrompts for more information on using the ListPrompts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListPromptsRequest method.
//	req, resp := client.ListPromptsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts
func (c *Connect) ListPromptsRequest(input *ListPromptsInput) (req *request.Request, output *ListPromptsOutput) {
	op := &request.Operation{
		Name:       opListPrompts,
		HTTPMethod: "GET",
		HTTPPath:   "/prompts-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListPromptsInput{}
	}

	output = &ListPromptsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListPrompts API operation for Amazon Connect Service.
//
// Provides information about the prompts for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListPrompts for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListPrompts
func (c *Connect) ListPrompts(input *ListPromptsInput) (*ListPromptsOutput, error) {
	req, out := c.ListPromptsRequest(input)
	return out, req.Send()
}

// ListPromptsWithContext is the same as ListPrompts with the addition of
// the ability to pass a context and additional request options.
//
// See ListPrompts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPromptsWithContext(ctx aws.Context, input *ListPromptsInput, opts ...request.Option) (*ListPromptsOutput, error) {
	req, out := c.ListPromptsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListPromptsPages iterates over the pages of a ListPrompts operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListPrompts method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListPrompts operation.
//	pageNum := 0
//	err := client.ListPromptsPages(params,
//	    func(page *connect.ListPromptsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListPromptsPages(input *ListPromptsInput, fn func(*ListPromptsOutput, bool) bool) error {
	return c.ListPromptsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListPromptsPagesWithContext same as ListPromptsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListPromptsPagesWithContext(ctx aws.Context, input *ListPromptsInput, fn func(*ListPromptsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListPromptsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListPromptsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListPromptsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueueQuickConnects = "ListQueueQuickConnects"

// ListQueueQuickConnectsRequest generates a "aws/request.Request" representing the
// client's request for the ListQueueQuickConnects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueueQuickConnects for more information on using the ListQueueQuickConnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueueQuickConnectsRequest method.
//	req, resp := client.ListQueueQuickConnectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects
func (c *Connect) ListQueueQuickConnectsRequest(input *ListQueueQuickConnectsInput) (req *request.Request, output *ListQueueQuickConnectsOutput) {
	op := &request.Operation{
		Name:       opListQueueQuickConnects,
		HTTPMethod: "GET",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/quick-connects",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueueQuickConnectsInput{}
	}

	output = &ListQueueQuickConnectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueueQuickConnects API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Lists the quick connects associated with a queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListQueueQuickConnects for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueueQuickConnects
func (c *Connect) ListQueueQuickConnects(input *ListQueueQuickConnectsInput) (*ListQueueQuickConnectsOutput, error) {
	req, out := c.ListQueueQuickConnectsRequest(input)
	return out, req.Send()
}

// ListQueueQuickConnectsWithContext is the same as ListQueueQuickConnects with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueueQuickConnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueueQuickConnectsWithContext(ctx aws.Context, input *ListQueueQuickConnectsInput, opts ...request.Option) (*ListQueueQuickConnectsOutput, error) {
	req, out := c.ListQueueQuickConnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueueQuickConnectsPages iterates over the pages of a ListQueueQuickConnects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueueQuickConnects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueueQuickConnects operation.
//	pageNum := 0
//	err := client.ListQueueQuickConnectsPages(params,
//	    func(page *connect.ListQueueQuickConnectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListQueueQuickConnectsPages(input *ListQueueQuickConnectsInput, fn func(*ListQueueQuickConnectsOutput, bool) bool) error {
	return c.ListQueueQuickConnectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueueQuickConnectsPagesWithContext same as ListQueueQuickConnectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueueQuickConnectsPagesWithContext(ctx aws.Context, input *ListQueueQuickConnectsInput, fn func(*ListQueueQuickConnectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueueQuickConnectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueueQuickConnectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueueQuickConnectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQueues = "ListQueues"

// ListQueuesRequest generates a "aws/request.Request" representing the
// client's request for the ListQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQueues for more information on using the ListQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQueuesRequest method.
//	req, resp := client.ListQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues
func (c *Connect) ListQueuesRequest(input *ListQueuesInput) (req *request.Request, output *ListQueuesOutput) {
	op := &request.Operation{
		Name:       opListQueues,
		HTTPMethod: "GET",
		HTTPPath:   "/queues-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQueuesInput{}
	}

	output = &ListQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQueues API operation for Amazon Connect Service.
//
// Provides information about the queues for the specified Amazon Connect instance.
//
// If you do not specify a QueueTypes parameter, both standard and agent queues
// are returned. This might cause an unexpected truncation of results if you
// have more than 1000 agents and you limit the number of results of the API
// call in code.
//
// For more information about queues, see Queues: Standard and Agent (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-queues-standard-and-agent.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQueues
func (c *Connect) ListQueues(input *ListQueuesInput) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	return out, req.Send()
}

// ListQueuesWithContext is the same as ListQueues with the addition of
// the ability to pass a context and additional request options.
//
// See ListQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueuesWithContext(ctx aws.Context, input *ListQueuesInput, opts ...request.Option) (*ListQueuesOutput, error) {
	req, out := c.ListQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQueuesPages iterates over the pages of a ListQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQueues operation.
//	pageNum := 0
//	err := client.ListQueuesPages(params,
//	    func(page *connect.ListQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListQueuesPages(input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool) error {
	return c.ListQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQueuesPagesWithContext same as ListQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQueuesPagesWithContext(ctx aws.Context, input *ListQueuesInput, fn func(*ListQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListQuickConnects = "ListQuickConnects"

// ListQuickConnectsRequest generates a "aws/request.Request" representing the
// client's request for the ListQuickConnects operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListQuickConnects for more information on using the ListQuickConnects
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListQuickConnectsRequest method.
//	req, resp := client.ListQuickConnectsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects
func (c *Connect) ListQuickConnectsRequest(input *ListQuickConnectsInput) (req *request.Request, output *ListQuickConnectsOutput) {
	op := &request.Operation{
		Name:       opListQuickConnects,
		HTTPMethod: "GET",
		HTTPPath:   "/quick-connects/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListQuickConnectsInput{}
	}

	output = &ListQuickConnectsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListQuickConnects API operation for Amazon Connect Service.
//
// Provides information about the quick connects for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListQuickConnects for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListQuickConnects
func (c *Connect) ListQuickConnects(input *ListQuickConnectsInput) (*ListQuickConnectsOutput, error) {
	req, out := c.ListQuickConnectsRequest(input)
	return out, req.Send()
}

// ListQuickConnectsWithContext is the same as ListQuickConnects with the addition of
// the ability to pass a context and additional request options.
//
// See ListQuickConnects for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQuickConnectsWithContext(ctx aws.Context, input *ListQuickConnectsInput, opts ...request.Option) (*ListQuickConnectsOutput, error) {
	req, out := c.ListQuickConnectsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListQuickConnectsPages iterates over the pages of a ListQuickConnects operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListQuickConnects method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListQuickConnects operation.
//	pageNum := 0
//	err := client.ListQuickConnectsPages(params,
//	    func(page *connect.ListQuickConnectsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListQuickConnectsPages(input *ListQuickConnectsInput, fn func(*ListQuickConnectsOutput, bool) bool) error {
	return c.ListQuickConnectsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListQuickConnectsPagesWithContext same as ListQuickConnectsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListQuickConnectsPagesWithContext(ctx aws.Context, input *ListQuickConnectsInput, fn func(*ListQuickConnectsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListQuickConnectsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListQuickConnectsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListQuickConnectsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutingProfileQueues = "ListRoutingProfileQueues"

// ListRoutingProfileQueuesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingProfileQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingProfileQueues for more information on using the ListRoutingProfileQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoutingProfileQueuesRequest method.
//	req, resp := client.ListRoutingProfileQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues
func (c *Connect) ListRoutingProfileQueuesRequest(input *ListRoutingProfileQueuesInput) (req *request.Request, output *ListRoutingProfileQueuesOutput) {
	op := &request.Operation{
		Name:       opListRoutingProfileQueues,
		HTTPMethod: "GET",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/queues",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutingProfileQueuesInput{}
	}

	output = &ListRoutingProfileQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingProfileQueues API operation for Amazon Connect Service.
//
// Lists the queues associated with a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListRoutingProfileQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfileQueues
func (c *Connect) ListRoutingProfileQueues(input *ListRoutingProfileQueuesInput) (*ListRoutingProfileQueuesOutput, error) {
	req, out := c.ListRoutingProfileQueuesRequest(input)
	return out, req.Send()
}

// ListRoutingProfileQueuesWithContext is the same as ListRoutingProfileQueues with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingProfileQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfileQueuesWithContext(ctx aws.Context, input *ListRoutingProfileQueuesInput, opts ...request.Option) (*ListRoutingProfileQueuesOutput, error) {
	req, out := c.ListRoutingProfileQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutingProfileQueuesPages iterates over the pages of a ListRoutingProfileQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutingProfileQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoutingProfileQueues operation.
//	pageNum := 0
//	err := client.ListRoutingProfileQueuesPages(params,
//	    func(page *connect.ListRoutingProfileQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListRoutingProfileQueuesPages(input *ListRoutingProfileQueuesInput, fn func(*ListRoutingProfileQueuesOutput, bool) bool) error {
	return c.ListRoutingProfileQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutingProfileQueuesPagesWithContext same as ListRoutingProfileQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfileQueuesPagesWithContext(ctx aws.Context, input *ListRoutingProfileQueuesInput, fn func(*ListRoutingProfileQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutingProfileQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutingProfileQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutingProfileQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRoutingProfiles = "ListRoutingProfiles"

// ListRoutingProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListRoutingProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRoutingProfiles for more information on using the ListRoutingProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRoutingProfilesRequest method.
//	req, resp := client.ListRoutingProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfilesRequest(input *ListRoutingProfilesInput) (req *request.Request, output *ListRoutingProfilesOutput) {
	op := &request.Operation{
		Name:       opListRoutingProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/routing-profiles-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRoutingProfilesInput{}
	}

	output = &ListRoutingProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRoutingProfiles API operation for Amazon Connect Service.
//
// Provides summary information about the routing profiles for the specified
// Amazon Connect instance.
//
// For more information about routing profiles, see Routing Profiles (https://docs.aws.amazon.com/connect/latest/adminguide/concepts-routing.html)
// and Create a Routing Profile (https://docs.aws.amazon.com/connect/latest/adminguide/routing-profiles.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListRoutingProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRoutingProfiles
func (c *Connect) ListRoutingProfiles(input *ListRoutingProfilesInput) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	return out, req.Send()
}

// ListRoutingProfilesWithContext is the same as ListRoutingProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListRoutingProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfilesWithContext(ctx aws.Context, input *ListRoutingProfilesInput, opts ...request.Option) (*ListRoutingProfilesOutput, error) {
	req, out := c.ListRoutingProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRoutingProfilesPages iterates over the pages of a ListRoutingProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRoutingProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRoutingProfiles operation.
//	pageNum := 0
//	err := client.ListRoutingProfilesPages(params,
//	    func(page *connect.ListRoutingProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListRoutingProfilesPages(input *ListRoutingProfilesInput, fn func(*ListRoutingProfilesOutput, bool) bool) error {
	return c.ListRoutingProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRoutingProfilesPagesWithContext same as ListRoutingProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRoutingProfilesPagesWithContext(ctx aws.Context, input *ListRoutingProfilesInput, fn func(*ListRoutingProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRoutingProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRoutingProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRoutingProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListRules = "ListRules"

// ListRulesRequest generates a "aws/request.Request" representing the
// client's request for the ListRules operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListRules for more information on using the ListRules
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListRulesRequest method.
//	req, resp := client.ListRulesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRules
func (c *Connect) ListRulesRequest(input *ListRulesInput) (req *request.Request, output *ListRulesOutput) {
	op := &request.Operation{
		Name:       opListRules,
		HTTPMethod: "GET",
		HTTPPath:   "/rules/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListRulesInput{}
	}

	output = &ListRulesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListRules API operation for Amazon Connect Service.
//
// List all rules for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListRules for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListRules
func (c *Connect) ListRules(input *ListRulesInput) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	return out, req.Send()
}

// ListRulesWithContext is the same as ListRules with the addition of
// the ability to pass a context and additional request options.
//
// See ListRules for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRulesWithContext(ctx aws.Context, input *ListRulesInput, opts ...request.Option) (*ListRulesOutput, error) {
	req, out := c.ListRulesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListRulesPages iterates over the pages of a ListRules operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListRules method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListRules operation.
//	pageNum := 0
//	err := client.ListRulesPages(params,
//	    func(page *connect.ListRulesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListRulesPages(input *ListRulesInput, fn func(*ListRulesOutput, bool) bool) error {
	return c.ListRulesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListRulesPagesWithContext same as ListRulesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListRulesPagesWithContext(ctx aws.Context, input *ListRulesInput, fn func(*ListRulesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListRulesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListRulesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListRulesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityKeys = "ListSecurityKeys"

// ListSecurityKeysRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityKeys operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityKeys for more information on using the ListSecurityKeys
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityKeysRequest method.
//	req, resp := client.ListSecurityKeysRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys
func (c *Connect) ListSecurityKeysRequest(input *ListSecurityKeysInput) (req *request.Request, output *ListSecurityKeysOutput) {
	op := &request.Operation{
		Name:       opListSecurityKeys,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/security-keys",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityKeysInput{}
	}

	output = &ListSecurityKeysOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityKeys API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Returns a paginated list of all security keys associated with the instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListSecurityKeys for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityKeys
func (c *Connect) ListSecurityKeys(input *ListSecurityKeysInput) (*ListSecurityKeysOutput, error) {
	req, out := c.ListSecurityKeysRequest(input)
	return out, req.Send()
}

// ListSecurityKeysWithContext is the same as ListSecurityKeys with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityKeys for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityKeysWithContext(ctx aws.Context, input *ListSecurityKeysInput, opts ...request.Option) (*ListSecurityKeysOutput, error) {
	req, out := c.ListSecurityKeysRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityKeysPages iterates over the pages of a ListSecurityKeys operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityKeys method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityKeys operation.
//	pageNum := 0
//	err := client.ListSecurityKeysPages(params,
//	    func(page *connect.ListSecurityKeysOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListSecurityKeysPages(input *ListSecurityKeysInput, fn func(*ListSecurityKeysOutput, bool) bool) error {
	return c.ListSecurityKeysPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityKeysPagesWithContext same as ListSecurityKeysPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityKeysPagesWithContext(ctx aws.Context, input *ListSecurityKeysInput, fn func(*ListSecurityKeysOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityKeysInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityKeysRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityKeysOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityProfilePermissions = "ListSecurityProfilePermissions"

// ListSecurityProfilePermissionsRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfilePermissions operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfilePermissions for more information on using the ListSecurityProfilePermissions
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityProfilePermissionsRequest method.
//	req, resp := client.ListSecurityProfilePermissionsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions
func (c *Connect) ListSecurityProfilePermissionsRequest(input *ListSecurityProfilePermissionsInput) (req *request.Request, output *ListSecurityProfilePermissionsOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfilePermissions,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-permissions/{InstanceId}/{SecurityProfileId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityProfilePermissionsInput{}
	}

	output = &ListSecurityProfilePermissionsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfilePermissions API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Lists the permissions granted to a security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListSecurityProfilePermissions for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfilePermissions
func (c *Connect) ListSecurityProfilePermissions(input *ListSecurityProfilePermissionsInput) (*ListSecurityProfilePermissionsOutput, error) {
	req, out := c.ListSecurityProfilePermissionsRequest(input)
	return out, req.Send()
}

// ListSecurityProfilePermissionsWithContext is the same as ListSecurityProfilePermissions with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfilePermissions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilePermissionsWithContext(ctx aws.Context, input *ListSecurityProfilePermissionsInput, opts ...request.Option) (*ListSecurityProfilePermissionsOutput, error) {
	req, out := c.ListSecurityProfilePermissionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityProfilePermissionsPages iterates over the pages of a ListSecurityProfilePermissions operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityProfilePermissions method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityProfilePermissions operation.
//	pageNum := 0
//	err := client.ListSecurityProfilePermissionsPages(params,
//	    func(page *connect.ListSecurityProfilePermissionsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListSecurityProfilePermissionsPages(input *ListSecurityProfilePermissionsInput, fn func(*ListSecurityProfilePermissionsOutput, bool) bool) error {
	return c.ListSecurityProfilePermissionsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityProfilePermissionsPagesWithContext same as ListSecurityProfilePermissionsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilePermissionsPagesWithContext(ctx aws.Context, input *ListSecurityProfilePermissionsInput, fn func(*ListSecurityProfilePermissionsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityProfilePermissionsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityProfilePermissionsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityProfilePermissionsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListSecurityProfiles = "ListSecurityProfiles"

// ListSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListSecurityProfiles for more information on using the ListSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListSecurityProfilesRequest method.
//	req, resp := client.ListSecurityProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfilesRequest(input *ListSecurityProfilesInput) (req *request.Request, output *ListSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opListSecurityProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/security-profiles-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListSecurityProfilesInput{}
	}

	output = &ListSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListSecurityProfiles API operation for Amazon Connect Service.
//
// Provides summary information about the security profiles for the specified
// Amazon Connect instance.
//
// For more information about security profiles, see Security Profiles (https://docs.aws.amazon.com/connect/latest/adminguide/connect-security-profiles.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListSecurityProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListSecurityProfiles
func (c *Connect) ListSecurityProfiles(input *ListSecurityProfilesInput) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	return out, req.Send()
}

// ListSecurityProfilesWithContext is the same as ListSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, opts ...request.Option) (*ListSecurityProfilesOutput, error) {
	req, out := c.ListSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListSecurityProfilesPages iterates over the pages of a ListSecurityProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListSecurityProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListSecurityProfiles operation.
//	pageNum := 0
//	err := client.ListSecurityProfilesPages(params,
//	    func(page *connect.ListSecurityProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListSecurityProfilesPages(input *ListSecurityProfilesInput, fn func(*ListSecurityProfilesOutput, bool) bool) error {
	return c.ListSecurityProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListSecurityProfilesPagesWithContext same as ListSecurityProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListSecurityProfilesPagesWithContext(ctx aws.Context, input *ListSecurityProfilesInput, fn func(*ListSecurityProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListSecurityProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListSecurityProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListSecurityProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource
func (c *Connect) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon Connect Service.
//
// Lists the tags for the specified resource.
//
// For sample policies that use tags, see Amazon Connect Identity-Based Policy
// Examples (https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTagsForResource
func (c *Connect) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTaskTemplates = "ListTaskTemplates"

// ListTaskTemplatesRequest generates a "aws/request.Request" representing the
// client's request for the ListTaskTemplates operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTaskTemplates for more information on using the ListTaskTemplates
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTaskTemplatesRequest method.
//	req, resp := client.ListTaskTemplatesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTaskTemplates
func (c *Connect) ListTaskTemplatesRequest(input *ListTaskTemplatesInput) (req *request.Request, output *ListTaskTemplatesOutput) {
	op := &request.Operation{
		Name:       opListTaskTemplates,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/task/template",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTaskTemplatesInput{}
	}

	output = &ListTaskTemplatesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTaskTemplates API operation for Amazon Connect Service.
//
// Lists task templates for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListTaskTemplates for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTaskTemplates
func (c *Connect) ListTaskTemplates(input *ListTaskTemplatesInput) (*ListTaskTemplatesOutput, error) {
	req, out := c.ListTaskTemplatesRequest(input)
	return out, req.Send()
}

// ListTaskTemplatesWithContext is the same as ListTaskTemplates with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskTemplates for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTaskTemplatesWithContext(ctx aws.Context, input *ListTaskTemplatesInput, opts ...request.Option) (*ListTaskTemplatesOutput, error) {
	req, out := c.ListTaskTemplatesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTaskTemplatesPages iterates over the pages of a ListTaskTemplates operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTaskTemplates method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTaskTemplates operation.
//	pageNum := 0
//	err := client.ListTaskTemplatesPages(params,
//	    func(page *connect.ListTaskTemplatesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListTaskTemplatesPages(input *ListTaskTemplatesInput, fn func(*ListTaskTemplatesOutput, bool) bool) error {
	return c.ListTaskTemplatesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTaskTemplatesPagesWithContext same as ListTaskTemplatesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTaskTemplatesPagesWithContext(ctx aws.Context, input *ListTaskTemplatesInput, fn func(*ListTaskTemplatesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTaskTemplatesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTaskTemplatesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTaskTemplatesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTrafficDistributionGroups = "ListTrafficDistributionGroups"

// ListTrafficDistributionGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListTrafficDistributionGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTrafficDistributionGroups for more information on using the ListTrafficDistributionGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTrafficDistributionGroupsRequest method.
//	req, resp := client.ListTrafficDistributionGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTrafficDistributionGroups
func (c *Connect) ListTrafficDistributionGroupsRequest(input *ListTrafficDistributionGroupsInput) (req *request.Request, output *ListTrafficDistributionGroupsOutput) {
	op := &request.Operation{
		Name:       opListTrafficDistributionGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/traffic-distribution-groups",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListTrafficDistributionGroupsInput{}
	}

	output = &ListTrafficDistributionGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTrafficDistributionGroups API operation for Amazon Connect Service.
//
// Lists traffic distribution groups.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListTrafficDistributionGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListTrafficDistributionGroups
func (c *Connect) ListTrafficDistributionGroups(input *ListTrafficDistributionGroupsInput) (*ListTrafficDistributionGroupsOutput, error) {
	req, out := c.ListTrafficDistributionGroupsRequest(input)
	return out, req.Send()
}

// ListTrafficDistributionGroupsWithContext is the same as ListTrafficDistributionGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListTrafficDistributionGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTrafficDistributionGroupsWithContext(ctx aws.Context, input *ListTrafficDistributionGroupsInput, opts ...request.Option) (*ListTrafficDistributionGroupsOutput, error) {
	req, out := c.ListTrafficDistributionGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListTrafficDistributionGroupsPages iterates over the pages of a ListTrafficDistributionGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListTrafficDistributionGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListTrafficDistributionGroups operation.
//	pageNum := 0
//	err := client.ListTrafficDistributionGroupsPages(params,
//	    func(page *connect.ListTrafficDistributionGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListTrafficDistributionGroupsPages(input *ListTrafficDistributionGroupsInput, fn func(*ListTrafficDistributionGroupsOutput, bool) bool) error {
	return c.ListTrafficDistributionGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListTrafficDistributionGroupsPagesWithContext same as ListTrafficDistributionGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListTrafficDistributionGroupsPagesWithContext(ctx aws.Context, input *ListTrafficDistributionGroupsInput, fn func(*ListTrafficDistributionGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListTrafficDistributionGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListTrafficDistributionGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListTrafficDistributionGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUseCases = "ListUseCases"

// ListUseCasesRequest generates a "aws/request.Request" representing the
// client's request for the ListUseCases operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUseCases for more information on using the ListUseCases
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUseCasesRequest method.
//	req, resp := client.ListUseCasesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases
func (c *Connect) ListUseCasesRequest(input *ListUseCasesInput) (req *request.Request, output *ListUseCasesOutput) {
	op := &request.Operation{
		Name:       opListUseCases,
		HTTPMethod: "GET",
		HTTPPath:   "/instance/{InstanceId}/integration-associations/{IntegrationAssociationId}/use-cases",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUseCasesInput{}
	}

	output = &ListUseCasesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUseCases API operation for Amazon Connect Service.
//
// Lists the use cases for the integration association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUseCases for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUseCases
func (c *Connect) ListUseCases(input *ListUseCasesInput) (*ListUseCasesOutput, error) {
	req, out := c.ListUseCasesRequest(input)
	return out, req.Send()
}

// ListUseCasesWithContext is the same as ListUseCases with the addition of
// the ability to pass a context and additional request options.
//
// See ListUseCases for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUseCasesWithContext(ctx aws.Context, input *ListUseCasesInput, opts ...request.Option) (*ListUseCasesOutput, error) {
	req, out := c.ListUseCasesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUseCasesPages iterates over the pages of a ListUseCases operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUseCases method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUseCases operation.
//	pageNum := 0
//	err := client.ListUseCasesPages(params,
//	    func(page *connect.ListUseCasesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListUseCasesPages(input *ListUseCasesInput, fn func(*ListUseCasesOutput, bool) bool) error {
	return c.ListUseCasesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUseCasesPagesWithContext same as ListUseCasesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUseCasesPagesWithContext(ctx aws.Context, input *ListUseCasesInput, fn func(*ListUseCasesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUseCasesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUseCasesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUseCasesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUserHierarchyGroups = "ListUserHierarchyGroups"

// ListUserHierarchyGroupsRequest generates a "aws/request.Request" representing the
// client's request for the ListUserHierarchyGroups operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUserHierarchyGroups for more information on using the ListUserHierarchyGroups
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUserHierarchyGroupsRequest method.
//	req, resp := client.ListUserHierarchyGroupsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroupsRequest(input *ListUserHierarchyGroupsInput) (req *request.Request, output *ListUserHierarchyGroupsOutput) {
	op := &request.Operation{
		Name:       opListUserHierarchyGroups,
		HTTPMethod: "GET",
		HTTPPath:   "/user-hierarchy-groups-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUserHierarchyGroupsInput{}
	}

	output = &ListUserHierarchyGroupsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUserHierarchyGroups API operation for Amazon Connect Service.
//
// Provides summary information about the hierarchy groups for the specified
// Amazon Connect instance.
//
// For more information about agent hierarchies, see Set Up Agent Hierarchies
// (https://docs.aws.amazon.com/connect/latest/adminguide/agent-hierarchy.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUserHierarchyGroups for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUserHierarchyGroups
func (c *Connect) ListUserHierarchyGroups(input *ListUserHierarchyGroupsInput) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	return out, req.Send()
}

// ListUserHierarchyGroupsWithContext is the same as ListUserHierarchyGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListUserHierarchyGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUserHierarchyGroupsWithContext(ctx aws.Context, input *ListUserHierarchyGroupsInput, opts ...request.Option) (*ListUserHierarchyGroupsOutput, error) {
	req, out := c.ListUserHierarchyGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUserHierarchyGroupsPages iterates over the pages of a ListUserHierarchyGroups operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUserHierarchyGroups method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUserHierarchyGroups operation.
//	pageNum := 0
//	err := client.ListUserHierarchyGroupsPages(params,
//	    func(page *connect.ListUserHierarchyGroupsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListUserHierarchyGroupsPages(input *ListUserHierarchyGroupsInput, fn func(*ListUserHierarchyGroupsOutput, bool) bool) error {
	return c.ListUserHierarchyGroupsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUserHierarchyGroupsPagesWithContext same as ListUserHierarchyGroupsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUserHierarchyGroupsPagesWithContext(ctx aws.Context, input *ListUserHierarchyGroupsInput, fn func(*ListUserHierarchyGroupsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUserHierarchyGroupsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUserHierarchyGroupsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUserHierarchyGroupsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListUsers = "ListUsers"

// ListUsersRequest generates a "aws/request.Request" representing the
// client's request for the ListUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListUsers for more information on using the ListUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListUsersRequest method.
//	req, resp := client.ListUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsersRequest(input *ListUsersInput) (req *request.Request, output *ListUsersOutput) {
	op := &request.Operation{
		Name:       opListUsers,
		HTTPMethod: "GET",
		HTTPPath:   "/users-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListUsersInput{}
	}

	output = &ListUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListUsers API operation for Amazon Connect Service.
//
// Provides summary information about the users for the specified Amazon Connect
// instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ListUsers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ListUsers
func (c *Connect) ListUsers(input *ListUsersInput) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	return out, req.Send()
}

// ListUsersWithContext is the same as ListUsers with the addition of
// the ability to pass a context and additional request options.
//
// See ListUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUsersWithContext(ctx aws.Context, input *ListUsersInput, opts ...request.Option) (*ListUsersOutput, error) {
	req, out := c.ListUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListUsersPages iterates over the pages of a ListUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListUsers operation.
//	pageNum := 0
//	err := client.ListUsersPages(params,
//	    func(page *connect.ListUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) ListUsersPages(input *ListUsersInput, fn func(*ListUsersOutput, bool) bool) error {
	return c.ListUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListUsersPagesWithContext same as ListUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ListUsersPagesWithContext(ctx aws.Context, input *ListUsersInput, fn func(*ListUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opMonitorContact = "MonitorContact"

// MonitorContactRequest generates a "aws/request.Request" representing the
// client's request for the MonitorContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See MonitorContact for more information on using the MonitorContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the MonitorContactRequest method.
//	req, resp := client.MonitorContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/MonitorContact
func (c *Connect) MonitorContactRequest(input *MonitorContactInput) (req *request.Request, output *MonitorContactOutput) {
	op := &request.Operation{
		Name:       opMonitorContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/monitor",
	}

	if input == nil {
		input = &MonitorContactInput{}
	}

	output = &MonitorContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// MonitorContact API operation for Amazon Connect Service.
//
// Initiates silent monitoring of a contact. The Contact Control Panel (CCP)
// of the user specified by userId will be set to silent monitoring mode on
// the contact.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation MonitorContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/MonitorContact
func (c *Connect) MonitorContact(input *MonitorContactInput) (*MonitorContactOutput, error) {
	req, out := c.MonitorContactRequest(input)
	return out, req.Send()
}

// MonitorContactWithContext is the same as MonitorContact with the addition of
// the ability to pass a context and additional request options.
//
// See MonitorContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) MonitorContactWithContext(ctx aws.Context, input *MonitorContactInput, opts ...request.Option) (*MonitorContactOutput, error) {
	req, out := c.MonitorContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opPutUserStatus = "PutUserStatus"

// PutUserStatusRequest generates a "aws/request.Request" representing the
// client's request for the PutUserStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See PutUserStatus for more information on using the PutUserStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the PutUserStatusRequest method.
//	req, resp := client.PutUserStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/PutUserStatus
func (c *Connect) PutUserStatusRequest(input *PutUserStatusInput) (req *request.Request, output *PutUserStatusOutput) {
	op := &request.Operation{
		Name:       opPutUserStatus,
		HTTPMethod: "PUT",
		HTTPPath:   "/users/{InstanceId}/{UserId}/status",
	}

	if input == nil {
		input = &PutUserStatusInput{}
	}

	output = &PutUserStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// PutUserStatus API operation for Amazon Connect Service.
//
// Changes the current status of a user or agent in Amazon Connect. If the agent
// is currently handling a contact, this sets the agent's next status.
//
// For more information, see Agent status (https://docs.aws.amazon.com/connect/latest/adminguide/metrics-agent-status.html)
// and Set your next status (https://docs.aws.amazon.com/connect/latest/adminguide/set-next-status.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation PutUserStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/PutUserStatus
func (c *Connect) PutUserStatus(input *PutUserStatusInput) (*PutUserStatusOutput, error) {
	req, out := c.PutUserStatusRequest(input)
	return out, req.Send()
}

// PutUserStatusWithContext is the same as PutUserStatus with the addition of
// the ability to pass a context and additional request options.
//
// See PutUserStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) PutUserStatusWithContext(ctx aws.Context, input *PutUserStatusInput, opts ...request.Option) (*PutUserStatusOutput, error) {
	req, out := c.PutUserStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReleasePhoneNumber = "ReleasePhoneNumber"

// ReleasePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the ReleasePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReleasePhoneNumber for more information on using the ReleasePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReleasePhoneNumberRequest method.
//	req, resp := client.ReleasePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReleasePhoneNumber
func (c *Connect) ReleasePhoneNumberRequest(input *ReleasePhoneNumberInput) (req *request.Request, output *ReleasePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opReleasePhoneNumber,
		HTTPMethod: "DELETE",
		HTTPPath:   "/phone-number/{PhoneNumberId}",
	}

	if input == nil {
		input = &ReleasePhoneNumberInput{}
	}

	output = &ReleasePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ReleasePhoneNumber API operation for Amazon Connect Service.
//
// Releases a phone number previously claimed to an Amazon Connect instance
// or traffic distribution group. You can call this API only in the Amazon Web
// Services Region where the number was claimed.
//
// To release phone numbers from a traffic distribution group, use the ReleasePhoneNumber
// API, not the Amazon Connect console.
//
// After releasing a phone number, the phone number enters into a cooldown period
// of 30 days. It cannot be searched for or claimed again until the period has
// ended. If you accidentally release a phone number, contact Amazon Web Services
// Support.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ReleasePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReleasePhoneNumber
func (c *Connect) ReleasePhoneNumber(input *ReleasePhoneNumberInput) (*ReleasePhoneNumberOutput, error) {
	req, out := c.ReleasePhoneNumberRequest(input)
	return out, req.Send()
}

// ReleasePhoneNumberWithContext is the same as ReleasePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See ReleasePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ReleasePhoneNumberWithContext(ctx aws.Context, input *ReleasePhoneNumberInput, opts ...request.Option) (*ReleasePhoneNumberOutput, error) {
	req, out := c.ReleasePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opReplicateInstance = "ReplicateInstance"

// ReplicateInstanceRequest generates a "aws/request.Request" representing the
// client's request for the ReplicateInstance operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ReplicateInstance for more information on using the ReplicateInstance
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ReplicateInstanceRequest method.
//	req, resp := client.ReplicateInstanceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReplicateInstance
func (c *Connect) ReplicateInstanceRequest(input *ReplicateInstanceInput) (req *request.Request, output *ReplicateInstanceOutput) {
	op := &request.Operation{
		Name:       opReplicateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/{InstanceId}/replicate",
	}

	if input == nil {
		input = &ReplicateInstanceInput{}
	}

	output = &ReplicateInstanceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ReplicateInstance API operation for Amazon Connect Service.
//
// Replicates an Amazon Connect instance in the specified Amazon Web Services
// Region.
//
// For more information about replicating an Amazon Connect instance, see Create
// a replica of your existing Amazon Connect instance (https://docs.aws.amazon.com/connect/latest/adminguide/create-replica-connect-instance.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ReplicateInstance for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotReadyException
//     The resource is not ready.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ReplicateInstance
func (c *Connect) ReplicateInstance(input *ReplicateInstanceInput) (*ReplicateInstanceOutput, error) {
	req, out := c.ReplicateInstanceRequest(input)
	return out, req.Send()
}

// ReplicateInstanceWithContext is the same as ReplicateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See ReplicateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ReplicateInstanceWithContext(ctx aws.Context, input *ReplicateInstanceInput, opts ...request.Option) (*ReplicateInstanceOutput, error) {
	req, out := c.ReplicateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResumeContactRecording = "ResumeContactRecording"

// ResumeContactRecordingRequest generates a "aws/request.Request" representing the
// client's request for the ResumeContactRecording operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ResumeContactRecording for more information on using the ResumeContactRecording
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ResumeContactRecordingRequest method.
//	req, resp := client.ResumeContactRecordingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ResumeContactRecording
func (c *Connect) ResumeContactRecordingRequest(input *ResumeContactRecordingInput) (req *request.Request, output *ResumeContactRecordingOutput) {
	op := &request.Operation{
		Name:       opResumeContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/resume-recording",
	}

	if input == nil {
		input = &ResumeContactRecordingInput{}
	}

	output = &ResumeContactRecordingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// ResumeContactRecording API operation for Amazon Connect Service.
//
// When a contact is being recorded, and the recording has been suspended using
// SuspendContactRecording, this API resumes recording the call.
//
// Only voice recordings are supported at this time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation ResumeContactRecording for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/ResumeContactRecording
func (c *Connect) ResumeContactRecording(input *ResumeContactRecordingInput) (*ResumeContactRecordingOutput, error) {
	req, out := c.ResumeContactRecordingRequest(input)
	return out, req.Send()
}

// ResumeContactRecordingWithContext is the same as ResumeContactRecording with the addition of
// the ability to pass a context and additional request options.
//
// See ResumeContactRecording for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) ResumeContactRecordingWithContext(ctx aws.Context, input *ResumeContactRecordingInput, opts ...request.Option) (*ResumeContactRecordingOutput, error) {
	req, out := c.ResumeContactRecordingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSearchAvailablePhoneNumbers = "SearchAvailablePhoneNumbers"

// SearchAvailablePhoneNumbersRequest generates a "aws/request.Request" representing the
// client's request for the SearchAvailablePhoneNumbers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchAvailablePhoneNumbers for more information on using the SearchAvailablePhoneNumbers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchAvailablePhoneNumbersRequest method.
//	req, resp := client.SearchAvailablePhoneNumbersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers
func (c *Connect) SearchAvailablePhoneNumbersRequest(input *SearchAvailablePhoneNumbersInput) (req *request.Request, output *SearchAvailablePhoneNumbersOutput) {
	op := &request.Operation{
		Name:       opSearchAvailablePhoneNumbers,
		HTTPMethod: "POST",
		HTTPPath:   "/phone-number/search-available",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchAvailablePhoneNumbersInput{}
	}

	output = &SearchAvailablePhoneNumbersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchAvailablePhoneNumbers API operation for Amazon Connect Service.
//
// Searches for available phone numbers that you can claim to your Amazon Connect
// instance or traffic distribution group. If the provided TargetArn is a traffic
// distribution group, you can call this API in both Amazon Web Services Regions
// associated with the traffic distribution group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchAvailablePhoneNumbers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchAvailablePhoneNumbers
func (c *Connect) SearchAvailablePhoneNumbers(input *SearchAvailablePhoneNumbersInput) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersWithContext is the same as SearchAvailablePhoneNumbers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchAvailablePhoneNumbers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchAvailablePhoneNumbersWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, opts ...request.Option) (*SearchAvailablePhoneNumbersOutput, error) {
	req, out := c.SearchAvailablePhoneNumbersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchAvailablePhoneNumbersPages iterates over the pages of a SearchAvailablePhoneNumbers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchAvailablePhoneNumbers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchAvailablePhoneNumbers operation.
//	pageNum := 0
//	err := client.SearchAvailablePhoneNumbersPages(params,
//	    func(page *connect.SearchAvailablePhoneNumbersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchAvailablePhoneNumbersPages(input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool) error {
	return c.SearchAvailablePhoneNumbersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchAvailablePhoneNumbersPagesWithContext same as SearchAvailablePhoneNumbersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchAvailablePhoneNumbersPagesWithContext(ctx aws.Context, input *SearchAvailablePhoneNumbersInput, fn func(*SearchAvailablePhoneNumbersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchAvailablePhoneNumbersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchAvailablePhoneNumbersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchAvailablePhoneNumbersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchQueues = "SearchQueues"

// SearchQueuesRequest generates a "aws/request.Request" representing the
// client's request for the SearchQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchQueues for more information on using the SearchQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchQueuesRequest method.
//	req, resp := client.SearchQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchQueues
func (c *Connect) SearchQueuesRequest(input *SearchQueuesInput) (req *request.Request, output *SearchQueuesOutput) {
	op := &request.Operation{
		Name:       opSearchQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/search-queues",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchQueuesInput{}
	}

	output = &SearchQueuesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchQueues API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Searches queues in an Amazon Connect instance, with optional filtering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchQueues
func (c *Connect) SearchQueues(input *SearchQueuesInput) (*SearchQueuesOutput, error) {
	req, out := c.SearchQueuesRequest(input)
	return out, req.Send()
}

// SearchQueuesWithContext is the same as SearchQueues with the addition of
// the ability to pass a context and additional request options.
//
// See SearchQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchQueuesWithContext(ctx aws.Context, input *SearchQueuesInput, opts ...request.Option) (*SearchQueuesOutput, error) {
	req, out := c.SearchQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchQueuesPages iterates over the pages of a SearchQueues operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchQueues method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchQueues operation.
//	pageNum := 0
//	err := client.SearchQueuesPages(params,
//	    func(page *connect.SearchQueuesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchQueuesPages(input *SearchQueuesInput, fn func(*SearchQueuesOutput, bool) bool) error {
	return c.SearchQueuesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchQueuesPagesWithContext same as SearchQueuesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchQueuesPagesWithContext(ctx aws.Context, input *SearchQueuesInput, fn func(*SearchQueuesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchQueuesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchQueuesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchQueuesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchRoutingProfiles = "SearchRoutingProfiles"

// SearchRoutingProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchRoutingProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchRoutingProfiles for more information on using the SearchRoutingProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchRoutingProfilesRequest method.
//	req, resp := client.SearchRoutingProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchRoutingProfiles
func (c *Connect) SearchRoutingProfilesRequest(input *SearchRoutingProfilesInput) (req *request.Request, output *SearchRoutingProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchRoutingProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/search-routing-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchRoutingProfilesInput{}
	}

	output = &SearchRoutingProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchRoutingProfiles API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Searches routing profiles in an Amazon Connect instance, with optional filtering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchRoutingProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchRoutingProfiles
func (c *Connect) SearchRoutingProfiles(input *SearchRoutingProfilesInput) (*SearchRoutingProfilesOutput, error) {
	req, out := c.SearchRoutingProfilesRequest(input)
	return out, req.Send()
}

// SearchRoutingProfilesWithContext is the same as SearchRoutingProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchRoutingProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchRoutingProfilesWithContext(ctx aws.Context, input *SearchRoutingProfilesInput, opts ...request.Option) (*SearchRoutingProfilesOutput, error) {
	req, out := c.SearchRoutingProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchRoutingProfilesPages iterates over the pages of a SearchRoutingProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchRoutingProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchRoutingProfiles operation.
//	pageNum := 0
//	err := client.SearchRoutingProfilesPages(params,
//	    func(page *connect.SearchRoutingProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchRoutingProfilesPages(input *SearchRoutingProfilesInput, fn func(*SearchRoutingProfilesOutput, bool) bool) error {
	return c.SearchRoutingProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchRoutingProfilesPagesWithContext same as SearchRoutingProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchRoutingProfilesPagesWithContext(ctx aws.Context, input *SearchRoutingProfilesInput, fn func(*SearchRoutingProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchRoutingProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchRoutingProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchRoutingProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchSecurityProfiles = "SearchSecurityProfiles"

// SearchSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the SearchSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchSecurityProfiles for more information on using the SearchSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchSecurityProfilesRequest method.
//	req, resp := client.SearchSecurityProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchSecurityProfiles
func (c *Connect) SearchSecurityProfilesRequest(input *SearchSecurityProfilesInput) (req *request.Request, output *SearchSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opSearchSecurityProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/search-security-profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchSecurityProfilesInput{}
	}

	output = &SearchSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchSecurityProfiles API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Searches security profiles in an Amazon Connect instance, with optional filtering.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchSecurityProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchSecurityProfiles
func (c *Connect) SearchSecurityProfiles(input *SearchSecurityProfilesInput) (*SearchSecurityProfilesOutput, error) {
	req, out := c.SearchSecurityProfilesRequest(input)
	return out, req.Send()
}

// SearchSecurityProfilesWithContext is the same as SearchSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See SearchSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchSecurityProfilesWithContext(ctx aws.Context, input *SearchSecurityProfilesInput, opts ...request.Option) (*SearchSecurityProfilesOutput, error) {
	req, out := c.SearchSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchSecurityProfilesPages iterates over the pages of a SearchSecurityProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchSecurityProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchSecurityProfiles operation.
//	pageNum := 0
//	err := client.SearchSecurityProfilesPages(params,
//	    func(page *connect.SearchSecurityProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchSecurityProfilesPages(input *SearchSecurityProfilesInput, fn func(*SearchSecurityProfilesOutput, bool) bool) error {
	return c.SearchSecurityProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchSecurityProfilesPagesWithContext same as SearchSecurityProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchSecurityProfilesPagesWithContext(ctx aws.Context, input *SearchSecurityProfilesInput, fn func(*SearchSecurityProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchSecurityProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchSecurityProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchSecurityProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchUsers = "SearchUsers"

// SearchUsersRequest generates a "aws/request.Request" representing the
// client's request for the SearchUsers operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchUsers for more information on using the SearchUsers
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchUsersRequest method.
//	req, resp := client.SearchUsersRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers
func (c *Connect) SearchUsersRequest(input *SearchUsersInput) (req *request.Request, output *SearchUsersOutput) {
	op := &request.Operation{
		Name:       opSearchUsers,
		HTTPMethod: "POST",
		HTTPPath:   "/search-users",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchUsersInput{}
	}

	output = &SearchUsersOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchUsers API operation for Amazon Connect Service.
//
// Searches users in an Amazon Connect instance, with optional filtering.
//
// AfterContactWorkTimeLimit is returned in milliseconds.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchUsers for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchUsers
func (c *Connect) SearchUsers(input *SearchUsersInput) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	return out, req.Send()
}

// SearchUsersWithContext is the same as SearchUsers with the addition of
// the ability to pass a context and additional request options.
//
// See SearchUsers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchUsersWithContext(ctx aws.Context, input *SearchUsersInput, opts ...request.Option) (*SearchUsersOutput, error) {
	req, out := c.SearchUsersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchUsersPages iterates over the pages of a SearchUsers operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchUsers method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchUsers operation.
//	pageNum := 0
//	err := client.SearchUsersPages(params,
//	    func(page *connect.SearchUsersOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchUsersPages(input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool) error {
	return c.SearchUsersPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchUsersPagesWithContext same as SearchUsersPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchUsersPagesWithContext(ctx aws.Context, input *SearchUsersInput, fn func(*SearchUsersOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchUsersInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchUsersRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchUsersOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opSearchVocabularies = "SearchVocabularies"

// SearchVocabulariesRequest generates a "aws/request.Request" representing the
// client's request for the SearchVocabularies operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SearchVocabularies for more information on using the SearchVocabularies
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SearchVocabulariesRequest method.
//	req, resp := client.SearchVocabulariesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies
func (c *Connect) SearchVocabulariesRequest(input *SearchVocabulariesInput) (req *request.Request, output *SearchVocabulariesOutput) {
	op := &request.Operation{
		Name:       opSearchVocabularies,
		HTTPMethod: "POST",
		HTTPPath:   "/vocabulary-summary/{InstanceId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &SearchVocabulariesInput{}
	}

	output = &SearchVocabulariesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SearchVocabularies API operation for Amazon Connect Service.
//
// Searches for vocabularies within a specific Amazon Connect instance using
// State, NameStartsWith, and LanguageCode.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SearchVocabularies for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SearchVocabularies
func (c *Connect) SearchVocabularies(input *SearchVocabulariesInput) (*SearchVocabulariesOutput, error) {
	req, out := c.SearchVocabulariesRequest(input)
	return out, req.Send()
}

// SearchVocabulariesWithContext is the same as SearchVocabularies with the addition of
// the ability to pass a context and additional request options.
//
// See SearchVocabularies for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchVocabulariesWithContext(ctx aws.Context, input *SearchVocabulariesInput, opts ...request.Option) (*SearchVocabulariesOutput, error) {
	req, out := c.SearchVocabulariesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// SearchVocabulariesPages iterates over the pages of a SearchVocabularies operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See SearchVocabularies method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a SearchVocabularies operation.
//	pageNum := 0
//	err := client.SearchVocabulariesPages(params,
//	    func(page *connect.SearchVocabulariesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Connect) SearchVocabulariesPages(input *SearchVocabulariesInput, fn func(*SearchVocabulariesOutput, bool) bool) error {
	return c.SearchVocabulariesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// SearchVocabulariesPagesWithContext same as SearchVocabulariesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SearchVocabulariesPagesWithContext(ctx aws.Context, input *SearchVocabulariesInput, fn func(*SearchVocabulariesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *SearchVocabulariesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.SearchVocabulariesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*SearchVocabulariesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opStartChatContact = "StartChatContact"

// StartChatContactRequest generates a "aws/request.Request" representing the
// client's request for the StartChatContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartChatContact for more information on using the StartChatContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartChatContactRequest method.
//	req, resp := client.StartChatContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact
func (c *Connect) StartChatContactRequest(input *StartChatContactInput) (req *request.Request, output *StartChatContactOutput) {
	op := &request.Operation{
		Name:       opStartChatContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/chat",
	}

	if input == nil {
		input = &StartChatContactInput{}
	}

	output = &StartChatContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartChatContact API operation for Amazon Connect Service.
//
// Initiates a flow to start a new chat for the customer. Response of this API
// provides a token required to obtain credentials from the CreateParticipantConnection
// (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// API in the Amazon Connect Participant Service.
//
// When a new chat contact is successfully created, clients must subscribe to
// the participant’s connection for the created chat within 5 minutes. This
// is achieved by invoking CreateParticipantConnection (https://docs.aws.amazon.com/connect-participant/latest/APIReference/API_CreateParticipantConnection.html)
// with WEBSOCKET and CONNECTION_CREDENTIALS.
//
// A 429 error occurs in the following situations:
//
//   - API rate limit is exceeded. API TPS throttling returns a TooManyRequests
//     exception.
//
//   - The quota for concurrent active chats (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
//     is exceeded. Active chat throttling returns a LimitExceededException.
//
// If you use the ChatDurationInMinutes parameter and receive a 400 error, your
// account may not support the ability to configure custom chat durations. For
// more information, contact Amazon Web Services Support.
//
// For more information about chat, see Chat (https://docs.aws.amazon.com/connect/latest/adminguide/chat.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartChatContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartChatContact
func (c *Connect) StartChatContact(input *StartChatContactInput) (*StartChatContactOutput, error) {
	req, out := c.StartChatContactRequest(input)
	return out, req.Send()
}

// StartChatContactWithContext is the same as StartChatContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartChatContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartChatContactWithContext(ctx aws.Context, input *StartChatContactInput, opts ...request.Option) (*StartChatContactOutput, error) {
	req, out := c.StartChatContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartContactEvaluation = "StartContactEvaluation"

// StartContactEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the StartContactEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContactEvaluation for more information on using the StartContactEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartContactEvaluationRequest method.
//	req, resp := client.StartContactEvaluationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactEvaluation
func (c *Connect) StartContactEvaluationRequest(input *StartContactEvaluationInput) (req *request.Request, output *StartContactEvaluationOutput) {
	op := &request.Operation{
		Name:       opStartContactEvaluation,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact-evaluations/{InstanceId}",
	}

	if input == nil {
		input = &StartContactEvaluationInput{}
	}

	output = &StartContactEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartContactEvaluation API operation for Amazon Connect Service.
//
// Starts an empty evaluation in the specified Amazon Connect instance, using
// the given evaluation form for the particular contact. The evaluation form
// version used for the contact evaluation corresponds to the currently activated
// version. If no version is activated for the evaluation form, the contact
// evaluation cannot be started.
//
// Evaluations created through the public API do not contain answer values suggested
// from automation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartContactEvaluation for usage and error information.
//
// Returned Error Types:
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactEvaluation
func (c *Connect) StartContactEvaluation(input *StartContactEvaluationInput) (*StartContactEvaluationOutput, error) {
	req, out := c.StartContactEvaluationRequest(input)
	return out, req.Send()
}

// StartContactEvaluationWithContext is the same as StartContactEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See StartContactEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartContactEvaluationWithContext(ctx aws.Context, input *StartContactEvaluationInput, opts ...request.Option) (*StartContactEvaluationOutput, error) {
	req, out := c.StartContactEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartContactRecording = "StartContactRecording"

// StartContactRecordingRequest generates a "aws/request.Request" representing the
// client's request for the StartContactRecording operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContactRecording for more information on using the StartContactRecording
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartContactRecordingRequest method.
//	req, resp := client.StartContactRecordingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactRecording
func (c *Connect) StartContactRecordingRequest(input *StartContactRecordingInput) (req *request.Request, output *StartContactRecordingOutput) {
	op := &request.Operation{
		Name:       opStartContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/start-recording",
	}

	if input == nil {
		input = &StartContactRecordingInput{}
	}

	output = &StartContactRecordingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StartContactRecording API operation for Amazon Connect Service.
//
// Starts recording the contact:
//
//   - If the API is called before the agent joins the call, recording starts
//     when the agent joins the call.
//
//   - If the API is called after the agent joins the call, recording starts
//     at the time of the API call.
//
// StartContactRecording is a one-time action. For example, if you use StopContactRecording
// to stop recording an ongoing call, you can't use StartContactRecording to
// restart it. For scenarios where the recording has started and you want to
// suspend and resume it, such as when collecting sensitive information (for
// example, a credit card number), use SuspendContactRecording and ResumeContactRecording.
//
// You can use this API to override the recording behavior configured in the
// Set recording behavior (https://docs.aws.amazon.com/connect/latest/adminguide/set-recording-behavior.html)
// block.
//
// Only voice recordings are supported at this time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartContactRecording for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactRecording
func (c *Connect) StartContactRecording(input *StartContactRecordingInput) (*StartContactRecordingOutput, error) {
	req, out := c.StartContactRecordingRequest(input)
	return out, req.Send()
}

// StartContactRecordingWithContext is the same as StartContactRecording with the addition of
// the ability to pass a context and additional request options.
//
// See StartContactRecording for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartContactRecordingWithContext(ctx aws.Context, input *StartContactRecordingInput, opts ...request.Option) (*StartContactRecordingOutput, error) {
	req, out := c.StartContactRecordingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartContactStreaming = "StartContactStreaming"

// StartContactStreamingRequest generates a "aws/request.Request" representing the
// client's request for the StartContactStreaming operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartContactStreaming for more information on using the StartContactStreaming
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartContactStreamingRequest method.
//	req, resp := client.StartContactStreamingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactStreaming
func (c *Connect) StartContactStreamingRequest(input *StartContactStreamingInput) (req *request.Request, output *StartContactStreamingOutput) {
	op := &request.Operation{
		Name:       opStartContactStreaming,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/start-streaming",
	}

	if input == nil {
		input = &StartContactStreamingInput{}
	}

	output = &StartContactStreamingOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartContactStreaming API operation for Amazon Connect Service.
//
// Initiates real-time message streaming for a new chat contact.
//
// For more information about message streaming, see Enable real-time chat message
// streaming (https://docs.aws.amazon.com/connect/latest/adminguide/chat-message-streaming.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartContactStreaming for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartContactStreaming
func (c *Connect) StartContactStreaming(input *StartContactStreamingInput) (*StartContactStreamingOutput, error) {
	req, out := c.StartContactStreamingRequest(input)
	return out, req.Send()
}

// StartContactStreamingWithContext is the same as StartContactStreaming with the addition of
// the ability to pass a context and additional request options.
//
// See StartContactStreaming for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartContactStreamingWithContext(ctx aws.Context, input *StartContactStreamingInput, opts ...request.Option) (*StartContactStreamingOutput, error) {
	req, out := c.StartContactStreamingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartOutboundVoiceContact = "StartOutboundVoiceContact"

// StartOutboundVoiceContactRequest generates a "aws/request.Request" representing the
// client's request for the StartOutboundVoiceContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartOutboundVoiceContact for more information on using the StartOutboundVoiceContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartOutboundVoiceContactRequest method.
//	req, resp := client.StartOutboundVoiceContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContactRequest(input *StartOutboundVoiceContactInput) (req *request.Request, output *StartOutboundVoiceContactOutput) {
	op := &request.Operation{
		Name:       opStartOutboundVoiceContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/outbound-voice",
	}

	if input == nil {
		input = &StartOutboundVoiceContactInput{}
	}

	output = &StartOutboundVoiceContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartOutboundVoiceContact API operation for Amazon Connect Service.
//
// Places an outbound call to a contact, and then initiates the flow. It performs
// the actions in the flow that's specified (in ContactFlowId).
//
// Agents do not initiate the outbound API, which means that they do not dial
// the contact. If the flow places an outbound call to a contact, and then puts
// the contact in queue, the call is then routed to the agent, like any other
// inbound case.
//
// There is a 60-second dialing timeout for this operation. If the call is not
// connected after 60 seconds, it fails.
//
// UK numbers with a 447 prefix are not allowed by default. Before you can dial
// these UK mobile numbers, you must submit a service quota increase request.
// For more information, see Amazon Connect Service Quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html)
// in the Amazon Connect Administrator Guide.
//
// Campaign calls are not allowed by default. Before you can make a call with
// TrafficType = CAMPAIGN, you must submit a service quota increase request
// to the quota Amazon Connect campaigns (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#outbound-communications-quotas).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartOutboundVoiceContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - DestinationNotAllowedException
//     Outbound calls to the destination number are not allowed.
//
//   - OutboundContactNotPermittedException
//     The contact is not permitted.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartOutboundVoiceContact
func (c *Connect) StartOutboundVoiceContact(input *StartOutboundVoiceContactInput) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	return out, req.Send()
}

// StartOutboundVoiceContactWithContext is the same as StartOutboundVoiceContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartOutboundVoiceContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartOutboundVoiceContactWithContext(ctx aws.Context, input *StartOutboundVoiceContactInput, opts ...request.Option) (*StartOutboundVoiceContactOutput, error) {
	req, out := c.StartOutboundVoiceContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartTaskContact = "StartTaskContact"

// StartTaskContactRequest generates a "aws/request.Request" representing the
// client's request for the StartTaskContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartTaskContact for more information on using the StartTaskContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartTaskContactRequest method.
//	req, resp := client.StartTaskContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartTaskContact
func (c *Connect) StartTaskContactRequest(input *StartTaskContactInput) (req *request.Request, output *StartTaskContactOutput) {
	op := &request.Operation{
		Name:       opStartTaskContact,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/task",
	}

	if input == nil {
		input = &StartTaskContactInput{}
	}

	output = &StartTaskContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartTaskContact API operation for Amazon Connect Service.
//
// Initiates a flow to start a new task.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StartTaskContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StartTaskContact
func (c *Connect) StartTaskContact(input *StartTaskContactInput) (*StartTaskContactOutput, error) {
	req, out := c.StartTaskContactRequest(input)
	return out, req.Send()
}

// StartTaskContactWithContext is the same as StartTaskContact with the addition of
// the ability to pass a context and additional request options.
//
// See StartTaskContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StartTaskContactWithContext(ctx aws.Context, input *StartTaskContactInput, opts ...request.Option) (*StartTaskContactOutput, error) {
	req, out := c.StartTaskContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContact = "StopContact"

// StopContactRequest generates a "aws/request.Request" representing the
// client's request for the StopContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContact for more information on using the StopContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopContactRequest method.
//	req, resp := client.StopContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContactRequest(input *StopContactInput) (req *request.Request, output *StopContactOutput) {
	op := &request.Operation{
		Name:       opStopContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop",
	}

	if input == nil {
		input = &StopContactInput{}
	}

	output = &StopContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopContact API operation for Amazon Connect Service.
//
// Ends the specified contact. This call does not work for the following initiation
// methods:
//
//   - DISCONNECT
//
//   - TRANSFER
//
//   - QUEUE_TRANSFER
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StopContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ContactNotFoundException
//     The contact with the specified ID is not active or does not exist. Applies
//     to Voice calls only, not to Chat, Task, or Voice Callback.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContact
func (c *Connect) StopContact(input *StopContactInput) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	return out, req.Send()
}

// StopContactWithContext is the same as StopContact with the addition of
// the ability to pass a context and additional request options.
//
// See StopContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StopContactWithContext(ctx aws.Context, input *StopContactInput, opts ...request.Option) (*StopContactOutput, error) {
	req, out := c.StopContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContactRecording = "StopContactRecording"

// StopContactRecordingRequest generates a "aws/request.Request" representing the
// client's request for the StopContactRecording operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContactRecording for more information on using the StopContactRecording
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopContactRecordingRequest method.
//	req, resp := client.StopContactRecordingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactRecording
func (c *Connect) StopContactRecordingRequest(input *StopContactRecordingInput) (req *request.Request, output *StopContactRecordingOutput) {
	op := &request.Operation{
		Name:       opStopContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop-recording",
	}

	if input == nil {
		input = &StopContactRecordingInput{}
	}

	output = &StopContactRecordingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopContactRecording API operation for Amazon Connect Service.
//
// Stops recording a call when a contact is being recorded. StopContactRecording
// is a one-time action. If you use StopContactRecording to stop recording an
// ongoing call, you can't use StartContactRecording to restart it. For scenarios
// where the recording has started and you want to suspend it for sensitive
// information (for example, to collect a credit card number), and then restart
// it, use SuspendContactRecording and ResumeContactRecording.
//
// Only voice recordings are supported at this time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StopContactRecording for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactRecording
func (c *Connect) StopContactRecording(input *StopContactRecordingInput) (*StopContactRecordingOutput, error) {
	req, out := c.StopContactRecordingRequest(input)
	return out, req.Send()
}

// StopContactRecordingWithContext is the same as StopContactRecording with the addition of
// the ability to pass a context and additional request options.
//
// See StopContactRecording for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StopContactRecordingWithContext(ctx aws.Context, input *StopContactRecordingInput, opts ...request.Option) (*StopContactRecordingOutput, error) {
	req, out := c.StopContactRecordingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStopContactStreaming = "StopContactStreaming"

// StopContactStreamingRequest generates a "aws/request.Request" representing the
// client's request for the StopContactStreaming operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StopContactStreaming for more information on using the StopContactStreaming
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StopContactStreamingRequest method.
//	req, resp := client.StopContactStreamingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactStreaming
func (c *Connect) StopContactStreamingRequest(input *StopContactStreamingInput) (req *request.Request, output *StopContactStreamingOutput) {
	op := &request.Operation{
		Name:       opStopContactStreaming,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/stop-streaming",
	}

	if input == nil {
		input = &StopContactStreamingInput{}
	}

	output = &StopContactStreamingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// StopContactStreaming API operation for Amazon Connect Service.
//
// Ends message streaming on a specified contact. To restart message streaming
// on that contact, call the StartContactStreaming (https://docs.aws.amazon.com/connect/latest/APIReference/API_StartContactStreaming.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation StopContactStreaming for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/StopContactStreaming
func (c *Connect) StopContactStreaming(input *StopContactStreamingInput) (*StopContactStreamingOutput, error) {
	req, out := c.StopContactStreamingRequest(input)
	return out, req.Send()
}

// StopContactStreamingWithContext is the same as StopContactStreaming with the addition of
// the ability to pass a context and additional request options.
//
// See StopContactStreaming for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) StopContactStreamingWithContext(ctx aws.Context, input *StopContactStreamingInput, opts ...request.Option) (*StopContactStreamingOutput, error) {
	req, out := c.StopContactStreamingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSubmitContactEvaluation = "SubmitContactEvaluation"

// SubmitContactEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the SubmitContactEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SubmitContactEvaluation for more information on using the SubmitContactEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SubmitContactEvaluationRequest method.
//	req, resp := client.SubmitContactEvaluationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SubmitContactEvaluation
func (c *Connect) SubmitContactEvaluationRequest(input *SubmitContactEvaluationInput) (req *request.Request, output *SubmitContactEvaluationOutput) {
	op := &request.Operation{
		Name:       opSubmitContactEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-evaluations/{InstanceId}/{EvaluationId}/submit",
	}

	if input == nil {
		input = &SubmitContactEvaluationInput{}
	}

	output = &SubmitContactEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// SubmitContactEvaluation API operation for Amazon Connect Service.
//
// Submits a contact evaluation in the specified Amazon Connect instance. Answers
// included in the request are merged with existing answers for the given evaluation.
// If no answers or notes are passed, the evaluation is submitted with the existing
// answers and notes. You can delete an answer or note by passing an empty object
// ({}) to the question identifier.
//
// If a contact evaluation is already in submitted state, this operation will
// trigger a resubmission.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SubmitContactEvaluation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SubmitContactEvaluation
func (c *Connect) SubmitContactEvaluation(input *SubmitContactEvaluationInput) (*SubmitContactEvaluationOutput, error) {
	req, out := c.SubmitContactEvaluationRequest(input)
	return out, req.Send()
}

// SubmitContactEvaluationWithContext is the same as SubmitContactEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See SubmitContactEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SubmitContactEvaluationWithContext(ctx aws.Context, input *SubmitContactEvaluationInput, opts ...request.Option) (*SubmitContactEvaluationOutput, error) {
	req, out := c.SubmitContactEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSuspendContactRecording = "SuspendContactRecording"

// SuspendContactRecordingRequest generates a "aws/request.Request" representing the
// client's request for the SuspendContactRecording operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See SuspendContactRecording for more information on using the SuspendContactRecording
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the SuspendContactRecordingRequest method.
//	req, resp := client.SuspendContactRecordingRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SuspendContactRecording
func (c *Connect) SuspendContactRecordingRequest(input *SuspendContactRecordingInput) (req *request.Request, output *SuspendContactRecordingOutput) {
	op := &request.Operation{
		Name:       opSuspendContactRecording,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/suspend-recording",
	}

	if input == nil {
		input = &SuspendContactRecordingInput{}
	}

	output = &SuspendContactRecordingOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// SuspendContactRecording API operation for Amazon Connect Service.
//
// When a contact is being recorded, this API suspends recording the call. For
// example, you might suspend the call recording while collecting sensitive
// information, such as a credit card number. Then use ResumeContactRecording
// to restart recording.
//
// The period of time that the recording is suspended is filled with silence
// in the final recording.
//
// Only voice recordings are supported at this time.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation SuspendContactRecording for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/SuspendContactRecording
func (c *Connect) SuspendContactRecording(input *SuspendContactRecordingInput) (*SuspendContactRecordingOutput, error) {
	req, out := c.SuspendContactRecordingRequest(input)
	return out, req.Send()
}

// SuspendContactRecordingWithContext is the same as SuspendContactRecording with the addition of
// the ability to pass a context and additional request options.
//
// See SuspendContactRecording for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) SuspendContactRecordingWithContext(ctx aws.Context, input *SuspendContactRecordingInput, opts ...request.Option) (*SuspendContactRecordingOutput, error) {
	req, out := c.SuspendContactRecordingRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource
func (c *Connect) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon Connect Service.
//
// Adds the specified tags to the specified resource.
//
// Some of the supported resource types are agents, routing profiles, queues,
// quick connects, contact flows, agent statuses, hours of operation, phone
// numbers, security profiles, and task templates. For a complete list, see
// Tagging resources in Amazon Connect (https://docs.aws.amazon.com/connect/latest/adminguide/tagging.html).
//
// For sample policies that use tags, see Amazon Connect Identity-Based Policy
// Examples (https://docs.aws.amazon.com/connect/latest/adminguide/security_iam_id-based-policy-examples.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TagResource
func (c *Connect) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTransferContact = "TransferContact"

// TransferContactRequest generates a "aws/request.Request" representing the
// client's request for the TransferContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TransferContact for more information on using the TransferContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TransferContactRequest method.
//	req, resp := client.TransferContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TransferContact
func (c *Connect) TransferContactRequest(input *TransferContactInput) (req *request.Request, output *TransferContactOutput) {
	op := &request.Operation{
		Name:       opTransferContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/transfer",
	}

	if input == nil {
		input = &TransferContactInput{}
	}

	output = &TransferContactOutput{}
	req = c.newRequest(op, input, output)
	return
}

// TransferContact API operation for Amazon Connect Service.
//
// Transfers contacts from one agent or queue to another agent or queue at any
// point after a contact is created. You can transfer a contact to another queue
// by providing the flow which orchestrates the contact to the destination queue.
// This gives you more control over contact handling and helps you adhere to
// the service level agreement (SLA) guaranteed to your customers.
//
// Note the following requirements:
//
//   - Transfer is supported for only TASK contacts.
//
//   - Do not use both QueueId and UserId in the same call.
//
//   - The following flow types are supported: Inbound flow, Transfer to agent
//     flow, and Transfer to queue flow.
//
//   - The TransferContact API can be called only on active contacts.
//
//   - A contact cannot be transferred more than 11 times.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation TransferContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/TransferContact
func (c *Connect) TransferContact(input *TransferContactInput) (*TransferContactOutput, error) {
	req, out := c.TransferContactRequest(input)
	return out, req.Send()
}

// TransferContactWithContext is the same as TransferContact with the addition of
// the ability to pass a context and additional request options.
//
// See TransferContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) TransferContactWithContext(ctx aws.Context, input *TransferContactInput, opts ...request.Option) (*TransferContactOutput, error) {
	req, out := c.TransferContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource
func (c *Connect) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon Connect Service.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UntagResource
func (c *Connect) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateAgentStatus = "UpdateAgentStatus"

// UpdateAgentStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateAgentStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateAgentStatus for more information on using the UpdateAgentStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateAgentStatusRequest method.
//	req, resp := client.UpdateAgentStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateAgentStatus
func (c *Connect) UpdateAgentStatusRequest(input *UpdateAgentStatusInput) (req *request.Request, output *UpdateAgentStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateAgentStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/agent-status/{InstanceId}/{AgentStatusId}",
	}

	if input == nil {
		input = &UpdateAgentStatusInput{}
	}

	output = &UpdateAgentStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateAgentStatus API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates agent status.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateAgentStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateAgentStatus
func (c *Connect) UpdateAgentStatus(input *UpdateAgentStatusInput) (*UpdateAgentStatusOutput, error) {
	req, out := c.UpdateAgentStatusRequest(input)
	return out, req.Send()
}

// UpdateAgentStatusWithContext is the same as UpdateAgentStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateAgentStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateAgentStatusWithContext(ctx aws.Context, input *UpdateAgentStatusInput, opts ...request.Option) (*UpdateAgentStatusOutput, error) {
	req, out := c.UpdateAgentStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContact = "UpdateContact"

// UpdateContactRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContact operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContact for more information on using the UpdateContact
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactRequest method.
//	req, resp := client.UpdateContactRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContact
func (c *Connect) UpdateContactRequest(input *UpdateContactInput) (req *request.Request, output *UpdateContactOutput) {
	op := &request.Operation{
		Name:       opUpdateContact,
		HTTPMethod: "POST",
		HTTPPath:   "/contacts/{InstanceId}/{ContactId}",
	}

	if input == nil {
		input = &UpdateContactInput{}
	}

	output = &UpdateContactOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContact API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Adds or updates user-defined contact information associated with the specified
// contact. At least one field to be updated must be present in the request.
//
// You can add or update user-defined contact information for both ongoing and
// completed contacts.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContact for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContact
func (c *Connect) UpdateContact(input *UpdateContactInput) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	return out, req.Send()
}

// UpdateContactWithContext is the same as UpdateContact with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContact for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactWithContext(ctx aws.Context, input *UpdateContactInput, opts ...request.Option) (*UpdateContactOutput, error) {
	req, out := c.UpdateContactRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactAttributes = "UpdateContactAttributes"

// UpdateContactAttributesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactAttributes operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactAttributes for more information on using the UpdateContactAttributes
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactAttributesRequest method.
//	req, resp := client.UpdateContactAttributesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributesRequest(input *UpdateContactAttributesInput) (req *request.Request, output *UpdateContactAttributesOutput) {
	op := &request.Operation{
		Name:       opUpdateContactAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/attributes",
	}

	if input == nil {
		input = &UpdateContactAttributesInput{}
	}

	output = &UpdateContactAttributesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactAttributes API operation for Amazon Connect Service.
//
// Creates or updates user-defined contact attributes associated with the specified
// contact.
//
// You can create or update user-defined attributes for both ongoing and completed
// contacts. For example, while the call is active, you can update the customer's
// name or the reason the customer called. You can add notes about steps that
// the agent took during the call that display to the next agent that takes
// the call. You can also update attributes for a contact using data from your
// CRM application and save the data with the contact in Amazon Connect. You
// could also flag calls for additional analysis, such as legal review or to
// identify abusive callers.
//
// Contact attributes are available in Amazon Connect for 24 months, and are
// then deleted. For information about contact record retention and the maximum
// size of the contact record attributes section, see Feature specifications
// (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html#feature-limits)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactAttributes for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactAttributes
func (c *Connect) UpdateContactAttributes(input *UpdateContactAttributesInput) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	return out, req.Send()
}

// UpdateContactAttributesWithContext is the same as UpdateContactAttributes with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactAttributes for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactAttributesWithContext(ctx aws.Context, input *UpdateContactAttributesInput, opts ...request.Option) (*UpdateContactAttributesOutput, error) {
	req, out := c.UpdateContactAttributesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactEvaluation = "UpdateContactEvaluation"

// UpdateContactEvaluationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactEvaluation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactEvaluation for more information on using the UpdateContactEvaluation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactEvaluationRequest method.
//	req, resp := client.UpdateContactEvaluationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactEvaluation
func (c *Connect) UpdateContactEvaluationRequest(input *UpdateContactEvaluationInput) (req *request.Request, output *UpdateContactEvaluationOutput) {
	op := &request.Operation{
		Name:       opUpdateContactEvaluation,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-evaluations/{InstanceId}/{EvaluationId}",
	}

	if input == nil {
		input = &UpdateContactEvaluationInput{}
	}

	output = &UpdateContactEvaluationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateContactEvaluation API operation for Amazon Connect Service.
//
// Updates details about a contact evaluation in the specified Amazon Connect
// instance. A contact evaluation must be in draft state. Answers included in
// the request are merged with existing answers for the given evaluation. An
// answer or note can be deleted by passing an empty object ({}) to the question
// identifier.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactEvaluation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactEvaluation
func (c *Connect) UpdateContactEvaluation(input *UpdateContactEvaluationInput) (*UpdateContactEvaluationOutput, error) {
	req, out := c.UpdateContactEvaluationRequest(input)
	return out, req.Send()
}

// UpdateContactEvaluationWithContext is the same as UpdateContactEvaluation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactEvaluation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactEvaluationWithContext(ctx aws.Context, input *UpdateContactEvaluationInput, opts ...request.Option) (*UpdateContactEvaluationOutput, error) {
	req, out := c.UpdateContactEvaluationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactFlowContent = "UpdateContactFlowContent"

// UpdateContactFlowContentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactFlowContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactFlowContent for more information on using the UpdateContactFlowContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactFlowContentRequest method.
//	req, resp := client.UpdateContactFlowContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowContent
func (c *Connect) UpdateContactFlowContentRequest(input *UpdateContactFlowContentInput) (req *request.Request, output *UpdateContactFlowContentOutput) {
	op := &request.Operation{
		Name:       opUpdateContactFlowContent,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-flows/{InstanceId}/{ContactFlowId}/content",
	}

	if input == nil {
		input = &UpdateContactFlowContentInput{}
	}

	output = &UpdateContactFlowContentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactFlowContent API operation for Amazon Connect Service.
//
// Updates the specified flow.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactFlowContent for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidContactFlowException
//     The flow is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowContent
func (c *Connect) UpdateContactFlowContent(input *UpdateContactFlowContentInput) (*UpdateContactFlowContentOutput, error) {
	req, out := c.UpdateContactFlowContentRequest(input)
	return out, req.Send()
}

// UpdateContactFlowContentWithContext is the same as UpdateContactFlowContent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactFlowContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactFlowContentWithContext(ctx aws.Context, input *UpdateContactFlowContentInput, opts ...request.Option) (*UpdateContactFlowContentOutput, error) {
	req, out := c.UpdateContactFlowContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactFlowMetadata = "UpdateContactFlowMetadata"

// UpdateContactFlowMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactFlowMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactFlowMetadata for more information on using the UpdateContactFlowMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactFlowMetadataRequest method.
//	req, resp := client.UpdateContactFlowMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowMetadata
func (c *Connect) UpdateContactFlowMetadataRequest(input *UpdateContactFlowMetadataInput) (req *request.Request, output *UpdateContactFlowMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateContactFlowMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-flows/{InstanceId}/{ContactFlowId}/metadata",
	}

	if input == nil {
		input = &UpdateContactFlowMetadataInput{}
	}

	output = &UpdateContactFlowMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactFlowMetadata API operation for Amazon Connect Service.
//
// Updates metadata about specified flow.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactFlowMetadata for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowMetadata
func (c *Connect) UpdateContactFlowMetadata(input *UpdateContactFlowMetadataInput) (*UpdateContactFlowMetadataOutput, error) {
	req, out := c.UpdateContactFlowMetadataRequest(input)
	return out, req.Send()
}

// UpdateContactFlowMetadataWithContext is the same as UpdateContactFlowMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactFlowMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactFlowMetadataWithContext(ctx aws.Context, input *UpdateContactFlowMetadataInput, opts ...request.Option) (*UpdateContactFlowMetadataOutput, error) {
	req, out := c.UpdateContactFlowMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactFlowModuleContent = "UpdateContactFlowModuleContent"

// UpdateContactFlowModuleContentRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactFlowModuleContent operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactFlowModuleContent for more information on using the UpdateContactFlowModuleContent
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactFlowModuleContentRequest method.
//	req, resp := client.UpdateContactFlowModuleContentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleContent
func (c *Connect) UpdateContactFlowModuleContentRequest(input *UpdateContactFlowModuleContentInput) (req *request.Request, output *UpdateContactFlowModuleContentOutput) {
	op := &request.Operation{
		Name:       opUpdateContactFlowModuleContent,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/content",
	}

	if input == nil {
		input = &UpdateContactFlowModuleContentInput{}
	}

	output = &UpdateContactFlowModuleContentOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactFlowModuleContent API operation for Amazon Connect Service.
//
// Updates specified flow module for the specified Amazon Connect instance.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactFlowModuleContent for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidContactFlowModuleException
//     The problems with the module. Please fix before trying again.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleContent
func (c *Connect) UpdateContactFlowModuleContent(input *UpdateContactFlowModuleContentInput) (*UpdateContactFlowModuleContentOutput, error) {
	req, out := c.UpdateContactFlowModuleContentRequest(input)
	return out, req.Send()
}

// UpdateContactFlowModuleContentWithContext is the same as UpdateContactFlowModuleContent with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactFlowModuleContent for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactFlowModuleContentWithContext(ctx aws.Context, input *UpdateContactFlowModuleContentInput, opts ...request.Option) (*UpdateContactFlowModuleContentOutput, error) {
	req, out := c.UpdateContactFlowModuleContentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactFlowModuleMetadata = "UpdateContactFlowModuleMetadata"

// UpdateContactFlowModuleMetadataRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactFlowModuleMetadata operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactFlowModuleMetadata for more information on using the UpdateContactFlowModuleMetadata
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactFlowModuleMetadataRequest method.
//	req, resp := client.UpdateContactFlowModuleMetadataRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleMetadata
func (c *Connect) UpdateContactFlowModuleMetadataRequest(input *UpdateContactFlowModuleMetadataInput) (req *request.Request, output *UpdateContactFlowModuleMetadataOutput) {
	op := &request.Operation{
		Name:       opUpdateContactFlowModuleMetadata,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-flow-modules/{InstanceId}/{ContactFlowModuleId}/metadata",
	}

	if input == nil {
		input = &UpdateContactFlowModuleMetadataInput{}
	}

	output = &UpdateContactFlowModuleMetadataOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactFlowModuleMetadata API operation for Amazon Connect Service.
//
// Updates metadata about specified flow module.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactFlowModuleMetadata for usage and error information.
//
// Returned Error Types:
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowModuleMetadata
func (c *Connect) UpdateContactFlowModuleMetadata(input *UpdateContactFlowModuleMetadataInput) (*UpdateContactFlowModuleMetadataOutput, error) {
	req, out := c.UpdateContactFlowModuleMetadataRequest(input)
	return out, req.Send()
}

// UpdateContactFlowModuleMetadataWithContext is the same as UpdateContactFlowModuleMetadata with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactFlowModuleMetadata for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactFlowModuleMetadataWithContext(ctx aws.Context, input *UpdateContactFlowModuleMetadataInput, opts ...request.Option) (*UpdateContactFlowModuleMetadataOutput, error) {
	req, out := c.UpdateContactFlowModuleMetadataRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactFlowName = "UpdateContactFlowName"

// UpdateContactFlowNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactFlowName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactFlowName for more information on using the UpdateContactFlowName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactFlowNameRequest method.
//	req, resp := client.UpdateContactFlowNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowName
func (c *Connect) UpdateContactFlowNameRequest(input *UpdateContactFlowNameInput) (req *request.Request, output *UpdateContactFlowNameOutput) {
	op := &request.Operation{
		Name:       opUpdateContactFlowName,
		HTTPMethod: "POST",
		HTTPPath:   "/contact-flows/{InstanceId}/{ContactFlowId}/name",
	}

	if input == nil {
		input = &UpdateContactFlowNameInput{}
	}

	output = &UpdateContactFlowNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactFlowName API operation for Amazon Connect Service.
//
// The name of the flow.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactFlowName for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactFlowName
func (c *Connect) UpdateContactFlowName(input *UpdateContactFlowNameInput) (*UpdateContactFlowNameOutput, error) {
	req, out := c.UpdateContactFlowNameRequest(input)
	return out, req.Send()
}

// UpdateContactFlowNameWithContext is the same as UpdateContactFlowName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactFlowName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactFlowNameWithContext(ctx aws.Context, input *UpdateContactFlowNameInput, opts ...request.Option) (*UpdateContactFlowNameOutput, error) {
	req, out := c.UpdateContactFlowNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateContactSchedule = "UpdateContactSchedule"

// UpdateContactScheduleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateContactSchedule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateContactSchedule for more information on using the UpdateContactSchedule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateContactScheduleRequest method.
//	req, resp := client.UpdateContactScheduleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactSchedule
func (c *Connect) UpdateContactScheduleRequest(input *UpdateContactScheduleInput) (req *request.Request, output *UpdateContactScheduleOutput) {
	op := &request.Operation{
		Name:       opUpdateContactSchedule,
		HTTPMethod: "POST",
		HTTPPath:   "/contact/schedule",
	}

	if input == nil {
		input = &UpdateContactScheduleInput{}
	}

	output = &UpdateContactScheduleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateContactSchedule API operation for Amazon Connect Service.
//
// Updates the scheduled time of a task contact that is already scheduled.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateContactSchedule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - LimitExceededException
//     The allowed limit for the resource has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateContactSchedule
func (c *Connect) UpdateContactSchedule(input *UpdateContactScheduleInput) (*UpdateContactScheduleOutput, error) {
	req, out := c.UpdateContactScheduleRequest(input)
	return out, req.Send()
}

// UpdateContactScheduleWithContext is the same as UpdateContactSchedule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateContactSchedule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateContactScheduleWithContext(ctx aws.Context, input *UpdateContactScheduleInput, opts ...request.Option) (*UpdateContactScheduleOutput, error) {
	req, out := c.UpdateContactScheduleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEvaluationForm = "UpdateEvaluationForm"

// UpdateEvaluationFormRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEvaluationForm operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEvaluationForm for more information on using the UpdateEvaluationForm
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateEvaluationFormRequest method.
//	req, resp := client.UpdateEvaluationFormRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateEvaluationForm
func (c *Connect) UpdateEvaluationFormRequest(input *UpdateEvaluationFormInput) (req *request.Request, output *UpdateEvaluationFormOutput) {
	op := &request.Operation{
		Name:       opUpdateEvaluationForm,
		HTTPMethod: "PUT",
		HTTPPath:   "/evaluation-forms/{InstanceId}/{EvaluationFormId}",
	}

	if input == nil {
		input = &UpdateEvaluationFormInput{}
	}

	output = &UpdateEvaluationFormOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateEvaluationForm API operation for Amazon Connect Service.
//
// Updates details about a specific evaluation form version in the specified
// Amazon Connect instance. An evaluation form must have a unique title within
// an instance. Question and section identifiers cannot be duplicated within
// the same evaluation form.
//
// This operation does not support partial updates. Instead it does a full update
// of evaluation form content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateEvaluationForm for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateEvaluationForm
func (c *Connect) UpdateEvaluationForm(input *UpdateEvaluationFormInput) (*UpdateEvaluationFormOutput, error) {
	req, out := c.UpdateEvaluationFormRequest(input)
	return out, req.Send()
}

// UpdateEvaluationFormWithContext is the same as UpdateEvaluationForm with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEvaluationForm for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateEvaluationFormWithContext(ctx aws.Context, input *UpdateEvaluationFormInput, opts ...request.Option) (*UpdateEvaluationFormOutput, error) {
	req, out := c.UpdateEvaluationFormRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateHoursOfOperation = "UpdateHoursOfOperation"

// UpdateHoursOfOperationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateHoursOfOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateHoursOfOperation for more information on using the UpdateHoursOfOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateHoursOfOperationRequest method.
//	req, resp := client.UpdateHoursOfOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateHoursOfOperation
func (c *Connect) UpdateHoursOfOperationRequest(input *UpdateHoursOfOperationInput) (req *request.Request, output *UpdateHoursOfOperationOutput) {
	op := &request.Operation{
		Name:       opUpdateHoursOfOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/hours-of-operations/{InstanceId}/{HoursOfOperationId}",
	}

	if input == nil {
		input = &UpdateHoursOfOperationInput{}
	}

	output = &UpdateHoursOfOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateHoursOfOperation API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the hours of operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateHoursOfOperation for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateHoursOfOperation
func (c *Connect) UpdateHoursOfOperation(input *UpdateHoursOfOperationInput) (*UpdateHoursOfOperationOutput, error) {
	req, out := c.UpdateHoursOfOperationRequest(input)
	return out, req.Send()
}

// UpdateHoursOfOperationWithContext is the same as UpdateHoursOfOperation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateHoursOfOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateHoursOfOperationWithContext(ctx aws.Context, input *UpdateHoursOfOperationInput, opts ...request.Option) (*UpdateHoursOfOperationOutput, error) {
	req, out := c.UpdateHoursOfOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceAttribute = "UpdateInstanceAttribute"

// UpdateInstanceAttributeRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceAttribute operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceAttribute for more information on using the UpdateInstanceAttribute
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceAttributeRequest method.
//	req, resp := client.UpdateInstanceAttributeRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceAttribute
func (c *Connect) UpdateInstanceAttributeRequest(input *UpdateInstanceAttributeInput) (req *request.Request, output *UpdateInstanceAttributeOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceAttribute,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/{InstanceId}/attribute/{AttributeType}",
	}

	if input == nil {
		input = &UpdateInstanceAttributeInput{}
	}

	output = &UpdateInstanceAttributeOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceAttribute API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the value for the specified attribute type.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateInstanceAttribute for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceAttribute
func (c *Connect) UpdateInstanceAttribute(input *UpdateInstanceAttributeInput) (*UpdateInstanceAttributeOutput, error) {
	req, out := c.UpdateInstanceAttributeRequest(input)
	return out, req.Send()
}

// UpdateInstanceAttributeWithContext is the same as UpdateInstanceAttribute with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceAttribute for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateInstanceAttributeWithContext(ctx aws.Context, input *UpdateInstanceAttributeInput, opts ...request.Option) (*UpdateInstanceAttributeOutput, error) {
	req, out := c.UpdateInstanceAttributeRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateInstanceStorageConfig = "UpdateInstanceStorageConfig"

// UpdateInstanceStorageConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateInstanceStorageConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateInstanceStorageConfig for more information on using the UpdateInstanceStorageConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateInstanceStorageConfigRequest method.
//	req, resp := client.UpdateInstanceStorageConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceStorageConfig
func (c *Connect) UpdateInstanceStorageConfigRequest(input *UpdateInstanceStorageConfigInput) (req *request.Request, output *UpdateInstanceStorageConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateInstanceStorageConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/{InstanceId}/storage-config/{AssociationId}",
	}

	if input == nil {
		input = &UpdateInstanceStorageConfigInput{}
	}

	output = &UpdateInstanceStorageConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateInstanceStorageConfig API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates an existing configuration for a resource type. This API is idempotent.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateInstanceStorageConfig for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateInstanceStorageConfig
func (c *Connect) UpdateInstanceStorageConfig(input *UpdateInstanceStorageConfigInput) (*UpdateInstanceStorageConfigOutput, error) {
	req, out := c.UpdateInstanceStorageConfigRequest(input)
	return out, req.Send()
}

// UpdateInstanceStorageConfigWithContext is the same as UpdateInstanceStorageConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateInstanceStorageConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateInstanceStorageConfigWithContext(ctx aws.Context, input *UpdateInstanceStorageConfigInput, opts ...request.Option) (*UpdateInstanceStorageConfigOutput, error) {
	req, out := c.UpdateInstanceStorageConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateParticipantRoleConfig = "UpdateParticipantRoleConfig"

// UpdateParticipantRoleConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateParticipantRoleConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateParticipantRoleConfig for more information on using the UpdateParticipantRoleConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateParticipantRoleConfigRequest method.
//	req, resp := client.UpdateParticipantRoleConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateParticipantRoleConfig
func (c *Connect) UpdateParticipantRoleConfigRequest(input *UpdateParticipantRoleConfigInput) (req *request.Request, output *UpdateParticipantRoleConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateParticipantRoleConfig,
		HTTPMethod: "PUT",
		HTTPPath:   "/contact/participant-role-config/{InstanceId}/{ContactId}",
	}

	if input == nil {
		input = &UpdateParticipantRoleConfigInput{}
	}

	output = &UpdateParticipantRoleConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateParticipantRoleConfig API operation for Amazon Connect Service.
//
// Updates timeouts for when human chat participants are to be considered idle,
// and when agents are automatically disconnected from a chat due to idleness.
// You can set four timers:
//
//   - Customer idle timeout
//
//   - Customer auto-disconnect timeout
//
//   - Agent idle timeout
//
//   - Agent auto-disconnect timeout
//
// For more information about how chat timeouts work, see Set up chat timeouts
// for human participants (https://docs.aws.amazon.com/connect/latest/adminguide/setup-chat-timeouts.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateParticipantRoleConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateParticipantRoleConfig
func (c *Connect) UpdateParticipantRoleConfig(input *UpdateParticipantRoleConfigInput) (*UpdateParticipantRoleConfigOutput, error) {
	req, out := c.UpdateParticipantRoleConfigRequest(input)
	return out, req.Send()
}

// UpdateParticipantRoleConfigWithContext is the same as UpdateParticipantRoleConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateParticipantRoleConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateParticipantRoleConfigWithContext(ctx aws.Context, input *UpdateParticipantRoleConfigInput, opts ...request.Option) (*UpdateParticipantRoleConfigOutput, error) {
	req, out := c.UpdateParticipantRoleConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdatePhoneNumber = "UpdatePhoneNumber"

// UpdatePhoneNumberRequest generates a "aws/request.Request" representing the
// client's request for the UpdatePhoneNumber operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdatePhoneNumber for more information on using the UpdatePhoneNumber
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdatePhoneNumberRequest method.
//	req, resp := client.UpdatePhoneNumberRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdatePhoneNumber
func (c *Connect) UpdatePhoneNumberRequest(input *UpdatePhoneNumberInput) (req *request.Request, output *UpdatePhoneNumberOutput) {
	op := &request.Operation{
		Name:       opUpdatePhoneNumber,
		HTTPMethod: "PUT",
		HTTPPath:   "/phone-number/{PhoneNumberId}",
	}

	if input == nil {
		input = &UpdatePhoneNumberInput{}
	}

	output = &UpdatePhoneNumberOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdatePhoneNumber API operation for Amazon Connect Service.
//
// Updates your claimed phone number from its current Amazon Connect instance
// or traffic distribution group to another Amazon Connect instance or traffic
// distribution group in the same Amazon Web Services Region.
//
// You can call DescribePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html)
// API to verify the status of a previous UpdatePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
// operation.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdatePhoneNumber for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
//   - IdempotencyException
//     An entity with the same name already exists.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdatePhoneNumber
func (c *Connect) UpdatePhoneNumber(input *UpdatePhoneNumberInput) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	return out, req.Send()
}

// UpdatePhoneNumberWithContext is the same as UpdatePhoneNumber with the addition of
// the ability to pass a context and additional request options.
//
// See UpdatePhoneNumber for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdatePhoneNumberWithContext(ctx aws.Context, input *UpdatePhoneNumberInput, opts ...request.Option) (*UpdatePhoneNumberOutput, error) {
	req, out := c.UpdatePhoneNumberRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueHoursOfOperation = "UpdateQueueHoursOfOperation"

// UpdateQueueHoursOfOperationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueHoursOfOperation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueHoursOfOperation for more information on using the UpdateQueueHoursOfOperation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueHoursOfOperationRequest method.
//	req, resp := client.UpdateQueueHoursOfOperationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueHoursOfOperation
func (c *Connect) UpdateQueueHoursOfOperationRequest(input *UpdateQueueHoursOfOperationInput) (req *request.Request, output *UpdateQueueHoursOfOperationOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueHoursOfOperation,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/hours-of-operation",
	}

	if input == nil {
		input = &UpdateQueueHoursOfOperationInput{}
	}

	output = &UpdateQueueHoursOfOperationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQueueHoursOfOperation API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the hours of operation for the specified queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQueueHoursOfOperation for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueHoursOfOperation
func (c *Connect) UpdateQueueHoursOfOperation(input *UpdateQueueHoursOfOperationInput) (*UpdateQueueHoursOfOperationOutput, error) {
	req, out := c.UpdateQueueHoursOfOperationRequest(input)
	return out, req.Send()
}

// UpdateQueueHoursOfOperationWithContext is the same as UpdateQueueHoursOfOperation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueHoursOfOperation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQueueHoursOfOperationWithContext(ctx aws.Context, input *UpdateQueueHoursOfOperationInput, opts ...request.Option) (*UpdateQueueHoursOfOperationOutput, error) {
	req, out := c.UpdateQueueHoursOfOperationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueMaxContacts = "UpdateQueueMaxContacts"

// UpdateQueueMaxContactsRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueMaxContacts operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueMaxContacts for more information on using the UpdateQueueMaxContacts
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueMaxContactsRequest method.
//	req, resp := client.UpdateQueueMaxContactsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueMaxContacts
func (c *Connect) UpdateQueueMaxContactsRequest(input *UpdateQueueMaxContactsInput) (req *request.Request, output *UpdateQueueMaxContactsOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueMaxContacts,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/max-contacts",
	}

	if input == nil {
		input = &UpdateQueueMaxContactsInput{}
	}

	output = &UpdateQueueMaxContactsOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQueueMaxContacts API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the maximum number of contacts allowed in a queue before it is considered
// full.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQueueMaxContacts for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueMaxContacts
func (c *Connect) UpdateQueueMaxContacts(input *UpdateQueueMaxContactsInput) (*UpdateQueueMaxContactsOutput, error) {
	req, out := c.UpdateQueueMaxContactsRequest(input)
	return out, req.Send()
}

// UpdateQueueMaxContactsWithContext is the same as UpdateQueueMaxContacts with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueMaxContacts for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQueueMaxContactsWithContext(ctx aws.Context, input *UpdateQueueMaxContactsInput, opts ...request.Option) (*UpdateQueueMaxContactsOutput, error) {
	req, out := c.UpdateQueueMaxContactsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueName = "UpdateQueueName"

// UpdateQueueNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueName for more information on using the UpdateQueueName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueNameRequest method.
//	req, resp := client.UpdateQueueNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueName
func (c *Connect) UpdateQueueNameRequest(input *UpdateQueueNameInput) (req *request.Request, output *UpdateQueueNameOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueName,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/name",
	}

	if input == nil {
		input = &UpdateQueueNameInput{}
	}

	output = &UpdateQueueNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQueueName API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the name and description of a queue. At least Name or Description
// must be provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQueueName for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueName
func (c *Connect) UpdateQueueName(input *UpdateQueueNameInput) (*UpdateQueueNameOutput, error) {
	req, out := c.UpdateQueueNameRequest(input)
	return out, req.Send()
}

// UpdateQueueNameWithContext is the same as UpdateQueueName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQueueNameWithContext(ctx aws.Context, input *UpdateQueueNameInput, opts ...request.Option) (*UpdateQueueNameOutput, error) {
	req, out := c.UpdateQueueNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueOutboundCallerConfig = "UpdateQueueOutboundCallerConfig"

// UpdateQueueOutboundCallerConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueOutboundCallerConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueOutboundCallerConfig for more information on using the UpdateQueueOutboundCallerConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueOutboundCallerConfigRequest method.
//	req, resp := client.UpdateQueueOutboundCallerConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueOutboundCallerConfig
func (c *Connect) UpdateQueueOutboundCallerConfigRequest(input *UpdateQueueOutboundCallerConfigInput) (req *request.Request, output *UpdateQueueOutboundCallerConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueOutboundCallerConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/outbound-caller-config",
	}

	if input == nil {
		input = &UpdateQueueOutboundCallerConfigInput{}
	}

	output = &UpdateQueueOutboundCallerConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQueueOutboundCallerConfig API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the outbound caller ID name, number, and outbound whisper flow for
// a specified queue.
//
// If the number being used in the input is claimed to a traffic distribution
// group, and you are calling this API using an instance in the Amazon Web Services
// Region where the traffic distribution group was created, you can use either
// a full phone number ARN or UUID value for the OutboundCallerIdNumberId value
// of the OutboundCallerConfig (https://docs.aws.amazon.com/connect/latest/APIReference/API_OutboundCallerConfig)
// request body parameter. However, if the number is claimed to a traffic distribution
// group and you are calling this API using an instance in the alternate Amazon
// Web Services Region associated with the traffic distribution group, you must
// provide a full phone number ARN. If a UUID is provided in this scenario,
// you will receive a ResourceNotFoundException.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQueueOutboundCallerConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueOutboundCallerConfig
func (c *Connect) UpdateQueueOutboundCallerConfig(input *UpdateQueueOutboundCallerConfigInput) (*UpdateQueueOutboundCallerConfigOutput, error) {
	req, out := c.UpdateQueueOutboundCallerConfigRequest(input)
	return out, req.Send()
}

// UpdateQueueOutboundCallerConfigWithContext is the same as UpdateQueueOutboundCallerConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueOutboundCallerConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQueueOutboundCallerConfigWithContext(ctx aws.Context, input *UpdateQueueOutboundCallerConfigInput, opts ...request.Option) (*UpdateQueueOutboundCallerConfigOutput, error) {
	req, out := c.UpdateQueueOutboundCallerConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQueueStatus = "UpdateQueueStatus"

// UpdateQueueStatusRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQueueStatus operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQueueStatus for more information on using the UpdateQueueStatus
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQueueStatusRequest method.
//	req, resp := client.UpdateQueueStatusRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueStatus
func (c *Connect) UpdateQueueStatusRequest(input *UpdateQueueStatusInput) (req *request.Request, output *UpdateQueueStatusOutput) {
	op := &request.Operation{
		Name:       opUpdateQueueStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/queues/{InstanceId}/{QueueId}/status",
	}

	if input == nil {
		input = &UpdateQueueStatusInput{}
	}

	output = &UpdateQueueStatusOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQueueStatus API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates the status of the queue.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQueueStatus for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQueueStatus
func (c *Connect) UpdateQueueStatus(input *UpdateQueueStatusInput) (*UpdateQueueStatusOutput, error) {
	req, out := c.UpdateQueueStatusRequest(input)
	return out, req.Send()
}

// UpdateQueueStatusWithContext is the same as UpdateQueueStatus with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQueueStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQueueStatusWithContext(ctx aws.Context, input *UpdateQueueStatusInput, opts ...request.Option) (*UpdateQueueStatusOutput, error) {
	req, out := c.UpdateQueueStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQuickConnectConfig = "UpdateQuickConnectConfig"

// UpdateQuickConnectConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQuickConnectConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQuickConnectConfig for more information on using the UpdateQuickConnectConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQuickConnectConfigRequest method.
//	req, resp := client.UpdateQuickConnectConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectConfig
func (c *Connect) UpdateQuickConnectConfigRequest(input *UpdateQuickConnectConfigInput) (req *request.Request, output *UpdateQuickConnectConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateQuickConnectConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/quick-connects/{InstanceId}/{QuickConnectId}/config",
	}

	if input == nil {
		input = &UpdateQuickConnectConfigInput{}
	}

	output = &UpdateQuickConnectConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQuickConnectConfig API operation for Amazon Connect Service.
//
// Updates the configuration settings for the specified quick connect.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQuickConnectConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectConfig
func (c *Connect) UpdateQuickConnectConfig(input *UpdateQuickConnectConfigInput) (*UpdateQuickConnectConfigOutput, error) {
	req, out := c.UpdateQuickConnectConfigRequest(input)
	return out, req.Send()
}

// UpdateQuickConnectConfigWithContext is the same as UpdateQuickConnectConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQuickConnectConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQuickConnectConfigWithContext(ctx aws.Context, input *UpdateQuickConnectConfigInput, opts ...request.Option) (*UpdateQuickConnectConfigOutput, error) {
	req, out := c.UpdateQuickConnectConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateQuickConnectName = "UpdateQuickConnectName"

// UpdateQuickConnectNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateQuickConnectName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateQuickConnectName for more information on using the UpdateQuickConnectName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateQuickConnectNameRequest method.
//	req, resp := client.UpdateQuickConnectNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectName
func (c *Connect) UpdateQuickConnectNameRequest(input *UpdateQuickConnectNameInput) (req *request.Request, output *UpdateQuickConnectNameOutput) {
	op := &request.Operation{
		Name:       opUpdateQuickConnectName,
		HTTPMethod: "POST",
		HTTPPath:   "/quick-connects/{InstanceId}/{QuickConnectId}/name",
	}

	if input == nil {
		input = &UpdateQuickConnectNameInput{}
	}

	output = &UpdateQuickConnectNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateQuickConnectName API operation for Amazon Connect Service.
//
// Updates the name and description of a quick connect. The request accepts
// the following data in JSON format. At least Name or Description must be provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateQuickConnectName for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateQuickConnectName
func (c *Connect) UpdateQuickConnectName(input *UpdateQuickConnectNameInput) (*UpdateQuickConnectNameOutput, error) {
	req, out := c.UpdateQuickConnectNameRequest(input)
	return out, req.Send()
}

// UpdateQuickConnectNameWithContext is the same as UpdateQuickConnectName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateQuickConnectName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateQuickConnectNameWithContext(ctx aws.Context, input *UpdateQuickConnectNameInput, opts ...request.Option) (*UpdateQuickConnectNameOutput, error) {
	req, out := c.UpdateQuickConnectNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingProfileConcurrency = "UpdateRoutingProfileConcurrency"

// UpdateRoutingProfileConcurrencyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingProfileConcurrency operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingProfileConcurrency for more information on using the UpdateRoutingProfileConcurrency
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingProfileConcurrencyRequest method.
//	req, resp := client.UpdateRoutingProfileConcurrencyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileConcurrency
func (c *Connect) UpdateRoutingProfileConcurrencyRequest(input *UpdateRoutingProfileConcurrencyInput) (req *request.Request, output *UpdateRoutingProfileConcurrencyOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingProfileConcurrency,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/concurrency",
	}

	if input == nil {
		input = &UpdateRoutingProfileConcurrencyInput{}
	}

	output = &UpdateRoutingProfileConcurrencyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingProfileConcurrency API operation for Amazon Connect Service.
//
// Updates the channels that agents can handle in the Contact Control Panel
// (CCP) for a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateRoutingProfileConcurrency for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileConcurrency
func (c *Connect) UpdateRoutingProfileConcurrency(input *UpdateRoutingProfileConcurrencyInput) (*UpdateRoutingProfileConcurrencyOutput, error) {
	req, out := c.UpdateRoutingProfileConcurrencyRequest(input)
	return out, req.Send()
}

// UpdateRoutingProfileConcurrencyWithContext is the same as UpdateRoutingProfileConcurrency with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingProfileConcurrency for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateRoutingProfileConcurrencyWithContext(ctx aws.Context, input *UpdateRoutingProfileConcurrencyInput, opts ...request.Option) (*UpdateRoutingProfileConcurrencyOutput, error) {
	req, out := c.UpdateRoutingProfileConcurrencyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingProfileDefaultOutboundQueue = "UpdateRoutingProfileDefaultOutboundQueue"

// UpdateRoutingProfileDefaultOutboundQueueRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingProfileDefaultOutboundQueue operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingProfileDefaultOutboundQueue for more information on using the UpdateRoutingProfileDefaultOutboundQueue
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingProfileDefaultOutboundQueueRequest method.
//	req, resp := client.UpdateRoutingProfileDefaultOutboundQueueRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileDefaultOutboundQueue
func (c *Connect) UpdateRoutingProfileDefaultOutboundQueueRequest(input *UpdateRoutingProfileDefaultOutboundQueueInput) (req *request.Request, output *UpdateRoutingProfileDefaultOutboundQueueOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingProfileDefaultOutboundQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/default-outbound-queue",
	}

	if input == nil {
		input = &UpdateRoutingProfileDefaultOutboundQueueInput{}
	}

	output = &UpdateRoutingProfileDefaultOutboundQueueOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingProfileDefaultOutboundQueue API operation for Amazon Connect Service.
//
// Updates the default outbound queue of a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateRoutingProfileDefaultOutboundQueue for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileDefaultOutboundQueue
func (c *Connect) UpdateRoutingProfileDefaultOutboundQueue(input *UpdateRoutingProfileDefaultOutboundQueueInput) (*UpdateRoutingProfileDefaultOutboundQueueOutput, error) {
	req, out := c.UpdateRoutingProfileDefaultOutboundQueueRequest(input)
	return out, req.Send()
}

// UpdateRoutingProfileDefaultOutboundQueueWithContext is the same as UpdateRoutingProfileDefaultOutboundQueue with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingProfileDefaultOutboundQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateRoutingProfileDefaultOutboundQueueWithContext(ctx aws.Context, input *UpdateRoutingProfileDefaultOutboundQueueInput, opts ...request.Option) (*UpdateRoutingProfileDefaultOutboundQueueOutput, error) {
	req, out := c.UpdateRoutingProfileDefaultOutboundQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingProfileName = "UpdateRoutingProfileName"

// UpdateRoutingProfileNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingProfileName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingProfileName for more information on using the UpdateRoutingProfileName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingProfileNameRequest method.
//	req, resp := client.UpdateRoutingProfileNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileName
func (c *Connect) UpdateRoutingProfileNameRequest(input *UpdateRoutingProfileNameInput) (req *request.Request, output *UpdateRoutingProfileNameOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingProfileName,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/name",
	}

	if input == nil {
		input = &UpdateRoutingProfileNameInput{}
	}

	output = &UpdateRoutingProfileNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingProfileName API operation for Amazon Connect Service.
//
// Updates the name and description of a routing profile. The request accepts
// the following data in JSON format. At least Name or Description must be provided.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateRoutingProfileName for usage and error information.
//
// Returned Error Types:
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileName
func (c *Connect) UpdateRoutingProfileName(input *UpdateRoutingProfileNameInput) (*UpdateRoutingProfileNameOutput, error) {
	req, out := c.UpdateRoutingProfileNameRequest(input)
	return out, req.Send()
}

// UpdateRoutingProfileNameWithContext is the same as UpdateRoutingProfileName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingProfileName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateRoutingProfileNameWithContext(ctx aws.Context, input *UpdateRoutingProfileNameInput, opts ...request.Option) (*UpdateRoutingProfileNameOutput, error) {
	req, out := c.UpdateRoutingProfileNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRoutingProfileQueues = "UpdateRoutingProfileQueues"

// UpdateRoutingProfileQueuesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRoutingProfileQueues operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRoutingProfileQueues for more information on using the UpdateRoutingProfileQueues
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRoutingProfileQueuesRequest method.
//	req, resp := client.UpdateRoutingProfileQueuesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileQueues
func (c *Connect) UpdateRoutingProfileQueuesRequest(input *UpdateRoutingProfileQueuesInput) (req *request.Request, output *UpdateRoutingProfileQueuesOutput) {
	op := &request.Operation{
		Name:       opUpdateRoutingProfileQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/routing-profiles/{InstanceId}/{RoutingProfileId}/queues",
	}

	if input == nil {
		input = &UpdateRoutingProfileQueuesInput{}
	}

	output = &UpdateRoutingProfileQueuesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRoutingProfileQueues API operation for Amazon Connect Service.
//
// Updates the properties associated with a set of queues for a routing profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateRoutingProfileQueues for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRoutingProfileQueues
func (c *Connect) UpdateRoutingProfileQueues(input *UpdateRoutingProfileQueuesInput) (*UpdateRoutingProfileQueuesOutput, error) {
	req, out := c.UpdateRoutingProfileQueuesRequest(input)
	return out, req.Send()
}

// UpdateRoutingProfileQueuesWithContext is the same as UpdateRoutingProfileQueues with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRoutingProfileQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateRoutingProfileQueuesWithContext(ctx aws.Context, input *UpdateRoutingProfileQueuesInput, opts ...request.Option) (*UpdateRoutingProfileQueuesOutput, error) {
	req, out := c.UpdateRoutingProfileQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateRule = "UpdateRule"

// UpdateRuleRequest generates a "aws/request.Request" representing the
// client's request for the UpdateRule operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateRule for more information on using the UpdateRule
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateRuleRequest method.
//	req, resp := client.UpdateRuleRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRule
func (c *Connect) UpdateRuleRequest(input *UpdateRuleInput) (req *request.Request, output *UpdateRuleOutput) {
	op := &request.Operation{
		Name:       opUpdateRule,
		HTTPMethod: "PUT",
		HTTPPath:   "/rules/{InstanceId}/{RuleId}",
	}

	if input == nil {
		input = &UpdateRuleInput{}
	}

	output = &UpdateRuleOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateRule API operation for Amazon Connect Service.
//
// Updates a rule for the specified Amazon Connect instance.
//
// Use the Rules Function language (https://docs.aws.amazon.com/connect/latest/APIReference/connect-rules-language.html)
// to code conditions for the rule.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateRule for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceConflictException
//     A resource already has that name.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateRule
func (c *Connect) UpdateRule(input *UpdateRuleInput) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	return out, req.Send()
}

// UpdateRuleWithContext is the same as UpdateRule with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateRuleWithContext(ctx aws.Context, input *UpdateRuleInput, opts ...request.Option) (*UpdateRuleOutput, error) {
	req, out := c.UpdateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateSecurityProfile = "UpdateSecurityProfile"

// UpdateSecurityProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateSecurityProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateSecurityProfile for more information on using the UpdateSecurityProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateSecurityProfileRequest method.
//	req, resp := client.UpdateSecurityProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateSecurityProfile
func (c *Connect) UpdateSecurityProfileRequest(input *UpdateSecurityProfileInput) (req *request.Request, output *UpdateSecurityProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateSecurityProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/security-profiles/{InstanceId}/{SecurityProfileId}",
	}

	if input == nil {
		input = &UpdateSecurityProfileInput{}
	}

	output = &UpdateSecurityProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateSecurityProfile API operation for Amazon Connect Service.
//
// This API is in preview release for Amazon Connect and is subject to change.
//
// Updates a security profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateSecurityProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateSecurityProfile
func (c *Connect) UpdateSecurityProfile(input *UpdateSecurityProfileInput) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	return out, req.Send()
}

// UpdateSecurityProfileWithContext is the same as UpdateSecurityProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateSecurityProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateSecurityProfileWithContext(ctx aws.Context, input *UpdateSecurityProfileInput, opts ...request.Option) (*UpdateSecurityProfileOutput, error) {
	req, out := c.UpdateSecurityProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTaskTemplate = "UpdateTaskTemplate"

// UpdateTaskTemplateRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTaskTemplate operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTaskTemplate for more information on using the UpdateTaskTemplate
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTaskTemplateRequest method.
//	req, resp := client.UpdateTaskTemplateRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateTaskTemplate
func (c *Connect) UpdateTaskTemplateRequest(input *UpdateTaskTemplateInput) (req *request.Request, output *UpdateTaskTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateTaskTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/instance/{InstanceId}/task/template/{TaskTemplateId}",
	}

	if input == nil {
		input = &UpdateTaskTemplateInput{}
	}

	output = &UpdateTaskTemplateOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateTaskTemplate API operation for Amazon Connect Service.
//
// Updates details about a specific task template in the specified Amazon Connect
// instance. This operation does not support partial updates. Instead it does
// a full update of template content.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateTaskTemplate for usage and error information.
//
// Returned Error Types:
//
//   - PropertyValidationException
//     The property is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - ServiceQuotaExceededException
//     The service quota has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateTaskTemplate
func (c *Connect) UpdateTaskTemplate(input *UpdateTaskTemplateInput) (*UpdateTaskTemplateOutput, error) {
	req, out := c.UpdateTaskTemplateRequest(input)
	return out, req.Send()
}

// UpdateTaskTemplateWithContext is the same as UpdateTaskTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTaskTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateTaskTemplateWithContext(ctx aws.Context, input *UpdateTaskTemplateInput, opts ...request.Option) (*UpdateTaskTemplateOutput, error) {
	req, out := c.UpdateTaskTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateTrafficDistribution = "UpdateTrafficDistribution"

// UpdateTrafficDistributionRequest generates a "aws/request.Request" representing the
// client's request for the UpdateTrafficDistribution operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateTrafficDistribution for more information on using the UpdateTrafficDistribution
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateTrafficDistributionRequest method.
//	req, resp := client.UpdateTrafficDistributionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateTrafficDistribution
func (c *Connect) UpdateTrafficDistributionRequest(input *UpdateTrafficDistributionInput) (req *request.Request, output *UpdateTrafficDistributionOutput) {
	op := &request.Operation{
		Name:       opUpdateTrafficDistribution,
		HTTPMethod: "PUT",
		HTTPPath:   "/traffic-distribution/{Id}",
	}

	if input == nil {
		input = &UpdateTrafficDistributionInput{}
	}

	output = &UpdateTrafficDistributionOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateTrafficDistribution API operation for Amazon Connect Service.
//
// Updates the traffic distribution for a given traffic distribution group.
//
// For more information about updating a traffic distribution group, see Update
// telephony traffic distribution across Amazon Web Services Regions (https://docs.aws.amazon.com/connect/latest/adminguide/update-telephony-traffic-distribution.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateTrafficDistribution for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - AccessDeniedException
//     You do not have sufficient permissions to perform this action.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceConflictException
//     A resource already has that name.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateTrafficDistribution
func (c *Connect) UpdateTrafficDistribution(input *UpdateTrafficDistributionInput) (*UpdateTrafficDistributionOutput, error) {
	req, out := c.UpdateTrafficDistributionRequest(input)
	return out, req.Send()
}

// UpdateTrafficDistributionWithContext is the same as UpdateTrafficDistribution with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateTrafficDistribution for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateTrafficDistributionWithContext(ctx aws.Context, input *UpdateTrafficDistributionInput, opts ...request.Option) (*UpdateTrafficDistributionOutput, error) {
	req, out := c.UpdateTrafficDistributionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserHierarchy = "UpdateUserHierarchy"

// UpdateUserHierarchyRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserHierarchy operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserHierarchy for more information on using the UpdateUserHierarchy
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserHierarchyRequest method.
//	req, resp := client.UpdateUserHierarchyRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchyRequest(input *UpdateUserHierarchyInput) (req *request.Request, output *UpdateUserHierarchyOutput) {
	op := &request.Operation{
		Name:       opUpdateUserHierarchy,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/hierarchy",
	}

	if input == nil {
		input = &UpdateUserHierarchyInput{}
	}

	output = &UpdateUserHierarchyOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserHierarchy API operation for Amazon Connect Service.
//
// Assigns the specified hierarchy group to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserHierarchy for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchy
func (c *Connect) UpdateUserHierarchy(input *UpdateUserHierarchyInput) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	return out, req.Send()
}

// UpdateUserHierarchyWithContext is the same as UpdateUserHierarchy with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserHierarchy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserHierarchyWithContext(ctx aws.Context, input *UpdateUserHierarchyInput, opts ...request.Option) (*UpdateUserHierarchyOutput, error) {
	req, out := c.UpdateUserHierarchyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserHierarchyGroupName = "UpdateUserHierarchyGroupName"

// UpdateUserHierarchyGroupNameRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserHierarchyGroupName operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserHierarchyGroupName for more information on using the UpdateUserHierarchyGroupName
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserHierarchyGroupNameRequest method.
//	req, resp := client.UpdateUserHierarchyGroupNameRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyGroupName
func (c *Connect) UpdateUserHierarchyGroupNameRequest(input *UpdateUserHierarchyGroupNameInput) (req *request.Request, output *UpdateUserHierarchyGroupNameOutput) {
	op := &request.Operation{
		Name:       opUpdateUserHierarchyGroupName,
		HTTPMethod: "POST",
		HTTPPath:   "/user-hierarchy-groups/{InstanceId}/{HierarchyGroupId}/name",
	}

	if input == nil {
		input = &UpdateUserHierarchyGroupNameInput{}
	}

	output = &UpdateUserHierarchyGroupNameOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserHierarchyGroupName API operation for Amazon Connect Service.
//
// Updates the name of the user hierarchy group.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserHierarchyGroupName for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - DuplicateResourceException
//     A resource with the specified name already exists.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyGroupName
func (c *Connect) UpdateUserHierarchyGroupName(input *UpdateUserHierarchyGroupNameInput) (*UpdateUserHierarchyGroupNameOutput, error) {
	req, out := c.UpdateUserHierarchyGroupNameRequest(input)
	return out, req.Send()
}

// UpdateUserHierarchyGroupNameWithContext is the same as UpdateUserHierarchyGroupName with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserHierarchyGroupName for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserHierarchyGroupNameWithContext(ctx aws.Context, input *UpdateUserHierarchyGroupNameInput, opts ...request.Option) (*UpdateUserHierarchyGroupNameOutput, error) {
	req, out := c.UpdateUserHierarchyGroupNameRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserHierarchyStructure = "UpdateUserHierarchyStructure"

// UpdateUserHierarchyStructureRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserHierarchyStructure operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserHierarchyStructure for more information on using the UpdateUserHierarchyStructure
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserHierarchyStructureRequest method.
//	req, resp := client.UpdateUserHierarchyStructureRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyStructure
func (c *Connect) UpdateUserHierarchyStructureRequest(input *UpdateUserHierarchyStructureInput) (req *request.Request, output *UpdateUserHierarchyStructureOutput) {
	op := &request.Operation{
		Name:       opUpdateUserHierarchyStructure,
		HTTPMethod: "POST",
		HTTPPath:   "/user-hierarchy-structure/{InstanceId}",
	}

	if input == nil {
		input = &UpdateUserHierarchyStructureInput{}
	}

	output = &UpdateUserHierarchyStructureOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserHierarchyStructure API operation for Amazon Connect Service.
//
// Updates the user hierarchy structure: add, remove, and rename user hierarchy
// levels.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserHierarchyStructure for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ResourceInUseException
//     That resource is already in use. Please try another.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserHierarchyStructure
func (c *Connect) UpdateUserHierarchyStructure(input *UpdateUserHierarchyStructureInput) (*UpdateUserHierarchyStructureOutput, error) {
	req, out := c.UpdateUserHierarchyStructureRequest(input)
	return out, req.Send()
}

// UpdateUserHierarchyStructureWithContext is the same as UpdateUserHierarchyStructure with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserHierarchyStructure for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserHierarchyStructureWithContext(ctx aws.Context, input *UpdateUserHierarchyStructureInput, opts ...request.Option) (*UpdateUserHierarchyStructureOutput, error) {
	req, out := c.UpdateUserHierarchyStructureRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserIdentityInfo = "UpdateUserIdentityInfo"

// UpdateUserIdentityInfoRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserIdentityInfo operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserIdentityInfo for more information on using the UpdateUserIdentityInfo
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserIdentityInfoRequest method.
//	req, resp := client.UpdateUserIdentityInfoRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfoRequest(input *UpdateUserIdentityInfoInput) (req *request.Request, output *UpdateUserIdentityInfoOutput) {
	op := &request.Operation{
		Name:       opUpdateUserIdentityInfo,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/identity-info",
	}

	if input == nil {
		input = &UpdateUserIdentityInfoInput{}
	}

	output = &UpdateUserIdentityInfoOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserIdentityInfo API operation for Amazon Connect Service.
//
// Updates the identity information for the specified user.
//
// We strongly recommend limiting who has the ability to invoke UpdateUserIdentityInfo.
// Someone with that ability can change the login credentials of other users
// by changing their email address. This poses a security risk to your organization.
// They can change the email address of a user to the attacker's email address,
// and then reset the password through email. For more information, see Best
// Practices for Security Profiles (https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-best-practices.html)
// in the Amazon Connect Administrator Guide.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserIdentityInfo for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserIdentityInfo
func (c *Connect) UpdateUserIdentityInfo(input *UpdateUserIdentityInfoInput) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	return out, req.Send()
}

// UpdateUserIdentityInfoWithContext is the same as UpdateUserIdentityInfo with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserIdentityInfo for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserIdentityInfoWithContext(ctx aws.Context, input *UpdateUserIdentityInfoInput, opts ...request.Option) (*UpdateUserIdentityInfoOutput, error) {
	req, out := c.UpdateUserIdentityInfoRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserPhoneConfig = "UpdateUserPhoneConfig"

// UpdateUserPhoneConfigRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserPhoneConfig operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserPhoneConfig for more information on using the UpdateUserPhoneConfig
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserPhoneConfigRequest method.
//	req, resp := client.UpdateUserPhoneConfigRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfigRequest(input *UpdateUserPhoneConfigInput) (req *request.Request, output *UpdateUserPhoneConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateUserPhoneConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/phone-config",
	}

	if input == nil {
		input = &UpdateUserPhoneConfigInput{}
	}

	output = &UpdateUserPhoneConfigOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserPhoneConfig API operation for Amazon Connect Service.
//
// Updates the phone configuration settings for the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserPhoneConfig for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserPhoneConfig
func (c *Connect) UpdateUserPhoneConfig(input *UpdateUserPhoneConfigInput) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	return out, req.Send()
}

// UpdateUserPhoneConfigWithContext is the same as UpdateUserPhoneConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserPhoneConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserPhoneConfigWithContext(ctx aws.Context, input *UpdateUserPhoneConfigInput, opts ...request.Option) (*UpdateUserPhoneConfigOutput, error) {
	req, out := c.UpdateUserPhoneConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserRoutingProfile = "UpdateUserRoutingProfile"

// UpdateUserRoutingProfileRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserRoutingProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserRoutingProfile for more information on using the UpdateUserRoutingProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserRoutingProfileRequest method.
//	req, resp := client.UpdateUserRoutingProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfileRequest(input *UpdateUserRoutingProfileInput) (req *request.Request, output *UpdateUserRoutingProfileOutput) {
	op := &request.Operation{
		Name:       opUpdateUserRoutingProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/routing-profile",
	}

	if input == nil {
		input = &UpdateUserRoutingProfileInput{}
	}

	output = &UpdateUserRoutingProfileOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserRoutingProfile API operation for Amazon Connect Service.
//
// Assigns the specified routing profile to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserRoutingProfile for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserRoutingProfile
func (c *Connect) UpdateUserRoutingProfile(input *UpdateUserRoutingProfileInput) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	return out, req.Send()
}

// UpdateUserRoutingProfileWithContext is the same as UpdateUserRoutingProfile with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserRoutingProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserRoutingProfileWithContext(ctx aws.Context, input *UpdateUserRoutingProfileInput, opts ...request.Option) (*UpdateUserRoutingProfileOutput, error) {
	req, out := c.UpdateUserRoutingProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateUserSecurityProfiles = "UpdateUserSecurityProfiles"

// UpdateUserSecurityProfilesRequest generates a "aws/request.Request" representing the
// client's request for the UpdateUserSecurityProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateUserSecurityProfiles for more information on using the UpdateUserSecurityProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateUserSecurityProfilesRequest method.
//	req, resp := client.UpdateUserSecurityProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfilesRequest(input *UpdateUserSecurityProfilesInput) (req *request.Request, output *UpdateUserSecurityProfilesOutput) {
	op := &request.Operation{
		Name:       opUpdateUserSecurityProfiles,
		HTTPMethod: "POST",
		HTTPPath:   "/users/{InstanceId}/{UserId}/security-profiles",
	}

	if input == nil {
		input = &UpdateUserSecurityProfilesInput{}
	}

	output = &UpdateUserSecurityProfilesOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateUserSecurityProfiles API operation for Amazon Connect Service.
//
// Assigns the specified security profiles to the specified user.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Connect Service's
// API operation UpdateUserSecurityProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidRequestException
//     The request is not valid.
//
//   - InvalidParameterException
//     One or more of the specified parameters are not valid.
//
//   - ResourceNotFoundException
//     The specified resource was not found.
//
//   - ThrottlingException
//     The throttling limit has been exceeded.
//
//   - InternalServiceException
//     Request processing failed because of an error or failure with the service.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/connect-2017-08-08/UpdateUserSecurityProfiles
func (c *Connect) UpdateUserSecurityProfiles(input *UpdateUserSecurityProfilesInput) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	return out, req.Send()
}

// UpdateUserSecurityProfilesWithContext is the same as UpdateUserSecurityProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateUserSecurityProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Connect) UpdateUserSecurityProfilesWithContext(ctx aws.Context, input *UpdateUserSecurityProfilesInput, opts ...request.Option) (*UpdateUserSecurityProfilesOutput, error) {
	req, out := c.UpdateUserSecurityProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient permissions to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Information about an action.
type ActionSummary struct {
	_ struct{} `type:"structure"`

	// The action type.
	//
	// ActionType is a required field
	ActionType *string `type:"string" required:"true" enum:"ActionType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActionSummary) GoString() string {
	return s.String()
}

// SetActionType sets the ActionType field's value.
func (s *ActionSummary) SetActionType(v string) *ActionSummary {
	s.ActionType = &v
	return s
}

type ActivateEvaluationFormInput struct {
	_ struct{} `type:"structure"`

	// The unique identifier for the evaluation form.
	//
	// EvaluationFormId is a required field
	EvaluationFormId *string `location:"uri" locationName:"EvaluationFormId" min:"1" type:"string" required:"true"`

	// The version of the evaluation form to activate. If the version property is
	// not provided, the latest version of the evaluation form is activated.
	//
	// EvaluationFormVersion is a required field
	EvaluationFormVersion *int64 `min:"1" type:"integer" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEvaluationFormInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEvaluationFormInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ActivateEvaluationFormInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ActivateEvaluationFormInput"}
	if s.EvaluationFormId == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationFormId"))
	}
	if s.EvaluationFormId != nil && len(*s.EvaluationFormId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EvaluationFormId", 1))
	}
	if s.EvaluationFormVersion == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationFormVersion"))
	}
	if s.EvaluationFormVersion != nil && *s.EvaluationFormVersion < 1 {
		invalidParams.Add(request.NewErrParamMinValue("EvaluationFormVersion", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEvaluationFormId sets the EvaluationFormId field's value.
func (s *ActivateEvaluationFormInput) SetEvaluationFormId(v string) *ActivateEvaluationFormInput {
	s.EvaluationFormId = &v
	return s
}

// SetEvaluationFormVersion sets the EvaluationFormVersion field's value.
func (s *ActivateEvaluationFormInput) SetEvaluationFormVersion(v int64) *ActivateEvaluationFormInput {
	s.EvaluationFormVersion = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *ActivateEvaluationFormInput) SetInstanceId(v string) *ActivateEvaluationFormInput {
	s.InstanceId = &v
	return s
}

type ActivateEvaluationFormOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the evaluation form resource.
	//
	// EvaluationFormArn is a required field
	EvaluationFormArn *string `type:"string" required:"true"`

	// The unique identifier for the evaluation form.
	//
	// EvaluationFormId is a required field
	EvaluationFormId *string `min:"1" type:"string" required:"true"`

	// A version of the evaluation form.
	//
	// EvaluationFormVersion is a required field
	EvaluationFormVersion *int64 `min:"1" type:"integer" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEvaluationFormOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ActivateEvaluationFormOutput) GoString() string {
	return s.String()
}

// SetEvaluationFormArn sets the EvaluationFormArn field's value.
func (s *ActivateEvaluationFormOutput) SetEvaluationFormArn(v string) *ActivateEvaluationFormOutput {
	s.EvaluationFormArn = &v
	return s
}

// SetEvaluationFormId sets the EvaluationFormId field's value.
func (s *ActivateEvaluationFormOutput) SetEvaluationFormId(v string) *ActivateEvaluationFormOutput {
	s.EvaluationFormId = &v
	return s
}

// SetEvaluationFormVersion sets the EvaluationFormVersion field's value.
func (s *ActivateEvaluationFormOutput) SetEvaluationFormVersion(v int64) *ActivateEvaluationFormOutput {
	s.EvaluationFormVersion = &v
	return s
}

// Information about the contact (https://docs.aws.amazon.com/connect/latest/APIReference/API_Contact.html)
// associated to the user.
type AgentContactReference struct {
	_ struct{} `type:"structure"`

	// The state of the contact (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
	AgentContactState *string `type:"string" enum:"ContactState"`

	// The channel of the contact.
	Channel *string `type:"string" enum:"Channel"`

	// The time at which the contact was connected to an agent.
	ConnectedToAgentTimestamp *time.Time `type:"timestamp"`

	// The identifier of the contact in this instance of Amazon Connect.
	ContactId *string `min:"1" type:"string"`

	// How the contact was initiated.
	InitiationMethod *string `type:"string" enum:"ContactInitiationMethod"`

	// Contains information about a queue resource for which metrics are returned.
	Queue *QueueReference `type:"structure"`

	// The epoch timestamp when the contact state started.
	StateStartTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentContactReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentContactReference) GoString() string {
	return s.String()
}

// SetAgentContactState sets the AgentContactState field's value.
func (s *AgentContactReference) SetAgentContactState(v string) *AgentContactReference {
	s.AgentContactState = &v
	return s
}

// SetChannel sets the Channel field's value.
func (s *AgentContactReference) SetChannel(v string) *AgentContactReference {
	s.Channel = &v
	return s
}

// SetConnectedToAgentTimestamp sets the ConnectedToAgentTimestamp field's value.
func (s *AgentContactReference) SetConnectedToAgentTimestamp(v time.Time) *AgentContactReference {
	s.ConnectedToAgentTimestamp = &v
	return s
}

// SetContactId sets the ContactId field's value.
func (s *AgentContactReference) SetContactId(v string) *AgentContactReference {
	s.ContactId = &v
	return s
}

// SetInitiationMethod sets the InitiationMethod field's value.
func (s *AgentContactReference) SetInitiationMethod(v string) *AgentContactReference {
	s.InitiationMethod = &v
	return s
}

// SetQueue sets the Queue field's value.
func (s *AgentContactReference) SetQueue(v *QueueReference) *AgentContactReference {
	s.Queue = v
	return s
}

// SetStateStartTimestamp sets the StateStartTimestamp field's value.
func (s *AgentContactReference) SetStateStartTimestamp(v time.Time) *AgentContactReference {
	s.StateStartTimestamp = &v
	return s
}

// Information about the agent who accepted the contact.
type AgentInfo struct {
	_ struct{} `type:"structure"`

	// The timestamp when the contact was connected to the agent.
	ConnectedToAgentTimestamp *time.Time `type:"timestamp"`

	// The identifier of the agent who accepted the contact.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentInfo) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentInfo) GoString() string {
	return s.String()
}

// SetConnectedToAgentTimestamp sets the ConnectedToAgentTimestamp field's value.
func (s *AgentInfo) SetConnectedToAgentTimestamp(v time.Time) *AgentInfo {
	s.ConnectedToAgentTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *AgentInfo) SetId(v string) *AgentInfo {
	s.Id = &v
	return s
}

// Contains information about an agent status.
type AgentStatus struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent status.
	AgentStatusARN *string `type:"string"`

	// The identifier of the agent status.
	AgentStatusId *string `type:"string"`

	// The description of the agent status.
	Description *string `min:"1" type:"string"`

	// The display order of the agent status.
	DisplayOrder *int64 `min:"1" type:"integer"`

	// The name of the agent status.
	Name *string `min:"1" type:"string"`

	// The state of the agent status.
	State *string `type:"string" enum:"AgentStatusState"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The type of agent status.
	Type *string `type:"string" enum:"AgentStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatus) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatus) GoString() string {
	return s.String()
}

// SetAgentStatusARN sets the AgentStatusARN field's value.
func (s *AgentStatus) SetAgentStatusARN(v string) *AgentStatus {
	s.AgentStatusARN = &v
	return s
}

// SetAgentStatusId sets the AgentStatusId field's value.
func (s *AgentStatus) SetAgentStatusId(v string) *AgentStatus {
	s.AgentStatusId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AgentStatus) SetDescription(v string) *AgentStatus {
	s.Description = &v
	return s
}

// SetDisplayOrder sets the DisplayOrder field's value.
func (s *AgentStatus) SetDisplayOrder(v int64) *AgentStatus {
	s.DisplayOrder = &v
	return s
}

// SetName sets the Name field's value.
func (s *AgentStatus) SetName(v string) *AgentStatus {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *AgentStatus) SetState(v string) *AgentStatus {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AgentStatus) SetTags(v map[string]*string) *AgentStatus {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *AgentStatus) SetType(v string) *AgentStatus {
	s.Type = &v
	return s
}

// Information about the agent's status.
type AgentStatusReference struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent's status.
	StatusArn *string `type:"string"`

	// The name of the agent status.
	StatusName *string `min:"1" type:"string"`

	// The start timestamp of the agent's status.
	StatusStartTimestamp *time.Time `type:"timestamp"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatusReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatusReference) GoString() string {
	return s.String()
}

// SetStatusArn sets the StatusArn field's value.
func (s *AgentStatusReference) SetStatusArn(v string) *AgentStatusReference {
	s.StatusArn = &v
	return s
}

// SetStatusName sets the StatusName field's value.
func (s *AgentStatusReference) SetStatusName(v string) *AgentStatusReference {
	s.StatusName = &v
	return s
}

// SetStatusStartTimestamp sets the StatusStartTimestamp field's value.
func (s *AgentStatusReference) SetStatusStartTimestamp(v time.Time) *AgentStatusReference {
	s.StatusStartTimestamp = &v
	return s
}

// Summary information for an agent status.
type AgentStatusSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the agent status.
	Arn *string `type:"string"`

	// The identifier for an agent status.
	Id *string `type:"string"`

	// The name of the agent status.
	Name *string `min:"1" type:"string"`

	// The type of the agent status.
	Type *string `type:"string" enum:"AgentStatusType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatusSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AgentStatusSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *AgentStatusSummary) SetArn(v string) *AgentStatusSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *AgentStatusSummary) SetId(v string) *AgentStatusSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *AgentStatusSummary) SetName(v string) *AgentStatusSummary {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *AgentStatusSummary) SetType(v string) *AgentStatusSummary {
	s.Type = &v
	return s
}

// Configuration of the answering machine detection.
type AnswerMachineDetectionConfig struct {
	_ struct{} `type:"structure"`

	// Wait for the answering machine prompt.
	AwaitAnswerMachinePrompt *bool `type:"boolean"`

	// The flag to indicate if answer machine detection analysis needs to be performed
	// for a voice call. If set to true, TrafficType must be set as CAMPAIGN.
	EnableAnswerMachineDetection *bool `type:"boolean"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerMachineDetectionConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnswerMachineDetectionConfig) GoString() string {
	return s.String()
}

// SetAwaitAnswerMachinePrompt sets the AwaitAnswerMachinePrompt field's value.
func (s *AnswerMachineDetectionConfig) SetAwaitAnswerMachinePrompt(v bool) *AnswerMachineDetectionConfig {
	s.AwaitAnswerMachinePrompt = &v
	return s
}

// SetEnableAnswerMachineDetection sets the EnableAnswerMachineDetection field's value.
func (s *AnswerMachineDetectionConfig) SetEnableAnswerMachineDetection(v bool) *AnswerMachineDetectionConfig {
	s.EnableAnswerMachineDetection = &v
	return s
}

// This action must be set if TriggerEventSource is one of the following values:
// OnPostCallAnalysisAvailable | OnRealTimeCallAnalysisAvailable | OnPostChatAnalysisAvailable.
// Contact is categorized using the rule name.
//
// RuleName is used as ContactCategory.
type AssignContactCategoryActionDefinition struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignContactCategoryActionDefinition) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssignContactCategoryActionDefinition) GoString() string {
	return s.String()
}

type AssociateApprovedOriginInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The domain to add to your allow list.
	//
	// Origin is a required field
	Origin *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateApprovedOriginInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateApprovedOriginInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateApprovedOriginInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateApprovedOriginInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Origin == nil {
		invalidParams.Add(request.NewErrParamRequired("Origin"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateApprovedOriginInput) SetInstanceId(v string) *AssociateApprovedOriginInput {
	s.InstanceId = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *AssociateApprovedOriginInput) SetOrigin(v string) *AssociateApprovedOriginInput {
	s.Origin = &v
	return s
}

type AssociateApprovedOriginOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateApprovedOriginOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateApprovedOriginOutput) GoString() string {
	return s.String()
}

type AssociateBotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Configuration information of an Amazon Lex bot.
	LexBot *LexBot `type:"structure"`

	// The Amazon Lex V2 bot to associate with the instance.
	LexV2Bot *LexV2Bot `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateBotInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LexBot != nil {
		if err := s.LexBot.Validate(); err != nil {
			invalidParams.AddNested("LexBot", err.(request.ErrInvalidParams))
		}
	}
	if s.LexV2Bot != nil {
		if err := s.LexV2Bot.Validate(); err != nil {
			invalidParams.AddNested("LexV2Bot", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateBotInput) SetInstanceId(v string) *AssociateBotInput {
	s.InstanceId = &v
	return s
}

// SetLexBot sets the LexBot field's value.
func (s *AssociateBotInput) SetLexBot(v *LexBot) *AssociateBotInput {
	s.LexBot = v
	return s
}

// SetLexV2Bot sets the LexV2Bot field's value.
func (s *AssociateBotInput) SetLexV2Bot(v *LexV2Bot) *AssociateBotInput {
	s.LexV2Bot = v
	return s
}

type AssociateBotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateBotOutput) GoString() string {
	return s.String()
}

type AssociateDefaultVocabularyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The language code of the vocabulary entries. For a list of languages and
	// their corresponding language codes, see What is Amazon Transcribe? (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// LanguageCode is a required field
	LanguageCode *string `location:"uri" locationName:"LanguageCode" type:"string" required:"true" enum:"VocabularyLanguageCode"`

	// The identifier of the custom vocabulary. If this is empty, the default is
	// set to none.
	VocabularyId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateDefaultVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateDefaultVocabularyInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.LanguageCode != nil && len(*s.LanguageCode) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("LanguageCode", 1))
	}
	if s.VocabularyId != nil && len(*s.VocabularyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateDefaultVocabularyInput) SetInstanceId(v string) *AssociateDefaultVocabularyInput {
	s.InstanceId = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *AssociateDefaultVocabularyInput) SetLanguageCode(v string) *AssociateDefaultVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetVocabularyId sets the VocabularyId field's value.
func (s *AssociateDefaultVocabularyInput) SetVocabularyId(v string) *AssociateDefaultVocabularyInput {
	s.VocabularyId = &v
	return s
}

type AssociateDefaultVocabularyOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultVocabularyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateDefaultVocabularyOutput) GoString() string {
	return s.String()
}

type AssociateInstanceStorageConfigInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// A valid resource type.
	//
	// ResourceType is a required field
	ResourceType *string `type:"string" required:"true" enum:"InstanceStorageResourceType"`

	// A valid storage type.
	//
	// StorageConfig is a required field
	StorageConfig *InstanceStorageConfig `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateInstanceStorageConfigInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateInstanceStorageConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateInstanceStorageConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateInstanceStorageConfigInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.ResourceType == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceType"))
	}
	if s.StorageConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("StorageConfig"))
	}
	if s.StorageConfig != nil {
		if err := s.StorageConfig.Validate(); err != nil {
			invalidParams.AddNested("StorageConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateInstanceStorageConfigInput) SetInstanceId(v string) *AssociateInstanceStorageConfigInput {
	s.InstanceId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *AssociateInstanceStorageConfigInput) SetResourceType(v string) *AssociateInstanceStorageConfigInput {
	s.ResourceType = &v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *AssociateInstanceStorageConfigInput) SetStorageConfig(v *InstanceStorageConfig) *AssociateInstanceStorageConfigInput {
	s.StorageConfig = v
	return s
}

type AssociateInstanceStorageConfigOutput struct {
	_ struct{} `type:"structure"`

	// The existing association identifier that uniquely identifies the resource
	// type and storage config for the given instance ID.
	AssociationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateInstanceStorageConfigOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateInstanceStorageConfigOutput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociateInstanceStorageConfigOutput) SetAssociationId(v string) *AssociateInstanceStorageConfigOutput {
	s.AssociationId = &v
	return s
}

type AssociateLambdaFunctionInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the Lambda function being associated.
	// Maximum number of characters allowed is 140.
	//
	// FunctionArn is a required field
	FunctionArn *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLambdaFunctionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLambdaFunctionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLambdaFunctionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLambdaFunctionInput"}
	if s.FunctionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FunctionArn"))
	}
	if s.FunctionArn != nil && len(*s.FunctionArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FunctionArn", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFunctionArn sets the FunctionArn field's value.
func (s *AssociateLambdaFunctionInput) SetFunctionArn(v string) *AssociateLambdaFunctionInput {
	s.FunctionArn = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateLambdaFunctionInput) SetInstanceId(v string) *AssociateLambdaFunctionInput {
	s.InstanceId = &v
	return s
}

type AssociateLambdaFunctionOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLambdaFunctionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLambdaFunctionOutput) GoString() string {
	return s.String()
}

type AssociateLexBotInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The Amazon Lex bot to associate with the instance.
	//
	// LexBot is a required field
	LexBot *LexBot `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLexBotInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLexBotInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateLexBotInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateLexBotInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LexBot == nil {
		invalidParams.Add(request.NewErrParamRequired("LexBot"))
	}
	if s.LexBot != nil {
		if err := s.LexBot.Validate(); err != nil {
			invalidParams.AddNested("LexBot", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateLexBotInput) SetInstanceId(v string) *AssociateLexBotInput {
	s.InstanceId = &v
	return s
}

// SetLexBot sets the LexBot field's value.
func (s *AssociateLexBotInput) SetLexBot(v *LexBot) *AssociateLexBotInput {
	s.LexBot = v
	return s
}

type AssociateLexBotOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLexBotOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateLexBotOutput) GoString() string {
	return s.String()
}

type AssociatePhoneNumberContactFlowInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the flow.
	//
	// ContactFlowId is a required field
	ContactFlowId *string `type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// A unique identifier for the phone number.
	//
	// PhoneNumberId is a required field
	PhoneNumberId *string `location:"uri" locationName:"PhoneNumberId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberContactFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberContactFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociatePhoneNumberContactFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociatePhoneNumberContactFlowInput"}
	if s.ContactFlowId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactFlowId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneNumberId == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumberId"))
	}
	if s.PhoneNumberId != nil && len(*s.PhoneNumberId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("PhoneNumberId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *AssociatePhoneNumberContactFlowInput) SetContactFlowId(v string) *AssociatePhoneNumberContactFlowInput {
	s.ContactFlowId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociatePhoneNumberContactFlowInput) SetInstanceId(v string) *AssociatePhoneNumberContactFlowInput {
	s.InstanceId = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *AssociatePhoneNumberContactFlowInput) SetPhoneNumberId(v string) *AssociatePhoneNumberContactFlowInput {
	s.PhoneNumberId = &v
	return s
}

type AssociatePhoneNumberContactFlowOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberContactFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociatePhoneNumberContactFlowOutput) GoString() string {
	return s.String()
}

type AssociateQueueQuickConnectsInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier for the queue.
	//
	// QueueId is a required field
	QueueId *string `location:"uri" locationName:"QueueId" type:"string" required:"true"`

	// The quick connects to associate with this queue.
	//
	// QuickConnectIds is a required field
	QuickConnectIds []*string `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQueueQuickConnectsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQueueQuickConnectsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateQueueQuickConnectsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateQueueQuickConnectsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.QueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueId"))
	}
	if s.QueueId != nil && len(*s.QueueId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueId", 1))
	}
	if s.QuickConnectIds == nil {
		invalidParams.Add(request.NewErrParamRequired("QuickConnectIds"))
	}
	if s.QuickConnectIds != nil && len(s.QuickConnectIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuickConnectIds", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateQueueQuickConnectsInput) SetInstanceId(v string) *AssociateQueueQuickConnectsInput {
	s.InstanceId = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *AssociateQueueQuickConnectsInput) SetQueueId(v string) *AssociateQueueQuickConnectsInput {
	s.QueueId = &v
	return s
}

// SetQuickConnectIds sets the QuickConnectIds field's value.
func (s *AssociateQueueQuickConnectsInput) SetQuickConnectIds(v []*string) *AssociateQueueQuickConnectsInput {
	s.QuickConnectIds = v
	return s
}

type AssociateQueueQuickConnectsOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQueueQuickConnectsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateQueueQuickConnectsOutput) GoString() string {
	return s.String()
}

type AssociateRoutingProfileQueuesInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The queues to associate with this routing profile.
	//
	// QueueConfigs is a required field
	QueueConfigs []*RoutingProfileQueueConfig `min:"1" type:"list" required:"true"`

	// The identifier of the routing profile.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `location:"uri" locationName:"RoutingProfileId" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateRoutingProfileQueuesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateRoutingProfileQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateRoutingProfileQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateRoutingProfileQueuesInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.QueueConfigs == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueConfigs"))
	}
	if s.QueueConfigs != nil && len(s.QueueConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueConfigs", 1))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.RoutingProfileId != nil && len(*s.RoutingProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("RoutingProfileId", 1))
	}
	if s.QueueConfigs != nil {
		for i, v := range s.QueueConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateRoutingProfileQueuesInput) SetInstanceId(v string) *AssociateRoutingProfileQueuesInput {
	s.InstanceId = &v
	return s
}

// SetQueueConfigs sets the QueueConfigs field's value.
func (s *AssociateRoutingProfileQueuesInput) SetQueueConfigs(v []*RoutingProfileQueueConfig) *AssociateRoutingProfileQueuesInput {
	s.QueueConfigs = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *AssociateRoutingProfileQueuesInput) SetRoutingProfileId(v string) *AssociateRoutingProfileQueuesInput {
	s.RoutingProfileId = &v
	return s
}

type AssociateRoutingProfileQueuesOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateRoutingProfileQueuesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateRoutingProfileQueuesOutput) GoString() string {
	return s.String()
}

type AssociateSecurityKeyInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// A valid security key in PEM format.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSecurityKeyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSecurityKeyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateSecurityKeyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateSecurityKeyInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *AssociateSecurityKeyInput) SetInstanceId(v string) *AssociateSecurityKeyInput {
	s.InstanceId = &v
	return s
}

// SetKey sets the Key field's value.
func (s *AssociateSecurityKeyInput) SetKey(v string) *AssociateSecurityKeyInput {
	s.Key = &v
	return s
}

type AssociateSecurityKeyOutput struct {
	_ struct{} `type:"structure"`

	// The existing association identifier that uniquely identifies the resource
	// type and storage config for the given instance ID.
	AssociationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSecurityKeyOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateSecurityKeyOutput) GoString() string {
	return s.String()
}

// SetAssociationId sets the AssociationId field's value.
func (s *AssociateSecurityKeyOutput) SetAssociationId(v string) *AssociateSecurityKeyOutput {
	s.AssociationId = &v
	return s
}

// Information about a reference when the referenceType is ATTACHMENT. Otherwise,
// null.
type AttachmentReference struct {
	_ struct{} `type:"structure"`

	// Identifier of the attachment reference.
	Name *string `min:"1" type:"string"`

	// Status of the attachment reference type.
	Status *string `type:"string" enum:"ReferenceStatus"`

	// The location path of the attachment reference.
	Value *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentReference) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AttachmentReference) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *AttachmentReference) SetName(v string) *AttachmentReference {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *AttachmentReference) SetStatus(v string) *AttachmentReference {
	s.Status = &v
	return s
}

// SetValue sets the Value field's value.
func (s *AttachmentReference) SetValue(v string) *AttachmentReference {
	s.Value = &v
	return s
}

// A toggle for an individual feature at the instance level.
type Attribute struct {
	_ struct{} `type:"structure"`

	// The type of attribute.
	AttributeType *string `type:"string" enum:"InstanceAttributeType"`

	// The value of the attribute.
	Value *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Attribute) GoString() string {
	return s.String()
}

// SetAttributeType sets the AttributeType field's value.
func (s *Attribute) SetAttributeType(v string) *Attribute {
	s.AttributeType = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Attribute) SetValue(v string) *Attribute {
	s.Value = &v
	return s
}

// Information about available phone numbers.
type AvailableNumberSummary struct {
	_ struct{} `type:"structure"`

	// The phone number. Phone numbers are formatted [+] [country code] [subscriber
	// number including area code].
	PhoneNumber *string `type:"string"`

	// The ISO country code.
	PhoneNumberCountryCode *string `type:"string" enum:"PhoneNumberCountryCode"`

	// The type of phone number.
	PhoneNumberType *string `type:"string" enum:"PhoneNumberType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailableNumberSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AvailableNumberSummary) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *AvailableNumberSummary) SetPhoneNumber(v string) *AvailableNumberSummary {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberCountryCode sets the PhoneNumberCountryCode field's value.
func (s *AvailableNumberSummary) SetPhoneNumberCountryCode(v string) *AvailableNumberSummary {
	s.PhoneNumberCountryCode = &v
	return s
}

// SetPhoneNumberType sets the PhoneNumberType field's value.
func (s *AvailableNumberSummary) SetPhoneNumberType(v string) *AvailableNumberSummary {
	s.PhoneNumberType = &v
	return s
}

// A chat message.
type ChatMessage struct {
	_ struct{} `type:"structure"`

	// The content of the chat message.
	//
	//    * For text/plain and text/markdown, the Length Constraints are Minimum
	//    of 1, Maximum of 1024.
	//
	//    * For application/json, the Length Constraints are Minimum of 1, Maximum
	//    of 12000.
	//
	//    * For application/vnd.amazonaws.connect.message.interactive.response,
	//    the Length Constraints are Minimum of 1, Maximum of 12288.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The type of the content. Supported types are text/plain, text/markdown, application/json,
	// and application/vnd.amazonaws.connect.message.interactive.response.
	//
	// ContentType is a required field
	ContentType *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatMessage) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatMessage) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatMessage) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatMessage"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.ContentType == nil {
		invalidParams.Add(request.NewErrParamRequired("ContentType"))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContentType", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *ChatMessage) SetContent(v string) *ChatMessage {
	s.Content = &v
	return s
}

// SetContentType sets the ContentType field's value.
func (s *ChatMessage) SetContentType(v string) *ChatMessage {
	s.ContentType = &v
	return s
}

// Configuration information for the chat participant role.
type ChatParticipantRoleConfig struct {
	_ struct{} `type:"structure"`

	// A list of participant timers. You can specify any unique combination of role
	// and timer type. Duplicate entries error out the request with a 400.
	//
	// ParticipantTimerConfigList is a required field
	ParticipantTimerConfigList []*ParticipantTimerConfiguration `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatParticipantRoleConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatParticipantRoleConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatParticipantRoleConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatParticipantRoleConfig"}
	if s.ParticipantTimerConfigList == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantTimerConfigList"))
	}
	if s.ParticipantTimerConfigList != nil && len(s.ParticipantTimerConfigList) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ParticipantTimerConfigList", 1))
	}
	if s.ParticipantTimerConfigList != nil {
		for i, v := range s.ParticipantTimerConfigList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "ParticipantTimerConfigList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetParticipantTimerConfigList sets the ParticipantTimerConfigList field's value.
func (s *ChatParticipantRoleConfig) SetParticipantTimerConfigList(v []*ParticipantTimerConfiguration) *ChatParticipantRoleConfig {
	s.ParticipantTimerConfigList = v
	return s
}

// The streaming configuration, such as the Amazon SNS streaming endpoint.
type ChatStreamingConfiguration struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the standard Amazon SNS topic. The Amazon
	// Resource Name (ARN) of the streaming endpoint that is used to publish real-time
	// message streaming for chat conversations.
	//
	// StreamingEndpointArn is a required field
	StreamingEndpointArn *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatStreamingConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ChatStreamingConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ChatStreamingConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ChatStreamingConfiguration"}
	if s.StreamingEndpointArn == nil {
		invalidParams.Add(request.NewErrParamRequired("StreamingEndpointArn"))
	}
	if s.StreamingEndpointArn != nil && len(*s.StreamingEndpointArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("StreamingEndpointArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetStreamingEndpointArn sets the StreamingEndpointArn field's value.
func (s *ChatStreamingConfiguration) SetStreamingEndpointArn(v string) *ChatStreamingConfiguration {
	s.StreamingEndpointArn = &v
	return s
}

type ClaimPhoneNumberInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	//
	// Pattern: ^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The phone number you want to claim. Phone numbers are formatted [+] [country
	// code] [subscriber number including area code].
	//
	// PhoneNumber is a required field
	PhoneNumber *string `type:"string" required:"true"`

	// The description of the phone number.
	PhoneNumberDescription *string `type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution
	// groups that phone numbers are claimed to.
	//
	// TargetArn is a required field
	TargetArn *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimPhoneNumberInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimPhoneNumberInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ClaimPhoneNumberInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ClaimPhoneNumberInput"}
	if s.PhoneNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNumber"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TargetArn == nil {
		invalidParams.Add(request.NewErrParamRequired("TargetArn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *ClaimPhoneNumberInput) SetClientToken(v string) *ClaimPhoneNumberInput {
	s.ClientToken = &v
	return s
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *ClaimPhoneNumberInput) SetPhoneNumber(v string) *ClaimPhoneNumberInput {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberDescription sets the PhoneNumberDescription field's value.
func (s *ClaimPhoneNumberInput) SetPhoneNumberDescription(v string) *ClaimPhoneNumberInput {
	s.PhoneNumberDescription = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClaimPhoneNumberInput) SetTags(v map[string]*string) *ClaimPhoneNumberInput {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ClaimPhoneNumberInput) SetTargetArn(v string) *ClaimPhoneNumberInput {
	s.TargetArn = &v
	return s
}

type ClaimPhoneNumberOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the phone number.
	PhoneNumberArn *string `type:"string"`

	// A unique identifier for the phone number.
	PhoneNumberId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimPhoneNumberOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimPhoneNumberOutput) GoString() string {
	return s.String()
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *ClaimPhoneNumberOutput) SetPhoneNumberArn(v string) *ClaimPhoneNumberOutput {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *ClaimPhoneNumberOutput) SetPhoneNumberId(v string) *ClaimPhoneNumberOutput {
	s.PhoneNumberId = &v
	return s
}

// Information about a phone number that has been claimed to your Amazon Connect
// instance or traffic distribution group.
type ClaimedPhoneNumberSummary struct {
	_ struct{} `type:"structure"`

	// The phone number. Phone numbers are formatted [+] [country code] [subscriber
	// number including area code].
	PhoneNumber *string `type:"string"`

	// The Amazon Resource Name (ARN) of the phone number.
	PhoneNumberArn *string `type:"string"`

	// The ISO country code.
	PhoneNumberCountryCode *string `type:"string" enum:"PhoneNumberCountryCode"`

	// The description of the phone number.
	PhoneNumberDescription *string `type:"string"`

	// A unique identifier for the phone number.
	PhoneNumberId *string `type:"string"`

	// The status of the phone number.
	//
	//    * CLAIMED means the previous ClaimedPhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	//    or UpdatePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	//    operation succeeded.
	//
	//    * IN_PROGRESS means a ClaimedPhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	//    or UpdatePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	//    operation is still in progress and has not yet completed. You can call
	//    DescribePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_DescribePhoneNumber.html)
	//    at a later time to verify if the previous operation has completed.
	//
	//    * FAILED indicates that the previous ClaimedPhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_ClaimedPhoneNumber.html)
	//    or UpdatePhoneNumber (https://docs.aws.amazon.com/connect/latest/APIReference/API_UpdatePhoneNumber.html)
	//    operation has failed. It will include a message indicating the failure
	//    reason. A common reason for a failure may be that the TargetArn value
	//    you are claiming or updating a phone number to has reached its limit of
	//    total claimed numbers. If you received a FAILED status from a ClaimPhoneNumber
	//    API call, you have one day to retry claiming the phone number before the
	//    number is released back to the inventory for other customers to claim.
	//
	// You will not be billed for the phone number during the 1-day period if number
	// claiming fails.
	PhoneNumberStatus *PhoneNumberStatus `type:"structure"`

	// The type of phone number.
	PhoneNumberType *string `type:"string" enum:"PhoneNumberType"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The Amazon Resource Name (ARN) for Amazon Connect instances or traffic distribution
	// groups that phone numbers are claimed to.
	TargetArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimedPhoneNumberSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ClaimedPhoneNumberSummary) GoString() string {
	return s.String()
}

// SetPhoneNumber sets the PhoneNumber field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumber(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumber = &v
	return s
}

// SetPhoneNumberArn sets the PhoneNumberArn field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberArn(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumberArn = &v
	return s
}

// SetPhoneNumberCountryCode sets the PhoneNumberCountryCode field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberCountryCode(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumberCountryCode = &v
	return s
}

// SetPhoneNumberDescription sets the PhoneNumberDescription field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberDescription(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumberDescription = &v
	return s
}

// SetPhoneNumberId sets the PhoneNumberId field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberId(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumberId = &v
	return s
}

// SetPhoneNumberStatus sets the PhoneNumberStatus field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberStatus(v *PhoneNumberStatus) *ClaimedPhoneNumberSummary {
	s.PhoneNumberStatus = v
	return s
}

// SetPhoneNumberType sets the PhoneNumberType field's value.
func (s *ClaimedPhoneNumberSummary) SetPhoneNumberType(v string) *ClaimedPhoneNumberSummary {
	s.PhoneNumberType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ClaimedPhoneNumberSummary) SetTags(v map[string]*string) *ClaimedPhoneNumberSummary {
	s.Tags = v
	return s
}

// SetTargetArn sets the TargetArn field's value.
func (s *ClaimedPhoneNumberSummary) SetTargetArn(v string) *ClaimedPhoneNumberSummary {
	s.TargetArn = &v
	return s
}

// Contains information about a contact.
type Contact struct {
	_ struct{} `type:"structure"`

	// Information about the agent who accepted the contact.
	AgentInfo *AgentInfo `type:"structure"`

	// The Amazon Resource Name (ARN) for the contact.
	Arn *string `type:"string"`

	// How the contact reached your contact center.
	Channel *string `type:"string" enum:"Channel"`

	// The description of the contact.
	Description *string `type:"string"`

	// The timestamp when the customer endpoint disconnected from Amazon Connect.
	DisconnectTimestamp *time.Time `type:"timestamp"`

	// The identifier for the contact.
	Id *string `min:"1" type:"string"`

	// If this contact is related to other contacts, this is the ID of the initial
	// contact.
	InitialContactId *string `min:"1" type:"string"`

	// Indicates how the contact was initiated.
	InitiationMethod *string `type:"string" enum:"ContactInitiationMethod"`

	// The date and time this contact was initiated, in UTC time. For INBOUND, this
	// is when the contact arrived. For OUTBOUND, this is when the agent began dialing.
	// For CALLBACK, this is when the callback contact was created. For TRANSFER
	// and QUEUE_TRANSFER, this is when the transfer was initiated. For API, this
	// is when the request arrived.
	InitiationTimestamp *time.Time `type:"timestamp"`

	// The timestamp when contact was last updated.
	LastUpdateTimestamp *time.Time `type:"timestamp"`

	// The name of the contact.
	Name *string `type:"string"`

	// If this contact is not the first contact, this is the ID of the previous
	// contact.
	PreviousContactId *string `min:"1" type:"string"`

	// If this contact was queued, this contains information about the queue.
	QueueInfo *QueueInfo `type:"structure"`

	// The contactId that is related (https://docs.aws.amazon.com/connect/latest/adminguide/chat-persistence.html#relatedcontactid)
	// to this contact.
	RelatedContactId *string `min:"1" type:"string"`

	// The timestamp, in Unix epoch time format, at which to start running the inbound
	// flow.
	ScheduledTimestamp *time.Time `type:"timestamp"`

	// Information about Amazon Connect Wisdom.
	WisdomInfo *WisdomInfo `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Contact) GoString() string {
	return s.String()
}

// SetAgentInfo sets the AgentInfo field's value.
func (s *Contact) SetAgentInfo(v *AgentInfo) *Contact {
	s.AgentInfo = v
	return s
}

// SetArn sets the Arn field's value.
func (s *Contact) SetArn(v string) *Contact {
	s.Arn = &v
	return s
}

// SetChannel sets the Channel field's value.
func (s *Contact) SetChannel(v string) *Contact {
	s.Channel = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *Contact) SetDescription(v string) *Contact {
	s.Description = &v
	return s
}

// SetDisconnectTimestamp sets the DisconnectTimestamp field's value.
func (s *Contact) SetDisconnectTimestamp(v time.Time) *Contact {
	s.DisconnectTimestamp = &v
	return s
}

// SetId sets the Id field's value.
func (s *Contact) SetId(v string) *Contact {
	s.Id = &v
	return s
}

// SetInitialContactId sets the InitialContactId field's value.
func (s *Contact) SetInitialContactId(v string) *Contact {
	s.InitialContactId = &v
	return s
}

// SetInitiationMethod sets the InitiationMethod field's value.
func (s *Contact) SetInitiationMethod(v string) *Contact {
	s.InitiationMethod = &v
	return s
}

// SetInitiationTimestamp sets the InitiationTimestamp field's value.
func (s *Contact) SetInitiationTimestamp(v time.Time) *Contact {
	s.InitiationTimestamp = &v
	return s
}

// SetLastUpdateTimestamp sets the LastUpdateTimestamp field's value.
func (s *Contact) SetLastUpdateTimestamp(v time.Time) *Contact {
	s.LastUpdateTimestamp = &v
	return s
}

// SetName sets the Name field's value.
func (s *Contact) SetName(v string) *Contact {
	s.Name = &v
	return s
}

// SetPreviousContactId sets the PreviousContactId field's value.
func (s *Contact) SetPreviousContactId(v string) *Contact {
	s.PreviousContactId = &v
	return s
}

// SetQueueInfo sets the QueueInfo field's value.
func (s *Contact) SetQueueInfo(v *QueueInfo) *Contact {
	s.QueueInfo = v
	return s
}

// SetRelatedContactId sets the RelatedContactId field's value.
func (s *Contact) SetRelatedContactId(v string) *Contact {
	s.RelatedContactId = &v
	return s
}

// SetScheduledTimestamp sets the ScheduledTimestamp field's value.
func (s *Contact) SetScheduledTimestamp(v time.Time) *Contact {
	s.ScheduledTimestamp = &v
	return s
}

// SetWisdomInfo sets the WisdomInfo field's value.
func (s *Contact) SetWisdomInfo(v *WisdomInfo) *Contact {
	s.WisdomInfo = v
	return s
}

// Filters user data based on the contact information that is associated to
// the users. It contains a list of contact states (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
type ContactFilter struct {
	_ struct{} `type:"structure"`

	// A list of up to 9 contact states (https://docs.aws.amazon.com/connect/latest/adminguide/about-contact-states.html).
	ContactStates []*string `type:"list" enum:"ContactState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFilter) GoString() string {
	return s.String()
}

// SetContactStates sets the ContactStates field's value.
func (s *ContactFilter) SetContactStates(v []*string) *ContactFilter {
	s.ContactStates = v
	return s
}

// Contains information about a flow.
type ContactFlow struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	Arn *string `type:"string"`

	// The content of the flow.
	Content *string `type:"string"`

	// The description of the flow.
	Description *string `type:"string"`

	// The identifier of the flow.
	Id *string `type:"string"`

	// The name of the flow.
	Name *string `min:"1" type:"string"`

	// The type of flow.
	State *string `type:"string" enum:"ContactFlowState"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The type of the flow. For descriptions of the available types, see Choose
	// a flow type (https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types)
	// in the Amazon Connect Administrator Guide.
	Type *string `type:"string" enum:"ContactFlowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlow) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlow) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactFlow) SetArn(v string) *ContactFlow {
	s.Arn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *ContactFlow) SetContent(v string) *ContactFlow {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ContactFlow) SetDescription(v string) *ContactFlow {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ContactFlow) SetId(v string) *ContactFlow {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContactFlow) SetName(v string) *ContactFlow {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *ContactFlow) SetState(v string) *ContactFlow {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContactFlow) SetTags(v map[string]*string) *ContactFlow {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *ContactFlow) SetType(v string) *ContactFlow {
	s.Type = &v
	return s
}

// Contains information about a flow module.
type ContactFlowModule struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN).
	Arn *string `type:"string"`

	// The content of the flow module.
	Content *string `min:"1" type:"string"`

	// The description of the flow module.
	Description *string `type:"string"`

	// The identifier of the flow module.
	Id *string `min:"1" type:"string"`

	// The name of the flow module.
	Name *string `min:"1" type:"string"`

	// The type of flow module.
	State *string `type:"string" enum:"ContactFlowModuleState"`

	// The status of the flow module.
	Status *string `type:"string" enum:"ContactFlowModuleStatus"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowModule) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowModule) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactFlowModule) SetArn(v string) *ContactFlowModule {
	s.Arn = &v
	return s
}

// SetContent sets the Content field's value.
func (s *ContactFlowModule) SetContent(v string) *ContactFlowModule {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ContactFlowModule) SetDescription(v string) *ContactFlowModule {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ContactFlowModule) SetId(v string) *ContactFlowModule {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContactFlowModule) SetName(v string) *ContactFlowModule {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *ContactFlowModule) SetState(v string) *ContactFlowModule {
	s.State = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ContactFlowModule) SetStatus(v string) *ContactFlowModule {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *ContactFlowModule) SetTags(v map[string]*string) *ContactFlowModule {
	s.Tags = v
	return s
}

// Contains summary information about a flow.
type ContactFlowModuleSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow module.
	Arn *string `type:"string"`

	// The identifier of the flow module.
	Id *string `min:"1" type:"string"`

	// The name of the flow module.
	Name *string `min:"1" type:"string"`

	// The type of flow module.
	State *string `type:"string" enum:"ContactFlowModuleState"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowModuleSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowModuleSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactFlowModuleSummary) SetArn(v string) *ContactFlowModuleSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ContactFlowModuleSummary) SetId(v string) *ContactFlowModuleSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContactFlowModuleSummary) SetName(v string) *ContactFlowModuleSummary {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *ContactFlowModuleSummary) SetState(v string) *ContactFlowModuleSummary {
	s.State = &v
	return s
}

// The flow has not been published.
type ContactFlowNotPublishedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowNotPublishedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowNotPublishedException) GoString() string {
	return s.String()
}

func newErrorContactFlowNotPublishedException(v protocol.ResponseMetadata) error {
	return &ContactFlowNotPublishedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContactFlowNotPublishedException) Code() string {
	return "ContactFlowNotPublishedException"
}

// Message returns the exception's message.
func (s *ContactFlowNotPublishedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContactFlowNotPublishedException) OrigErr() error {
	return nil
}

func (s *ContactFlowNotPublishedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContactFlowNotPublishedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContactFlowNotPublishedException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Contains summary information about a flow.
//
// You can also create and update flows using the Amazon Connect Flow language
// (https://docs.aws.amazon.com/connect/latest/APIReference/flow-language.html).
type ContactFlowSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	Arn *string `type:"string"`

	// The type of flow.
	ContactFlowState *string `type:"string" enum:"ContactFlowState"`

	// The type of flow.
	ContactFlowType *string `type:"string" enum:"ContactFlowType"`

	// The identifier of the flow.
	Id *string `type:"string"`

	// The name of the flow.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactFlowSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ContactFlowSummary) SetArn(v string) *ContactFlowSummary {
	s.Arn = &v
	return s
}

// SetContactFlowState sets the ContactFlowState field's value.
func (s *ContactFlowSummary) SetContactFlowState(v string) *ContactFlowSummary {
	s.ContactFlowState = &v
	return s
}

// SetContactFlowType sets the ContactFlowType field's value.
func (s *ContactFlowSummary) SetContactFlowType(v string) *ContactFlowSummary {
	s.ContactFlowType = &v
	return s
}

// SetId sets the Id field's value.
func (s *ContactFlowSummary) SetId(v string) *ContactFlowSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ContactFlowSummary) SetName(v string) *ContactFlowSummary {
	s.Name = &v
	return s
}

// The contact with the specified ID is not active or does not exist. Applies
// to Voice calls only, not to Chat, Task, or Voice Callback.
type ContactNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The message.
	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ContactNotFoundException) GoString() string {
	return s.String()
}

func newErrorContactNotFoundException(v protocol.ResponseMetadata) error {
	return &ContactNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ContactNotFoundException) Code() string {
	return "ContactNotFoundException"
}

// Message returns the exception's message.
func (s *ContactNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ContactNotFoundException) OrigErr() error {
	return nil
}

func (s *ContactNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ContactNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ContactNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An object that can be used to specify Tag conditions inside the SearchFilter.
// This accepts an OR of AND (List of List) input where:
//
//   - Top level list specifies conditions that need to be applied with OR
//     operator
//
//   - Inner list specifies conditions that need to be applied with AND operator.
type ControlPlaneTagFilter struct {
	_ struct{} `type:"structure"`

	// A list of conditions which would be applied together with an AND condition.
	AndConditions []*TagCondition `type:"list"`

	// A list of conditions which would be applied together with an OR condition.
	OrConditions [][]*TagCondition `type:"list"`

	// A leaf node condition which can be used to specify a tag condition.
	TagCondition *TagCondition `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlaneTagFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ControlPlaneTagFilter) GoString() string {
	return s.String()
}

// SetAndConditions sets the AndConditions field's value.
func (s *ControlPlaneTagFilter) SetAndConditions(v []*TagCondition) *ControlPlaneTagFilter {
	s.AndConditions = v
	return s
}

// SetOrConditions sets the OrConditions field's value.
func (s *ControlPlaneTagFilter) SetOrConditions(v [][]*TagCondition) *ControlPlaneTagFilter {
	s.OrConditions = v
	return s
}

// SetTagCondition sets the TagCondition field's value.
func (s *ControlPlaneTagFilter) SetTagCondition(v *TagCondition) *ControlPlaneTagFilter {
	s.TagCondition = v
	return s
}

type CreateAgentStatusInput struct {
	_ struct{} `type:"structure"`

	// The description of the status.
	Description *string `min:"1" type:"string"`

	// The display order of the status.
	DisplayOrder *int64 `min:"1" type:"integer"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the status.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The state of the status.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"AgentStatusState"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentStatusInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAgentStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAgentStatusInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.DisplayOrder != nil && *s.DisplayOrder < 1 {
		invalidParams.Add(request.NewErrParamMinValue("DisplayOrder", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.State == nil {
		invalidParams.Add(request.NewErrParamRequired("State"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateAgentStatusInput) SetDescription(v string) *CreateAgentStatusInput {
	s.Description = &v
	return s
}

// SetDisplayOrder sets the DisplayOrder field's value.
func (s *CreateAgentStatusInput) SetDisplayOrder(v int64) *CreateAgentStatusInput {
	s.DisplayOrder = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateAgentStatusInput) SetInstanceId(v string) *CreateAgentStatusInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateAgentStatusInput) SetName(v string) *CreateAgentStatusInput {
	s.Name = &v
	return s
}

// SetState sets the State field's value.
func (s *CreateAgentStatusInput) SetState(v string) *CreateAgentStatusInput {
	s.State = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAgentStatusInput) SetTags(v map[string]*string) *CreateAgentStatusInput {
	s.Tags = v
	return s
}

type CreateAgentStatusOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the agent status.
	AgentStatusARN *string `type:"string"`

	// The identifier of the agent status.
	AgentStatusId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentStatusOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateAgentStatusOutput) GoString() string {
	return s.String()
}

// SetAgentStatusARN sets the AgentStatusARN field's value.
func (s *CreateAgentStatusOutput) SetAgentStatusARN(v string) *CreateAgentStatusOutput {
	s.AgentStatusARN = &v
	return s
}

// SetAgentStatusId sets the AgentStatusId field's value.
func (s *CreateAgentStatusOutput) SetAgentStatusId(v string) *CreateAgentStatusOutput {
	s.AgentStatusId = &v
	return s
}

type CreateContactFlowInput struct {
	_ struct{} `type:"structure"`

	// The content of the flow.
	//
	// Content is a required field
	Content *string `type:"string" required:"true"`

	// The description of the flow.
	Description *string `type:"string"`

	// The identifier of the Amazon Connect instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the flow.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The type of the flow. For descriptions of the available types, see Choose
	// a flow type (https://docs.aws.amazon.com/connect/latest/adminguide/create-contact-flow.html#contact-flow-types)
	// in the Amazon Connect Administrator Guide.
	//
	// Type is a required field
	Type *string `type:"string" required:"true" enum:"ContactFlowType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactFlowInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactFlowInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetContent sets the Content field's value.
func (s *CreateContactFlowInput) SetContent(v string) *CreateContactFlowInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateContactFlowInput) SetDescription(v string) *CreateContactFlowInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateContactFlowInput) SetInstanceId(v string) *CreateContactFlowInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContactFlowInput) SetName(v string) *CreateContactFlowInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContactFlowInput) SetTags(v map[string]*string) *CreateContactFlowInput {
	s.Tags = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateContactFlowInput) SetType(v string) *CreateContactFlowInput {
	s.Type = &v
	return s
}

type CreateContactFlowModuleInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The content of the flow module.
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The description of the flow module.
	Description *string `type:"string"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the flow module.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowModuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowModuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateContactFlowModuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateContactFlowModuleInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateContactFlowModuleInput) SetClientToken(v string) *CreateContactFlowModuleInput {
	s.ClientToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateContactFlowModuleInput) SetContent(v string) *CreateContactFlowModuleInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateContactFlowModuleInput) SetDescription(v string) *CreateContactFlowModuleInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateContactFlowModuleInput) SetInstanceId(v string) *CreateContactFlowModuleInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateContactFlowModuleInput) SetName(v string) *CreateContactFlowModuleInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateContactFlowModuleInput) SetTags(v map[string]*string) *CreateContactFlowModuleInput {
	s.Tags = v
	return s
}

type CreateContactFlowModuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow module.
	Arn *string `type:"string"`

	// The identifier of the flow module.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowModuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowModuleOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateContactFlowModuleOutput) SetArn(v string) *CreateContactFlowModuleOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateContactFlowModuleOutput) SetId(v string) *CreateContactFlowModuleOutput {
	s.Id = &v
	return s
}

type CreateContactFlowOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow.
	ContactFlowArn *string `type:"string"`

	// The identifier of the flow.
	ContactFlowId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateContactFlowOutput) GoString() string {
	return s.String()
}

// SetContactFlowArn sets the ContactFlowArn field's value.
func (s *CreateContactFlowOutput) SetContactFlowArn(v string) *CreateContactFlowOutput {
	s.ContactFlowArn = &v
	return s
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *CreateContactFlowOutput) SetContactFlowId(v string) *CreateContactFlowOutput {
	s.ContactFlowId = &v
	return s
}

type CreateEvaluationFormInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The description of the evaluation form.
	Description *string `type:"string"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Items that are part of the evaluation form. The total number of sections
	// and questions must not exceed 100 each. Questions must be contained in a
	// section.
	//
	// Items is a required field
	Items []*EvaluationFormItem `type:"list" required:"true"`

	// A scoring strategy of the evaluation form.
	ScoringStrategy *EvaluationFormScoringStrategy `type:"structure"`

	// A unique title of the evaluation form.
	//
	// Title is a required field
	Title *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationFormInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationFormInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEvaluationFormInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEvaluationFormInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Items == nil {
		invalidParams.Add(request.NewErrParamRequired("Items"))
	}
	if s.Title == nil {
		invalidParams.Add(request.NewErrParamRequired("Title"))
	}
	if s.Items != nil {
		for i, v := range s.Items {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Items", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.ScoringStrategy != nil {
		if err := s.ScoringStrategy.Validate(); err != nil {
			invalidParams.AddNested("ScoringStrategy", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEvaluationFormInput) SetClientToken(v string) *CreateEvaluationFormInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEvaluationFormInput) SetDescription(v string) *CreateEvaluationFormInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateEvaluationFormInput) SetInstanceId(v string) *CreateEvaluationFormInput {
	s.InstanceId = &v
	return s
}

// SetItems sets the Items field's value.
func (s *CreateEvaluationFormInput) SetItems(v []*EvaluationFormItem) *CreateEvaluationFormInput {
	s.Items = v
	return s
}

// SetScoringStrategy sets the ScoringStrategy field's value.
func (s *CreateEvaluationFormInput) SetScoringStrategy(v *EvaluationFormScoringStrategy) *CreateEvaluationFormInput {
	s.ScoringStrategy = v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateEvaluationFormInput) SetTitle(v string) *CreateEvaluationFormInput {
	s.Title = &v
	return s
}

type CreateEvaluationFormOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the evaluation form resource.
	//
	// EvaluationFormArn is a required field
	EvaluationFormArn *string `type:"string" required:"true"`

	// The unique identifier for the evaluation form.
	//
	// EvaluationFormId is a required field
	EvaluationFormId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationFormOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEvaluationFormOutput) GoString() string {
	return s.String()
}

// SetEvaluationFormArn sets the EvaluationFormArn field's value.
func (s *CreateEvaluationFormOutput) SetEvaluationFormArn(v string) *CreateEvaluationFormOutput {
	s.EvaluationFormArn = &v
	return s
}

// SetEvaluationFormId sets the EvaluationFormId field's value.
func (s *CreateEvaluationFormOutput) SetEvaluationFormId(v string) *CreateEvaluationFormOutput {
	s.EvaluationFormId = &v
	return s
}

type CreateHoursOfOperationInput struct {
	_ struct{} `type:"structure"`

	// Configuration information for the hours of operation: day, start time, and
	// end time.
	//
	// Config is a required field
	Config []*HoursOfOperationConfig `type:"list" required:"true"`

	// The description of the hours of operation.
	Description *string `min:"1" type:"string"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the hours of operation.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The time zone of the hours of operation.
	//
	// TimeZone is a required field
	TimeZone *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHoursOfOperationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHoursOfOperationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateHoursOfOperationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateHoursOfOperationInput"}
	if s.Config == nil {
		invalidParams.Add(request.NewErrParamRequired("Config"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.TimeZone == nil {
		invalidParams.Add(request.NewErrParamRequired("TimeZone"))
	}
	if s.Config != nil {
		for i, v := range s.Config {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Config", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetConfig sets the Config field's value.
func (s *CreateHoursOfOperationInput) SetConfig(v []*HoursOfOperationConfig) *CreateHoursOfOperationInput {
	s.Config = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateHoursOfOperationInput) SetDescription(v string) *CreateHoursOfOperationInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateHoursOfOperationInput) SetInstanceId(v string) *CreateHoursOfOperationInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateHoursOfOperationInput) SetName(v string) *CreateHoursOfOperationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateHoursOfOperationInput) SetTags(v map[string]*string) *CreateHoursOfOperationInput {
	s.Tags = v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *CreateHoursOfOperationInput) SetTimeZone(v string) *CreateHoursOfOperationInput {
	s.TimeZone = &v
	return s
}

type CreateHoursOfOperationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the hours of operation.
	HoursOfOperationArn *string `type:"string"`

	// The identifier for the hours of operation.
	HoursOfOperationId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHoursOfOperationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateHoursOfOperationOutput) GoString() string {
	return s.String()
}

// SetHoursOfOperationArn sets the HoursOfOperationArn field's value.
func (s *CreateHoursOfOperationOutput) SetHoursOfOperationArn(v string) *CreateHoursOfOperationOutput {
	s.HoursOfOperationArn = &v
	return s
}

// SetHoursOfOperationId sets the HoursOfOperationId field's value.
func (s *CreateHoursOfOperationOutput) SetHoursOfOperationId(v string) *CreateHoursOfOperationOutput {
	s.HoursOfOperationId = &v
	return s
}

type CreateInstanceInput struct {
	_ struct{} `type:"structure"`

	// The idempotency token.
	ClientToken *string `type:"string"`

	// The identifier for the directory.
	DirectoryId *string `min:"12" type:"string"`

	// The type of identity management for your Amazon Connect users.
	//
	// IdentityManagementType is a required field
	IdentityManagementType *string `type:"string" required:"true" enum:"DirectoryType"`

	// Your contact center handles incoming contacts.
	//
	// InboundCallsEnabled is a required field
	InboundCallsEnabled *bool `type:"boolean" required:"true"`

	// The name for your instance.
	//
	// InstanceAlias is a sensitive parameter and its value will be
	// replaced with "sensitive" in string returned by CreateInstanceInput's
	// String and GoString methods.
	InstanceAlias *string `min:"1" type:"string" sensitive:"true"`

	// Your contact center allows outbound calls.
	//
	// OutboundCallsEnabled is a required field
	OutboundCallsEnabled *bool `type:"boolean" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateInstanceInput"}
	if s.DirectoryId != nil && len(*s.DirectoryId) < 12 {
		invalidParams.Add(request.NewErrParamMinLen("DirectoryId", 12))
	}
	if s.IdentityManagementType == nil {
		invalidParams.Add(request.NewErrParamRequired("IdentityManagementType"))
	}
	if s.InboundCallsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("InboundCallsEnabled"))
	}
	if s.InstanceAlias != nil && len(*s.InstanceAlias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceAlias", 1))
	}
	if s.OutboundCallsEnabled == nil {
		invalidParams.Add(request.NewErrParamRequired("OutboundCallsEnabled"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInstanceInput) SetClientToken(v string) *CreateInstanceInput {
	s.ClientToken = &v
	return s
}

// SetDirectoryId sets the DirectoryId field's value.
func (s *CreateInstanceInput) SetDirectoryId(v string) *CreateInstanceInput {
	s.DirectoryId = &v
	return s
}

// SetIdentityManagementType sets the IdentityManagementType field's value.
func (s *CreateInstanceInput) SetIdentityManagementType(v string) *CreateInstanceInput {
	s.IdentityManagementType = &v
	return s
}

// SetInboundCallsEnabled sets the InboundCallsEnabled field's value.
func (s *CreateInstanceInput) SetInboundCallsEnabled(v bool) *CreateInstanceInput {
	s.InboundCallsEnabled = &v
	return s
}

// SetInstanceAlias sets the InstanceAlias field's value.
func (s *CreateInstanceInput) SetInstanceAlias(v string) *CreateInstanceInput {
	s.InstanceAlias = &v
	return s
}

// SetOutboundCallsEnabled sets the OutboundCallsEnabled field's value.
func (s *CreateInstanceInput) SetOutboundCallsEnabled(v bool) *CreateInstanceInput {
	s.OutboundCallsEnabled = &v
	return s
}

type CreateInstanceOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the instance.
	Arn *string `type:"string"`

	// The identifier for the instance.
	Id *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateInstanceOutput) SetArn(v string) *CreateInstanceOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateInstanceOutput) SetId(v string) *CreateInstanceOutput {
	s.Id = &v
	return s
}

type CreateIntegrationAssociationInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the integration.
	//
	// When integrating with Amazon Pinpoint, the Amazon Connect and Amazon Pinpoint
	// instances must be in the same account.
	//
	// IntegrationArn is a required field
	IntegrationArn *string `type:"string" required:"true"`

	// The type of information to be ingested.
	//
	// IntegrationType is a required field
	IntegrationType *string `type:"string" required:"true" enum:"IntegrationType"`

	// The name of the external application. This field is only required for the
	// EVENT integration type.
	SourceApplicationName *string `min:"1" type:"string"`

	// The URL for the external application. This field is only required for the
	// EVENT integration type.
	SourceApplicationUrl *string `min:"1" type:"string"`

	// The type of the data source. This field is only required for the EVENT integration
	// type.
	SourceType *string `type:"string" enum:"SourceType"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateIntegrationAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateIntegrationAssociationInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.IntegrationArn == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationArn"))
	}
	if s.IntegrationType == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationType"))
	}
	if s.SourceApplicationName != nil && len(*s.SourceApplicationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceApplicationName", 1))
	}
	if s.SourceApplicationUrl != nil && len(*s.SourceApplicationUrl) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceApplicationUrl", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateIntegrationAssociationInput) SetInstanceId(v string) *CreateIntegrationAssociationInput {
	s.InstanceId = &v
	return s
}

// SetIntegrationArn sets the IntegrationArn field's value.
func (s *CreateIntegrationAssociationInput) SetIntegrationArn(v string) *CreateIntegrationAssociationInput {
	s.IntegrationArn = &v
	return s
}

// SetIntegrationType sets the IntegrationType field's value.
func (s *CreateIntegrationAssociationInput) SetIntegrationType(v string) *CreateIntegrationAssociationInput {
	s.IntegrationType = &v
	return s
}

// SetSourceApplicationName sets the SourceApplicationName field's value.
func (s *CreateIntegrationAssociationInput) SetSourceApplicationName(v string) *CreateIntegrationAssociationInput {
	s.SourceApplicationName = &v
	return s
}

// SetSourceApplicationUrl sets the SourceApplicationUrl field's value.
func (s *CreateIntegrationAssociationInput) SetSourceApplicationUrl(v string) *CreateIntegrationAssociationInput {
	s.SourceApplicationUrl = &v
	return s
}

// SetSourceType sets the SourceType field's value.
func (s *CreateIntegrationAssociationInput) SetSourceType(v string) *CreateIntegrationAssociationInput {
	s.SourceType = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateIntegrationAssociationInput) SetTags(v map[string]*string) *CreateIntegrationAssociationInput {
	s.Tags = v
	return s
}

type CreateIntegrationAssociationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the association.
	IntegrationAssociationArn *string `type:"string"`

	// The identifier for the integration association.
	IntegrationAssociationId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateIntegrationAssociationOutput) GoString() string {
	return s.String()
}

// SetIntegrationAssociationArn sets the IntegrationAssociationArn field's value.
func (s *CreateIntegrationAssociationOutput) SetIntegrationAssociationArn(v string) *CreateIntegrationAssociationOutput {
	s.IntegrationAssociationArn = &v
	return s
}

// SetIntegrationAssociationId sets the IntegrationAssociationId field's value.
func (s *CreateIntegrationAssociationOutput) SetIntegrationAssociationId(v string) *CreateIntegrationAssociationOutput {
	s.IntegrationAssociationId = &v
	return s
}

type CreateParticipantInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The identifier of the contact in this instance of Amazon Connect. Only contacts
	// in the CHAT channel are supported.
	//
	// ContactId is a required field
	ContactId *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// Information identifying the participant.
	//
	// The only Valid value for ParticipantRole is CUSTOM_BOT.
	//
	// DisplayName is Required.
	//
	// ParticipantDetails is a required field
	ParticipantDetails *ParticipantDetailsToAdd `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateParticipantInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateParticipantInput"}
	if s.ContactId == nil {
		invalidParams.Add(request.NewErrParamRequired("ContactId"))
	}
	if s.ContactId != nil && len(*s.ContactId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ContactId", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.ParticipantDetails == nil {
		invalidParams.Add(request.NewErrParamRequired("ParticipantDetails"))
	}
	if s.ParticipantDetails != nil {
		if err := s.ParticipantDetails.Validate(); err != nil {
			invalidParams.AddNested("ParticipantDetails", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateParticipantInput) SetClientToken(v string) *CreateParticipantInput {
	s.ClientToken = &v
	return s
}

// SetContactId sets the ContactId field's value.
func (s *CreateParticipantInput) SetContactId(v string) *CreateParticipantInput {
	s.ContactId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateParticipantInput) SetInstanceId(v string) *CreateParticipantInput {
	s.InstanceId = &v
	return s
}

// SetParticipantDetails sets the ParticipantDetails field's value.
func (s *CreateParticipantInput) SetParticipantDetails(v *ParticipantDetailsToAdd) *CreateParticipantInput {
	s.ParticipantDetails = v
	return s
}

type CreateParticipantOutput struct {
	_ struct{} `type:"structure"`

	// The token used by the chat participant to call CreateParticipantConnection.
	// The participant token is valid for the lifetime of a chat participant.
	ParticipantCredentials *ParticipantTokenCredentials `type:"structure"`

	// The identifier for a chat participant. The participantId for a chat participant
	// is the same throughout the chat lifecycle.
	ParticipantId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateParticipantOutput) GoString() string {
	return s.String()
}

// SetParticipantCredentials sets the ParticipantCredentials field's value.
func (s *CreateParticipantOutput) SetParticipantCredentials(v *ParticipantTokenCredentials) *CreateParticipantOutput {
	s.ParticipantCredentials = v
	return s
}

// SetParticipantId sets the ParticipantId field's value.
func (s *CreateParticipantOutput) SetParticipantId(v string) *CreateParticipantOutput {
	s.ParticipantId = &v
	return s
}

type CreateQueueInput struct {
	_ struct{} `type:"structure"`

	// The description of the queue.
	Description *string `min:"1" type:"string"`

	// The identifier for the hours of operation.
	//
	// HoursOfOperationId is a required field
	HoursOfOperationId *string `type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The maximum number of contacts that can be in the queue before it is considered
	// full.
	MaxContacts *int64 `type:"integer"`

	// The name of the queue.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The outbound caller ID name, number, and outbound whisper flow.
	OutboundCallerConfig *OutboundCallerConfig `type:"structure"`

	// The quick connects available to agents who are working the queue.
	QuickConnectIds []*string `min:"1" type:"list"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.HoursOfOperationId == nil {
		invalidParams.Add(request.NewErrParamRequired("HoursOfOperationId"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QuickConnectIds != nil && len(s.QuickConnectIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QuickConnectIds", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.OutboundCallerConfig != nil {
		if err := s.OutboundCallerConfig.Validate(); err != nil {
			invalidParams.AddNested("OutboundCallerConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateQueueInput) SetDescription(v string) *CreateQueueInput {
	s.Description = &v
	return s
}

// SetHoursOfOperationId sets the HoursOfOperationId field's value.
func (s *CreateQueueInput) SetHoursOfOperationId(v string) *CreateQueueInput {
	s.HoursOfOperationId = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateQueueInput) SetInstanceId(v string) *CreateQueueInput {
	s.InstanceId = &v
	return s
}

// SetMaxContacts sets the MaxContacts field's value.
func (s *CreateQueueInput) SetMaxContacts(v int64) *CreateQueueInput {
	s.MaxContacts = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateQueueInput) SetName(v string) *CreateQueueInput {
	s.Name = &v
	return s
}

// SetOutboundCallerConfig sets the OutboundCallerConfig field's value.
func (s *CreateQueueInput) SetOutboundCallerConfig(v *OutboundCallerConfig) *CreateQueueInput {
	s.OutboundCallerConfig = v
	return s
}

// SetQuickConnectIds sets the QuickConnectIds field's value.
func (s *CreateQueueInput) SetQuickConnectIds(v []*string) *CreateQueueInput {
	s.QuickConnectIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQueueInput) SetTags(v map[string]*string) *CreateQueueInput {
	s.Tags = v
	return s
}

type CreateQueueOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the queue.
	QueueArn *string `type:"string"`

	// The identifier for the queue.
	QueueId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQueueOutput) GoString() string {
	return s.String()
}

// SetQueueArn sets the QueueArn field's value.
func (s *CreateQueueOutput) SetQueueArn(v string) *CreateQueueOutput {
	s.QueueArn = &v
	return s
}

// SetQueueId sets the QueueId field's value.
func (s *CreateQueueOutput) SetQueueId(v string) *CreateQueueOutput {
	s.QueueId = &v
	return s
}

type CreateQuickConnectInput struct {
	_ struct{} `type:"structure"`

	// The description of the quick connect.
	Description *string `min:"1" type:"string"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the quick connect.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Configuration settings for the quick connect.
	//
	// QuickConnectConfig is a required field
	QuickConnectConfig *QuickConnectConfig `type:"structure" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuickConnectInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuickConnectInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQuickConnectInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQuickConnectInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QuickConnectConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("QuickConnectConfig"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.QuickConnectConfig != nil {
		if err := s.QuickConnectConfig.Validate(); err != nil {
			invalidParams.AddNested("QuickConnectConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateQuickConnectInput) SetDescription(v string) *CreateQuickConnectInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateQuickConnectInput) SetInstanceId(v string) *CreateQuickConnectInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateQuickConnectInput) SetName(v string) *CreateQuickConnectInput {
	s.Name = &v
	return s
}

// SetQuickConnectConfig sets the QuickConnectConfig field's value.
func (s *CreateQuickConnectInput) SetQuickConnectConfig(v *QuickConnectConfig) *CreateQuickConnectInput {
	s.QuickConnectConfig = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateQuickConnectInput) SetTags(v map[string]*string) *CreateQuickConnectInput {
	s.Tags = v
	return s
}

type CreateQuickConnectOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the quick connect.
	QuickConnectARN *string `type:"string"`

	// The identifier for the quick connect.
	QuickConnectId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuickConnectOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateQuickConnectOutput) GoString() string {
	return s.String()
}

// SetQuickConnectARN sets the QuickConnectARN field's value.
func (s *CreateQuickConnectOutput) SetQuickConnectARN(v string) *CreateQuickConnectOutput {
	s.QuickConnectARN = &v
	return s
}

// SetQuickConnectId sets the QuickConnectId field's value.
func (s *CreateQuickConnectOutput) SetQuickConnectId(v string) *CreateQuickConnectOutput {
	s.QuickConnectId = &v
	return s
}

type CreateRoutingProfileInput struct {
	_ struct{} `type:"structure"`

	// The default outbound queue for the routing profile.
	//
	// DefaultOutboundQueueId is a required field
	DefaultOutboundQueueId *string `type:"string" required:"true"`

	// Description of the routing profile. Must not be more than 250 characters.
	//
	// Description is a required field
	Description *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The channels that agents can handle in the Contact Control Panel (CCP) for
	// this routing profile.
	//
	// MediaConcurrencies is a required field
	MediaConcurrencies []*MediaConcurrency `type:"list" required:"true"`

	// The name of the routing profile. Must not be more than 127 characters.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The inbound queues associated with the routing profile. If no queue is added,
	// the agent can make only outbound calls.
	//
	// The limit of 10 array members applies to the maximum number of RoutingProfileQueueConfig
	// objects that can be passed during a CreateRoutingProfile API request. It
	// is different from the quota of 50 queues per routing profile per instance
	// that is listed in Amazon Connect service quotas (https://docs.aws.amazon.com/connect/latest/adminguide/amazon-connect-service-limits.html).
	QueueConfigs []*RoutingProfileQueueConfig `min:"1" type:"list"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRoutingProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRoutingProfileInput"}
	if s.DefaultOutboundQueueId == nil {
		invalidParams.Add(request.NewErrParamRequired("DefaultOutboundQueueId"))
	}
	if s.Description == nil {
		invalidParams.Add(request.NewErrParamRequired("Description"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.MediaConcurrencies == nil {
		invalidParams.Add(request.NewErrParamRequired("MediaConcurrencies"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.QueueConfigs != nil && len(s.QueueConfigs) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueConfigs", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.MediaConcurrencies != nil {
		for i, v := range s.MediaConcurrencies {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "MediaConcurrencies", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.QueueConfigs != nil {
		for i, v := range s.QueueConfigs {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "QueueConfigs", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDefaultOutboundQueueId sets the DefaultOutboundQueueId field's value.
func (s *CreateRoutingProfileInput) SetDefaultOutboundQueueId(v string) *CreateRoutingProfileInput {
	s.DefaultOutboundQueueId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRoutingProfileInput) SetDescription(v string) *CreateRoutingProfileInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateRoutingProfileInput) SetInstanceId(v string) *CreateRoutingProfileInput {
	s.InstanceId = &v
	return s
}

// SetMediaConcurrencies sets the MediaConcurrencies field's value.
func (s *CreateRoutingProfileInput) SetMediaConcurrencies(v []*MediaConcurrency) *CreateRoutingProfileInput {
	s.MediaConcurrencies = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRoutingProfileInput) SetName(v string) *CreateRoutingProfileInput {
	s.Name = &v
	return s
}

// SetQueueConfigs sets the QueueConfigs field's value.
func (s *CreateRoutingProfileInput) SetQueueConfigs(v []*RoutingProfileQueueConfig) *CreateRoutingProfileInput {
	s.QueueConfigs = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRoutingProfileInput) SetTags(v map[string]*string) *CreateRoutingProfileInput {
	s.Tags = v
	return s
}

type CreateRoutingProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the routing profile.
	RoutingProfileArn *string `type:"string"`

	// The identifier of the routing profile.
	RoutingProfileId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRoutingProfileOutput) GoString() string {
	return s.String()
}

// SetRoutingProfileArn sets the RoutingProfileArn field's value.
func (s *CreateRoutingProfileOutput) SetRoutingProfileArn(v string) *CreateRoutingProfileOutput {
	s.RoutingProfileArn = &v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *CreateRoutingProfileOutput) SetRoutingProfileId(v string) *CreateRoutingProfileOutput {
	s.RoutingProfileId = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure"`

	// A list of actions to be run when the rule is triggered.
	//
	// Actions is a required field
	Actions []*RuleAction `type:"list" required:"true"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The conditions of the rule.
	//
	// Function is a required field
	Function *string `type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// A unique name for the rule.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The publish status of the rule.
	//
	// PublishStatus is a required field
	PublishStatus *string `type:"string" required:"true" enum:"RulePublishStatus"`

	// The event source to trigger the rule.
	//
	// TriggerEventSource is a required field
	TriggerEventSource *RuleTriggerEventSource `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.Actions == nil {
		invalidParams.Add(request.NewErrParamRequired("Actions"))
	}
	if s.Function == nil {
		invalidParams.Add(request.NewErrParamRequired("Function"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.PublishStatus == nil {
		invalidParams.Add(request.NewErrParamRequired("PublishStatus"))
	}
	if s.TriggerEventSource == nil {
		invalidParams.Add(request.NewErrParamRequired("TriggerEventSource"))
	}
	if s.Actions != nil {
		for i, v := range s.Actions {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Actions", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.TriggerEventSource != nil {
		if err := s.TriggerEventSource.Validate(); err != nil {
			invalidParams.AddNested("TriggerEventSource", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetActions sets the Actions field's value.
func (s *CreateRuleInput) SetActions(v []*RuleAction) *CreateRuleInput {
	s.Actions = v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateRuleInput) SetClientToken(v string) *CreateRuleInput {
	s.ClientToken = &v
	return s
}

// SetFunction sets the Function field's value.
func (s *CreateRuleInput) SetFunction(v string) *CreateRuleInput {
	s.Function = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateRuleInput) SetInstanceId(v string) *CreateRuleInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateRuleInput) SetName(v string) *CreateRuleInput {
	s.Name = &v
	return s
}

// SetPublishStatus sets the PublishStatus field's value.
func (s *CreateRuleInput) SetPublishStatus(v string) *CreateRuleInput {
	s.PublishStatus = &v
	return s
}

// SetTriggerEventSource sets the TriggerEventSource field's value.
func (s *CreateRuleInput) SetTriggerEventSource(v *RuleTriggerEventSource) *CreateRuleInput {
	s.TriggerEventSource = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the rule.
	//
	// RuleArn is a required field
	RuleArn *string `type:"string" required:"true"`

	// A unique identifier for the rule.
	//
	// RuleId is a required field
	RuleId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetRuleArn sets the RuleArn field's value.
func (s *CreateRuleOutput) SetRuleArn(v string) *CreateRuleOutput {
	s.RuleArn = &v
	return s
}

// SetRuleId sets the RuleId field's value.
func (s *CreateRuleOutput) SetRuleId(v string) *CreateRuleOutput {
	s.RuleId = &v
	return s
}

type CreateSecurityProfileInput struct {
	_ struct{} `type:"structure"`

	// The list of tags that a security profile uses to restrict access to resources
	// in Amazon Connect.
	AllowedAccessControlTags map[string]*string `type:"map"`

	// The description of the security profile.
	Description *string `type:"string"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// Permissions assigned to the security profile. For a list of valid permissions,
	// see List of security profile permissions (https://docs.aws.amazon.com/connect/latest/adminguide/security-profile-list.html).
	Permissions []*string `type:"list"`

	// The name of the security profile.
	//
	// SecurityProfileName is a required field
	SecurityProfileName *string `min:"1" type:"string" required:"true"`

	// The list of resources that a security profile applies tag restrictions to
	// in Amazon Connect. Following are acceptable ResourceNames: User | SecurityProfile
	// | Queue | RoutingProfile
	TagRestrictedResources []*string `type:"list"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateSecurityProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateSecurityProfileInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.SecurityProfileName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileName"))
	}
	if s.SecurityProfileName != nil && len(*s.SecurityProfileName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileName", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAllowedAccessControlTags sets the AllowedAccessControlTags field's value.
func (s *CreateSecurityProfileInput) SetAllowedAccessControlTags(v map[string]*string) *CreateSecurityProfileInput {
	s.AllowedAccessControlTags = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateSecurityProfileInput) SetDescription(v string) *CreateSecurityProfileInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateSecurityProfileInput) SetInstanceId(v string) *CreateSecurityProfileInput {
	s.InstanceId = &v
	return s
}

// SetPermissions sets the Permissions field's value.
func (s *CreateSecurityProfileInput) SetPermissions(v []*string) *CreateSecurityProfileInput {
	s.Permissions = v
	return s
}

// SetSecurityProfileName sets the SecurityProfileName field's value.
func (s *CreateSecurityProfileInput) SetSecurityProfileName(v string) *CreateSecurityProfileInput {
	s.SecurityProfileName = &v
	return s
}

// SetTagRestrictedResources sets the TagRestrictedResources field's value.
func (s *CreateSecurityProfileInput) SetTagRestrictedResources(v []*string) *CreateSecurityProfileInput {
	s.TagRestrictedResources = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateSecurityProfileInput) SetTags(v map[string]*string) *CreateSecurityProfileInput {
	s.Tags = v
	return s
}

type CreateSecurityProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the security profile.
	SecurityProfileArn *string `type:"string"`

	// The identifier for the security profle.
	SecurityProfileId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateSecurityProfileOutput) GoString() string {
	return s.String()
}

// SetSecurityProfileArn sets the SecurityProfileArn field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileArn(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileArn = &v
	return s
}

// SetSecurityProfileId sets the SecurityProfileId field's value.
func (s *CreateSecurityProfileOutput) SetSecurityProfileId(v string) *CreateSecurityProfileOutput {
	s.SecurityProfileId = &v
	return s
}

type CreateTaskTemplateInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// Constraints that are applicable to the fields listed.
	Constraints *TaskTemplateConstraints `type:"structure"`

	// The identifier of the flow that runs by default when a task is created by
	// referencing this template.
	ContactFlowId *string `type:"string"`

	// The default values for fields when a task is created by referencing this
	// template.
	Defaults *TaskTemplateDefaults `type:"structure"`

	// The description of the task template.
	Description *string `min:"1" type:"string"`

	// Fields that are part of the template.
	//
	// Fields is a required field
	Fields []*TaskTemplateField `type:"list" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the task template.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// Marks a template as ACTIVE or INACTIVE for a task to refer to it. Tasks can
	// only be created from ACTIVE templates. If a template is marked as INACTIVE,
	// then a task that refers to this template cannot be created.
	Status *string `type:"string" enum:"TaskTemplateStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskTemplateInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Fields == nil {
		invalidParams.Add(request.NewErrParamRequired("Fields"))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Constraints != nil {
		if err := s.Constraints.Validate(); err != nil {
			invalidParams.AddNested("Constraints", err.(request.ErrInvalidParams))
		}
	}
	if s.Defaults != nil {
		if err := s.Defaults.Validate(); err != nil {
			invalidParams.AddNested("Defaults", err.(request.ErrInvalidParams))
		}
	}
	if s.Fields != nil {
		for i, v := range s.Fields {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Fields", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTaskTemplateInput) SetClientToken(v string) *CreateTaskTemplateInput {
	s.ClientToken = &v
	return s
}

// SetConstraints sets the Constraints field's value.
func (s *CreateTaskTemplateInput) SetConstraints(v *TaskTemplateConstraints) *CreateTaskTemplateInput {
	s.Constraints = v
	return s
}

// SetContactFlowId sets the ContactFlowId field's value.
func (s *CreateTaskTemplateInput) SetContactFlowId(v string) *CreateTaskTemplateInput {
	s.ContactFlowId = &v
	return s
}

// SetDefaults sets the Defaults field's value.
func (s *CreateTaskTemplateInput) SetDefaults(v *TaskTemplateDefaults) *CreateTaskTemplateInput {
	s.Defaults = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTaskTemplateInput) SetDescription(v string) *CreateTaskTemplateInput {
	s.Description = &v
	return s
}

// SetFields sets the Fields field's value.
func (s *CreateTaskTemplateInput) SetFields(v []*TaskTemplateField) *CreateTaskTemplateInput {
	s.Fields = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateTaskTemplateInput) SetInstanceId(v string) *CreateTaskTemplateInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTaskTemplateInput) SetName(v string) *CreateTaskTemplateInput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateTaskTemplateInput) SetStatus(v string) *CreateTaskTemplateInput {
	s.Status = &v
	return s
}

type CreateTaskTemplateOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the task template resource.
	//
	// Arn is a required field
	Arn *string `min:"1" type:"string" required:"true"`

	// The identifier of the task template resource.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTaskTemplateOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTaskTemplateOutput) SetArn(v string) *CreateTaskTemplateOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateTaskTemplateOutput) SetId(v string) *CreateTaskTemplateOutput {
	s.Id = &v
	return s
}

type CreateTrafficDistributionGroupInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// A description for the traffic distribution group.
	Description *string `min:"1" type:"string"`

	// The identifier of the Amazon Connect instance that has been replicated. You
	// can find the instanceId in the ARN of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `min:"1" type:"string" required:"true"`

	// The name for the traffic distribution group.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficDistributionGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficDistributionGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTrafficDistributionGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTrafficDistributionGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateTrafficDistributionGroupInput) SetClientToken(v string) *CreateTrafficDistributionGroupInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateTrafficDistributionGroupInput) SetDescription(v string) *CreateTrafficDistributionGroupInput {
	s.Description = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateTrafficDistributionGroupInput) SetInstanceId(v string) *CreateTrafficDistributionGroupInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTrafficDistributionGroupInput) SetName(v string) *CreateTrafficDistributionGroupInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateTrafficDistributionGroupInput) SetTags(v map[string]*string) *CreateTrafficDistributionGroupInput {
	s.Tags = v
	return s
}

type CreateTrafficDistributionGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the traffic distribution group.
	Arn *string `type:"string"`

	// The identifier of the traffic distribution group. This can be the ID or the
	// ARN if the API is being called in the Region where the traffic distribution
	// group was created. The ARN must be provided if the call is from the replicated
	// Region.
	Id *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficDistributionGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateTrafficDistributionGroupOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateTrafficDistributionGroupOutput) SetArn(v string) *CreateTrafficDistributionGroupOutput {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateTrafficDistributionGroupOutput) SetId(v string) *CreateTrafficDistributionGroupOutput {
	s.Id = &v
	return s
}

type CreateUseCaseInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The identifier for the integration association.
	//
	// IntegrationAssociationId is a required field
	IntegrationAssociationId *string `location:"uri" locationName:"IntegrationAssociationId" min:"1" type:"string" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The type of use case to associate to the integration association. Each integration
	// association can have only one of each use case type.
	//
	// UseCaseType is a required field
	UseCaseType *string `type:"string" required:"true" enum:"UseCaseType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUseCaseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUseCaseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUseCaseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUseCaseInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.IntegrationAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("IntegrationAssociationId"))
	}
	if s.IntegrationAssociationId != nil && len(*s.IntegrationAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("IntegrationAssociationId", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.UseCaseType == nil {
		invalidParams.Add(request.NewErrParamRequired("UseCaseType"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateUseCaseInput) SetInstanceId(v string) *CreateUseCaseInput {
	s.InstanceId = &v
	return s
}

// SetIntegrationAssociationId sets the IntegrationAssociationId field's value.
func (s *CreateUseCaseInput) SetIntegrationAssociationId(v string) *CreateUseCaseInput {
	s.IntegrationAssociationId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUseCaseInput) SetTags(v map[string]*string) *CreateUseCaseInput {
	s.Tags = v
	return s
}

// SetUseCaseType sets the UseCaseType field's value.
func (s *CreateUseCaseInput) SetUseCaseType(v string) *CreateUseCaseInput {
	s.UseCaseType = &v
	return s
}

type CreateUseCaseOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the use case.
	UseCaseArn *string `type:"string"`

	// The identifier of the use case.
	UseCaseId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUseCaseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUseCaseOutput) GoString() string {
	return s.String()
}

// SetUseCaseArn sets the UseCaseArn field's value.
func (s *CreateUseCaseOutput) SetUseCaseArn(v string) *CreateUseCaseOutput {
	s.UseCaseArn = &v
	return s
}

// SetUseCaseId sets the UseCaseId field's value.
func (s *CreateUseCaseOutput) SetUseCaseId(v string) *CreateUseCaseOutput {
	s.UseCaseId = &v
	return s
}

type CreateUserHierarchyGroupInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The name of the user hierarchy group. Must not be more than 100 characters.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// The identifier for the parent hierarchy group. The user hierarchy is created
	// at level one if the parent group ID is null.
	ParentGroupId *string `type:"string"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserHierarchyGroupInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserHierarchyGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserHierarchyGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserHierarchyGroupInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateUserHierarchyGroupInput) SetInstanceId(v string) *CreateUserHierarchyGroupInput {
	s.InstanceId = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateUserHierarchyGroupInput) SetName(v string) *CreateUserHierarchyGroupInput {
	s.Name = &v
	return s
}

// SetParentGroupId sets the ParentGroupId field's value.
func (s *CreateUserHierarchyGroupInput) SetParentGroupId(v string) *CreateUserHierarchyGroupInput {
	s.ParentGroupId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserHierarchyGroupInput) SetTags(v map[string]*string) *CreateUserHierarchyGroupInput {
	s.Tags = v
	return s
}

type CreateUserHierarchyGroupOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the hierarchy group.
	HierarchyGroupArn *string `type:"string"`

	// The identifier of the hierarchy group.
	HierarchyGroupId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserHierarchyGroupOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserHierarchyGroupOutput) GoString() string {
	return s.String()
}

// SetHierarchyGroupArn sets the HierarchyGroupArn field's value.
func (s *CreateUserHierarchyGroupOutput) SetHierarchyGroupArn(v string) *CreateUserHierarchyGroupOutput {
	s.HierarchyGroupArn = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *CreateUserHierarchyGroupOutput) SetHierarchyGroupId(v string) *CreateUserHierarchyGroupOutput {
	s.HierarchyGroupId = &v
	return s
}

type CreateUserInput struct {
	_ struct{} `type:"structure"`

	// The identifier of the user account in the directory used for identity management.
	// If Amazon Connect cannot access the directory, you can specify this identifier
	// to authenticate users. If you include the identifier, we assume that Amazon
	// Connect cannot access the directory. Otherwise, the identity information
	// is used to authenticate users from your directory.
	//
	// This parameter is required if you are using an existing directory for identity
	// management in Amazon Connect when Amazon Connect cannot access your directory
	// to authenticate users. If you are using SAML for identity management and
	// include this parameter, an error is returned.
	DirectoryUserId *string `type:"string"`

	// The identifier of the hierarchy group for the user.
	HierarchyGroupId *string `type:"string"`

	// The information about the identity of the user.
	IdentityInfo *UserIdentityInfo `type:"structure"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The password for the user account. A password is required if you are using
	// Amazon Connect for identity management. Otherwise, it is an error to include
	// a password.
	Password *string `type:"string"`

	// The phone settings for the user.
	//
	// PhoneConfig is a required field
	PhoneConfig *UserPhoneConfig `type:"structure" required:"true"`

	// The identifier of the routing profile for the user.
	//
	// RoutingProfileId is a required field
	RoutingProfileId *string `type:"string" required:"true"`

	// The identifier of the security profile for the user.
	//
	// SecurityProfileIds is a required field
	SecurityProfileIds []*string `min:"1" type:"list" required:"true"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// The user name for the account. For instances not using SAML for identity
	// management, the user name can include up to 20 characters. If you are using
	// SAML for identity management, the user name can include up to 64 characters
	// from [a-zA-Z0-9_-.\@]+.
	//
	// Username is a required field
	Username *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.PhoneConfig == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneConfig"))
	}
	if s.RoutingProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("RoutingProfileId"))
	}
	if s.SecurityProfileIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityProfileIds"))
	}
	if s.SecurityProfileIds != nil && len(s.SecurityProfileIds) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SecurityProfileIds", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.Username == nil {
		invalidParams.Add(request.NewErrParamRequired("Username"))
	}
	if s.Username != nil && len(*s.Username) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Username", 1))
	}
	if s.IdentityInfo != nil {
		if err := s.IdentityInfo.Validate(); err != nil {
			invalidParams.AddNested("IdentityInfo", err.(request.ErrInvalidParams))
		}
	}
	if s.PhoneConfig != nil {
		if err := s.PhoneConfig.Validate(); err != nil {
			invalidParams.AddNested("PhoneConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDirectoryUserId sets the DirectoryUserId field's value.
func (s *CreateUserInput) SetDirectoryUserId(v string) *CreateUserInput {
	s.DirectoryUserId = &v
	return s
}

// SetHierarchyGroupId sets the HierarchyGroupId field's value.
func (s *CreateUserInput) SetHierarchyGroupId(v string) *CreateUserInput {
	s.HierarchyGroupId = &v
	return s
}

// SetIdentityInfo sets the IdentityInfo field's value.
func (s *CreateUserInput) SetIdentityInfo(v *UserIdentityInfo) *CreateUserInput {
	s.IdentityInfo = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateUserInput) SetInstanceId(v string) *CreateUserInput {
	s.InstanceId = &v
	return s
}

// SetPassword sets the Password field's value.
func (s *CreateUserInput) SetPassword(v string) *CreateUserInput {
	s.Password = &v
	return s
}

// SetPhoneConfig sets the PhoneConfig field's value.
func (s *CreateUserInput) SetPhoneConfig(v *UserPhoneConfig) *CreateUserInput {
	s.PhoneConfig = v
	return s
}

// SetRoutingProfileId sets the RoutingProfileId field's value.
func (s *CreateUserInput) SetRoutingProfileId(v string) *CreateUserInput {
	s.RoutingProfileId = &v
	return s
}

// SetSecurityProfileIds sets the SecurityProfileIds field's value.
func (s *CreateUserInput) SetSecurityProfileIds(v []*string) *CreateUserInput {
	s.SecurityProfileIds = v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateUserInput) SetTags(v map[string]*string) *CreateUserInput {
	s.Tags = v
	return s
}

// SetUsername sets the Username field's value.
func (s *CreateUserInput) SetUsername(v string) *CreateUserInput {
	s.Username = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the user account.
	UserArn *string `type:"string"`

	// The identifier of the user account.
	UserId *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetUserArn sets the UserArn field's value.
func (s *CreateUserOutput) SetUserArn(v string) *CreateUserOutput {
	s.UserArn = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

type CreateVocabularyInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request. If not provided, the Amazon Web Services SDK populates this
	// field. For more information about idempotency, see Making retries safe with
	// idempotent APIs (https://aws.amazon.com/builders-library/making-retries-safe-with-idempotent-APIs/).
	// If a create request is received more than once with same client token, subsequent
	// requests return the previous response without creating a vocabulary again.
	ClientToken *string `type:"string" idempotencyToken:"true"`

	// The content of the custom vocabulary in plain-text format with a table of
	// values. Each row in the table represents a word or a phrase, described with
	// Phrase, IPA, SoundsLike, and DisplayAs fields. Separate the fields with TAB
	// characters. The size limit is 50KB. For more information, see Create a custom
	// vocabulary using a table (https://docs.aws.amazon.com/transcribe/latest/dg/custom-vocabulary.html#create-vocabulary-table).
	//
	// Content is a required field
	Content *string `min:"1" type:"string" required:"true"`

	// The identifier of the Amazon Connect instance. You can find the instance
	// ID (https://docs.aws.amazon.com/connect/latest/adminguide/find-instance-arn.html)
	// in the Amazon Resource Name (ARN) of the instance.
	//
	// InstanceId is a required field
	InstanceId *string `location:"uri" locationName:"InstanceId" min:"1" type:"string" required:"true"`

	// The language code of the vocabulary entries. For a list of languages and
	// their corresponding language codes, see What is Amazon Transcribe? (https://docs.aws.amazon.com/transcribe/latest/dg/transcribe-whatis.html)
	//
	// LanguageCode is a required field
	LanguageCode *string `type:"string" required:"true" enum:"VocabularyLanguageCode"`

	// The tags used to organize, track, or control access for this resource. For
	// example, { "tags": {"key1":"value1", "key2":"value2"} }.
	Tags map[string]*string `min:"1" type:"map"`

	// A unique name of the custom vocabulary.
	//
	// VocabularyName is a required field
	VocabularyName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateVocabularyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateVocabularyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateVocabularyInput"}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Content != nil && len(*s.Content) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Content", 1))
	}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.InstanceId != nil && len(*s.InstanceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("InstanceId", 1))
	}
	if s.LanguageCode == nil {
		invalidParams.Add(request.NewErrParamRequired("LanguageCode"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.VocabularyName == nil {
		invalidParams.Add(request.NewErrParamRequired("VocabularyName"))
	}
	if s.VocabularyName != nil && len(*s.VocabularyName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("VocabularyName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateVocabularyInput) SetClientToken(v string) *CreateVocabularyInput {
	s.ClientToken = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateVocabularyInput) SetContent(v string) *CreateVocabularyInput {
	s.Content = &v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateVocabularyInput) SetInstanceId(v string) *CreateVocabularyInput {
	s.InstanceId = &v
	return s
}

// SetLanguageCode sets the LanguageCode field's value.
func (s *CreateVocabularyInput) SetLanguageCode(v string) *CreateVocabularyInput {
	s.LanguageCode = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateVocabularyInput) SetTags(v map[string]*string) *CreateVocabularyInput {
	s.Tags = v
	return s
}

// SetVocabularyName sets the VocabularyName field's value.
func (s *CreateVocabularyInput) SetVocabularyName(v string) *CreateVocabularyInput {
	s.VocabularyName = &v
	return s
}

type CreateVocabularyOutput struct {
	_ struct{} `type:"structure"`

	// The current state of the custom vocabulary.
	//
	// State is a required field
	State *string `type:"string" required:"true" enum:"VocabularyState"`

	// The Amazon Resource Name (ARN) of the custom vocabulary.
	//
	// VocabularyArn is a required field
	VocabularyArn *string `type:"string" required:"true"`

	// The identifier of the custom vocabulary.
	//
	// VocabularyId is a required field
	VocabularyId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be repla