// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package route53profiles

import (
	"fmt"
	"time"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opAssociateProfile = "AssociateProfile"

// AssociateProfileRequest generates a "aws/request.Request" representing the
// client's request for the AssociateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateProfile for more information on using the AssociateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateProfileRequest method.
//	req, resp := client.AssociateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/AssociateProfile
func (c *Route53Profiles) AssociateProfileRequest(input *AssociateProfileInput) (req *request.Request, output *AssociateProfileOutput) {
	op := &request.Operation{
		Name:       opAssociateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profileassociation",
	}

	if input == nil {
		input = &AssociateProfileInput{}
	}

	output = &AssociateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateProfile API operation for Route 53 Profiles.
//
// Associates a Route 53 Profiles profile with a VPC. A VPC can have only one
// Profile associated with it, but a Profile can be associated with up to 5000
// VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation AssociateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ResourceExistsException
//     The resource you are trying to associate, has already been associated.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/AssociateProfile
func (c *Route53Profiles) AssociateProfile(input *AssociateProfileInput) (*AssociateProfileOutput, error) {
	req, out := c.AssociateProfileRequest(input)
	return out, req.Send()
}

// AssociateProfileWithContext is the same as AssociateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) AssociateProfileWithContext(ctx aws.Context, input *AssociateProfileInput, opts ...request.Option) (*AssociateProfileOutput, error) {
	req, out := c.AssociateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAssociateResourceToProfile = "AssociateResourceToProfile"

// AssociateResourceToProfileRequest generates a "aws/request.Request" representing the
// client's request for the AssociateResourceToProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AssociateResourceToProfile for more information on using the AssociateResourceToProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AssociateResourceToProfileRequest method.
//	req, resp := client.AssociateResourceToProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/AssociateResourceToProfile
func (c *Route53Profiles) AssociateResourceToProfileRequest(input *AssociateResourceToProfileInput) (req *request.Request, output *AssociateResourceToProfileOutput) {
	op := &request.Operation{
		Name:       opAssociateResourceToProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profileresourceassociation",
	}

	if input == nil {
		input = &AssociateResourceToProfileInput{}
	}

	output = &AssociateResourceToProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AssociateResourceToProfile API operation for Route 53 Profiles.
//
// Associates a DNS reource configuration to a Route 53 Profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation AssociateResourceToProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     An internal server error occured. Retry your request.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/AssociateResourceToProfile
func (c *Route53Profiles) AssociateResourceToProfile(input *AssociateResourceToProfileInput) (*AssociateResourceToProfileOutput, error) {
	req, out := c.AssociateResourceToProfileRequest(input)
	return out, req.Send()
}

// AssociateResourceToProfileWithContext is the same as AssociateResourceToProfile with the addition of
// the ability to pass a context and additional request options.
//
// See AssociateResourceToProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) AssociateResourceToProfileWithContext(ctx aws.Context, input *AssociateResourceToProfileInput, opts ...request.Option) (*AssociateResourceToProfileOutput, error) {
	req, out := c.AssociateResourceToProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateProfile = "CreateProfile"

// CreateProfileRequest generates a "aws/request.Request" representing the
// client's request for the CreateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateProfile for more information on using the CreateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the CreateProfileRequest method.
//	req, resp := client.CreateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/CreateProfile
func (c *Route53Profiles) CreateProfileRequest(input *CreateProfileInput) (req *request.Request, output *CreateProfileOutput) {
	op := &request.Operation{
		Name:       opCreateProfile,
		HTTPMethod: "POST",
		HTTPPath:   "/profile",
	}

	if input == nil {
		input = &CreateProfileInput{}
	}

	output = &CreateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateProfile API operation for Route 53 Profiles.
//
// Creates an empty Route 53 Profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation CreateProfile for usage and error information.
//
// Returned Error Types:
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/CreateProfile
func (c *Route53Profiles) CreateProfile(input *CreateProfileInput) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	return out, req.Send()
}

// CreateProfileWithContext is the same as CreateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See CreateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) CreateProfileWithContext(ctx aws.Context, input *CreateProfileInput, opts ...request.Option) (*CreateProfileOutput, error) {
	req, out := c.CreateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteProfile = "DeleteProfile"

// DeleteProfileRequest generates a "aws/request.Request" representing the
// client's request for the DeleteProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteProfile for more information on using the DeleteProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DeleteProfileRequest method.
//	req, resp := client.DeleteProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DeleteProfile
func (c *Route53Profiles) DeleteProfileRequest(input *DeleteProfileInput) (req *request.Request, output *DeleteProfileOutput) {
	op := &request.Operation{
		Name:       opDeleteProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profile/{ProfileId}",
	}

	if input == nil {
		input = &DeleteProfileInput{}
	}

	output = &DeleteProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DeleteProfile API operation for Route 53 Profiles.
//
// Deletes the specified Route 53 Profile. Before you can delete a profile,
// you must first disassociate it from all VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation DeleteProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DeleteProfile
func (c *Route53Profiles) DeleteProfile(input *DeleteProfileInput) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	return out, req.Send()
}

// DeleteProfileWithContext is the same as DeleteProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) DeleteProfileWithContext(ctx aws.Context, input *DeleteProfileInput, opts ...request.Option) (*DeleteProfileOutput, error) {
	req, out := c.DeleteProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateProfile = "DisassociateProfile"

// DisassociateProfileRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateProfile for more information on using the DisassociateProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateProfileRequest method.
//	req, resp := client.DisassociateProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DisassociateProfile
func (c *Route53Profiles) DisassociateProfileRequest(input *DisassociateProfileInput) (req *request.Request, output *DisassociateProfileOutput) {
	op := &request.Operation{
		Name:       opDisassociateProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profileassociation/Profileid/{ProfileId}/resourceid/{ResourceId}",
	}

	if input == nil {
		input = &DisassociateProfileInput{}
	}

	output = &DisassociateProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateProfile API operation for Route 53 Profiles.
//
// Dissociates a specified Route 53 Profile from the specified VPC.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation DisassociateProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DisassociateProfile
func (c *Route53Profiles) DisassociateProfile(input *DisassociateProfileInput) (*DisassociateProfileOutput, error) {
	req, out := c.DisassociateProfileRequest(input)
	return out, req.Send()
}

// DisassociateProfileWithContext is the same as DisassociateProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) DisassociateProfileWithContext(ctx aws.Context, input *DisassociateProfileInput, opts ...request.Option) (*DisassociateProfileOutput, error) {
	req, out := c.DisassociateProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisassociateResourceFromProfile = "DisassociateResourceFromProfile"

// DisassociateResourceFromProfileRequest generates a "aws/request.Request" representing the
// client's request for the DisassociateResourceFromProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DisassociateResourceFromProfile for more information on using the DisassociateResourceFromProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DisassociateResourceFromProfileRequest method.
//	req, resp := client.DisassociateResourceFromProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DisassociateResourceFromProfile
func (c *Route53Profiles) DisassociateResourceFromProfileRequest(input *DisassociateResourceFromProfileInput) (req *request.Request, output *DisassociateResourceFromProfileOutput) {
	op := &request.Operation{
		Name:       opDisassociateResourceFromProfile,
		HTTPMethod: "DELETE",
		HTTPPath:   "/profileresourceassociation/profileid/{ProfileId}/resourcearn/{ResourceArn}",
	}

	if input == nil {
		input = &DisassociateResourceFromProfileInput{}
	}

	output = &DisassociateResourceFromProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DisassociateResourceFromProfile API operation for Route 53 Profiles.
//
// Dissoaciated a specified resource, from the Route 53 Profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation DisassociateResourceFromProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     An internal server error occured. Retry your request.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/DisassociateResourceFromProfile
func (c *Route53Profiles) DisassociateResourceFromProfile(input *DisassociateResourceFromProfileInput) (*DisassociateResourceFromProfileOutput, error) {
	req, out := c.DisassociateResourceFromProfileRequest(input)
	return out, req.Send()
}

// DisassociateResourceFromProfileWithContext is the same as DisassociateResourceFromProfile with the addition of
// the ability to pass a context and additional request options.
//
// See DisassociateResourceFromProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) DisassociateResourceFromProfileWithContext(ctx aws.Context, input *DisassociateResourceFromProfileInput, opts ...request.Option) (*DisassociateResourceFromProfileOutput, error) {
	req, out := c.DisassociateResourceFromProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfile = "GetProfile"

// GetProfileRequest generates a "aws/request.Request" representing the
// client's request for the GetProfile operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfile for more information on using the GetProfile
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileRequest method.
//	req, resp := client.GetProfileRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfile
func (c *Route53Profiles) GetProfileRequest(input *GetProfileInput) (req *request.Request, output *GetProfileOutput) {
	op := &request.Operation{
		Name:       opGetProfile,
		HTTPMethod: "GET",
		HTTPPath:   "/profile/{ProfileId}",
	}

	if input == nil {
		input = &GetProfileInput{}
	}

	output = &GetProfileOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfile API operation for Route 53 Profiles.
//
// Returns information about a specified Route 53 Profile, such as whether whether
// the Profile is shared, and the current status of the Profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation GetProfile for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfile
func (c *Route53Profiles) GetProfile(input *GetProfileInput) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	return out, req.Send()
}

// GetProfileWithContext is the same as GetProfile with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfile for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) GetProfileWithContext(ctx aws.Context, input *GetProfileInput, opts ...request.Option) (*GetProfileOutput, error) {
	req, out := c.GetProfileRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileAssociation = "GetProfileAssociation"

// GetProfileAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileAssociation for more information on using the GetProfileAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileAssociationRequest method.
//	req, resp := client.GetProfileAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileAssociation
func (c *Route53Profiles) GetProfileAssociationRequest(input *GetProfileAssociationInput) (req *request.Request, output *GetProfileAssociationOutput) {
	op := &request.Operation{
		Name:       opGetProfileAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/profileassociation/{ProfileAssociationId}",
	}

	if input == nil {
		input = &GetProfileAssociationInput{}
	}

	output = &GetProfileAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileAssociation API operation for Route 53 Profiles.
//
// Retrieves a Route 53 Profile association for a VPC. A VPC can have only one
// Profile association, but a Profile can be associated with up to 5000 VPCs.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation GetProfileAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileAssociation
func (c *Route53Profiles) GetProfileAssociation(input *GetProfileAssociationInput) (*GetProfileAssociationOutput, error) {
	req, out := c.GetProfileAssociationRequest(input)
	return out, req.Send()
}

// GetProfileAssociationWithContext is the same as GetProfileAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) GetProfileAssociationWithContext(ctx aws.Context, input *GetProfileAssociationInput, opts ...request.Option) (*GetProfileAssociationOutput, error) {
	req, out := c.GetProfileAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetProfileResourceAssociation = "GetProfileResourceAssociation"

// GetProfileResourceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the GetProfileResourceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetProfileResourceAssociation for more information on using the GetProfileResourceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetProfileResourceAssociationRequest method.
//	req, resp := client.GetProfileResourceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileResourceAssociation
func (c *Route53Profiles) GetProfileResourceAssociationRequest(input *GetProfileResourceAssociationInput) (req *request.Request, output *GetProfileResourceAssociationOutput) {
	op := &request.Operation{
		Name:       opGetProfileResourceAssociation,
		HTTPMethod: "GET",
		HTTPPath:   "/profileresourceassociation/{ProfileResourceAssociationId}",
	}

	if input == nil {
		input = &GetProfileResourceAssociationInput{}
	}

	output = &GetProfileResourceAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetProfileResourceAssociation API operation for Route 53 Profiles.
//
// Returns information about a specified Route 53 Profile resource association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation GetProfileResourceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/GetProfileResourceAssociation
func (c *Route53Profiles) GetProfileResourceAssociation(input *GetProfileResourceAssociationInput) (*GetProfileResourceAssociationOutput, error) {
	req, out := c.GetProfileResourceAssociationRequest(input)
	return out, req.Send()
}

// GetProfileResourceAssociationWithContext is the same as GetProfileResourceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See GetProfileResourceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) GetProfileResourceAssociationWithContext(ctx aws.Context, input *GetProfileResourceAssociationInput, opts ...request.Option) (*GetProfileResourceAssociationOutput, error) {
	req, out := c.GetProfileResourceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListProfileAssociations = "ListProfileAssociations"

// ListProfileAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileAssociations for more information on using the ListProfileAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileAssociationsRequest method.
//	req, resp := client.ListProfileAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfileAssociations
func (c *Route53Profiles) ListProfileAssociationsRequest(input *ListProfileAssociationsInput) (req *request.Request, output *ListProfileAssociationsOutput) {
	op := &request.Operation{
		Name:       opListProfileAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/profileassociations",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileAssociationsInput{}
	}

	output = &ListProfileAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileAssociations API operation for Route 53 Profiles.
//
// Lists all the VPCs that the specified Route 53 Profile is associated with.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation ListProfileAssociations for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - InvalidNextTokenException
//     The NextToken you provided isn;t valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfileAssociations
func (c *Route53Profiles) ListProfileAssociations(input *ListProfileAssociationsInput) (*ListProfileAssociationsOutput, error) {
	req, out := c.ListProfileAssociationsRequest(input)
	return out, req.Send()
}

// ListProfileAssociationsWithContext is the same as ListProfileAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfileAssociationsWithContext(ctx aws.Context, input *ListProfileAssociationsInput, opts ...request.Option) (*ListProfileAssociationsOutput, error) {
	req, out := c.ListProfileAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfileAssociationsPages iterates over the pages of a ListProfileAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfileAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfileAssociations operation.
//	pageNum := 0
//	err := client.ListProfileAssociationsPages(params,
//	    func(page *route53profiles.ListProfileAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Profiles) ListProfileAssociationsPages(input *ListProfileAssociationsInput, fn func(*ListProfileAssociationsOutput, bool) bool) error {
	return c.ListProfileAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfileAssociationsPagesWithContext same as ListProfileAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfileAssociationsPagesWithContext(ctx aws.Context, input *ListProfileAssociationsInput, fn func(*ListProfileAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfileAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfileAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfileAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfileResourceAssociations = "ListProfileResourceAssociations"

// ListProfileResourceAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListProfileResourceAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfileResourceAssociations for more information on using the ListProfileResourceAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfileResourceAssociationsRequest method.
//	req, resp := client.ListProfileResourceAssociationsRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfileResourceAssociations
func (c *Route53Profiles) ListProfileResourceAssociationsRequest(input *ListProfileResourceAssociationsInput) (req *request.Request, output *ListProfileResourceAssociationsOutput) {
	op := &request.Operation{
		Name:       opListProfileResourceAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/profileresourceassociations/profileid/{ProfileId}",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfileResourceAssociationsInput{}
	}

	output = &ListProfileResourceAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfileResourceAssociations API operation for Route 53 Profiles.
//
// Lists all the resource associations for the specified Route 53 Profile.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation ListProfileResourceAssociations for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - InternalServiceErrorException
//     An internal server error occured. Retry your request.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - InvalidNextTokenException
//     The NextToken you provided isn;t valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfileResourceAssociations
func (c *Route53Profiles) ListProfileResourceAssociations(input *ListProfileResourceAssociationsInput) (*ListProfileResourceAssociationsOutput, error) {
	req, out := c.ListProfileResourceAssociationsRequest(input)
	return out, req.Send()
}

// ListProfileResourceAssociationsWithContext is the same as ListProfileResourceAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfileResourceAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfileResourceAssociationsWithContext(ctx aws.Context, input *ListProfileResourceAssociationsInput, opts ...request.Option) (*ListProfileResourceAssociationsOutput, error) {
	req, out := c.ListProfileResourceAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfileResourceAssociationsPages iterates over the pages of a ListProfileResourceAssociations operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfileResourceAssociations method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfileResourceAssociations operation.
//	pageNum := 0
//	err := client.ListProfileResourceAssociationsPages(params,
//	    func(page *route53profiles.ListProfileResourceAssociationsOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Profiles) ListProfileResourceAssociationsPages(input *ListProfileResourceAssociationsInput, fn func(*ListProfileResourceAssociationsOutput, bool) bool) error {
	return c.ListProfileResourceAssociationsPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfileResourceAssociationsPagesWithContext same as ListProfileResourceAssociationsPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfileResourceAssociationsPagesWithContext(ctx aws.Context, input *ListProfileResourceAssociationsInput, fn func(*ListProfileResourceAssociationsOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfileResourceAssociationsInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfileResourceAssociationsRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfileResourceAssociationsOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListProfiles = "ListProfiles"

// ListProfilesRequest generates a "aws/request.Request" representing the
// client's request for the ListProfiles operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListProfiles for more information on using the ListProfiles
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListProfilesRequest method.
//	req, resp := client.ListProfilesRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfiles
func (c *Route53Profiles) ListProfilesRequest(input *ListProfilesInput) (req *request.Request, output *ListProfilesOutput) {
	op := &request.Operation{
		Name:       opListProfiles,
		HTTPMethod: "GET",
		HTTPPath:   "/profiles",
		Paginator: &request.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListProfilesInput{}
	}

	output = &ListProfilesOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListProfiles API operation for Route 53 Profiles.
//
// Lists all the Route 53 Profiles associated with your Amazon Web Services
// account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation ListProfiles for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - InvalidNextTokenException
//     The NextToken you provided isn;t valid.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListProfiles
func (c *Route53Profiles) ListProfiles(input *ListProfilesInput) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	return out, req.Send()
}

// ListProfilesWithContext is the same as ListProfiles with the addition of
// the ability to pass a context and additional request options.
//
// See ListProfiles for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfilesWithContext(ctx aws.Context, input *ListProfilesInput, opts ...request.Option) (*ListProfilesOutput, error) {
	req, out := c.ListProfilesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// ListProfilesPages iterates over the pages of a ListProfiles operation,
// calling the "fn" function with the response data for each page. To stop
// iterating, return false from the fn function.
//
// See ListProfiles method for more information on how to use this operation.
//
// Note: This operation can generate multiple requests to a service.
//
//	// Example iterating over at most 3 pages of a ListProfiles operation.
//	pageNum := 0
//	err := client.ListProfilesPages(params,
//	    func(page *route53profiles.ListProfilesOutput, lastPage bool) bool {
//	        pageNum++
//	        fmt.Println(page)
//	        return pageNum <= 3
//	    })
func (c *Route53Profiles) ListProfilesPages(input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool) error {
	return c.ListProfilesPagesWithContext(aws.BackgroundContext(), input, fn)
}

// ListProfilesPagesWithContext same as ListProfilesPages except
// it takes a Context and allows setting request options on the pages.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListProfilesPagesWithContext(ctx aws.Context, input *ListProfilesInput, fn func(*ListProfilesOutput, bool) bool, opts ...request.Option) error {
	p := request.Pagination{
		NewRequest: func() (*request.Request, error) {
			var inCpy *ListProfilesInput
			if input != nil {
				tmp := *input
				inCpy = &tmp
			}
			req, _ := c.ListProfilesRequest(inCpy)
			req.SetContext(ctx)
			req.ApplyOptions(opts...)
			return req, nil
		},
	}

	for p.Next() {
		if !fn(p.Page().(*ListProfilesOutput), !p.HasNextPage()) {
			break
		}
	}

	return p.Err()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the ListTagsForResourceRequest method.
//	req, resp := client.ListTagsForResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListTagsForResource
func (c *Route53Profiles) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Route 53 Profiles.
//
// Lists the tags that you associated with the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/ListTagsForResource
func (c *Route53Profiles) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the TagResourceRequest method.
//	req, resp := client.TagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/TagResource
func (c *Route53Profiles) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Route 53 Profiles.
//
// Adds one or more tags to a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/TagResource
func (c *Route53Profiles) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UntagResourceRequest method.
//	req, resp := client.UntagResourceRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/UntagResource
func (c *Route53Profiles) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{ResourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Route 53 Profiles.
//
// Removes one or more tags from a specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/UntagResource
func (c *Route53Profiles) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateProfileResourceAssociation = "UpdateProfileResourceAssociation"

// UpdateProfileResourceAssociationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateProfileResourceAssociation operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateProfileResourceAssociation for more information on using the UpdateProfileResourceAssociation
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the UpdateProfileResourceAssociationRequest method.
//	req, resp := client.UpdateProfileResourceAssociationRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/UpdateProfileResourceAssociation
func (c *Route53Profiles) UpdateProfileResourceAssociationRequest(input *UpdateProfileResourceAssociationInput) (req *request.Request, output *UpdateProfileResourceAssociationOutput) {
	op := &request.Operation{
		Name:       opUpdateProfileResourceAssociation,
		HTTPMethod: "PATCH",
		HTTPPath:   "/profileresourceassociation/{ProfileResourceAssociationId}",
	}

	if input == nil {
		input = &UpdateProfileResourceAssociationInput{}
	}

	output = &UpdateProfileResourceAssociationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// UpdateProfileResourceAssociation API operation for Route 53 Profiles.
//
// Updates the specified Route 53 Profile resourse association.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Route 53 Profiles's
// API operation UpdateProfileResourceAssociation for usage and error information.
//
// Returned Error Types:
//
//   - ResourceNotFoundException
//     The resource you are associating is not found.
//
//   - LimitExceededException
//     The request caused one or more limits to be exceeded.
//
//   - InternalServiceErrorException
//     An internal server error occured. Retry your request.
//
//   - InvalidParameterException
//     One or more parameters in this request are not valid.
//
//   - ThrottlingException
//     The request was throttled. Try again in a few minutes.
//
//   - ValidationException
//     You have provided an invalid command.
//
//   - AccessDeniedException
//     The current account doesn't have the IAM permissions required to perform
//     the specified operation.
//
//   - ConflictException
//     The request you submitted conflicts with an existing request.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/route53profiles-2018-05-10/UpdateProfileResourceAssociation
func (c *Route53Profiles) UpdateProfileResourceAssociation(input *UpdateProfileResourceAssociationInput) (*UpdateProfileResourceAssociationOutput, error) {
	req, out := c.UpdateProfileResourceAssociationRequest(input)
	return out, req.Send()
}

// UpdateProfileResourceAssociationWithContext is the same as UpdateProfileResourceAssociation with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateProfileResourceAssociation for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Route53Profiles) UpdateProfileResourceAssociationWithContext(ctx aws.Context, input *UpdateProfileResourceAssociationInput, opts ...request.Option) (*UpdateProfileResourceAssociationOutput, error) {
	req, out := c.UpdateProfileResourceAssociationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// The current account doesn't have the IAM permissions required to perform
// the specified operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AssociateProfileInput struct {
	_ struct{} `type:"structure"`

	// A name for the association.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `min:"1" type:"string" required:"true"`

	// The ID of the VPC.
	//
	// ResourceId is a required field
	ResourceId *string `min:"1" type:"string" required:"true"`

	// A list of the tag keys and values that you want to identify the Profile association.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateProfileInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociateProfileInput) SetName(v string) *AssociateProfileInput {
	s.Name = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *AssociateProfileInput) SetProfileId(v string) *AssociateProfileInput {
	s.ProfileId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *AssociateProfileInput) SetResourceId(v string) *AssociateProfileInput {
	s.ResourceId = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AssociateProfileInput) SetTags(v []*Tag) *AssociateProfileInput {
	s.Tags = v
	return s
}

type AssociateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The association that you just created. The association has an ID that you
	// can use to identify it in other requests, like update and delete.
	ProfileAssociation *ProfileAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileAssociation sets the ProfileAssociation field's value.
func (s *AssociateProfileOutput) SetProfileAssociation(v *ProfileAssociation) *AssociateProfileOutput {
	s.ProfileAssociation = v
	return s
}

type AssociateResourceToProfileInput struct {
	_ struct{} `type:"structure"`

	// Name for the resource association.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `min:"1" type:"string" required:"true"`

	// Amazon resource number, ARN, of the DNS resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"1" type:"string" required:"true"`

	// If you are adding a DNS Firewall rule group, include also a priority in this
	// format:
	//
	// Key=FirewallRuleGroupPriority,Value=100
	ResourceProperties *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceToProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceToProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AssociateResourceToProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AssociateResourceToProfileInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *AssociateResourceToProfileInput) SetName(v string) *AssociateResourceToProfileInput {
	s.Name = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *AssociateResourceToProfileInput) SetProfileId(v string) *AssociateResourceToProfileInput {
	s.ProfileId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *AssociateResourceToProfileInput) SetResourceArn(v string) *AssociateResourceToProfileInput {
	s.ResourceArn = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *AssociateResourceToProfileInput) SetResourceProperties(v string) *AssociateResourceToProfileInput {
	s.ResourceProperties = &v
	return s
}

type AssociateResourceToProfileOutput struct {
	_ struct{} `type:"structure"`

	// Infromation about the AssociateResourceToProfile, including a status message.
	ProfileResourceAssociation *ProfileResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceToProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AssociateResourceToProfileOutput) GoString() string {
	return s.String()
}

// SetProfileResourceAssociation sets the ProfileResourceAssociation field's value.
func (s *AssociateResourceToProfileOutput) SetProfileResourceAssociation(v *ProfileResourceAssociation) *AssociateResourceToProfileOutput {
	s.ProfileResourceAssociation = v
	return s
}

// The request you submitted conflicts with an existing request.
type ConflictException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ConflictException) GoString() string {
	return s.String()
}

func newErrorConflictException(v protocol.ResponseMetadata) error {
	return &ConflictException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ConflictException) Code() string {
	return "ConflictException"
}

// Message returns the exception's message.
func (s *ConflictException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ConflictException) OrigErr() error {
	return nil
}

func (s *ConflictException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ConflictException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ConflictException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateProfileInput struct {
	_ struct{} `type:"structure"`

	// ClientToken is an idempotency token that ensures a call to CreateProfile
	// completes only once. You choose the value to pass. For example, an issue
	// might prevent you from getting a response from CreateProfile. In this case,
	// safely retry your call to CreateProfile by using the same CreateProfile parameter
	// value.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A name for the Profile.
	//
	// Name is a required field
	Name *string `type:"string" required:"true"`

	// A list of the tag keys and values that you want to associate with the Route
	// 53 Profile.
	Tags []*Tag `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateProfileInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Tags != nil {
		for i, v := range s.Tags {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Tags", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateProfileInput) SetClientToken(v string) *CreateProfileInput {
	s.ClientToken = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateProfileInput) SetName(v string) *CreateProfileInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateProfileInput) SetTags(v []*Tag) *CreateProfileInput {
	s.Tags = v
	return s
}

type CreateProfileOutput struct {
	_ struct{} `type:"structure"`

	// The Profile that you just created.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *CreateProfileOutput) SetProfile(v *Profile) *CreateProfileOutput {
	s.Profile = v
	return s
}

type DeleteProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Profile that you want to delete.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DeleteProfileInput) SetProfileId(v string) *DeleteProfileInput {
	s.ProfileId = &v
	return s
}

type DeleteProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DeleteProfile request, including the status of the
	// request.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *DeleteProfileOutput) SetProfile(v *Profile) *DeleteProfileOutput {
	s.Profile = v
	return s
}

type DisassociateProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" min:"1" type:"string" required:"true"`

	// The ID of the VPC.
	//
	// ResourceId is a required field
	ResourceId *string `location:"uri" locationName:"ResourceId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.ResourceId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceId"))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DisassociateProfileInput) SetProfileId(v string) *DisassociateProfileInput {
	s.ProfileId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *DisassociateProfileInput) SetResourceId(v string) *DisassociateProfileInput {
	s.ResourceId = &v
	return s
}

type DisassociateProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DisassociateProfile request.
	ProfileAssociation *ProfileAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateProfileOutput) GoString() string {
	return s.String()
}

// SetProfileAssociation sets the ProfileAssociation field's value.
func (s *DisassociateProfileOutput) SetProfileAssociation(v *ProfileAssociation) *DisassociateProfileOutput {
	s.ProfileAssociation = v
	return s
}

type DisassociateResourceFromProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" min:"1" type:"string" required:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceFromProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceFromProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisassociateResourceFromProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisassociateResourceFromProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *DisassociateResourceFromProfileInput) SetProfileId(v string) *DisassociateResourceFromProfileInput {
	s.ProfileId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *DisassociateResourceFromProfileInput) SetResourceArn(v string) *DisassociateResourceFromProfileInput {
	s.ResourceArn = &v
	return s
}

type DisassociateResourceFromProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the DisassociateResourceFromProfile request, including
	// the status of the request.
	ProfileResourceAssociation *ProfileResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceFromProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DisassociateResourceFromProfileOutput) GoString() string {
	return s.String()
}

// SetProfileResourceAssociation sets the ProfileResourceAssociation field's value.
func (s *DisassociateResourceFromProfileOutput) SetProfileResourceAssociation(v *ProfileResourceAssociation) *DisassociateResourceFromProfileOutput {
	s.ProfileResourceAssociation = v
	return s
}

type GetProfileAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The identifier of the association you want to get information about.
	//
	// ProfileAssociationId is a required field
	ProfileAssociationId *string `location:"uri" locationName:"ProfileAssociationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileAssociationInput"}
	if s.ProfileAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileAssociationId"))
	}
	if s.ProfileAssociationId != nil && len(*s.ProfileAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileAssociationId sets the ProfileAssociationId field's value.
func (s *GetProfileAssociationInput) SetProfileAssociationId(v string) *GetProfileAssociationInput {
	s.ProfileAssociationId = &v
	return s
}

type GetProfileAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Profile association that you specified in a GetProfileAssociation
	// request.
	ProfileAssociation *ProfileAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileAssociationOutput) GoString() string {
	return s.String()
}

// SetProfileAssociation sets the ProfileAssociation field's value.
func (s *GetProfileAssociationOutput) SetProfileAssociation(v *ProfileAssociation) *GetProfileAssociationOutput {
	s.ProfileAssociation = v
	return s
}

type GetProfileInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileInput"}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileId sets the ProfileId field's value.
func (s *GetProfileInput) SetProfileId(v string) *GetProfileInput {
	s.ProfileId = &v
	return s
}

type GetProfileOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Profile, including the status of the Profile.
	Profile *Profile `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileOutput) GoString() string {
	return s.String()
}

// SetProfile sets the Profile field's value.
func (s *GetProfileOutput) SetProfile(v *Profile) *GetProfileOutput {
	s.Profile = v
	return s
}

type GetProfileResourceAssociationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The ID of the profile resource association that you want to get information
	// about.
	//
	// ProfileResourceAssociationId is a required field
	ProfileResourceAssociationId *string `location:"uri" locationName:"ProfileResourceAssociationId" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileResourceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileResourceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetProfileResourceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetProfileResourceAssociationInput"}
	if s.ProfileResourceAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileResourceAssociationId"))
	}
	if s.ProfileResourceAssociationId != nil && len(*s.ProfileResourceAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileResourceAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProfileResourceAssociationId sets the ProfileResourceAssociationId field's value.
func (s *GetProfileResourceAssociationInput) SetProfileResourceAssociationId(v string) *GetProfileResourceAssociationInput {
	s.ProfileResourceAssociationId = &v
	return s
}

type GetProfileResourceAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the Profile resource association that you specified in
	// a GetProfileResourceAssociation request.
	ProfileResourceAssociation *ProfileResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileResourceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetProfileResourceAssociationOutput) GoString() string {
	return s.String()
}

// SetProfileResourceAssociation sets the ProfileResourceAssociation field's value.
func (s *GetProfileResourceAssociationOutput) SetProfileResourceAssociation(v *ProfileResourceAssociation) *GetProfileResourceAssociationOutput {
	s.ProfileResourceAssociation = v
	return s
}

// An internal server error occured. Retry your request.
type InternalServiceErrorException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceErrorException) GoString() string {
	return s.String()
}

func newErrorInternalServiceErrorException(v protocol.ResponseMetadata) error {
	return &InternalServiceErrorException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceErrorException) Code() string {
	return "InternalServiceErrorException"
}

// Message returns the exception's message.
func (s *InternalServiceErrorException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceErrorException) OrigErr() error {
	return nil
}

func (s *InternalServiceErrorException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceErrorException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceErrorException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The NextToken you provided isn;t valid.
type InvalidNextTokenException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidNextTokenException) GoString() string {
	return s.String()
}

func newErrorInvalidNextTokenException(v protocol.ResponseMetadata) error {
	return &InvalidNextTokenException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidNextTokenException) Code() string {
	return "InvalidNextTokenException"
}

// Message returns the exception's message.
func (s *InvalidNextTokenException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidNextTokenException) OrigErr() error {
	return nil
}

func (s *InvalidNextTokenException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidNextTokenException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidNextTokenException) RequestID() string {
	return s.RespMetadata.RequestID
}

// One or more parameters in this request are not valid.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	// The parameter field name for the invalid parameter exception.
	FieldName *string `type:"string"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request caused one or more limits to be exceeded.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The resource type that caused the limits to be exceeded.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListProfileAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects that you want to return for this request. If
	// more objects are available, in the response, a NextToken value, which you
	// can use in a subsequent call to get the next batch of objects, is provided.
	//
	// If you don't specify a value for MaxResults, up to 100 objects are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, at most the number of objects specified
	// by MaxResults is returned. If more objects are available for retrieval, a
	// NextToken value is returned in the response. To retrieve the next batch of
	// objects, use the token that was returned for the prior request in your next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// ID of the Profile.
	ProfileId *string `location:"querystring" locationName:"profileId" min:"1" type:"string"`

	// ID of the VPC.
	ResourceId *string `location:"querystring" locationName:"resourceId" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}
	if s.ResourceId != nil && len(*s.ResourceId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileAssociationsInput) SetMaxResults(v int64) *ListProfileAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileAssociationsInput) SetNextToken(v string) *ListProfileAssociationsInput {
	s.NextToken = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListProfileAssociationsInput) SetProfileId(v string) *ListProfileAssociationsInput {
	s.ProfileId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ListProfileAssociationsInput) SetResourceId(v string) *ListProfileAssociationsInput {
	s.ResourceId = &v
	return s
}

type ListProfileAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults profile associations match the specified criteria,
	// you can submit another ListProfileAssociations request to get the next group
	// of results. In the next request, specify the value of NextToken from the
	// previous response.
	NextToken *string `type:"string"`

	// A complex type that containts settings information about the profile's VPC
	// associations.
	ProfileAssociations []*ProfileAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileAssociationsOutput) SetNextToken(v string) *ListProfileAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetProfileAssociations sets the ProfileAssociations field's value.
func (s *ListProfileAssociationsOutput) SetProfileAssociations(v []*ProfileAssociation) *ListProfileAssociationsOutput {
	s.ProfileAssociations = v
	return s
}

type ListProfileResourceAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects that you want to return for this request. If
	// more objects are available, in the response, a NextToken value, which you
	// can use in a subsequent call to get the next batch of objects, is provided.
	//
	// If you don't specify a value for MaxResults, up to 100 objects are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, at most the number of objects specified
	// by MaxResults is returned. If more objects are available for retrieval, a
	// NextToken value is returned in the response. To retrieve the next batch of
	// objects, use the token that was returned for the prior request in your next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`

	// The ID of the Profile.
	//
	// ProfileId is a required field
	ProfileId *string `location:"uri" locationName:"ProfileId" min:"1" type:"string" required:"true"`

	// ID of a resource if you want information on only one type.
	ResourceType *string `location:"querystring" locationName:"resourceType" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileResourceAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileResourceAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfileResourceAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfileResourceAssociationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.ProfileId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileId"))
	}
	if s.ProfileId != nil && len(*s.ProfileId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfileResourceAssociationsInput) SetMaxResults(v int64) *ListProfileResourceAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileResourceAssociationsInput) SetNextToken(v string) *ListProfileResourceAssociationsInput {
	s.NextToken = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ListProfileResourceAssociationsInput) SetProfileId(v string) *ListProfileResourceAssociationsInput {
	s.ProfileId = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ListProfileResourceAssociationsInput) SetResourceType(v string) *ListProfileResourceAssociationsInput {
	s.ResourceType = &v
	return s
}

type ListProfileResourceAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults resource associations match the specified criteria,
	// you can submit another ListProfileResourceAssociations request to get the
	// next group of results. In the next request, specify the value of NextToken
	// from the previous response.
	NextToken *string `type:"string"`

	// Information about the profile resource association that you specified in
	// a GetProfileResourceAssociation request.
	ProfileResourceAssociations []*ProfileResourceAssociation `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileResourceAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfileResourceAssociationsOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfileResourceAssociationsOutput) SetNextToken(v string) *ListProfileResourceAssociationsOutput {
	s.NextToken = &v
	return s
}

// SetProfileResourceAssociations sets the ProfileResourceAssociations field's value.
func (s *ListProfileResourceAssociationsOutput) SetProfileResourceAssociations(v []*ProfileResourceAssociation) *ListProfileResourceAssociationsOutput {
	s.ProfileResourceAssociations = v
	return s
}

type ListProfilesInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of objects that you want to return for this request. If
	// more objects are available, in the response, a NextToken value, which you
	// can use in a subsequent call to get the next batch of objects, is provided.
	//
	// If you don't specify a value for MaxResults, up to 100 objects are returned.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// For the first call to this list request, omit this value.
	//
	// When you request a list of objects, at most the number of objects specified
	// by MaxResults is returned. If more objects are available for retrieval, a
	// NextToken value is returned in the response. To retrieve the next batch of
	// objects, use the token that was returned for the prior request in your next
	// request.
	NextToken *string `location:"querystring" locationName:"nextToken" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListProfilesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListProfilesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListProfilesInput) SetMaxResults(v int64) *ListProfilesInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesInput) SetNextToken(v string) *ListProfilesInput {
	s.NextToken = &v
	return s
}

type ListProfilesOutput struct {
	_ struct{} `type:"structure"`

	// If more than MaxResults resource associations match the specified criteria,
	// you can submit another ListProfiles request to get the next group of results.
	// In the next request, specify the value of NextToken from the previous response.
	NextToken *string `type:"string"`

	// Summary information about the Profiles.
	ProfileSummaries []*ProfileSummary `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListProfilesOutput) GoString() string {
	return s.String()
}

// SetNextToken sets the NextToken field's value.
func (s *ListProfilesOutput) SetNextToken(v string) *ListProfilesOutput {
	s.NextToken = &v
	return s
}

// SetProfileSummaries sets the ProfileSummaries field's value.
func (s *ListProfilesOutput) SetProfileSummaries(v []*ProfileSummary) *ListProfilesOutput {
	s.ProfileSummaries = v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for the resource that you want to list the
	// tags for.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The tags that are associated with the resource that you specified in the
	// ListTagsForResource request.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// A complex type that includes settings for a Route 53 Profile.
type Profile struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Profile.
	Arn *string `min:"1" type:"string"`

	// The ClientToken value that was assigned when the Profile was created.
	ClientToken *string `min:"1" type:"string"`

	// The date and time that the Profile was created, in Unix time format and Coordinated
	// Universal Time (UTC).
	CreationTime *time.Time `type:"timestamp"`

	// ID of the Profile.
	Id *string `min:"1" type:"string"`

	// The date and time that the Profile was modified, in Unix time format and
	// Coordinated Universal Time (UTC).
	ModificationTime *time.Time `type:"timestamp"`

	// Name of the Profile.
	Name *string `type:"string"`

	// Amazon Web Services account ID of the Profile owner.
	OwnerId *string `min:"12" type:"string"`

	// Sharing status for the Profile.
	ShareStatus *string `type:"string" enum:"ShareStatus"`

	// The status for the Profile.
	Status *string `type:"string" enum:"ProfileStatus"`

	// Status message that includes additiona information about the Profile.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Profile) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *Profile) SetArn(v string) *Profile {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *Profile) SetClientToken(v string) *Profile {
	s.ClientToken = &v
	return s
}

// SetCreationTime sets the CreationTime field's value.
func (s *Profile) SetCreationTime(v time.Time) *Profile {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *Profile) SetId(v string) *Profile {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *Profile) SetModificationTime(v time.Time) *Profile {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *Profile) SetName(v string) *Profile {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *Profile) SetOwnerId(v string) *Profile {
	s.OwnerId = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *Profile) SetShareStatus(v string) *Profile {
	s.ShareStatus = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *Profile) SetStatus(v string) *Profile {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *Profile) SetStatusMessage(v string) *Profile {
	s.StatusMessage = &v
	return s
}

// An association between a Route 53 Profile and a VPC.
type ProfileAssociation struct {
	_ struct{} `type:"structure"`

	// The date and time that the Profile association was created, in Unix time
	// format and Coordinated Universal Time (UTC).
	CreationTime *time.Time `type:"timestamp"`

	// ID of the Profile association.
	Id *string `min:"1" type:"string"`

	// The date and time that the Profile association was modified, in Unix time
	// format and Coordinated Universal Time (UTC).
	ModificationTime *time.Time `type:"timestamp"`

	// Name of the Profile association.
	Name *string `type:"string"`

	// Amazon Web Services account ID of the Profile association owner.
	OwnerId *string `min:"12" type:"string"`

	// ID of the Profile.
	ProfileId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the VPC.
	ResourceId *string `min:"1" type:"string"`

	// Status of the Profile association.
	Status *string `type:"string" enum:"ProfileStatus"`

	// Additional information about the Profile association.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileAssociation) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ProfileAssociation) SetCreationTime(v time.Time) *ProfileAssociation {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProfileAssociation) SetId(v string) *ProfileAssociation {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ProfileAssociation) SetModificationTime(v time.Time) *ProfileAssociation {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProfileAssociation) SetName(v string) *ProfileAssociation {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ProfileAssociation) SetOwnerId(v string) *ProfileAssociation {
	s.OwnerId = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ProfileAssociation) SetProfileId(v string) *ProfileAssociation {
	s.ProfileId = &v
	return s
}

// SetResourceId sets the ResourceId field's value.
func (s *ProfileAssociation) SetResourceId(v string) *ProfileAssociation {
	s.ResourceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProfileAssociation) SetStatus(v string) *ProfileAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProfileAssociation) SetStatusMessage(v string) *ProfileAssociation {
	s.StatusMessage = &v
	return s
}

// The association between a Route 53 Profile and resources.
type ProfileResourceAssociation struct {
	_ struct{} `type:"structure"`

	// The date and time that the Profile resource association was created, in Unix
	// time format and Coordinated Universal Time (UTC).
	CreationTime *time.Time `type:"timestamp"`

	// ID of the Profile resource association.
	Id *string `min:"1" type:"string"`

	// The date and time that the Profile resource association was modified, in
	// Unix time format and Coordinated Universal Time (UTC).
	ModificationTime *time.Time `type:"timestamp"`

	// Name of the Profile resource association.
	Name *string `type:"string"`

	// Amazon Web Services account ID of the Profile resource association owner.
	OwnerId *string `min:"12" type:"string"`

	// Profile ID of the Profile that the resources are associated with.
	ProfileId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the resource association.
	ResourceArn *string `min:"1" type:"string"`

	// If the DNS resource is a DNS Firewall rule group, this indicates the priority.
	ResourceProperties *string `type:"string"`

	// Resource type, such as a private hosted zone, or DNS Firewall rule group.
	ResourceType *string `type:"string"`

	// Status of the Profile resource association.
	Status *string `type:"string" enum:"ProfileStatus"`

	// Additional information about the Profile resource association.
	StatusMessage *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileResourceAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileResourceAssociation) GoString() string {
	return s.String()
}

// SetCreationTime sets the CreationTime field's value.
func (s *ProfileResourceAssociation) SetCreationTime(v time.Time) *ProfileResourceAssociation {
	s.CreationTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProfileResourceAssociation) SetId(v string) *ProfileResourceAssociation {
	s.Id = &v
	return s
}

// SetModificationTime sets the ModificationTime field's value.
func (s *ProfileResourceAssociation) SetModificationTime(v time.Time) *ProfileResourceAssociation {
	s.ModificationTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProfileResourceAssociation) SetName(v string) *ProfileResourceAssociation {
	s.Name = &v
	return s
}

// SetOwnerId sets the OwnerId field's value.
func (s *ProfileResourceAssociation) SetOwnerId(v string) *ProfileResourceAssociation {
	s.OwnerId = &v
	return s
}

// SetProfileId sets the ProfileId field's value.
func (s *ProfileResourceAssociation) SetProfileId(v string) *ProfileResourceAssociation {
	s.ProfileId = &v
	return s
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ProfileResourceAssociation) SetResourceArn(v string) *ProfileResourceAssociation {
	s.ResourceArn = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *ProfileResourceAssociation) SetResourceProperties(v string) *ProfileResourceAssociation {
	s.ResourceProperties = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *ProfileResourceAssociation) SetResourceType(v string) *ProfileResourceAssociation {
	s.ResourceType = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ProfileResourceAssociation) SetStatus(v string) *ProfileResourceAssociation {
	s.Status = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *ProfileResourceAssociation) SetStatusMessage(v string) *ProfileResourceAssociation {
	s.StatusMessage = &v
	return s
}

// Summary information about a Route 53 Profile.
type ProfileSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the Profile.
	Arn *string `min:"1" type:"string"`

	// ID of the Profile.
	Id *string `min:"1" type:"string"`

	// Name of the Profile.
	Name *string `type:"string"`

	// Share status of the Profile.
	ShareStatus *string `type:"string" enum:"ShareStatus"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProfileSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *ProfileSummary) SetArn(v string) *ProfileSummary {
	s.Arn = &v
	return s
}

// SetId sets the Id field's value.
func (s *ProfileSummary) SetId(v string) *ProfileSummary {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ProfileSummary) SetName(v string) *ProfileSummary {
	s.Name = &v
	return s
}

// SetShareStatus sets the ShareStatus field's value.
func (s *ProfileSummary) SetShareStatus(v string) *ProfileSummary {
	s.ShareStatus = &v
	return s
}

// The resource you are trying to associate, has already been associated.
type ResourceExistsException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The resource type that caused the resource exists exception.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceExistsException) GoString() string {
	return s.String()
}

func newErrorResourceExistsException(v protocol.ResponseMetadata) error {
	return &ResourceExistsException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceExistsException) Code() string {
	return "ResourceExistsException"
}

// Message returns the exception's message.
func (s *ResourceExistsException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceExistsException) OrigErr() error {
	return nil
}

func (s *ResourceExistsException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceExistsException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceExistsException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The resource you are associating is not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`

	// The resource type that caused the resource not found exception.
	ResourceType *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Tag for the Profile.
type Tag struct {
	_ struct{} `type:"structure"`

	// Key associated with the Tag.
	//
	// Key is a required field
	Key *string `min:"1" type:"string" required:"true"`

	// Value for the Tag.
	//
	// Value is a required field
	Value *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Tag) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Tag) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Tag"}
	if s.Key == nil {
		invalidParams.Add(request.NewErrParamRequired("Key"))
	}
	if s.Key != nil && len(*s.Key) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Key", 1))
	}
	if s.Value == nil {
		invalidParams.Add(request.NewErrParamRequired("Value"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *Tag) SetKey(v string) *Tag {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *Tag) SetValue(v string) *Tag {
	s.Value = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the resource that you want to add tags
	// to.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The tags that you want to add to the specified resource.
	//
	// Tags is a required field
	Tags map[string]*string `type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The request was throttled. Try again in a few minutes.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) for the resource that you want to remove tags
	// from.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"ResourceArn" min:"1" type:"string" required:"true"`

	// The tags that you want to remove to the specified resource.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateProfileResourceAssociationInput struct {
	_ struct{} `type:"structure"`

	// Name of the resource association.
	Name *string `type:"string"`

	// ID of the resource association.
	//
	// ProfileResourceAssociationId is a required field
	ProfileResourceAssociationId *string `location:"uri" locationName:"ProfileResourceAssociationId" min:"1" type:"string" required:"true"`

	// If you are adding a DNS Firewall rule group, include also a priority in this
	// format:
	//
	// Key=FirewallRuleGroupPriority,Value=100.
	ResourceProperties *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileResourceAssociationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileResourceAssociationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateProfileResourceAssociationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateProfileResourceAssociationInput"}
	if s.ProfileResourceAssociationId == nil {
		invalidParams.Add(request.NewErrParamRequired("ProfileResourceAssociationId"))
	}
	if s.ProfileResourceAssociationId != nil && len(*s.ProfileResourceAssociationId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ProfileResourceAssociationId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *UpdateProfileResourceAssociationInput) SetName(v string) *UpdateProfileResourceAssociationInput {
	s.Name = &v
	return s
}

// SetProfileResourceAssociationId sets the ProfileResourceAssociationId field's value.
func (s *UpdateProfileResourceAssociationInput) SetProfileResourceAssociationId(v string) *UpdateProfileResourceAssociationInput {
	s.ProfileResourceAssociationId = &v
	return s
}

// SetResourceProperties sets the ResourceProperties field's value.
func (s *UpdateProfileResourceAssociationInput) SetResourceProperties(v string) *UpdateProfileResourceAssociationInput {
	s.ResourceProperties = &v
	return s
}

type UpdateProfileResourceAssociationOutput struct {
	_ struct{} `type:"structure"`

	// Information about the UpdateProfileResourceAssociation request, including
	// a status message.
	ProfileResourceAssociation *ProfileResourceAssociation `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileResourceAssociationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateProfileResourceAssociationOutput) GoString() string {
	return s.String()
}

// SetProfileResourceAssociation sets the ProfileResourceAssociation field's value.
func (s *UpdateProfileResourceAssociationOutput) SetProfileResourceAssociation(v *ProfileResourceAssociation) *UpdateProfileResourceAssociationOutput {
	s.ProfileResourceAssociation = v
	return s
}

// You have provided an invalid command.
type ValidationException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ValidationException) GoString() string {
	return s.String()
}

func newErrorValidationException(v protocol.ResponseMetadata) error {
	return &ValidationException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ValidationException) Code() string {
	return "ValidationException"
}

// Message returns the exception's message.
func (s *ValidationException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ValidationException) OrigErr() error {
	return nil
}

func (s *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ValidationException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ValidationException) RequestID() string {
	return s.RespMetadata.RequestID
}

const (
	// ProfileStatusComplete is a ProfileStatus enum value
	ProfileStatusComplete = "COMPLETE"

	// ProfileStatusDeleting is a ProfileStatus enum value
	ProfileStatusDeleting = "DELETING"

	// ProfileStatusUpdating is a ProfileStatus enum value
	ProfileStatusUpdating = "UPDATING"

	// ProfileStatusCreating is a ProfileStatus enum value
	ProfileStatusCreating = "CREATING"

	// ProfileStatusDeleted is a ProfileStatus enum value
	ProfileStatusDeleted = "DELETED"

	// ProfileStatusFailed is a ProfileStatus enum value
	ProfileStatusFailed = "FAILED"
)

// ProfileStatus_Values returns all elements of the ProfileStatus enum
func ProfileStatus_Values() []string {
	return []string{
		ProfileStatusComplete,
		ProfileStatusDeleting,
		ProfileStatusUpdating,
		ProfileStatusCreating,
		ProfileStatusDeleted,
		ProfileStatusFailed,
	}
}

const (
	// ShareStatusNotShared is a ShareStatus enum value
	ShareStatusNotShared = "NOT_SHARED"

	// ShareStatusSharedWithMe is a ShareStatus enum value
	ShareStatusSharedWithMe = "SHARED_WITH_ME"

	// ShareStatusSharedByMe is a ShareStatus enum value
	ShareStatusSharedByMe = "SHARED_BY_ME"
)

// ShareStatus_Values returns all elements of the ShareStatus enum
func ShareStatus_Values() []string {
	return []string{
		ShareStatusNotShared,
		ShareStatusSharedWithMe,
		ShareStatusSharedByMe,
	}
}
