// Code generated by the FlatBuffers compiler. DO NOT EDIT.

package fbtypes

import (
	flatbuffers "github.com/google/flatbuffers/go"

	motion__core__fbtypes "github.com/boschrexroth/ctrlx-datalayer-golang/pkg/fbs/motion/core/fbtypes"
)

/// set of homing parameters
type HomingParamT struct {
	NewRefPos float64
	TravelDisLim float64
	HomingDir string
	RefType RefType
	DynForward *motion__core__fbtypes.DynamicLimitsT
	DynBackward *motion__core__fbtypes.DynamicLimitsT
}

func (t *HomingParamT) Pack(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	if t == nil { return 0 }
	homingDirOffset := builder.CreateString(t.HomingDir)
	dynForwardOffset := t.DynForward.Pack(builder)
	dynBackwardOffset := t.DynBackward.Pack(builder)
	HomingParamStart(builder)
	HomingParamAddNewRefPos(builder, t.NewRefPos)
	HomingParamAddTravelDisLim(builder, t.TravelDisLim)
	HomingParamAddHomingDir(builder, homingDirOffset)
	HomingParamAddRefType(builder, t.RefType)
	HomingParamAddDynForward(builder, dynForwardOffset)
	HomingParamAddDynBackward(builder, dynBackwardOffset)
	return HomingParamEnd(builder)
}

func (rcv *HomingParam) UnPackTo(t *HomingParamT) {
	t.NewRefPos = rcv.NewRefPos()
	t.TravelDisLim = rcv.TravelDisLim()
	t.HomingDir = string(rcv.HomingDir())
	t.RefType = rcv.RefType()
	t.DynForward = rcv.DynForward(nil).UnPack()
	t.DynBackward = rcv.DynBackward(nil).UnPack()
}

func (rcv *HomingParam) UnPack() *HomingParamT {
	if rcv == nil { return nil }
	t := &HomingParamT{}
	rcv.UnPackTo(t)
	return t
}

type HomingParam struct {
	_tab flatbuffers.Table
}

func GetRootAsHomingParam(buf []byte, offset flatbuffers.UOffsetT) *HomingParam {
	n := flatbuffers.GetUOffsetT(buf[offset:])
	x := &HomingParam{}
	x.Init(buf, n+offset)
	return x
}

func GetSizePrefixedRootAsHomingParam(buf []byte, offset flatbuffers.UOffsetT) *HomingParam {
	n := flatbuffers.GetUOffsetT(buf[offset+flatbuffers.SizeUint32:])
	x := &HomingParam{}
	x.Init(buf, n+offset+flatbuffers.SizeUint32)
	return x
}

func (rcv *HomingParam) Init(buf []byte, i flatbuffers.UOffsetT) {
	rcv._tab.Bytes = buf
	rcv._tab.Pos = i
}

func (rcv *HomingParam) Table() flatbuffers.Table {
	return rcv._tab
}

/// commanded target position (or increment for relative position command
func (rcv *HomingParam) NewRefPos() float64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(4))
	if o != 0 {
		return rcv._tab.GetFloat64(o + rcv._tab.Pos)
	}
	return 0.0
}

/// commanded target position (or increment for relative position command
func (rcv *HomingParam) MutateNewRefPos(n float64) bool {
	return rcv._tab.MutateFloat64Slot(4, n)
}

/// max travel distance to search the reference switch
func (rcv *HomingParam) TravelDisLim() float64 {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(6))
	if o != 0 {
		return rcv._tab.GetFloat64(o + rcv._tab.Pos)
	}
	return 0.0
}

/// max travel distance to search the reference switch
func (rcv *HomingParam) MutateTravelDisLim(n float64) bool {
	return rcv._tab.MutateFloat64Slot(6, n)
}

/// homing direction
func (rcv *HomingParam) HomingDir() []byte {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(8))
	if o != 0 {
		return rcv._tab.ByteVector(o + rcv._tab.Pos)
	}
	return nil
}

/// homing direction
/// reference type to indicates set which position as the reference position
func (rcv *HomingParam) RefType() RefType {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(10))
	if o != 0 {
		return RefType(rcv._tab.GetInt8(o + rcv._tab.Pos))
	}
	return 0
}

/// reference type to indicates set which position as the reference position
func (rcv *HomingParam) MutateRefType(n RefType) bool {
	return rcv._tab.MutateInt8Slot(10, int8(n))
}

/// dynamic limit to search the reference switch(fast velocity)
func (rcv *HomingParam) DynForward(obj *motion__core__fbtypes.DynamicLimits) *motion__core__fbtypes.DynamicLimits {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(12))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(motion__core__fbtypes.DynamicLimits)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// dynamic limit to search the reference switch(fast velocity)
/// dynamic limit to move to reference switch(slow velocity)
func (rcv *HomingParam) DynBackward(obj *motion__core__fbtypes.DynamicLimits) *motion__core__fbtypes.DynamicLimits {
	o := flatbuffers.UOffsetT(rcv._tab.Offset(14))
	if o != 0 {
		x := rcv._tab.Indirect(o + rcv._tab.Pos)
		if obj == nil {
			obj = new(motion__core__fbtypes.DynamicLimits)
		}
		obj.Init(rcv._tab.Bytes, x)
		return obj
	}
	return nil
}

/// dynamic limit to move to reference switch(slow velocity)
func HomingParamStart(builder *flatbuffers.Builder) {
	builder.StartObject(6)
}
func HomingParamAddNewRefPos(builder *flatbuffers.Builder, newRefPos float64) {
	builder.PrependFloat64Slot(0, newRefPos, 0.0)
}
func HomingParamAddTravelDisLim(builder *flatbuffers.Builder, travelDisLim float64) {
	builder.PrependFloat64Slot(1, travelDisLim, 0.0)
}
func HomingParamAddHomingDir(builder *flatbuffers.Builder, homingDir flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(2, flatbuffers.UOffsetT(homingDir), 0)
}
func HomingParamAddRefType(builder *flatbuffers.Builder, refType RefType) {
	builder.PrependInt8Slot(3, int8(refType), 0)
}
func HomingParamAddDynForward(builder *flatbuffers.Builder, dynForward flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(4, flatbuffers.UOffsetT(dynForward), 0)
}
func HomingParamAddDynBackward(builder *flatbuffers.Builder, dynBackward flatbuffers.UOffsetT) {
	builder.PrependUOffsetTSlot(5, flatbuffers.UOffsetT(dynBackward), 0)
}
func HomingParamEnd(builder *flatbuffers.Builder) flatbuffers.UOffsetT {
	return builder.EndObject()
}
