//go:build go1.20

package errors_test

import (
	stderrors "errors"
	"io"
	"testing"

	"github.com/go-faster/errors"
)

var ErrValue = errors.New("value error")

type Error struct{}

func (*Error) Error() string {
	return "typed error"
}

// Compatibility test for multi-errors generated by [errors.Join]
func TestMulti(t *testing.T) {
	typedErr := new(Error)
	wrappedErr := errors.Wrap(io.ErrClosedPipe, "wrapped error")

	errs := stderrors.Join(ErrValue, typedErr, wrappedErr)

	// Test Is.
	if !errors.Is(errs, ErrValue) {
		t.Errorf("Expected Is(%+v, %+v) == true", errs, ErrValue)
	}

	// Test As.
	if target := new(*Error); !errors.As(errs, target) {
		t.Errorf("Expected As(%+v, %T) == true", errs, target)
	}

	// Test wrapping.
	if !errors.Is(errs, io.ErrClosedPipe) {
		t.Errorf("Expected Is(%+v, %+v) == true", errs, ErrValue)
	}
}
