// Copyright 2016 Google LLC. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.24.0
// 	protoc        v3.12.3
// source: crypto/sigpb/sigpb.proto

package sigpb

import (
	proto "github.com/golang/protobuf/proto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// This is a compile-time assertion that a sufficiently up-to-date version
// of the legacy proto package is being used.
const _ = proto.ProtoPackageIsVersion4

// HashAlgorithm defines the approved methods for object hashing.
//
// Supported hash algorithms. The numbering space is the same as for TLS,
// given in RFC 5246 s7.4.1.4.1 and at:
// http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-18
type DigitallySigned_HashAlgorithm int32

const (
	// No hash algorithm is used.
	DigitallySigned_NONE DigitallySigned_HashAlgorithm = 0
	// SHA256 is used.
	DigitallySigned_SHA256 DigitallySigned_HashAlgorithm = 4
)

// Enum value maps for DigitallySigned_HashAlgorithm.
var (
	DigitallySigned_HashAlgorithm_name = map[int32]string{
		0: "NONE",
		4: "SHA256",
	}
	DigitallySigned_HashAlgorithm_value = map[string]int32{
		"NONE":   0,
		"SHA256": 4,
	}
)

func (x DigitallySigned_HashAlgorithm) Enum() *DigitallySigned_HashAlgorithm {
	p := new(DigitallySigned_HashAlgorithm)
	*p = x
	return p
}

func (x DigitallySigned_HashAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigitallySigned_HashAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_crypto_sigpb_sigpb_proto_enumTypes[0].Descriptor()
}

func (DigitallySigned_HashAlgorithm) Type() protoreflect.EnumType {
	return &file_crypto_sigpb_sigpb_proto_enumTypes[0]
}

func (x DigitallySigned_HashAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DigitallySigned_HashAlgorithm.Descriptor instead.
func (DigitallySigned_HashAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_crypto_sigpb_sigpb_proto_rawDescGZIP(), []int{0, 0}
}

// SignatureAlgorithm defines the algorithm used to sign the object.
//
// Supported signature algorithms. The numbering space is the same as for TLS,
// given in RFC 5246 s7.4.1.4.1 and at:
// http://www.iana.org/assignments/tls-parameters/tls-parameters.xhtml#tls-parameters-16
type DigitallySigned_SignatureAlgorithm int32

const (
	// Anonymous signature scheme.
	DigitallySigned_ANONYMOUS DigitallySigned_SignatureAlgorithm = 0
	// RSA signature scheme.
	DigitallySigned_RSA DigitallySigned_SignatureAlgorithm = 1
	// ECDSA signature scheme.
	DigitallySigned_ECDSA DigitallySigned_SignatureAlgorithm = 3
	// Ed25519 signature scheme.
	DigitallySigned_ED25519 DigitallySigned_SignatureAlgorithm = 7
)

// Enum value maps for DigitallySigned_SignatureAlgorithm.
var (
	DigitallySigned_SignatureAlgorithm_name = map[int32]string{
		0: "ANONYMOUS",
		1: "RSA",
		3: "ECDSA",
		7: "ED25519",
	}
	DigitallySigned_SignatureAlgorithm_value = map[string]int32{
		"ANONYMOUS": 0,
		"RSA":       1,
		"ECDSA":     3,
		"ED25519":   7,
	}
)

func (x DigitallySigned_SignatureAlgorithm) Enum() *DigitallySigned_SignatureAlgorithm {
	p := new(DigitallySigned_SignatureAlgorithm)
	*p = x
	return p
}

func (x DigitallySigned_SignatureAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (DigitallySigned_SignatureAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_crypto_sigpb_sigpb_proto_enumTypes[1].Descriptor()
}

func (DigitallySigned_SignatureAlgorithm) Type() protoreflect.EnumType {
	return &file_crypto_sigpb_sigpb_proto_enumTypes[1]
}

func (x DigitallySigned_SignatureAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use DigitallySigned_SignatureAlgorithm.Descriptor instead.
func (DigitallySigned_SignatureAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_crypto_sigpb_sigpb_proto_rawDescGZIP(), []int{0, 1}
}

// Protocol buffer encoding of the TLS DigitallySigned type, from RFC 5246 §4.7.
type DigitallySigned struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// hash_algorithm contains the hash algorithm used.
	HashAlgorithm DigitallySigned_HashAlgorithm `protobuf:"varint,1,opt,name=hash_algorithm,json=hashAlgorithm,proto3,enum=sigpb.DigitallySigned_HashAlgorithm" json:"hash_algorithm,omitempty"`
	// sig_algorithm contains the signing algorithm used.
	SignatureAlgorithm DigitallySigned_SignatureAlgorithm `protobuf:"varint,2,opt,name=signature_algorithm,json=signatureAlgorithm,proto3,enum=sigpb.DigitallySigned_SignatureAlgorithm" json:"signature_algorithm,omitempty"`
	// signature contains the object signature.
	Signature []byte `protobuf:"bytes,3,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (x *DigitallySigned) Reset() {
	*x = DigitallySigned{}
	if protoimpl.UnsafeEnabled {
		mi := &file_crypto_sigpb_sigpb_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DigitallySigned) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DigitallySigned) ProtoMessage() {}

func (x *DigitallySigned) ProtoReflect() protoreflect.Message {
	mi := &file_crypto_sigpb_sigpb_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DigitallySigned.ProtoReflect.Descriptor instead.
func (*DigitallySigned) Descriptor() ([]byte, []int) {
	return file_crypto_sigpb_sigpb_proto_rawDescGZIP(), []int{0}
}

func (x *DigitallySigned) GetHashAlgorithm() DigitallySigned_HashAlgorithm {
	if x != nil {
		return x.HashAlgorithm
	}
	return DigitallySigned_NONE
}

func (x *DigitallySigned) GetSignatureAlgorithm() DigitallySigned_SignatureAlgorithm {
	if x != nil {
		return x.SignatureAlgorithm
	}
	return DigitallySigned_ANONYMOUS
}

func (x *DigitallySigned) GetSignature() []byte {
	if x != nil {
		return x.Signature
	}
	return nil
}

var File_crypto_sigpb_sigpb_proto protoreflect.FileDescriptor

var file_crypto_sigpb_sigpb_proto_rawDesc = []byte{
	0x0a, 0x18, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2f, 0x73, 0x69, 0x67, 0x70, 0x62, 0x2f, 0x73,
	0x69, 0x67, 0x70, 0x62, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x05, 0x73, 0x69, 0x67, 0x70,
	0x62, 0x22, 0xc5, 0x02, 0x0a, 0x0f, 0x44, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x6c, 0x79, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x12, 0x4b, 0x0a, 0x0e, 0x68, 0x61, 0x73, 0x68, 0x5f, 0x61, 0x6c,
	0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e,
	0x73, 0x69, 0x67, 0x70, 0x62, 0x2e, 0x44, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x6c, 0x79, 0x53,
	0x69, 0x67, 0x6e, 0x65, 0x64, 0x2e, 0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x52, 0x0d, 0x68, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74,
	0x68, 0x6d, 0x12, 0x5a, 0x0a, 0x13, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x5f,
	0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x29, 0x2e, 0x73, 0x69, 0x67, 0x70, 0x62, 0x2e, 0x44, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x6c,
	0x79, 0x53, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x2e, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72,
	0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x12, 0x73, 0x69, 0x67, 0x6e,
	0x61, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1c,
	0x0a, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0c, 0x52, 0x09, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x22, 0x25, 0x0a, 0x0d,
	0x48, 0x61, 0x73, 0x68, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x08, 0x0a,
	0x04, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x00, 0x12, 0x0a, 0x0a, 0x06, 0x53, 0x48, 0x41, 0x32, 0x35,
	0x36, 0x10, 0x04, 0x22, 0x44, 0x0a, 0x12, 0x53, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x0d, 0x0a, 0x09, 0x41, 0x4e, 0x4f,
	0x4e, 0x59, 0x4d, 0x4f, 0x55, 0x53, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x52, 0x53, 0x41, 0x10,
	0x01, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x43, 0x44, 0x53, 0x41, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07,
	0x45, 0x44, 0x32, 0x35, 0x35, 0x31, 0x39, 0x10, 0x07, 0x42, 0x29, 0x5a, 0x27, 0x67, 0x69, 0x74,
	0x68, 0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74,
	0x72, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x2f, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2f, 0x73,
	0x69, 0x67, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_crypto_sigpb_sigpb_proto_rawDescOnce sync.Once
	file_crypto_sigpb_sigpb_proto_rawDescData = file_crypto_sigpb_sigpb_proto_rawDesc
)

func file_crypto_sigpb_sigpb_proto_rawDescGZIP() []byte {
	file_crypto_sigpb_sigpb_proto_rawDescOnce.Do(func() {
		file_crypto_sigpb_sigpb_proto_rawDescData = protoimpl.X.CompressGZIP(file_crypto_sigpb_sigpb_proto_rawDescData)
	})
	return file_crypto_sigpb_sigpb_proto_rawDescData
}

var file_crypto_sigpb_sigpb_proto_enumTypes = make([]protoimpl.EnumInfo, 2)
var file_crypto_sigpb_sigpb_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_crypto_sigpb_sigpb_proto_goTypes = []interface{}{
	(DigitallySigned_HashAlgorithm)(0),      // 0: sigpb.DigitallySigned.HashAlgorithm
	(DigitallySigned_SignatureAlgorithm)(0), // 1: sigpb.DigitallySigned.SignatureAlgorithm
	(*DigitallySigned)(nil),                 // 2: sigpb.DigitallySigned
}
var file_crypto_sigpb_sigpb_proto_depIdxs = []int32{
	0, // 0: sigpb.DigitallySigned.hash_algorithm:type_name -> sigpb.DigitallySigned.HashAlgorithm
	1, // 1: sigpb.DigitallySigned.signature_algorithm:type_name -> sigpb.DigitallySigned.SignatureAlgorithm
	2, // [2:2] is the sub-list for method output_type
	2, // [2:2] is the sub-list for method input_type
	2, // [2:2] is the sub-list for extension type_name
	2, // [2:2] is the sub-list for extension extendee
	0, // [0:2] is the sub-list for field type_name
}

func init() { file_crypto_sigpb_sigpb_proto_init() }
func file_crypto_sigpb_sigpb_proto_init() {
	if File_crypto_sigpb_sigpb_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_crypto_sigpb_sigpb_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DigitallySigned); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_crypto_sigpb_sigpb_proto_rawDesc,
			NumEnums:      2,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_crypto_sigpb_sigpb_proto_goTypes,
		DependencyIndexes: file_crypto_sigpb_sigpb_proto_depIdxs,
		EnumInfos:         file_crypto_sigpb_sigpb_proto_enumTypes,
		MessageInfos:      file_crypto_sigpb_sigpb_proto_msgTypes,
	}.Build()
	File_crypto_sigpb_sigpb_proto = out.File
	file_crypto_sigpb_sigpb_proto_rawDesc = nil
	file_crypto_sigpb_sigpb_proto_goTypes = nil
	file_crypto_sigpb_sigpb_proto_depIdxs = nil
}
