// Code generated by go-swagger; DO NOT EDIT.

package query_history

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UnstarQueryReader is a Reader for the UnstarQuery structure.
type UnstarQueryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UnstarQueryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUnstarQueryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUnstarQueryUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUnstarQueryInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /query-history/star/{query_history_uid}] unstarQuery", response, response.Code())
	}
}

// NewUnstarQueryOK creates a UnstarQueryOK with default headers values
func NewUnstarQueryOK() *UnstarQueryOK {
	return &UnstarQueryOK{}
}

/*
UnstarQueryOK describes a response with status code 200, with default header values.

(empty)
*/
type UnstarQueryOK struct {
	Payload *models.QueryHistoryResponse
}

// IsSuccess returns true when this unstar query Ok response has a 2xx status code
func (o *UnstarQueryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this unstar query Ok response has a 3xx status code
func (o *UnstarQueryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar query Ok response has a 4xx status code
func (o *UnstarQueryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this unstar query Ok response has a 5xx status code
func (o *UnstarQueryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar query Ok response a status code equal to that given
func (o *UnstarQueryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the unstar query Ok response
func (o *UnstarQueryOK) Code() int {
	return 200
}

func (o *UnstarQueryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryOk %s", 200, payload)
}

func (o *UnstarQueryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryOk %s", 200, payload)
}

func (o *UnstarQueryOK) GetPayload() *models.QueryHistoryResponse {
	return o.Payload
}

func (o *UnstarQueryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.QueryHistoryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarQueryUnauthorized creates a UnstarQueryUnauthorized with default headers values
func NewUnstarQueryUnauthorized() *UnstarQueryUnauthorized {
	return &UnstarQueryUnauthorized{}
}

/*
UnstarQueryUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UnstarQueryUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar query unauthorized response has a 2xx status code
func (o *UnstarQueryUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar query unauthorized response has a 3xx status code
func (o *UnstarQueryUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar query unauthorized response has a 4xx status code
func (o *UnstarQueryUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this unstar query unauthorized response has a 5xx status code
func (o *UnstarQueryUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this unstar query unauthorized response a status code equal to that given
func (o *UnstarQueryUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the unstar query unauthorized response
func (o *UnstarQueryUnauthorized) Code() int {
	return 401
}

func (o *UnstarQueryUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryUnauthorized %s", 401, payload)
}

func (o *UnstarQueryUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryUnauthorized %s", 401, payload)
}

func (o *UnstarQueryUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarQueryUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUnstarQueryInternalServerError creates a UnstarQueryInternalServerError with default headers values
func NewUnstarQueryInternalServerError() *UnstarQueryInternalServerError {
	return &UnstarQueryInternalServerError{}
}

/*
UnstarQueryInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UnstarQueryInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this unstar query internal server error response has a 2xx status code
func (o *UnstarQueryInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this unstar query internal server error response has a 3xx status code
func (o *UnstarQueryInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this unstar query internal server error response has a 4xx status code
func (o *UnstarQueryInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this unstar query internal server error response has a 5xx status code
func (o *UnstarQueryInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this unstar query internal server error response a status code equal to that given
func (o *UnstarQueryInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the unstar query internal server error response
func (o *UnstarQueryInternalServerError) Code() int {
	return 500
}

func (o *UnstarQueryInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryInternalServerError %s", 500, payload)
}

func (o *UnstarQueryInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /query-history/star/{query_history_uid}][%d] unstarQueryInternalServerError %s", 500, payload)
}

func (o *UnstarQueryInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UnstarQueryInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
