// Code generated by go-swagger; DO NOT EDIT.

package sso_settings

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdateProviderSettingsReader is a Reader for the UpdateProviderSettings structure.
type UpdateProviderSettingsReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateProviderSettingsReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewUpdateProviderSettingsNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewUpdateProviderSettingsBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewUpdateProviderSettingsUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdateProviderSettingsForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdateProviderSettingsInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /v1/sso-settings/{key}] updateProviderSettings", response, response.Code())
	}
}

// NewUpdateProviderSettingsNoContent creates a UpdateProviderSettingsNoContent with default headers values
func NewUpdateProviderSettingsNoContent() *UpdateProviderSettingsNoContent {
	return &UpdateProviderSettingsNoContent{}
}

/*
UpdateProviderSettingsNoContent describes a response with status code 204, with default header values.

An OKResponse is returned if the request was successful.
*/
type UpdateProviderSettingsNoContent struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this update provider settings no content response has a 2xx status code
func (o *UpdateProviderSettingsNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update provider settings no content response has a 3xx status code
func (o *UpdateProviderSettingsNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider settings no content response has a 4xx status code
func (o *UpdateProviderSettingsNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this update provider settings no content response has a 5xx status code
func (o *UpdateProviderSettingsNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this update provider settings no content response a status code equal to that given
func (o *UpdateProviderSettingsNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the update provider settings no content response
func (o *UpdateProviderSettingsNoContent) Code() int {
	return 204
}

func (o *UpdateProviderSettingsNoContent) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsNoContent %s", 204, payload)
}

func (o *UpdateProviderSettingsNoContent) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsNoContent %s", 204, payload)
}

func (o *UpdateProviderSettingsNoContent) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *UpdateProviderSettingsNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateProviderSettingsBadRequest creates a UpdateProviderSettingsBadRequest with default headers values
func NewUpdateProviderSettingsBadRequest() *UpdateProviderSettingsBadRequest {
	return &UpdateProviderSettingsBadRequest{}
}

/*
UpdateProviderSettingsBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type UpdateProviderSettingsBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update provider settings bad request response has a 2xx status code
func (o *UpdateProviderSettingsBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update provider settings bad request response has a 3xx status code
func (o *UpdateProviderSettingsBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider settings bad request response has a 4xx status code
func (o *UpdateProviderSettingsBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this update provider settings bad request response has a 5xx status code
func (o *UpdateProviderSettingsBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this update provider settings bad request response a status code equal to that given
func (o *UpdateProviderSettingsBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the update provider settings bad request response
func (o *UpdateProviderSettingsBadRequest) Code() int {
	return 400
}

func (o *UpdateProviderSettingsBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsBadRequest %s", 400, payload)
}

func (o *UpdateProviderSettingsBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsBadRequest %s", 400, payload)
}

func (o *UpdateProviderSettingsBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateProviderSettingsBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateProviderSettingsUnauthorized creates a UpdateProviderSettingsUnauthorized with default headers values
func NewUpdateProviderSettingsUnauthorized() *UpdateProviderSettingsUnauthorized {
	return &UpdateProviderSettingsUnauthorized{}
}

/*
UpdateProviderSettingsUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdateProviderSettingsUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update provider settings unauthorized response has a 2xx status code
func (o *UpdateProviderSettingsUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update provider settings unauthorized response has a 3xx status code
func (o *UpdateProviderSettingsUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider settings unauthorized response has a 4xx status code
func (o *UpdateProviderSettingsUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update provider settings unauthorized response has a 5xx status code
func (o *UpdateProviderSettingsUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update provider settings unauthorized response a status code equal to that given
func (o *UpdateProviderSettingsUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update provider settings unauthorized response
func (o *UpdateProviderSettingsUnauthorized) Code() int {
	return 401
}

func (o *UpdateProviderSettingsUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsUnauthorized %s", 401, payload)
}

func (o *UpdateProviderSettingsUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsUnauthorized %s", 401, payload)
}

func (o *UpdateProviderSettingsUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateProviderSettingsUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateProviderSettingsForbidden creates a UpdateProviderSettingsForbidden with default headers values
func NewUpdateProviderSettingsForbidden() *UpdateProviderSettingsForbidden {
	return &UpdateProviderSettingsForbidden{}
}

/*
UpdateProviderSettingsForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdateProviderSettingsForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update provider settings forbidden response has a 2xx status code
func (o *UpdateProviderSettingsForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update provider settings forbidden response has a 3xx status code
func (o *UpdateProviderSettingsForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider settings forbidden response has a 4xx status code
func (o *UpdateProviderSettingsForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update provider settings forbidden response has a 5xx status code
func (o *UpdateProviderSettingsForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update provider settings forbidden response a status code equal to that given
func (o *UpdateProviderSettingsForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update provider settings forbidden response
func (o *UpdateProviderSettingsForbidden) Code() int {
	return 403
}

func (o *UpdateProviderSettingsForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsForbidden %s", 403, payload)
}

func (o *UpdateProviderSettingsForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsForbidden %s", 403, payload)
}

func (o *UpdateProviderSettingsForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateProviderSettingsForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateProviderSettingsInternalServerError creates a UpdateProviderSettingsInternalServerError with default headers values
func NewUpdateProviderSettingsInternalServerError() *UpdateProviderSettingsInternalServerError {
	return &UpdateProviderSettingsInternalServerError{}
}

/*
UpdateProviderSettingsInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdateProviderSettingsInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update provider settings internal server error response has a 2xx status code
func (o *UpdateProviderSettingsInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update provider settings internal server error response has a 3xx status code
func (o *UpdateProviderSettingsInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update provider settings internal server error response has a 4xx status code
func (o *UpdateProviderSettingsInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update provider settings internal server error response has a 5xx status code
func (o *UpdateProviderSettingsInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update provider settings internal server error response a status code equal to that given
func (o *UpdateProviderSettingsInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update provider settings internal server error response
func (o *UpdateProviderSettingsInternalServerError) Code() int {
	return 500
}

func (o *UpdateProviderSettingsInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsInternalServerError %s", 500, payload)
}

func (o *UpdateProviderSettingsInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/sso-settings/{key}][%d] updateProviderSettingsInternalServerError %s", 500, payload)
}

func (o *UpdateProviderSettingsInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdateProviderSettingsInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
