// Code generated by go-swagger; DO NOT EDIT.

package group_attribute_sync

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// DeleteGroupMappingReader is a Reader for the DeleteGroupMapping structure.
type DeleteGroupMappingReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *DeleteGroupMappingReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 204:
		result := NewDeleteGroupMappingNoContent()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewDeleteGroupMappingBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewDeleteGroupMappingUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewDeleteGroupMappingForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewDeleteGroupMappingNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewDeleteGroupMappingInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[DELETE /groupsync/mappings/{mapping_uid}] deleteGroupMapping", response, response.Code())
	}
}

// NewDeleteGroupMappingNoContent creates a DeleteGroupMappingNoContent with default headers values
func NewDeleteGroupMappingNoContent() *DeleteGroupMappingNoContent {
	return &DeleteGroupMappingNoContent{}
}

/*
DeleteGroupMappingNoContent describes a response with status code 204, with default header values.

An OKResponse is returned if the request was successful.
*/
type DeleteGroupMappingNoContent struct {
	Payload *models.SuccessResponseBody
}

// IsSuccess returns true when this delete group mapping no content response has a 2xx status code
func (o *DeleteGroupMappingNoContent) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this delete group mapping no content response has a 3xx status code
func (o *DeleteGroupMappingNoContent) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping no content response has a 4xx status code
func (o *DeleteGroupMappingNoContent) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete group mapping no content response has a 5xx status code
func (o *DeleteGroupMappingNoContent) IsServerError() bool {
	return false
}

// IsCode returns true when this delete group mapping no content response a status code equal to that given
func (o *DeleteGroupMappingNoContent) IsCode(code int) bool {
	return code == 204
}

// Code gets the status code for the delete group mapping no content response
func (o *DeleteGroupMappingNoContent) Code() int {
	return 204
}

func (o *DeleteGroupMappingNoContent) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingNoContent %s", 204, payload)
}

func (o *DeleteGroupMappingNoContent) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingNoContent %s", 204, payload)
}

func (o *DeleteGroupMappingNoContent) GetPayload() *models.SuccessResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingNoContent) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SuccessResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteGroupMappingBadRequest creates a DeleteGroupMappingBadRequest with default headers values
func NewDeleteGroupMappingBadRequest() *DeleteGroupMappingBadRequest {
	return &DeleteGroupMappingBadRequest{}
}

/*
DeleteGroupMappingBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type DeleteGroupMappingBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete group mapping bad request response has a 2xx status code
func (o *DeleteGroupMappingBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete group mapping bad request response has a 3xx status code
func (o *DeleteGroupMappingBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping bad request response has a 4xx status code
func (o *DeleteGroupMappingBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete group mapping bad request response has a 5xx status code
func (o *DeleteGroupMappingBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this delete group mapping bad request response a status code equal to that given
func (o *DeleteGroupMappingBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the delete group mapping bad request response
func (o *DeleteGroupMappingBadRequest) Code() int {
	return 400
}

func (o *DeleteGroupMappingBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingBadRequest %s", 400, payload)
}

func (o *DeleteGroupMappingBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingBadRequest %s", 400, payload)
}

func (o *DeleteGroupMappingBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteGroupMappingUnauthorized creates a DeleteGroupMappingUnauthorized with default headers values
func NewDeleteGroupMappingUnauthorized() *DeleteGroupMappingUnauthorized {
	return &DeleteGroupMappingUnauthorized{}
}

/*
DeleteGroupMappingUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type DeleteGroupMappingUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete group mapping unauthorized response has a 2xx status code
func (o *DeleteGroupMappingUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete group mapping unauthorized response has a 3xx status code
func (o *DeleteGroupMappingUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping unauthorized response has a 4xx status code
func (o *DeleteGroupMappingUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete group mapping unauthorized response has a 5xx status code
func (o *DeleteGroupMappingUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this delete group mapping unauthorized response a status code equal to that given
func (o *DeleteGroupMappingUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the delete group mapping unauthorized response
func (o *DeleteGroupMappingUnauthorized) Code() int {
	return 401
}

func (o *DeleteGroupMappingUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingUnauthorized %s", 401, payload)
}

func (o *DeleteGroupMappingUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingUnauthorized %s", 401, payload)
}

func (o *DeleteGroupMappingUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteGroupMappingForbidden creates a DeleteGroupMappingForbidden with default headers values
func NewDeleteGroupMappingForbidden() *DeleteGroupMappingForbidden {
	return &DeleteGroupMappingForbidden{}
}

/*
DeleteGroupMappingForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type DeleteGroupMappingForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete group mapping forbidden response has a 2xx status code
func (o *DeleteGroupMappingForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete group mapping forbidden response has a 3xx status code
func (o *DeleteGroupMappingForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping forbidden response has a 4xx status code
func (o *DeleteGroupMappingForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete group mapping forbidden response has a 5xx status code
func (o *DeleteGroupMappingForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this delete group mapping forbidden response a status code equal to that given
func (o *DeleteGroupMappingForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the delete group mapping forbidden response
func (o *DeleteGroupMappingForbidden) Code() int {
	return 403
}

func (o *DeleteGroupMappingForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingForbidden %s", 403, payload)
}

func (o *DeleteGroupMappingForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingForbidden %s", 403, payload)
}

func (o *DeleteGroupMappingForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteGroupMappingNotFound creates a DeleteGroupMappingNotFound with default headers values
func NewDeleteGroupMappingNotFound() *DeleteGroupMappingNotFound {
	return &DeleteGroupMappingNotFound{}
}

/*
DeleteGroupMappingNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type DeleteGroupMappingNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete group mapping not found response has a 2xx status code
func (o *DeleteGroupMappingNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete group mapping not found response has a 3xx status code
func (o *DeleteGroupMappingNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping not found response has a 4xx status code
func (o *DeleteGroupMappingNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this delete group mapping not found response has a 5xx status code
func (o *DeleteGroupMappingNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this delete group mapping not found response a status code equal to that given
func (o *DeleteGroupMappingNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the delete group mapping not found response
func (o *DeleteGroupMappingNotFound) Code() int {
	return 404
}

func (o *DeleteGroupMappingNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingNotFound %s", 404, payload)
}

func (o *DeleteGroupMappingNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingNotFound %s", 404, payload)
}

func (o *DeleteGroupMappingNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewDeleteGroupMappingInternalServerError creates a DeleteGroupMappingInternalServerError with default headers values
func NewDeleteGroupMappingInternalServerError() *DeleteGroupMappingInternalServerError {
	return &DeleteGroupMappingInternalServerError{}
}

/*
DeleteGroupMappingInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type DeleteGroupMappingInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this delete group mapping internal server error response has a 2xx status code
func (o *DeleteGroupMappingInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this delete group mapping internal server error response has a 3xx status code
func (o *DeleteGroupMappingInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this delete group mapping internal server error response has a 4xx status code
func (o *DeleteGroupMappingInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this delete group mapping internal server error response has a 5xx status code
func (o *DeleteGroupMappingInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this delete group mapping internal server error response a status code equal to that given
func (o *DeleteGroupMappingInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the delete group mapping internal server error response
func (o *DeleteGroupMappingInternalServerError) Code() int {
	return 500
}

func (o *DeleteGroupMappingInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingInternalServerError %s", 500, payload)
}

func (o *DeleteGroupMappingInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /groupsync/mappings/{mapping_uid}][%d] deleteGroupMappingInternalServerError %s", 500, payload)
}

func (o *DeleteGroupMappingInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *DeleteGroupMappingInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
