// Code generated by go-swagger; DO NOT EDIT.

package orgs

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// CreateOrgReader is a Reader for the CreateOrg structure.
type CreateOrgReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateOrgReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateOrgOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewCreateOrgUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewCreateOrgForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 409:
		result := NewCreateOrgConflict()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewCreateOrgInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[POST /orgs] createOrg", response, response.Code())
	}
}

// NewCreateOrgOK creates a CreateOrgOK with default headers values
func NewCreateOrgOK() *CreateOrgOK {
	return &CreateOrgOK{}
}

/*
CreateOrgOK describes a response with status code 200, with default header values.

(empty)
*/
type CreateOrgOK struct {
	Payload *models.CreateOrgOKBody
}

// IsSuccess returns true when this create org Ok response has a 2xx status code
func (o *CreateOrgOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create org Ok response has a 3xx status code
func (o *CreateOrgOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create org Ok response has a 4xx status code
func (o *CreateOrgOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create org Ok response has a 5xx status code
func (o *CreateOrgOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create org Ok response a status code equal to that given
func (o *CreateOrgOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create org Ok response
func (o *CreateOrgOK) Code() int {
	return 200
}

func (o *CreateOrgOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgOk %s", 200, payload)
}

func (o *CreateOrgOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgOk %s", 200, payload)
}

func (o *CreateOrgOK) GetPayload() *models.CreateOrgOKBody {
	return o.Payload
}

func (o *CreateOrgOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CreateOrgOKBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrgUnauthorized creates a CreateOrgUnauthorized with default headers values
func NewCreateOrgUnauthorized() *CreateOrgUnauthorized {
	return &CreateOrgUnauthorized{}
}

/*
CreateOrgUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type CreateOrgUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create org unauthorized response has a 2xx status code
func (o *CreateOrgUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create org unauthorized response has a 3xx status code
func (o *CreateOrgUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create org unauthorized response has a 4xx status code
func (o *CreateOrgUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this create org unauthorized response has a 5xx status code
func (o *CreateOrgUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this create org unauthorized response a status code equal to that given
func (o *CreateOrgUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the create org unauthorized response
func (o *CreateOrgUnauthorized) Code() int {
	return 401
}

func (o *CreateOrgUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgUnauthorized %s", 401, payload)
}

func (o *CreateOrgUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgUnauthorized %s", 401, payload)
}

func (o *CreateOrgUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateOrgUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrgForbidden creates a CreateOrgForbidden with default headers values
func NewCreateOrgForbidden() *CreateOrgForbidden {
	return &CreateOrgForbidden{}
}

/*
CreateOrgForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type CreateOrgForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create org forbidden response has a 2xx status code
func (o *CreateOrgForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create org forbidden response has a 3xx status code
func (o *CreateOrgForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create org forbidden response has a 4xx status code
func (o *CreateOrgForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this create org forbidden response has a 5xx status code
func (o *CreateOrgForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this create org forbidden response a status code equal to that given
func (o *CreateOrgForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the create org forbidden response
func (o *CreateOrgForbidden) Code() int {
	return 403
}

func (o *CreateOrgForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgForbidden %s", 403, payload)
}

func (o *CreateOrgForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgForbidden %s", 403, payload)
}

func (o *CreateOrgForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateOrgForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrgConflict creates a CreateOrgConflict with default headers values
func NewCreateOrgConflict() *CreateOrgConflict {
	return &CreateOrgConflict{}
}

/*
CreateOrgConflict describes a response with status code 409, with default header values.

ConflictError
*/
type CreateOrgConflict struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create org conflict response has a 2xx status code
func (o *CreateOrgConflict) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create org conflict response has a 3xx status code
func (o *CreateOrgConflict) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create org conflict response has a 4xx status code
func (o *CreateOrgConflict) IsClientError() bool {
	return true
}

// IsServerError returns true when this create org conflict response has a 5xx status code
func (o *CreateOrgConflict) IsServerError() bool {
	return false
}

// IsCode returns true when this create org conflict response a status code equal to that given
func (o *CreateOrgConflict) IsCode(code int) bool {
	return code == 409
}

// Code gets the status code for the create org conflict response
func (o *CreateOrgConflict) Code() int {
	return 409
}

func (o *CreateOrgConflict) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgConflict %s", 409, payload)
}

func (o *CreateOrgConflict) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgConflict %s", 409, payload)
}

func (o *CreateOrgConflict) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateOrgConflict) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateOrgInternalServerError creates a CreateOrgInternalServerError with default headers values
func NewCreateOrgInternalServerError() *CreateOrgInternalServerError {
	return &CreateOrgInternalServerError{}
}

/*
CreateOrgInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type CreateOrgInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this create org internal server error response has a 2xx status code
func (o *CreateOrgInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this create org internal server error response has a 3xx status code
func (o *CreateOrgInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create org internal server error response has a 4xx status code
func (o *CreateOrgInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this create org internal server error response has a 5xx status code
func (o *CreateOrgInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this create org internal server error response a status code equal to that given
func (o *CreateOrgInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the create org internal server error response
func (o *CreateOrgInternalServerError) Code() int {
	return 500
}

func (o *CreateOrgInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgInternalServerError %s", 500, payload)
}

func (o *CreateOrgInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /orgs][%d] createOrgInternalServerError %s", 500, payload)
}

func (o *CreateOrgInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *CreateOrgInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
