// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// PutContactpointReader is a Reader for the PutContactpoint structure.
type PutContactpointReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PutContactpointReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 202:
		result := NewPutContactpointAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewPutContactpointBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /v1/provisioning/contact-points/{UID}] PutContactpoint", response, response.Code())
	}
}

// NewPutContactpointAccepted creates a PutContactpointAccepted with default headers values
func NewPutContactpointAccepted() *PutContactpointAccepted {
	return &PutContactpointAccepted{}
}

/*
PutContactpointAccepted describes a response with status code 202, with default header values.

Ack
*/
type PutContactpointAccepted struct {
	Payload models.Ack
}

// IsSuccess returns true when this put contactpoint accepted response has a 2xx status code
func (o *PutContactpointAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this put contactpoint accepted response has a 3xx status code
func (o *PutContactpointAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put contactpoint accepted response has a 4xx status code
func (o *PutContactpointAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this put contactpoint accepted response has a 5xx status code
func (o *PutContactpointAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this put contactpoint accepted response a status code equal to that given
func (o *PutContactpointAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the put contactpoint accepted response
func (o *PutContactpointAccepted) Code() int {
	return 202
}

func (o *PutContactpointAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/contact-points/{UID}][%d] putContactpointAccepted %s", 202, payload)
}

func (o *PutContactpointAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/contact-points/{UID}][%d] putContactpointAccepted %s", 202, payload)
}

func (o *PutContactpointAccepted) GetPayload() models.Ack {
	return o.Payload
}

func (o *PutContactpointAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPutContactpointBadRequest creates a PutContactpointBadRequest with default headers values
func NewPutContactpointBadRequest() *PutContactpointBadRequest {
	return &PutContactpointBadRequest{}
}

/*
PutContactpointBadRequest describes a response with status code 400, with default header values.

ValidationError
*/
type PutContactpointBadRequest struct {
	Payload *models.ValidationError
}

// IsSuccess returns true when this put contactpoint bad request response has a 2xx status code
func (o *PutContactpointBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this put contactpoint bad request response has a 3xx status code
func (o *PutContactpointBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this put contactpoint bad request response has a 4xx status code
func (o *PutContactpointBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this put contactpoint bad request response has a 5xx status code
func (o *PutContactpointBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this put contactpoint bad request response a status code equal to that given
func (o *PutContactpointBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the put contactpoint bad request response
func (o *PutContactpointBadRequest) Code() int {
	return 400
}

func (o *PutContactpointBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/contact-points/{UID}][%d] putContactpointBadRequest %s", 400, payload)
}

func (o *PutContactpointBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /v1/provisioning/contact-points/{UID}][%d] putContactpointBadRequest %s", 400, payload)
}

func (o *PutContactpointBadRequest) GetPayload() *models.ValidationError {
	return o.Payload
}

func (o *PutContactpointBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ValidationError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
