// Code generated by go-swagger; DO NOT EDIT.

package migrations

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// GetSessionReader is a Reader for the GetSession structure.
type GetSessionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetSessionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetSessionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 400:
		result := NewGetSessionBadRequest()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 401:
		result := NewGetSessionUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewGetSessionForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewGetSessionInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[GET /cloudmigration/migration/{uid}] getSession", response, response.Code())
	}
}

// NewGetSessionOK creates a GetSessionOK with default headers values
func NewGetSessionOK() *GetSessionOK {
	return &GetSessionOK{}
}

/*
GetSessionOK describes a response with status code 200, with default header values.

(empty)
*/
type GetSessionOK struct {
	Payload *models.CloudMigrationSessionResponseDTO
}

// IsSuccess returns true when this get session Ok response has a 2xx status code
func (o *GetSessionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get session Ok response has a 3xx status code
func (o *GetSessionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get session Ok response has a 4xx status code
func (o *GetSessionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get session Ok response has a 5xx status code
func (o *GetSessionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get session Ok response a status code equal to that given
func (o *GetSessionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get session Ok response
func (o *GetSessionOK) Code() int {
	return 200
}

func (o *GetSessionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionOk %s", 200, payload)
}

func (o *GetSessionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionOk %s", 200, payload)
}

func (o *GetSessionOK) GetPayload() *models.CloudMigrationSessionResponseDTO {
	return o.Payload
}

func (o *GetSessionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.CloudMigrationSessionResponseDTO)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSessionBadRequest creates a GetSessionBadRequest with default headers values
func NewGetSessionBadRequest() *GetSessionBadRequest {
	return &GetSessionBadRequest{}
}

/*
GetSessionBadRequest describes a response with status code 400, with default header values.

BadRequestError is returned when the request is invalid and it cannot be processed.
*/
type GetSessionBadRequest struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get session bad request response has a 2xx status code
func (o *GetSessionBadRequest) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get session bad request response has a 3xx status code
func (o *GetSessionBadRequest) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get session bad request response has a 4xx status code
func (o *GetSessionBadRequest) IsClientError() bool {
	return true
}

// IsServerError returns true when this get session bad request response has a 5xx status code
func (o *GetSessionBadRequest) IsServerError() bool {
	return false
}

// IsCode returns true when this get session bad request response a status code equal to that given
func (o *GetSessionBadRequest) IsCode(code int) bool {
	return code == 400
}

// Code gets the status code for the get session bad request response
func (o *GetSessionBadRequest) Code() int {
	return 400
}

func (o *GetSessionBadRequest) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionBadRequest %s", 400, payload)
}

func (o *GetSessionBadRequest) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionBadRequest %s", 400, payload)
}

func (o *GetSessionBadRequest) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSessionBadRequest) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSessionUnauthorized creates a GetSessionUnauthorized with default headers values
func NewGetSessionUnauthorized() *GetSessionUnauthorized {
	return &GetSessionUnauthorized{}
}

/*
GetSessionUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type GetSessionUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get session unauthorized response has a 2xx status code
func (o *GetSessionUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get session unauthorized response has a 3xx status code
func (o *GetSessionUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get session unauthorized response has a 4xx status code
func (o *GetSessionUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this get session unauthorized response has a 5xx status code
func (o *GetSessionUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this get session unauthorized response a status code equal to that given
func (o *GetSessionUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the get session unauthorized response
func (o *GetSessionUnauthorized) Code() int {
	return 401
}

func (o *GetSessionUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionUnauthorized %s", 401, payload)
}

func (o *GetSessionUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionUnauthorized %s", 401, payload)
}

func (o *GetSessionUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSessionUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSessionForbidden creates a GetSessionForbidden with default headers values
func NewGetSessionForbidden() *GetSessionForbidden {
	return &GetSessionForbidden{}
}

/*
GetSessionForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type GetSessionForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get session forbidden response has a 2xx status code
func (o *GetSessionForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get session forbidden response has a 3xx status code
func (o *GetSessionForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get session forbidden response has a 4xx status code
func (o *GetSessionForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this get session forbidden response has a 5xx status code
func (o *GetSessionForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this get session forbidden response a status code equal to that given
func (o *GetSessionForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the get session forbidden response
func (o *GetSessionForbidden) Code() int {
	return 403
}

func (o *GetSessionForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionForbidden %s", 403, payload)
}

func (o *GetSessionForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionForbidden %s", 403, payload)
}

func (o *GetSessionForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSessionForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetSessionInternalServerError creates a GetSessionInternalServerError with default headers values
func NewGetSessionInternalServerError() *GetSessionInternalServerError {
	return &GetSessionInternalServerError{}
}

/*
GetSessionInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type GetSessionInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this get session internal server error response has a 2xx status code
func (o *GetSessionInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this get session internal server error response has a 3xx status code
func (o *GetSessionInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get session internal server error response has a 4xx status code
func (o *GetSessionInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this get session internal server error response has a 5xx status code
func (o *GetSessionInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this get session internal server error response a status code equal to that given
func (o *GetSessionInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the get session internal server error response
func (o *GetSessionInternalServerError) Code() int {
	return 500
}

func (o *GetSessionInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionInternalServerError %s", 500, payload)
}

func (o *GetSessionInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /cloudmigration/migration/{uid}][%d] getSessionInternalServerError %s", 500, payload)
}

func (o *GetSessionInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *GetSessionInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
