// Code generated by go-swagger; DO NOT EDIT.

package playlists

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// UpdatePlaylistReader is a Reader for the UpdatePlaylist structure.
type UpdatePlaylistReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdatePlaylistReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdatePlaylistOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 401:
		result := NewUpdatePlaylistUnauthorized()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 403:
		result := NewUpdatePlaylistForbidden()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 404:
		result := NewUpdatePlaylistNotFound()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	case 500:
		result := NewUpdatePlaylistInternalServerError()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return nil, result
	default:
		return nil, runtime.NewAPIError("[PUT /playlists/{uid}] updatePlaylist", response, response.Code())
	}
}

// NewUpdatePlaylistOK creates a UpdatePlaylistOK with default headers values
func NewUpdatePlaylistOK() *UpdatePlaylistOK {
	return &UpdatePlaylistOK{}
}

/*
UpdatePlaylistOK describes a response with status code 200, with default header values.

(empty)
*/
type UpdatePlaylistOK struct {
	Payload *models.Playlist
}

// IsSuccess returns true when this update playlist Ok response has a 2xx status code
func (o *UpdatePlaylistOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update playlist Ok response has a 3xx status code
func (o *UpdatePlaylistOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update playlist Ok response has a 4xx status code
func (o *UpdatePlaylistOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update playlist Ok response has a 5xx status code
func (o *UpdatePlaylistOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update playlist Ok response a status code equal to that given
func (o *UpdatePlaylistOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update playlist Ok response
func (o *UpdatePlaylistOK) Code() int {
	return 200
}

func (o *UpdatePlaylistOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistOk %s", 200, payload)
}

func (o *UpdatePlaylistOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistOk %s", 200, payload)
}

func (o *UpdatePlaylistOK) GetPayload() *models.Playlist {
	return o.Payload
}

func (o *UpdatePlaylistOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Playlist)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePlaylistUnauthorized creates a UpdatePlaylistUnauthorized with default headers values
func NewUpdatePlaylistUnauthorized() *UpdatePlaylistUnauthorized {
	return &UpdatePlaylistUnauthorized{}
}

/*
UpdatePlaylistUnauthorized describes a response with status code 401, with default header values.

UnauthorizedError is returned when the request is not authenticated.
*/
type UpdatePlaylistUnauthorized struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update playlist unauthorized response has a 2xx status code
func (o *UpdatePlaylistUnauthorized) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update playlist unauthorized response has a 3xx status code
func (o *UpdatePlaylistUnauthorized) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update playlist unauthorized response has a 4xx status code
func (o *UpdatePlaylistUnauthorized) IsClientError() bool {
	return true
}

// IsServerError returns true when this update playlist unauthorized response has a 5xx status code
func (o *UpdatePlaylistUnauthorized) IsServerError() bool {
	return false
}

// IsCode returns true when this update playlist unauthorized response a status code equal to that given
func (o *UpdatePlaylistUnauthorized) IsCode(code int) bool {
	return code == 401
}

// Code gets the status code for the update playlist unauthorized response
func (o *UpdatePlaylistUnauthorized) Code() int {
	return 401
}

func (o *UpdatePlaylistUnauthorized) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistUnauthorized %s", 401, payload)
}

func (o *UpdatePlaylistUnauthorized) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistUnauthorized %s", 401, payload)
}

func (o *UpdatePlaylistUnauthorized) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdatePlaylistUnauthorized) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePlaylistForbidden creates a UpdatePlaylistForbidden with default headers values
func NewUpdatePlaylistForbidden() *UpdatePlaylistForbidden {
	return &UpdatePlaylistForbidden{}
}

/*
UpdatePlaylistForbidden describes a response with status code 403, with default header values.

ForbiddenError is returned if the user/token has insufficient permissions to access the requested resource.
*/
type UpdatePlaylistForbidden struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update playlist forbidden response has a 2xx status code
func (o *UpdatePlaylistForbidden) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update playlist forbidden response has a 3xx status code
func (o *UpdatePlaylistForbidden) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update playlist forbidden response has a 4xx status code
func (o *UpdatePlaylistForbidden) IsClientError() bool {
	return true
}

// IsServerError returns true when this update playlist forbidden response has a 5xx status code
func (o *UpdatePlaylistForbidden) IsServerError() bool {
	return false
}

// IsCode returns true when this update playlist forbidden response a status code equal to that given
func (o *UpdatePlaylistForbidden) IsCode(code int) bool {
	return code == 403
}

// Code gets the status code for the update playlist forbidden response
func (o *UpdatePlaylistForbidden) Code() int {
	return 403
}

func (o *UpdatePlaylistForbidden) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistForbidden %s", 403, payload)
}

func (o *UpdatePlaylistForbidden) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistForbidden %s", 403, payload)
}

func (o *UpdatePlaylistForbidden) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdatePlaylistForbidden) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePlaylistNotFound creates a UpdatePlaylistNotFound with default headers values
func NewUpdatePlaylistNotFound() *UpdatePlaylistNotFound {
	return &UpdatePlaylistNotFound{}
}

/*
UpdatePlaylistNotFound describes a response with status code 404, with default header values.

NotFoundError is returned when the requested resource was not found.
*/
type UpdatePlaylistNotFound struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update playlist not found response has a 2xx status code
func (o *UpdatePlaylistNotFound) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update playlist not found response has a 3xx status code
func (o *UpdatePlaylistNotFound) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update playlist not found response has a 4xx status code
func (o *UpdatePlaylistNotFound) IsClientError() bool {
	return true
}

// IsServerError returns true when this update playlist not found response has a 5xx status code
func (o *UpdatePlaylistNotFound) IsServerError() bool {
	return false
}

// IsCode returns true when this update playlist not found response a status code equal to that given
func (o *UpdatePlaylistNotFound) IsCode(code int) bool {
	return code == 404
}

// Code gets the status code for the update playlist not found response
func (o *UpdatePlaylistNotFound) Code() int {
	return 404
}

func (o *UpdatePlaylistNotFound) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistNotFound %s", 404, payload)
}

func (o *UpdatePlaylistNotFound) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistNotFound %s", 404, payload)
}

func (o *UpdatePlaylistNotFound) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdatePlaylistNotFound) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdatePlaylistInternalServerError creates a UpdatePlaylistInternalServerError with default headers values
func NewUpdatePlaylistInternalServerError() *UpdatePlaylistInternalServerError {
	return &UpdatePlaylistInternalServerError{}
}

/*
UpdatePlaylistInternalServerError describes a response with status code 500, with default header values.

InternalServerError is a general error indicating something went wrong internally.
*/
type UpdatePlaylistInternalServerError struct {
	Payload *models.ErrorResponseBody
}

// IsSuccess returns true when this update playlist internal server error response has a 2xx status code
func (o *UpdatePlaylistInternalServerError) IsSuccess() bool {
	return false
}

// IsRedirect returns true when this update playlist internal server error response has a 3xx status code
func (o *UpdatePlaylistInternalServerError) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update playlist internal server error response has a 4xx status code
func (o *UpdatePlaylistInternalServerError) IsClientError() bool {
	return false
}

// IsServerError returns true when this update playlist internal server error response has a 5xx status code
func (o *UpdatePlaylistInternalServerError) IsServerError() bool {
	return true
}

// IsCode returns true when this update playlist internal server error response a status code equal to that given
func (o *UpdatePlaylistInternalServerError) IsCode(code int) bool {
	return code == 500
}

// Code gets the status code for the update playlist internal server error response
func (o *UpdatePlaylistInternalServerError) Code() int {
	return 500
}

func (o *UpdatePlaylistInternalServerError) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistInternalServerError %s", 500, payload)
}

func (o *UpdatePlaylistInternalServerError) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /playlists/{uid}][%d] updatePlaylistInternalServerError %s", 500, payload)
}

func (o *UpdatePlaylistInternalServerError) GetPayload() *models.ErrorResponseBody {
	return o.Payload
}

func (o *UpdatePlaylistInternalServerError) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponseBody)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
