// Code generated by go-swagger; DO NOT EDIT.

package provisioning

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/grafana/grafana-openapi-client-go/models"
)

// NewPutPolicyTreeParams creates a new PutPolicyTreeParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPutPolicyTreeParams() *PutPolicyTreeParams {
	return &PutPolicyTreeParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPutPolicyTreeParamsWithTimeout creates a new PutPolicyTreeParams object
// with the ability to set a timeout on a request.
func NewPutPolicyTreeParamsWithTimeout(timeout time.Duration) *PutPolicyTreeParams {
	return &PutPolicyTreeParams{
		timeout: timeout,
	}
}

// NewPutPolicyTreeParamsWithContext creates a new PutPolicyTreeParams object
// with the ability to set a context for a request.
func NewPutPolicyTreeParamsWithContext(ctx context.Context) *PutPolicyTreeParams {
	return &PutPolicyTreeParams{
		Context: ctx,
	}
}

// NewPutPolicyTreeParamsWithHTTPClient creates a new PutPolicyTreeParams object
// with the ability to set a custom HTTPClient for a request.
func NewPutPolicyTreeParamsWithHTTPClient(client *http.Client) *PutPolicyTreeParams {
	return &PutPolicyTreeParams{
		HTTPClient: client,
	}
}

/*
PutPolicyTreeParams contains all the parameters to send to the API endpoint

	for the put policy tree operation.

	Typically these are written to a http.Request.
*/
type PutPolicyTreeParams struct {

	/* Body.

	   The new notification routing tree to use
	*/
	Body *models.Route

	// XDisableProvenance.
	XDisableProvenance *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the put policy tree params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutPolicyTreeParams) WithDefaults() *PutPolicyTreeParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the put policy tree params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PutPolicyTreeParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the put policy tree params
func (o *PutPolicyTreeParams) WithTimeout(timeout time.Duration) *PutPolicyTreeParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the put policy tree params
func (o *PutPolicyTreeParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the put policy tree params
func (o *PutPolicyTreeParams) WithContext(ctx context.Context) *PutPolicyTreeParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the put policy tree params
func (o *PutPolicyTreeParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the put policy tree params
func (o *PutPolicyTreeParams) WithHTTPClient(client *http.Client) *PutPolicyTreeParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the put policy tree params
func (o *PutPolicyTreeParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the put policy tree params
func (o *PutPolicyTreeParams) WithBody(body *models.Route) *PutPolicyTreeParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the put policy tree params
func (o *PutPolicyTreeParams) SetBody(body *models.Route) {
	o.Body = body
}

// WithXDisableProvenance adds the xDisableProvenance to the put policy tree params
func (o *PutPolicyTreeParams) WithXDisableProvenance(xDisableProvenance *string) *PutPolicyTreeParams {
	o.SetXDisableProvenance(xDisableProvenance)
	return o
}

// SetXDisableProvenance adds the xDisableProvenance to the put policy tree params
func (o *PutPolicyTreeParams) SetXDisableProvenance(xDisableProvenance *string) {
	o.XDisableProvenance = xDisableProvenance
}

// WriteToRequest writes these params to a swagger request
func (o *PutPolicyTreeParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	if o.XDisableProvenance != nil {

		// header param X-Disable-Provenance
		if err := r.SetHeaderParam("X-Disable-Provenance", *o.XDisableProvenance); err != nil {
			return err
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
