// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// ActiveSyncStatusDTO ActiveSyncStatusDTO holds the information for LDAP background Sync
//
// swagger:model ActiveSyncStatusDTO
type ActiveSyncStatusDTO struct {

	// enabled
	Enabled bool `json:"enabled,omitempty"`

	// next sync
	// Format: date-time
	NextSync strfmt.DateTime `json:"nextSync,omitempty"`

	// prev sync
	PrevSync *SyncResult `json:"prevSync,omitempty"`

	// schedule
	Schedule string `json:"schedule,omitempty"`
}

// Validate validates this active sync status DTO
func (m *ActiveSyncStatusDTO) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateNextSync(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePrevSync(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveSyncStatusDTO) validateNextSync(formats strfmt.Registry) error {
	if swag.IsZero(m.NextSync) { // not required
		return nil
	}

	if err := validate.FormatOf("nextSync", "body", "date-time", m.NextSync.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *ActiveSyncStatusDTO) validatePrevSync(formats strfmt.Registry) error {
	if swag.IsZero(m.PrevSync) { // not required
		return nil
	}

	if m.PrevSync != nil {
		if err := m.PrevSync.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("prevSync")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("prevSync")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this active sync status DTO based on the context it is used
func (m *ActiveSyncStatusDTO) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidatePrevSync(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *ActiveSyncStatusDTO) contextValidatePrevSync(ctx context.Context, formats strfmt.Registry) error {

	if m.PrevSync != nil {

		if swag.IsZero(m.PrevSync) { // not required
			return nil
		}

		if err := m.PrevSync.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("prevSync")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("prevSync")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *ActiveSyncStatusDTO) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *ActiveSyncStatusDTO) UnmarshalBinary(b []byte) error {
	var res ActiveSyncStatusDTO
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
