// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Billing20201105BillingAccount BillingAccount is the user-facing object in HCP that defines how an
// organization will be billed for the resources used in their projects.
//
// swagger:model billing_20201105BillingAccount
type Billing20201105BillingAccount struct {

	// balance is the account's current credit balance. Credit is added to an
	// account's balance for example when it is eligible for a free trial.
	Balance string `json:"balance,omitempty"`

	// country is the billing account's country that is used both in the billing
	// address and for selecting regional prices.
	Country *Billing20201105Country `json:"country,omitempty"`

	// id is the user-settable ID for this Billing Account. It is unique within
	// the organization.
	ID string `json:"id,omitempty"`

	// name is the Billing Account's user-defined name.
	Name string `json:"name,omitempty"`

	// on_demand_status represents the status of the on-demand payment method.
	OnDemandStatus *BillingAccountOnDemandStatus `json:"on_demand_status,omitempty"`

	// organization_id is the ID of the organization to which the Billing Account
	// belongs.
	OrganizationID string `json:"organization_id,omitempty"`

	// pricing_model is the value of the current pricing model for the billing account.
	PricingModel *Billing20201105PricingModel `json:"pricing_model,omitempty"`

	// project_ids is the list of IDs of all projects associated with the Billing
	// Account. Projects can be linked to *at most* one Billing Account.
	ProjectIds []string `json:"project_ids"`

	// status of the billing account (e.g. active, canceled).
	Status *Billing20201105BillingAccountStatus `json:"status,omitempty"`
}

// Validate validates this billing 20201105 billing account
func (m *Billing20201105BillingAccount) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCountry(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnDemandStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validatePricingModel(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105BillingAccount) validateCountry(formats strfmt.Registry) error {
	if swag.IsZero(m.Country) { // not required
		return nil
	}

	if m.Country != nil {
		if err := m.Country.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("country")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("country")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) validateOnDemandStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.OnDemandStatus) { // not required
		return nil
	}

	if m.OnDemandStatus != nil {
		if err := m.OnDemandStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("on_demand_status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("on_demand_status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) validatePricingModel(formats strfmt.Registry) error {
	if swag.IsZero(m.PricingModel) { // not required
		return nil
	}

	if m.PricingModel != nil {
		if err := m.PricingModel.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pricing_model")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pricing_model")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing 20201105 billing account based on the context it is used
func (m *Billing20201105BillingAccount) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCountry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidatePricingModel(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105BillingAccount) contextValidateCountry(ctx context.Context, formats strfmt.Registry) error {

	if m.Country != nil {

		if swag.IsZero(m.Country) { // not required
			return nil
		}

		if err := m.Country.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("country")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("country")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) contextValidateOnDemandStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.OnDemandStatus != nil {

		if swag.IsZero(m.OnDemandStatus) { // not required
			return nil
		}

		if err := m.OnDemandStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("on_demand_status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("on_demand_status")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) contextValidatePricingModel(ctx context.Context, formats strfmt.Registry) error {

	if m.PricingModel != nil {

		if swag.IsZero(m.PricingModel) { // not required
			return nil
		}

		if err := m.PricingModel.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("pricing_model")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("pricing_model")
			}
			return err
		}
	}

	return nil
}

func (m *Billing20201105BillingAccount) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {

		if swag.IsZero(m.Status) { // not required
			return nil
		}

		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105BillingAccount) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105BillingAccount) UnmarshalBinary(b []byte) error {
	var res Billing20201105BillingAccount
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
