// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// Billing20201105EstimateCostResponse EstimateCostResponse is the response to EstimateCostRequest & contains the hourly and monthly costs.
//
// swagger:model billing_20201105EstimateCostResponse
type Billing20201105EstimateCostResponse struct {

	// item_price contains the individual hourly and monthly prices as well the itemKey for each product.
	ItemPrice []*Billing20201105EstimatedPackageItemPrice `json:"item_price"`

	// total_hourly_price is the hourly price of the cluster.
	TotalHourlyPrice string `json:"total_hourly_price,omitempty"`

	// total_monthly_price is the monthly price of the cluster.
	TotalMonthlyPrice string `json:"total_monthly_price,omitempty"`
}

// Validate validates this billing 20201105 estimate cost response
func (m *Billing20201105EstimateCostResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateItemPrice(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105EstimateCostResponse) validateItemPrice(formats strfmt.Registry) error {
	if swag.IsZero(m.ItemPrice) { // not required
		return nil
	}

	for i := 0; i < len(m.ItemPrice); i++ {
		if swag.IsZero(m.ItemPrice[i]) { // not required
			continue
		}

		if m.ItemPrice[i] != nil {
			if err := m.ItemPrice[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("item_price" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("item_price" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this billing 20201105 estimate cost response based on the context it is used
func (m *Billing20201105EstimateCostResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateItemPrice(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *Billing20201105EstimateCostResponse) contextValidateItemPrice(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.ItemPrice); i++ {

		if m.ItemPrice[i] != nil {

			if swag.IsZero(m.ItemPrice[i]) { // not required
				return nil
			}

			if err := m.ItemPrice[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("item_price" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("item_price" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *Billing20201105EstimateCostResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *Billing20201105EstimateCostResponse) UnmarshalBinary(b []byte) error {
	var res Billing20201105EstimateCostResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
