// Code generated by go-swagger; DO NOT EDIT.

package boundary_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-boundary-service/stable/2021-12-21/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// BoundaryServiceGetControllerConfigurationReader is a Reader for the BoundaryServiceGetControllerConfiguration structure.
type BoundaryServiceGetControllerConfigurationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *BoundaryServiceGetControllerConfigurationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewBoundaryServiceGetControllerConfigurationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewBoundaryServiceGetControllerConfigurationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewBoundaryServiceGetControllerConfigurationOK creates a BoundaryServiceGetControllerConfigurationOK with default headers values
func NewBoundaryServiceGetControllerConfigurationOK() *BoundaryServiceGetControllerConfigurationOK {
	return &BoundaryServiceGetControllerConfigurationOK{}
}

/*
BoundaryServiceGetControllerConfigurationOK describes a response with status code 200, with default header values.

A successful response.
*/
type BoundaryServiceGetControllerConfigurationOK struct {
	Payload *models.HashicorpCloudBoundary20211221GetControllerConfigurationResponse
}

// IsSuccess returns true when this boundary service get controller configuration o k response has a 2xx status code
func (o *BoundaryServiceGetControllerConfigurationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this boundary service get controller configuration o k response has a 3xx status code
func (o *BoundaryServiceGetControllerConfigurationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this boundary service get controller configuration o k response has a 4xx status code
func (o *BoundaryServiceGetControllerConfigurationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this boundary service get controller configuration o k response has a 5xx status code
func (o *BoundaryServiceGetControllerConfigurationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this boundary service get controller configuration o k response a status code equal to that given
func (o *BoundaryServiceGetControllerConfigurationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the boundary service get controller configuration o k response
func (o *BoundaryServiceGetControllerConfigurationOK) Code() int {
	return 200
}

func (o *BoundaryServiceGetControllerConfigurationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] boundaryServiceGetControllerConfigurationOK %s", 200, payload)
}

func (o *BoundaryServiceGetControllerConfigurationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] boundaryServiceGetControllerConfigurationOK %s", 200, payload)
}

func (o *BoundaryServiceGetControllerConfigurationOK) GetPayload() *models.HashicorpCloudBoundary20211221GetControllerConfigurationResponse {
	return o.Payload
}

func (o *BoundaryServiceGetControllerConfigurationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudBoundary20211221GetControllerConfigurationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewBoundaryServiceGetControllerConfigurationDefault creates a BoundaryServiceGetControllerConfigurationDefault with default headers values
func NewBoundaryServiceGetControllerConfigurationDefault(code int) *BoundaryServiceGetControllerConfigurationDefault {
	return &BoundaryServiceGetControllerConfigurationDefault{
		_statusCode: code,
	}
}

/*
BoundaryServiceGetControllerConfigurationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type BoundaryServiceGetControllerConfigurationDefault struct {
	_statusCode int

	Payload *cloud.GrpcGatewayRuntimeError
}

// IsSuccess returns true when this boundary service get controller configuration default response has a 2xx status code
func (o *BoundaryServiceGetControllerConfigurationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this boundary service get controller configuration default response has a 3xx status code
func (o *BoundaryServiceGetControllerConfigurationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this boundary service get controller configuration default response has a 4xx status code
func (o *BoundaryServiceGetControllerConfigurationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this boundary service get controller configuration default response has a 5xx status code
func (o *BoundaryServiceGetControllerConfigurationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this boundary service get controller configuration default response a status code equal to that given
func (o *BoundaryServiceGetControllerConfigurationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the boundary service get controller configuration default response
func (o *BoundaryServiceGetControllerConfigurationDefault) Code() int {
	return o._statusCode
}

func (o *BoundaryServiceGetControllerConfigurationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] BoundaryService_GetControllerConfiguration default %s", o._statusCode, payload)
}

func (o *BoundaryServiceGetControllerConfigurationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /boundary/2021-12-21/organizations/{location.organization_id}/projects/{location.project_id}/clusters/{cluster_id}/controller-configuration][%d] BoundaryService_GetControllerConfiguration default %s", o._statusCode, payload)
}

func (o *BoundaryServiceGetControllerConfigurationDefault) GetPayload() *cloud.GrpcGatewayRuntimeError {
	return o.Payload
}

func (o *BoundaryServiceGetControllerConfigurationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GrpcGatewayRuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
