// Code generated by go-swagger; DO NOT EDIT.

package log_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-log-service/preview/2021-03-30/models"
)

// LogServiceGetReader is a Reader for the LogServiceGet structure.
type LogServiceGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *LogServiceGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewLogServiceGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewLogServiceGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewLogServiceGetOK creates a LogServiceGetOK with default headers values
func NewLogServiceGetOK() *LogServiceGetOK {
	return &LogServiceGetOK{}
}

/*
LogServiceGetOK describes a response with status code 200, with default header values.

A successful response.
*/
type LogServiceGetOK struct {
	Payload *models.LogService20210330GetResponse
}

// IsSuccess returns true when this log service get o k response has a 2xx status code
func (o *LogServiceGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this log service get o k response has a 3xx status code
func (o *LogServiceGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this log service get o k response has a 4xx status code
func (o *LogServiceGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this log service get o k response has a 5xx status code
func (o *LogServiceGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this log service get o k response a status code equal to that given
func (o *LogServiceGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the log service get o k response
func (o *LogServiceGetOK) Code() int {
	return 200
}

func (o *LogServiceGetOK) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/entries/query][%d] logServiceGetOK  %+v", 200, o.Payload)
}

func (o *LogServiceGetOK) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/entries/query][%d] logServiceGetOK  %+v", 200, o.Payload)
}

func (o *LogServiceGetOK) GetPayload() *models.LogService20210330GetResponse {
	return o.Payload
}

func (o *LogServiceGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.LogService20210330GetResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewLogServiceGetDefault creates a LogServiceGetDefault with default headers values
func NewLogServiceGetDefault(code int) *LogServiceGetDefault {
	return &LogServiceGetDefault{
		_statusCode: code,
	}
}

/*
LogServiceGetDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type LogServiceGetDefault struct {
	_statusCode int

	Payload *models.RuntimeError
}

// IsSuccess returns true when this log service get default response has a 2xx status code
func (o *LogServiceGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this log service get default response has a 3xx status code
func (o *LogServiceGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this log service get default response has a 4xx status code
func (o *LogServiceGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this log service get default response has a 5xx status code
func (o *LogServiceGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this log service get default response a status code equal to that given
func (o *LogServiceGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the log service get default response
func (o *LogServiceGetDefault) Code() int {
	return o._statusCode
}

func (o *LogServiceGetDefault) Error() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/entries/query][%d] LogService_Get default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceGetDefault) String() string {
	return fmt.Sprintf("[POST /logs/2021-03-30/entries/query][%d] LogService_Get default  %+v", o._statusCode, o.Payload)
}

func (o *LogServiceGetDefault) GetPayload() *models.RuntimeError {
	return o.Payload
}

func (o *LogServiceGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RuntimeError)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
