// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// LogService20210330ListArchivesResponse ListArchiveResponse represents the response from the list archive request.
//
// swagger:model log_service_20210330ListArchivesResponse
type LogService20210330ListArchivesResponse struct {

	// archives represents the list of archive records that are related to a resource.
	Archives []*LogService20210330ListArchiveRecord `json:"archives"`

	// config_creation_date represents the date when the data plane configuration was created for a resource .
	// Format: date-time
	ConfigCreationDate strfmt.DateTime `json:"config_creation_date,omitempty"`
}

// Validate validates this log service 20210330 list archives response
func (m *LogService20210330ListArchivesResponse) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateArchives(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateConfigCreationDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330ListArchivesResponse) validateArchives(formats strfmt.Registry) error {
	if swag.IsZero(m.Archives) { // not required
		return nil
	}

	for i := 0; i < len(m.Archives); i++ {
		if swag.IsZero(m.Archives[i]) { // not required
			continue
		}

		if m.Archives[i] != nil {
			if err := m.Archives[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("archives" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("archives" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *LogService20210330ListArchivesResponse) validateConfigCreationDate(formats strfmt.Registry) error {
	if swag.IsZero(m.ConfigCreationDate) { // not required
		return nil
	}

	if err := validate.FormatOf("config_creation_date", "body", "date-time", m.ConfigCreationDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this log service 20210330 list archives response based on the context it is used
func (m *LogService20210330ListArchivesResponse) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateArchives(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *LogService20210330ListArchivesResponse) contextValidateArchives(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Archives); i++ {

		if m.Archives[i] != nil {

			if swag.IsZero(m.Archives[i]) { // not required
				return nil
			}

			if err := m.Archives[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("archives" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("archives" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (m *LogService20210330ListArchivesResponse) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *LogService20210330ListArchivesResponse) UnmarshalBinary(b []byte) error {
	var res LogService20210330ListArchivesResponse
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
