// Code generated by go-swagger; DO NOT EDIT.

package packer_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-packer-service/stable/2021-04-30/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// PackerServiceUpdateRegistryReader is a Reader for the PackerServiceUpdateRegistry structure.
type PackerServiceUpdateRegistryReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PackerServiceUpdateRegistryReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPackerServiceUpdateRegistryOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPackerServiceUpdateRegistryDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPackerServiceUpdateRegistryOK creates a PackerServiceUpdateRegistryOK with default headers values
func NewPackerServiceUpdateRegistryOK() *PackerServiceUpdateRegistryOK {
	return &PackerServiceUpdateRegistryOK{}
}

/*
PackerServiceUpdateRegistryOK describes a response with status code 200, with default header values.

A successful response.
*/
type PackerServiceUpdateRegistryOK struct {
	Payload *models.HashicorpCloudPackerUpdateRegistryResponse
}

// IsSuccess returns true when this packer service update registry o k response has a 2xx status code
func (o *PackerServiceUpdateRegistryOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this packer service update registry o k response has a 3xx status code
func (o *PackerServiceUpdateRegistryOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this packer service update registry o k response has a 4xx status code
func (o *PackerServiceUpdateRegistryOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this packer service update registry o k response has a 5xx status code
func (o *PackerServiceUpdateRegistryOK) IsServerError() bool {
	return false
}

// IsCode returns true when this packer service update registry o k response a status code equal to that given
func (o *PackerServiceUpdateRegistryOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the packer service update registry o k response
func (o *PackerServiceUpdateRegistryOK) Code() int {
	return 200
}

func (o *PackerServiceUpdateRegistryOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceUpdateRegistryOK %s", 200, payload)
}

func (o *PackerServiceUpdateRegistryOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] packerServiceUpdateRegistryOK %s", 200, payload)
}

func (o *PackerServiceUpdateRegistryOK) GetPayload() *models.HashicorpCloudPackerUpdateRegistryResponse {
	return o.Payload
}

func (o *PackerServiceUpdateRegistryOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudPackerUpdateRegistryResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPackerServiceUpdateRegistryDefault creates a PackerServiceUpdateRegistryDefault with default headers values
func NewPackerServiceUpdateRegistryDefault(code int) *PackerServiceUpdateRegistryDefault {
	return &PackerServiceUpdateRegistryDefault{
		_statusCode: code,
	}
}

/*
PackerServiceUpdateRegistryDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type PackerServiceUpdateRegistryDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this packer service update registry default response has a 2xx status code
func (o *PackerServiceUpdateRegistryDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this packer service update registry default response has a 3xx status code
func (o *PackerServiceUpdateRegistryDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this packer service update registry default response has a 4xx status code
func (o *PackerServiceUpdateRegistryDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this packer service update registry default response has a 5xx status code
func (o *PackerServiceUpdateRegistryDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this packer service update registry default response a status code equal to that given
func (o *PackerServiceUpdateRegistryDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the packer service update registry default response
func (o *PackerServiceUpdateRegistryDefault) Code() int {
	return o._statusCode
}

func (o *PackerServiceUpdateRegistryDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_UpdateRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateRegistryDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /packer/2021-04-30/organizations/{location.organization_id}/projects/{location.project_id}/registry][%d] PackerService_UpdateRegistry default %s", o._statusCode, payload)
}

func (o *PackerServiceUpdateRegistryDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *PackerServiceUpdateRegistryDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
PackerServiceUpdateRegistryBody packer service update registry body
swagger:model PackerServiceUpdateRegistryBody
*/
type PackerServiceUpdateRegistryBody struct {

	// Activates a deactivated registry. A registry can only be activated
	// if the organization billing account is valid (e.g. valid credits or payment method).
	Activate bool `json:"activate,omitempty"`

	// Feature tier of the Registry.
	// When trying to update a registry to the deprecated PRIVATE_BETA tier, HCP Packer will
	// automatically update to STANDARD.
	FeatureTier *models.HashicorpCloudPackerRegistryConfigTier `json:"feature_tier,omitempty"`

	// location
	Location *PackerServiceUpdateRegistryParamsBodyLocation `json:"location,omitempty"`
}

// Validate validates this packer service update registry body
func (o *PackerServiceUpdateRegistryBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateFeatureTier(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateRegistryBody) validateFeatureTier(formats strfmt.Registry) error {
	if swag.IsZero(o.FeatureTier) { // not required
		return nil
	}

	if o.FeatureTier != nil {
		if err := o.FeatureTier.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "feature_tier")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceUpdateRegistryBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service update registry body based on the context it is used
func (o *PackerServiceUpdateRegistryBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateFeatureTier(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateRegistryBody) contextValidateFeatureTier(ctx context.Context, formats strfmt.Registry) error {

	if o.FeatureTier != nil {

		if swag.IsZero(o.FeatureTier) { // not required
			return nil
		}

		if err := o.FeatureTier.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "feature_tier")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "feature_tier")
			}
			return err
		}
	}

	return nil
}

func (o *PackerServiceUpdateRegistryBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceUpdateRegistryBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceUpdateRegistryBody) UnmarshalBinary(b []byte) error {
	var res PackerServiceUpdateRegistryBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
PackerServiceUpdateRegistryParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model PackerServiceUpdateRegistryParamsBodyLocation
*/
type PackerServiceUpdateRegistryParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *cloud.HashicorpCloudLocationRegion `json:"region,omitempty"`
}

// Validate validates this packer service update registry params body location
func (o *PackerServiceUpdateRegistryParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateRegistryParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this packer service update registry params body location based on the context it is used
func (o *PackerServiceUpdateRegistryParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *PackerServiceUpdateRegistryParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *PackerServiceUpdateRegistryParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *PackerServiceUpdateRegistryParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res PackerServiceUpdateRegistryParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
