// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudPacker20230101Version hashicorp cloud packer 20230101 version
//
// swagger:model hashicorp.cloud.packer_20230101.Version
type HashicorpCloudPacker20230101Version struct {

	// Name of the author who created this version.
	AuthorID string `json:"author_id,omitempty"`

	// Human-readable name for the bucket that this version is associated with.
	BucketName string `json:"bucket_name,omitempty"`

	// List of all the builds associated with this version.
	Builds []*HashicorpCloudPacker20230101Build `json:"builds"`

	// Created datetime.
	// Format: date-time
	CreatedAt strfmt.DateTime `json:"created_at,omitempty"`

	// Fingerprint of the version. The fingerprint is set by Packer when you
	// call `packer build`.
	Fingerprint string `json:"fingerprint,omitempty"`

	// If true, this version has children versions. Knowing if a version has
	// descendants can help taking decisions such as persist revocation to all
	// its descendants or not.
	HasDescendants bool `json:"has_descendants,omitempty"`

	// Unique identifier (ULID).
	ID string `json:"id,omitempty"`

	// Human-readable name of the version.
	Name string `json:"name,omitempty"`

	// Information about this version's parents. Parents are the base artifact.
	Parents *HashicorpCloudPacker20230101VersionParents `json:"parents,omitempty"`

	// Who revoked this version. For human authors (e.g. HCP Portal) this will be
	// an email address. For machine authors using service principals, this is
	// the customer-chosen name for this service principal.
	RevocationAuthor string `json:"revocation_author,omitempty"`

	// Ancestor version from whom this version inherited the revocation.
	RevocationInheritedFrom *HashicorpCloudPacker20230101RevokedAncestor `json:"revocation_inherited_from,omitempty"`

	// Short explanation of why this version was revoked.
	RevocationMessage string `json:"revocation_message,omitempty"`

	// Revocation type is 'manual' when the version is revoked directly or
	// 'inherited' when the version inherits a revocation from an upstream
	// ancestor.
	RevocationType *HashicorpCloudPacker20230101RevocationType `json:"revocation_type,omitempty"`

	// Datetime from when the version is revoked an no longer trusted to be secure.
	// Format: date-time
	RevokeAt strfmt.DateTime `json:"revoke_at,omitempty"`

	// Current state of the version.
	Status *HashicorpCloudPacker20230101VersionStatus `json:"status,omitempty"`

	// The type of Packer configuration template used to build this version.
	TemplateType *HashicorpCloudPacker20230101TemplateType `json:"template_type,omitempty"`

	// Last updated datetime.
	// Format: date-time
	UpdatedAt strfmt.DateTime `json:"updated_at,omitempty"`
}

// Validate validates this hashicorp cloud packer 20230101 version
func (m *HashicorpCloudPacker20230101Version) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateBuilds(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateCreatedAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateParents(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRevocationInheritedFrom(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRevocationType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateRevokeAt(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTemplateType(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateUpdatedAt(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateBuilds(formats strfmt.Registry) error {
	if swag.IsZero(m.Builds) { // not required
		return nil
	}

	for i := 0; i < len(m.Builds); i++ {
		if swag.IsZero(m.Builds[i]) { // not required
			continue
		}

		if m.Builds[i] != nil {
			if err := m.Builds[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("builds" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("builds" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateCreatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.CreatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("created_at", "body", "date-time", m.CreatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateParents(formats strfmt.Registry) error {
	if swag.IsZero(m.Parents) { // not required
		return nil
	}

	if m.Parents != nil {
		if err := m.Parents.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parents")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parents")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateRevocationInheritedFrom(formats strfmt.Registry) error {
	if swag.IsZero(m.RevocationInheritedFrom) { // not required
		return nil
	}

	if m.RevocationInheritedFrom != nil {
		if err := m.RevocationInheritedFrom.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("revocation_inherited_from")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("revocation_inherited_from")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateRevocationType(formats strfmt.Registry) error {
	if swag.IsZero(m.RevocationType) { // not required
		return nil
	}

	if m.RevocationType != nil {
		if err := m.RevocationType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("revocation_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("revocation_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateRevokeAt(formats strfmt.Registry) error {
	if swag.IsZero(m.RevokeAt) { // not required
		return nil
	}

	if err := validate.FormatOf("revoke_at", "body", "date-time", m.RevokeAt.String(), formats); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateStatus(formats strfmt.Registry) error {
	if swag.IsZero(m.Status) { // not required
		return nil
	}

	if m.Status != nil {
		if err := m.Status.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateTemplateType(formats strfmt.Registry) error {
	if swag.IsZero(m.TemplateType) { // not required
		return nil
	}

	if m.TemplateType != nil {
		if err := m.TemplateType.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("template_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) validateUpdatedAt(formats strfmt.Registry) error {
	if swag.IsZero(m.UpdatedAt) { // not required
		return nil
	}

	if err := validate.FormatOf("updated_at", "body", "date-time", m.UpdatedAt.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this hashicorp cloud packer 20230101 version based on the context it is used
func (m *HashicorpCloudPacker20230101Version) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateBuilds(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateParents(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRevocationInheritedFrom(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateRevocationType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTemplateType(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateBuilds(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Builds); i++ {

		if m.Builds[i] != nil {

			if swag.IsZero(m.Builds[i]) { // not required
				return nil
			}

			if err := m.Builds[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("builds" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("builds" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateParents(ctx context.Context, formats strfmt.Registry) error {

	if m.Parents != nil {

		if swag.IsZero(m.Parents) { // not required
			return nil
		}

		if err := m.Parents.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("parents")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("parents")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateRevocationInheritedFrom(ctx context.Context, formats strfmt.Registry) error {

	if m.RevocationInheritedFrom != nil {

		if swag.IsZero(m.RevocationInheritedFrom) { // not required
			return nil
		}

		if err := m.RevocationInheritedFrom.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("revocation_inherited_from")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("revocation_inherited_from")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateRevocationType(ctx context.Context, formats strfmt.Registry) error {

	if m.RevocationType != nil {

		if swag.IsZero(m.RevocationType) { // not required
			return nil
		}

		if err := m.RevocationType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("revocation_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("revocation_type")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateStatus(ctx context.Context, formats strfmt.Registry) error {

	if m.Status != nil {

		if swag.IsZero(m.Status) { // not required
			return nil
		}

		if err := m.Status.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("status")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("status")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudPacker20230101Version) contextValidateTemplateType(ctx context.Context, formats strfmt.Registry) error {

	if m.TemplateType != nil {

		if swag.IsZero(m.TemplateType) { // not required
			return nil
		}

		if err := m.TemplateType.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("template_type")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("template_type")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101Version) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudPacker20230101Version) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudPacker20230101Version
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
