// Code generated by go-swagger; DO NOT EDIT.

package resource_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-resource-manager/stable/2019-12-10/models"
	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
)

// ResourceServiceListReader is a Reader for the ResourceServiceList structure.
type ResourceServiceListReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *ResourceServiceListReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewResourceServiceListOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewResourceServiceListDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewResourceServiceListOK creates a ResourceServiceListOK with default headers values
func NewResourceServiceListOK() *ResourceServiceListOK {
	return &ResourceServiceListOK{}
}

/*
ResourceServiceListOK describes a response with status code 200, with default header values.

A successful response.
*/
type ResourceServiceListOK struct {
	Payload *models.HashicorpCloudResourcemanagerResourceListResponse
}

// IsSuccess returns true when this resource service list o k response has a 2xx status code
func (o *ResourceServiceListOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this resource service list o k response has a 3xx status code
func (o *ResourceServiceListOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this resource service list o k response has a 4xx status code
func (o *ResourceServiceListOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this resource service list o k response has a 5xx status code
func (o *ResourceServiceListOK) IsServerError() bool {
	return false
}

// IsCode returns true when this resource service list o k response a status code equal to that given
func (o *ResourceServiceListOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the resource service list o k response
func (o *ResourceServiceListOK) Code() int {
	return 200
}

func (o *ResourceServiceListOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources][%d] resourceServiceListOK %s", 200, payload)
}

func (o *ResourceServiceListOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources][%d] resourceServiceListOK %s", 200, payload)
}

func (o *ResourceServiceListOK) GetPayload() *models.HashicorpCloudResourcemanagerResourceListResponse {
	return o.Payload
}

func (o *ResourceServiceListOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudResourcemanagerResourceListResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewResourceServiceListDefault creates a ResourceServiceListDefault with default headers values
func NewResourceServiceListDefault(code int) *ResourceServiceListDefault {
	return &ResourceServiceListDefault{
		_statusCode: code,
	}
}

/*
ResourceServiceListDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type ResourceServiceListDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this resource service list default response has a 2xx status code
func (o *ResourceServiceListDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this resource service list default response has a 3xx status code
func (o *ResourceServiceListDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this resource service list default response has a 4xx status code
func (o *ResourceServiceListDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this resource service list default response has a 5xx status code
func (o *ResourceServiceListDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this resource service list default response a status code equal to that given
func (o *ResourceServiceListDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the resource service list default response
func (o *ResourceServiceListDefault) Code() int {
	return o._statusCode
}

func (o *ResourceServiceListDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources][%d] ResourceService_List default %s", o._statusCode, payload)
}

func (o *ResourceServiceListDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /resource-manager/2019-12-10/resources][%d] ResourceService_List default %s", o._statusCode, payload)
}

func (o *ResourceServiceListDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *ResourceServiceListDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
