// Code generated by go-swagger; DO NOT EDIT.

package data_source_registration_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-radar/preview/2023-05-01/models"
)

// UpdateDataSourceTokenReader is a Reader for the UpdateDataSourceToken structure.
type UpdateDataSourceTokenReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateDataSourceTokenReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateDataSourceTokenOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateDataSourceTokenDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateDataSourceTokenOK creates a UpdateDataSourceTokenOK with default headers values
func NewUpdateDataSourceTokenOK() *UpdateDataSourceTokenOK {
	return &UpdateDataSourceTokenOK{}
}

/*
UpdateDataSourceTokenOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateDataSourceTokenOK struct {
	Payload interface{}
}

// IsSuccess returns true when this update data source token o k response has a 2xx status code
func (o *UpdateDataSourceTokenOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update data source token o k response has a 3xx status code
func (o *UpdateDataSourceTokenOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update data source token o k response has a 4xx status code
func (o *UpdateDataSourceTokenOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update data source token o k response has a 5xx status code
func (o *UpdateDataSourceTokenOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update data source token o k response a status code equal to that given
func (o *UpdateDataSourceTokenOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update data source token o k response
func (o *UpdateDataSourceTokenOK) Code() int {
	return 200
}

func (o *UpdateDataSourceTokenOK) Error() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/token][%d] updateDataSourceTokenOK  %+v", 200, o.Payload)
}

func (o *UpdateDataSourceTokenOK) String() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/token][%d] updateDataSourceTokenOK  %+v", 200, o.Payload)
}

func (o *UpdateDataSourceTokenOK) GetPayload() interface{} {
	return o.Payload
}

func (o *UpdateDataSourceTokenOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateDataSourceTokenDefault creates a UpdateDataSourceTokenDefault with default headers values
func NewUpdateDataSourceTokenDefault(code int) *UpdateDataSourceTokenDefault {
	return &UpdateDataSourceTokenDefault{
		_statusCode: code,
	}
}

/*
UpdateDataSourceTokenDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateDataSourceTokenDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this update data source token default response has a 2xx status code
func (o *UpdateDataSourceTokenDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update data source token default response has a 3xx status code
func (o *UpdateDataSourceTokenDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update data source token default response has a 4xx status code
func (o *UpdateDataSourceTokenDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update data source token default response has a 5xx status code
func (o *UpdateDataSourceTokenDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update data source token default response a status code equal to that given
func (o *UpdateDataSourceTokenDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update data source token default response
func (o *UpdateDataSourceTokenDefault) Code() int {
	return o._statusCode
}

func (o *UpdateDataSourceTokenDefault) Error() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/token][%d] UpdateDataSourceToken default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateDataSourceTokenDefault) String() string {
	return fmt.Sprintf("[PUT /2023-05-01/vault-radar/projects/{location.project_id}/data-source-registrations/token][%d] UpdateDataSourceToken default  %+v", o._statusCode, o.Payload)
}

func (o *UpdateDataSourceTokenDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *UpdateDataSourceTokenDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
UpdateDataSourceTokenBody update data source token body
swagger:model UpdateDataSourceTokenBody
*/
type UpdateDataSourceTokenBody struct {

	// id
	ID string `json:"id,omitempty"`

	// location
	Location *UpdateDataSourceTokenParamsBodyLocation `json:"location,omitempty"`

	// token
	Token string `json:"token,omitempty"`
}

// Validate validates this update data source token body
func (o *UpdateDataSourceTokenBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateDataSourceTokenBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update data source token body based on the context it is used
func (o *UpdateDataSourceTokenBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateDataSourceTokenBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateDataSourceTokenBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateDataSourceTokenBody) UnmarshalBinary(b []byte) error {
	var res UpdateDataSourceTokenBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
UpdateDataSourceTokenParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model UpdateDataSourceTokenParamsBodyLocation
*/
type UpdateDataSourceTokenParamsBodyLocation struct {

	// organization_id is the id of the organization.
	OrganizationID string `json:"organization_id,omitempty"`

	// region
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this update data source token params body location
func (o *UpdateDataSourceTokenParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateDataSourceTokenParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this update data source token params body location based on the context it is used
func (o *UpdateDataSourceTokenParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *UpdateDataSourceTokenParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *UpdateDataSourceTokenParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *UpdateDataSourceTokenParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res UpdateDataSourceTokenParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
