// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// CreateAppReader is a Reader for the CreateApp structure.
type CreateAppReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateAppDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppOK creates a CreateAppOK with default headers values
func NewCreateAppOK() *CreateAppOK {
	return &CreateAppOK{}
}

/*
CreateAppOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateAppOK struct {
	Payload *models.Secrets20230613CreateAppResponse
}

// IsSuccess returns true when this create app o k response has a 2xx status code
func (o *CreateAppOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create app o k response has a 3xx status code
func (o *CreateAppOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create app o k response has a 4xx status code
func (o *CreateAppOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create app o k response has a 5xx status code
func (o *CreateAppOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create app o k response a status code equal to that given
func (o *CreateAppOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create app o k response
func (o *CreateAppOK) Code() int {
	return 200
}

func (o *CreateAppOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps][%d] createAppOK %s", 200, payload)
}

func (o *CreateAppOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps][%d] createAppOK %s", 200, payload)
}

func (o *CreateAppOK) GetPayload() *models.Secrets20230613CreateAppResponse {
	return o.Payload
}

func (o *CreateAppOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613CreateAppResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppDefault creates a CreateAppDefault with default headers values
func NewCreateAppDefault(code int) *CreateAppDefault {
	return &CreateAppDefault{
		_statusCode: code,
	}
}

/*
CreateAppDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateAppDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this create app default response has a 2xx status code
func (o *CreateAppDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create app default response has a 3xx status code
func (o *CreateAppDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create app default response has a 4xx status code
func (o *CreateAppDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create app default response has a 5xx status code
func (o *CreateAppDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create app default response a status code equal to that given
func (o *CreateAppDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create app default response
func (o *CreateAppDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps][%d] CreateApp default %s", o._statusCode, payload)
}

func (o *CreateAppDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/apps][%d] CreateApp default %s", o._statusCode, payload)
}

func (o *CreateAppDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *CreateAppDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
CreateAppBody create app body
swagger:model CreateAppBody
*/
type CreateAppBody struct {

	// description
	Description string `json:"description,omitempty"`

	// location
	Location *CreateAppParamsBodyLocation `json:"location,omitempty"`

	// name
	Name string `json:"name,omitempty"`

	// sync integrations
	SyncIntegrations []string `json:"sync_integrations"`
}

// Validate validates this create app body
func (o *CreateAppBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLocation(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateAppBody) validateLocation(formats strfmt.Registry) error {
	if swag.IsZero(o.Location) { // not required
		return nil
	}

	if o.Location != nil {
		if err := o.Location.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create app body based on the context it is used
func (o *CreateAppBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLocation(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateAppBody) contextValidateLocation(ctx context.Context, formats strfmt.Registry) error {

	if o.Location != nil {

		if swag.IsZero(o.Location) { // not required
			return nil
		}

		if err := o.Location.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateAppBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateAppBody) UnmarshalBinary(b []byte) error {
	var res CreateAppBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
CreateAppParamsBodyLocation Location represents a target for an operation in HCP.
swagger:model CreateAppParamsBodyLocation
*/
type CreateAppParamsBodyLocation struct {

	// region is the region that the resource is located in. It is
	// optional if the object being referenced is a global object.
	Region *models.LocationRegion `json:"region,omitempty"`
}

// Validate validates this create app params body location
func (o *CreateAppParamsBodyLocation) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRegion(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateAppParamsBodyLocation) validateRegion(formats strfmt.Registry) error {
	if swag.IsZero(o.Region) { // not required
		return nil
	}

	if o.Region != nil {
		if err := o.Region.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this create app params body location based on the context it is used
func (o *CreateAppParamsBodyLocation) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRegion(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *CreateAppParamsBodyLocation) contextValidateRegion(ctx context.Context, formats strfmt.Registry) error {

	if o.Region != nil {

		if swag.IsZero(o.Region) { // not required
			return nil
		}

		if err := o.Region.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("body" + "." + "location" + "." + "region")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("body" + "." + "location" + "." + "region")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *CreateAppParamsBodyLocation) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *CreateAppParamsBodyLocation) UnmarshalBinary(b []byte) error {
	var res CreateAppParamsBodyLocation
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
