// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-06-13/models"
)

// GetUsageReader is a Reader for the GetUsage structure.
type GetUsageReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetUsageReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetUsageOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetUsageDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetUsageOK creates a GetUsageOK with default headers values
func NewGetUsageOK() *GetUsageOK {
	return &GetUsageOK{}
}

/*
GetUsageOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetUsageOK struct {
	Payload *models.Secrets20230613GetUsageResponse
}

// IsSuccess returns true when this get usage o k response has a 2xx status code
func (o *GetUsageOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get usage o k response has a 3xx status code
func (o *GetUsageOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get usage o k response has a 4xx status code
func (o *GetUsageOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get usage o k response has a 5xx status code
func (o *GetUsageOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get usage o k response a status code equal to that given
func (o *GetUsageOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get usage o k response
func (o *GetUsageOK) Code() int {
	return 200
}

func (o *GetUsageOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/usage][%d] getUsageOK %s", 200, payload)
}

func (o *GetUsageOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/usage][%d] getUsageOK %s", 200, payload)
}

func (o *GetUsageOK) GetPayload() *models.Secrets20230613GetUsageResponse {
	return o.Payload
}

func (o *GetUsageOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20230613GetUsageResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetUsageDefault creates a GetUsageDefault with default headers values
func NewGetUsageDefault(code int) *GetUsageDefault {
	return &GetUsageDefault{
		_statusCode: code,
	}
}

/*
GetUsageDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetUsageDefault struct {
	_statusCode int

	Payload *models.RPCStatus
}

// IsSuccess returns true when this get usage default response has a 2xx status code
func (o *GetUsageDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get usage default response has a 3xx status code
func (o *GetUsageDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get usage default response has a 4xx status code
func (o *GetUsageDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get usage default response has a 5xx status code
func (o *GetUsageDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get usage default response a status code equal to that given
func (o *GetUsageDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get usage default response
func (o *GetUsageDefault) Code() int {
	return o._statusCode
}

func (o *GetUsageDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/usage][%d] GetUsage default %s", o._statusCode, payload)
}

func (o *GetUsageDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-06-13/organizations/{location.organization_id}/projects/{location.project_id}/usage][%d] GetUsage default %s", o._statusCode, payload)
}

func (o *GetUsageDefault) GetPayload() *models.RPCStatus {
	return o.Payload
}

func (o *GetUsageDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.RPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
