// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// CreateAppRotatingSecretReader is a Reader for the CreateAppRotatingSecret structure.
type CreateAppRotatingSecretReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *CreateAppRotatingSecretReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewCreateAppRotatingSecretOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewCreateAppRotatingSecretDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewCreateAppRotatingSecretOK creates a CreateAppRotatingSecretOK with default headers values
func NewCreateAppRotatingSecretOK() *CreateAppRotatingSecretOK {
	return &CreateAppRotatingSecretOK{}
}

/*
CreateAppRotatingSecretOK describes a response with status code 200, with default header values.

A successful response.
*/
type CreateAppRotatingSecretOK struct {
	Payload *models.Secrets20231128CreateAppRotatingSecretResponse
}

// IsSuccess returns true when this create app rotating secret o k response has a 2xx status code
func (o *CreateAppRotatingSecretOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this create app rotating secret o k response has a 3xx status code
func (o *CreateAppRotatingSecretOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this create app rotating secret o k response has a 4xx status code
func (o *CreateAppRotatingSecretOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this create app rotating secret o k response has a 5xx status code
func (o *CreateAppRotatingSecretOK) IsServerError() bool {
	return false
}

// IsCode returns true when this create app rotating secret o k response a status code equal to that given
func (o *CreateAppRotatingSecretOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the create app rotating secret o k response
func (o *CreateAppRotatingSecretOK) Code() int {
	return 200
}

func (o *CreateAppRotatingSecretOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating][%d] createAppRotatingSecretOK %s", 200, payload)
}

func (o *CreateAppRotatingSecretOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating][%d] createAppRotatingSecretOK %s", 200, payload)
}

func (o *CreateAppRotatingSecretOK) GetPayload() *models.Secrets20231128CreateAppRotatingSecretResponse {
	return o.Payload
}

func (o *CreateAppRotatingSecretOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128CreateAppRotatingSecretResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewCreateAppRotatingSecretDefault creates a CreateAppRotatingSecretDefault with default headers values
func NewCreateAppRotatingSecretDefault(code int) *CreateAppRotatingSecretDefault {
	return &CreateAppRotatingSecretDefault{
		_statusCode: code,
	}
}

/*
CreateAppRotatingSecretDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type CreateAppRotatingSecretDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this create app rotating secret default response has a 2xx status code
func (o *CreateAppRotatingSecretDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this create app rotating secret default response has a 3xx status code
func (o *CreateAppRotatingSecretDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this create app rotating secret default response has a 4xx status code
func (o *CreateAppRotatingSecretDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this create app rotating secret default response has a 5xx status code
func (o *CreateAppRotatingSecretDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this create app rotating secret default response a status code equal to that given
func (o *CreateAppRotatingSecretDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the create app rotating secret default response
func (o *CreateAppRotatingSecretDefault) Code() int {
	return o._statusCode
}

func (o *CreateAppRotatingSecretDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating][%d] CreateAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *CreateAppRotatingSecretDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating][%d] CreateAppRotatingSecret default %s", o._statusCode, payload)
}

func (o *CreateAppRotatingSecretDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *CreateAppRotatingSecretDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
