// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateConfluentIntegrationParams creates a new CreateConfluentIntegrationParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateConfluentIntegrationParams() *CreateConfluentIntegrationParams {
	return &CreateConfluentIntegrationParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateConfluentIntegrationParamsWithTimeout creates a new CreateConfluentIntegrationParams object
// with the ability to set a timeout on a request.
func NewCreateConfluentIntegrationParamsWithTimeout(timeout time.Duration) *CreateConfluentIntegrationParams {
	return &CreateConfluentIntegrationParams{
		timeout: timeout,
	}
}

// NewCreateConfluentIntegrationParamsWithContext creates a new CreateConfluentIntegrationParams object
// with the ability to set a context for a request.
func NewCreateConfluentIntegrationParamsWithContext(ctx context.Context) *CreateConfluentIntegrationParams {
	return &CreateConfluentIntegrationParams{
		Context: ctx,
	}
}

// NewCreateConfluentIntegrationParamsWithHTTPClient creates a new CreateConfluentIntegrationParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateConfluentIntegrationParamsWithHTTPClient(client *http.Client) *CreateConfluentIntegrationParams {
	return &CreateConfluentIntegrationParams{
		HTTPClient: client,
	}
}

/*
CreateConfluentIntegrationParams contains all the parameters to send to the API endpoint

	for the create confluent integration operation.

	Typically these are written to a http.Request.
*/
type CreateConfluentIntegrationParams struct {

	// Body.
	Body *models.SecretServiceCreateConfluentIntegrationBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create confluent integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateConfluentIntegrationParams) WithDefaults() *CreateConfluentIntegrationParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create confluent integration params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateConfluentIntegrationParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithTimeout(timeout time.Duration) *CreateConfluentIntegrationParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithContext(ctx context.Context) *CreateConfluentIntegrationParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithHTTPClient(client *http.Client) *CreateConfluentIntegrationParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithBody(body *models.SecretServiceCreateConfluentIntegrationBody) *CreateConfluentIntegrationParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetBody(body *models.SecretServiceCreateConfluentIntegrationBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithOrganizationID(organizationID string) *CreateConfluentIntegrationParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create confluent integration params
func (o *CreateConfluentIntegrationParams) WithProjectID(projectID string) *CreateConfluentIntegrationParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create confluent integration params
func (o *CreateConfluentIntegrationParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateConfluentIntegrationParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
