// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// NewCreateSyncParams creates a new CreateSyncParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewCreateSyncParams() *CreateSyncParams {
	return &CreateSyncParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewCreateSyncParamsWithTimeout creates a new CreateSyncParams object
// with the ability to set a timeout on a request.
func NewCreateSyncParamsWithTimeout(timeout time.Duration) *CreateSyncParams {
	return &CreateSyncParams{
		timeout: timeout,
	}
}

// NewCreateSyncParamsWithContext creates a new CreateSyncParams object
// with the ability to set a context for a request.
func NewCreateSyncParamsWithContext(ctx context.Context) *CreateSyncParams {
	return &CreateSyncParams{
		Context: ctx,
	}
}

// NewCreateSyncParamsWithHTTPClient creates a new CreateSyncParams object
// with the ability to set a custom HTTPClient for a request.
func NewCreateSyncParamsWithHTTPClient(client *http.Client) *CreateSyncParams {
	return &CreateSyncParams{
		HTTPClient: client,
	}
}

/*
CreateSyncParams contains all the parameters to send to the API endpoint

	for the create sync operation.

	Typically these are written to a http.Request.
*/
type CreateSyncParams struct {

	// Body.
	Body *models.SecretServiceCreateSyncBody

	// OrganizationID.
	OrganizationID string

	// ProjectID.
	ProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the create sync params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateSyncParams) WithDefaults() *CreateSyncParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the create sync params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *CreateSyncParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the create sync params
func (o *CreateSyncParams) WithTimeout(timeout time.Duration) *CreateSyncParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the create sync params
func (o *CreateSyncParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the create sync params
func (o *CreateSyncParams) WithContext(ctx context.Context) *CreateSyncParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the create sync params
func (o *CreateSyncParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the create sync params
func (o *CreateSyncParams) WithHTTPClient(client *http.Client) *CreateSyncParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the create sync params
func (o *CreateSyncParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the create sync params
func (o *CreateSyncParams) WithBody(body *models.SecretServiceCreateSyncBody) *CreateSyncParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the create sync params
func (o *CreateSyncParams) SetBody(body *models.SecretServiceCreateSyncBody) {
	o.Body = body
}

// WithOrganizationID adds the organizationID to the create sync params
func (o *CreateSyncParams) WithOrganizationID(organizationID string) *CreateSyncParams {
	o.SetOrganizationID(organizationID)
	return o
}

// SetOrganizationID adds the organizationId to the create sync params
func (o *CreateSyncParams) SetOrganizationID(organizationID string) {
	o.OrganizationID = organizationID
}

// WithProjectID adds the projectID to the create sync params
func (o *CreateSyncParams) WithProjectID(projectID string) *CreateSyncParams {
	o.SetProjectID(projectID)
	return o
}

// SetProjectID adds the projectId to the create sync params
func (o *CreateSyncParams) SetProjectID(projectID string) {
	o.ProjectID = projectID
}

// WriteToRequest writes these params to a swagger request
func (o *CreateSyncParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param organization_id
	if err := r.SetPathParam("organization_id", o.OrganizationID); err != nil {
		return err
	}

	// path param project_id
	if err := r.SetPathParam("project_id", o.ProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
