// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// GetTwilioIntegrationReader is a Reader for the GetTwilioIntegration structure.
type GetTwilioIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *GetTwilioIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewGetTwilioIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewGetTwilioIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewGetTwilioIntegrationOK creates a GetTwilioIntegrationOK with default headers values
func NewGetTwilioIntegrationOK() *GetTwilioIntegrationOK {
	return &GetTwilioIntegrationOK{}
}

/*
GetTwilioIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type GetTwilioIntegrationOK struct {
	Payload *models.Secrets20231128GetTwilioIntegrationResponse
}

// IsSuccess returns true when this get twilio integration o k response has a 2xx status code
func (o *GetTwilioIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this get twilio integration o k response has a 3xx status code
func (o *GetTwilioIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this get twilio integration o k response has a 4xx status code
func (o *GetTwilioIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this get twilio integration o k response has a 5xx status code
func (o *GetTwilioIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this get twilio integration o k response a status code equal to that given
func (o *GetTwilioIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the get twilio integration o k response
func (o *GetTwilioIntegrationOK) Code() int {
	return 200
}

func (o *GetTwilioIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] getTwilioIntegrationOK %s", 200, payload)
}

func (o *GetTwilioIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] getTwilioIntegrationOK %s", 200, payload)
}

func (o *GetTwilioIntegrationOK) GetPayload() *models.Secrets20231128GetTwilioIntegrationResponse {
	return o.Payload
}

func (o *GetTwilioIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128GetTwilioIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewGetTwilioIntegrationDefault creates a GetTwilioIntegrationDefault with default headers values
func NewGetTwilioIntegrationDefault(code int) *GetTwilioIntegrationDefault {
	return &GetTwilioIntegrationDefault{
		_statusCode: code,
	}
}

/*
GetTwilioIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type GetTwilioIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this get twilio integration default response has a 2xx status code
func (o *GetTwilioIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this get twilio integration default response has a 3xx status code
func (o *GetTwilioIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this get twilio integration default response has a 4xx status code
func (o *GetTwilioIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this get twilio integration default response has a 5xx status code
func (o *GetTwilioIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this get twilio integration default response a status code equal to that given
func (o *GetTwilioIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the get twilio integration default response
func (o *GetTwilioIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *GetTwilioIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] GetTwilioIntegration default %s", o._statusCode, payload)
}

func (o *GetTwilioIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}][%d] GetTwilioIntegration default %s", o._statusCode, payload)
}

func (o *GetTwilioIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *GetTwilioIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
