// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	httptransport "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// New creates a new secret service API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

// New creates a new secret service API client with basic auth credentials.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - user: user for basic authentication header.
// - password: password for basic authentication header.
func NewClientWithBasicAuth(host, basePath, scheme, user, password string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BasicAuth(user, password)
	return &Client{transport: transport, formats: strfmt.Default}
}

// New creates a new secret service API client with a bearer token for authentication.
// It takes the following parameters:
// - host: http host (github.com).
// - basePath: any base path for the API client ("/v1", "/v3").
// - scheme: http scheme ("http", "https").
// - bearerToken: bearer token for Bearer authentication header.
func NewClientWithBearerToken(host, basePath, scheme, bearerToken string) ClientService {
	transport := httptransport.New(host, basePath, []string{scheme})
	transport.DefaultAuthentication = httptransport.BearerToken(bearerToken)
	return &Client{transport: transport, formats: strfmt.Default}
}

/*
Client for secret service API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption may be used to customize the behavior of Client methods.
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	BulkCreateAppKVSecrets(params *BulkCreateAppKVSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BulkCreateAppKVSecretsOK, error)

	CreateApp(params *CreateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppOK, error)

	CreateAppDynamicSecret(params *CreateAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppDynamicSecretOK, error)

	CreateAppKVSecret(params *CreateAppKVSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppKVSecretOK, error)

	CreateAppRotatingSecret(params *CreateAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppRotatingSecretOK, error)

	CreateAwsDynamicSecret(params *CreateAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsDynamicSecretOK, error)

	CreateAwsIAMUserAccessKeyRotatingSecret(params *CreateAwsIAMUserAccessKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsIAMUserAccessKeyRotatingSecretOK, error)

	CreateAwsIntegration(params *CreateAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsIntegrationOK, error)

	CreateAzureApplicationPasswordRotatingSecret(params *CreateAzureApplicationPasswordRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureApplicationPasswordRotatingSecretOK, error)

	CreateAzureIntegration(params *CreateAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureIntegrationOK, error)

	CreateConfluentCloudAPIKeyRotatingSecret(params *CreateConfluentCloudAPIKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateConfluentCloudAPIKeyRotatingSecretOK, error)

	CreateConfluentIntegration(params *CreateConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateConfluentIntegrationOK, error)

	CreateGatewayPool(params *CreateGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGatewayPoolOK, error)

	CreateGcpDynamicSecret(params *CreateGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpDynamicSecretOK, error)

	CreateGcpIntegration(params *CreateGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpIntegrationOK, error)

	CreateGcpServiceAccountKeyRotatingSecret(params *CreateGcpServiceAccountKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpServiceAccountKeyRotatingSecretOK, error)

	CreateIntegration(params *CreateIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationOK, error)

	CreateMongoDBAtlasIntegration(params *CreateMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateMongoDBAtlasIntegrationOK, error)

	CreateMongoDBAtlasRotatingSecret(params *CreateMongoDBAtlasRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateMongoDBAtlasRotatingSecretOK, error)

	CreatePostgresIntegration(params *CreatePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePostgresIntegrationOK, error)

	CreatePostgresRotatingSecret(params *CreatePostgresRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePostgresRotatingSecretOK, error)

	CreateRandomIntegration(params *CreateRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRandomIntegrationOK, error)

	CreateRandomRotatingSecret(params *CreateRandomRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRandomRotatingSecretOK, error)

	CreateSync(params *CreateSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateSyncOK, error)

	CreateTwilioIntegration(params *CreateTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTwilioIntegrationOK, error)

	CreateTwilioRotatingSecret(params *CreateTwilioRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTwilioRotatingSecretOK, error)

	DeleteApp(params *DeleteAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppOK, error)

	DeleteAppSecret(params *DeleteAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretOK, error)

	DeleteAppSecretVersion(params *DeleteAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretVersionOK, error)

	DeleteAwsDynamicSecret(params *DeleteAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAwsDynamicSecretOK, error)

	DeleteAwsIntegration(params *DeleteAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAwsIntegrationOK, error)

	DeleteAzureIntegration(params *DeleteAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAzureIntegrationOK, error)

	DeleteConfluentIntegration(params *DeleteConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteConfluentIntegrationOK, error)

	DeleteGatewayPool(params *DeleteGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGatewayPoolOK, error)

	DeleteGcpDynamicSecret(params *DeleteGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGcpDynamicSecretOK, error)

	DeleteGcpIntegration(params *DeleteGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGcpIntegrationOK, error)

	DeleteIntegration(params *DeleteIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationOK, error)

	DeleteMongoDBAtlasIntegration(params *DeleteMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteMongoDBAtlasIntegrationOK, error)

	DeletePostgresIntegration(params *DeletePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeletePostgresIntegrationOK, error)

	DeleteRandomIntegration(params *DeleteRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteRandomIntegrationOK, error)

	DeleteSync(params *DeleteSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncOK, error)

	DeleteTwilioIntegration(params *DeleteTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteTwilioIntegrationOK, error)

	DescribeProvider(params *DescribeProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DescribeProviderOK, error)

	GetApp(params *GetAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppOK, error)

	GetAppDynamicSecret(params *GetAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppDynamicSecretOK, error)

	GetAppRotatingSecret(params *GetAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppRotatingSecretOK, error)

	GetAppSecret(params *GetAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretOK, error)

	GetAppSecretVersion(params *GetAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretVersionOK, error)

	GetAppSyncs(params *GetAppSyncsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSyncsOK, error)

	GetAwsDynamicSecret(params *GetAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsDynamicSecretOK, error)

	GetAwsIAMUserAccessKeyRotatingSecretConfig(params *GetAwsIAMUserAccessKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsIAMUserAccessKeyRotatingSecretConfigOK, error)

	GetAwsIntegration(params *GetAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsIntegrationOK, error)

	GetAzureApplicationPasswordRotatingSecretConfig(params *GetAzureApplicationPasswordRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAzureApplicationPasswordRotatingSecretConfigOK, error)

	GetAzureIntegration(params *GetAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAzureIntegrationOK, error)

	GetConfluentCloudAPIKeyRotatingSecretConfig(params *GetConfluentCloudAPIKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetConfluentCloudAPIKeyRotatingSecretConfigOK, error)

	GetConfluentIntegration(params *GetConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetConfluentIntegrationOK, error)

	GetGatewayPool(params *GetGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGatewayPoolOK, error)

	GetGatewayPoolCertificate(params *GetGatewayPoolCertificateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGatewayPoolCertificateOK, error)

	GetGcpDynamicSecret(params *GetGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpDynamicSecretOK, error)

	GetGcpIntegration(params *GetGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpIntegrationOK, error)

	GetGcpServiceAccountKeyRotatingSecretConfig(params *GetGcpServiceAccountKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpServiceAccountKeyRotatingSecretConfigOK, error)

	GetIntegration(params *GetIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationOK, error)

	GetMongoDBAtlasIntegration(params *GetMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetMongoDBAtlasIntegrationOK, error)

	GetMongoDBAtlasRotatingSecretConfig(params *GetMongoDBAtlasRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetMongoDBAtlasRotatingSecretConfigOK, error)

	GetOrganizationLockStatus(params *GetOrganizationLockStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetOrganizationLockStatusOK, error)

	GetPostgresIntegration(params *GetPostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetPostgresIntegrationOK, error)

	GetPostgresRotatingSecretConfig(params *GetPostgresRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetPostgresRotatingSecretConfigOK, error)

	GetProjectLockStatus(params *GetProjectLockStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetProjectLockStatusOK, error)

	GetRandomIntegration(params *GetRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRandomIntegrationOK, error)

	GetRandomRotatingSecretConfig(params *GetRandomRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRandomRotatingSecretConfigOK, error)

	GetRotatingSecretState(params *GetRotatingSecretStateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRotatingSecretStateOK, error)

	GetSync(params *GetSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncOK, error)

	GetTwilioIntegration(params *GetTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTwilioIntegrationOK, error)

	GetTwilioRotatingSecretConfig(params *GetTwilioRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTwilioRotatingSecretConfigOK, error)

	GetUsage(params *GetUsageParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsageOK, error)

	GetUsage2(params *GetUsage2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsage2OK, error)

	ListAppSecretVersions(params *ListAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretVersionsOK, error)

	ListAppSecrets(params *ListAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretsOK, error)

	ListApps(params *ListAppsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppsOK, error)

	ListAwsDynamicSecrets(params *ListAwsDynamicSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAwsDynamicSecretsOK, error)

	ListAwsIntegrations(params *ListAwsIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAwsIntegrationsOK, error)

	ListAzureIntegrations(params *ListAzureIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAzureIntegrationsOK, error)

	ListConfluentIntegrations(params *ListConfluentIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListConfluentIntegrationsOK, error)

	ListGatewayPoolGateways(params *ListGatewayPoolGatewaysParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolGatewaysOK, error)

	ListGatewayPoolIntegrations(params *ListGatewayPoolIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolIntegrationsOK, error)

	ListGatewayPools(params *ListGatewayPoolsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolsOK, error)

	ListGcpDynamicSecrets(params *ListGcpDynamicSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGcpDynamicSecretsOK, error)

	ListGcpIntegrations(params *ListGcpIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGcpIntegrationsOK, error)

	ListIntegrations(params *ListIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListIntegrationsOK, error)

	ListMongoDBAtlasIntegrations(params *ListMongoDBAtlasIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListMongoDBAtlasIntegrationsOK, error)

	ListOpenAppSecretVersions(params *ListOpenAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOpenAppSecretVersionsOK, error)

	ListPostgresIntegrations(params *ListPostgresIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListPostgresIntegrationsOK, error)

	ListProviders(params *ListProvidersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListProvidersOK, error)

	ListRandomIntegrations(params *ListRandomIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListRandomIntegrationsOK, error)

	ListSyncs(params *ListSyncsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncsOK, error)

	ListTwilioIntegrations(params *ListTwilioIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListTwilioIntegrationsOK, error)

	LockOrganization(params *LockOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LockOrganizationOK, error)

	LockProject(params *LockProjectParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LockProjectOK, error)

	OpenAppSecret(params *OpenAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretOK, error)

	OpenAppSecretByResourceName(params *OpenAppSecretByResourceNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretByResourceNameOK, error)

	OpenAppSecretVersion(params *OpenAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretVersionOK, error)

	OpenAppSecrets(params *OpenAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretsOK, error)

	PurgeAppAndSecrets(params *PurgeAppAndSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PurgeAppAndSecretsOK, error)

	RotateSecret(params *RotateSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RotateSecretOK, error)

	SetTier(params *SetTierParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SetTierOK, error)

	UnlockOrganization(params *UnlockOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnlockOrganizationOK, error)

	UnlockProject(params *UnlockProjectParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnlockProjectOK, error)

	UpdateApp(params *UpdateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppOK, error)

	UpdateAppDynamicSecret(params *UpdateAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppDynamicSecretOK, error)

	UpdateAppRotatingSecret(params *UpdateAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppRotatingSecretOK, error)

	UpdateAwsDynamicSecret(params *UpdateAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsDynamicSecretOK, error)

	UpdateAwsIAMUserAccessKeyRotatingSecret(params *UpdateAwsIAMUserAccessKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsIAMUserAccessKeyRotatingSecretOK, error)

	UpdateAwsIntegration(params *UpdateAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsIntegrationOK, error)

	UpdateAzureApplicationPasswordRotatingSecret(params *UpdateAzureApplicationPasswordRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAzureApplicationPasswordRotatingSecretOK, error)

	UpdateAzureIntegration(params *UpdateAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAzureIntegrationOK, error)

	UpdateConfluentCloudAPIKeyRotatingSecret(params *UpdateConfluentCloudAPIKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateConfluentCloudAPIKeyRotatingSecretOK, error)

	UpdateConfluentIntegration(params *UpdateConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateConfluentIntegrationOK, error)

	UpdateGatewayPool(params *UpdateGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGatewayPoolOK, error)

	UpdateGcpDynamicSecret(params *UpdateGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpDynamicSecretOK, error)

	UpdateGcpIntegration(params *UpdateGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpIntegrationOK, error)

	UpdateGcpServiceAccountKeyRotatingSecret(params *UpdateGcpServiceAccountKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpServiceAccountKeyRotatingSecretOK, error)

	UpdateIntegration(params *UpdateIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationOK, error)

	UpdateMongoDBAtlasIntegration(params *UpdateMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateMongoDBAtlasIntegrationOK, error)

	UpdateMongoDBAtlasRotatingSecret(params *UpdateMongoDBAtlasRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateMongoDBAtlasRotatingSecretOK, error)

	UpdatePostgresIntegration(params *UpdatePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdatePostgresIntegrationOK, error)

	UpdatePostgresRotatingSecret(params *UpdatePostgresRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdatePostgresRotatingSecretOK, error)

	UpdateRandomIntegration(params *UpdateRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateRandomIntegrationOK, error)

	UpdateRandomRotatingSecret(params *UpdateRandomRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateRandomRotatingSecretOK, error)

	UpdateTwilioIntegration(params *UpdateTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateTwilioIntegrationOK, error)

	UpdateTwilioRotatingSecret(params *UpdateTwilioRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateTwilioRotatingSecretOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
BulkCreateAppKVSecrets bulk create app k v secrets API
*/
func (a *Client) BulkCreateAppKVSecrets(params *BulkCreateAppKVSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BulkCreateAppKVSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBulkCreateAppKVSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "BulkCreateAppKVSecrets",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv:batch",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &BulkCreateAppKVSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*BulkCreateAppKVSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BulkCreateAppKVSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateApp create app API
*/
func (a *Client) CreateApp(params *CreateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateApp",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAppDynamicSecret create app dynamic secret API
*/
func (a *Client) CreateAppDynamicSecret(params *CreateAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAppDynamicSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAppKVSecret create app k v secret API
*/
func (a *Client) CreateAppKVSecret(params *CreateAppKVSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppKVSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppKVSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAppKVSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secret/kv",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppKVSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppKVSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppKVSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAppRotatingSecret create app rotating secret API
*/
func (a *Client) CreateAppRotatingSecret(params *CreateAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAppRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAppRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAppRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAppRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAppRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAppRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAwsDynamicSecret create aws dynamic secret API
*/
func (a *Client) CreateAwsDynamicSecret(params *CreateAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAwsDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAwsDynamicSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAwsDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAwsDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAwsDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAwsIAMUserAccessKeyRotatingSecret create aws i a m user access key rotating secret API
*/
func (a *Client) CreateAwsIAMUserAccessKeyRotatingSecret(params *CreateAwsIAMUserAccessKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsIAMUserAccessKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAwsIAMUserAccessKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAwsIAMUserAccessKeyRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/aws/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAwsIAMUserAccessKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAwsIAMUserAccessKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAwsIAMUserAccessKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAwsIntegration create aws integration API
*/
func (a *Client) CreateAwsIntegration(params *CreateAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAwsIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAwsIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAwsIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAwsIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAwsIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAwsIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAzureApplicationPasswordRotatingSecret create azure application password rotating secret API
*/
func (a *Client) CreateAzureApplicationPasswordRotatingSecret(params *CreateAzureApplicationPasswordRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureApplicationPasswordRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAzureApplicationPasswordRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAzureApplicationPasswordRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/azure/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAzureApplicationPasswordRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAzureApplicationPasswordRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAzureApplicationPasswordRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateAzureIntegration create azure integration API
*/
func (a *Client) CreateAzureIntegration(params *CreateAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateAzureIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateAzureIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateAzureIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateAzureIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateAzureIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateAzureIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateConfluentCloudAPIKeyRotatingSecret create confluent cloud Api key rotating secret API
*/
func (a *Client) CreateConfluentCloudAPIKeyRotatingSecret(params *CreateConfluentCloudAPIKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateConfluentCloudAPIKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateConfluentCloudAPIKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateConfluentCloudApiKeyRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/confluent/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateConfluentCloudAPIKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateConfluentCloudAPIKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateConfluentCloudAPIKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateConfluentIntegration create confluent integration API
*/
func (a *Client) CreateConfluentIntegration(params *CreateConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateConfluentIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateConfluentIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateConfluentIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateConfluentIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateConfluentIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateConfluentIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGatewayPool create gateway pool API
*/
func (a *Client) CreateGatewayPool(params *CreateGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGatewayPoolOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGatewayPoolParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGatewayPool",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGatewayPoolReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGatewayPoolOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGatewayPoolDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGcpDynamicSecret create gcp dynamic secret API
*/
func (a *Client) CreateGcpDynamicSecret(params *CreateGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGcpDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGcpDynamicSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/gcp/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGcpDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGcpDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGcpDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGcpIntegration create gcp integration API
*/
func (a *Client) CreateGcpIntegration(params *CreateGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGcpIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGcpIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGcpIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGcpIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGcpIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateGcpServiceAccountKeyRotatingSecret create gcp service account key rotating secret API
*/
func (a *Client) CreateGcpServiceAccountKeyRotatingSecret(params *CreateGcpServiceAccountKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateGcpServiceAccountKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateGcpServiceAccountKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateGcpServiceAccountKeyRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/gcp/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateGcpServiceAccountKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateGcpServiceAccountKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateGcpServiceAccountKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateIntegration create integration API
*/
func (a *Client) CreateIntegration(params *CreateIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateMongoDBAtlasIntegration create mongo d b atlas integration API
*/
func (a *Client) CreateMongoDBAtlasIntegration(params *CreateMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateMongoDBAtlasIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateMongoDBAtlasIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateMongoDBAtlasIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/mongodb-atlas/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateMongoDBAtlasIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateMongoDBAtlasIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateMongoDBAtlasIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateMongoDBAtlasRotatingSecret create mongo d b atlas rotating secret API
*/
func (a *Client) CreateMongoDBAtlasRotatingSecret(params *CreateMongoDBAtlasRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateMongoDBAtlasRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateMongoDBAtlasRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateMongoDBAtlasRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/mongodb-atlas/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateMongoDBAtlasRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateMongoDBAtlasRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateMongoDBAtlasRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreatePostgresIntegration create postgres integration API
*/
func (a *Client) CreatePostgresIntegration(params *CreatePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePostgresIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreatePostgresIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreatePostgresIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/postgres/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreatePostgresIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreatePostgresIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreatePostgresIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreatePostgresRotatingSecret create postgres rotating secret API
*/
func (a *Client) CreatePostgresRotatingSecret(params *CreatePostgresRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreatePostgresRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreatePostgresRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreatePostgresRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/postgres/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreatePostgresRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreatePostgresRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreatePostgresRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateRandomIntegration create random integration API
*/
func (a *Client) CreateRandomIntegration(params *CreateRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRandomIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRandomIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateRandomIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateRandomIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRandomIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateRandomIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateRandomRotatingSecret create random rotating secret API
*/
func (a *Client) CreateRandomRotatingSecret(params *CreateRandomRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateRandomRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateRandomRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateRandomRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/random/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateRandomRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateRandomRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateRandomRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateSync create sync API
*/
func (a *Client) CreateSync(params *CreateSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateSyncOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateSyncParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateSync",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateSyncReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateSyncOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateSyncDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateTwilioIntegration create twilio integration API
*/
func (a *Client) CreateTwilioIntegration(params *CreateTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTwilioIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateTwilioIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateTwilioIntegration",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateTwilioIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTwilioIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateTwilioIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
CreateTwilioRotatingSecret create twilio rotating secret API
*/
func (a *Client) CreateTwilioRotatingSecret(params *CreateTwilioRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*CreateTwilioRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewCreateTwilioRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "CreateTwilioRotatingSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/twilio/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &CreateTwilioRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*CreateTwilioRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*CreateTwilioRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteApp delete app API
*/
func (a *Client) DeleteApp(params *DeleteAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteApp",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAppSecret delete app secret API
*/
func (a *Client) DeleteAppSecret(params *DeleteAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAppSecret",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAppSecretVersion delete app secret version API
*/
func (a *Client) DeleteAppSecretVersion(params *DeleteAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAppSecretVersion",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAwsDynamicSecret delete aws dynamic secret API
*/
func (a *Client) DeleteAwsDynamicSecret(params *DeleteAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAwsDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAwsDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAwsDynamicSecret",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAwsDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAwsDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAwsDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAwsIntegration delete aws integration API
*/
func (a *Client) DeleteAwsIntegration(params *DeleteAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAwsIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAwsIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAwsIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAwsIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAwsIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAwsIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteAzureIntegration delete azure integration API
*/
func (a *Client) DeleteAzureIntegration(params *DeleteAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteAzureIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteAzureIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteAzureIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteAzureIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteAzureIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteAzureIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteConfluentIntegration delete confluent integration API
*/
func (a *Client) DeleteConfluentIntegration(params *DeleteConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteConfluentIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteConfluentIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteConfluentIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteConfluentIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteConfluentIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteConfluentIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteGatewayPool delete gateway pool API
*/
func (a *Client) DeleteGatewayPool(params *DeleteGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGatewayPoolOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteGatewayPoolParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteGatewayPool",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteGatewayPoolReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteGatewayPoolOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteGatewayPoolDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteGcpDynamicSecret delete gcp dynamic secret API
*/
func (a *Client) DeleteGcpDynamicSecret(params *DeleteGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGcpDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteGcpDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteGcpDynamicSecret",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/gcp/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteGcpDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteGcpDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteGcpDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteGcpIntegration delete gcp integration API
*/
func (a *Client) DeleteGcpIntegration(params *DeleteGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteGcpIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteGcpIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteGcpIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteGcpIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteGcpIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteGcpIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteIntegration delete integration API
*/
func (a *Client) DeleteIntegration(params *DeleteIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteMongoDBAtlasIntegration delete mongo d b atlas integration API
*/
func (a *Client) DeleteMongoDBAtlasIntegration(params *DeleteMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteMongoDBAtlasIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteMongoDBAtlasIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteMongoDBAtlasIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/mongodb-atlas/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteMongoDBAtlasIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteMongoDBAtlasIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteMongoDBAtlasIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeletePostgresIntegration delete postgres integration API
*/
func (a *Client) DeletePostgresIntegration(params *DeletePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeletePostgresIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeletePostgresIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeletePostgresIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/postgres/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeletePostgresIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeletePostgresIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeletePostgresIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteRandomIntegration delete random integration API
*/
func (a *Client) DeleteRandomIntegration(params *DeleteRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteRandomIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteRandomIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteRandomIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteRandomIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteRandomIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteRandomIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteSync delete sync API
*/
func (a *Client) DeleteSync(params *DeleteSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteSyncOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteSyncParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteSync",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteSyncReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteSyncOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteSyncDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DeleteTwilioIntegration delete twilio integration API
*/
func (a *Client) DeleteTwilioIntegration(params *DeleteTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DeleteTwilioIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDeleteTwilioIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DeleteTwilioIntegration",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DeleteTwilioIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DeleteTwilioIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DeleteTwilioIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
DescribeProvider describe provider API
*/
func (a *Client) DescribeProvider(params *DescribeProviderParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*DescribeProviderOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewDescribeProviderParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "DescribeProvider",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/providers/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &DescribeProviderReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*DescribeProviderOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*DescribeProviderDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetApp get app API
*/
func (a *Client) GetApp(params *GetAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetApp",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppDynamicSecret get app dynamic secret API
*/
func (a *Client) GetAppDynamicSecret(params *GetAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppDynamicSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppRotatingSecret get app rotating secret API
*/
func (a *Client) GetAppRotatingSecret(params *GetAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppRotatingSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppSecret get app secret API
*/
func (a *Client) GetAppSecret(params *GetAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppSecretVersion get app secret version API
*/
func (a *Client) GetAppSecretVersion(params *GetAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppSecretVersion",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAppSyncs ps r e v i e w u n s t a b l e
*/
func (a *Client) GetAppSyncs(params *GetAppSyncsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAppSyncsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAppSyncsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAppSyncs",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}/syncs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAppSyncsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAppSyncsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAppSyncsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAwsDynamicSecret get aws dynamic secret API
*/
func (a *Client) GetAwsDynamicSecret(params *GetAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAwsDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAwsDynamicSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAwsDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAwsDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAwsDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAwsIAMUserAccessKeyRotatingSecretConfig get aws i a m user access key rotating secret config API
*/
func (a *Client) GetAwsIAMUserAccessKeyRotatingSecretConfig(params *GetAwsIAMUserAccessKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsIAMUserAccessKeyRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAwsIAMUserAccessKeyRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAwsIAMUserAccessKeyRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/aws/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAwsIAMUserAccessKeyRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAwsIAMUserAccessKeyRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAwsIAMUserAccessKeyRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAwsIntegration get aws integration API
*/
func (a *Client) GetAwsIntegration(params *GetAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAwsIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAwsIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAwsIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAwsIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAwsIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAwsIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAzureApplicationPasswordRotatingSecretConfig get azure application password rotating secret config API
*/
func (a *Client) GetAzureApplicationPasswordRotatingSecretConfig(params *GetAzureApplicationPasswordRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAzureApplicationPasswordRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAzureApplicationPasswordRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAzureApplicationPasswordRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/azure/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAzureApplicationPasswordRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAzureApplicationPasswordRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAzureApplicationPasswordRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetAzureIntegration get azure integration API
*/
func (a *Client) GetAzureIntegration(params *GetAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetAzureIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetAzureIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetAzureIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetAzureIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetAzureIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetAzureIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetConfluentCloudAPIKeyRotatingSecretConfig get confluent cloud Api key rotating secret config API
*/
func (a *Client) GetConfluentCloudAPIKeyRotatingSecretConfig(params *GetConfluentCloudAPIKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetConfluentCloudAPIKeyRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetConfluentCloudAPIKeyRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetConfluentCloudApiKeyRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/confluent/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetConfluentCloudAPIKeyRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetConfluentCloudAPIKeyRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetConfluentCloudAPIKeyRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetConfluentIntegration get confluent integration API
*/
func (a *Client) GetConfluentIntegration(params *GetConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetConfluentIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetConfluentIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetConfluentIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetConfluentIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetConfluentIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetConfluentIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGatewayPool get gateway pool API
*/
func (a *Client) GetGatewayPool(params *GetGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGatewayPoolOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGatewayPoolParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGatewayPool",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGatewayPoolReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGatewayPoolOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGatewayPoolDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGatewayPoolCertificate get gateway pool certificate API
*/
func (a *Client) GetGatewayPoolCertificate(params *GetGatewayPoolCertificateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGatewayPoolCertificateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGatewayPoolCertificateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGatewayPoolCertificate",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/certificate",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGatewayPoolCertificateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGatewayPoolCertificateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGatewayPoolCertificateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGcpDynamicSecret get gcp dynamic secret API
*/
func (a *Client) GetGcpDynamicSecret(params *GetGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGcpDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGcpDynamicSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/gcp/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGcpDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGcpDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGcpDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGcpIntegration get gcp integration API
*/
func (a *Client) GetGcpIntegration(params *GetGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGcpIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGcpIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGcpIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGcpIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGcpIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetGcpServiceAccountKeyRotatingSecretConfig get gcp service account key rotating secret config API
*/
func (a *Client) GetGcpServiceAccountKeyRotatingSecretConfig(params *GetGcpServiceAccountKeyRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetGcpServiceAccountKeyRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetGcpServiceAccountKeyRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetGcpServiceAccountKeyRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/gcp/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetGcpServiceAccountKeyRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetGcpServiceAccountKeyRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetGcpServiceAccountKeyRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetIntegration get integration API
*/
func (a *Client) GetIntegration(params *GetIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetMongoDBAtlasIntegration get mongo d b atlas integration API
*/
func (a *Client) GetMongoDBAtlasIntegration(params *GetMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetMongoDBAtlasIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetMongoDBAtlasIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMongoDBAtlasIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/mongodb-atlas/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetMongoDBAtlasIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMongoDBAtlasIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetMongoDBAtlasIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetMongoDBAtlasRotatingSecretConfig get mongo d b atlas rotating secret config API
*/
func (a *Client) GetMongoDBAtlasRotatingSecretConfig(params *GetMongoDBAtlasRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetMongoDBAtlasRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetMongoDBAtlasRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetMongoDBAtlasRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/mongodb-atlas/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetMongoDBAtlasRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetMongoDBAtlasRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetMongoDBAtlasRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetOrganizationLockStatus get organization lock status API
*/
func (a *Client) GetOrganizationLockStatus(params *GetOrganizationLockStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetOrganizationLockStatusOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetOrganizationLockStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetOrganizationLockStatus",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/lock-status",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetOrganizationLockStatusReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetOrganizationLockStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetOrganizationLockStatusDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetPostgresIntegration get postgres integration API
*/
func (a *Client) GetPostgresIntegration(params *GetPostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetPostgresIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPostgresIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetPostgresIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/postgres/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetPostgresIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPostgresIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetPostgresIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetPostgresRotatingSecretConfig get postgres rotating secret config API
*/
func (a *Client) GetPostgresRotatingSecretConfig(params *GetPostgresRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetPostgresRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetPostgresRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetPostgresRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/postgres/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetPostgresRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetPostgresRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetPostgresRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetProjectLockStatus get project lock status API
*/
func (a *Client) GetProjectLockStatus(params *GetProjectLockStatusParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetProjectLockStatusOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetProjectLockStatusParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetProjectLockStatus",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock-status",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetProjectLockStatusReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetProjectLockStatusOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetProjectLockStatusDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetRandomIntegration get random integration API
*/
func (a *Client) GetRandomIntegration(params *GetRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRandomIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRandomIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetRandomIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRandomIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRandomIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetRandomIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetRandomRotatingSecretConfig get random rotating secret config API
*/
func (a *Client) GetRandomRotatingSecretConfig(params *GetRandomRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRandomRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRandomRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetRandomRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/random/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRandomRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRandomRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetRandomRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetRotatingSecretState get rotating secret state API
*/
func (a *Client) GetRotatingSecretState(params *GetRotatingSecretStateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetRotatingSecretStateOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetRotatingSecretStateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetRotatingSecretState",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}/rotation-state",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetRotatingSecretStateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetRotatingSecretStateOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetRotatingSecretStateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetSync get sync API
*/
func (a *Client) GetSync(params *GetSyncParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetSyncOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetSyncParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetSync",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetSyncReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetSyncOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetSyncDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetTwilioIntegration get twilio integration API
*/
func (a *Client) GetTwilioIntegration(params *GetTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTwilioIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTwilioIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTwilioIntegration",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetTwilioIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTwilioIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetTwilioIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetTwilioRotatingSecretConfig get twilio rotating secret config API
*/
func (a *Client) GetTwilioRotatingSecretConfig(params *GetTwilioRotatingSecretConfigParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetTwilioRotatingSecretConfigOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetTwilioRotatingSecretConfigParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetTwilioRotatingSecretConfig",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/twilio/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetTwilioRotatingSecretConfigReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetTwilioRotatingSecretConfigOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetTwilioRotatingSecretConfigDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetUsage get usage API
*/
func (a *Client) GetUsage(params *GetUsageParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsageOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUsageParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetUsage",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/usage",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetUsageReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUsageOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetUsageDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
GetUsage2 get usage2 API
*/
func (a *Client) GetUsage2(params *GetUsage2Params, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*GetUsage2OK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewGetUsage2Params()
	}
	op := &runtime.ClientOperation{
		ID:                 "GetUsage2",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/usage",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &GetUsage2Reader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*GetUsage2OK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*GetUsage2Default)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAppSecretVersions list app secret versions API
*/
func (a *Client) ListAppSecretVersions(params *ListAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppSecretVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAppSecretVersions",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppSecretVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppSecretVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppSecretVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAppSecrets list app secrets API
*/
func (a *Client) ListAppSecrets(params *ListAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAppSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListApps list apps API
*/
func (a *Client) ListApps(params *ListAppsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAppsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAppsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListApps",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAppsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAppsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAppsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAwsDynamicSecrets list aws dynamic secrets API
*/
func (a *Client) ListAwsDynamicSecrets(params *ListAwsDynamicSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAwsDynamicSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAwsDynamicSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAwsDynamicSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAwsDynamicSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAwsDynamicSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAwsDynamicSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAwsIntegrations list aws integrations API
*/
func (a *Client) ListAwsIntegrations(params *ListAwsIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAwsIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAwsIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAwsIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAwsIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAwsIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAwsIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListAzureIntegrations list azure integrations API
*/
func (a *Client) ListAzureIntegrations(params *ListAzureIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListAzureIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListAzureIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListAzureIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListAzureIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListAzureIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListAzureIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListConfluentIntegrations list confluent integrations API
*/
func (a *Client) ListConfluentIntegrations(params *ListConfluentIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListConfluentIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListConfluentIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListConfluentIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListConfluentIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListConfluentIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListConfluentIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGatewayPoolGateways list gateway pool gateways API
*/
func (a *Client) ListGatewayPoolGateways(params *ListGatewayPoolGatewaysParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolGatewaysOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGatewayPoolGatewaysParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGatewayPoolGateways",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/gateways",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGatewayPoolGatewaysReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGatewayPoolGatewaysOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGatewayPoolGatewaysDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGatewayPoolIntegrations list gateway pool integrations API
*/
func (a *Client) ListGatewayPoolIntegrations(params *ListGatewayPoolIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGatewayPoolIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGatewayPoolIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}/integrations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGatewayPoolIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGatewayPoolIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGatewayPoolIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGatewayPools list gateway pools API
*/
func (a *Client) ListGatewayPools(params *ListGatewayPoolsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGatewayPoolsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGatewayPoolsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGatewayPools",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGatewayPoolsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGatewayPoolsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGatewayPoolsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGcpDynamicSecrets list gcp dynamic secrets API
*/
func (a *Client) ListGcpDynamicSecrets(params *ListGcpDynamicSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGcpDynamicSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGcpDynamicSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGcpDynamicSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/gcp/secret",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGcpDynamicSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGcpDynamicSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGcpDynamicSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListGcpIntegrations list gcp integrations API
*/
func (a *Client) ListGcpIntegrations(params *ListGcpIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListGcpIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListGcpIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListGcpIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListGcpIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListGcpIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListGcpIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListIntegrations list integrations API
*/
func (a *Client) ListIntegrations(params *ListIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListMongoDBAtlasIntegrations list mongo d b atlas integrations API
*/
func (a *Client) ListMongoDBAtlasIntegrations(params *ListMongoDBAtlasIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListMongoDBAtlasIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListMongoDBAtlasIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListMongoDBAtlasIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/mongodb-atlas/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListMongoDBAtlasIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListMongoDBAtlasIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListMongoDBAtlasIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListOpenAppSecretVersions list open app secret versions API
*/
func (a *Client) ListOpenAppSecretVersions(params *ListOpenAppSecretVersionsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListOpenAppSecretVersionsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListOpenAppSecretVersionsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListOpenAppSecretVersions",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions:open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListOpenAppSecretVersionsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListOpenAppSecretVersionsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListOpenAppSecretVersionsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListPostgresIntegrations list postgres integrations API
*/
func (a *Client) ListPostgresIntegrations(params *ListPostgresIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListPostgresIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListPostgresIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListPostgresIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/postgres/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListPostgresIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListPostgresIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListPostgresIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListProviders list providers API
*/
func (a *Client) ListProviders(params *ListProvidersParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListProvidersOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListProvidersParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListProviders",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/providers",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListProvidersReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListProvidersOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListProvidersDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListRandomIntegrations list random integrations API
*/
func (a *Client) ListRandomIntegrations(params *ListRandomIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListRandomIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListRandomIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListRandomIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListRandomIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListRandomIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListRandomIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListSyncs list syncs API
*/
func (a *Client) ListSyncs(params *ListSyncsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListSyncsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListSyncsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListSyncs",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/syncs",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListSyncsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListSyncsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListSyncsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
ListTwilioIntegrations list twilio integrations API
*/
func (a *Client) ListTwilioIntegrations(params *ListTwilioIntegrationsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*ListTwilioIntegrationsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewListTwilioIntegrationsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ListTwilioIntegrations",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &ListTwilioIntegrationsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*ListTwilioIntegrationsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*ListTwilioIntegrationsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LockOrganization lock organization API
*/
func (a *Client) LockOrganization(params *LockOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LockOrganizationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLockOrganizationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LockOrganization",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/lock",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LockOrganizationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LockOrganizationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LockOrganizationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
LockProject lock project API
*/
func (a *Client) LockProject(params *LockProjectParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*LockProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewLockProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "LockProject",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/lock",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &LockProjectReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*LockProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*LockProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecret open app secret API
*/
func (a *Client) OpenAppSecret(params *OpenAppSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecret",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}:open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecretByResourceName open app secret by resource name API
*/
func (a *Client) OpenAppSecretByResourceName(params *OpenAppSecretByResourceNameParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretByResourceNameOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretByResourceNameParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecretByResourceName",
		Method:             "GET",
		PathPattern:        "/2023-11-28/{resource_name}:open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretByResourceNameReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretByResourceNameOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretByResourceNameDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecretVersion open app secret version API
*/
func (a *Client) OpenAppSecretVersion(params *OpenAppSecretVersionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretVersionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretVersionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecretVersion",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{secret_name}/versions/{version}:open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretVersionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretVersionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretVersionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
OpenAppSecrets open app secrets API
*/
func (a *Client) OpenAppSecrets(params *OpenAppSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*OpenAppSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewOpenAppSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "OpenAppSecrets",
		Method:             "GET",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets:open",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &OpenAppSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*OpenAppSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*OpenAppSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PurgeAppAndSecrets purge app and secrets API
*/
func (a *Client) PurgeAppAndSecrets(params *PurgeAppAndSecretsParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PurgeAppAndSecretsOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPurgeAppAndSecretsParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "PurgeAppAndSecrets",
		Method:             "DELETE",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}:purge",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &PurgeAppAndSecretsReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PurgeAppAndSecretsOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PurgeAppAndSecretsDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
RotateSecret rotate secret API
*/
func (a *Client) RotateSecret(params *RotateSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*RotateSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewRotateSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "RotateSecret",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/{name}:rotate",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &RotateSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*RotateSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*RotateSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SetTier set tier API
*/
func (a *Client) SetTier(params *SetTierParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SetTierOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSetTierParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "SetTier",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/billing/tier",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &SetTierReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SetTierOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SetTierDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnlockOrganization unlock organization API
*/
func (a *Client) UnlockOrganization(params *UnlockOrganizationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnlockOrganizationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnlockOrganizationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UnlockOrganization",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/unlock",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UnlockOrganizationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnlockOrganizationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnlockOrganizationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UnlockProject unlock project API
*/
func (a *Client) UnlockProject(params *UnlockProjectParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UnlockProjectOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUnlockProjectParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UnlockProject",
		Method:             "POST",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/unlock",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UnlockProjectReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UnlockProjectOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UnlockProjectDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateApp update app API
*/
func (a *Client) UpdateApp(params *UpdateAppParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAppParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateApp",
		Method:             "PATCH",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAppReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAppOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAppDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAppDynamicSecret update app dynamic secret API
*/
func (a *Client) UpdateAppDynamicSecret(params *UpdateAppDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAppDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAppDynamicSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/dynamic/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAppDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAppDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAppDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAppRotatingSecret update app rotating secret API
*/
func (a *Client) UpdateAppRotatingSecret(params *UpdateAppRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAppRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAppRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAppRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/secrets/rotating/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAppRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAppRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAppRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAwsDynamicSecret update aws dynamic secret API
*/
func (a *Client) UpdateAwsDynamicSecret(params *UpdateAwsDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAwsDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAwsDynamicSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/aws/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAwsDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAwsDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAwsDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAwsIAMUserAccessKeyRotatingSecret update aws i a m user access key rotating secret API
*/
func (a *Client) UpdateAwsIAMUserAccessKeyRotatingSecret(params *UpdateAwsIAMUserAccessKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsIAMUserAccessKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAwsIAMUserAccessKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAwsIAMUserAccessKeyRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/aws/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAwsIAMUserAccessKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAwsIAMUserAccessKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAwsIAMUserAccessKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAwsIntegration update aws integration API
*/
func (a *Client) UpdateAwsIntegration(params *UpdateAwsIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAwsIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAwsIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAwsIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/aws/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAwsIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAwsIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAwsIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAzureApplicationPasswordRotatingSecret update azure application password rotating secret API
*/
func (a *Client) UpdateAzureApplicationPasswordRotatingSecret(params *UpdateAzureApplicationPasswordRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAzureApplicationPasswordRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAzureApplicationPasswordRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAzureApplicationPasswordRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/azure/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAzureApplicationPasswordRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAzureApplicationPasswordRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAzureApplicationPasswordRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateAzureIntegration update azure integration API
*/
func (a *Client) UpdateAzureIntegration(params *UpdateAzureIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateAzureIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateAzureIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateAzureIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/azure/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateAzureIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateAzureIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateAzureIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateConfluentCloudAPIKeyRotatingSecret update confluent cloud Api key rotating secret API
*/
func (a *Client) UpdateConfluentCloudAPIKeyRotatingSecret(params *UpdateConfluentCloudAPIKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateConfluentCloudAPIKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateConfluentCloudAPIKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateConfluentCloudApiKeyRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/confluent/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateConfluentCloudAPIKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateConfluentCloudAPIKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateConfluentCloudAPIKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateConfluentIntegration update confluent integration API
*/
func (a *Client) UpdateConfluentIntegration(params *UpdateConfluentIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateConfluentIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateConfluentIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateConfluentIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateConfluentIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateConfluentIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateConfluentIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateGatewayPool update gateway pool API
*/
func (a *Client) UpdateGatewayPool(params *UpdateGatewayPoolParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGatewayPoolOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateGatewayPoolParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateGatewayPool",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/gateway-pools/{gateway_pool_name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateGatewayPoolReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateGatewayPoolOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateGatewayPoolDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateGcpDynamicSecret update gcp dynamic secret API
*/
func (a *Client) UpdateGcpDynamicSecret(params *UpdateGcpDynamicSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpDynamicSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateGcpDynamicSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateGcpDynamicSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/dynamic/gcp/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateGcpDynamicSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateGcpDynamicSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateGcpDynamicSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateGcpIntegration update gcp integration API
*/
func (a *Client) UpdateGcpIntegration(params *UpdateGcpIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateGcpIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateGcpIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/gcp/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateGcpIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateGcpIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateGcpIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateGcpServiceAccountKeyRotatingSecret update gcp service account key rotating secret API
*/
func (a *Client) UpdateGcpServiceAccountKeyRotatingSecret(params *UpdateGcpServiceAccountKeyRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateGcpServiceAccountKeyRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateGcpServiceAccountKeyRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateGcpServiceAccountKeyRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/gcp/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateGcpServiceAccountKeyRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateGcpServiceAccountKeyRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateGcpServiceAccountKeyRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateIntegration update integration API
*/
func (a *Client) UpdateIntegration(params *UpdateIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateMongoDBAtlasIntegration update mongo d b atlas integration API
*/
func (a *Client) UpdateMongoDBAtlasIntegration(params *UpdateMongoDBAtlasIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateMongoDBAtlasIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateMongoDBAtlasIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateMongoDBAtlasIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/mongodb-atlas/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateMongoDBAtlasIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateMongoDBAtlasIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateMongoDBAtlasIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateMongoDBAtlasRotatingSecret update mongo d b atlas rotating secret API
*/
func (a *Client) UpdateMongoDBAtlasRotatingSecret(params *UpdateMongoDBAtlasRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateMongoDBAtlasRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateMongoDBAtlasRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateMongoDBAtlasRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/mongodb-atlas/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateMongoDBAtlasRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateMongoDBAtlasRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateMongoDBAtlasRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdatePostgresIntegration update postgres integration API
*/
func (a *Client) UpdatePostgresIntegration(params *UpdatePostgresIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdatePostgresIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdatePostgresIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdatePostgresIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/postgres/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdatePostgresIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdatePostgresIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdatePostgresIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdatePostgresRotatingSecret update postgres rotating secret API
*/
func (a *Client) UpdatePostgresRotatingSecret(params *UpdatePostgresRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdatePostgresRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdatePostgresRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdatePostgresRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/postgres/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdatePostgresRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdatePostgresRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdatePostgresRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateRandomIntegration update random integration API
*/
func (a *Client) UpdateRandomIntegration(params *UpdateRandomIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateRandomIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRandomIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateRandomIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/random/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateRandomIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRandomIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateRandomIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateRandomRotatingSecret update random rotating secret API
*/
func (a *Client) UpdateRandomRotatingSecret(params *UpdateRandomRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateRandomRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateRandomRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateRandomRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/random/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateRandomRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateRandomRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateRandomRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateTwilioIntegration update twilio integration API
*/
func (a *Client) UpdateTwilioIntegration(params *UpdateTwilioIntegrationParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateTwilioIntegrationOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateTwilioIntegrationParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateTwilioIntegration",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/twilio/config/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateTwilioIntegrationReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTwilioIntegrationOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateTwilioIntegrationDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
UpdateTwilioRotatingSecret update twilio rotating secret API
*/
func (a *Client) UpdateTwilioRotatingSecret(params *UpdateTwilioRotatingSecretParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*UpdateTwilioRotatingSecretOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewUpdateTwilioRotatingSecretParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "UpdateTwilioRotatingSecret",
		Method:             "PUT",
		PathPattern:        "/secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/apps/{app_name}/rotating/twilio/secret/{name}",
		ProducesMediaTypes: []string{"application/json"},
		ConsumesMediaTypes: []string{"application/json"},
		Schemes:            []string{"http"},
		Params:             params,
		Reader:             &UpdateTwilioRotatingSecretReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*UpdateTwilioRotatingSecretOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*UpdateTwilioRotatingSecretDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
