// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UpdateConfluentIntegrationReader is a Reader for the UpdateConfluentIntegration structure.
type UpdateConfluentIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateConfluentIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateConfluentIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateConfluentIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateConfluentIntegrationOK creates a UpdateConfluentIntegrationOK with default headers values
func NewUpdateConfluentIntegrationOK() *UpdateConfluentIntegrationOK {
	return &UpdateConfluentIntegrationOK{}
}

/*
UpdateConfluentIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateConfluentIntegrationOK struct {
	Payload *models.Secrets20231128UpdateConfluentIntegrationResponse
}

// IsSuccess returns true when this update confluent integration o k response has a 2xx status code
func (o *UpdateConfluentIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update confluent integration o k response has a 3xx status code
func (o *UpdateConfluentIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update confluent integration o k response has a 4xx status code
func (o *UpdateConfluentIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update confluent integration o k response has a 5xx status code
func (o *UpdateConfluentIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update confluent integration o k response a status code equal to that given
func (o *UpdateConfluentIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update confluent integration o k response
func (o *UpdateConfluentIntegrationOK) Code() int {
	return 200
}

func (o *UpdateConfluentIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] updateConfluentIntegrationOK %s", 200, payload)
}

func (o *UpdateConfluentIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] updateConfluentIntegrationOK %s", 200, payload)
}

func (o *UpdateConfluentIntegrationOK) GetPayload() *models.Secrets20231128UpdateConfluentIntegrationResponse {
	return o.Payload
}

func (o *UpdateConfluentIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128UpdateConfluentIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateConfluentIntegrationDefault creates a UpdateConfluentIntegrationDefault with default headers values
func NewUpdateConfluentIntegrationDefault(code int) *UpdateConfluentIntegrationDefault {
	return &UpdateConfluentIntegrationDefault{
		_statusCode: code,
	}
}

/*
UpdateConfluentIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateConfluentIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this update confluent integration default response has a 2xx status code
func (o *UpdateConfluentIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update confluent integration default response has a 3xx status code
func (o *UpdateConfluentIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update confluent integration default response has a 4xx status code
func (o *UpdateConfluentIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update confluent integration default response has a 5xx status code
func (o *UpdateConfluentIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update confluent integration default response a status code equal to that given
func (o *UpdateConfluentIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update confluent integration default response
func (o *UpdateConfluentIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *UpdateConfluentIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] UpdateConfluentIntegration default %s", o._statusCode, payload)
}

func (o *UpdateConfluentIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/confluent/config/{name}][%d] UpdateConfluentIntegration default %s", o._statusCode, payload)
}

func (o *UpdateConfluentIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UpdateConfluentIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
