// Code generated by go-swagger; DO NOT EDIT.

package secret_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-secrets/stable/2023-11-28/models"
)

// UpdateIntegrationReader is a Reader for the UpdateIntegration structure.
type UpdateIntegrationReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *UpdateIntegrationReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewUpdateIntegrationOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewUpdateIntegrationDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewUpdateIntegrationOK creates a UpdateIntegrationOK with default headers values
func NewUpdateIntegrationOK() *UpdateIntegrationOK {
	return &UpdateIntegrationOK{}
}

/*
UpdateIntegrationOK describes a response with status code 200, with default header values.

A successful response.
*/
type UpdateIntegrationOK struct {
	Payload *models.Secrets20231128UpdateIntegrationResponse
}

// IsSuccess returns true when this update integration o k response has a 2xx status code
func (o *UpdateIntegrationOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this update integration o k response has a 3xx status code
func (o *UpdateIntegrationOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this update integration o k response has a 4xx status code
func (o *UpdateIntegrationOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this update integration o k response has a 5xx status code
func (o *UpdateIntegrationOK) IsServerError() bool {
	return false
}

// IsCode returns true when this update integration o k response a status code equal to that given
func (o *UpdateIntegrationOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the update integration o k response
func (o *UpdateIntegrationOK) Code() int {
	return 200
}

func (o *UpdateIntegrationOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] updateIntegrationOK %s", 200, payload)
}

func (o *UpdateIntegrationOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] updateIntegrationOK %s", 200, payload)
}

func (o *UpdateIntegrationOK) GetPayload() *models.Secrets20231128UpdateIntegrationResponse {
	return o.Payload
}

func (o *UpdateIntegrationOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Secrets20231128UpdateIntegrationResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewUpdateIntegrationDefault creates a UpdateIntegrationDefault with default headers values
func NewUpdateIntegrationDefault(code int) *UpdateIntegrationDefault {
	return &UpdateIntegrationDefault{
		_statusCode: code,
	}
}

/*
UpdateIntegrationDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type UpdateIntegrationDefault struct {
	_statusCode int

	Payload *models.GooglerpcStatus
}

// IsSuccess returns true when this update integration default response has a 2xx status code
func (o *UpdateIntegrationDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this update integration default response has a 3xx status code
func (o *UpdateIntegrationDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this update integration default response has a 4xx status code
func (o *UpdateIntegrationDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this update integration default response has a 5xx status code
func (o *UpdateIntegrationDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this update integration default response a status code equal to that given
func (o *UpdateIntegrationDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the update integration default response
func (o *UpdateIntegrationDefault) Code() int {
	return o._statusCode
}

func (o *UpdateIntegrationDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] UpdateIntegration default %s", o._statusCode, payload)
}

func (o *UpdateIntegrationDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PUT /secrets/2023-11-28/organizations/{organization_id}/projects/{project_id}/integrations/{name}][%d] UpdateIntegration default %s", o._statusCode, payload)
}

func (o *UpdateIntegrationDefault) GetPayload() *models.GooglerpcStatus {
	return o.Payload
}

func (o *UpdateIntegrationDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.GooglerpcStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
