// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewWaypointServiceDeleteAddOnDefinitionParams creates a new WaypointServiceDeleteAddOnDefinitionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewWaypointServiceDeleteAddOnDefinitionParams() *WaypointServiceDeleteAddOnDefinitionParams {
	return &WaypointServiceDeleteAddOnDefinitionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewWaypointServiceDeleteAddOnDefinitionParamsWithTimeout creates a new WaypointServiceDeleteAddOnDefinitionParams object
// with the ability to set a timeout on a request.
func NewWaypointServiceDeleteAddOnDefinitionParamsWithTimeout(timeout time.Duration) *WaypointServiceDeleteAddOnDefinitionParams {
	return &WaypointServiceDeleteAddOnDefinitionParams{
		timeout: timeout,
	}
}

// NewWaypointServiceDeleteAddOnDefinitionParamsWithContext creates a new WaypointServiceDeleteAddOnDefinitionParams object
// with the ability to set a context for a request.
func NewWaypointServiceDeleteAddOnDefinitionParamsWithContext(ctx context.Context) *WaypointServiceDeleteAddOnDefinitionParams {
	return &WaypointServiceDeleteAddOnDefinitionParams{
		Context: ctx,
	}
}

// NewWaypointServiceDeleteAddOnDefinitionParamsWithHTTPClient creates a new WaypointServiceDeleteAddOnDefinitionParams object
// with the ability to set a custom HTTPClient for a request.
func NewWaypointServiceDeleteAddOnDefinitionParamsWithHTTPClient(client *http.Client) *WaypointServiceDeleteAddOnDefinitionParams {
	return &WaypointServiceDeleteAddOnDefinitionParams{
		HTTPClient: client,
	}
}

/*
WaypointServiceDeleteAddOnDefinitionParams contains all the parameters to send to the API endpoint

	for the waypoint service delete add on definition operation.

	Typically these are written to a http.Request.
*/
type WaypointServiceDeleteAddOnDefinitionParams struct {

	// AddOnDefinitionID.
	AddOnDefinitionID string

	// AddOnDefinitionName.
	AddOnDefinitionName *string

	// NamespaceID.
	NamespaceID string

	/* NamespaceLocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	NamespaceLocationOrganizationID *string

	/* NamespaceLocationProjectID.

	   project_id is the projects id.
	*/
	NamespaceLocationProjectID *string

	/* NamespaceLocationRegionProvider.

	   provider is the named cloud provider ("aws", "gcp", "azure")
	*/
	NamespaceLocationRegionProvider *string

	/* NamespaceLocationRegionRegion.

	   region is the cloud region ("us-west1", "us-east1")
	*/
	NamespaceLocationRegionRegion *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the waypoint service delete add on definition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithDefaults() *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the waypoint service delete add on definition params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithTimeout(timeout time.Duration) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithContext(ctx context.Context) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithHTTPClient(client *http.Client) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddOnDefinitionID adds the addOnDefinitionID to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithAddOnDefinitionID(addOnDefinitionID string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetAddOnDefinitionID(addOnDefinitionID)
	return o
}

// SetAddOnDefinitionID adds the addOnDefinitionId to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetAddOnDefinitionID(addOnDefinitionID string) {
	o.AddOnDefinitionID = addOnDefinitionID
}

// WithAddOnDefinitionName adds the addOnDefinitionName to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithAddOnDefinitionName(addOnDefinitionName *string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetAddOnDefinitionName(addOnDefinitionName)
	return o
}

// SetAddOnDefinitionName adds the addOnDefinitionName to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetAddOnDefinitionName(addOnDefinitionName *string) {
	o.AddOnDefinitionName = addOnDefinitionName
}

// WithNamespaceID adds the namespaceID to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithNamespaceID(namespaceID string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetNamespaceID(namespaceID)
	return o
}

// SetNamespaceID adds the namespaceId to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetNamespaceID(namespaceID string) {
	o.NamespaceID = namespaceID
}

// WithNamespaceLocationOrganizationID adds the namespaceLocationOrganizationID to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID)
	return o
}

// SetNamespaceLocationOrganizationID adds the namespaceLocationOrganizationId to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetNamespaceLocationOrganizationID(namespaceLocationOrganizationID *string) {
	o.NamespaceLocationOrganizationID = namespaceLocationOrganizationID
}

// WithNamespaceLocationProjectID adds the namespaceLocationProjectID to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithNamespaceLocationProjectID(namespaceLocationProjectID *string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetNamespaceLocationProjectID(namespaceLocationProjectID)
	return o
}

// SetNamespaceLocationProjectID adds the namespaceLocationProjectId to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetNamespaceLocationProjectID(namespaceLocationProjectID *string) {
	o.NamespaceLocationProjectID = namespaceLocationProjectID
}

// WithNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider)
	return o
}

// SetNamespaceLocationRegionProvider adds the namespaceLocationRegionProvider to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetNamespaceLocationRegionProvider(namespaceLocationRegionProvider *string) {
	o.NamespaceLocationRegionProvider = namespaceLocationRegionProvider
}

// WithNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) WithNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) *WaypointServiceDeleteAddOnDefinitionParams {
	o.SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion)
	return o
}

// SetNamespaceLocationRegionRegion adds the namespaceLocationRegionRegion to the waypoint service delete add on definition params
func (o *WaypointServiceDeleteAddOnDefinitionParams) SetNamespaceLocationRegionRegion(namespaceLocationRegionRegion *string) {
	o.NamespaceLocationRegionRegion = namespaceLocationRegionRegion
}

// WriteToRequest writes these params to a swagger request
func (o *WaypointServiceDeleteAddOnDefinitionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param add_on_definition.id
	if err := r.SetPathParam("add_on_definition.id", o.AddOnDefinitionID); err != nil {
		return err
	}

	if o.AddOnDefinitionName != nil {

		// query param add_on_definition.name
		var qrAddOnDefinitionName string

		if o.AddOnDefinitionName != nil {
			qrAddOnDefinitionName = *o.AddOnDefinitionName
		}
		qAddOnDefinitionName := qrAddOnDefinitionName
		if qAddOnDefinitionName != "" {

			if err := r.SetQueryParam("add_on_definition.name", qAddOnDefinitionName); err != nil {
				return err
			}
		}
	}

	// path param namespace.id
	if err := r.SetPathParam("namespace.id", o.NamespaceID); err != nil {
		return err
	}

	if o.NamespaceLocationOrganizationID != nil {

		// query param namespace.location.organization_id
		var qrNamespaceLocationOrganizationID string

		if o.NamespaceLocationOrganizationID != nil {
			qrNamespaceLocationOrganizationID = *o.NamespaceLocationOrganizationID
		}
		qNamespaceLocationOrganizationID := qrNamespaceLocationOrganizationID
		if qNamespaceLocationOrganizationID != "" {

			if err := r.SetQueryParam("namespace.location.organization_id", qNamespaceLocationOrganizationID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationProjectID != nil {

		// query param namespace.location.project_id
		var qrNamespaceLocationProjectID string

		if o.NamespaceLocationProjectID != nil {
			qrNamespaceLocationProjectID = *o.NamespaceLocationProjectID
		}
		qNamespaceLocationProjectID := qrNamespaceLocationProjectID
		if qNamespaceLocationProjectID != "" {

			if err := r.SetQueryParam("namespace.location.project_id", qNamespaceLocationProjectID); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionProvider != nil {

		// query param namespace.location.region.provider
		var qrNamespaceLocationRegionProvider string

		if o.NamespaceLocationRegionProvider != nil {
			qrNamespaceLocationRegionProvider = *o.NamespaceLocationRegionProvider
		}
		qNamespaceLocationRegionProvider := qrNamespaceLocationRegionProvider
		if qNamespaceLocationRegionProvider != "" {

			if err := r.SetQueryParam("namespace.location.region.provider", qNamespaceLocationRegionProvider); err != nil {
				return err
			}
		}
	}

	if o.NamespaceLocationRegionRegion != nil {

		// query param namespace.location.region.region
		var qrNamespaceLocationRegionRegion string

		if o.NamespaceLocationRegionRegion != nil {
			qrNamespaceLocationRegionRegion = *o.NamespaceLocationRegionRegion
		}
		qNamespaceLocationRegionRegion := qrNamespaceLocationRegionRegion
		if qNamespaceLocationRegionRegion != "" {

			if err := r.SetQueryParam("namespace.location.region.region", qNamespaceLocationRegionRegion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
