// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2023-08-18/models"
)

// WaypointServiceGetApplicationTemplate4Reader is a Reader for the WaypointServiceGetApplicationTemplate4 structure.
type WaypointServiceGetApplicationTemplate4Reader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceGetApplicationTemplate4Reader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceGetApplicationTemplate4OK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceGetApplicationTemplate4Default(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceGetApplicationTemplate4OK creates a WaypointServiceGetApplicationTemplate4OK with default headers values
func NewWaypointServiceGetApplicationTemplate4OK() *WaypointServiceGetApplicationTemplate4OK {
	return &WaypointServiceGetApplicationTemplate4OK{}
}

/*
WaypointServiceGetApplicationTemplate4OK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceGetApplicationTemplate4OK struct {
	Payload *models.HashicorpCloudWaypointGetApplicationTemplateResponse
}

// IsSuccess returns true when this waypoint service get application template4 o k response has a 2xx status code
func (o *WaypointServiceGetApplicationTemplate4OK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service get application template4 o k response has a 3xx status code
func (o *WaypointServiceGetApplicationTemplate4OK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service get application template4 o k response has a 4xx status code
func (o *WaypointServiceGetApplicationTemplate4OK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service get application template4 o k response has a 5xx status code
func (o *WaypointServiceGetApplicationTemplate4OK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service get application template4 o k response a status code equal to that given
func (o *WaypointServiceGetApplicationTemplate4OK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service get application template4 o k response
func (o *WaypointServiceGetApplicationTemplate4OK) Code() int {
	return 200
}

func (o *WaypointServiceGetApplicationTemplate4OK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}][%d] waypointServiceGetApplicationTemplate4OK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationTemplate4OK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}][%d] waypointServiceGetApplicationTemplate4OK %s", 200, payload)
}

func (o *WaypointServiceGetApplicationTemplate4OK) GetPayload() *models.HashicorpCloudWaypointGetApplicationTemplateResponse {
	return o.Payload
}

func (o *WaypointServiceGetApplicationTemplate4OK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.HashicorpCloudWaypointGetApplicationTemplateResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceGetApplicationTemplate4Default creates a WaypointServiceGetApplicationTemplate4Default with default headers values
func NewWaypointServiceGetApplicationTemplate4Default(code int) *WaypointServiceGetApplicationTemplate4Default {
	return &WaypointServiceGetApplicationTemplate4Default{
		_statusCode: code,
	}
}

/*
WaypointServiceGetApplicationTemplate4Default describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceGetApplicationTemplate4Default struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service get application template4 default response has a 2xx status code
func (o *WaypointServiceGetApplicationTemplate4Default) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service get application template4 default response has a 3xx status code
func (o *WaypointServiceGetApplicationTemplate4Default) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service get application template4 default response has a 4xx status code
func (o *WaypointServiceGetApplicationTemplate4Default) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service get application template4 default response has a 5xx status code
func (o *WaypointServiceGetApplicationTemplate4Default) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service get application template4 default response a status code equal to that given
func (o *WaypointServiceGetApplicationTemplate4Default) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service get application template4 default response
func (o *WaypointServiceGetApplicationTemplate4Default) Code() int {
	return o._statusCode
}

func (o *WaypointServiceGetApplicationTemplate4Default) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}][%d] WaypointService_GetApplicationTemplate4 default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationTemplate4Default) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /waypoint/2023-08-18/namespace/{namespace.id}/templates/by-name/{application_template.name}][%d] WaypointService_GetApplicationTemplate4 default %s", o._statusCode, payload)
}

func (o *WaypointServiceGetApplicationTemplate4Default) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceGetApplicationTemplate4Default) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
