// Code generated by go-swagger; DO NOT EDIT.

package waypoint_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	cloud "github.com/hashicorp/hcp-sdk-go/clients/cloud-shared/v1/models"
	"github.com/hashicorp/hcp-sdk-go/clients/cloud-waypoint-service/preview/2024-11-22/models"
)

// WaypointServiceDeleteAddOnDefinitionReader is a Reader for the WaypointServiceDeleteAddOnDefinition structure.
type WaypointServiceDeleteAddOnDefinitionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *WaypointServiceDeleteAddOnDefinitionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewWaypointServiceDeleteAddOnDefinitionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewWaypointServiceDeleteAddOnDefinitionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewWaypointServiceDeleteAddOnDefinitionOK creates a WaypointServiceDeleteAddOnDefinitionOK with default headers values
func NewWaypointServiceDeleteAddOnDefinitionOK() *WaypointServiceDeleteAddOnDefinitionOK {
	return &WaypointServiceDeleteAddOnDefinitionOK{}
}

/*
WaypointServiceDeleteAddOnDefinitionOK describes a response with status code 200, with default header values.

A successful response.
*/
type WaypointServiceDeleteAddOnDefinitionOK struct {
	Payload models.HashicorpCloudWaypointDeleteAddOnDefinitionResponse
}

// IsSuccess returns true when this waypoint service delete add on definition o k response has a 2xx status code
func (o *WaypointServiceDeleteAddOnDefinitionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this waypoint service delete add on definition o k response has a 3xx status code
func (o *WaypointServiceDeleteAddOnDefinitionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this waypoint service delete add on definition o k response has a 4xx status code
func (o *WaypointServiceDeleteAddOnDefinitionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this waypoint service delete add on definition o k response has a 5xx status code
func (o *WaypointServiceDeleteAddOnDefinitionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this waypoint service delete add on definition o k response a status code equal to that given
func (o *WaypointServiceDeleteAddOnDefinitionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the waypoint service delete add on definition o k response
func (o *WaypointServiceDeleteAddOnDefinitionOK) Code() int {
	return 200
}

func (o *WaypointServiceDeleteAddOnDefinitionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition/{add_on_definition.id}][%d] waypointServiceDeleteAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceDeleteAddOnDefinitionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition/{add_on_definition.id}][%d] waypointServiceDeleteAddOnDefinitionOK %s", 200, payload)
}

func (o *WaypointServiceDeleteAddOnDefinitionOK) GetPayload() models.HashicorpCloudWaypointDeleteAddOnDefinitionResponse {
	return o.Payload
}

func (o *WaypointServiceDeleteAddOnDefinitionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// response payload
	if err := consumer.Consume(response.Body(), &o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewWaypointServiceDeleteAddOnDefinitionDefault creates a WaypointServiceDeleteAddOnDefinitionDefault with default headers values
func NewWaypointServiceDeleteAddOnDefinitionDefault(code int) *WaypointServiceDeleteAddOnDefinitionDefault {
	return &WaypointServiceDeleteAddOnDefinitionDefault{
		_statusCode: code,
	}
}

/*
WaypointServiceDeleteAddOnDefinitionDefault describes a response with status code -1, with default header values.

An unexpected error response.
*/
type WaypointServiceDeleteAddOnDefinitionDefault struct {
	_statusCode int

	Payload *cloud.GoogleRPCStatus
}

// IsSuccess returns true when this waypoint service delete add on definition default response has a 2xx status code
func (o *WaypointServiceDeleteAddOnDefinitionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this waypoint service delete add on definition default response has a 3xx status code
func (o *WaypointServiceDeleteAddOnDefinitionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this waypoint service delete add on definition default response has a 4xx status code
func (o *WaypointServiceDeleteAddOnDefinitionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this waypoint service delete add on definition default response has a 5xx status code
func (o *WaypointServiceDeleteAddOnDefinitionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this waypoint service delete add on definition default response a status code equal to that given
func (o *WaypointServiceDeleteAddOnDefinitionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the waypoint service delete add on definition default response
func (o *WaypointServiceDeleteAddOnDefinitionDefault) Code() int {
	return o._statusCode
}

func (o *WaypointServiceDeleteAddOnDefinitionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition/{add_on_definition.id}][%d] WaypointService_DeleteAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteAddOnDefinitionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /waypoint/2024-11-22/organizations/{namespace.location.organization_id}/projects/{namespace.location.project_id}/add-on-definition/{add_on_definition.id}][%d] WaypointService_DeleteAddOnDefinition default %s", o._statusCode, payload)
}

func (o *WaypointServiceDeleteAddOnDefinitionDefault) GetPayload() *cloud.GoogleRPCStatus {
	return o.Payload
}

func (o *WaypointServiceDeleteAddOnDefinitionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(cloud.GoogleRPCStatus)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
