// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"
)

// HashicorpCloudWaypointAddOnDefinition AddOnDefinition is the template for an add-on
//
// swagger:model hashicorp.cloud.waypoint.AddOnDefinition
type HashicorpCloudWaypointAddOnDefinition struct {

	// Longer description of the Add-on
	Description string `json:"description,omitempty"`

	// Unique identifier of the Add-on definition
	// Read Only: true
	ID string `json:"id,omitempty"`

	// A list of descriptive labels for an Add-on
	Labels []string `json:"labels"`

	// module_id is the ID of the template's Terraform module. Clients are
	// expected to set this field when creating a new application template.
	ModuleID string `json:"module_id,omitempty"`

	// module_source is where to find the source code for the desired child module.
	ModuleSource string `json:"module_source,omitempty"`

	// Name of the Add-on definition
	Name string `json:"name,omitempty"`

	// A templated README describing the Add-on
	// Format: byte
	ReadmeMarkdownTemplate strfmt.Base64 `json:"readme_markdown_template,omitempty"`

	// readme_template is markdown formatted instructions on how to operate the application.
	// This may be populated from a application template.
	// This field is favored over readme_markdown_template and support for both is transitional.
	ReadmeTemplate string `json:"readme_template,omitempty"`

	// Short description of the Add-on
	Summary string `json:"summary,omitempty"`

	// kv tags
	Tags []*HashicorpCloudWaypointTag `json:"tags"`

	// The TF project
	TerraformCloudWorkspaceDetails *HashicorpCloudWaypointTerraformCloudWorkspaceDetails `json:"terraform_cloud_workspace_details,omitempty"`

	// tf_agent_pool_id is the ID of the agent pool to use for the Terraform
	// workspace if 'agent' is used for 'tf_execution_mode'.
	TfAgentPoolID string `json:"tf_agent_pool_id,omitempty"`

	// tf_execution_mode is the mode in which the Terraform backed workspace should
	// operate in. Defaults to 'remote'.
	TfExecutionMode string `json:"tf_execution_mode,omitempty"`

	// variable_options is the collection of input variables which may be set for a template.
	VariableOptions []*HashicorpCloudWaypointTFModuleVariable `json:"variable_options"`

	// variable_options_out_of_sync is a boolean value that indicates whether the variable_options
	// are out of sync with the Terraform no-code module, published in Terraform Cloud.
	// This is used to determine whether the variable_options should be updated.
	// API client should not set this value.
	// Read Only: true
	VariableOptionsOutOfSync *bool `json:"variable_options_out_of_sync,omitempty"`
}

// Validate validates this hashicorp cloud waypoint add on definition
func (m *HashicorpCloudWaypointAddOnDefinition) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateTags(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateTerraformCloudWorkspaceDetails(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateVariableOptions(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) validateTags(formats strfmt.Registry) error {
	if swag.IsZero(m.Tags) { // not required
		return nil
	}

	for i := 0; i < len(m.Tags); i++ {
		if swag.IsZero(m.Tags[i]) { // not required
			continue
		}

		if m.Tags[i] != nil {
			if err := m.Tags[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tags" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) validateTerraformCloudWorkspaceDetails(formats strfmt.Registry) error {
	if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
		return nil
	}

	if m.TerraformCloudWorkspaceDetails != nil {
		if err := m.TerraformCloudWorkspaceDetails.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) validateVariableOptions(formats strfmt.Registry) error {
	if swag.IsZero(m.VariableOptions) { // not required
		return nil
	}

	for i := 0; i < len(m.VariableOptions); i++ {
		if swag.IsZero(m.VariableOptions[i]) { // not required
			continue
		}

		if m.VariableOptions[i] != nil {
			if err := m.VariableOptions[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this hashicorp cloud waypoint add on definition based on the context it is used
func (m *HashicorpCloudWaypointAddOnDefinition) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTags(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateTerraformCloudWorkspaceDetails(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOptions(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateVariableOptionsOutOfSync(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "id", "body", string(m.ID)); err != nil {
		return err
	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) contextValidateTags(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.Tags); i++ {

		if m.Tags[i] != nil {

			if swag.IsZero(m.Tags[i]) { // not required
				return nil
			}

			if err := m.Tags[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("tags" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("tags" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) contextValidateTerraformCloudWorkspaceDetails(ctx context.Context, formats strfmt.Registry) error {

	if m.TerraformCloudWorkspaceDetails != nil {

		if swag.IsZero(m.TerraformCloudWorkspaceDetails) { // not required
			return nil
		}

		if err := m.TerraformCloudWorkspaceDetails.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("terraform_cloud_workspace_details")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("terraform_cloud_workspace_details")
			}
			return err
		}
	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) contextValidateVariableOptions(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(m.VariableOptions); i++ {

		if m.VariableOptions[i] != nil {

			if swag.IsZero(m.VariableOptions[i]) { // not required
				return nil
			}

			if err := m.VariableOptions[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("variable_options" + "." + strconv.Itoa(i))
				} else if ce, ok := err.(*errors.CompositeError); ok {
					return ce.ValidateName("variable_options" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (m *HashicorpCloudWaypointAddOnDefinition) contextValidateVariableOptionsOutOfSync(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "variable_options_out_of_sync", "body", m.VariableOptionsOutOfSync); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (m *HashicorpCloudWaypointAddOnDefinition) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *HashicorpCloudWaypointAddOnDefinition) UnmarshalBinary(b []byte) error {
	var res HashicorpCloudWaypointAddOnDefinition
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
