// Code generated by go-swagger; DO NOT EDIT.

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// BillingAccountServiceUpdateBody UpdateBillingAccountRequest is the request to update a Billing Account.
//
// swagger:model BillingAccountServiceUpdateBody
type BillingAccountServiceUpdateBody struct {

	// country is the billing account's country which is used for selecting
	// country-specific prices and for invoicing.
	Country *Billing20201105Country `json:"country,omitempty"`

	// name is the Billing Account's user-defined name.
	Name string `json:"name,omitempty"`

	// on_demand_billing_method configures the on-demand billing method for the
	// billing account. This billing method is expected to be charged with
	// on-demand cost that isn't covered by a contract or through a positive
	// account balance.
	OnDemandBillingMethod *Billing20201105OnDemandBillingMethod `json:"on_demand_billing_method,omitempty"`

	// project_ids is the list of IDs of all projects associated with the Billing
	// Account. Projects can be linked to *at most* one Billing Account.
	ProjectIds []string `json:"project_ids"`
}

// Validate validates this billing account service update body
func (m *BillingAccountServiceUpdateBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateCountry(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateOnDemandBillingMethod(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BillingAccountServiceUpdateBody) validateCountry(formats strfmt.Registry) error {
	if swag.IsZero(m.Country) { // not required
		return nil
	}

	if m.Country != nil {
		if err := m.Country.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("country")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("country")
			}
			return err
		}
	}

	return nil
}

func (m *BillingAccountServiceUpdateBody) validateOnDemandBillingMethod(formats strfmt.Registry) error {
	if swag.IsZero(m.OnDemandBillingMethod) { // not required
		return nil
	}

	if m.OnDemandBillingMethod != nil {
		if err := m.OnDemandBillingMethod.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("on_demand_billing_method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("on_demand_billing_method")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this billing account service update body based on the context it is used
func (m *BillingAccountServiceUpdateBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateCountry(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateOnDemandBillingMethod(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *BillingAccountServiceUpdateBody) contextValidateCountry(ctx context.Context, formats strfmt.Registry) error {

	if m.Country != nil {

		if swag.IsZero(m.Country) { // not required
			return nil
		}

		if err := m.Country.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("country")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("country")
			}
			return err
		}
	}

	return nil
}

func (m *BillingAccountServiceUpdateBody) contextValidateOnDemandBillingMethod(ctx context.Context, formats strfmt.Registry) error {

	if m.OnDemandBillingMethod != nil {

		if swag.IsZero(m.OnDemandBillingMethod) { // not required
			return nil
		}

		if err := m.OnDemandBillingMethod.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("on_demand_billing_method")
			} else if ce, ok := err.(*errors.CompositeError); ok {
				return ce.ValidateName("on_demand_billing_method")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *BillingAccountServiceUpdateBody) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *BillingAccountServiceUpdateBody) UnmarshalBinary(b []byte) error {
	var res BillingAccountServiceUpdateBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
