// Code generated by go-swagger; DO NOT EDIT.

package nodes

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetNodeParams creates a new GetNodeParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetNodeParams() *GetNodeParams {
	return &GetNodeParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetNodeParamsWithTimeout creates a new GetNodeParams object
// with the ability to set a timeout on a request.
func NewGetNodeParamsWithTimeout(timeout time.Duration) *GetNodeParams {
	return &GetNodeParams{
		timeout: timeout,
	}
}

// NewGetNodeParamsWithContext creates a new GetNodeParams object
// with the ability to set a context for a request.
func NewGetNodeParamsWithContext(ctx context.Context) *GetNodeParams {
	return &GetNodeParams{
		Context: ctx,
	}
}

// NewGetNodeParamsWithHTTPClient creates a new GetNodeParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetNodeParamsWithHTTPClient(client *http.Client) *GetNodeParams {
	return &GetNodeParams{
		HTTPClient: client,
	}
}

/*
GetNodeParams contains all the parameters to send to the API endpoint

	for the get node operation.

	Typically these are written to a http.Request.
*/
type GetNodeParams struct {

	/* NodeName.

	   Node name of which details is required
	*/
	NodeName string

	/* ParentResourceName.

	   Parent resource name will be of the form `consul/project/<project_id>/cluster/<cluster_id>`
	*/
	ParentResourceName string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get node params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetNodeParams) WithDefaults() *GetNodeParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get node params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetNodeParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get node params
func (o *GetNodeParams) WithTimeout(timeout time.Duration) *GetNodeParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get node params
func (o *GetNodeParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get node params
func (o *GetNodeParams) WithContext(ctx context.Context) *GetNodeParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get node params
func (o *GetNodeParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get node params
func (o *GetNodeParams) WithHTTPClient(client *http.Client) *GetNodeParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get node params
func (o *GetNodeParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithNodeName adds the nodeName to the get node params
func (o *GetNodeParams) WithNodeName(nodeName string) *GetNodeParams {
	o.SetNodeName(nodeName)
	return o
}

// SetNodeName adds the nodeName to the get node params
func (o *GetNodeParams) SetNodeName(nodeName string) {
	o.NodeName = nodeName
}

// WithParentResourceName adds the parentResourceName to the get node params
func (o *GetNodeParams) WithParentResourceName(parentResourceName string) *GetNodeParams {
	o.SetParentResourceName(parentResourceName)
	return o
}

// SetParentResourceName adds the parentResourceName to the get node params
func (o *GetNodeParams) SetParentResourceName(parentResourceName string) {
	o.ParentResourceName = parentResourceName
}

// WriteToRequest writes these params to a swagger request
func (o *GetNodeParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param node_name
	if err := r.SetPathParam("node_name", o.NodeName); err != nil {
		return err
	}

	// path param parent_resource_name
	if err := r.SetPathParam("parent_resource_name", o.ParentResourceName); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
